/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.renderer;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.g;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class TXCYuvTextureRender {
    private static final String TAG = TXCYuvTextureRender.class.getSimpleName();
    private static final String mVertexShaderCode = "uniform mat4 uMatrix;uniform mat4 uTextureMatrix;attribute vec2 position;attribute vec2 inputTextureCoordinate;varying vec2 textureCoordinate;void main() {vec4 pos  = vec4(position, 0.0, 1.0);gl_Position = uMatrix * pos;textureCoordinate = (uTextureMatrix*vec4(inputTextureCoordinate, 0.0, 0.0)).xy;}";
    private static final String mFragmentShaderCode = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform sampler2D yTexture;\nuniform sampler2D uTexture;\nuniform mat3 convertMatrix;\nuniform vec3 offset;\n\nvoid main()\n{\n    highp vec3 yuvColor;\n    highp vec3 rgbColor;\n\n    // Get the YUV values\n    yuvColor.x = texture2D(yTexture, textureCoordinate).r;\n    yuvColor.y = texture2D(uTexture, vec2(textureCoordinate.x * 0.5, textureCoordinate.y * 0.5)).r;\n    yuvColor.z = texture2D(uTexture, vec2(textureCoordinate.x * 0.5, textureCoordinate.y * 0.5 + 0.5)).r;\n\n    // Do the color transform   \n    yuvColor += offset;\n    rgbColor = convertMatrix * yuvColor; \n\n    gl_FragColor = vec4(rgbColor, 1.0);\n}\n";
    private static final int BYTES_PER_FLOAT = 4;
    private static final int POSITION_COMPONENT_COUNT = 2;
    private static final int TEXTURE_COORDINATES_COMPONENT_COUNT = 2;
    private float[] mVerticesCoordinates;
    private short[] mIndices;
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mTextureBuffer;
    private ShortBuffer mIndicesBuffer;
    private float[] mMVPMatrix = new float[16];
    private float[] mTextureMatrix = new float[16];
    private int[] mTextureIds;
    private int mProgram;
    private int mVertexMatrixHandle;
    private int mTextureMatrixHandle;
    private int mPositionHandle;
    private int mTextureCoordinatesHandle;
    private int mTextureUnitHandle0;
    private int mTextureUnitHandle1;
    private int mConvertMatrixUniform = -1;
    private int mConvertOffsetUniform = -1;
    private boolean mNeedReLoadFrameBuffer = false;
    private int mHeight;
    private int mWidth;
    private static final int INVALID_TEXTURE_ID = -12345;
    private int mFrameBufferTextureID = -12345;
    private int mFrameBufferID = -12345;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private final int def_InputType_YUVJ420 = 4;
    private int mRawDataFrameType = -1;
    private float[] mbt601_fullRange_matrix3 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.343f, 1.765f, 1.4f, -0.711f, 0.0f};
    private float[] mbt601_videoRange_matrix3 = new float[]{1.164f, 1.164f, 1.164f, 0.0f, -0.392f, 2.017f, 1.596f, -0.813f, 0.0f};
    private float[] mbt601_offset_matrix = new float[]{0.0f, -0.5f, -0.5f};
    private float[] mbt709_videoRange_matrix3 = new float[]{1.164f, 1.164f, 1.164f, 0.0f, -0.213f, 2.112f, 1.793f, -0.533f, 0.0f};
    float[] bt601_videorange_ffmpeg_offset = new float[]{-0.0627451f, -0.5019608f, -0.5019608f};
    float[] bt601_videorage_ffmpeg_matrix = new float[]{1.1644f, 1.1644f, 1.1644f, 0.0f, -0.3918f, 2.0172f, 1.596f, -0.813f, 0.0f};
    float[] bt601_fullrange_ffmpeg_offset = new float[]{0.0f, -0.5019608f, -0.5019608f};
    float[] bt601_fullrage_ffmpeg_matrix = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.3441f, 1.772f, 1.402f, -0.7141f, 0.0f};

    public TXCYuvTextureRender() {
        float[] fArray = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.mIndices = new short[]{0, 1, 2, 1, 3, 2};
        this.mVerticesCoordinates = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        this.mTextureBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTextureBuffer.put(fArray);
        this.mTextureBuffer.position(0);
        this.mVertexBuffer = ByteBuffer.allocateDirect(this.mVerticesCoordinates.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mVertexBuffer.put(this.mVerticesCoordinates);
        this.mVertexBuffer.position(0);
        this.mIndicesBuffer = ByteBuffer.allocateDirect(this.mIndices.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.mIndicesBuffer.put(this.mIndices);
        this.mIndicesBuffer.position(0);
    }

    public void setVideoSize(int n2, int n3) {
        this.mVideoWidth = n2;
        this.mVideoHeight = n3;
    }

    public void createTexture() {
        int n2 = GLES20.glCreateShader((int)35633);
        this.checkError();
        GLES20.glShaderSource((int)n2, (String)mVertexShaderCode);
        this.checkError();
        GLES20.glCompileShader((int)n2);
        this.checkError();
        int n3 = GLES20.glCreateShader((int)35632);
        this.checkError();
        GLES20.glShaderSource((int)n3, (String)mFragmentShaderCode);
        this.checkError();
        GLES20.glCompileShader((int)n3);
        this.mProgram = GLES20.glCreateProgram();
        this.checkError();
        GLES20.glAttachShader((int)this.mProgram, (int)n2);
        this.checkError();
        GLES20.glAttachShader((int)this.mProgram, (int)n3);
        this.checkError();
        GLES20.glLinkProgram((int)this.mProgram);
        this.checkError();
        GLES20.glDeleteShader((int)n2);
        GLES20.glDeleteShader((int)n3);
        this.mVertexMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMatrix");
        this.checkError();
        this.mTextureMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTextureMatrix");
        this.checkError();
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"position");
        this.checkError();
        this.mTextureCoordinatesHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"inputTextureCoordinate");
        this.checkError();
        this.mTextureUnitHandle0 = GLES20.glGetUniformLocation((int)this.mProgram, (String)"yTexture");
        this.checkError();
        this.mTextureUnitHandle1 = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTexture");
        this.checkError();
        this.mConvertOffsetUniform = GLES20.glGetUniformLocation((int)this.mProgram, (String)"offset");
        GLES20.glUniform3fv((int)this.mConvertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.bt601_fullrange_ffmpeg_offset));
        this.mConvertMatrixUniform = GLES20.glGetUniformLocation((int)this.mProgram, (String)"convertMatrix");
        GLES20.glUniformMatrix3fv((int)this.mConvertMatrixUniform, (int)1, (boolean)false, (float[])this.bt601_fullrage_ffmpeg_matrix, (int)0);
        this.mTextureIds = new int[2];
        GLES20.glGenTextures((int)2, (int[])this.mTextureIds, (int)0);
    }

    public void onSurfaceDestroy() {
        if (this.mTextureIds != null) {
            GLES20.glDeleteTextures((int)2, (int[])this.mTextureIds, (int)0);
            this.mTextureIds = null;
        }
        this.destroyFrameBuffer();
        GLES20.glDeleteProgram((int)this.mProgram);
    }

    public void setHasFrameBuffer(int n2, int n3) {
        if (this.mWidth == n2 && this.mHeight == n3) {
            return;
        }
        this.mWidth = n2;
        this.mHeight = n3;
        this.mNeedReLoadFrameBuffer = true;
    }

    public void flipVertical(boolean bl) {
        float[] fArray = null;
        fArray = bl ? new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f} : new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        this.mTextureBuffer = ByteBuffer.allocateDirect(fArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTextureBuffer.put(fArray);
        this.mTextureBuffer.position(0);
    }

    private void reloadFrameBuffer() {
        if (!this.mNeedReLoadFrameBuffer) {
            return;
        }
        TXCLog.i(TAG, "reloadFrameBuffer. size = " + this.mWidth + "*" + this.mHeight);
        this.destroyFrameBuffer();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GLES20.glGenTextures((int)1, (int[])nArray, (int)0);
        GLES20.glGenFramebuffers((int)1, (int[])nArray2, (int)0);
        this.mFrameBufferTextureID = nArray[0];
        this.mFrameBufferID = nArray2[0];
        TXCLog.d(TAG, "frameBuffer id = " + this.mFrameBufferID + ", texture id = " + this.mFrameBufferTextureID);
        GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextureID);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mWidth, (int)this.mHeight, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferID);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextureID, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        this.mNeedReLoadFrameBuffer = false;
    }

    private void destroyFrameBuffer() {
        int[] nArray;
        if (this.mFrameBufferID != -12345) {
            nArray = new int[]{this.mFrameBufferID};
            GLES20.glDeleteFramebuffers((int)1, (int[])nArray, (int)0);
            this.mFrameBufferID = -12345;
        }
        if (this.mFrameBufferTextureID != -12345) {
            nArray = new int[]{this.mFrameBufferTextureID};
            GLES20.glDeleteTextures((int)1, (int[])nArray, (int)0);
            this.mFrameBufferTextureID = -12345;
        }
    }

    public int drawToTexture(TXSVideoFrame tXSVideoFrame) {
        this.reloadFrameBuffer();
        if (this.mFrameBufferID == -12345) {
            TXCLog.w(TAG, "invalid frame buffer id");
            return -12345;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferID);
        GLES20.glViewport((int)0, (int)0, (int)this.mWidth, (int)this.mHeight);
        this.drawFrame(tXSVideoFrame);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.mFrameBufferTextureID;
    }

    public void drawFrame(TXSVideoFrame tXSVideoFrame) {
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mTextureMatrix, (int)0);
        GLES20.glUseProgram((int)this.mProgram);
        this.checkError();
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        this.checkError();
        this.mVertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mVertexBuffer);
        this.checkError();
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordinatesHandle);
        this.checkError();
        this.mTextureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordinatesHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mTextureBuffer);
        this.checkError();
        GLES20.glUniformMatrix4fv((int)this.mVertexMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        this.checkError();
        GLES20.glUniformMatrix4fv((int)this.mTextureMatrixHandle, (int)1, (boolean)false, (float[])this.mTextureMatrix, (int)0);
        this.checkError();
        int n2 = tXSVideoFrame.frameType;
        if (4 == n2) {
            GLES20.glUniform3fv((int)this.mConvertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.bt601_fullrange_ffmpeg_offset));
            GLES20.glUniformMatrix3fv((int)this.mConvertMatrixUniform, (int)1, (boolean)false, (float[])this.bt601_fullrage_ffmpeg_matrix, (int)0);
            if (n2 != this.mRawDataFrameType) {
                this.mRawDataFrameType = n2;
                TXCLog.i(TAG, " frame type " + n2 + " matrix_test fullRange");
            }
        } else {
            GLES20.glUniform3fv((int)this.mConvertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.bt601_videorange_ffmpeg_offset));
            GLES20.glUniformMatrix3fv((int)this.mConvertMatrixUniform, (int)1, (boolean)false, (float[])this.bt601_videorage_ffmpeg_matrix, (int)0);
            if (n2 != this.mRawDataFrameType) {
                this.mRawDataFrameType = n2;
                TXCLog.i(TAG, " frame type " + n2 + " matrix_test videoRange");
            }
        }
        GLES20.glUniform1i((int)this.mTextureUnitHandle0, (int)0);
        this.checkError();
        GLES20.glUniform1i((int)this.mTextureUnitHandle1, (int)1);
        this.checkError();
        if (tXSVideoFrame.buffer != null && this.mTextureIds != null) {
            TXCYuvTextureRender.nativeLoadTexture(tXSVideoFrame.buffer, tXSVideoFrame.width, tXSVideoFrame.height, this.mTextureIds);
        }
        tXSVideoFrame.release();
        GLES20.glDrawElements((int)4, (int)this.mIndices.length, (int)5123, (Buffer)this.mIndicesBuffer);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glDisableVertexAttribArray((int)this.mTextureCoordinatesHandle);
    }

    public int checkError() {
        int n2 = GLES20.glGetError();
        if (n2 != 0) {
            throw new IllegalStateException("gl error=" + n2);
        }
        return n2;
    }

    public static native void nativeLoadTexture(ByteBuffer var0, int var1, int var2, int[] var3);

    static {
        g.f();
    }
}

