/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.qos;

import android.os.Bundle;
import android.os.Handler;
import com.tencent.liteav.basic.b.c;
import com.tencent.liteav.basic.c.b;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.g;
import com.tencent.liteav.qos.a;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TXCQoS {
    static final String TAG = "TXCQos";
    public static final int AUTO_ADJUST_LIVEPUSH_RESOLUTION_STRATEGY = 1;
    public static final int AUTO_ADJUST_REALTIME_VIDEOCHAT_STRATEGY = 5;
    private static final Map<Integer, c> RESOLUTION_MAP;
    private long mInterval = 1000L;
    private String mUserID = "";
    private boolean mIsEnableDrop = false;
    private int mBitrate = 0;
    private int mWidth = 0;
    private int mHeight = 0;
    private int mAutoStrategy = -1;
    private Handler mHandler = new Handler();
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            if (TXCQoS.this.mListener != null) {
                int n2 = TXCQoS.this.mListener.onGetEncoderRealBitrate();
                int n3 = TXCQoS.this.mListener.onGetQueueInputSize();
                int n4 = TXCQoS.this.mListener.onGetQueueOutputSize();
                int n5 = TXCQoS.this.mListener.onGetVideoQueueMaxCount();
                int n6 = TXCQoS.this.mListener.onGetVideoQueueCurrentCount();
                int n7 = TXCQoS.this.mListener.onGetVideoDropCount();
                int n8 = TXCQoS.this.mListener.onGetBandwidthEst();
                TXCQoS.this.nativeSetVideoRealBitrate(TXCQoS.this.mInstance, n2);
                TXCQoS.this.nativeAdjustBitrate(TXCQoS.this.mInstance, n5, n6, n7, n4, n3, n8);
                boolean bl = TXCQoS.this.nativeIsEnableDrop(TXCQoS.this.mInstance);
                if (TXCQoS.this.mIsEnableDrop != bl) {
                    TXCQoS.this.mIsEnableDrop = bl;
                    TXCQoS.this.mListener.onEnableDropStatusChanged(bl);
                }
                int n9 = TXCQoS.this.nativeGetBitrate(TXCQoS.this.mInstance);
                int n10 = TXCQoS.this.nativeGetWidth(TXCQoS.this.mInstance);
                int n11 = TXCQoS.this.nativeGetHeight(TXCQoS.this.mInstance);
                if (n10 != TXCQoS.this.mWidth || n11 != TXCQoS.this.mHeight) {
                    if (TXCQoS.this.mAutoStrategy == 1 || TXCQoS.this.mAutoStrategy == 5) {
                        TXCQoS.this.mListener.onEncoderParamsChanged(n9, n10, n11);
                        if (TXCQoS.this.mNotifyListener != null) {
                            Bundle bundle = new Bundle();
                            bundle.putCharSequence("EVT_MSG", (CharSequence)("Adjust resolution:new bitrate:" + n9 + " new resolution:" + n10 + "*" + n11));
                            bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                            TXCQoS.this.mNotifyListener.onNotifyEvent(1005, bundle);
                        }
                    }
                } else if (n9 != TXCQoS.this.mBitrate) {
                    TXCQoS.this.mListener.onEncoderParamsChanged(n9, 0, 0);
                    if (TXCQoS.this.mNotifyListener != null) {
                        Bundle bundle = new Bundle();
                        bundle.putCharSequence("EVT_MSG", (CharSequence)("Adjust encoding bitrate:new bitrate:" + n9));
                        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                        bundle.putString("EVT_USERID", TXCQoS.this.mUserID);
                        TXCQoS.this.mNotifyListener.onNotifyEvent(1006, bundle);
                    }
                }
                TXCQoS.this.mBitrate = n9;
                TXCQoS.this.mWidth = n10;
                TXCQoS.this.mHeight = n11;
            }
            TXCQoS.this.mHandler.postDelayed((Runnable)this, TXCQoS.this.mInterval);
        }
    };
    private long mInstance;
    private a mListener;
    private b mNotifyListener;

    public TXCQoS(boolean bl) {
        this.mInstance = this.nativeInit(bl);
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDeinit(this.mInstance);
        }
        finally {
            super.finalize();
        }
    }

    public void start(long l2) {
        this.mInterval = l2;
        this.mHandler.postDelayed(this.mRunnable, this.mInterval);
    }

    public void stop() {
        this.mHandler.removeCallbacks(this.mRunnable);
        this.mAutoStrategy = -1;
    }

    public String getUserID() {
        return this.mUserID;
    }

    public void setUserID(String string) {
        this.mUserID = string;
    }

    public void setNotifyListener(b b2) {
        this.mNotifyListener = b2;
    }

    public void setListener(a a2) {
        this.mListener = a2;
    }

    public void reset(boolean bl) {
        this.nativeReset(this.mInstance, bl);
    }

    public boolean isEnableDrop() {
        return this.nativeIsEnableDrop(this.mInstance);
    }

    public void setHasVideo(boolean bl) {
        this.nativeSetHasVideo(this.mInstance, bl);
    }

    public void setAutoAdjustBitrate(boolean bl) {
        TXCLog.i(TAG, "autoAdjustBitrate is " + (bl ? "yes" : "no"));
        this.nativeSetAutoAdjustBitrate(this.mInstance, bl);
    }

    public void setAutoAdjustStrategy(int n2) {
        TXCLog.i(TAG, "autoAdjustStrategy is " + n2);
        this.nativeSetAutoAdjustStrategy(this.mInstance, n2);
        this.mAutoStrategy = n2;
    }

    public void setDefaultVideoResolution(c c2) {
        TXCLog.i(TAG, "DefaultVideoResolution is " + (Object)((Object)c2));
        this.mWidth = 0;
        this.mHeight = 0;
        int n2 = 0;
        for (Map.Entry<Integer, c> entry : RESOLUTION_MAP.entrySet()) {
            if (entry.getValue() != c2) continue;
            n2 = entry.getKey();
        }
        this.nativeSetVideoDefaultResolution(this.mInstance, n2);
    }

    public void setVideoEncBitrate(int n2, int n3, int n4) {
        this.mBitrate = 0;
        this.nativeSetVideoEncBitrate(this.mInstance, n2, n3, n4);
    }

    public void setVideoExpectBitrate(int n2) {
        this.nativeSetVideoExpectBitrate(this.mInstance, n2);
    }

    public static c getProperResolutionByVideoBitrate(boolean bl, int n2, int n3) {
        int n4 = TXCQoS.nativeGetProperResolutionByVideoBitrate(bl, n2, n3);
        return RESOLUTION_MAP.get(n4);
    }

    private native long nativeInit(boolean var1);

    private native void nativeDeinit(long var1);

    private native void nativeReset(long var1, boolean var3);

    private native boolean nativeIsEnableDrop(long var1);

    private native void nativeSetHasVideo(long var1, boolean var3);

    private native void nativeSetAutoAdjustBitrate(long var1, boolean var3);

    private native void nativeSetAutoAdjustStrategy(long var1, int var3);

    private native void nativeAdjustBitrate(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    private native void nativeSetVideoEncBitrate(long var1, int var3, int var4, int var5);

    private native void nativeSetVideoRealBitrate(long var1, int var3);

    private native void nativeSetVideoExpectBitrate(long var1, int var3);

    private native void nativeSetVideoDefaultResolution(long var1, int var3);

    private native void nativeAddQueueInputSize(long var1, int var3);

    private native void nativeAddQueueOutputSize(long var1, int var3);

    private native int nativeGetBitrate(long var1);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private static native int nativeGetProperResolutionByVideoBitrate(boolean var0, int var1, int var2);

    static {
        HashMap<Integer, c> hashMap = new HashMap<Integer, c>();
        hashMap.put(0, c.b);
        hashMap.put(1, c.c);
        hashMap.put(2, c.d);
        hashMap.put(3, c.e);
        hashMap.put(4, c.f);
        hashMap.put(5, c.g);
        hashMap.put(6, c.h);
        hashMap.put(7, c.i);
        hashMap.put(8, c.j);
        hashMap.put(9, c.k);
        hashMap.put(10, c.l);
        hashMap.put(11, c.m);
        hashMap.put(12, c.n);
        hashMap.put(13, c.o);
        hashMap.put(14, c.p);
        hashMap.put(15, c.q);
        hashMap.put(16, c.r);
        hashMap.put(17, c.s);
        hashMap.put(18, c.t);
        hashMap.put(19, c.u);
        RESOLUTION_MAP = Collections.unmodifiableMap(hashMap);
        g.f();
    }
}

