/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.device;

import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.Monitor;
import com.tencent.liteav.d;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.liteav.i;

public class TXDeviceManagerImpl
implements TXDeviceManager {
    public static final String TAG = "TXDeviceManagerImpl";
    private TXDeviceManagerListener mDeviceManagerListener;
    protected d mCaptureAndEnc;
    protected Handler mSDKHandler;
    private boolean mIsFrontCamera;

    protected void runOnSDKThread(Runnable runnable) {
        if (this.mSDKHandler != null) {
            if (Looper.myLooper() != this.mSDKHandler.getLooper()) {
                this.mSDKHandler.post(runnable);
            } else {
                runnable.run();
            }
        }
    }

    public TXDeviceManagerImpl(Handler handler) {
        this.mSDKHandler = handler;
    }

    public void setCaptureAndEnc(d d2) {
        this.mCaptureAndEnc = d2;
    }

    public void setDeviceManagerListener(TXDeviceManagerListener tXDeviceManagerListener) {
        this.mDeviceManagerListener = tXDeviceManagerListener;
    }

    protected void apiLog(String string) {
        TXCLog.i(TAG, "trtc_api TXDeviceManager:" + string);
    }

    public void setFrontCamera(boolean bl) {
        this.mIsFrontCamera = bl;
    }

    @Override
    public boolean isFrontCamera() {
        return this.mIsFrontCamera;
    }

    @Override
    public int switchCamera(final boolean bl) {
        final boolean bl2 = this.mIsFrontCamera;
        this.mIsFrontCamera = bl;
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                if (bl2 != bl) {
                    TXDeviceManagerImpl.this.mCaptureAndEnc.l();
                    if (TXDeviceManagerImpl.this.mDeviceManagerListener != null) {
                        TXDeviceManagerImpl.this.mDeviceManagerListener.onSwitchCamera();
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        return this.mCaptureAndEnc.r();
    }

    @Override
    public int setCameraZoomRatio(final float f2) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraZoomRatio " + f2);
                TXDeviceManagerImpl.this.mCaptureAndEnc.i((int)f2);
            }
        });
        return 0;
    }

    @Override
    public int enableCameraAutoFocus(final boolean bl) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("enableCameraAutoFocus " + bl);
                i i2 = TXDeviceManagerImpl.this.mCaptureAndEnc.c();
                i2.K = !bl;
                TXDeviceManagerImpl.this.mCaptureAndEnc.a(i2);
            }
        });
        return 0;
    }

    @Override
    public boolean isAutoFocusEnabled() {
        i i2 = this.mCaptureAndEnc.c();
        return !i2.K;
    }

    @Override
    public boolean enableCameraTorch(boolean bl) {
        this.apiLog("enableCameraTorch " + bl);
        return this.mCaptureAndEnc.f(bl);
    }

    @Override
    public int setCameraFocusPosition(final int n2, final int n3) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setCameraFocusPosition x:" + n2 + "y:" + n3);
                TXDeviceManagerImpl.this.mCaptureAndEnc.b(n2, n3);
            }
        });
        return 0;
    }

    @Override
    public int setAudioRoute(final TXDeviceManager.TXAudioRoute tXAudioRoute) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setAudioRoute " + (Object)((Object)tXAudioRoute));
                Monitor.a(1, String.format("setAudioRoute route:%s", tXAudioRoute.name()), "", 0);
                switch (tXAudioRoute) {
                    case TXAudioRouteSpeakerphone: {
                        TXCAudioEngine.setAudioRoute(0);
                        break;
                    }
                    case TXAudioRouteEarpiece: {
                        TXCAudioEngine.setAudioRoute(1);
                        break;
                    }
                }
            }
        });
        return 0;
    }

    @Override
    public int setSystemVolumeType(final TXDeviceManager.TXSystemVolumeType tXSystemVolumeType) {
        this.runOnSDKThread(new Runnable(){

            @Override
            public void run() {
                TXDeviceManagerImpl.this.apiLog("setSystemVolumeType " + (Object)((Object)tXSystemVolumeType));
                Monitor.a(1, String.format("setSystemVolumeType type:%s,  auto(0),media(1),VOIP(2)", tXSystemVolumeType.name()), "", 0);
                switch (tXSystemVolumeType) {
                    case TXSystemVolumeTypeAuto: {
                        TXCAudioEngine.setSystemVolumeType(0);
                        break;
                    }
                    case TXSystemVolumeTypeVOIP: {
                        TXCAudioEngine.setSystemVolumeType(2);
                        break;
                    }
                    case TXSystemVolumeTypeMedia: {
                        TXCAudioEngine.setSystemVolumeType(1);
                    }
                }
            }
        });
        return 0;
    }

    public static interface TXDeviceManagerListener {
        public void onSwitchCamera();
    }
}

