/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.avprotocol;

import android.util.Log;
import com.tencent.liteav.basic.d.c;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.a;
import com.tencent.liteav.basic.util.g;
import java.util.ArrayList;

public class TXCAVProtocol {
    public static byte AV_STATE_NONE = 0;
    public static byte AV_STATE_ENTER_AUDIO = 1;
    public static byte AV_STATE_EXIT_AUDIO = (byte)2;
    public static byte AV_STATE_ENTER_VIDEO = (byte)3;
    public static byte AV_STATE_EXIT_VIDEO = (byte)4;
    private static final String TAG = TXCAVProtocol.class.getSimpleName();
    private long mInstance = this.nativeInitAVProtocol();
    private TXIAVListener mListener = null;

    public void destory() {
        if (this.mInstance == 0L) {
            return;
        }
        this.nativeUninitAVProtocol(this.mInstance);
        this.mInstance = 0L;
    }

    public void setListener(TXIAVListener tXIAVListener) {
        this.mListener = tXIAVListener;
    }

    public void enterRoom(TXCAVProtoParam tXCAVProtoParam, TXIAVCompletionCallback tXIAVCompletionCallback) {
        if (this.mInstance == 0L) {
            return;
        }
        int n2 = (int)c.a().a("QUICMode", "AVRoom");
        this.nativeEnterRoom(this.mInstance, tXIAVCompletionCallback, tXCAVProtoParam.sdkAppid, tXCAVProtoParam.sdkVersion, tXCAVProtoParam.roomID, tXCAVProtoParam.authBits, tXCAVProtoParam.authBuffer, tXCAVProtoParam.userID, n2);
    }

    public void exitRoom(final TXIAVCompletionCallback tXIAVCompletionCallback) {
        if (this.mInstance == 0L) {
            return;
        }
        this.nativeExitRoom(this.mInstance, new TXIAVCompletionCallback(){

            @Override
            public void onComplete(int n2) {
                tXIAVCompletionCallback.onComplete(n2);
            }
        });
    }

    public void changeAVState(byte by, TXIAVCompletionCallback tXIAVCompletionCallback) {
        if (this.mInstance == 0L) {
            return;
        }
        this.nativeChangeAVState(this.mInstance, tXIAVCompletionCallback, by);
    }

    public void requestViews(ArrayList<TXSAVRoomView> arrayList, TXIAVCompletionCallback tXIAVCompletionCallback) {
        if (this.mInstance == 0L) {
            return;
        }
        long[] lArray = new long[arrayList.size()];
        int[] nArray = new int[arrayList.size()];
        int[] nArray2 = new int[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            lArray[i2] = arrayList.get((int)i2).tinyID;
            nArray[i2] = arrayList.get((int)i2).width;
            nArray2[i2] = arrayList.get((int)i2).height;
        }
        this.nativeRequestViews(this.mInstance, tXIAVCompletionCallback, lArray, nArray, nArray2);
    }

    public void pushAAC(byte[] byArray, long l2, int n2, int n3) {
        if (this.mInstance == 0L) {
            return;
        }
        this.nativePushAAC(this.mInstance, byArray, n2, n3, 16, 3, l2);
    }

    public void pushNAL(TXSNALPacket tXSNALPacket) {
        if (this.mInstance == 0L) {
            return;
        }
        this.nativePushNAL(this.mInstance, tXSNALPacket.nalData, tXSNALPacket.nalType, tXSNALPacket.gopIndex, tXSNALPacket.gopFrameIndex, tXSNALPacket.frameIndex, tXSNALPacket.refFremeIndex, tXSNALPacket.pts, tXSNALPacket.dts);
    }

    private void onPullAudio(int n2, long l2, byte[] byArray, long l3, int n3, int n4, int n5, int n6) {
        if (this.mListener != null) {
            TXSAVProtoAudioPacket tXSAVProtoAudioPacket = new TXSAVProtoAudioPacket();
            tXSAVProtoAudioPacket.roomID = n2;
            tXSAVProtoAudioPacket.tinyID = l2;
            tXSAVProtoAudioPacket.audioData = byArray;
            tXSAVProtoAudioPacket.timestamp = l3;
            tXSAVProtoAudioPacket.sampleRate = n3;
            tXSAVProtoAudioPacket.channelsPerSample = n4;
            tXSAVProtoAudioPacket.bitsPerChannel = n5;
            tXSAVProtoAudioPacket.packetType = n6;
            this.mListener.onPullAudio(tXSAVProtoAudioPacket);
        }
    }

    private void onPullVideo(int n2, long l2, byte[] byArray, int n3, long l3, long l4, int n4, int n5, int n6, int n7) {
        if (this.mListener != null) {
            TXSAVProtoNALPacket tXSAVProtoNALPacket = new TXSAVProtoNALPacket();
            tXSAVProtoNALPacket.roomID = n2;
            tXSAVProtoNALPacket.tinyID = l2;
            tXSAVProtoNALPacket.nalType = n3;
            tXSAVProtoNALPacket.nalData = byArray;
            tXSAVProtoNALPacket.pts = l3;
            tXSAVProtoNALPacket.dts = l4;
            tXSAVProtoNALPacket.gopIndex = n4;
            tXSAVProtoNALPacket.gopFrameIndex = n5;
            tXSAVProtoNALPacket.frameIndex = n6;
            tXSAVProtoNALPacket.refFremeIndex = n7;
            this.mListener.onPullNAL(tXSAVProtoNALPacket);
        }
    }

    private void onMemberChange(long l2, boolean bl) {
        this.mListener.onMemberChange(l2, bl);
    }

    private void onVideoStateChange(long l2, boolean bl) {
        this.mListener.onVideoStateChange(l2, bl);
    }

    private void sendNotifyEvent(int n2, String string) {
        Log.i((String)TAG, (String)("event" + n2));
        this.mListener.sendNotifyEvent(n2, string);
    }

    public long[] getRoomMemberList() {
        if (this.mInstance == 0L) {
            return null;
        }
        return this.nativeGetRoomMemberList(this.mInstance);
    }

    public long[] getRoomVideoList() {
        if (this.mInstance == 0L) {
            return null;
        }
        return this.nativeGetRoomVideoList(this.mInstance);
    }

    public UploadStats getUploadStats() {
        UploadStats uploadStats = null;
        if (this.mInstance != 0L) {
            uploadStats = this.nativeGetUploadStats(this.mInstance);
        }
        return uploadStats;
    }

    public DownloadStats getDownloadStats() {
        DownloadStats downloadStats = null;
        if (this.mInstance != 0L) {
            downloadStats = this.nativeGetDownloadStats(this.mInstance);
        }
        return downloadStats;
    }

    public native String nativeNAT64Compatable(String var1, short var2);

    private native long nativeInitAVProtocol();

    private native void nativeUninitAVProtocol(long var1);

    private native void nativeEnterRoom(long var1, TXIAVCompletionCallback var3, long var4, long var6, long var8, long var10, byte[] var12, long var13, int var15);

    private native void nativeExitRoom(long var1, TXIAVCompletionCallback var3);

    private native void nativeChangeAVState(long var1, TXIAVCompletionCallback var3, byte var4);

    private native void nativeRequestViews(long var1, TXIAVCompletionCallback var3, long[] var4, int[] var5, int[] var6);

    private native void nativePushAAC(long var1, byte[] var3, int var4, int var5, int var6, int var7, long var8);

    private native void nativePushNAL(long var1, byte[] var3, int var4, long var5, long var7, long var9, long var11, long var13, long var15);

    private native UploadStats nativeGetUploadStats(long var1);

    private native DownloadStats nativeGetDownloadStats(long var1);

    private native long[] nativeGetRoomMemberList(long var1);

    private native long[] nativeGetRoomVideoList(long var1);

    static {
        g.f();
    }

    public class TXSAVRoomView {
        public long tinyID;
        public int height;
        public int width;
    }

    public class TXCAVProtoParam {
        public int sdkAppid;
        public int sdkVersion;
        public long userID;
        public long roomID;
        public int authBits;
        public byte[] authBuffer;
    }

    public static interface TXIAVListener {
        public void onPullAudio(TXSAVProtoAudioPacket var1);

        public void onPullNAL(TXSAVProtoNALPacket var1);

        public void sendNotifyEvent(int var1, String var2);

        public void onMemberChange(long var1, boolean var3);

        public void onVideoStateChange(long var1, boolean var3);
    }

    public class TXSAVProtoNALPacket
    extends TXSNALPacket {
        public int roomID;
        public long tinyID;
    }

    public class TXSAVProtoAudioPacket
    extends a {
        public int roomID;
        public long tinyID;
    }

    public static interface TXIAVCompletionCallback {
        public void onComplete(int var1);
    }

    public class DownloadStats {
        public long beforeParseVideoBytes;
        public long beforeParseAudioBytes;
        public long afterParseVideoBytes;
        public long afterParseAudioBytes;
        public long startTS;
        public long dnsTS;
        public long connTS;
        public long firstVideoTS;
        public long firstAudioTS;
        public String serverIP;
    }

    public class UploadStats {
        public long inVideoBytes;
        public long inAudioBytes;
        public long outVideoBytes;
        public long outAudioBytes;
        public long videoCacheLen;
        public long audioCacheLen;
        public long videoDropCount;
        public long audioDropCount;
        public long startTS;
        public long dnsTS;
        public long connTS;
        public String serverIP;
        public long channelType;
    }
}

