/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.g;
import com.tencent.liteav.audio.impl.Play.TXCMultAudioTrackPlayer;
import com.tencent.liteav.basic.log.TXCLog;
import java.lang.ref.WeakReference;

public class TXCUGCBGMPlayer
implements TXAudioEffectManager.TXMusicPlayObserver {
    private static final String TAG = "AudioCenter:TXCUGCBGMPlayer";
    private WeakReference<g> mWeakListener = null;
    private static final int PLAY_SUCCESS = 0;
    private static final int PLAY_ERR_OPEN = -1;
    private boolean mIsRunning = false;
    private float mVolume = 1.0f;
    private float mSpeedRate = 1.0f;
    private long mStartTimeMS = 0L;
    private long mEndTimeMS = 0L;
    private long mSeekBytes = 0L;
    private int mBGMId = Integer.MIN_VALUE;

    public static TXCUGCBGMPlayer getInstance() {
        return a.a();
    }

    private TXCUGCBGMPlayer() {
        TXCMultAudioTrackPlayer.getInstance();
    }

    public synchronized void setOnPlayListener(g g2) {
        if (g2 == null) {
            this.mWeakListener = null;
        }
        this.mWeakListener = new WeakReference<g>(g2);
    }

    public void startPlay(String string, boolean bl) {
        TXCLog.i(TAG, "startPlay:" + string + "record:" + bl);
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.mIsRunning) {
            TXCLog.w(TAG, "BGM is playing, restarting...");
            this.stopPlay();
        }
        this.mSeekBytes = 0L;
        this.mIsRunning = true;
        TXAudioEffectManager.AudioMusicParam audioMusicParam = new TXAudioEffectManager.AudioMusicParam(this.mBGMId, string);
        audioMusicParam.publish = bl;
        audioMusicParam.loopCount = 0;
        audioMusicParam.startTimeMS = this.mStartTimeMS;
        audioMusicParam.endTimeMS = this.mEndTimeMS;
        audioMusicParam.isShortFile = true;
        TXCLog.i(TAG, "start bgm play : filePath = " + string + " publish:" + bl + " startTimeMS:" + this.mStartTimeMS + " endTimeMS:" + this.mEndTimeMS + " isShortFile:" + audioMusicParam.isShortFile + "mVolume:" + this.mVolume);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(this.mBGMId, (int)(this.mVolume * 100.0f));
        TXAudioEffectManagerImpl.getCacheInstance().setMusicPlayoutSpeedRate(this.mBGMId, this.mSpeedRate);
        if (bl) {
            TXAudioEffectManagerImpl.getCacheInstance().setMuteDataDurationToPublish(this.mBGMId, 200);
        }
        boolean bl2 = TXAudioEffectManagerImpl.getCacheInstance().startPlayMusic(audioMusicParam);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(this.mBGMId, this);
        if (!bl2) {
            this.onPlayEnd(-1);
            return;
        }
        this.onPlayStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlay() {
        TXCLog.i(TAG, "stopPlay");
        this.mIsRunning = false;
        long l2 = System.currentTimeMillis();
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            TXAudioEffectManagerImpl.getCacheInstance().setMusicObserver(this.mBGMId, null);
            TXAudioEffectManagerImpl.getCacheInstance().stopPlayMusic(this.mBGMId);
        }
        TXCLog.i(TAG, "stopBGMPlay cost(MS): " + (System.currentTimeMillis() - l2));
    }

    public void pause() {
        TXCLog.i(TAG, "pause");
        TXAudioEffectManagerImpl.getCacheInstance().pausePlayMusic(this.mBGMId);
    }

    public void resume() {
        TXCLog.i(TAG, "resume");
        TXAudioEffectManagerImpl.getCacheInstance().resumePlayMusic(this.mBGMId);
    }

    public void setVolume(float f2) {
        TXCLog.i(TAG, "setVolume:" + f2);
        this.mVolume = f2;
        TXAudioEffectManagerImpl.getCacheInstance().setMusicVolume(this.mBGMId, (int)(f2 * 100.0f));
    }

    public void setSpeedRate(float f2) {
        TXCLog.i(TAG, "setSpeedRate:" + f2);
        this.mSpeedRate = f2;
        TXAudioEffectManagerImpl.getCacheInstance().setMusicPlayoutSpeedRate(this.mBGMId, f2);
    }

    public void setChangerType(int n2) {
        TXCLog.i(TAG, "changerType:" + n2);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicChangerType(this.mBGMId, n2);
    }

    public void setReverbType(int n2) {
        TXCLog.i(TAG, "int reverbType:" + n2);
        TXAudioEffectManagerImpl.getCacheInstance().setMusicReverbType(this.mBGMId, n2);
    }

    public void playFromTime(long l2, long l3) {
        TXCLog.i(TAG, "startPlayRange:" + l2 + ", " + l3);
        this.mStartTimeMS = l2;
        this.mEndTimeMS = l3;
    }

    public void seekBytes(long l2) {
        TXCLog.i(TAG, "seekBytes:" + l2);
        if (l2 < 0L) {
            l2 = 0L;
            TXCLog.e(TAG, "seek bytes can not be negative. change to 0");
        }
        this.mSeekBytes = l2;
        TXAudioEffectManagerImpl.getCacheInstance().seekMusicToPosInBytes(this.mBGMId, l2);
    }

    public long getDurationMS(String string) {
        return TXAudioEffectManagerImpl.getCacheInstance().getMusicDurationInMS(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayStart() {
        g g2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                g2 = (g)this.mWeakListener.get();
            }
        }
        if (g2 != null) {
            g2.onPlayStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayEnd(int n2) {
        g g2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                g2 = (g)this.mWeakListener.get();
            }
        }
        if (g2 != null) {
            g2.onPlayEnd(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayProgress(long l2, long l3) {
        g g2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                g2 = (g)this.mWeakListener.get();
            }
        }
        if (g2 != null) {
            g2.onPlayProgress(l2, l3);
        }
    }

    @Override
    public void onPlayProgress(int n2, long l2, long l3) {
        this.onPlayProgress(l2, l3);
    }

    @Override
    public void onStart(int n2, int n3) {
        this.onPlayStart();
    }

    @Override
    public void onComplete(int n2, int n3) {
        this.onPlayEnd(n3);
    }

    static {
        com.tencent.liteav.basic.util.g.f();
    }

    private static class a {
        private static TXCUGCBGMPlayer a = new TXCUGCBGMPlayer();

        public static TXCUGCBGMPlayer a() {
            return a;
        }
    }
}

