/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXAudioEffectManagerImpl;
import com.tencent.liteav.audio.TXCAudioEncoderConfig;
import com.tencent.liteav.audio.b;
import com.tencent.liteav.audio.d;
import com.tencent.liteav.audio.e;
import com.tencent.liteav.audio.f;
import com.tencent.liteav.audio.impl.Play.TXCMultAudioTrackPlayer;
import com.tencent.liteav.audio.impl.Record.TXCAudioSysRecord;
import com.tencent.liteav.audio.impl.TXCAudioEngineJNI;
import com.tencent.liteav.audio.impl.a;
import com.tencent.liteav.audio.impl.earmonitor.HuaweiAudioKit;
import com.tencent.liteav.audio.impl.earmonitor.TXSystemAudioKit;
import com.tencent.liteav.basic.d.c;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.StatusBucket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class TXCAudioEngine
implements com.tencent.liteav.audio.impl.b,
com.tencent.liteav.audio.impl.earmonitor.a {
    private static final String TAG = "AudioEngine :TXCAudioEngine_java";
    private static final int EVT_AUDIO_DEVICE_ROLLBACK_TO_STABLE_SAMPLERATE = 10055;
    private static final int EVT_AUDIO_DEVICE_RESTART_WHEN_USING_STABLE_SAMPLERATE = 10056;
    private static final long SYSTEM_AUDIO_KIT_RESTART_INTERVAL = TimeUnit.SECONDS.toMillis(2L);
    static TXCAudioEngine sInstance = new TXCAudioEngine();
    private final ArrayList<WeakReference<com.tencent.liteav.basic.c.a>> mCallbackList = new ArrayList();
    private TXSystemAudioKit mAudioKit;
    protected boolean mDeviceIsRecording = false;
    protected boolean mIsCustomRecord = false;
    protected static Context mContext = null;
    private static boolean has_trae = false;
    private static WeakReference<e> mAudioCoreDataListener = null;
    protected static final HashMap<String, WeakReference<e>> mJitterDataListenerMap = new HashMap();
    private static final Object mJitterDataListenerMapLock = new Object();
    protected static final HashMap<String, WeakReference<d>> mJitterEventListenerMap = new HashMap();
    private static final Object mJitterEventListenerMapLock = new Object();
    private static volatile boolean has_init = false;
    protected boolean mIsCallComed = false;

    public static TXCAudioEngine getInstance() {
        return sInstance;
    }

    private TXCAudioEngine() {
    }

    public static synchronized void CreateInstance(Context context, String string) {
        TXCAudioEngine.CreateInstanceWithoutInitDevice(context, string);
        TXCAudioEngineJNI.nativeInitAudioDevice();
    }

    public static synchronized void CreateInstanceWithoutInitDevice(Context context, String string) {
        TXCLog.i(TAG, "CreateInstance: ");
        mContext = context.getApplicationContext();
        if (has_init) {
            TXCLog.i(TAG, "CreateInstance already created~ ");
            return;
        }
        if (TXCAudioEngineJNI.nativeCheckTraeEngine(context)) {
            has_trae = true;
        }
        TXCAudioEngineJNI.nativeUseSysAudioDevice(!has_trae);
        if (has_trae) {
            TXCAudioEngineJNI.InitTraeEngineLibrary(context);
            TXCAudioEngineJNI.nativeSetTRAEConfig(string);
            TXCAudioEngineJNI.nativeInitBeforeEngineCreate(context);
            a.a().a(context.getApplicationContext());
            a.a().a(sInstance);
            TXCAudioEngineJNI.nativeNewAudioSessionDuplicate(mContext);
        } else {
            TXCMultAudioTrackPlayer.getInstance();
            TXCAudioSysRecord.getInstance();
        }
        has_init = true;
    }

    public static boolean hasTrae() {
        return has_trae;
    }

    public static boolean enableAudioVolumeEvaluation(boolean bl, int n2) {
        TXCLog.i(TAG, "enableAudioVolumeEvaluation : " + bl + "interval:" + n2);
        TXCAudioEngineJNI.nativeEnableAudioVolumeEvaluation(bl, n2);
        return true;
    }

    public Context getAppContext() {
        return mContext;
    }

    public void setAudioQuality(int n2, int n3) {
        TXCAudioEngineJNI.nativeSetAudioQuality(n2, n3);
    }

    public void setEncoderSampleRate(int n2) {
        TXCAudioEngineJNI.nativeSetEncoderSampleRate(n2);
    }

    public void setEncoderChannels(int n2) {
        TXCAudioEngineJNI.nativeSetEncoderChannels(n2);
    }

    public int getEncoderSampleRate() {
        return TXCAudioEngineJNI.nativeGetEncoderSampleRate();
    }

    public int getEncoderChannels() {
        return TXCAudioEngineJNI.nativeGetEncoderChannels();
    }

    public TXCAudioEncoderConfig getAudioEncoderConfig() {
        return TXCAudioEngineJNI.nativeGetEncoderConfig();
    }

    public int startLocalAudio(int n2, boolean bl) {
        TXCLog.i(TAG, "startLocalAudio audioFormat:" + n2);
        if (mContext == null) {
            TXCLog.i(TAG, "Please call CreateInstance fisrt!!!");
            return -901;
        }
        TXCAudioEngineJNI.InitTraeEngineLibrary(mContext);
        TXCAudioEngineJNI.nativeStartLocalAudio(n2, bl);
        this.mDeviceIsRecording = true;
        return 0;
    }

    public int stopLocalAudio() {
        TXCLog.i(TAG, "stopLocalAudio");
        TXCAudioEngineJNI.nativeStopLocalAudio();
        this.mDeviceIsRecording = false;
        return 0;
    }

    public void pauseLocalAudio() {
        TXCAudioEngineJNI.nativePauseLocalAudio();
    }

    public void resumeLocalAudio() {
        TXCAudioEngineJNI.nativeResumeLocalAudio();
    }

    public void EnableMixMode(boolean bl) {
        TXCAudioEngineJNI.nativeEnableMixMode(bl);
    }

    public void enableEncodedDataPackWithTRAEHeaderCallback(boolean bl) {
        TXCAudioEngineJNI.nativeEnableEncodedDataPackWithTRAEHeaderCallback(bl);
    }

    public void enableEncodedDataCallback(boolean bl) {
        TXCAudioEngineJNI.nativeEnableEncodedDataCallback(bl);
    }

    public int pauseAudioCapture(boolean bl) {
        TXCLog.i(TAG, "pauseAudioCapture: " + bl);
        TXCAudioEngineJNI.pauseAudioCapture(bl);
        return 0;
    }

    public int resumeAudioCapture() {
        TXCLog.i(TAG, "resumeRecord");
        TXCAudioEngineJNI.resumeAudioCapture();
        return 0;
    }

    public void sendCustomPCMData(byte[] byArray, int n2, int n3) {
        TXCAudioEngineJNI.sendCustomPCMData(byArray, n2, n3);
    }

    public void sendCustomPCMData(com.tencent.liteav.basic.structs.a a2) {
        TXCAudioEngineJNI.sendCustomPCMData(a2);
    }

    public boolean setAudioCaptureDataListener(f f2) {
        TXCLog.i(TAG, "setRecordListener ");
        if (f2 == null) {
            TXCAudioEngineJNI.setAudioCaptureDataListener(null);
        } else {
            TXCAudioEngineJNI.setAudioCaptureDataListener(new WeakReference<f>(f2));
        }
        return true;
    }

    public boolean muteLocalAudio(boolean bl) {
        TXCLog.i(TAG, "setRecordMute: " + bl);
        TXCAudioEngineJNI.nativeMuteLocalAudio(bl);
        return true;
    }

    public boolean setReverbType(TXAudioEffectManager.TXVoiceReverbType tXVoiceReverbType) {
        TXCLog.i(TAG, "setReverbType: " + tXVoiceReverbType.getNativeValue());
        TXCAudioEngineJNI.nativeSetRecordReverb(tXVoiceReverbType.getNativeValue());
        return true;
    }

    public boolean setSoftwareCaptureVolume(float f2) {
        TXCLog.i(TAG, "setRecordVolume: " + f2);
        TXCAudioEngineJNI.nativeSetSoftwareCaptureVolume(f2);
        return true;
    }

    public boolean setMixingPlayoutVolume(float f2) {
        TXCLog.i(TAG, "setPlayoutVolume: " + f2);
        TXCAudioEngineJNI.nativeSetMixingPlayoutVolume(f2);
        return true;
    }

    public void enableSoftAEC(boolean bl, int n2) {
        TXCLog.i(TAG, "enableSoftAEC: enable = " + bl + " level = " + n2);
        if (!bl) {
            n2 = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftAEC(n2);
    }

    public void enableSoftANS(boolean bl, int n2) {
        TXCLog.i(TAG, "enableSoftANS: enable = " + bl + " level = " + n2);
        if (!bl) {
            n2 = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftANS(n2);
    }

    public void enableSoftAGC(boolean bl, int n2) {
        TXCLog.i(TAG, "enableSoftAGC: enable = " + bl + " level = " + n2);
        if (!bl) {
            n2 = 0;
        }
        TXCAudioEngineJNI.nativeSetSoftAGC(n2);
    }

    public boolean setVoiceChangerType(TXAudioEffectManager.TXVoiceChangerType tXVoiceChangerType) {
        TXCLog.i(TAG, "setVoiceChangerType " + tXVoiceChangerType.getNativeValue());
        TXCAudioEngineJNI.nativeSetCaptureVoiceChanger(tXVoiceChangerType.getNativeValue());
        return true;
    }

    public boolean setEncoderFECPercent(float f2) {
        TXCAudioEngineJNI.nativeSetEncoderFECPercent(f2);
        return true;
    }

    public boolean setAudioEncoderParam(int n2, int n3) {
        TXCAudioEngineJNI.nativeSetAudioEncoderParam(n2, n3);
        return true;
    }

    public boolean enableCaptureEOSMode(boolean bl) {
        TXCLog.i(TAG, "enableEosMode " + bl);
        TXCAudioEngineJNI.nativeEnableCaptureEOSMode(bl);
        return true;
    }

    public boolean isAudioDeviceCapturing() {
        boolean bl = TXCAudioEngineJNI.nativeIsAudioDeviceCapturing();
        TXCLog.i(TAG, "isRecording: " + bl);
        return bl;
    }

    public int getAECType() {
        return 2;
    }

    public int getSoftwareCaptureVolumeLevel() {
        return TXCAudioEngineJNI.nativeGetSoftwareCaptureVolumeLevel();
    }

    public void startRemoteAudio(String string, boolean bl) {
        TXCAudioEngineJNI.nativeStartRemoteAudio(sInstance, bl, string);
        TXCAudioEngineJNI.nativeSetRemoteAudioJitterCycle(string, c.a().a("Audio", "LIVE_JitterCycle"));
        TXCAudioEngineJNI.nativeSetRemoteAudioBlockThreshold(string, c.a().a("Audio", "LoadingThreshold"));
    }

    public void stopRemoteAudio(String string) {
        if (string == null) {
            return;
        }
        TXCAudioEngineJNI.nativeStopRemoteAudio(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetAudioEngineRemoteStreamDataListener(String string, e e2) {
        if (string == null) {
            return;
        }
        Object object = mJitterDataListenerMapLock;
        synchronized (object) {
            mJitterDataListenerMap.put(string, new WeakReference<e>(e2));
        }
        TXCAudioEngineJNI.nativeSetAudioEngineRemoteStreamDataListener(string, null != e2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onAudioPlayPcmData(String string, byte[] byArray, long l2, int n2, int n3) {
        e e2 = null;
        Object object = mJitterDataListenerMapLock;
        synchronized (object) {
            if (null != mJitterDataListenerMap.get(string)) {
                e2 = (e)mJitterDataListenerMap.get(string).get();
            }
        }
        if (null != e2) {
            e2.onAudioPlayPcmData(string, byArray, l2, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteAudioStreamEventListener(String string, d d2) {
        if (string == null) {
            return;
        }
        Object object = mJitterEventListenerMapLock;
        synchronized (object) {
            mJitterEventListenerMap.put(string, new WeakReference<d>(d2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onAudioJitterBufferNotify(String string, int n2, String string2) {
        d d2 = null;
        Object object = mJitterEventListenerMapLock;
        synchronized (object) {
            if (null != mJitterEventListenerMap.get(string)) {
                d2 = (d)mJitterEventListenerMap.get(string).get();
            }
        }
        if (d2 != null) {
            TXCLog.i(TAG, "onAudioJitterBufferNotify  cur state " + n2);
            d2.onAudioJitterBufferNotify(string, n2, string2);
        }
    }

    public void setRemoteAudioCacheParams(String string, boolean bl, int n2, int n3, int n4) {
        TXCAudioEngineJNI.nativeSetRemoteAudioCacheParams(string, bl, n2, n3, n4);
    }

    public void muteRemoteAudio(String string, boolean bl) {
        if (string == null) {
            return;
        }
        TXCAudioEngineJNI.nativeMuteRemoteAudio(string, bl);
    }

    public void muteRemoteAudioInSpeaker(String string, boolean bl) {
        if (string == null) {
            return;
        }
        TXCAudioEngineJNI.nativeMuteRemoteAudioInSpeaker(string, bl);
    }

    public void setRemotePlayoutVolume(String string, int n2) {
        if (string == null) {
            return;
        }
        TXCAudioEngineJNI.nativeSetRemotePlayoutVolume(string, n2);
    }

    public boolean isRemoteAudioPlaying(String string) {
        if (string == null) {
            return false;
        }
        return TXCAudioEngineJNI.nativeIsRemoteAudioPlaying(string);
    }

    public int getRemotePlayoutVolumeLevel(String string) {
        if (string == null) {
            return 0;
        }
        return TXCAudioEngineJNI.nativeGetRemotePlayoutVolumeLevel(string);
    }

    public int getPlaySampleRate() {
        return 48000;
    }

    public int getPlayChannels() {
        return 2;
    }

    public int getPlayAECType() {
        if (has_trae) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventCallback(WeakReference<com.tencent.liteav.basic.c.a> weakReference) {
        if (weakReference == null) {
            return;
        }
        ArrayList<WeakReference<com.tencent.liteav.basic.c.a>> arrayList = this.mCallbackList;
        synchronized (arrayList) {
            this.mCallbackList.add(weakReference);
            TXCAudioEngineJNI.nativeSetEventCallbackEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String string, int n2, String string2, String string3) {
        this.handleAudioEvent(string, n2, string2, string3);
        ArrayList<com.tencent.liteav.basic.c.a> arrayList = new ArrayList<com.tencent.liteav.basic.c.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.c.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.c.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.c.a> weakReference = object.next();
                com.tencent.liteav.basic.c.a a2 = (com.tencent.liteav.basic.c.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.c.a a3 : arrayList) {
            a3.onEvent(string, n2, string2, string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWarning(String string, int n2, String string2, String string3) {
        this.handleAudioEvent(string, n2, string2, string3);
        ArrayList<com.tencent.liteav.basic.c.a> arrayList = new ArrayList<com.tencent.liteav.basic.c.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.c.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.c.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.c.a> weakReference = object.next();
                com.tencent.liteav.basic.c.a a2 = (com.tencent.liteav.basic.c.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.c.a a3 : arrayList) {
            a3.onWarning(string, n2, string2, string3);
        }
    }

    private void handleAudioEvent(String string, int n2, String string2, String string3) {
        if (n2 == 10055) {
            b.a().a("timestamp_rollback_to_stable_samplerate", System.currentTimeMillis());
        } else if (n2 == 10056) {
            b.a().a("timestamp_rollback_to_stable_samplerate", 0L);
            TXCLog.i(TAG, "audio device restart when using stable samplerate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(String string, int n2, String string2, String string3) {
        ArrayList<com.tencent.liteav.basic.c.a> arrayList = new ArrayList<com.tencent.liteav.basic.c.a>();
        ArrayList<WeakReference<com.tencent.liteav.basic.c.a>> arrayList2 = this.mCallbackList;
        synchronized (arrayList2) {
            if (this.mCallbackList.size() <= 0) {
                return;
            }
            Iterator<WeakReference<com.tencent.liteav.basic.c.a>> object = this.mCallbackList.iterator();
            while (object.hasNext()) {
                WeakReference<com.tencent.liteav.basic.c.a> weakReference = object.next();
                com.tencent.liteav.basic.c.a a2 = (com.tencent.liteav.basic.c.a)weakReference.get();
                if (a2 != null) {
                    arrayList.add(a2);
                    continue;
                }
                object.remove();
            }
            if (this.mCallbackList.size() <= 0) {
                TXCAudioEngineJNI.nativeSetEventCallbackEnabled(false);
            }
        }
        for (com.tencent.liteav.basic.c.a a3 : arrayList) {
            a3.onError(string, n2, string2, string3);
        }
    }

    public static void setPlayoutDataListener(e e2) {
        mAudioCoreDataListener = new WeakReference<e>(e2);
        TXCAudioEngineJNI.nativeSetPlayoutDataListener(null != e2);
    }

    public static void onCorePlayPcmData(byte[] byArray, long l2, int n2, int n3) {
        e e2;
        if (mAudioCoreDataListener != null && (e2 = (e)mAudioCoreDataListener.get()) != null) {
            e2.onAudioPlayPcmData(null, byArray, l2, n2, n3);
        }
    }

    public static int getMixingPlayoutVolumeLevel() {
        return TXCAudioEngineJNI.nativeGetMixingPlayoutVolumeLevel();
    }

    public StatusBucket getStatus(int n2) {
        return TXCAudioEngineJNI.getStatus(n2);
    }

    public static void setAudioRoute(int n2) {
        TXCLog.i(TAG, "setAudioRoute: " + n2);
        TXCAudioEngineJNI.nativeSetAudioRoute(n2);
    }

    public static void setSystemVolumeType(int n2) {
        TXCLog.i(TAG, "setSystemVolumeType: " + n2);
        TXCAudioEngineJNI.nativeSetSystemVolumeType(n2);
    }

    public static void enableAudioEarMonitoring(boolean bl) {
        TXCLog.i(TAG, "enableAudioEarMonitoring: " + bl);
        TXCAudioEngineJNI.nativeEnableAudioEarMonitoring(bl);
    }

    public static void setAudioEarMonitoringVolume(int n2) {
        TXCLog.i(TAG, "setAudioEarMonitoringVolume: " + n2);
        TXCAudioEngineJNI.nativeSetAudioEarMonitoringVolume(n2);
    }

    public int startLocalAudioDumping(int n2, int n3, String string) {
        return TXCAudioEngineJNI.nativeStartLocalAudioDumping(n2, n3, string);
    }

    public void stopLocalAudioDumping() {
        TXCAudioEngineJNI.nativeStopLocalAudioDumping();
    }

    public void setAudioDumpingListener(TXCAudioEngineJNI.a a2) {
        TXCAudioEngineJNI.SetAudioDumpingListener(a2);
    }

    public void setCaptureDataCallbackFormat(int n2, int n3, int n4) {
        TXCLog.i(TAG, "setCaptureDataCallbackFormat: sampleRate-" + n2 + " channels-" + n3 + " length-" + n4);
        TXCAudioEngineJNI.nativeSetCaptureDataCallbackFormat(n2, n3, n4);
    }

    public void setPlayoutDataCallbackFormat(int n2, int n3, int n4) {
        TXCLog.i(TAG, "setPlayoutDataCallbackFormat: sampleRate-" + n2 + " channels-" + n3 + " length-" + n4);
        TXCAudioEngineJNI.nativeSetPlayoutDataCallbackFormat(n2, n3, n4);
    }

    public void setRemoteStreamDataCallbackFormat(String string, int n2, int n3, int n4) {
        TXCLog.i(TAG, "setRemoteStreamDataCallbackFormat: id-" + string + " sampleRate-" + n2 + " channels-" + n3 + " length-" + n4);
        TXCAudioEngineJNI.nativeSetRemoteStreamDataCallbackFormat(string, n2, n3, n4);
    }

    public void clean() {
        TXCAudioEngineJNI.nativeClean();
    }

    public void forceCallbackMixedPlayAudioFrame(boolean bl) {
        TXCAudioEngineJNI.nativeForceCallbackMixedPlayAudioFrame(bl);
    }

    @Override
    public void onCallStateChanged(int n2) {
        switch (n2) {
            case 1: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_RINGING!");
                break;
            }
            case 2: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_OFFHOOK!");
                TXCAudioEngineJNI.pauseAudioCapture(true);
                TXAudioEffectManagerImpl.getInstance().interruptAllMusics();
                TXAudioEffectManagerImpl.getCacheInstance().interruptAllMusics();
                TXAudioEffectManagerImpl.getAutoCacheHolder().interruptAllMusics();
                this.mIsCallComed = true;
                break;
            }
            case 0: {
                TXCLog.i(TAG, "TelephonyManager.CALL_STATE_IDLE!");
                if (!this.mIsCallComed) break;
                this.mIsCallComed = false;
                TXCAudioEngineJNI.resumeAudioCapture();
                TXAudioEffectManagerImpl.getInstance().recoverAllMusics();
                TXAudioEffectManagerImpl.getCacheInstance().recoverAllMusics();
                TXAudioEffectManagerImpl.getAutoCacheHolder().recoverAllMusics();
            }
        }
    }

    public void enableAutoRestartDevice(boolean bl) {
        TXCAudioEngineJNI.nativeEnableAutoRestartDevice(bl);
    }

    public void setMaxSelectedPlayStreams(int n2) {
        TXCAudioEngineJNI.nativeSetMaxSelectedPlayStreams(n2);
    }

    public static String buildTRAEConfig(Context context, Boolean bl, boolean bl2, long l2) {
        String string = "";
        string = string + "sharp {\n";
        string = string + "  os android\n";
        string = string + "  trae {\n";
        string = string + "    dev {\n";
        if (bl != null) {
            string = string + "  closeOpensl " + (bl != false ? "n" : "y") + "\n";
        }
        long l3 = b.a().b("timestamp_rollback_to_stable_samplerate", 0L);
        boolean bl3 = System.currentTimeMillis() - l3 < l2;
        TXCLog.i(TAG, "low latency samplerate, enable: %b, isBlocked: %b, blockTime: %d", bl2, bl3, l2);
        if (!bl3 && bl2 && TXCAudioEngine.getLowLatencySampleRate(context) == 48000) {
            string = string + "  component 1\n";
            string = string + "  cap {\n";
            string = string + "    hw_sr 48000\n";
            string = string + "  }\n";
            string = string + "  play {\n";
            string = string + "    hw_sr 48000\n";
            string = string + "  }";
        }
        string = string + "    }\n";
        string = string + "  }\n";
        string = string + "}";
        return string;
    }

    private static int getLowLatencySampleRate(Context context) {
        AudioManager audioManager;
        if (Build.VERSION.SDK_INT >= 17 && (audioManager = (AudioManager)context.getSystemService("audio")) != null) {
            try {
                return Integer.parseInt(audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE"));
            }
            catch (NumberFormatException numberFormatException) {
                TXCLog.e(TAG, "can't parse low latency samplerate", numberFormatException);
            }
        }
        return -1;
    }

    public void setSystemAudioKitEnabled() {
        this.startSystemAudioKit();
    }

    private void startSystemAudioKit() {
        if (this.mAudioKit != null || mContext == null) {
            return;
        }
        this.mAudioKit = this.createManufacturerAudioKit(mContext);
        if (this.mAudioKit != null) {
            TXCAudioEngineJNI.nativeNotifySystemEarMonitoringInitializing();
            this.mAudioKit.initialize(mContext, this);
        } else {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onAudioKitInitFinished(TXSystemAudioKit tXSystemAudioKit, boolean bl) {
        if (this.mAudioKit != tXSystemAudioKit) {
            return;
        }
        TXCLog.i(TAG, "system audio kit init finished, ret: %b.", bl);
        if (!bl) {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onEarMonitoringInitialized(TXSystemAudioKit tXSystemAudioKit, boolean bl) {
        if (this.mAudioKit != tXSystemAudioKit) {
            return;
        }
        TXCLog.i(TAG, "onEarMonitoringInitialized result: %b", bl);
        if (bl) {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(this.mAudioKit);
        } else {
            TXCAudioEngineJNI.nativeSetSystemEarMonitoring(null);
        }
    }

    @Override
    public void onAudioKitError(TXSystemAudioKit tXSystemAudioKit) {
        if (this.mAudioKit != tXSystemAudioKit) {
            return;
        }
        TXCLog.i(TAG, "onAudioKitError");
        if (this.mAudioKit != null) {
            this.mAudioKit.stopSystemEarMonitoring();
            this.mAudioKit.uninitialize();
            this.mAudioKit = null;
        }
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                TXCAudioEngine.this.startSystemAudioKit();
            }
        }, SYSTEM_AUDIO_KIT_RESTART_INTERVAL);
    }

    private TXSystemAudioKit createManufacturerAudioKit(Context context) {
        String string = Build.MANUFACTURER;
        if (string.equalsIgnoreCase("huawei")) {
            return new HuaweiAudioKit();
        }
        return null;
    }
}

