/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.TXAudioEffectManager;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.g;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TXAudioEffectManagerImpl
implements TXAudioEffectManager {
    private static final String TAG = "AudioCenter:TXAudioEffectManager";
    private static final int OLD_BGM_PLAYER_ID_TYPE = 0;
    private static final int NEW_BGM_PLAYER_ID_TYPE = 1;
    private static final int EFFECT_PLAYER_ID_TYPE = 2;
    private static final HashMap<Long, TXAudioEffectManager.TXMusicPlayObserver> mMusicObserverMap = new HashMap();
    private final int mIdType;
    private final List<Long> mPlayingMusicIDList = new ArrayList<Long>();
    private static final Handler mMainHandler = new Handler(Looper.getMainLooper());

    public static TXAudioEffectManagerImpl getInstance() {
        return AudioEffectManagerHolder.INSTANCE;
    }

    public static TXAudioEffectManagerImpl getCacheInstance() {
        return AudioEffectManagerCacheHolder.INSTANCE;
    }

    public static TXAudioEffectManagerImpl getAutoCacheHolder() {
        return AudioEffectManagerAutoCacheHolder.INSTANCE;
    }

    private TXAudioEffectManagerImpl(int n2) {
        this.mIdType = n2;
    }

    @Override
    public void enableVoiceEarMonitor(boolean bl) {
        TXCAudioEngine.enableAudioEarMonitoring(bl);
    }

    @Override
    public void setVoiceEarMonitorVolume(int n2) {
        TXCAudioEngine.setAudioEarMonitoringVolume(n2);
    }

    @Override
    public void setVoiceReverbType(TXAudioEffectManager.TXVoiceReverbType tXVoiceReverbType) {
        TXCAudioEngine.getInstance().setReverbType(tXVoiceReverbType);
    }

    @Override
    public void setVoiceChangerType(TXAudioEffectManager.TXVoiceChangerType tXVoiceChangerType) {
        TXCAudioEngine.getInstance().setVoiceChangerType(tXVoiceChangerType);
    }

    @Override
    public void setVoiceCaptureVolume(int n2) {
        float f2 = (float)n2 / 100.0f;
        TXCAudioEngine.getInstance().setSoftwareCaptureVolume(f2);
    }

    public void setAudioPlayoutVolume(int n2) {
        float f2 = (float)n2 / 100.0f;
        TXCAudioEngine.getInstance().setMixingPlayoutVolume(f2);
    }

    @Override
    public void setMusicObserver(final int n2, final TXAudioEffectManager.TXMusicPlayObserver tXMusicPlayObserver) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (null == tXMusicPlayObserver) {
                    mMusicObserverMap.remove(TXAudioEffectManagerImpl.convertIdToInt64(TXAudioEffectManagerImpl.this.mIdType, n2));
                } else {
                    mMusicObserverMap.put(TXAudioEffectManagerImpl.convertIdToInt64(TXAudioEffectManagerImpl.this.mIdType, n2), tXMusicPlayObserver);
                }
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "setMusicObserver map count: %d", mMusicObserverMap.size());
            }
        };
        if (Looper.myLooper() == mMainHandler.getLooper()) {
            runnable.run();
        } else {
            mMainHandler.post(runnable);
        }
    }

    @Override
    public boolean startPlayMusic(TXAudioEffectManager.AudioMusicParam audioMusicParam) {
        long l2;
        TXCLog.i(TAG, "startPlay");
        long l3 = audioMusicParam.startTimeMS;
        long l4 = audioMusicParam.endTimeMS;
        if (l3 < 0L) {
            l3 = 0L;
        }
        if (l4 < 0L) {
            l4 = 0L;
        }
        if (!this.mPlayingMusicIDList.contains(l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, audioMusicParam.id))) {
            this.mPlayingMusicIDList.add(l2);
        }
        this.nativeStartPlayRange(l2, l3, l4);
        return this.nativeStartPlay(l2, audioMusicParam.path, audioMusicParam.loopCount, audioMusicParam.publish, audioMusicParam.isShortFile);
    }

    @Override
    public void stopPlayMusic(int n2) {
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2);
        this.mPlayingMusicIDList.remove(l2);
        this.nativeStopPlay(l2);
    }

    @Override
    public void pausePlayMusic(int n2) {
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2);
        this.mPlayingMusicIDList.remove(l2);
        this.nativePause(l2);
    }

    @Override
    public void resumePlayMusic(int n2) {
        long l2 = TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2);
        if (!this.mPlayingMusicIDList.contains(l2)) {
            this.mPlayingMusicIDList.add(l2);
        }
        this.nativeResume(l2);
    }

    public void interruptAllMusics() {
        TXCLog.i(TAG, "interruptAllMusics");
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativePause(l2);
        }
    }

    public void recoverAllMusics() {
        TXCLog.i(TAG, "recoverAllMusics");
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativeResume(l2);
        }
    }

    public void stopAllMusics() {
        TXCLog.i(TAG, "stopAllMusics");
        for (long l2 : this.mPlayingMusicIDList) {
            this.nativeStopPlay(l2);
            final long l3 = l2;
            mMainHandler.post(new Runnable(){

                @Override
                public void run() {
                    mMusicObserverMap.remove(l3);
                }
            });
        }
        this.mPlayingMusicIDList.clear();
    }

    public void setMusicVolume(int n2, int n3) {
        TXCLog.i(TAG, "setMusicVolume " + n3);
        this.nativeSetVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    @Override
    public void setMusicPublishVolume(int n2, int n3) {
        this.nativeSetPublishVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    @Override
    public void setMusicPlayoutVolume(int n2, int n3) {
        this.nativeSetPlayoutVolume(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    @Override
    public void setAllMusicVolume(int n2) {
        this.nativeSetAllVolume(n2);
    }

    @Override
    public void setMusicPitch(int n2, float f2) {
        this.nativeSetPitch(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), f2);
    }

    @Override
    public void setMusicSpeedRate(int n2, float f2) {
        this.nativeSetSpeedRate(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), f2);
    }

    public void setMusicPlayoutSpeedRate(int n2, float f2) {
        this.nativeSetPlayoutSpeedRate(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), f2);
    }

    public void setMusicChangerType(int n2, int n3) {
        this.nativeSetChangerType(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    public void setMusicReverbType(int n2, int n3) {
        this.nativeSetReverbType(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    @Override
    public long getMusicCurrentPosInMS(int n2) {
        return this.nativeGetCurrentPositionInMs(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2));
    }

    public void seekMusicToPosInBytes(int n2, long l2) {
        this.nativeSeekToPosition(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), l2);
    }

    @Override
    public void seekMusicToPosInMS(int n2, int n3) {
        this.nativeSeekToTime(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    public void setMuteDataDurationToPublish(int n2, int n3) {
        this.nativeSetMuteDataDurationToPublish(TXAudioEffectManagerImpl.convertIdToInt64(this.mIdType, n2), n3);
    }

    @Override
    public long getMusicDurationInMS(String string) {
        return TXAudioEffectManagerImpl.nativeGetDurationMSByPath(string);
    }

    public static void onEffectFinish(final long l2, final int n2) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "onEffectFinish -> effect id = " + l2 + ", errCode = " + n2);
                if (mMusicObserverMap.get(l2) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(l2)).onComplete((int)l2, n2);
                }
            }
        });
    }

    public static void onEffectStart(final long l2, final int n2) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                TXCLog.i(TXAudioEffectManagerImpl.TAG, "onEffectStart -> effect id = " + l2 + ", errCode = " + n2);
                if (mMusicObserverMap.get(l2) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(l2)).onStart((int)l2, n2);
                }
            }
        });
    }

    public static void onEffectProgress(final long l2, final long l3, final long l4) {
        mMainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (mMusicObserverMap.get(l2) != null) {
                    ((TXAudioEffectManager.TXMusicPlayObserver)mMusicObserverMap.get(l2)).onPlayProgress((int)l2, l3, l4);
                }
            }
        });
    }

    private static long convertIdToInt64(int n2, int n3) {
        long l2 = 0L;
        l2 = n2;
        l2 <<= 32;
        return l2 |= (long)n3;
    }

    private static native void nativeClassInit();

    private native boolean nativeStartPlay(long var1, String var3, int var4, boolean var5, boolean var6);

    private native void nativeStartPlayRange(long var1, long var3, long var5);

    private native void nativeStopPlay(long var1);

    private native void nativePause(long var1);

    private native void nativeResume(long var1);

    private native void nativeSetVolume(long var1, int var3);

    private native void nativeSetPlayoutVolume(long var1, int var3);

    private native void nativeSetPublishVolume(long var1, int var3);

    private native void nativeSetAllVolume(int var1);

    private native void nativeSetPitch(long var1, float var3);

    private native void nativeSetSpeedRate(long var1, float var3);

    private native void nativeSetPlayoutSpeedRate(long var1, float var3);

    private native void nativeSetChangerType(long var1, int var3);

    private native void nativeSetReverbType(long var1, int var3);

    private native void nativeSeekToTime(long var1, int var3);

    private native void nativeSeekToPosition(long var1, long var3);

    private native void nativeSetMuteDataDurationToPublish(long var1, int var3);

    private native long nativeGetCurrentPositionInMs(long var1);

    private static native long nativeGetDurationMSByPath(String var0);

    static {
        g.f();
        TXAudioEffectManagerImpl.nativeClassInit();
    }

    private static class AudioEffectManagerAutoCacheHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(1);

        private AudioEffectManagerAutoCacheHolder() {
        }
    }

    private static class AudioEffectManagerCacheHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(2);

        private AudioEffectManagerCacheHolder() {
        }
    }

    private static class AudioEffectManagerHolder {
        private static final TXAudioEffectManagerImpl INSTANCE = new TXAudioEffectManagerImpl(0);

        private AudioEffectManagerHolder() {
        }
    }
}

