/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player.misc;

import android.text.TextUtils;
import com.tencent.ijk.media.player.IjkMediaMeta;
import com.tencent.ijk.media.player.misc.IMediaFormat;
import com.tencent.ijk.media.player.misc.ITrackInfo;
import com.tencent.ijk.media.player.misc.IjkMediaFormat;

public class IjkTrackInfo
implements ITrackInfo {
    private int mTrackType = 0;
    private IjkMediaMeta.IjkStreamMeta mStreamMeta;

    public IjkTrackInfo(IjkMediaMeta.IjkStreamMeta ijkStreamMeta) {
        this.mStreamMeta = ijkStreamMeta;
    }

    public void setMediaMeta(IjkMediaMeta.IjkStreamMeta ijkStreamMeta) {
        this.mStreamMeta = ijkStreamMeta;
    }

    @Override
    public IMediaFormat getFormat() {
        return new IjkMediaFormat(this.mStreamMeta);
    }

    @Override
    public String getLanguage() {
        if (this.mStreamMeta == null || TextUtils.isEmpty((CharSequence)this.mStreamMeta.mLanguage)) {
            return "und";
        }
        return this.mStreamMeta.mLanguage;
    }

    @Override
    public int getTrackType() {
        return this.mTrackType;
    }

    public void setTrackType(int n2) {
        this.mTrackType = n2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.getInfoInline() + "}";
    }

    @Override
    public String getInfoInline() {
        StringBuilder stringBuilder = new StringBuilder(128);
        switch (this.mTrackType) {
            case 1: {
                stringBuilder.append("VIDEO");
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getCodecShortNameInline());
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getBitrateInline());
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getResolutionInline());
                break;
            }
            case 2: {
                stringBuilder.append("AUDIO");
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getCodecShortNameInline());
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getBitrateInline());
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.getSampleRateInline());
                break;
            }
            case 3: {
                stringBuilder.append("TIMEDTEXT");
                stringBuilder.append(", ");
                stringBuilder.append(this.mStreamMeta.mLanguage);
                break;
            }
            case 4: {
                stringBuilder.append("SUBTITLE");
                break;
            }
            default: {
                stringBuilder.append("UNKNOWN");
            }
        }
        return stringBuilder.toString();
    }
}

