/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player.misc;

import android.annotation.TargetApi;
import android.text.TextUtils;
import com.tencent.ijk.media.player.IjkMediaMeta;
import com.tencent.ijk.media.player.misc.IMediaFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class IjkMediaFormat
implements IMediaFormat {
    public static final String KEY_IJK_CODEC_LONG_NAME_UI = "ijk-codec-long-name-ui";
    public static final String KEY_IJK_CODEC_NAME_UI = "ijk-codec-name-ui";
    public static final String KEY_IJK_BIT_RATE_UI = "ijk-bit-rate-ui";
    public static final String KEY_IJK_CODEC_PROFILE_LEVEL_UI = "ijk-profile-level-ui";
    public static final String KEY_IJK_CODEC_PIXEL_FORMAT_UI = "ijk-pixel-format-ui";
    public static final String KEY_IJK_RESOLUTION_UI = "ijk-resolution-ui";
    public static final String KEY_IJK_FRAME_RATE_UI = "ijk-frame-rate-ui";
    public static final String KEY_IJK_SAMPLE_RATE_UI = "ijk-sample-rate-ui";
    public static final String KEY_IJK_CHANNEL_UI = "ijk-channel-ui";
    public static final String CODEC_NAME_H264 = "h264";
    public final IjkMediaMeta.IjkStreamMeta mMediaFormat;
    private static final Map<String, Formatter> sFormatterMap = new HashMap<String, Formatter>();

    public IjkMediaFormat(IjkMediaMeta.IjkStreamMeta ijkStreamMeta) {
        sFormatterMap.put(KEY_IJK_CODEC_LONG_NAME_UI, new Formatter(){

            @Override
            public String doFormat(IjkMediaFormat ijkMediaFormat) {
                return IjkMediaFormat.this.mMediaFormat.getString("codec_long_name");
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_NAME_UI, new Formatter(){

            @Override
            public String doFormat(IjkMediaFormat ijkMediaFormat) {
                return IjkMediaFormat.this.mMediaFormat.getString("codec_name");
            }
        });
        sFormatterMap.put(KEY_IJK_BIT_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                int n2 = ijkMediaFormat.getInteger("bitrate");
                if (n2 <= 0) {
                    return null;
                }
                if (n2 < 1000) {
                    return String.format(Locale.US, "%d bit/s", n2);
                }
                return String.format(Locale.US, "%d kb/s", n2 / 1000);
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_PROFILE_LEVEL_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                String string2;
                int n2 = ijkMediaFormat.getInteger("codec_profile_id");
                switch (n2) {
                    case 66: {
                        string2 = "Baseline";
                        break;
                    }
                    case 578: {
                        string2 = "Constrained Baseline";
                        break;
                    }
                    case 77: {
                        string2 = "Main";
                        break;
                    }
                    case 88: {
                        string2 = "Extended";
                        break;
                    }
                    case 100: {
                        string2 = "High";
                        break;
                    }
                    case 110: {
                        string2 = "High 10";
                        break;
                    }
                    case 2158: {
                        string2 = "High 10 Intra";
                        break;
                    }
                    case 122: {
                        string2 = "High 4:2:2";
                        break;
                    }
                    case 2170: {
                        string2 = "High 4:2:2 Intra";
                        break;
                    }
                    case 144: {
                        string2 = "High 4:4:4";
                        break;
                    }
                    case 244: {
                        string2 = "High 4:4:4 Predictive";
                        break;
                    }
                    case 2292: {
                        string2 = "High 4:4:4 Intra";
                        break;
                    }
                    case 44: {
                        string2 = "CAVLC 4:4:4";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                String string3 = ijkMediaFormat.getString("codec_name");
                if (!TextUtils.isEmpty((CharSequence)string3) && string3.equalsIgnoreCase(IjkMediaFormat.CODEC_NAME_H264)) {
                    int n3 = ijkMediaFormat.getInteger("codec_level");
                    if (n3 < 10) {
                        return stringBuilder.toString();
                    }
                    stringBuilder.append(" Profile Level ");
                    stringBuilder.append(n3 / 10 % 10);
                    if (n3 % 10 != 0) {
                        stringBuilder.append(".");
                        stringBuilder.append(n3 % 10);
                    }
                }
                return stringBuilder.toString();
            }
        });
        sFormatterMap.put(KEY_IJK_CODEC_PIXEL_FORMAT_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                return ijkMediaFormat.getString("codec_pixel_format");
            }
        });
        sFormatterMap.put(KEY_IJK_RESOLUTION_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                int n2 = ijkMediaFormat.getInteger("width");
                int n3 = ijkMediaFormat.getInteger("height");
                int n4 = ijkMediaFormat.getInteger("sar_num");
                int n5 = ijkMediaFormat.getInteger("sar_den");
                if (n2 <= 0 || n3 <= 0) {
                    return null;
                }
                if (n4 <= 0 || n5 <= 0) {
                    return String.format(Locale.US, "%d x %d", n2, n3);
                }
                return String.format(Locale.US, "%d x %d [SAR %d:%d]", n2, n3, n4, n5);
            }
        });
        sFormatterMap.put(KEY_IJK_FRAME_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                int n2 = ijkMediaFormat.getInteger("fps_num");
                int n3 = ijkMediaFormat.getInteger("fps_den");
                if (n2 <= 0 || n3 <= 0) {
                    return null;
                }
                return String.valueOf((float)n2 / (float)n3);
            }
        });
        sFormatterMap.put(KEY_IJK_SAMPLE_RATE_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                int n2 = ijkMediaFormat.getInteger("sample_rate");
                if (n2 <= 0) {
                    return null;
                }
                return String.format(Locale.US, "%d Hz", n2);
            }
        });
        sFormatterMap.put(KEY_IJK_CHANNEL_UI, new Formatter(){

            @Override
            protected String doFormat(IjkMediaFormat ijkMediaFormat) {
                int n2 = ijkMediaFormat.getInteger("channel_layout");
                if (n2 <= 0) {
                    return null;
                }
                if ((long)n2 == 4L) {
                    return "mono";
                }
                if ((long)n2 == 3L) {
                    return "stereo";
                }
                return String.format(Locale.US, "%x", n2);
            }
        });
        this.mMediaFormat = ijkStreamMeta;
    }

    @Override
    @TargetApi(value=16)
    public int getInteger(String string2) {
        if (this.mMediaFormat == null) {
            return 0;
        }
        return this.mMediaFormat.getInt(string2);
    }

    @Override
    public String getString(String string2) {
        if (this.mMediaFormat == null) {
            return null;
        }
        if (sFormatterMap.containsKey(string2)) {
            Formatter formatter = sFormatterMap.get(string2);
            return formatter.format(this);
        }
        return this.mMediaFormat.getString(string2);
    }

    private static abstract class Formatter {
        private Formatter() {
        }

        public String format(IjkMediaFormat ijkMediaFormat) {
            String string2 = this.doFormat(ijkMediaFormat);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return this.getDefaultString();
            }
            return string2;
        }

        protected abstract String doFormat(IjkMediaFormat var1);

        protected String getDefaultString() {
            return "N/A";
        }
    }
}

