/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player.misc;

import android.annotation.TargetApi;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.os.Build;
import com.tencent.ijk.media.player.misc.AndroidMediaFormat;
import com.tencent.ijk.media.player.misc.IMediaFormat;
import com.tencent.ijk.media.player.misc.ITrackInfo;

public class AndroidTrackInfo
implements ITrackInfo {
    private final MediaPlayer.TrackInfo mTrackInfo;

    public static AndroidTrackInfo[] fromMediaPlayer(MediaPlayer mediaPlayer) {
        if (Build.VERSION.SDK_INT >= 16) {
            return AndroidTrackInfo.fromTrackInfo(mediaPlayer.getTrackInfo());
        }
        return null;
    }

    private static AndroidTrackInfo[] fromTrackInfo(MediaPlayer.TrackInfo[] trackInfoArray) {
        if (trackInfoArray == null) {
            return null;
        }
        AndroidTrackInfo[] androidTrackInfoArray = new AndroidTrackInfo[trackInfoArray.length];
        for (int i2 = 0; i2 < trackInfoArray.length; ++i2) {
            androidTrackInfoArray[i2] = new AndroidTrackInfo(trackInfoArray[i2]);
        }
        return androidTrackInfoArray;
    }

    private AndroidTrackInfo(MediaPlayer.TrackInfo trackInfo) {
        this.mTrackInfo = trackInfo;
    }

    @Override
    @TargetApi(value=19)
    public IMediaFormat getFormat() {
        if (this.mTrackInfo == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        MediaFormat mediaFormat = this.mTrackInfo.getFormat();
        if (mediaFormat == null) {
            return null;
        }
        return new AndroidMediaFormat(mediaFormat);
    }

    @Override
    @TargetApi(value=16)
    public String getLanguage() {
        if (this.mTrackInfo == null) {
            return "und";
        }
        return this.mTrackInfo.getLanguage();
    }

    @Override
    @TargetApi(value=16)
    public int getTrackType() {
        if (this.mTrackInfo == null) {
            return 0;
        }
        return this.mTrackInfo.getTrackType();
    }

    @TargetApi(value=16)
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('{');
        if (this.mTrackInfo != null) {
            stringBuilder.append(this.mTrackInfo.toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    @TargetApi(value=16)
    public String getInfoInline() {
        if (this.mTrackInfo != null) {
            return this.mTrackInfo.toString();
        }
        return "null";
    }
}

