/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Rect;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.ijk.media.player.AbstractMediaPlayer;
import com.tencent.ijk.media.player.IMediaPlayer;
import com.tencent.ijk.media.player.IjkBitrateItem;
import com.tencent.ijk.media.player.IjkLibLoader;
import com.tencent.ijk.media.player.IjkMediaCodecInfo;
import com.tencent.ijk.media.player.IjkMediaMeta;
import com.tencent.ijk.media.player.IjkTimedText;
import com.tencent.ijk.media.player.MediaInfo;
import com.tencent.ijk.media.player.annotations.AccessedByNative;
import com.tencent.ijk.media.player.annotations.CalledByNative;
import com.tencent.ijk.media.player.misc.IAndroidIO;
import com.tencent.ijk.media.player.misc.IMediaDataSource;
import com.tencent.ijk.media.player.misc.IjkTrackInfo;
import com.tencent.ijk.media.player.pragma.DebugLog;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public final class IjkMediaPlayer
extends AbstractMediaPlayer {
    private static final String TAG = IjkMediaPlayer.class.getName();
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    private static final int MEDIA_HLS_KEY_ERROR = 210;
    private static final int MEDIA_HEVC_VIDEO_DECODER_ERROR = 211;
    private static final int MEDIA_VIDEO_DECODER_ERROR = 212;
    protected static final int MEDIA_SET_VIDEO_SAR = 10001;
    public static final int IJK_LOG_UNKNOWN = 0;
    public static final int IJK_LOG_DEFAULT = 1;
    public static final int IJK_LOG_VERBOSE = 2;
    public static final int IJK_LOG_DEBUG = 3;
    public static final int IJK_LOG_INFO = 4;
    public static final int IJK_LOG_WARN = 5;
    public static final int IJK_LOG_ERROR = 6;
    public static final int IJK_LOG_FATAL = 7;
    public static final int IJK_LOG_SILENT = 8;
    public static final int OPT_CATEGORY_FORMAT = 1;
    public static final int OPT_CATEGORY_CODEC = 2;
    public static final int OPT_CATEGORY_SWS = 3;
    public static final int OPT_CATEGORY_PLAYER = 4;
    public static final int SDL_FCC_YV12 = 842094169;
    public static final int SDL_FCC_RV16 = 909203026;
    public static final int SDL_FCC_RV32 = 842225234;
    public static final int PROP_FLOAT_VIDEO_DECODE_FRAMES_PER_SECOND = 10001;
    public static final int PROP_FLOAT_VIDEO_OUTPUT_FRAMES_PER_SECOND = 10002;
    public static final int FFP_PROP_FLOAT_PLAYBACK_RATE = 10003;
    public static final int FFP_PROP_FLOAT_AVDELAY = 10004;
    public static final int FFP_PROP_FLOAT_AVDIFF = 10005;
    public static final int FFP_PROP_FLOAT_DROP_FRAME_RATE = 10007;
    public static final int FFP_PROP_INT64_SELECTED_VIDEO_STREAM = 20001;
    public static final int FFP_PROP_INT64_SELECTED_AUDIO_STREAM = 20002;
    public static final int FFP_PROP_INT64_SELECTED_TIMEDTEXT_STREAM = 20011;
    public static final int FFP_PROP_INT64_VIDEO_DECODER = 20003;
    public static final int FFP_PROP_INT64_AUDIO_DECODER = 20004;
    public static final int FFP_PROPV_DECODER_UNKNOWN = 0;
    public static final int FFP_PROPV_DECODER_AVCODEC = 1;
    public static final int FFP_PROPV_DECODER_MEDIACODEC = 2;
    public static final int FFP_PROPV_DECODER_VIDEOTOOLBOX = 3;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_DURATION = 20005;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_DURATION = 20006;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_BYTES = 20007;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_BYTES = 20008;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_PACKETS = 20009;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_PACKETS = 20010;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_BACKWARDS = 20201;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_FORWARDS = 20202;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_CAPACITY = 20203;
    public static final int FFP_PROP_INT64_TRAFFIC_STATISTIC_BYTE_COUNT = 20204;
    public static final int FFP_PROP_INT64_CACHE_STATISTIC_PHYSICAL_POS = 20205;
    public static final int FFP_PROP_INT64_CACHE_STATISTIC_FILE_FORWARDS = 20206;
    public static final int FFP_PROP_INT64_CACHE_STATISTIC_FILE_POS = 20207;
    public static final int FFP_PROP_INT64_CACHE_STATISTIC_COUNT_BYTES = 20208;
    public static final int FFP_PROP_INT64_LOGICAL_FILE_SIZE = 20209;
    public static final int FFP_PROP_INT64_BIT_RATE = 20100;
    public static final int FFP_PROP_INT64_TCP_SPEED = 20200;
    public static final int FFP_PROP_INT64_LATEST_SEEK_LOAD_DURATION = 20300;
    @AccessedByNative
    private long mNativeMediaPlayer;
    @AccessedByNative
    private long mNativeMediaDataSource;
    @AccessedByNative
    private long mNativeAndroidIO;
    @AccessedByNative
    private int mNativeSurfaceTexture;
    @AccessedByNative
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private String mDataSource;
    private Surface mSurface;
    private int mBitrateIndex;
    private static final IjkLibLoader sLocalLibLoader = new IjkLibLoader(){

        @Override
        public void loadLibrary(String string2) throws UnsatisfiedLinkError, SecurityException {
            System.loadLibrary(string2);
        }
    };
    private static volatile boolean mIsLibLoaded = false;
    private static volatile boolean mIsNativeInitialized = false;
    private OnControlMessageListener mOnControlMessageListener;
    private OnNativeInvokeListener mOnNativeInvokeListener;
    private OnMediaCodecSelectListener mOnMediaCodecSelectListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrariesOnce(IjkLibLoader ijkLibLoader) {
        Class<IjkMediaPlayer> clazz = IjkMediaPlayer.class;
        synchronized (IjkMediaPlayer.class) {
            if (!mIsLibLoaded) {
                if (ijkLibLoader == null) {
                    ijkLibLoader = sLocalLibLoader;
                }
                ijkLibLoader.loadLibrary("txffmpeg");
                ijkLibLoader.loadLibrary("txsdl");
                ijkLibLoader.loadLibrary("txplayer");
                mIsLibLoaded = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNativeOnce() {
        Class<IjkMediaPlayer> clazz = IjkMediaPlayer.class;
        synchronized (IjkMediaPlayer.class) {
            if (!mIsNativeInitialized) {
                IjkMediaPlayer.native_init();
                mIsNativeInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public IjkMediaPlayer() {
        this(sLocalLibLoader);
    }

    public IjkMediaPlayer(IjkLibLoader ijkLibLoader) {
        this.initPlayer(ijkLibLoader);
    }

    private void initPlayer(IjkLibLoader ijkLibLoader) {
        IjkMediaPlayer.loadLibrariesOnce(ijkLibLoader);
        IjkMediaPlayer.initNativeOnce();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<IjkMediaPlayer>(this));
    }

    private native void _setFrameAtTime(String var1, long var2, long var4, int var6, int var7) throws IllegalArgumentException, IllegalStateException;

    private native void _setVideoSurface(Surface var1);

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        this.mSurfaceHolder = surfaceHolder;
        Surface surface = surfaceHolder != null ? surfaceHolder.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            DebugLog.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
        this.mSurface = surface;
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=14)
    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String string2 = uri.getScheme();
        if ("file".equals(string2)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(string2) && "settings".equals(uri.getAuthority()) && (uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)RingtoneManager.getDefaultType((Uri)uri))) == null) {
            throw new FileNotFoundException("Failed to resolve default ringtone");
        }
        try (AssetFileDescriptor assetFileDescriptor = null;){
            ContentResolver contentResolver = context.getContentResolver();
            assetFileDescriptor = contentResolver.openAssetFileDescriptor(uri, "r");
            if (assetFileDescriptor == null) {
                return;
            }
            if (assetFileDescriptor.getDeclaredLength() < 0L) {
                this.setDataSource(assetFileDescriptor.getFileDescriptor());
            } else {
                this.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getDeclaredLength());
            }
            return;
        }
        Log.d((String)TAG, (String)"Couldn't open file on client side, trying server side");
        this.setDataSource(uri.toString(), map);
    }

    @Override
    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = string2;
        this._setDataSource(string2, null, null);
    }

    public void setDataSource(String string2, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (map != null && !map.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey());
                stringBuilder.append(":");
                String string3 = entry.getValue();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    stringBuilder.append(entry.getValue());
                }
                stringBuilder.append("\r\n");
                this.setOption(1, "headers", stringBuilder.toString());
                this.setOption(1, "protocol_whitelist", "async,cache,crypto,file,http,https,ijkhttphook,ijkinject,ijklivehook,ijklongurl,ijksegment,ijktcphook,pipe,rtp,tcp,tls,udp,ijkurlhook,data,ijkhttpcache,ijklongurl");
            }
        }
        this.setDataSource(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=13)
    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 12) {
            int n2 = -1;
            try {
                Field field = fileDescriptor.getClass().getDeclaredField("descriptor");
                field.setAccessible(true);
                n2 = field.getInt(fileDescriptor);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            this._setDataSourceFd(n2);
        } else {
            try (ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.dup((FileDescriptor)fileDescriptor);){
                this._setDataSourceFd(parcelFileDescriptor.getFd());
            }
        }
    }

    private void setDataSource(FileDescriptor fileDescriptor, long l2, long l3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fileDescriptor);
    }

    @Override
    public void setDataSource(IMediaDataSource iMediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(iMediaDataSource);
    }

    public void setAndroidIOCallback(IAndroidIO iAndroidIO) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setAndroidIOCallback(iAndroidIO);
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSourceFd(int var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSource(IMediaDataSource var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setAndroidIOCallback(IAndroidIO var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _injectCacheNode(int var1, long var2, long var4, long var6, long var8);

    public void injectCacheNode(int n2, long l2, long l3, long l4, long l5) {
        this._injectCacheNode(n2, l2, l3, l4, l5);
    }

    @Override
    public String getDataSource() {
        return this.mDataSource;
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        this._prepareAsync();
    }

    public native void _prepareAsync() throws IllegalStateException;

    @Override
    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    @Override
    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private native void _stop() throws IllegalStateException;

    @Override
    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    @Override
    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int n2) {
        boolean bl = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                bl = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(n2 | 0x20000000, IjkMediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (bl) {
            this.mWakeLock.acquire();
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        if (this.mScreenOnWhilePlaying != bl) {
            if (bl && this.mSurfaceHolder == null) {
                DebugLog.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = bl;
            this.updateSurfaceScreenOn();
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean bl) {
        if (this.mWakeLock != null) {
            if (bl && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!bl && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = bl;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public IjkTrackInfo[] getTrackInfo() {
        Bundle bundle = this.getMediaMeta();
        if (bundle == null) {
            return null;
        }
        IjkMediaMeta ijkMediaMeta = IjkMediaMeta.parse(bundle);
        if (ijkMediaMeta == null || ijkMediaMeta.mStreams == null) {
            return null;
        }
        ArrayList<IjkTrackInfo> arrayList = new ArrayList<IjkTrackInfo>();
        for (IjkMediaMeta.IjkStreamMeta ijkStreamMeta : ijkMediaMeta.mStreams) {
            IjkTrackInfo ijkTrackInfo = new IjkTrackInfo(ijkStreamMeta);
            if (ijkStreamMeta.mType.equalsIgnoreCase("video")) {
                ijkTrackInfo.setTrackType(1);
            } else if (ijkStreamMeta.mType.equalsIgnoreCase("audio")) {
                ijkTrackInfo.setTrackType(2);
            } else if (ijkStreamMeta.mType.equalsIgnoreCase("timedtext")) {
                ijkTrackInfo.setTrackType(3);
            }
            arrayList.add(ijkTrackInfo);
        }
        return arrayList.toArray(new IjkTrackInfo[arrayList.size()]);
    }

    public int getSelectedTrack(int n2) {
        switch (n2) {
            case 1: {
                return (int)this._getPropertyLong(20001, -1L);
            }
            case 2: {
                return (int)this._getPropertyLong(20002, -1L);
            }
            case 3: {
                return (int)this._getPropertyLong(20011, -1L);
            }
        }
        return -1;
    }

    public void selectTrack(int n2) {
        this._setStreamSelected(n2, true);
    }

    public void deselectTrack(int n2) {
        this._setStreamSelected(n2, false);
    }

    private native void _setStreamSelected(int var1, boolean var2);

    @Override
    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    @Override
    public int getVideoSarNum() {
        return this.mVideoSarNum;
    }

    @Override
    public int getVideoSarDen() {
        return this.mVideoSarDen;
    }

    @Override
    public native boolean isPlaying();

    @Override
    public native void seekTo(long var1) throws IllegalStateException;

    @Override
    public native long getCurrentPosition();

    @Override
    public native long getDuration();

    @Override
    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.resetListeners();
        new Thread(new Runnable(){

            @Override
            public void run() {
                IjkMediaPlayer.this._release();
            }
        }).start();
    }

    private native void _release();

    @Override
    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    private native void _reset();

    @Override
    public void setLooping(boolean bl) {
        int n2 = bl ? 0 : 1;
        this.setOption(4, "loop", n2);
        this._setLoopCount(n2);
    }

    private native void _setLoopCount(int var1);

    @Override
    public boolean isLooping() {
        int n2 = this._getLoopCount();
        return n2 != 1;
    }

    private native int _getLoopCount();

    public void setSpeed(float f2) {
        this._setPropertyFloat(10003, f2);
    }

    public float getSpeed() {
        return this._getPropertyFloat(10003, 0.0f);
    }

    public int getVideoDecoder() {
        return (int)this._getPropertyLong(20003, 0L);
    }

    public float getVideoOutputFramesPerSecond() {
        return this._getPropertyFloat(10002, 0.0f);
    }

    public float getVideoDecodeFramesPerSecond() {
        return this._getPropertyFloat(10001, 0.0f);
    }

    public long getVideoCachedDuration() {
        return this._getPropertyLong(20005, 0L);
    }

    public long getAudioCachedDuration() {
        return this._getPropertyLong(20006, 0L);
    }

    public long getVideoCachedBytes() {
        return this._getPropertyLong(20007, 0L);
    }

    public long getAudioCachedBytes() {
        return this._getPropertyLong(20008, 0L);
    }

    public long getVideoCachedPackets() {
        return this._getPropertyLong(20009, 0L);
    }

    public long getAudioCachedPackets() {
        return this._getPropertyLong(20010, 0L);
    }

    public long getAsyncStatisticBufBackwards() {
        return this._getPropertyLong(20201, 0L);
    }

    public long getAsyncStatisticBufForwards() {
        return this._getPropertyLong(20202, 0L);
    }

    public long getAsyncStatisticBufCapacity() {
        return this._getPropertyLong(20203, 0L);
    }

    public long getTrafficStatisticByteCount() {
        return this._getPropertyLong(20204, 0L);
    }

    public long getCacheStatisticPhysicalPos() {
        return this._getPropertyLong(20205, 0L);
    }

    public long getCacheStatisticFileForwards() {
        return this._getPropertyLong(20206, 0L);
    }

    public long getCacheStatisticFilePos() {
        return this._getPropertyLong(20207, 0L);
    }

    public long getCacheStatisticCountBytes() {
        return this._getPropertyLong(20208, 0L);
    }

    public long getFileSize() {
        return this._getPropertyLong(20209, 0L);
    }

    public long getBitRate() {
        return this._getPropertyLong(20100, 0L);
    }

    public float getAVDelay() {
        return this._getPropertyFloat(10004, 0.0f);
    }

    public float getAVDiff() {
        return this._getPropertyFloat(10005, 0.0f);
    }

    public long getTcpSpeed() {
        return this._getPropertyLong(20200, 0L);
    }

    public long getSeekLoadDuration() {
        return this._getPropertyLong(20300, 0L);
    }

    private native float _getPropertyFloat(int var1, float var2);

    private native void _setPropertyFloat(int var1, float var2);

    private native long _getPropertyLong(int var1, long var2);

    private native void _setPropertyLong(int var1, long var2);

    public float getDropFrameRate() {
        return this._getPropertyFloat(10007, 0.0f);
    }

    @Override
    public void setRate(float f2) {
        this.setSpeed(f2);
    }

    @Override
    public float getRate() {
        return this.getSpeed();
    }

    @Override
    public native void setVolume(float var1, float var2);

    @Override
    public void setAudioVolume(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 100) {
            n2 = 100;
        }
        this._setAudioVolume(n2);
    }

    @Override
    public native int getAudioSessionId();

    @Override
    public MediaInfo getMediaInfo() {
        String[] stringArray;
        MediaInfo mediaInfo = new MediaInfo();
        mediaInfo.mMediaPlayerName = "ijkplayer";
        String string2 = this._getVideoCodecInfo();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringArray = string2.split(",");
            if (stringArray.length >= 2) {
                mediaInfo.mVideoDecoder = stringArray[0];
                mediaInfo.mVideoDecoderImpl = stringArray[1];
            } else if (stringArray.length >= 1) {
                mediaInfo.mVideoDecoder = stringArray[0];
                mediaInfo.mVideoDecoderImpl = "";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(stringArray = this._getAudioCodecInfo()))) {
            String[] stringArray2 = stringArray.split(",");
            if (stringArray2.length >= 2) {
                mediaInfo.mAudioDecoder = stringArray2[0];
                mediaInfo.mAudioDecoderImpl = stringArray2[1];
            } else if (stringArray2.length >= 1) {
                mediaInfo.mAudioDecoder = stringArray2[0];
                mediaInfo.mAudioDecoderImpl = "";
            }
        }
        try {
            mediaInfo.mMeta = IjkMediaMeta.parse(this._getMediaMeta());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return mediaInfo;
    }

    @Override
    public void setLogEnabled(boolean bl) {
    }

    @Override
    public boolean isPlayable() {
        return true;
    }

    private native String _getVideoCodecInfo();

    private native String _getAudioCodecInfo();

    public void setOption(int n2, String string2, String string3) {
        this._setOption(n2, string2, string3);
    }

    public void setOption(int n2, String string2, long l2) {
        this._setOption(n2, string2, l2);
    }

    private native void _setOption(int var1, String var2, String var3);

    private native void _setOption(int var1, String var2, long var3);

    public Bundle getMediaMeta() {
        return this._getMediaMeta();
    }

    private native Bundle _getMediaMeta();

    public static String getColorFormatName(int n2) {
        return IjkMediaPlayer._getColorFormatName(n2);
    }

    private static native String _getColorFormatName(int var0);

    @Override
    public void setAudioStreamType(int n2) {
    }

    @Override
    public void setKeepInBackground(boolean bl) {
    }

    private static native void native_init();

    private native void native_setup(Object var1);

    private native void native_finalize();

    private native void native_message_loop(Object var1);

    protected void finalize() throws Throwable {
        super.finalize();
        this.native_finalize();
    }

    @CalledByNative
    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        if (object == null) {
            return;
        }
        IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)((WeakReference)object).get();
        if (ijkMediaPlayer == null) {
            return;
        }
        if (n2 == 200 && n3 == 2) {
            ijkMediaPlayer.start();
        }
        if (ijkMediaPlayer.mEventHandler != null) {
            Message message = ijkMediaPlayer.mEventHandler.obtainMessage(n2, n3, n4, object2);
            ijkMediaPlayer.mEventHandler.sendMessage(message);
        }
    }

    public void setOnControlMessageListener(OnControlMessageListener onControlMessageListener) {
        this.mOnControlMessageListener = onControlMessageListener;
    }

    public void setOnNativeInvokeListener(OnNativeInvokeListener onNativeInvokeListener) {
        this.mOnNativeInvokeListener = onNativeInvokeListener;
    }

    @CalledByNative
    private static boolean onNativeInvoke(Object object, int n2, Bundle bundle) {
        if (object == null || !(object instanceof WeakReference)) {
            throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        }
        WeakReference weakReference = (WeakReference)object;
        IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)weakReference.get();
        if (ijkMediaPlayer == null) {
            throw new IllegalStateException("<null weakPlayer>.onNativeInvoke()");
        }
        OnNativeInvokeListener onNativeInvokeListener = ijkMediaPlayer.mOnNativeInvokeListener;
        if (onNativeInvokeListener != null && onNativeInvokeListener.onNativeInvoke(n2, bundle)) {
            return true;
        }
        switch (n2) {
            case 131079: {
                OnControlMessageListener onControlMessageListener = ijkMediaPlayer.mOnControlMessageListener;
                if (onControlMessageListener == null) {
                    return false;
                }
                int n3 = bundle.getInt("segment_index", -1);
                if (n3 < 0) {
                    throw new InvalidParameterException("onNativeInvoke(invalid segment index)");
                }
                String string2 = onControlMessageListener.onControlResolveSegmentUrl(n3);
                if (string2 == null) {
                    throw new RuntimeException(new IOException("onNativeInvoke() = <NULL newUrl>"));
                }
                bundle.putString("url", string2);
                return true;
            }
        }
        return false;
    }

    public void setOnMediaCodecSelectListener(OnMediaCodecSelectListener onMediaCodecSelectListener) {
        this.mOnMediaCodecSelectListener = onMediaCodecSelectListener;
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.mOnMediaCodecSelectListener = null;
    }

    @CalledByNative
    private static String onSelectCodec(Object object, String string2, int n2, int n3) {
        if (object == null || !(object instanceof WeakReference)) {
            return null;
        }
        WeakReference weakReference = (WeakReference)object;
        IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)weakReference.get();
        if (ijkMediaPlayer == null) {
            return null;
        }
        OnMediaCodecSelectListener onMediaCodecSelectListener = ijkMediaPlayer.mOnMediaCodecSelectListener;
        if (onMediaCodecSelectListener == null) {
            onMediaCodecSelectListener = DefaultMediaCodecSelector.sInstance;
        }
        return onMediaCodecSelectListener.onMediaCodecSelect(ijkMediaPlayer, string2, n2, n3);
    }

    public static native void native_profileBegin(String var0);

    public static native void native_profileEnd();

    public static native void native_setLogLevel(int var0);

    @Override
    public int getBitrateIndex() {
        return this.mBitrateIndex;
    }

    @Override
    public void setBitrateIndex(int n2) {
        this.mBitrateIndex = n2;
        this._set_bitrate_index(n2);
    }

    @Override
    public ArrayList<IjkBitrateItem> getSupportedBitrates() {
        return this.getMediaInfo().mMeta.mBitrateItems;
    }

    public native void _set_bitrate_index(int var1);

    private native void _setAudioVolume(int var1);

    public static class DefaultMediaCodecSelector
    implements OnMediaCodecSelectListener {
        public static final DefaultMediaCodecSelector sInstance = new DefaultMediaCodecSelector();

        @Override
        @TargetApi(value=16)
        public String onMediaCodecSelect(IMediaPlayer iMediaPlayer, String string2, int n2, int n3) {
            if (Build.VERSION.SDK_INT < 16) {
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Log.i((String)TAG, (String)String.format(Locale.US, "onSelectCodec: mime=%s, profile=%d, level=%d", string2, n2, n3));
            ArrayList<IjkMediaCodecInfo> arrayList = new ArrayList<IjkMediaCodecInfo>();
            int n4 = MediaCodecList.getCodecCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                String[] stringArray2;
                MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
                Log.d((String)TAG, (String)String.format(Locale.US, "  found codec: %s", mediaCodecInfo.getName()));
                if (mediaCodecInfo.isEncoder() || (stringArray2 = mediaCodecInfo.getSupportedTypes()) == null) continue;
                for (String string3 : stringArray2) {
                    IjkMediaCodecInfo ijkMediaCodecInfo;
                    if (TextUtils.isEmpty((CharSequence)string3)) continue;
                    Log.d((String)TAG, (String)String.format(Locale.US, "    mime: %s", string3));
                    if (!string3.equalsIgnoreCase(string2) || (ijkMediaCodecInfo = IjkMediaCodecInfo.setupCandidate(mediaCodecInfo, string2)) == null) continue;
                    arrayList.add(ijkMediaCodecInfo);
                    Log.i((String)TAG, (String)String.format(Locale.US, "candidate codec: %s rank=%d", mediaCodecInfo.getName(), ijkMediaCodecInfo.mRank));
                    ijkMediaCodecInfo.dumpProfileLevels(string2);
                }
            }
            if (arrayList.isEmpty()) {
                return null;
            }
            IjkMediaCodecInfo stringArray = (IjkMediaCodecInfo)arrayList.get(0);
            for (IjkMediaCodecInfo ijkMediaCodecInfo : arrayList) {
                if (ijkMediaCodecInfo.mRank <= stringArray.mRank) continue;
                stringArray = ijkMediaCodecInfo;
            }
            if (stringArray.mRank < 600) {
                Log.w((String)TAG, (String)String.format(Locale.US, "unaccetable codec: %s", stringArray.mCodecInfo.getName()));
                return null;
            }
            Log.i((String)TAG, (String)String.format(Locale.US, "selected codec: %s rank=%d", stringArray.mCodecInfo.getName(), stringArray.mRank));
            return stringArray.mCodecInfo.getName();
        }
    }

    public static interface OnMediaCodecSelectListener {
        public String onMediaCodecSelect(IMediaPlayer var1, String var2, int var3, int var4);
    }

    public static interface OnNativeInvokeListener {
        public static final int CTRL_WILL_TCP_OPEN = 131073;
        public static final int CTRL_DID_TCP_OPEN = 131074;
        public static final int CTRL_WILL_HTTP_OPEN = 131075;
        public static final int CTRL_WILL_LIVE_OPEN = 131077;
        public static final int CTRL_WILL_CONCAT_RESOLVE_SEGMENT = 131079;
        public static final int EVENT_WILL_HTTP_OPEN = 1;
        public static final int EVENT_DID_HTTP_OPEN = 2;
        public static final int EVENT_WILL_HTTP_SEEK = 3;
        public static final int EVENT_DID_HTTP_SEEK = 4;
        public static final int CTRL_WILL_DNS_RESOLVE = 131105;
        public static final int CTRL_DID_DNS_RESOLVE = 131106;
        public static final String ARG_URL = "url";
        public static final String ARG_SEGMENT_INDEX = "segment_index";
        public static final String ARG_RETRY_COUNTER = "retry_counter";
        public static final String ARG_ERROR = "error";
        public static final String ARG_FAMILIY = "family";
        public static final String ARG_IP = "ip";
        public static final String ARG_PORT = "port";
        public static final String ARG_FD = "fd";
        public static final String ARG_OFFSET = "offset";
        public static final String ARG_HTTP_CODE = "http_code";

        public boolean onNativeInvoke(int var1, Bundle var2);
    }

    public static interface OnControlMessageListener {
        public String onControlResolveSegmentUrl(int var1);
    }

    private static class EventHandler
    extends Handler {
        private final WeakReference<IjkMediaPlayer> mWeakPlayer;

        public EventHandler(IjkMediaPlayer ijkMediaPlayer, Looper looper) {
            super(looper);
            this.mWeakPlayer = new WeakReference<IjkMediaPlayer>(ijkMediaPlayer);
        }

        public void handleMessage(Message message) {
            IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer)this.mWeakPlayer.get();
            if (ijkMediaPlayer == null || ijkMediaPlayer.mNativeMediaPlayer == 0L) {
                DebugLog.w(TAG, "IjkMediaPlayer went away with unhandled events");
                return;
            }
            switch (message.what) {
                case 1: {
                    ijkMediaPlayer.notifyOnPrepared();
                    return;
                }
                case 2: {
                    ijkMediaPlayer.stayAwake(false);
                    ijkMediaPlayer.notifyOnCompletion();
                    return;
                }
                case 3: {
                    long l2 = message.arg1;
                    if (l2 < 0L) {
                        l2 = 0L;
                    }
                    long l3 = 0L;
                    long l4 = ijkMediaPlayer.getDuration();
                    if (l4 > 0L) {
                        l3 = l2 * 100L / l4;
                    }
                    if (l3 >= 100L) {
                        l3 = 100L;
                    }
                    ijkMediaPlayer.notifyOnBufferingUpdate((int)l3);
                    return;
                }
                case 4: {
                    ijkMediaPlayer.notifyOnSeekComplete();
                    return;
                }
                case 5: {
                    ijkMediaPlayer.mVideoWidth = message.arg1;
                    ijkMediaPlayer.mVideoHeight = message.arg2;
                    ijkMediaPlayer.notifyOnVideoSizeChanged(ijkMediaPlayer.mVideoWidth, ijkMediaPlayer.mVideoHeight, ijkMediaPlayer.mVideoSarNum, ijkMediaPlayer.mVideoSarDen);
                    return;
                }
                case 100: {
                    DebugLog.e(TAG, "Error (" + message.arg1 + "," + message.arg2 + ")");
                    if (!ijkMediaPlayer.notifyOnError(message.arg1, message.arg2)) {
                        ijkMediaPlayer.notifyOnCompletion();
                    }
                    ijkMediaPlayer.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (message.arg1) {
                        case 3: {
                            DebugLog.i(TAG, "Info: MEDIA_INFO_VIDEO_RENDERING_START\n");
                        }
                    }
                    ijkMediaPlayer.notifyOnInfo(message.arg1, message.arg2);
                    return;
                }
                case 99: {
                    if (message.obj == null) {
                        ijkMediaPlayer.notifyOnTimedText(null);
                    } else {
                        IjkTimedText ijkTimedText = new IjkTimedText(new Rect(0, 0, 1, 1), (String)message.obj);
                        ijkMediaPlayer.notifyOnTimedText(ijkTimedText);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                case 10001: {
                    ijkMediaPlayer.mVideoSarNum = message.arg1;
                    ijkMediaPlayer.mVideoSarDen = message.arg2;
                    ijkMediaPlayer.notifyOnVideoSizeChanged(ijkMediaPlayer.mVideoWidth, ijkMediaPlayer.mVideoHeight, ijkMediaPlayer.mVideoSarNum, ijkMediaPlayer.mVideoSarDen);
                    break;
                }
                case 210: {
                    ijkMediaPlayer.notifyHLSKeyError();
                    break;
                }
                case 211: {
                    ijkMediaPlayer.notifyHevcVideoDecoderError();
                    break;
                }
                case 212: {
                    ijkMediaPlayer.notifyVideoDecoderError();
                    break;
                }
                default: {
                    DebugLog.e(TAG, "Unknown message type " + message.what);
                }
            }
        }
    }
}

