/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player;

import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.ijk.media.player.IjkBitrateItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class IjkMediaMeta {
    public static final String IJKM_KEY_FORMAT = "format";
    public static final String IJKM_KEY_DURATION_US = "duration_us";
    public static final String IJKM_KEY_START_US = "start_us";
    public static final String IJKM_KEY_BITRATE = "bitrate";
    public static final String IJKM_KEY_VIDEO_STREAM = "video";
    public static final String IJKM_KEY_AUDIO_STREAM = "audio";
    public static final String IJKM_KEY_TIMEDTEXT_STREAM = "timedtext";
    public static final String IJKM_KEY_TYPE = "type";
    public static final String IJKM_VAL_TYPE__VIDEO = "video";
    public static final String IJKM_VAL_TYPE__AUDIO = "audio";
    public static final String IJKM_VAL_TYPE__TIMEDTEXT = "timedtext";
    public static final String IJKM_VAL_TYPE__UNKNOWN = "unknown";
    public static final String IJKM_KEY_LANGUAGE = "language";
    public static final String IJKM_KEY_CODEC_NAME = "codec_name";
    public static final String IJKM_KEY_CODEC_PROFILE = "codec_profile";
    public static final String IJKM_KEY_CODEC_LEVEL = "codec_level";
    public static final String IJKM_KEY_CODEC_LONG_NAME = "codec_long_name";
    public static final String IJKM_KEY_CODEC_PIXEL_FORMAT = "codec_pixel_format";
    public static final String IJKM_KEY_CODEC_PROFILE_ID = "codec_profile_id";
    public static final String IJKM_KEY_WIDTH = "width";
    public static final String IJKM_KEY_HEIGHT = "height";
    public static final String IJKM_KEY_FPS_NUM = "fps_num";
    public static final String IJKM_KEY_FPS_DEN = "fps_den";
    public static final String IJKM_KEY_TBR_NUM = "tbr_num";
    public static final String IJKM_KEY_TBR_DEN = "tbr_den";
    public static final String IJKM_KEY_SAR_NUM = "sar_num";
    public static final String IJKM_KEY_SAR_DEN = "sar_den";
    public static final String IJKM_KEY_BITRATE_INDEX = "bitrate_index";
    public static final String IJKM_KEY_SAMPLE_RATE = "sample_rate";
    public static final String IJKM_KEY_CHANNEL_LAYOUT = "channel_layout";
    public static final String IJKM_KEY_STREAMS = "streams";
    public static final String IJKM_KEY_PROGRAMS = "programs";
    public static final String IJKM_KEY_M3U8 = "m3u8";
    public static final long AV_CH_FRONT_LEFT = 1L;
    public static final long AV_CH_FRONT_RIGHT = 2L;
    public static final long AV_CH_FRONT_CENTER = 4L;
    public static final long AV_CH_LOW_FREQUENCY = 8L;
    public static final long AV_CH_BACK_LEFT = 16L;
    public static final long AV_CH_BACK_RIGHT = 32L;
    public static final long AV_CH_FRONT_LEFT_OF_CENTER = 64L;
    public static final long AV_CH_FRONT_RIGHT_OF_CENTER = 128L;
    public static final long AV_CH_BACK_CENTER = 256L;
    public static final long AV_CH_SIDE_LEFT = 512L;
    public static final long AV_CH_SIDE_RIGHT = 1024L;
    public static final long AV_CH_TOP_CENTER = 2048L;
    public static final long AV_CH_TOP_FRONT_LEFT = 4096L;
    public static final long AV_CH_TOP_FRONT_CENTER = 8192L;
    public static final long AV_CH_TOP_FRONT_RIGHT = 16384L;
    public static final long AV_CH_TOP_BACK_LEFT = 32768L;
    public static final long AV_CH_TOP_BACK_CENTER = 65536L;
    public static final long AV_CH_TOP_BACK_RIGHT = 131072L;
    public static final long AV_CH_STEREO_LEFT = 0x20000000L;
    public static final long AV_CH_STEREO_RIGHT = 0x40000000L;
    public static final long AV_CH_WIDE_LEFT = 0x80000000L;
    public static final long AV_CH_WIDE_RIGHT = 0x100000000L;
    public static final long AV_CH_SURROUND_DIRECT_LEFT = 0x200000000L;
    public static final long AV_CH_SURROUND_DIRECT_RIGHT = 0x400000000L;
    public static final long AV_CH_LOW_FREQUENCY_2 = 0x800000000L;
    public static final long AV_CH_LAYOUT_MONO = 4L;
    public static final long AV_CH_LAYOUT_STEREO = 3L;
    public static final long AV_CH_LAYOUT_2POINT1 = 11L;
    public static final long AV_CH_LAYOUT_2_1 = 259L;
    public static final long AV_CH_LAYOUT_SURROUND = 7L;
    public static final long AV_CH_LAYOUT_3POINT1 = 15L;
    public static final long AV_CH_LAYOUT_4POINT0 = 263L;
    public static final long AV_CH_LAYOUT_4POINT1 = 271L;
    public static final long AV_CH_LAYOUT_2_2 = 1539L;
    public static final long AV_CH_LAYOUT_QUAD = 51L;
    public static final long AV_CH_LAYOUT_5POINT0 = 1543L;
    public static final long AV_CH_LAYOUT_5POINT1 = 1551L;
    public static final long AV_CH_LAYOUT_5POINT0_BACK = 55L;
    public static final long AV_CH_LAYOUT_5POINT1_BACK = 63L;
    public static final long AV_CH_LAYOUT_6POINT0 = 1799L;
    public static final long AV_CH_LAYOUT_6POINT0_FRONT = 1731L;
    public static final long AV_CH_LAYOUT_HEXAGONAL = 311L;
    public static final long AV_CH_LAYOUT_6POINT1 = 1807L;
    public static final long AV_CH_LAYOUT_6POINT1_BACK = 319L;
    public static final long AV_CH_LAYOUT_6POINT1_FRONT = 1739L;
    public static final long AV_CH_LAYOUT_7POINT0 = 1591L;
    public static final long AV_CH_LAYOUT_7POINT0_FRONT = 1735L;
    public static final long AV_CH_LAYOUT_7POINT1 = 1599L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE = 1743L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE_BACK = 255L;
    public static final long AV_CH_LAYOUT_OCTAGONAL = 1847L;
    public static final long AV_CH_LAYOUT_STEREO_DOWNMIX = 0x60000000L;
    public static final int FF_PROFILE_H264_CONSTRAINED = 512;
    public static final int FF_PROFILE_H264_INTRA = 2048;
    public static final int FF_PROFILE_H264_BASELINE = 66;
    public static final int FF_PROFILE_H264_CONSTRAINED_BASELINE = 578;
    public static final int FF_PROFILE_H264_MAIN = 77;
    public static final int FF_PROFILE_H264_EXTENDED = 88;
    public static final int FF_PROFILE_H264_HIGH = 100;
    public static final int FF_PROFILE_H264_HIGH_10 = 110;
    public static final int FF_PROFILE_H264_HIGH_10_INTRA = 2158;
    public static final int FF_PROFILE_H264_HIGH_422 = 122;
    public static final int FF_PROFILE_H264_HIGH_422_INTRA = 2170;
    public static final int FF_PROFILE_H264_HIGH_444 = 144;
    public static final int FF_PROFILE_H264_HIGH_444_PREDICTIVE = 244;
    public static final int FF_PROFILE_H264_HIGH_444_INTRA = 2292;
    public static final int FF_PROFILE_H264_CAVLC_444 = 44;
    public Bundle mMediaMeta;
    public String mFormat;
    public long mDurationUS;
    public long mStartUS;
    public long mBitrate;
    public ArrayList<IjkBitrateItem> mBitrateItems;
    public final ArrayList<IjkStreamMeta> mStreams = new ArrayList();
    public IjkStreamMeta mVideoStream;
    public IjkStreamMeta mAudioStream;

    public String getString(String string2) {
        return this.mMediaMeta.getString(string2);
    }

    public int getInt(String string2) {
        return this.getInt(string2, 0);
    }

    public int getInt(String string2, int n2) {
        String string3 = this.getString(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return n2;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public long getLong(String string2) {
        return this.getLong(string2, 0L);
    }

    public long getLong(String string2, long l2) {
        String string3 = this.getString(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return l2;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return l2;
        }
    }

    public ArrayList<Bundle> getParcelableArrayList(String string2) {
        return this.mMediaMeta.getParcelableArrayList(string2);
    }

    public String getDurationInline() {
        long l2 = this.mDurationUS + 5000L;
        long l3 = l2 / 1000000L;
        long l4 = l3 / 60L;
        long l5 = l4 / 60L;
        return String.format(Locale.US, "%02d:%02d:%02d", l5, l4 %= 60L, l3 %= 60L);
    }

    public Map<String, String> getMetaM3U8() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : this.mMediaMeta.keySet()) {
            if (!string2.startsWith("m3u8:")) continue;
            hashMap.put(string2, this.mMediaMeta.getString(string2));
        }
        return hashMap;
    }

    public static IjkMediaMeta parse(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        IjkMediaMeta ijkMediaMeta = new IjkMediaMeta();
        ijkMediaMeta.mMediaMeta = bundle;
        ijkMediaMeta.mFormat = ijkMediaMeta.getString(IJKM_KEY_FORMAT);
        ijkMediaMeta.mDurationUS = ijkMediaMeta.getLong(IJKM_KEY_DURATION_US);
        ijkMediaMeta.mStartUS = ijkMediaMeta.getLong(IJKM_KEY_START_US);
        ijkMediaMeta.mBitrate = ijkMediaMeta.getLong(IJKM_KEY_BITRATE);
        int n2 = ijkMediaMeta.getInt("video", -1);
        int n3 = ijkMediaMeta.getInt("audio", -1);
        int n4 = ijkMediaMeta.getInt("timedtext", -1);
        ArrayList<Bundle> arrayList = ijkMediaMeta.getParcelableArrayList(IJKM_KEY_STREAMS);
        if (arrayList == null) {
            return ijkMediaMeta;
        }
        ijkMediaMeta.mBitrateItems = new ArrayList();
        int n5 = -1;
        for (Bundle object : arrayList) {
            ++n5;
            if (object == null) continue;
            IjkStreamMeta ijkStreamMeta = new IjkStreamMeta(n5);
            ijkStreamMeta.mMeta = object;
            ijkStreamMeta.mType = ijkStreamMeta.getString(IJKM_KEY_TYPE);
            ijkStreamMeta.mLanguage = ijkStreamMeta.getString(IJKM_KEY_LANGUAGE);
            if (TextUtils.isEmpty((CharSequence)ijkStreamMeta.mType)) continue;
            ijkStreamMeta.mCodecName = ijkStreamMeta.getString(IJKM_KEY_CODEC_NAME);
            ijkStreamMeta.mCodecProfile = ijkStreamMeta.getString(IJKM_KEY_CODEC_PROFILE);
            ijkStreamMeta.mCodecLongName = ijkStreamMeta.getString(IJKM_KEY_CODEC_LONG_NAME);
            ijkStreamMeta.mBitrate = ijkStreamMeta.getInt(IJKM_KEY_BITRATE);
            if (ijkStreamMeta.mType.equalsIgnoreCase("video")) {
                ijkStreamMeta.mWidth = ijkStreamMeta.getInt(IJKM_KEY_WIDTH);
                ijkStreamMeta.mHeight = ijkStreamMeta.getInt(IJKM_KEY_HEIGHT);
                ijkStreamMeta.mFpsNum = ijkStreamMeta.getInt(IJKM_KEY_FPS_NUM);
                ijkStreamMeta.mFpsDen = ijkStreamMeta.getInt(IJKM_KEY_FPS_DEN);
                ijkStreamMeta.mTbrNum = ijkStreamMeta.getInt(IJKM_KEY_TBR_NUM);
                ijkStreamMeta.mTbrDen = ijkStreamMeta.getInt(IJKM_KEY_TBR_DEN);
                ijkStreamMeta.mSarNum = ijkStreamMeta.getInt(IJKM_KEY_SAR_NUM);
                ijkStreamMeta.mSarDen = ijkStreamMeta.getInt(IJKM_KEY_SAR_DEN);
                if (n2 == n5) {
                    ijkMediaMeta.mVideoStream = ijkStreamMeta;
                }
            } else if (ijkStreamMeta.mType.equalsIgnoreCase("audio")) {
                ijkStreamMeta.mSampleRate = ijkStreamMeta.getInt(IJKM_KEY_SAMPLE_RATE);
                ijkStreamMeta.mChannelLayout = ijkStreamMeta.getLong(IJKM_KEY_CHANNEL_LAYOUT);
                if (n3 == n5) {
                    ijkMediaMeta.mAudioStream = ijkStreamMeta;
                }
            }
            ijkMediaMeta.mStreams.add(ijkStreamMeta);
        }
        ArrayList<Bundle> arrayList2 = ijkMediaMeta.getParcelableArrayList(IJKM_KEY_PROGRAMS);
        if (arrayList2 == null) {
            return ijkMediaMeta;
        }
        for (Bundle bundle2 : arrayList2) {
            if (bundle2 == null) continue;
            IjkBitrateItem ijkBitrateItem = new IjkBitrateItem();
            ijkBitrateItem.index = Integer.parseInt(bundle2.getString(IJKM_KEY_BITRATE_INDEX, "0"));
            ijkBitrateItem.width = Integer.parseInt(bundle2.getString(IJKM_KEY_WIDTH, "0"));
            ijkBitrateItem.height = Integer.parseInt(bundle2.getString(IJKM_KEY_HEIGHT, "0"));
            ijkBitrateItem.bitrate = Integer.parseInt(bundle2.getString(IJKM_KEY_BITRATE, "0"));
            ijkMediaMeta.mBitrateItems.add(ijkBitrateItem);
        }
        return ijkMediaMeta;
    }

    public static class IjkStreamMeta {
        public Bundle mMeta;
        public final int mIndex;
        public String mType;
        public String mLanguage;
        public String mCodecName;
        public String mCodecProfile;
        public String mCodecLongName;
        public long mBitrate;
        public int mWidth;
        public int mHeight;
        public int mFpsNum;
        public int mFpsDen;
        public int mTbrNum;
        public int mTbrDen;
        public int mSarNum;
        public int mSarDen;
        public int mSampleRate;
        public long mChannelLayout;

        public IjkStreamMeta(int n2) {
            this.mIndex = n2;
        }

        public String getString(String string2) {
            return this.mMeta.getString(string2);
        }

        public int getInt(String string2) {
            return this.getInt(string2, 0);
        }

        public int getInt(String string2, int n2) {
            String string3 = this.getString(string2);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return n2;
            }
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return n2;
            }
        }

        public long getLong(String string2) {
            return this.getLong(string2, 0L);
        }

        public long getLong(String string2, long l2) {
            String string3 = this.getString(string2);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return l2;
            }
            try {
                return Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                return l2;
            }
        }

        public String getCodecLongNameInline() {
            if (!TextUtils.isEmpty((CharSequence)this.mCodecLongName)) {
                return this.mCodecLongName;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCodecName)) {
                return this.mCodecName;
            }
            return "N/A";
        }

        public String getCodecShortNameInline() {
            if (!TextUtils.isEmpty((CharSequence)this.mCodecName)) {
                return this.mCodecName;
            }
            return "N/A";
        }

        public String getResolutionInline() {
            if (this.mWidth <= 0 || this.mHeight <= 0) {
                return "N/A";
            }
            if (this.mSarNum <= 0 || this.mSarDen <= 0) {
                return String.format(Locale.US, "%d x %d", this.mWidth, this.mHeight);
            }
            return String.format(Locale.US, "%d x %d [SAR %d:%d]", this.mWidth, this.mHeight, this.mSarNum, this.mSarDen);
        }

        public String getFpsInline() {
            if (this.mFpsNum <= 0 || this.mFpsDen <= 0) {
                return "N/A";
            }
            return String.valueOf((float)this.mFpsNum / (float)this.mFpsDen);
        }

        public String getBitrateInline() {
            if (this.mBitrate <= 0L) {
                return "N/A";
            }
            if (this.mBitrate < 1000L) {
                return String.format(Locale.US, "%d bit/s", this.mBitrate);
            }
            return String.format(Locale.US, "%d kb/s", this.mBitrate / 1000L);
        }

        public String getSampleRateInline() {
            if (this.mSampleRate <= 0) {
                return "N/A";
            }
            return String.format(Locale.US, "%d Hz", this.mSampleRate);
        }

        public String getChannelLayoutInline() {
            if (this.mChannelLayout <= 0L) {
                return "N/A";
            }
            if (this.mChannelLayout == 4L) {
                return "mono";
            }
            if (this.mChannelLayout == 3L) {
                return "stereo";
            }
            return String.format(Locale.US, "%x", this.mChannelLayout);
        }
    }
}

