/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tencent.ijk.media.player.IjkDownloadMedia;
import com.tencent.ijk.media.player.IjkLibLoader;
import com.tencent.ijk.media.player.IjkMediaPlayer;
import com.tencent.ijk.media.player.annotations.CalledByNative;
import com.tencent.liteav.basic.util.g;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class IjkDownloadCenter {
    private static final String TAG = "IjkDownloadCenter";
    private static final int MSG_RESUME = 100;
    private static final int MSG_STOP = 300;
    private static final int MSG_ERROR = 500;
    private static final int MSG_FINISH = 600;
    private static final int MSG_PROGRESS = 900;
    private static final int DC_PROP_STRING_URL = 1001;
    private static final int DC_PROP_LONG_SIZE = 1002;
    private static final int DC_PROP_LONG_DOWNLOAD_SIZE = 1003;
    private static final int DC_PROP_LONG_SPEED = 1004;
    private OnDownloadListener mListener;
    private EventHandler mEventHandler;
    protected Map<String, String> mHeaders;
    private static IjkDownloadCenter instance = null;
    private static volatile boolean mIsLibLoaded = false;
    private static final IjkLibLoader sLocalLibLoader = new IjkLibLoader(){

        @Override
        public void loadLibrary(String string2) throws UnsatisfiedLinkError, SecurityException {
            g.a(string2);
        }
    };

    protected void finalize() throws Throwable {
        try {
            this.native_download_free();
        }
        finally {
            super.finalize();
        }
    }

    public IjkDownloadCenter setListener(OnDownloadListener onDownloadListener) {
        this.mListener = onDownloadListener;
        return this;
    }

    public IjkDownloadCenter(IjkLibLoader ijkLibLoader) {
        IjkDownloadCenter.loadLibrariesOnce(ijkLibLoader);
        Looper looper = Looper.getMainLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : null;
        this.native_download_setup(new WeakReference<IjkDownloadCenter>(this));
    }

    public IjkDownloadCenter() {
        this(sLocalLibLoader);
    }

    public static IjkDownloadCenter getInstance() {
        if (instance == null) {
            instance = new IjkDownloadCenter();
        }
        return instance;
    }

    public void setHeaders(Map<String, String> map) {
        this.mHeaders = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrariesOnce(IjkLibLoader ijkLibLoader) {
        Class<IjkMediaPlayer> clazz = IjkMediaPlayer.class;
        synchronized (IjkMediaPlayer.class) {
            if (!mIsLibLoaded) {
                if (ijkLibLoader == null) {
                    ijkLibLoader = sLocalLibLoader;
                }
                ijkLibLoader.loadLibrary("txffmpeg");
                ijkLibLoader.loadLibrary("txsdl");
                ijkLibLoader.loadLibrary("txplayer");
                mIsLibLoaded = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void stop(int n2) {
        this.native_download_stop(n2);
    }

    public int downloadHls(String string2, String string3) {
        String string4 = "";
        if (this.mHeaders != null) {
            for (String string5 : this.mHeaders.keySet()) {
                if (string4 == null) {
                    string4 = String.format("%s: %s", string5, this.mHeaders.get(string5));
                    continue;
                }
                string4 = string4 + "\r\n" + String.format("%s: %s", string5, this.mHeaders.get(string5));
            }
        }
        return this.native_download_hls_start(string2, string3, string4);
    }

    @CalledByNative
    private static int hlsVerifyForNative(Object object, int n2, String string2, byte[] byArray) {
        if (object == null) {
            return 0;
        }
        IjkDownloadCenter ijkDownloadCenter = (IjkDownloadCenter)((WeakReference)object).get();
        if (ijkDownloadCenter == null) {
            return 0;
        }
        IjkDownloadMedia ijkDownloadMedia = ijkDownloadCenter.convertMedia(n2);
        return ijkDownloadCenter.mListener.hlsKeyVerify(ijkDownloadCenter, ijkDownloadMedia, string2, byArray);
    }

    @CalledByNative
    private static void postEventFromNative(Object object, int n2, int n3, int n4, Object object2) {
        if (object == null) {
            return;
        }
        IjkDownloadCenter ijkDownloadCenter = (IjkDownloadCenter)((WeakReference)object).get();
        if (ijkDownloadCenter == null) {
            return;
        }
        if (ijkDownloadCenter.mEventHandler != null) {
            NativeEvent nativeEvent = new NativeEvent();
            nativeEvent.media = ijkDownloadCenter.convertMedia(n3);
            nativeEvent.error = n4;
            if (object2 != null) {
                nativeEvent.reason = (String)object2;
            }
            Message message = ijkDownloadCenter.mEventHandler.obtainMessage(n2, n3, n4, nativeEvent);
            ijkDownloadCenter.mEventHandler.sendMessage(message);
        }
    }

    private native void native_download_setup(Object var1);

    private native void native_download_free();

    private native void native_download_stop(int var1);

    private native int native_download_hls_start(String var1, String var2, String var3);

    private native int download_get_task_prop_long(int var1, int var2);

    private native String download_get_task_prop_string(int var1, int var2);

    IjkDownloadMedia convertMedia(int n2) {
        String string2 = this.download_get_task_prop_string(1001, n2);
        if (string2 == null) {
            return null;
        }
        IjkDownloadMedia ijkDownloadMedia = new IjkDownloadMedia();
        ijkDownloadMedia.size = this.download_get_task_prop_long(1002, n2);
        ijkDownloadMedia.downloadSize = this.download_get_task_prop_long(1003, n2);
        ijkDownloadMedia.speed = this.download_get_task_prop_long(1004, n2);
        ijkDownloadMedia.url = string2;
        ijkDownloadMedia.tid = n2;
        return ijkDownloadMedia;
    }

    private static class EventHandler
    extends Handler {
        private final WeakReference<IjkDownloadCenter> mWeakCenter;

        public EventHandler(IjkDownloadCenter ijkDownloadCenter, Looper looper) {
            super(looper);
            this.mWeakCenter = new WeakReference<IjkDownloadCenter>(ijkDownloadCenter);
        }

        public void handleMessage(Message message) {
            IjkDownloadCenter ijkDownloadCenter = (IjkDownloadCenter)this.mWeakCenter.get();
            if (ijkDownloadCenter == null || ijkDownloadCenter.mListener == null) {
                return;
            }
            NativeEvent nativeEvent = (NativeEvent)message.obj;
            IjkDownloadMedia ijkDownloadMedia = nativeEvent.media;
            if (ijkDownloadMedia == null) {
                return;
            }
            switch (message.what) {
                case 100: {
                    ijkDownloadCenter.mListener.downloadBegin(ijkDownloadCenter, ijkDownloadMedia);
                    break;
                }
                case 600: {
                    ijkDownloadCenter.mListener.downloadFinish(ijkDownloadCenter, ijkDownloadMedia);
                    break;
                }
                case 300: {
                    ijkDownloadCenter.mListener.downloadEnd(ijkDownloadCenter, ijkDownloadMedia);
                    break;
                }
                case 900: {
                    ijkDownloadCenter.mListener.downloadProgress(ijkDownloadCenter, ijkDownloadMedia);
                    break;
                }
                case 500: {
                    ijkDownloadCenter.mListener.downloadError(ijkDownloadCenter, ijkDownloadMedia, nativeEvent.error, nativeEvent.reason);
                }
            }
        }
    }

    private static class NativeEvent {
        IjkDownloadMedia media;
        int error;
        String reason;

        private NativeEvent() {
        }
    }

    public static interface OnDownloadListener {
        public void downloadBegin(IjkDownloadCenter var1, IjkDownloadMedia var2);

        public void downloadEnd(IjkDownloadCenter var1, IjkDownloadMedia var2);

        public void downloadFinish(IjkDownloadCenter var1, IjkDownloadMedia var2);

        public void downloadError(IjkDownloadCenter var1, IjkDownloadMedia var2, int var3, String var4);

        public void downloadProgress(IjkDownloadCenter var1, IjkDownloadMedia var2);

        public int hlsKeyVerify(IjkDownloadCenter var1, IjkDownloadMedia var2, String var3, byte[] var4);
    }
}

