/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ijk.media.player;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaDataSource;
import android.media.MediaPlayer;
import android.media.PlaybackParams;
import android.media.TimedText;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.ijk.media.player.AbstractMediaPlayer;
import com.tencent.ijk.media.player.IjkBitrateItem;
import com.tencent.ijk.media.player.IjkTimedText;
import com.tencent.ijk.media.player.MediaInfo;
import com.tencent.ijk.media.player.misc.AndroidTrackInfo;
import com.tencent.ijk.media.player.misc.IMediaDataSource;
import com.tencent.ijk.media.player.misc.ITrackInfo;
import com.tencent.ijk.media.player.pragma.DebugLog;
import com.tencent.liteav.basic.log.TXCLog;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class AndroidMediaPlayer
extends AbstractMediaPlayer {
    private static final String TAG = "AndroidMediaPlayer";
    private final MediaPlayer mInternalMediaPlayer;
    private final AndroidMediaPlayerListenerHolder mInternalListenerAdapter;
    private String mDataSource;
    private MediaDataSource mMediaDataSource;
    private final Object mInitLock;
    private boolean mIsReleased;
    private static MediaInfo sMediaInfo;
    private Surface mSurface;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidMediaPlayer() {
        Object object = this.mInitLock = new Object();
        synchronized (object) {
            this.mInternalMediaPlayer = new MediaPlayer();
        }
        this.mInternalMediaPlayer.setAudioStreamType(3);
        this.mInternalListenerAdapter = new AndroidMediaPlayerListenerHolder(this);
        this.attachInternalListeners();
    }

    public MediaPlayer getInternalMediaPlayer() {
        return this.mInternalMediaPlayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        Object object = this.mInitLock;
        synchronized (object) {
            if (!this.mIsReleased) {
                this.mInternalMediaPlayer.setDisplay(surfaceHolder);
            }
        }
    }

    @Override
    @TargetApi(value=14)
    public void setSurface(Surface surface) {
        this.mInternalMediaPlayer.setSurface(surface);
        this.mSurface = surface;
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(context, uri);
    }

    @Override
    @TargetApi(value=14)
    public void setDataSource(Context context, Uri uri, Map<String, String> map) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(context, uri, map);
    }

    @Override
    public void setDataSource(FileDescriptor fileDescriptor) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mInternalMediaPlayer.setDataSource(fileDescriptor);
    }

    @Override
    public void setDataSource(String string2) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = string2;
        Uri uri = Uri.parse((String)string2);
        String string3 = uri.getScheme();
        if (!TextUtils.isEmpty((CharSequence)string3) && string3.equalsIgnoreCase("file")) {
            this.mInternalMediaPlayer.setDataSource(uri.getPath());
        } else {
            this.mInternalMediaPlayer.setDataSource(string2);
        }
    }

    @Override
    @TargetApi(value=23)
    public void setDataSource(IMediaDataSource iMediaDataSource) {
        this.releaseMediaDataSource();
        this.mMediaDataSource = new MediaDataSourceProxy(iMediaDataSource);
        this.mInternalMediaPlayer.setDataSource(this.mMediaDataSource);
    }

    @Override
    public String getDataSource() {
        return this.mDataSource;
    }

    private void releaseMediaDataSource() {
        if (this.mMediaDataSource != null) {
            try {
                this.mMediaDataSource.close();
            }
            catch (IOException iOException) {
                TXCLog.e(TAG, "close media data source failed.", iOException);
            }
            this.mMediaDataSource = null;
        }
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        this.mInternalMediaPlayer.prepareAsync();
    }

    @Override
    public void start() throws IllegalStateException {
        this.mInternalMediaPlayer.start();
    }

    @Override
    public void stop() throws IllegalStateException {
        this.mInternalMediaPlayer.stop();
    }

    @Override
    public void pause() throws IllegalStateException {
        this.mInternalMediaPlayer.pause();
    }

    @Override
    public void setScreenOnWhilePlaying(boolean bl) {
        this.mInternalMediaPlayer.setScreenOnWhilePlaying(bl);
    }

    @Override
    public ITrackInfo[] getTrackInfo() {
        return AndroidTrackInfo.fromMediaPlayer(this.mInternalMediaPlayer);
    }

    @Override
    public int getVideoWidth() {
        return this.mInternalMediaPlayer.getVideoWidth();
    }

    @Override
    public int getVideoHeight() {
        return this.mInternalMediaPlayer.getVideoHeight();
    }

    @Override
    public int getVideoSarNum() {
        return 1;
    }

    @Override
    public int getVideoSarDen() {
        return 1;
    }

    @Override
    public boolean isPlaying() {
        try {
            return this.mInternalMediaPlayer.isPlaying();
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.printStackTrace(illegalStateException);
            return false;
        }
    }

    @Override
    public void seekTo(long l2) throws IllegalStateException {
        this.mInternalMediaPlayer.seekTo((int)l2);
    }

    @Override
    public long getCurrentPosition() {
        try {
            return this.mInternalMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.printStackTrace(illegalStateException);
            return 0L;
        }
    }

    @Override
    public long getDuration() {
        try {
            return this.mInternalMediaPlayer.getDuration();
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.printStackTrace(illegalStateException);
            return 0L;
        }
    }

    @Override
    public void release() {
        this.mIsReleased = true;
        this.mInternalMediaPlayer.release();
        this.releaseMediaDataSource();
        this.resetListeners();
        this.attachInternalListeners();
    }

    @Override
    public void reset() {
        try {
            this.mInternalMediaPlayer.reset();
        }
        catch (IllegalStateException illegalStateException) {
            DebugLog.printStackTrace(illegalStateException);
        }
        this.releaseMediaDataSource();
        this.resetListeners();
        this.attachInternalListeners();
    }

    @Override
    public void setLooping(boolean bl) {
        this.mInternalMediaPlayer.setLooping(bl);
    }

    @Override
    public boolean isLooping() {
        return this.mInternalMediaPlayer.isLooping();
    }

    @Override
    @TargetApi(value=23)
    public void setRate(float f2) {
        if (Build.VERSION.SDK_INT >= 23) {
            PlaybackParams playbackParams = new PlaybackParams();
            playbackParams.setPitch(f2);
            playbackParams.setSpeed(f2);
            this.mInternalMediaPlayer.setPlaybackParams(playbackParams);
        }
    }

    @Override
    @TargetApi(value=23)
    public float getRate() {
        if (Build.VERSION.SDK_INT >= 23) {
            PlaybackParams playbackParams = this.mInternalMediaPlayer.getPlaybackParams();
            return playbackParams.getSpeed();
        }
        return 1.0f;
    }

    @Override
    public void setVolume(float f2, float f3) {
        this.mInternalMediaPlayer.setVolume(f2, f3);
    }

    @Override
    public void setAudioVolume(int n2) {
    }

    @Override
    public int getAudioSessionId() {
        return this.mInternalMediaPlayer.getAudioSessionId();
    }

    @Override
    public MediaInfo getMediaInfo() {
        if (sMediaInfo == null) {
            MediaInfo mediaInfo = new MediaInfo();
            mediaInfo.mVideoDecoder = "android";
            mediaInfo.mVideoDecoderImpl = "HW";
            mediaInfo.mAudioDecoder = "android";
            mediaInfo.mAudioDecoderImpl = "HW";
            sMediaInfo = mediaInfo;
        }
        return sMediaInfo;
    }

    @Override
    public void setLogEnabled(boolean bl) {
    }

    @Override
    public boolean isPlayable() {
        return true;
    }

    @Override
    public void setWakeMode(Context context, int n2) {
        this.mInternalMediaPlayer.setWakeMode(context, n2);
    }

    @Override
    public void setAudioStreamType(int n2) {
        this.mInternalMediaPlayer.setAudioStreamType(n2);
    }

    @Override
    public void setKeepInBackground(boolean bl) {
    }

    private void attachInternalListeners() {
        this.mInternalMediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this.mInternalListenerAdapter);
        this.mInternalMediaPlayer.setOnTimedTextListener((MediaPlayer.OnTimedTextListener)this.mInternalListenerAdapter);
    }

    @Override
    public int getBitrateIndex() {
        return 0;
    }

    @Override
    public void setBitrateIndex(int n2) {
    }

    @Override
    public ArrayList<IjkBitrateItem> getSupportedBitrates() {
        return new ArrayList<IjkBitrateItem>();
    }

    private class AndroidMediaPlayerListenerHolder
    implements MediaPlayer.OnBufferingUpdateListener,
    MediaPlayer.OnCompletionListener,
    MediaPlayer.OnErrorListener,
    MediaPlayer.OnInfoListener,
    MediaPlayer.OnPreparedListener,
    MediaPlayer.OnSeekCompleteListener,
    MediaPlayer.OnTimedTextListener,
    MediaPlayer.OnVideoSizeChangedListener {
        public final WeakReference<AndroidMediaPlayer> mWeakMediaPlayer;

        public AndroidMediaPlayerListenerHolder(AndroidMediaPlayer androidMediaPlayer2) {
            this.mWeakMediaPlayer = new WeakReference<AndroidMediaPlayer>(androidMediaPlayer2);
        }

        public boolean onInfo(MediaPlayer mediaPlayer, int n2, int n3) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            return androidMediaPlayer != null && AndroidMediaPlayer.this.notifyOnInfo(n2, n3);
        }

        public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            return androidMediaPlayer != null && AndroidMediaPlayer.this.notifyOnError(n2, n3);
        }

        public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n2, int n3) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            AndroidMediaPlayer.this.notifyOnVideoSizeChanged(n2, n3, 1, 1);
        }

        public void onSeekComplete(MediaPlayer mediaPlayer) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            AndroidMediaPlayer.this.notifyOnSeekComplete();
        }

        public void onBufferingUpdate(MediaPlayer mediaPlayer, int n2) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            AndroidMediaPlayer.this.notifyOnBufferingUpdate(n2);
        }

        public void onCompletion(MediaPlayer mediaPlayer) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            AndroidMediaPlayer.this.notifyOnCompletion();
        }

        public void onPrepared(MediaPlayer mediaPlayer) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            AndroidMediaPlayer.this.notifyOnPrepared();
        }

        public void onTimedText(MediaPlayer mediaPlayer, TimedText timedText) {
            AndroidMediaPlayer androidMediaPlayer = (AndroidMediaPlayer)this.mWeakMediaPlayer.get();
            if (androidMediaPlayer == null) {
                return;
            }
            IjkTimedText ijkTimedText = null;
            if (timedText != null) {
                ijkTimedText = new IjkTimedText(timedText.getBounds(), timedText.getText());
            }
            AndroidMediaPlayer.this.notifyOnTimedText(ijkTimedText);
        }
    }

    @TargetApi(value=23)
    private static class MediaDataSourceProxy
    extends MediaDataSource {
        private final IMediaDataSource mMediaDataSource;

        public MediaDataSourceProxy(IMediaDataSource iMediaDataSource) {
            this.mMediaDataSource = iMediaDataSource;
        }

        public int readAt(long l2, byte[] byArray, int n2, int n3) throws IOException {
            return this.mMediaDataSource.readAt(l2, byArray, n2, n3);
        }

        public long getSize() throws IOException {
            return this.mMediaDataSource.getSize();
        }

        public void close() throws IOException {
            this.mMediaDataSource.close();
        }
    }
}

