/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.avroom;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.MediaFormat;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.tencent.avroom.TXCAVRoomCallback;
import com.tencent.avroom.TXCAVRoomConfig;
import com.tencent.avroom.TXCAVRoomConstants;
import com.tencent.avroom.TXCAVRoomLisenter;
import com.tencent.avroom.TXCAVRoomParam;
import com.tencent.avroom.a;
import com.tencent.avroom.b;
import com.tencent.avroom.c;
import com.tencent.liteav.TXCRenderAndDec;
import com.tencent.liteav.audio.TXCAudioEngine;
import com.tencent.liteav.avprotocol.TXCAVProtocol;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.d;
import com.tencent.liteav.i;
import com.tencent.liteav.j;
import com.tencent.liteav.qos.TXCQoS;
import com.tencent.liteav.renderer.d;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TXCAVRoom {
    private static final String TAG = TXCAVRoom.class.getSimpleName();
    private static final int AVROOM_IDLE = 0;
    private static final int AVROOM_ENTERING = 1;
    private static final int AVROOM_ENTERED = 2;
    private static final int AVROOM_EXITING = 3;
    private com.tencent.liteav.d mPusher;
    private i mLivePushConfig;
    private TXCAVProtocol mTXCAVProtocol;
    private Context mContext;
    private TXCAVRoomConfig mRoomConfig;
    private boolean allowedPush = false;
    private HashMap<Long, c> playerList = new HashMap();
    private ArrayList<Long> videoMemList = new ArrayList();
    private TXCAVProtocol.TXCAVProtoParam protoparam = new TXCAVProtocol().new TXCAVProtocol.TXCAVProtoParam();
    private TXCAVRoomLisenter mAvRoomLisenter;
    private TXCQoS mQos = null;
    private int maxReconnectCount = 10;
    private int reconnectCount = 0;
    private long myid = -1L;
    private int appid = -1;
    private int sdkVersion = 26215104;
    private b mCaptureDataCollection;
    private Handler mainHandler = new Handler(Looper.getMainLooper());
    private TXCAVRoomCallback enterRoomCB;
    private int roomStatus = 0;
    private TXCloudVideoView localView;
    private static int videoMemNum = 0;
    private com.tencent.liteav.basic.b.c videoResolution = com.tencent.liteav.basic.b.c.c;

    public boolean isPushing() {
        return this.mPusher.k();
    }

    public boolean isInRoom() {
        return this.roomStatus == 2;
    }

    public TXCAVRoom(Context context, TXCAVRoomConfig tXCAVRoomConfig, long l2, int n2) {
        this.mContext = context;
        this.mRoomConfig = tXCAVRoomConfig;
        this.myid = l2;
        this.appid = n2;
        this.mPusher = new com.tencent.liteav.d(context);
        this.mPusher.a(new d.a(){

            @Override
            public void onEncVideo(TXSNALPacket tXSNALPacket) {
                if (TXCAVRoom.this.allowedPush) {
                    TXCAVRoom.this.mTXCAVProtocol.pushNAL(tXSNALPacket);
                }
            }

            @Override
            public void onEncVideoFormat(MediaFormat mediaFormat) {
            }

            @Override
            public void onBackgroudPushStop() {
            }
        });
        this.mPusher.setID("" + this.myid);
        this.mPusher.a(new com.tencent.liteav.basic.c.b(){

            @Override
            public void onNotifyEvent(int n2, Bundle bundle) {
                TXCAVRoom.this.onBothNotifyEvent(n2, bundle);
            }
        });
        this.applyCaptureConfig();
        this.mTXCAVProtocol = new TXCAVProtocol();
        this.mTXCAVProtocol.setListener(new TXCAVProtocol.TXIAVListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPullAudio(TXCAVProtocol.TXSAVProtoAudioPacket tXSAVProtoAudioPacket) {
                TXCAVRoom tXCAVRoom = TXCAVRoom.this;
                synchronized (tXCAVRoom) {
                    HashMap hashMap = TXCAVRoom.this.playerList;
                    synchronized (hashMap) {
                        if (TXCAVRoom.this.playerList.get(tXSAVProtoAudioPacket.tinyID) != null) {
                            if (TXCAudioEngine.getInstance().isRemoteAudioPlaying(String.valueOf(TXCAVRoom.this.myid))) {
                                tXSAVProtoAudioPacket.audioData = new byte[2];
                                tXSAVProtoAudioPacket.packetType = 2;
                                TXCAVRoomConstants.makeAACCodecSpecificData(tXSAVProtoAudioPacket.audioData, 2, tXSAVProtoAudioPacket.sampleRate, tXSAVProtoAudioPacket.channelsPerSample);
                                TXCLog.i(TAG, "audioKey: makeAACCodecSpecificData id " + tXSAVProtoAudioPacket.tinyID);
                            }
                            if (TXCAVRoom.this.playerList.get(tXSAVProtoAudioPacket.tinyID) != null && ((c)TXCAVRoom.this.playerList.get(tXSAVProtoAudioPacket.tinyID)).a() != null && tXSAVProtoAudioPacket.audioData != null) {
                                ((c)TXCAVRoom.this.playerList.get(tXSAVProtoAudioPacket.tinyID)).a().b(tXSAVProtoAudioPacket.audioData.length);
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPullNAL(TXCAVProtocol.TXSAVProtoNALPacket tXSAVProtoNALPacket) {
                HashMap hashMap = TXCAVRoom.this.playerList;
                synchronized (hashMap) {
                    if (TXCAVRoom.this.playerList.get(tXSAVProtoNALPacket.tinyID) != null) {
                        if (((c)TXCAVRoom.this.playerList.get(tXSAVProtoNALPacket.tinyID)).a() != null) {
                            ((c)TXCAVRoom.this.playerList.get(tXSAVProtoNALPacket.tinyID)).a().a(tXSAVProtoNALPacket.nalData.length);
                        }
                        ((c)TXCAVRoom.this.playerList.get(tXSAVProtoNALPacket.tinyID)).decVideo(tXSAVProtoNALPacket);
                    }
                }
            }

            @Override
            public void sendNotifyEvent(int n2, String string2) {
                switch (n2) {
                    case 8001: {
                        n2 = TXCAVRoomConstants.AVROOM_EVT_REQUEST_IP_SUCC;
                        break;
                    }
                    case -3303: {
                        n2 = TXCAVRoomConstants.AVROOM_ERR_REQUEST_IP_FAIL;
                        break;
                    }
                    case 8002: {
                        n2 = TXCAVRoomConstants.AVROOM_EVT_CONNECT_SUCC;
                        break;
                    }
                    case -3304: {
                        n2 = TXCAVRoomConstants.AVROOM_ERR_CONNECT_FAILE;
                        break;
                    }
                    case 1018: {
                        n2 = TXCAVRoomConstants.AVROOM_EVT_ENTER_ROOM_SUCC;
                        break;
                    }
                    case -3301: {
                        n2 = TXCAVRoomConstants.AVROOM_ERR_ENTER_ROOM_FAIL;
                        break;
                    }
                    case 1019: {
                        n2 = TXCAVRoomConstants.AVROOM_EVT_EXIT_ROOM_SUCC;
                        break;
                    }
                    case 8003: {
                        n2 = TXCAVRoomConstants.AVROOM_EVT_REQUEST_AVSEAT_SUCC;
                        break;
                    }
                    case -3305: {
                        n2 = TXCAVRoomConstants.AVROOM_ERR_REQUEST_AVSEAT_FAIL;
                    }
                }
                final Bundle bundle = new Bundle();
                bundle.putInt("EVT_ID", n2);
                bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                bundle.putString("EVT_MSG", string2);
                final int n3 = n2;
                ((Activity)TXCAVRoom.this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TXCAVRoom.this.mAvRoomLisenter.onAVRoomEvent(TXCAVRoom.this.myid, n3, bundle);
                    }
                });
                if (n2 == -3302) {
                    TXCAVRoom.this.reconnectRoom();
                }
            }

            @Override
            public void onMemberChange(final long l2, final boolean bl) {
                TXCLog.i(TAG, "onMemberChange: " + l2 + " flag:" + bl);
                TXCAVRoom.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            TXCAVRoom.this.addRender(l2);
                        } else {
                            TXCAVRoom.this.removeRender(l2);
                        }
                        TXCAVRoom.this.mAvRoomLisenter.onMemberChange(l2, bl);
                    }
                });
            }

            @Override
            public void onVideoStateChange(final long l2, final boolean bl) {
                TXCLog.i(TAG, "onVideoStateChange: " + l2 + " flag:" + bl);
                TXCAVRoom.this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        TXCAVRoom.this.mAvRoomLisenter.onVideoStateChange(l2, bl);
                    }
                });
            }
        });
    }

    public TXCAVRoomConfig getRoomConfig() {
        return this.mRoomConfig;
    }

    public void setRoomConfig(TXCAVRoomConfig tXCAVRoomConfig) {
        this.mRoomConfig = tXCAVRoomConfig;
        this.applyCaptureConfig();
    }

    public String nat64Compatable(String string2, short s2) {
        return this.mTXCAVProtocol.nativeNAT64Compatable(string2, s2);
    }

    public void enterRoom(TXCAVRoomParam tXCAVRoomParam, final TXCAVRoomCallback tXCAVRoomCallback) {
        if (this.roomStatus != 0) {
            this.postToUiThread(tXCAVRoomCallback, -4);
            return;
        }
        this.roomStatus = 1;
        TXCDRApi.initCrashReport(this.mContext);
        TXCDRApi.txReportDAU(this.mContext, com.tencent.liteav.basic.datareport.a.bv);
        this.protoparam.roomID = tXCAVRoomParam.getRoomID();
        this.protoparam.authBits = tXCAVRoomParam.getAuthBits();
        this.protoparam.authBuffer = tXCAVRoomParam.getAuthBuffer();
        this.enterRoomCB = tXCAVRoomCallback;
        this.protoparam.userID = this.myid;
        this.protoparam.sdkAppid = this.appid;
        this.protoparam.sdkVersion = this.sdkVersion;
        this.applyCaptureConfig();
        this.mTXCAVProtocol.enterRoom(this.protoparam, new TXCAVProtocol.TXIAVCompletionCallback(){

            @Override
            public void onComplete(int n2) {
                if (n2 == 0) {
                    TXCAVRoom.this.reconnectCount = 0;
                    TXCAVRoom.this.startPush();
                    TXCAVRoom.this.roomStatus = 2;
                    videoMemNum = 1;
                    TXCAVRoom.this.postToUiThread(tXCAVRoomCallback, n2);
                    if (TXCAVRoom.this.mRoomConfig.isHasVideo()) {
                        TXCAVRoom.this.mTXCAVProtocol.changeAVState(TXCAVProtocol.AV_STATE_ENTER_VIDEO, new TXCAVProtocol.TXIAVCompletionCallback(){

                            @Override
                            public void onComplete(int n2) {
                                TXCLog.i(TAG, "keyway change to Video  onComplete: " + n2);
                            }
                        });
                    }
                } else {
                    TXCAVRoom.this.roomStatus = 0;
                    TXCAVRoom.this.postToUiThread(tXCAVRoomCallback, n2);
                }
            }
        });
        this.mQos = new TXCQoS(true);
        this.mQos.setUserID(String.valueOf(this.myid));
        this.mQos.setListener(new com.tencent.liteav.qos.a(){

            @Override
            public int onGetEncoderRealBitrate() {
                return (int)(TXCAVRoom.this.mCaptureDataCollection != null ? TXCAVRoom.this.mCaptureDataCollection.getLongValue(4002) : 0L);
            }

            @Override
            public int onGetQueueInputSize() {
                long l2 = TXCAVRoom.this.mCaptureDataCollection != null ? TXCAVRoom.this.mCaptureDataCollection.getLongValue(7002) : 0L;
                long l3 = TXCAVRoom.this.mCaptureDataCollection != null ? TXCAVRoom.this.mCaptureDataCollection.getLongValue(7001) : 0L;
                return (int)(l2 + l3);
            }

            @Override
            public int onGetQueueOutputSize() {
                if (TXCAVRoom.this.mCaptureDataCollection == null) {
                    return 0;
                }
                long l2 = TXCAVRoom.this.mCaptureDataCollection.getLongValue(7004);
                long l3 = TXCAVRoom.this.mCaptureDataCollection.getLongValue(7003);
                return (int)(l2 + l3);
            }

            @Override
            public int onGetVideoQueueMaxCount() {
                return 5;
            }

            @Override
            public int onGetVideoQueueCurrentCount() {
                if (TXCAVRoom.this.mCaptureDataCollection == null) {
                    return 0;
                }
                return (int)TXCAVRoom.this.mCaptureDataCollection.getLongValue(7005);
            }

            @Override
            public int onGetVideoDropCount() {
                if (TXCAVRoom.this.mCaptureDataCollection == null) {
                    return 0;
                }
                return (int)TXCAVRoom.this.mCaptureDataCollection.getLongValue(7007);
            }

            @Override
            public int onGetBandwidthEst() {
                return 0;
            }

            @Override
            public void onEncoderParamsChanged(int n2, int n3, int n4) {
                if (n2 != 0) {
                    if (TXCAVRoom.this.mPusher != null) {
                        TXCAVRoom.this.mPusher.a(n2, n3, n4);
                    }
                    TXCLog.i(TAG, "onEncoderParamsChanged:" + n2);
                }
            }

            @Override
            public void onEnableDropStatusChanged(boolean bl) {
            }
        });
        this.mQos.setNotifyListener(new com.tencent.liteav.basic.c.b(){

            @Override
            public void onNotifyEvent(int n2, Bundle bundle) {
                TXCAVRoom.this.onBothNotifyEvent(n2, bundle);
            }
        });
        this.mQos.setAutoAdjustBitrate(true);
        this.mQos.setAutoAdjustStrategy(5);
        this.mQos.setDefaultVideoResolution(com.tencent.liteav.basic.b.c.b);
        this.mQos.setDefaultVideoResolution(this.videoResolution);
        this.mQos.setVideoEncBitrate(100, this.mRoomConfig.getVideoBitrate(), this.mRoomConfig.getVideoBitrate());
        this.mQos.start(TXCAVRoomConstants.AVROOM_QOS_INTERVAL);
    }

    public long[] getRoomMemberList() {
        return this.mTXCAVProtocol.getRoomMemberList();
    }

    public long[] getRoomVideoList() {
        return this.mTXCAVProtocol.getRoomVideoList();
    }

    private void reconnectRoom() {
        if (this.roomStatus != 2) {
            return;
        }
        TXCLog.i(TAG, "reconnectRoom");
        if (this.reconnectCount > this.maxReconnectCount) {
            if (this.mAvRoomLisenter != null) {
                final Bundle bundle = new Bundle();
                bundle.putLong("EVT_USERID", this.myid);
                bundle.putInt("EVT_ID", TXCAVRoomConstants.AVROOM_WARNING_DISCONNECT);
                bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                bundle.putString("EVT_MSG", "Failed to reconnect many times. Abondon reconnect");
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TXCAVRoom.this.mAvRoomLisenter.onAVRoomEvent(TXCAVRoom.this.myid, TXCAVRoomConstants.AVROOM_WARNING_DISCONNECT, bundle);
                    }
                });
            }
            return;
        }
        int n2 = this.reconnectCount < 3 ? 0 : 2;
        this.mainHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                TXCAVRoom.this.mTXCAVProtocol.enterRoom(TXCAVRoom.this.protoparam, new TXCAVProtocol.TXIAVCompletionCallback(){

                    @Override
                    public void onComplete(int n2) {
                        if (n2 == 0) {
                            TXCAVRoom.this.reconnectCount = 0;
                            if (TXCAVRoom.this.mRoomConfig.isHasVideo()) {
                                TXCAVRoom.this.mTXCAVProtocol.changeAVState(TXCAVProtocol.AV_STATE_ENTER_VIDEO, new TXCAVProtocol.TXIAVCompletionCallback(){

                                    @Override
                                    public void onComplete(int n2) {
                                        TXCLog.i(TAG, "keyway changeAVState onComplete: " + n2);
                                    }
                                });
                            }
                        } else {
                            TXCAVRoom.this.reconnectRoom();
                        }
                    }
                });
                TXCAVRoom.this.reconnectCount++;
            }
        }, (long)(n2 * 1000));
    }

    public void setAvRoomLisenter(TXCAVRoomLisenter tXCAVRoomLisenter) {
        this.mAvRoomLisenter = tXCAVRoomLisenter;
    }

    public void exitRoom(final TXCAVRoomCallback tXCAVRoomCallback) {
        if (this.roomStatus == 3 || this.roomStatus == 1) {
            this.postToUiThread(tXCAVRoomCallback, -4);
            return;
        }
        this.roomStatus = 3;
        if (this.mQos != null) {
            this.mQos.stop();
            this.mQos.setListener(null);
            this.mQos.setNotifyListener(null);
            this.mQos = null;
        }
        this.removeAllRender();
        this.stopLocalPreview();
        this.stopPush();
        if (this.playerList != null) {
            this.playerList.clear();
        }
        this.mTXCAVProtocol.exitRoom(new TXCAVProtocol.TXIAVCompletionCallback(){

            @Override
            public void onComplete(int n2) {
                TXCAVRoom.this.roomStatus = 0;
                TXCAVRoom.this.postToUiThread(tXCAVRoomCallback, n2);
                if (n2 == 0) {
                    videoMemNum = 0;
                    if (TXCAVRoom.this.mCaptureDataCollection != null) {
                        TXCAVRoom.this.mCaptureDataCollection.b();
                        TXCAVRoom.this.mCaptureDataCollection = null;
                    }
                }
            }
        });
    }

    public void destory() {
        if (this.mQos != null) {
            this.mQos.stop();
        }
        this.stopLocalPreview();
        this.removeAllRender();
        this.mPusher.g();
        this.mPusher = null;
        this.mContext = null;
        this.mTXCAVProtocol.destory();
    }

    public void startLocalPreview(TXCloudVideoView tXCloudVideoView) {
        this.localView = tXCloudVideoView;
        tXCloudVideoView.setVisibility(0);
        TXCLog.i(TAG, "startLocalPreview: " + tXCloudVideoView.getTag());
        this.applyCaptureConfig();
        this.mPusher.a(tXCloudVideoView);
        if (this.mCaptureDataCollection == null) {
            this.mCaptureDataCollection = new b(this.appid, this.myid, this.mContext, this.mLivePushConfig);
            this.mCaptureDataCollection.a(this.mTXCAVProtocol);
            this.mCaptureDataCollection.a(this.mAvRoomLisenter);
            this.mCaptureDataCollection.a();
            this.mCaptureDataCollection.a(this.mPusher);
        }
        this.mRoomConfig.setHasVideo(true);
        if (this.roomStatus != 2) {
            return;
        }
        this.mTXCAVProtocol.changeAVState(TXCAVProtocol.AV_STATE_ENTER_VIDEO, new TXCAVProtocol.TXIAVCompletionCallback(){

            @Override
            public void onComplete(int n2) {
                Log.i((String)TAG, (String)("keyway change to Video onComplete: " + n2));
            }
        });
    }

    public void stopLocalPreview() {
        if (this.mCaptureDataCollection != null) {
            this.mCaptureDataCollection.b();
            this.mCaptureDataCollection = null;
        }
        if (this.localView != null) {
            this.localView.setVisibility(4);
            this.localView = null;
        }
        if (this.mPusher != null) {
            this.mPusher.d(true);
        }
        this.mRoomConfig.setHasVideo(false);
        if (this.roomStatus == 2) {
            this.mTXCAVProtocol.changeAVState(TXCAVProtocol.AV_STATE_ENTER_AUDIO, new TXCAVProtocol.TXIAVCompletionCallback(){

                @Override
                public void onComplete(int n2) {
                    Log.i((String)TAG, (String)("keyway change to audio onComplete: " + n2));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRender(long l2) {
        HashMap<Long, c> hashMap = this.playerList;
        synchronized (hashMap) {
            if (this.playerList.get(l2) == null) {
                c c2 = new c(this.mContext);
                c2.setID(String.valueOf(l2));
                c2.setNotifyListener(new com.tencent.liteav.basic.c.b(){

                    @Override
                    public void onNotifyEvent(int n2, Bundle bundle) {
                        TXCAVRoom.this.onBothNotifyEvent(n2, bundle);
                    }
                });
                j j2 = this.getRenderConfig();
                c2.setConfig(j2);
                c2.setRenderMode(this.mRoomConfig.getRemoteRenderMode());
                c2.setRenderRotation(TXCAVRoomConstants.AVROOM_HOME_ORIENTATION_RIGHT);
                if (j2.h) {
                    c2.setVideoRender(new d());
                } else {
                    c2.setVideoRender(new com.tencent.liteav.renderer.a());
                }
                this.playerList.put(l2, c2);
            }
            this.playerList.get(l2).start(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRender(Long l2) {
        HashMap<Long, c> hashMap = this.playerList;
        synchronized (hashMap) {
            c c2 = this.playerList.get(l2);
            if (c2 == null) {
                return;
            }
            c2.stop();
            c2.setVideoRender(null);
            c2.setDecListener(null);
            if (c2.a() != null) {
                c2.a().b();
                c2.a((a)null);
            }
            this.playerList.remove(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startRemoteView(TXCloudVideoView tXCloudVideoView, long l2) {
        HashMap<Long, c> hashMap = this.playerList;
        synchronized (hashMap) {
            c c2 = this.playerList.get(l2);
            if (c2 == null) {
                return;
            }
            if (tXCloudVideoView != null) {
                c2.a(tXCloudVideoView);
                this.videoMemList.add(l2);
                c2.setRenderMode(0);
                this.requestView(this.videoMemList);
            }
            a a2 = new a(l2);
            a2.a(this.mAvRoomLisenter);
            a2.a(this.mTXCAVProtocol);
            a2.a(this.playerList.get(l2));
            a2.a(this.playerList.get(l2).getVideoRender());
            this.playerList.get(l2).a(a2);
            a2.a();
            this.setRenderMode(this.mRoomConfig.getRemoteRenderMode());
        }
    }

    public synchronized void stopRemoteView(long l2) {
        this.videoMemList.remove(l2);
        this.requestView(this.videoMemList);
    }

    private void removeAllRender() {
        if (this.playerList == null || this.playerList.size() == 0) {
            return;
        }
        for (Long l2 : this.playerList.keySet()) {
            if (this.playerList.get(l2) == null) continue;
            this.stopRemoteView(l2);
            this.playerList.get(l2).stop();
            if (this.playerList.get(l2) == null || this.playerList.get(l2).a() == null) continue;
            this.playerList.get(l2).a().b();
            this.playerList.get(l2).a((a)null);
        }
        this.playerList.clear();
    }

    private void requestViewList(ArrayList<TXCAVProtocol.TXSAVRoomView> arrayList, final TXCAVRoomCallback tXCAVRoomCallback) {
        this.mTXCAVProtocol.requestViews(arrayList, new TXCAVProtocol.TXIAVCompletionCallback(){

            @Override
            public void onComplete(int n2) {
                TXCAVRoom.this.postToUiThread(tXCAVRoomCallback, n2);
            }
        });
    }

    private void startPush() {
        TXCLog.i(TAG, "keyway startPush: ");
        this.allowedPush = true;
        this.mPusher.f();
    }

    private void stopPush() {
        TXCLog.i(TAG, "keyway stopPush: ");
        this.allowedPush = false;
        this.mPusher.g();
    }

    public void onPause() {
        TXCLog.i(TAG, "keyway onPause : ");
        this.mPusher.h();
    }

    public void onResume() {
        TXCLog.i(TAG, "keyway onResume: ");
        this.mPusher.i();
    }

    public void setVideoBitrateAndvideoAspect(int n2, int n3) {
        this.videoResolution = TXCQoS.getProperResolutionByVideoBitrate(true, n2, n3);
        if (this.videoResolution == null) {
            this.videoResolution = n3 == 1 ? com.tencent.liteav.basic.b.c.b : (n3 == 2 ? com.tencent.liteav.basic.b.c.n : (n3 == 3 ? com.tencent.liteav.basic.b.c.s : com.tencent.liteav.basic.b.c.b));
        }
        TXCLog.i(TAG, "setVideoBitrateAndvideoAspect videoBitrate: " + n2 + " videoAspect:" + n3 + " videoResolution:" + (Object)((Object)this.videoResolution));
        this.mRoomConfig.videoBitrate(n2);
        this.applyCaptureConfig();
    }

    private void postToUiThread(final TXCAVRoomCallback tXCAVRoomCallback, final int n2) {
        if (this.mContext != null) {
            ((Activity)this.mContext).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    tXCAVRoomCallback.onComplete(n2);
                }
            });
        }
    }

    private void requestView(ArrayList<Long> arrayList) {
        TXCLog.i(TAG, "requestView: " + arrayList.size());
        ArrayList<TXCAVProtocol.TXSAVRoomView> arrayList2 = new ArrayList<TXCAVProtocol.TXSAVRoomView>();
        for (long l2 : arrayList) {
            TXCAVProtocol.TXSAVRoomView tXSAVRoomView = new TXCAVProtocol().new TXCAVProtocol.TXSAVRoomView();
            tXSAVRoomView.tinyID = l2;
            tXSAVRoomView.height = 240;
            tXSAVRoomView.width = 320;
            arrayList2.add(tXSAVRoomView);
        }
        this.requestViewList(arrayList2, new TXCAVRoomCallback(){

            @Override
            public void onComplete(int n2) {
                TXCLog.i(TAG, "keyway requestViewList onComplete: " + n2);
            }
        });
    }

    public void switchCamera() {
        if (this.mPusher != null) {
            this.mPusher.l();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteMute(boolean bl, long l2) {
        if (this.playerList == null) {
            return;
        }
        if (l2 == 0L) {
            for (Long l3 : this.playerList.keySet()) {
                TXCRenderAndDec tXCRenderAndDec = this.playerList.get(l3);
            }
        }
        HashMap<Long, c> hashMap = this.playerList;
        synchronized (hashMap) {
            if (this.playerList.get(l2) != null) {
                // empty if block
            }
        }
    }

    public void setMirror(boolean bl) {
        if (this.mPusher != null) {
            this.mPusher.g(bl);
        }
    }

    public void setAudioMode(int n2) {
    }

    public void setLocalMute(boolean bl) {
        if (this.mPusher != null) {
            // empty if block
        }
    }

    private void applyCaptureConfig() {
        if (this.mPusher != null) {
            this.mLivePushConfig = new i();
            this.mLivePushConfig.s = TXCAVRoomConstants.AVROOM_AUDIO_SAMPLE_RATE;
            this.mLivePushConfig.t = 1;
            this.mLivePushConfig.u = true;
            this.mLivePushConfig.c = this.mRoomConfig.getVideoBitrate();
            this.mLivePushConfig.h = this.mRoomConfig.getCaptureVideoFPS();
            this.mLivePushConfig.i = 1;
            this.mLivePushConfig.l = this.mRoomConfig.getHomeOrientation();
            this.mLivePushConfig.m = this.mRoomConfig.isFrontCamera();
            this.mLivePushConfig.C = this.mRoomConfig.getPauseFps();
            this.mLivePushConfig.A = this.mRoomConfig.getPauseImg();
            this.mLivePushConfig.B = TXCAVRoomConstants.AVROOM_PUSH_PAUSETIME;
            this.mLivePushConfig.D = this.mRoomConfig.getPauseFlag();
            this.mLivePushConfig.k = this.videoResolution;
            int n2 = this.mLivePushConfig.j = this.mRoomConfig.isEnableVideoHWAcceleration() ? 1 : 0;
            if (this.mQos != null) {
                this.mQos.setDefaultVideoResolution(this.videoResolution);
                this.mQos.setVideoEncBitrate(100, this.mRoomConfig.getVideoBitrate(), this.mRoomConfig.getVideoBitrate());
            }
            this.mPusher.a(this.mLivePushConfig);
        }
    }

    private j getRenderConfig() {
        j j2 = new j();
        j2.a(true);
        j2.a(TXCAVRoomConstants.AVROOM_CACHETIME);
        j2.b(TXCAVRoomConstants.AVROOM_MAX_ADJUSTCACHETIME);
        j2.h = this.mRoomConfig.isEnableVideoHWAcceleration();
        return j2;
    }

    public void setRenderMode(int n2) {
        for (Map.Entry<Long, c> entry : this.playerList.entrySet()) {
            TXCLog.i(TAG, "Key = " + entry.getKey() + ", Value = " + entry.getValue());
            c c2 = entry.getValue();
            c2.setRenderMode(n2);
        }
    }

    public void setEyeScaleLevel(int n2) {
        this.mPusher.b().setEyeScaleLevel(n2);
    }

    public void setFaceSlimLevel(int n2) {
        this.mPusher.b().setFaceSlimLevel(n2);
    }

    public void setFilter(Bitmap bitmap) {
        this.mPusher.b().setFilter(bitmap);
    }

    public void setGreenScreenFile(String string2) {
        this.mPusher.b().setGreenScreenFile(string2);
    }

    public void setMotionTmpl(String string2) {
        this.mPusher.b().setMotionTmpl(string2);
    }

    public void setExposureCompensation(float f2) {
        this.mPusher.a(f2);
    }

    public void setBeautyFilter(int n2, int n3, int n4, int n5) {
        if (null != this.mPusher) {
            this.mPusher.b().setBeautyStyle(n2);
            this.mPusher.b().setBeautyLevel(n3);
            this.mPusher.b().setWhitenessLevel(n3);
            this.mPusher.b().setRuddyLevel(n3);
        }
    }

    public void setFaceVLevel(int n2) {
        if (this.mPusher != null) {
            this.mPusher.b().setFaceVLevel(n2);
        }
    }

    public void setSpecialRatio(float f2) {
        if (this.mPusher != null) {
            this.mPusher.b().setFilterStrength(f2);
        }
    }

    public void setFaceShortLevel(int n2) {
        if (this.mPusher != null) {
            this.mPusher.b().setFaceShortLevel(n2);
        }
    }

    public void setChinLevel(int n2) {
        if (this.mPusher != null) {
            this.mPusher.b().setChinLevel(n2);
        }
    }

    public void setNoseSlimLevel(int n2) {
        if (this.mPusher != null) {
            this.mPusher.b().setNoseSlimLevel(n2);
        }
    }

    private void onBothNotifyEvent(int n2, Bundle bundle) {
        TXCLog.i(TAG, "AVROOM onNotifyEvent: " + bundle.getString("EVT_MSG"));
        if (this.mAvRoomLisenter != null) {
            final Long l2 = bundle.getLong("EVT_USERID");
            switch (n2) {
                case 1003: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_OPEN_CAMERA_SUCC;
                    break;
                }
                case -1301: {
                    n2 = TXCAVRoomConstants.AVROOM_ERR_OPEN_CAMERA_FAIL;
                    break;
                }
                case 1007: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_FIRST_FRAME_AVAILABLE;
                    break;
                }
                case -1302: {
                    n2 = TXCAVRoomConstants.AVROOM_ERR_OPEN_MIC_FAIL;
                    break;
                }
                case 1008: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_START_VIDEO_ENCODER;
                    break;
                }
                case 1103: {
                    n2 = TXCAVRoomConstants.AVROOM_WARNING_HW_ACCELERATION_ENCODE_FAIL;
                    break;
                }
                case -1303: {
                    n2 = TXCAVRoomConstants.AVROOM_ERR_VIDEO_ENCODE_FAIL;
                    break;
                }
                case 1005: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_UP_CHANGE_RESOLUTION;
                }
                case 1006: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_UP_CHANGE_BITRATE;
                    break;
                }
                case 2003: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_RCV_FIRST_I_FRAME;
                    break;
                }
                case 2105: {
                    n2 = TXCAVRoomConstants.AVROOM_WARNING_VIDEO_PLAY_LAG;
                    break;
                }
                case 2007: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_PLAY_LOADING;
                    break;
                }
                case 2004: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_PLAY_BEGIN;
                    break;
                }
                case 2008: {
                    n2 = TXCAVRoomConstants.AVROOM_EVT_START_VIDEO_DECODER;
                    break;
                }
                case 2106: {
                    n2 = TXCAVRoomConstants.AVROOM_WARNING_HW_ACCELERATION_DECODE_FAIL;
                    break;
                }
                case 2101: {
                    n2 = TXCAVRoomConstants.AVROOM_WARNING_VIDEO_DECODE_FAIL;
                    break;
                }
                default: {
                    return;
                }
            }
            final int n3 = n2;
            final Bundle bundle2 = new Bundle();
            bundle2.putLong("EVT_USERID", l2.longValue());
            bundle2.putInt("EVT_ID", bundle.getInt("EVT_ID", 0));
            bundle2.putLong("EVT_TIME", bundle.getLong("EVT_TIME", 0L));
            bundle2.putString("EVT_MSG", bundle.getString("EVT_MSG", ""));
            if (this.mPusher != null) {
                ((Activity)this.mContext).runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        TXCLog.i(TAG, "NotifyEvent sendNotifyEvent userID: " + l2 + "  msg " + bundle2.getString("EVT_MSG"));
                        TXCAVRoom.this.mAvRoomLisenter.onAVRoomEvent(l2, n3, bundle2);
                    }
                });
            }
        }
    }
}

