/*
 * Decompiled with CFR 0.152.
 */
package cn.qqtheme.framework.picker;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import cn.qqtheme.framework.popup.ConfirmPopup;
import cn.qqtheme.framework.widget.WheelView;

public abstract class WheelPicker
extends ConfirmPopup<View> {
    protected float lineSpaceMultiplier = 2.0f;
    protected int textPadding = -1;
    protected int textSize = 16;
    protected Typeface typeface = Typeface.DEFAULT;
    protected int textColorNormal = -4473925;
    protected int textColorFocus = -16611122;
    protected int labelTextColor = -16611122;
    protected int offset = 3;
    protected boolean cycleDisable = true;
    protected boolean useWeight = true;
    protected boolean textSizeAutoFit = true;
    protected WheelView.DividerConfig dividerConfig = new WheelView.DividerConfig();

    public WheelPicker(Activity activity) {
        super(activity);
    }

    public final void setLineSpaceMultiplier(@FloatRange(from=2.0, to=4.0) float multiplier) {
        this.lineSpaceMultiplier = multiplier;
    }

    @Deprecated
    public void setPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setTextColor(@ColorInt int textColorFocus, @ColorInt int textColorNormal) {
        this.textColorFocus = textColorFocus;
        this.textColorNormal = textColorNormal;
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColorFocus = textColor;
    }

    public void setLabelTextColor(int labelTextColor) {
        this.labelTextColor = labelTextColor;
    }

    public void setShadowVisible(boolean shadowVisible) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setShadowVisible(shadowVisible);
    }

    public void setShadowColor(@ColorInt int color) {
        this.setShadowColor(color, 100);
    }

    public void setShadowColor(@ColorInt int color, @IntRange(from=1L, to=255L) int alpha) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setShadowColor(color);
        this.dividerConfig.setShadowAlpha(alpha);
    }

    public void setDividerVisible(boolean visible) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setVisible(visible);
    }

    @Deprecated
    public void setLineVisible(boolean visible) {
        this.setDividerVisible(visible);
    }

    @Deprecated
    public void setLineColor(@ColorInt int color) {
        this.setDividerColor(color);
    }

    public void setDividerColor(@ColorInt int lineColor) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setVisible(true);
        this.dividerConfig.setColor(lineColor);
    }

    public void setDividerRatio(float ratio) {
        if (null == this.dividerConfig) {
            this.dividerConfig = new WheelView.DividerConfig();
        }
        this.dividerConfig.setRatio(ratio);
    }

    public void setDividerConfig(@Nullable WheelView.DividerConfig config) {
        if (null == config) {
            this.dividerConfig = new WheelView.DividerConfig();
            this.dividerConfig.setVisible(false);
            this.dividerConfig.setShadowVisible(false);
        } else {
            this.dividerConfig = config;
        }
    }

    @Deprecated
    public void setLineConfig(WheelView.DividerConfig config) {
        this.setDividerConfig(config);
    }

    public void setOffset(@IntRange(from=1L, to=5L) int offset) {
        this.offset = offset;
    }

    public void setCycleDisable(boolean cycleDisable) {
        this.cycleDisable = cycleDisable;
    }

    public void setUseWeight(boolean useWeight) {
        this.useWeight = useWeight;
    }

    public void setTextSizeAutoFit(boolean textSizeAutoFit) {
        this.textSizeAutoFit = textSizeAutoFit;
    }

    @Override
    public View getContentView() {
        if (this.centerView == null) {
            this.centerView = this.makeCenterView();
        }
        return this.centerView;
    }

    protected WheelView createWheelView() {
        WheelView wheelView = new WheelView((Context)this.activity);
        wheelView.setLineSpaceMultiplier(this.lineSpaceMultiplier);
        wheelView.setTextPadding(this.textPadding);
        wheelView.setTextSize(this.textSize);
        wheelView.setTypeface(this.typeface);
        wheelView.setTextColor(this.textColorNormal, this.textColorFocus);
        wheelView.setDividerConfig(this.dividerConfig);
        wheelView.setOffset(this.offset);
        wheelView.setCycleDisable(this.cycleDisable);
        wheelView.setUseWeight(this.useWeight);
        wheelView.setTextSizeAutoFit(this.textSizeAutoFit);
        return wheelView;
    }

    protected TextView createLabelView() {
        TextView labelView = new TextView((Context)this.activity);
        labelView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        labelView.setTextColor(this.labelTextColor);
        labelView.setTextSize((float)this.textSize);
        return labelView;
    }
}

