#!/usr/bin/env node

var paths = require('./parse'),
    json = paths.parse(),
    fs = require('fs'),
    path = require('path'),
    examples = [],
    tab = '    ',
    xml = path.join(__dirname, '../tests', 'coverage.xml'),
    str = [
        '<?xml version="1.0"?>',
        '<!-- Dynamically generated by src/common/node/make_unit.js -->',
        '<yuitest>',
        tab + '<tests base="@TEST_ARTIFACTS_BASE@" timeout="240000">'
    ];

    str.push('<!-- This needs to be first to prep the ');
    str.push('            browser window for the other tests -->');
    str.push(tab + tab + '<url>common/tests/prep.html</url>');

    Object.keys(json).forEach(function(mod) {
        var info = json[mod];
        var p = path.join(mod, 'tests/unit');
        var hasCoverage = info.some(function(line) {
            return (line.indexOf('coverage') > -1);
        });
        if (hasCoverage) {
            info.forEach(function(u) {
                if (u.indexOf('coverage') > -1) {
                    examples.push(path.join(p, u));
                }
            });
        } else {
            info.forEach(function(u) {
                examples.push(path.join(p, u));
            });
        }
    });
    examples.sort();



    examples.forEach(function(url) {
        str.push(tab + tab + '<url>' + url + '</url>');
    });

    str.push(tab + '</tests>');
    str.push('</yuitest>');
    str.push('');

    fs.writeFileSync(xml, str.join('\n'), 'utf8');

    console.log('Wrote', examples.length, 'test urls to coverage.xml');
