# Random Cat Generator Using Clean Architecture

![foo](https://user-images.githubusercontent.com/26605247/76627604-3418cf00-6533-11ea-9dc6-8eb74fcd9aa5.gif)

# Objective

This very basic Dart/Flutter project demonstrates the use of clean architecture to build a full stack application.

Users can use this application as a reference to strengthen their skills around designing apps with a clean architecture and wirting code using the SOLID design principles.

The code is mainly Dart (core business logic) with bits of Flutter (which you can swap with a UI library of your choice).

# Structure

- One screen.
- One button.
- One placeholder for cat images.

# Workflow

- App launches.
- User presses the button.
- A call is made to the random cats API.
- A loading indicator is shown while the call is performed.
- A cat picture is displayed in the screen when the response is successful.
- If no connection we show an error message.

# References

Clean architecture by [Uncle Bob](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html).

Youtube tutorials by [Reso Coder](https://www.youtube.com/watch?v=dc3B_mMrZ-Q).

