# List of ChatGPT Plugins & Resources

## OpenAI Resources

### OpenAI Announcement Post
- [ChatGPT Plugins](https://openai.com/blog/chatgpt-plugins)
- [Official Waitlist Signup](https://t.co/Tm3772myTt)

### OpenAI-published Examples
- [Video clip processing](https://twitter.com/gdb/status/1638971232443076609)
- [OpenAI Plugins launch sentiment analysis](https://twitter.com/gdb/status/1638986918947082241)
- [UN human rights analysis](https://cdn.openai.com/chat-plugins/retrieval-gh-repo-readme/Retrieval-Final.mp4)
- [Opentable & Instacart](https://twitter.com/gdb/status/1638949234681712643)

### OpenAI Development Resources
- [OpenAI Plugins Documentation](https://platform.openai.com/docs/plugins/introduction)
- [OpenAI Plugins Development Examples](https://platform.openai.com/docs/plugins/examples)
- [OpenAI Retrieval Plugin documentation](https://t.co/pX6z2QAGwE)

## 3rd Party Resources
- [LangChain Conversation Agents & ChatGPT Plugins](https://twitter.com/hwchase17/status/1639351690251100160)
- [Using ChatGPT to create ChatGPT plugins](https://twitter.com/clusteredbytes/status/1638996669244252162)
- [Building a LangChain Docs Plugin for ChatGPT](https://github.com/pinecone-io/examples/blob/master/generation/chatgpt/plugins/langchain-docs-plugin.ipynb)

## Plugin List

### Official OpenAI Plugins

|Name   |Description |
|---|---|
|Browsing   |An experimental model that knows when and how to browse the internet |
|Code Interpreter   |An experimental ChatGPT model that can use Python, handle uploads and downloads|
|Retrieval   |The open-source retrieval plugin enables ChatGPT to access personal or organizational information sources (with permission).| 

### Official "OpenAI Plugin Store" Plugins

|Name   |Description |
|---|---|
|Instacart   |Order from your favorite local grocery stores.|
|Kayak   |Search for flights, stays and rental cars. Get recommendations for all the places you can go within your budget.|
|Shop   |Search for millions of products from the world’s greatest brands.|
|FiscalNote   |Provides and enables access to select market-leading, real-time data sets for legal, political, and regulatory data and information.|
|Klarna   |Search and compare prices from thousands of online shops.|
|Milo Family AI   |Giving parents superpowers to turn the manic to magic, 20 minutes each day. Ask: Hey Milo, what’s magic today?|
|Zapier   |Interact with over 5,000+ apps like Google Sheets, Trello, Gmail, HubSpot, Salesforce, and more.|
|OpenTable   |Provides restaurant recommendations, with a direct link to book.|
|Speak   |Learn how to say anything in another language with Speak, your AI-powered language tutor.|
|Wolfram   |Access computation, math, curated knowledge & real-time data through Wolfram|Alpha and Wolfram Language.|
|Expedia   |Bring your trip plans to life—get there, stay there, find things to see and do.|
|[JoPilot](https://jopilot.net/) | Search jobs in the US by company name, keywords, locations and distance. |
|[Resume Copilot](https://c-resume.copilot.us/) | Upload your resume/CV, get feedback and create a new version of the resume for free. |


### 3rd Party Plugins

|Name   |Description |Source|
|---|---|---|
|Gerev AI   |Search engine for your organization   |https://github.com/GerevAI/gerev|
|Chat-todo-plugin  |ChatGPT Plugin for managing a TODO list |https://github.com/lencx/chat-todo-plugin|
|ChadCode |An intelligence layer on your codebase |https://twitter.com/mathemagic1an/status/1639779842769014784|
|Domain Ideas |Brainstorm domain names with ChatGPT | https://twitter.com/steventey/status/1640378476950855680|
|Paperplane |Update SalesForce automatically |https://twitter.com/dnlkwk/status/1640932332638179329|
|ReviewReader | Instantly summarise a product's Amazon reviews | https://youtu.be/SaNvkaRGUeI
|Transvribe |Ask any YouTube video a question |https://www.transvribe.com/.well-known/ai-plugin.json|

