<h1 align="center">Awesome-Story-Generation</h1>

<div align="center">Contributed by <a href="https://yingpengma.github.io/">Yingpeng Ma</a>, <a href="https://mantle2048.github.io/">Yan Ma</a></div>

## 

🔥 Due to limitations with the Semantic Scholar API, we are unable to display citation counts for all papers in this repo.

We focus on showing citation counts for all **LLMs-era** papers and some earlier **influential** papers. 

Here, "**influential**" means papers with **over 50 citations**.

## Table of Contents

- [Introduction](#introduction)
<!--
- [Related Repository](#related-repository)
-->
- [Papers](#papers)
  - [Literature Review](#literature-review)
  - [Large Language Model](#large-language-model)
  - [Plot Development](#plot-development)
  - [Better Storytelling](#better-storytelling)
  - [Story Character](#story-character)
  - [Writing Style](#writing-style)
  - [Story Planning](#story-planning)
  - [Controllable Story](#controllable-story)
  - [Reasonable Story](#reasonable-story)
  - [Benchmark](#benchmark)
  - [Others](#others)
- [Public Resources](#public-resources)

## Introduction
This repository collects an extensive list of awesome papers about **Story Generation** / **Storytelling**, primarily focusing on the era of **Large Language Models (LLMs)**.

All papers are sorted in **chronological order**, with the most recent ones appearing at the top.

Due to limited energy and time, there may be omissions and errors. If you notice any issues or mistakes, please feel free to open issues or submit PRs!

If you have any suggestions or questions, please do not hesitate to reach out to me:

`mayingpeng33 [AT] gmail [DOT] com`

<!--
## Related Repository
|**[Awesome-LLM-Characters](https://github.com/yingpengma/Awesome-LLM-Characters)**|
|:---:|
-->

## Papers

Eg. `ACL-2023` **Title** [paper] [code] .. [authors]  [![](https://img.shields.io/badge/citation-count-blue)]()


### Literature Review
- `CHI-2024` **The Value, Benefits, and Concerns of Generative AI-Powered Assistance in Writing** [[paper]](https://arxiv.org/abs/2403.12004) [Zhuoyan Li, Chen Liang, Jing Peng, Ming Yin] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/a567f5bd6e6a32963e428bb97dec9c52ad75f059?fields=citationCount)]()
- `EMNLP-2023` **Creative Natural Language Generation** [[paper]](https://aclanthology.org/2023.emnlp-tutorial.6/) [Tuhin Chakrabarty, Vishakh Padmakumar, He He, Nanyun Peng] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/3c550bda6ac5a98f630203b1750721acc61605b2?fields=citationCount)]()
- `Neurocomputing-2023` **Open-world story generation with structured knowledge enhancement: A comprehensive survey** [[paper]](https://arxiv.org/abs/2212.04634) [Yuxin Wang, Jieru Lin, Zhiwei Yu, Wei Hu, Börje F. Karlsson] 
- `WNU-2022` **What is Wrong with Language Models that Can Not Tell a Story?** [[paper]](https://arxiv.org/abs/2211.05044) [Ivan P. Yamshchikov, Alexey Tikhonov] 
- `ACM Computing Surveys-2021` **Automatic Story Generation** [[paper]](https://dl.acm.org/doi/10.1145/3453156) [Arwa I. Alhussain, Aqil M. Azmi]
- `NUSE-2021` **Automatic Story Generation: Challenges and Attempts** [[paper]](https://arxiv.org/abs/2102.12634) [Amal Alabdulkarim, Siyan Li, Xiangyu Peng] 

### Large Language Model
- `EACL-2024` **Creating Suspenseful Stories: Iterative Planning with Large Language Models** [[paper]](https://arxiv.org/abs/2402.17119) [Kaige Xie, Mark Riedl] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/ea6b0b5904d6e8eccbccb609ac35911ae967cd2c?fields=citationCount)]()
- `Arxiv-2024` **SWAG: Storytelling With Action Guidance** [[paper]](https://arxiv.org/abs/2402.03483) [Zeeshan Patel, Karim El-Refai, Jonathan Pei, Tianle Li] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/0353331b666c24845120a79a022e3abddcdb2fdc?fields=citationCount)]()
- `Arxiv-2024` **Weaver: Foundation Models for Creative Writing** [[paper]](https://arxiv.org/abs/2401.17268) [Tiannan Wang, Jiamin Chen, Qingrui Jia, Shuai Wang, Ruoyu Fang, ... , Yuchen Eleanor Jiang, Wangchunshu Zhou] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/1d500905ca70d40a85d10f60d44a018ec0d9349d?fields=citationCount)]()
- `ArXiv-2023` **AutoAgents: A Framework for Automatic Agent Generation** [[paper]](https://arxiv.org/abs/2309.17288) [Guangyao Chen, Siwei Dong, Yu Shu, Ge Zhang, Jaward Sesay, Börje F. Karlsson, Jie Fu, Yemin Shi] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/63fb7814c6257158ecb20f390be51d5bb8969be3?fields=citationCount)]()
- `ArXiv-2023` **RecurrentGPT: Interactive Generation of (Arbitrarily) Long Text** [[paper]](https://arxiv.org/abs/2305.13304) [[code]](https://github.com/aiwaves-cn/RecurrentGPT) [Wangchunshu Zhou, Yuchen Eleanor Jiang, Peng Cui, Tiannan Wang, Zhenxin Xiao, Yifan Hou, Ryan Cotterell, Mrinmaya Sachan] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/d9964ab436eefd21f923a4bc833c6b66692c7f00?fields=citationCount)]()


### Plot Development
- `Stanford CS224N Custom Project-2023` **Novelty: Optimizing StreamingLLM for Novel Plot Generation** [[paper]](https://web.stanford.edu/class/archive/cs/cs224n/cs224n.1244/final-projects/JoyceChuyiChenMeganMou.pdf) [Joyce Chen, Megan Mou] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/247a05b3b10228b1fc8da75dd03b9329cc0a8cf0?fields=citationCount)]()
- `ArXiv-2023` **End to End Story Plot Generator** [[paper]](https://arxiv.org/abs/2310.08796) [Hanlin Zhu, Andrew Cohen, Danqing Wang, Kevin Yang, Xiaomeng Yang, Jiantao Jiao, Yuandong Tian] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/2dede02e09147614e947ec464f575db6838a0b6c?fields=citationCount)]()
- `AAAI Workshop-2023` **Conveying the Predicted Future to Users: A Case Study of Story Plot Prediction** [[paper]](https://arxiv.org/abs/2302.09122)  [Chieh-Yang Huang, Saniya Naphade, Kavya Laalasa Karanam, Ting-Hao 'Kenneth' Huang] 
- `RANLP-2023` **Coherent Story Generation with Structured Knowledge** [[paper]](https://aclanthology.org/2023.ranlp-1.74.pdf) [Congda Ma, Kotaro Funakoshi, Kiyoaki Shirai, Manabu Okumura] 
- `EMNLP-2022` **EtriCA: Event-triggered context-aware story generation augmented by cross attention** [[paper]](https://arxiv.org/abs/2210.12463) [Chen Tang, Chenghua Lin, Henglin Huang, Frank Guerin, Zhihao Zhang] 
- `INLG-2022` **Plot Writing From Pre-Trained Language Models** [[paper]](https://arxiv.org/abs/2206.03021) [Yiping Jin, Vishakha Kadam, Dittaya Wanvarie] 
- `AAAI-2020` **Story Realization: Expanding Plot Events into Sentences** [[paper]](https://arxiv.org/abs/1909.03480v2)  [[code]](https://github.com/rajammanabrolu/StoryRealization)   [Prithviraj Ammanabrolu, Ethan Tien, Wesley Cheung, Zhaochen Luo, William Ma, Lara J. Martin, Mark O. Riedl] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/a4dd44938eaf534259aaf4bcb875bb0ab8431c4d?fields=citationCount)]()

### Better Storytelling
- `ArXiv-2024` **With Greater Text Comes Greater Necessity: Inference-Time Training Helps Long Text Generation** [[paper]](https://arxiv.org/abs/2401.11504) [Y. Wang, D. Ma, D. Cai]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/5215a3cfd67fdc6eb0201822dd0004bd4b830f91?fields=citationCount)]()
- `PAKDD-2024` **LongStory: Coherent, Complete and Length Controlled Long story Generation** [[paper]](https://arxiv.org/abs/2311.15208) [Kyeongman Park, Nakyeong Yang, Kyomin Jung]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/0bcb53691c6e0e4f39152aa4b5255e624c6f85ed?fields=citationCount)]() 
- `EMNLP Findings-2023` **Affective and Dynamic Beam Search for Story Generation** [[paper]](https://arxiv.org/abs/2310.15079) [Tenghao Huang, Ehsan Qasemi, Bangzheng Li, He Wang, Faeze Brahman, Muhao Chen, Snigdha Chaturvedi]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/b7aff63b893ae0f5178c894b515d1cab00ba97b7?fields=citationCount)]()
- `EMNLP Findings-2023` **GROVE: A Retrieval-augmented Complex Story Generation Framework with A Forest of Evidence** [[paper]](https://arxiv.org/abs/2310.05388) [Zhihua Wen, Zhiliang Tian, Wei Wu, Yuxin Yang, Yanqi Shi, Zhen Huang, Dongsheng Li] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/dd7a2613ee15cd10938e7ad40f3aa052e98fda3c?fields=citationCount)]()
- `ACL-2023` **Open-ended Long Text Generation via Masked Language Modeling** [[paper]](https://aclanthology.org/2023.acl-long.13/) [Xiaobo Liang, Zecheng Tang, Juntao Li, Min Zhang] 
- `ArXiv-2022` **Future Sight: Dynamic Story Generation with Large Pretrained Language Models** [[paper]](https://arxiv.org/abs/2212.09947) [Brian D. Zimmerman, Gaurav Sahu, Olga Vechtomova] 
- `ACL Workshop-2022` **Coherent Long Text Generation by Contrastive Soft Prompt** [[paper]](https://aclanthology.org/2022.gem-1.42) [Guandan Chen, Jiashu Pu, Yadong Xi, Rongsheng Zhang] 
- `AACL-2022` **Improving Chinese Story Generation via Awareness of Syntactic Dependencies and Semantics** [[paper]](https://arxiv.org/abs/2210.10618) [Henglin Huang, Chen Tang, Tyler Loakman, Frank Guerin, Chenghua Lin] 
- `AAAI-2022` **Generating Coherent Narratives by Learning Dynamic and Discrete Entity States with a Contrastive Framework** [[paper]](https://arxiv.org/abs/2208.03985)   [Jian Guan, Zhenyu Yang, Rongsheng Zhang, Zhipeng Hu, Minlie Huang] 
- `PhD Thesis-2022` **Great Expectations: Unsupervised Inference of Suspense, Surprise and Salience in Storytelling** [[paper]](https://arxiv.org/abs/2206.09708) [David Wilmot] 
- `NAACL-2022` **Go Back in Time: Generating Flashbacks in Stories with Event Temporal Prompts** [[paper]](https://arxiv.org/abs/2205.01898)  [Rujun Han, Hong Chen, Yufei Tian, Nanyun Peng]  
- `ACL Findings-2022` **Event Transition Planning for Open-ended Text Generation** [[paper]](https://arxiv.org/abs/2204.09453) [Qintong Li, Piji Li, Wei Bi, Zhaochun Ren, Yuxuan Lai, Lingpeng Kong] 
- `ICASSP-2022` **Clseg: Contrastive learning of story ending generation** [[paper]](https://arxiv.org/abs/2202.09049) [Yuqiang Xie, Yue Hu, Luxi Xing, Yunpeng Li, Wei Peng, Ping Guo] 
- `ICML-2022` **Towards Coherent and Consistent Use of Entities in Narrative Generation** [[paper]](https://arxiv.org/abs/2202.01709)   [Pinelopi Papalampidi, Kris Cao, Tomas Kocisky]
- `EMNLP Findings-2021` **Guiding Neural Story Generation with Reader Models** [[paper]](https://arxiv.org/abs/2112.08596) [Xiangyu Peng, Kaige Xie, Amal Alabdulkarim, Harshith Kayam, Samihan Dani, Mark O. Riedl] 
- `ArXiv-2021` **Goal-Directed Story Generation: Augmenting Generative Language Models with Reinforcement Learning** [[paper]](https://arxiv.org/abs/2112.08593)  [Amal Alabdulkarim, Winston Li, Lara J. Martin, Mark O. Riedl] 
- `ArXiv-2021` **Automated Story Generation as Question-Answering** [[paper]](https://arxiv.org/abs/2112.03808)  [Louis Castricato, Spencer Frazier, Jonathan Balloch, Nitya Tarakad, Mark Riedl] 
- `ACL-2021` **Long text generation by modeling sentence-level and discourse-level coherence** [[paper]](https://arxiv.org/abs/2105.08963)  [Jian Guan, Xiaoxi Mao, Changjie Fan, Zitao Liu, Wenbiao Ding, Minlie Huang] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/798c61b2b985e918a74b9aa154e6bc3f01040763?fields=citationCount)]()
- `AACL-2020` **Cue Me In: Content-Inducing Approaches to Interactive Story Generation** [[paper]](https://arxiv.org/abs/2010.09935) [Faeze Brahman, Alexandru Petrusca, Snigdha Chaturvedi] 


### Story Character
- `FDG-2024` **StoryVerse: Towards Co-authoring Dynamic Plot with LLM-based Character Simulation via Narrative Planning** [[paper]](https://arxiv.org/abs/2405.13042) [Yi Wang, Qian Zhou, David Ledo] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/490636907afbc60f9af11084e46122f5899faa45?fields=citationCount)]()
- `ArXiv-2024` **Large Language Models Fall Short: Understanding Complex Relationships in Detective Narratives** [[paper]](https://arxiv.org/abs/2402.11051) [Runcong Zhao, Qinglin Zhu, Hainiu Xu, Jiazheng Li, Yuxiang Zhou, Yulan He, Lin Gui] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/f55bddab8d47f80097b1048b6da6988e3aa3f357?fields=citationCount)]()
- `EMNLP-2022` **Towards Inter-character Relationship-driven Story Generation** [[paper]](https://arxiv.org/abs/2211.00676) [Anvesh Rao Vijjini, Faeze Brahman, Snigdha Chaturvedi]
- `COLING-2022` **CHAE: Fine-Grained Controllable Story Generation with Characters, Actions and Emotions** [[paper]](https://arxiv.org/abs/2210.05221) [Xinpeng Wang, Han Jiang, Zhihua Wei, Shanlin Zhou]
- `ArXiv-2022` **A Benchmark for Understanding and Generating Dialogue between Characters in Stories** [[paper]](https://arxiv.org/abs/2209.08524) [Jianzhu Yao, Ziqi Liu, Jian Guan, Minlie Huang]
- `ECML/PKDD-2022` **An Ion Exchange Mechanism Inspired Story Ending Generator for Different Characters** [[paper]](https://arxiv.org/abs/2209.00200) [Xinyu Jiang, Qi Zhang, Chongyang Shi, Kaiying Jiang, Liang Hu, Shoujin Wang]
- `NAACL-2022` **Persona-Guided Planning for Controlling the Protagonist’s Persona in Story Generation** [[paper]](https://arxiv.org/abs/2204.10703) [[code]](https://github.com/thu-coai/ConPer) [Zhexin Zhang, Jiaxin Wen, Jian Guan, Minlie Huang] 
- `ACL-2021` **Unsupervised Enrichment of Persona-grounded Dialog with Background Stories** [[paper]](https://arxiv.org/abs/2106.08364) [Bodhisattwa Prasad Majumder, Taylor Berg-Kirkpatrick, Julian McAuley, Harsh Jhamtani] 
- `SIGDIAL-2021` **Telling Stories through Multi-User Dialogue by Modeling Character Relations** [[paper]](https://arxiv.org/abs/2105.15054) [Wai Man Si, Prithviraj Ammanabrolu, Mark O. Riedl]


### Writing Style
- `ArXiv-2024` **CAT-LLM: Prompting Large Language Models with Text Style Definition for Chinese Article-style Transfer** [[paper]](https://arxiv.org/abs/2401.05707) [Zhen Tao, Dinghao Xi, Zhiyu Li, Liumin Tang, Wei Xu] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/dcb3381f33e5313fe4f0db31c0cbc0ff7e533cef?fields=citationCount)]()
- `ArXiv-2023` **Learning to Generate Text in Arbitrary Writing Styles** [[paper]](https://arxiv.org/abs/2312.17242) [Aleem Khan, Andrew Wang, Sophia Hager, Nicholas Andrews] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/1d39c86425146b4b88a8dad8702e70bb1fa60fc6?fields=citationCount)]()
- `ACL-2023` **StoryTrans: Non-Parallel Story Author-Style Transfer with Discourse Representations and Content Enhancing** [[paper]](https://arxiv.org/abs/2208.13423) [Xuekai Zhu, Jian Guan, Minlie Huang, Juan Liu]
- `ACL-2021` **Stylized story generation with style-guided planning** [[paper]](https://arxiv.org/abs/2105.08625)  [Xiangzhe Kong, Jialiang Huang, Ziquan Tung, Jian Guan, Minlie Huang] 
- `ACL-2020` **Story-level Text Style Transfer: A Proposal** [[paper]](https://aclanthology.org/2020.acl-srw.2.pdf)  [Yusu Qian] 


### Story Planning
- `ArXiv-2024` **Navigating the Path of Writing: Outline-guided Text Generation with Large Language Models** [[paper]](https://arxiv.org/abs/2404.13919) [Yukyung Lee, Soonwon Ka, Bokyung Son, Pilsung Kang, Jaewook Kang]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/b66f499b302e1bb5cd95b3c160b71d16c11451c9?fields=citationCount)]()
- `EMNLP Findings-2023` **Improving Pacing in Long-Form Story Planning** [[paper]](https://arxiv.org/abs/2311.04459) [Yichen Wang, Kevin Yang, Xiaoming Liu, Dan Klein]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/1ac61e3da6dbb844537c0e94ff3b07561bcd21d4?fields=citationCount)]()
- `ArXiv-2023` **EIPE-text: Evaluation-Guided Iterative Plan Extraction for Long-Form Narrative Text Generation** [[paper]](https://arxiv.org/abs/2310.08185) [Wang You, Wenshan Wu, Yaobo Liang, Shaoguang Mao, Chenfei Wu, Maosong Cao, Yuzhe Cai, Yiduo Guo, Yan Xia, Furu Wei, Nan Duan] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/bb2ef694e8b5a99e1f7ceb014968b4d1dc2e122a?fields=citationCount)]()
- `ArXiv-2023` **RLCD: Reinforcement Learning from Contrast Distillation for Language Model Alignment** [[paper]](https://arxiv.org/abs/2307.12950) [Kevin Yang, Dan Klein, Asli Celikyilmaz, Nanyun Peng, Yuandong Tian] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/cc1f72c2334703be01063536705b116ba49341cd?fields=citationCount)]()
- `ArXiv-2023` **Enhancing Generation through Summarization Duality and Explicit Outline Control** [[paper]](https://arxiv.org/abs/2305.14459) [Yunzhe Li, Qian Chen, Weixiang Yan, Wen Wang, Qinglin Zhang, Hari Sundaram]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/b00f60869d3f3a5cde9f6aac1892fdad6cc6c0c6?fields=citationCount)]()
- `ArXiv-2022` **Little Red Riding Hood Goes Around the Globe:Crosslingual Story Planning and Generation with Large Language Models** [[paper]](https://arxiv.org/abs/2212.10471) [Evgeniia Razumovskaia, Joshua Maynez, Annie Louis, Mirella Lapata, Shashi Narayan]
- `ACL-2023` **DOC: Improving Long Story Coherence With Detailed Outline Control** [[paper]](https://arxiv.org/abs/2212.10077) [[code]](https://github.com/yangkevin2/doc-story-generation) [Kevin Yang, Dan Klein, Nanyun Peng, Yuandong Tian] 
- `ArXiv-2022` **Neural Story Planning** [[paper]](https://arxiv.org/abs/2212.08718) [Anbang Ye, Christopher Cui, Taiwei Shi, Mark O. Riedl] 
- `EMNLP-2022` **Re3: Generating longer stories with recursive reprompting and revision** [[paper]](https://arxiv.org/abs/2210.06774) [Kevin Yang, Yuandong Tian, Nanyun Peng, Dan Klein]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/2aab6ca1a8dae3f3db6d248231ac3fa4e222b30a?fields=citationCount)]()
- `AAAI-2021` **Narrative Plan Generation with Self-Supervised Learning** [[paper]](https://ojs.aaai.org/index.php/AAAI/article/view/16747) [Mihai Polceanu, Julie Porteous, Alan Lindsay, Marc Cavazza] 
- `INLG-2021` **GraphPlan: Story Generation by Planning with Event Graph** [[paper]](https://arxiv.org/abs/2102.02977)  [Hong Chen, Raphael Shu, Hiroya Takamura, Hideki Nakayama]
- `EMNLP-2020` **Content Planning for Neural Story Generation with Aristotelian Rescoring** [[paper]](https://arxiv.org/abs/2009.09870) [Seraphina Goldfarb-Tarrant, Tuhin Chakrabarty, Ralph Weischedel, Nanyun Peng] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/12cfe5d242c940a0383b55978c7419ee6633ed85?fields=citationCount)]()
- `AAAI-2020` **Draft and Edit: Automatic Storytelling Through Multi-Pass Hierarchical Conditional Variational Autoencoder** [[paper]](https://ojs.aaai.org/index.php/AAAI/article/view/5538) [Meng-Hsuan Yu, Juntao Li, Danyang Liu, Dongyan Zhao, Rui Yan, Bo Tang, Haisong Zhang]
- `ACL-2019` **Strategies for Structuring Story Generation** [[paper]](https://arxiv.org/abs/1902.01109) [Angela Fan, Mike Lewis, Yann Dauphin]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/2d6c0f7774d9d30d4972f5dba1d6e5389b3ddd2f?fields=citationCount)]()
- `AAAI-2019` **Plan-And-Write: Towards Better Automatic Storytelling** [[paper]](https://arxiv.org/abs/1811.05701) [[code]](https://bitbucket.org/VioletPeng/language-model) [Lili Yao, Nanyun Peng, Ralph Weischedel, Kevin Knight, Dongyan Zhao, Rui Yan] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/b0e716728e940eb2164892b7e284940157a2cebe?fields=citationCount)]()
- `EMNLP-2018` **A Skeleton-Based Model for Promoting Coherence Among Sentences in Narrative Story Generation** [[paper]](https://arxiv.org/abs/1808.06945) [[code]](https://github.com/lancopku/Skeleton-Based-Generation-Model) [Jingjing Xu, Xuancheng Ren, Yi Zhang, Qi Zeng, Xiaoyan Cai, Xu Sun] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/6ac772a03a7ab6cce1fd3afcceff58bbc89da3ff?fields=citationCount)]()
- `ACL-2018` **Hierarchical Neural Story Generation** [[paper]](https://arxiv.org/abs/1805.04833) [[code]](https://github.com/kevalnagda/StoryGeneration) [[writing prompt]](https://www.kaggle.com/ratthachat/writing-prompts) [Angela Fan, Mike Lewis, Yann Dauphin]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/29de7c0fb3c09eaf55b20619bceaeafe72fd87a6?fields=citationCount)]()
- `AAAI-2018` **Event Representations for Automated Story Generation with Deep Neural Nets** [[paper]](https://arxiv.org/abs/1706.01331)  [[code]](https://github.com/lara-martin/ASTER)   [Lara J. Martin, Prithviraj Ammanabrolu, Xinyu Wang, William Hancock, Shruti Singh, Brent Harrison, Mark O. Riedl] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/47a26b0c5d27b99da175e0a719f42d707f97ec3d?fields=citationCount)]()

### Controllable Story
- `ACL-2024` **MoPS: Modular Story Premise Synthesis for Open-Ended Automatic Story Generation** [[paper]](https://arxiv.org/abs/2406.05690)  [[code]](https://github.com/GAIR-NLP/MoPS) [Yan Ma, Yu Qiao, Pengfei Liu] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/c00c67bb564f8f4e9912439f2283da691a16541e?fields=citationCount)]()
- `ArXiv-2024` **Returning to the Start: Generating Narratives with Related Endpoints** [[paper]](https://arxiv.org/abs/2404.00829) [[code]](https://github.com/adbrei/RENarGen) [Anneliese Brei, Chao Zhao, Snigdha Chaturvedi]
- `ArXiv-2024` **LiFi: Lightweight Controlled Text Generation with Fine-Grained Control Codes** [[paper]](https://arxiv.org/abs/2402.06930) [Chufan Shi, Deng Cai, Yujiu Yang]
- `INLG-2023` **Controlling keywords and their positions in text generation** [[paper]](https://arxiv.org/abs/2304.09516) [Yuichi Sasazawa, Terufumi Morishita, Hiroaki Ozaki, Osamu Imaichi, Yasuhiro Sogawa] 
- `COLING-2022` **Psychology-guided Controllable Story Generation** [[paper]](https://arxiv.org/abs/2210.07493) [Yuqiang Xie, Yue Hu, Yunpeng Li, Guanqun Bi, Luxi Xing, Wei Peng] 
- `WWW-2022` **Genre-controllable story generation via supervised contrastive learning** [[paper]](https://dl.acm.org/doi/abs/10.1145/3485447.3512004) [JinUk Cho, MinSu Jeong, JinYeong Bak, Yun-Gyung Cheong]
- `EMNLP Findings-2021` **A Plug-and-Play Method for Controlled Text Generation** [[paper]](https://arxiv.org/abs/2109.09707v1)  [[code]](https://github.com/dapascual/k2t) [Damian Pascual, Beni Egressy, Clara Meister, Ryan Cotterell, Roger Wattenhofer] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/ddcd5bed531c13e0da65e30333aaa5c27914f882?fields=citationCount)]()
- `NUSE-2021` **Plug-and-Blend: A Framework for Controllable Story Generation with Blended Control Codes** [[paper]](https://arxiv.org/abs/2104.04039v2)  [[code]](https://github.com/xxbidiao/plug-and-blend) [Zhiyu Lin, Mark Riedl] 
- `ArXiv-2021` **Transformer-based Conditional Variational Autoencoder for Controllable Story Generation** [[paper]](https://arxiv.org/abs/2101.00828) [[code]](https://github.com/fangleai/TransformerCVAE) [Le Fang, Tao Zeng, Chaochun Liu, Liefeng Bo, Wen Dong, Changyou Chen] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/36273607aceaaea85da9d87c261001fc178d8cb7?fields=citationCount)]()
- `ArXiv-2021` **Outline to Story: Fine-grained Controllable Story Generation from Cascaded Events** [[paper]](https://arxiv.org/abs/2101.00822) [Le Fang, Tao Zeng, Chaochun Liu, Liefeng Bo, Wen Dong, Changyou Chen] 
- `EMNLP-2020` **MEGATRON-CNTRL: Controllable story generation with external knowledge using large-scale language models** [[paper]](https://arxiv.org/abs/2010.00840)  [Peng Xu, Mostofa Patwary, Mohammad Shoeybi, Raul Puri, Pascale Fung, Anima Anandkumar, Bryan Catanzaro] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/7d884b40ef5892f61e0f6f358b8e29983f64a178?fields=citationCount)]()
- `ACL-2019` **Learning to Control the Fine-grained Sentiment for Story Ending Generation** [[paper]](https://aclanthology.org/P19-1603/) [Fuli Luo, Damai Dai, Pengcheng Yang, Tianyu Liu, Baobao Chang, Zhifang Sui, Xu Sun] 
- `IJCAI-2019` **Controllable Neural Story Plot Generation via Reward Shaping** [[paper]](https://arxiv.org/abs/1809.10736) [Pradyumna Tambwekar, Murtaza Dhuliawala, Lara J. Martin, Animesh Mehta, Brent Harrison, Mark O. Riedl] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/ff0a76fa0be5eb09e735f7c148f7dc95397fab30?fields=citationCount)]()
- `ACL-2018` **Towards Controllable Story Generation** [[paper]](https://aclanthology.org/W18-1505.pdf) [Nanyun Peng, Marjan Ghazvininejad, Jonathan May, Kevin Knight] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/f9de0d4a5adefc59bfb033f162d8a4a5212882cf?fields=citationCount)]()

### Reasonable Story
- `SIGIR-2022` **What makes the story forward? inferring commonsense explanations as prompts for future event generation** [[paper]](https://arxiv.org/abs/2201.07099) [Li Lin, Yixin Cao, Lifu Huang, Shu'ang Li, Xuming Hu, Lijie Wen, Jianmin Wang]
- `EMNLP Findings-2022` **Inferring the Reader: Guiding Automated Story Generation with Commonsense Reasoning** [[paper]](https://arxiv.org/abs/2105.01311)  [Xiangyu Peng, Siyan Li, Sarah Wiegreffe, Mark Riedl] 
- `AAAI-2021` **Automated Storytelling via Causal, Commonsense Plot Ordering** [[paper]](https://arxiv.org/abs/2009.00829) [Prithviraj Ammanabrolu, Wesley Cheung, William Broniec, Mark O. Riedl] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/4e0af5f4944c16e3ae49b3c96cce7f81989c30f8?fields=citationCount)]()
- `AIIDE-2020` **Bringing Stories Alive: Generating Interactive Fiction Worlds** [[paper]](https://arxiv.org/abs/2001.10161)  [[code]](https://github.com/rajammanabrolu/WorldGeneration) [Prithviraj Ammanabrolu, Wesley Cheung, Dan Tu, William Broniec, Mark O. Riedl] 
- `TACL-2020` **A Knowledge-Enhanced Pretraining Model for Commonsense Story Generation** [[paper]](https://arxiv.org/abs/2001.05139)  [Jian Guan, Fei Huang, Zhihao Zhao, Xiaoyan Zhu, Minlie Huang] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/c6a84615bc36486cd0170f8a3e1b7e5ec8f5344e?fields=citationCount)]()
- `EMNLP-2020` **Improving Neural Story Generation by Targeted Common Sense Grounding** [[paper]](https://arxiv.org/abs/1908.09451) [[code]](https://github.com/calclavia/story-generation) [Huanru Henry Mao, Bodhisattwa Prasad Majumder, Julian McAuley, Garrison W. Cottrell] 
- `AAAI-2019` **Story Ending Generation with Incremental Encoding and Commonsense Knowledge** [[paper]](https://arxiv.org/abs/1808.10113)  [Jian Guan, Yansen Wang, Minlie Huang] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/d03d24241fc95e018517d6b1e3be40c5dc31ee66?fields=citationCount)]()

### Benchmark
#### Evaluation
- `TACL-2024` **Do Language Models Enjoy Their Own Stories? Prompting Large Language Models for Automatic Story Evaluation** [[paper]](https://arxiv.org/abs/2405.13769) [Cyril Chhun, Fabian M. Suchanek, Chloé Clavel] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/11dda1081d32b607ea89b7e1028052af5583b25d?fields=citationCount)]()
- `Arxiv-2024` **Reading Subtext: Evaluating Large Language Models on Short Story Summarization with Writers** [[paper]](https://arxiv.org/abs/2403.01061) [Melanie Subbiah, Sean Zhang, Lydia B. Chilton, Kathleen McKeown] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/96b6592a0a4257b9cf093a44140fec7916a09c06?fields=citationCount)]()
- `ArXiv-2023` **Experimental Narratives: A Comparison of Human Crowdsourced Storytelling and AI Storytelling** [[paper]](https://arxiv.org/abs/2310.12902) [Nina Begus] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/db599a0ffcaf891bda55b62dafe348c3cc88ec6e?fields=citationCount)]()
- `ArXiv-2023` **Learning Personalized Story Evaluation** [[paper]](https://arxiv.org/abs/2310.03304) [Danqing Wang, Kevin Yang, Hanlin Zhu, Xiaomeng Yang, Andrew Cohen, Lei Li, Yuandong Tian] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/5df238894c82b0ff8846290f6a660d2a9ee1963c?fields=citationCount)]()
- `ArXiv-2023` **BooookScore: A systematic exploration of book-length summarization in the era of LLMs**[[paper]](https://arxiv.org/abs/2310.00785)[Yapei Chang, Kyle Lo, Tanya Goyal, Mohit Iyyer] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/65fe385a665480b41fafc56d76a3bd72e92e8886?fields=citationCount)]()
- `ArXiv-2023` **TIGERScore: Towards Building Explainable Metric for All Text Generation Tasks**[[paper]](https://arxiv.org/abs/2310.00752)[Dongfu Jiang, Yishan Li, Ge Zhang, Wenhao Huang, Bill Yuchen Lin, Wenhu Chen] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/d238a9770d24d0725656ef6cf4789afebf2126e7?fields=citationCount)]()
- `CHI-2023` **Art or Artifice? Large Language Models and the False Promise of Creativity** [[paper]](https://arxiv.org/abs/2309.14556) [Tuhin Chakrabarty, Philippe Laban, Divyansh Agarwal, Smaranda Muresan, Chien-Sheng Wu]   [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/7b1a6db0909856a345f055a9607f43711b3df375?fields=citationCount)]()
- `ACL-2023` **HAUSER: Towards Holistic and Automatic Evaluation of Simile Generation** [[paper]](https://arxiv.org/abs/2306.07554) [Qianyu He, Yikai Zhang, Jiaqing Liang, Yuncheng Huang, Yanghua Xiao, Yunwen Chen]
- `ACL-2023` **Can Large Language Models Be an Alternative to Human Evaluations?** [[paper]](https://arxiv.org/abs/2305.01937) [Cheng-Han Chiang, Hung-yi Lee] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/03055978e278960de9fbb5c648b1779ef9f26cd1?fields=citationCount)]()
- `ArXiv-2023` **DeltaScore: Evaluating Story Generation with Differentiating Perturbations** [[paper]](https://arxiv.org/abs/2303.08991) [Zhuohan Xie, Miao Li, Trevor Cohn, Jey Han Lau] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/a20f5eb74febd8d7115f6986e5d15f1a5c58deaa?fields=citationCount)]()
- `INLG-2023` **The Next Chapter: A Study of Large Language Models in Storytelling** [[paper]](https://arxiv.org/abs/2301.09790) [Zhuohan Xie, Trevor Cohn, Jey Han Lau] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/d01f6e76e67a445f23f807c0d3e68fa0be9a2c9e?fields=citationCount)]()
- `IEEE Access-2023` **Comparison of Evaluation Metrics for Short Story Generation** [[paper]](https://ieeexplore.ieee.org/ielx7/6287639/6514899/10329351.pdf) [P. Netisopakul, Usanisa Taoto] 
- `EMNLP-2022` **StoryER: Automatic Story Evaluation via Ranking, Rating and Reasoning** [[paper]](https://arxiv.org/abs/2210.08459) [Hong Chen, Duc Minh Vo, Hiroya Takamura, Yusuke Miyao, Hideki Nakayama] 
- `COLING-2022` **Of Human Criteria and Automatic Metrics: A Benchmark of the Evaluation of Story Generation** [[paper]](https://arxiv.org/abs/2208.11646)  [Cyril Chhun, Pierre Colombo, Chloé Clavel, Fabian M. Suchanek]
- `TACL-2022` **LOT: A story-centric benchmark for evaluating Chinese long text understanding and generation** [[paper]](https://arxiv.org/abs/2108.12960) [Jian Guan, Zhuoer Feng, Yamei Chen, Ruilin He, Xiaoxi Mao, Changjie Fan, Minlie Huang] 
- `ACL-2021` **Openmeva: A benchmark for evaluating open-ended story generation metrics** [[paper]](https://arxiv.org/abs/2105.08920) [Jian Guan, Zhexin Zhang, Zhuoer Feng, Zitao Liu, Wenbiao Ding, Xiaoxi Mao, Changjie Fan, Minlie Huang] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/7ffc1b425026e916cd6db37c79df3e08e8f47ee6?fields=citationCount)]()
- `EMNLP-2020` **Union: An unreferenced metric for evaluating open-ended story generation** [[paper]](https://arxiv.org/abs/2009.07602) [[code]](https://github.com/thu-coai/UNION) [Jian Guan, Minlie Huang] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/70aa38ddb852ff33fcf990792ca0690047464f99?fields=citationCount)]()
- `CoNLL-2019` **Do Massively Pretrained Language Models Make Better Storytellers?** [[paper]](https://arxiv.org/abs/1909.10705) [[code]](https://github.com/abisee/story-generation-eval) [Abigail See, Aneesh Pappu, Rohun Saxena, Akhila Yerukola, Christopher D. Manning] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/65650c58498c34a019bdbd422c3737a512cc4b28?fields=citationCount)]()
- `NAACL-2016` **A Corpus and Evaluation Framework for Deeper Understanding of Commonsense Stories** [[paper]](https://arxiv.org/abs/1604.01696) [Nasrin Mostafazadeh, Nathanael Chambers, Xiaodong He, Devi Parikh, Dhruv Batra, Lucy Vanderwende, Pushmeet Kohli, James Allen] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/2a0114dc4d8ee374506be68bda20c8cd78200c66?fields=citationCount)]()

#### Dataset
- `ArXiv-2024` **CollabStory: Multi-LLM Collaborative Story Generation and Authorship Analysis** [[paper]](https://arxiv.org/abs/2406.12665) [Saranya Venkatraman, Nafis Irtiza Tripto, Dongwon Lee]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/6771b7a44ce0a4573a30a366202c395538e80302?fields=citationCount)]()
- `IREC-COLING-2024` **Reflections & Resonance: Two-Agent Partnership for Advancing LLM-based Story Annotation** [[paper]](https://aclanthology.org/2024.lrec-main.1206/) [Yuetian Chen, Mei Si]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/5559636503f19614bb6580af5d2917b62f8c0c47?fields=citationCount)]()
- `ArXiv-2024` **CMDAG: A Chinese Metaphor Dataset with Annotated Grounds as CoT for Boosting Metaphor Generation** [[paper]](https://arxiv.org/abs/2402.13145) [Yujie Shao, Xinrong Yao, Xingwei Qu, Chenghua Lin, Shi Wang, Stephen W. Huang, Ge Zhang, Jie Fu]  [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/c4d76cfb9bf2ffcdd38739b41840141507bee0d3?fields=citationCount)]()
- `ArXiv-2023` **STONYBOOK: A System and Resource for Large-Scale Analysis of Novels** [[paper]](https://arxiv.org/abs/2311.03614) [Charuta Pethe, Allen Kim, Rajesh Prabhakar, Tanzir Pial, Steven Skiena]
- `ACL-2023` **StoryWars: A Dataset and Instruction Tuning Baselines for Collaborative Story Understanding and Generation** [[paper]](https://arxiv.org/abs/2305.08152) [Yulun Du, Lydia Chilton] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/d771baacb7407f2ea22a67187c7014ba7688eb3b?fields=citationCount)]()
- `TACL-2023` **PASTA: A Dataset for Modeling Participant States in Narratives** [[paper]](https://arxiv.org/abs/2208.00329) [Sayontan Ghosh, Mahnaz Koupaee, Isabella Chen, Francis Ferraro, Nathanael Chambers, Niranjan Balasubramanian]
- `NAACL-2022` **A corpus for understanding and generating moral stories** [[paper]](https://arxiv.org/abs/2204.09438) [Jian Guan, Ziqi Liu, Minlie Huang] 
- `EVAL4NLP-2021` **StoryDB: Broad Multi-language Narrative Dataset** [[paper]](https://arxiv.org/abs/2109.14396) [Alexey Tikhonov, Igor Samenko, Ivan P. Yamshchikov]  
- `ACL-2022` **SummScreen: A Dataset for Abstractive Screenplay Summarization** [[paper]](https://arxiv.org/abs/2104.07091) [[data]](https://github.com/mingdachen/SummScreen) [Mingda Chen, Zewei Chu, Sam Wiseman, Kevin Gimpel] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/43eee0596facea9faf72e3ab3a734d32a6aa82f1?fields=citationCount)]()
- `Arxiv-2021` **TVStoryGen: A Dataset for Generating Stories with Character Descriptions** [[paper]](https://arxiv.org/abs/2109.08833) [Mingda Chen, Kevin Gimpel] 
- `EMNLP-2020` **STORIUM: A Dataset and Evaluation Platform for Machine-in-the-Loop Story Generation** [[paper]](https://arxiv.org/abs/2010.01717) [Nader Akoury, Shufan Wang, Josh Whiting, Stephen Hood, Nanyun Peng, Mohit Iyyer] [![](https://img.shields.io/badge/dynamic/json?label=citation&query=citationCount&url=https://api.semanticscholar.org/graph/v1/paper/a0035379f93e0e95bdadd77a1d8eb27ba89dcf60?fields=citationCount)]()


### Others
<details>
    <summary>Click to view details of other related papers:</summary>
    <ul>
        <li><code>ArXiv-2024</code> <strong>Ai.llude: Encouraging Rewriting AI-Generated Text to Support Creative Expression</strong> <a href="https://arxiv.org/abs/2405.17843">[paper]</a> [David Zhou, Sarah Sterman]</li>
        <li><code>ArXiv-2024</code> <strong>Word2World: Generating Stories and Worlds through Large Language Models</strong> <a href="https://arxiv.org/abs/2405.06686">[paper]</a> <a href="https://github.com/umair-nasir14/Word2World">[code]</a> [Muhammad U. Nasir, Steven James, Julian Togelius]</li>
        <li><code>ArXiv-2024</code> <strong>Let Storytelling Tell Vivid Stories: An Expressive and Fluent Multimodal Storyteller</strong> <a href="https://arxiv.org/abs/2403.07301">[paper]</a> [Chuanqi Zang, Jiji Tang, Rongsheng Zhang, Zeng Zhao, Tangjie Lv, Mingtao Pei, Wei Liang]</li>
        <li><code>CHI-2024</code> <strong>Shaping Human-AI Collaboration: Varied Scaffolding Levels in Co-writing with Language Models</strong> <a href="https://arxiv.org/abs/2402.11723">[paper]</a> [Paramveer S. Dhillon, Somayeh Molaei, Jiaqi Li, Maximilian Golub, Shaochun Zheng, Lionel P. Robert]</li>
        <li><code>Arxiv-2024</code> <strong>GhostWriter: Augmenting Collaborative Human-AI Writing Experiences Through Personalization and Agency</strong> <a href="https://arxiv.org/abs/2402.08855">[paper]</a> [Catherine Yeh, Gonzalo Ramos, Rachel Ng, Andy Huntington, Richard Banks]</li>
        <li><code>ArXiv-2023</code> <strong>Inspo: Writing Stories with a Flock of AIs and Humans</strong> <a href="https://arxiv.org/abs/2311.16521">[paper]</a> [Chieh-Yang Huang, Sanjana Gautam, Shannon McClellan Brooks, Ya-Fang Lin, Ting-Hao 'Kenneth' Huang]</li>
        <li><code>AAAI-2023</code> <strong>SceneCraft: Automating Interactive Narrative Scene Generation in Digital Games with Large Language Models</strong> <a href="https://ojs.aaai.org/index.php/AIIDE/article/view/27504">[paper]</a> [Vikram Kumaran, Jonathan Rowe, Bradford Mott, James Lester]</li>
        <li><code>ArXiv-2023</code> <strong>PEARL: Personalizing Large Language Model Writing Assistants with Generation-Calibrated Retrievers</strong> <a href="https://arxiv.org/abs/2311.09180">[paper]</a> [Sheshera Mysore, Zhuoran Lu, Mengting Wan, Longqi Yang, Steve Menezes, Tina Baghaee, Emmanuel Barajas Gonzalez, Jennifer Neville, Tara Safavi]</li>
        <li><code>EMNLP Findings-2023</code> <strong>Are NLP Models Good at Tracing Thoughts: An Overview of Narrative Understanding</strong> <a href="https://arxiv.org/abs/2310.18783">[paper]</a> [Lixing Zhu, Runcong Zhao, Lin Gui, Yulan He]</li>
        <li><code>CoNLL Workshop-2023</code> <strong>BabyStories: Can Reinforcement Learning Teach Baby Language Models to Write Better Stories?</strong> <a href="https://arxiv.org/abs/2310.16681">[paper]</a> [Xingmeng Zhao, Tongnian Wang, Sheri Osborn, Anthony Rios]</li>
        <li><code>ArXiv-2023</code> <strong>Creativity Support in the Age of Large Language Models: An Empirical Study Involving Emerging Writers</strong> <a href="https://arxiv.org/abs/2309.12570">[paper]</a> [Tuhin Chakrabarty, Vishakh Padmakumar, Faeze Brahman, Smaranda Muresan]</li>
        <li><code>UIST-2023</code> <strong>Storyfier: Exploring Vocabulary Learning Support with Text Generation Models</strong> <a href="https://arxiv.org/abs/2308.03864">[paper]</a> [Zhenhui Peng, Xingbo Wang, Qiushi Han, Junkai Zhu, Xiaojuan Ma, Huamin Qu]</li>
        <li><code>PACLIC-2023</code> <strong>Generating Character Lines in Four-Panel Manga</strong> <a href="https://aclanthology.org/2023.paclic-1.34/">[paper]</a> [Michimasa Inaba]</li>
        <li><code>ArXiv-2022</code> <strong>Creative Writing with an AI-Powered Writing Assistant: Perspectives from Professional Writers</strong> <a href="https://arxiv.org/abs/2211.05030">[paper]</a> [Daphne Ippolito, Ann Yuan, Andy Coenen, Sehmon Burnam]</li>
        <li><code>ArXiv-2022</code> <strong>Survey: Automatic Movie Plot and Script Generation</strong> <a href="https://www.cfilt.iitb.ac.in/resources/surveys/2022/prerak-ampsg-survey-27jun22.pdf">[paper]</a> [Prerak Gandhi, Pushpak Bhattacharyya]</li>
        <li><code>CHI-2022</code> <strong>TaleBrush: Sketching Stories with Generative Pretrained Language Models</strong> <a href="http://www.cond.org/talebrush.pdf">[paper]</a> [John Joon Young Chung, Wooseok Kim, Kang Min Yoo, Hwaran Lee, Eytan Adar, Minsuk Chang]</li>
        <li><code>EMNLP-2022</code> <strong>Help me write a poem: Instruction Tuning as a Vehicle for Collaborative Poetry Writing</strong> <a href="https://arxiv.org/abs/2210.13669">[paper]</a> [Tuhin Chakrabarty, Vishakh Padmakumar, He He]</li>
        <li><code>CHI-2023</code> <strong>Co-Writing Screenplays and Theatre Scripts with Language Models: An Evaluation by Industry Professionals</strong> <a href="https://arxiv.org/abs/2209.14958">[paper]</a> [Piotr Mirowski, Kory W. Mathewson, Jaylen Pittman, Richard Evans]</li>
        <li><code>NeurIPS-2022</code> <strong>Factuality Enhanced Language Models for Open-Ended Text Generation</strong> <a href="https://arxiv.org/abs/2206.04624">[paper]</a> [Nayeon Lee, Wei Ping, Peng Xu, Mostofa Patwary, Mohammad Shoeybi, Bryan Catanzaro]</li>
        <li><code>FDG-2022</code> <strong>TropeTwist: Trope-based Narrative Structure Generation</strong> <a href="https://arxiv.org/abs/2204.09672">[paper]</a> [Alberto Alvarez, Jose Font]</li>
        <li><code>IUI-2022</code> <strong>Wordcraft: Story Writing With Large Language Models</strong> <a href="https://dl.acm.org/doi/10.1145/3490099.3511105">[paper]</a> [Ann Yuan, Andy Coenen, Emily Reif, Daphne Ippolito]</li>
        <li><code>ACM Computing Surveys-2023</code> <strong>A Survey of Controllable Text Generation Using Transformer-based Pre-trained Language Models</strong> <a href="https://arxiv.org/abs/2201.05337">[paper]</a> [Hanqing Zhang, Haolin Song, Shaoyu Li, Ming Zhou, Dawei Song]</li>
        <li><code>ACL-IJCNLP-2021</code> <strong>KuiLeiXi: a Chinese Open-Ended Text Adventure Game</strong> <a href="https://aclanthology.org/2021.acl-demo.21/">[paper]</a> [Heng Ji, Jong C. Park, Rui Xia]</li>
        <li><code>IJCAI AI4Narratives-2020</code> <strong>THEaiTRE: Artificial Intelligence to Write a Theatre Play</strong> <a href="https://arxiv.org/abs/2006.14668">[paper]</a> [Rudolf Rosa, Ondřej Dušek, Tom Kocmi, David Mareček, Tomáš Musil, Patrícia Schmidtová, Dominik Jurko, Ondřej Bojar, Daniel Hrbek, David Košťák, Martina Kinská, Josef Doležal, Klára Vosecká]</li>
        <li><code>ICCC-2020</code> <strong>Toward Automated Quest Generation in Text-Adventure Games</strong> <a href="https://arxiv.org/abs/1909.06283">[paper]</a> [Prithviraj Ammanabrolu, William Broniec, Alex Mueller, Jeremy Paul, Mark O. Riedl]</li>
    </ul>
</details>

## Public Resources
- [Understanding AI for Stories](https://isamu-website.medium.com/understanding-ai-for-stories-d0c1cd7b7bdc) serves as a survey blog that delves into the application of AI in the realm of story generation, shedding light on its potential as well as the challenges that it encounters.
- [ROC Stories](https://cs.rochester.edu/nlp/rocstories/) is a compilation of 100,000 five-sentence stories and 3,742 Story Cloze Test stories, capturing a rich array of causal and temporal commonsense connections between everyday events, making it suitable for story generation tasks.
- [CommonGen](https://inklab.usc.edu/CommonGen/) was developed by combining crowdsourced and existing caption corpora, containing 79k commonsense descriptions across 35k distinct concept-sets.
- [CMU Movie Summary Corpus](http://www.cs.cmu.edu/~ark/personas/) offers access to a dataset containing movie plot summaries and related metadata.
- [Scifi TV Show Plot Summaries & Events](https://huggingface.co/datasets/lara-martin/Scifi_TV_Shows) is a collection of plot synopses for long-running (80+ episodes) science fiction TV shows, sourced from Fandom.com wikis.

![Star History Chart](https://api.star-history.com/svg?repos=yingpengma/Awesome-Story-Generation&type=Date)
