﻿program Genliblcl;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  System.Rtti,
  System.IOUtils,
  System.Generics.Collections,
  System.TypInfo,
  System.SysUtils,
  System.Classes,
  System.UITypes,
  System.Types,
  System.IniFiles,
  System.Variants,
  System.Win.Registry,
  Vcl.Forms,
  Vcl.StdCtrls,
  Vcl.Dialogs,
  Vcl.ExtCtrls,
  Vcl.Graphics,
  Vcl.Controls,
  Vcl.ComCtrls,
  Vcl.ToolWin,
  Vcl.ImgList,
  Vcl.ExtDlgs,
  Vcl.Buttons,
  Vcl.ActnList,
  Vcl.Menus,
  Vcl.Clipbrd,
  Vcl.Mask,
  SHDocVw,
  Vcl.Grids,
  Vcl.ValEdit,
  Vcl.CheckLst,
  Vcl.Imaging.GIFImg,
  Vcl.Imaging.pngimage,
  Vcl.Imaging.jpeg,
  Vcl.Samples.Gauges,
  Vcl.Samples.Spin,
  Vcl.Printers,
  uLazarusPatchs in 'uLazarusPatchs.pas',
  ImageButton in '..\..\src\ImageButton.pas',
  MSHTML in '..\..\src\MSHTML.pas',
  uMiniWebview in '..\..\src\uMiniWebview.pas',
  WebJSExternal_TLB in '..\..\src\WebJSExternal_TLB.pas',
  xbutton in '..\..\src\xbutton.pas';

(*

// 纯RTTI方式


// 生成函数方式
// _ + FMX + _ + ClassName + MethodName
procedure _FMX_TApplication_Run(Handle: Pointer)
// string方式全部使用PWideChar
// class或者其它的全部使用Pointer类型


// 单元以 .inc 为主，主单元只有一个
{$I FMX_Forms.inc}
{$I FMX_Application.inc}

每个inc文件内部为

函数

exports
  函数




*)


type
  TCommentItem = record
    CN: string;
    EN: string;
  end;

var
  GFilterTable, GCTypeTable, GEvents, GAddTypePkgs, GAddUnsafePkgs: TDictionary<string, string>;
  GGoApiPath, GGoVclPath: string;
  GGoSrcFile, GIsAsFile, GExportTable, GDllImportTable: TStringList;
  GCommentInfo: TDictionary<string, TCommentItem>;


function CanConv(AName: string): Boolean; forward;
function GetCType(AName: string): string; forward;
function DTypeConvert(AType: TRttiType; IsInterfaceToPointer: Boolean = False): string; forward;
function DVarFlagsStr(AFlags: TParamFlags): string; forward;

procedure AddHeaderInfo(AStrs: TStrings; AIsGo: Boolean);
begin
  AStrs.Add('');
  AStrs.Add('//----------------------------------------');
  AStrs.Add('// The code is automatically generated by the GenlibLcl tool.');
  AStrs.Add('// Copyright © ying32. All Rights Reserved.');
  AStrs.Add('// ');
  if AIsGo then
    AStrs.Add('// Licensed under Apache License 2.0')
  else
    AStrs.Add('// Licensed under Lazarus.modifiedLGPL');
  AStrs.Add('//');
  AStrs.Add('//----------------------------------------');
  AStrs.Add('');
end;


function IfThen(AB: Boolean; ATrue, AFalse: string): string; overload; inline;
begin
  if AB then Result := ATrue else Result := AFalse;
end;

function TypeIsRecOrFloat(AType: TRttiType): Boolean;
var
  LArr: TArray<string>;
  LBaseType: string;
  LR: TRttiInstanceType;
begin
  Result := False;
  if AType = nil then Exit;
  case AType.TypeKind of
    tkRecord, tkFloat, tkInt64:
      begin
        Result := True;
      end;
  else
    Result := False;
  end;
end;

function TypeIsDateTime(AType: TRttiType): Boolean;
var
  LArr: TArray<string>;
  LBaseType: string;
  LR: TRttiInstanceType;
begin
  Result := False;
//  // 先屏蔽掉
  if AType = nil then Exit;
  case AType.TypeKind of
    tkFloat:
      Result := AType.Name.Equals('TDate') or
                AType.Name.Equals('TTime') or
                AType.Name.Equals('TDateTime');
  else
    Result := False;
  end;
end;

function GetReturnTypeKind(AType: TRttiType): TTypeKind;
begin
  Result := TTypeKind.tkUnknown;
  if AType = nil then Exit;
  Result := AType.TypeKind;
end;
//
//function TypeIsDateTime22222(AType: TRttiType): Boolean;
//var
//  LArr: TArray<string>;
//  LBaseType: string;
//  LR: TRttiInstanceType;
//begin
//  Result := False;
//  // 先屏蔽掉
//  if AType = nil then Exit;
//  case AType.TypeKind of
//    tkFloat:
//      Result := AType.Name.Equals('TDate') or
//                AType.Name.Equals('TTime') or
//                AType.Name.Equals('TDateTime');
//  else
//    Result := False;
//  end;
//end;

function GetDelphiParamsStr(AParams: TArray<TRttiParameter>; APatch: Integer = 0): string;
var
 LP: TRttiParameter;
 I: Integer;
begin
  Result := '';
  if Length(AParams) > 0 then
  begin
    for I := 0 to High(AParams) + APatch do
    begin
      LP := AParams[I];
      if I > 0 then
        Result := Result + '; ';
      Result := Result + DVarFlagsStr(LP.Flags) +
         IfThen(TypeIsRecOrFloat(LP.ParamType) and not TypeIsDateTime(LP.ParamType)
         , IfThen(not (pfVar in LP.Flags), 'var ', ''), '') + LP.Name + IfThen(LP.ParamType = nil, '', ': ') + DTypeConvert(LP.ParamType);
    end;
  end;
end;

function GetDelphiParamsName(AParams: TArray<TRttiParameter>; AIsSub: Integer = 0): string;
var
 LP: TRttiParameter;
 I: Integer;
begin
  Result := '';
  if Length(AParams) > 0 then
  begin
    for I := 0 to High(AParams) + AIsSub do
    begin
      LP := AParams[I];
      if I > 0 then
        Result := Result + ', ';
      if TypeIsDateTime(LP.ParamType) then
        Result := Result + 'UnixToTime(' + LP.Name + ')'
      else
        Result := Result + LP.Name;
    end;
  end;
end;

function DVarFlagsStr(AFlags: TParamFlags): string;
begin
  Result := '';
  if pfOut in AFlags then
    Result := 'out '
  else if pfVar in AFlags then
    Result := 'var '
//  else if pfConst in AFlags then
//    Result := ' '//'const ';
end;


// 有些平台不能使用相关函数
function IsOnlyWindowsFunc(AF: string): Boolean;
begin
  Result := False;
//  if AF.Contains('LoadFromResourceID') then
//    Result := True;
end;

// 在go中，delphi out var 需要使用指针传递
function TypeIsDelphiVarFlag(AP: TRttiParameter): Boolean;
begin
  Result := False;
  if AP = nil then Exit;
  if (pfVar in AP.Flags) or (pfOut in AP.Flags) then
    Result := True;
end;

function DTypeConvert(AType: TRttiType; IsInterfaceToPointer: Boolean = False): string;
begin
  if AType = nil then
    Exit('');
  case AType.TypeKind of
    tkString, tkLString, tkWString, tkUString:
      Result := 'PChar';
    tkInterface:
      begin
        if IsInterfaceToPointer then
          Result := 'Pointer'
        else Result := AType.Name;
      end
  else
    if AType.Name.Equals('PWideChar') then
      Result := 'PChar'
    else
    if (AType.Name = 'Boolean') or (AType.Name = 'WordBool') then
      Result := 'LongBool'
    else if TypeIsDateTime(AType) then
      Result := 'TUnixDateTime'
    else if AType.Name.Equals('TCustomLinkLabel.TLinkAlignment') then
      Result := 'TAlignment'
    else if AType.Name = 'TItemStates' then
      Result := 'TListItemStates'
    else if AType.Name = 'TItemState' then
     Result := 'TListItemState'
    else
//    if AType.Name.Equals('TMargins') then
//      Result := 'TControlBorderSpacing'
//    else
      Result := AType.Name;
  end;
end;

procedure SaveToUTF8(AList: TStrings; AFileName: string);
var
  LStream: TStringStream;
begin
  LStream := TStringStream.Create('', TEncoding.UTF8);
  try
    LStream.WriteString(AList.Text);
    LStream.Position := 0;
    LStream.SaveToFile(AFileName);
  finally
    LStream.Free;
  end;
end;

function GetNewMethod(AInst, AOrgName: string; AIsC: Boolean): string; inline;
begin
  if AInst[1] = 'T' then
    Delete(AInst, 1, 1);
  Result := Format('%s%s_%s', [IfThen(not AIsC, '', '_'), AInst, AOrgName]);
end;

function GetFirstParamName(AInst: string): string;
begin
  Result := 'AOwner';
  if AInst.Equals('TIniFile') then
    Result := 'AFileName'
  else if AInst.Equals('TRegistry') then
    Result := 'AAccess';   
end;



function GetDelphiMethodCode(AOrgName, AInst, ARetType, AParamsStr, AParamNames: string;
   AIsConstructor: Boolean; AIsRead: Boolean = False; AIsWrite: Boolean = False;
   AIsComponent: Boolean = True; AIsRec: Boolean = False; AisIndex: Boolean = False;
   AIndexName: string = ''; AIndexType: string = ''; AIndexName2: string = ''; AIndexType2: string = ''; ATypeKind: TTypeKind = TTypeKind.tkUnknown): string;

   function GetRealOwnerType: string;
   begin
     Result := 'TComponent';
     if AInst.Equals('TListGroups') or AInst.Equals('TListColumns') or AInst.Equals('TListItems') then
       Result := 'TCustomListView'
     else if AInst.Equals('TListItem') then
       Result := 'TListItems'
     else if AInst.Equals('TTreeNodes') then
       Result := 'TCustomTreeView'
     else if AInst.Equals('TTreeNode') then
       Result := 'TTreeNodes'

//     else if AInst.Equals('TStatusPanels') then
//       Result := 'TCustomStatusBar'
     else if AInst.Equals('TCollectionItem') or AInst.Equals('TListGroup') or
        AInst.Equals('TListColumn') or AInst.Equals('TCustomStatusBar') or
        AInst.Equals('TStatusPanel') then
       Result := 'TCollection'
     else if AInst.Equals('TGIFFrame') then
       Result := 'TGIFImage'
     else if AInst.Equals('TIniFile') then
       Result := 'PChar'  // string
     else if AInst.Equals('TMargins') then
       Result := 'TControl'
    // else if AInst.Equals('TMonthCalColors') then
     //  Result := 'TCommonCalendar'
     else if AInst.Equals('TParaAttributes') or AInst.Equals('TTextAttributes') then
       Result := 'TCustomRichEdit'

     else if AInst.Equals('TRegistry')  then
       Result := 'LongWord'

     else if AInst.Equals('TStatusPanels') then
       Result := 'TStatusBar'
     else if AInst.Equals('TDragObject') or AInst.Equals('TDragDockObject') then
       Result := 'TControl'
     else if AInst.Equals('TCoolBands') then
       Result := 'TCoolBar'
    	else if AInst.Equals('THeaderSection') or AInst.Equals('TCoolBand') then
       Result := 'TCollection'
     else if AInst.Equals('THeaderSections') then
       Result := 'TCustomHeaderControl'
     else if AInst.Equals('TCoolBand') then
       Result := 'TCollection'
     else if AInst.Equals('TCollection') then

       Result := 'TCollectionItemClass'
     else if AInst.Equals('TTaskDialogProgressBar') then
       Result := 'TCustomTaskDialog'
     else if AInst.Equals('TTaskDialogButtonItem') or AInst.Equals('TTaskDialogRadioButtonItem') or AInst.Equals('TTaskDialogBaseButtonItem') then
       Result := 'TCollection'
     else if AInst.Equals('TTaskDialogButtons') then
      Result := 'TPersistent; ItemClass: TCollectionItemClass'
       // TPointerList
   end;

   function GetParam2Name: string;
   begin
     Result := '';
     if Ainst.Equals('TTaskDialogButtons') then
       Result := ', ItemClass';
   end;

   function GetRetType2(AType: string): string;
   begin
     Result := AType;
     if Result = 'shortstring' then
       Result := 'PChar'
     else if Result = 'TPointerList' then
       Result := 'PPointerList'
     else if Result = 'TJPEGPixelFormat' then
       Result := 'TPixelFormat'
//     else if Result = 'TMargins' then
//       Result := 'TControlBorderSpacing';

//     else if Result = 'TForm' then
//       Result := 'TGoForm';
   end;

   // 重新转转换调用的类型    ，这里因为delphi跟lazarus有些名不一样，所以这里lazarus最终换下
   function GetRNameMethodName(AM2: string): string;
   begin
     Result := AM2;
     if AInst.Equals('TTreeNode') and AM2.Equals('Item')  then
        Result := 'Items'
     else if AInst.Equals('TPopupMenu') then
     begin
       if AM2.Equals('CloseMenu') then
         Result := 'Close'
       else if AM2.Equals('Popup') then
         Result := 'PopUp'
     end else
     if Result.Equals('Margins') then
       Result := 'BorderSpacing';
   end;

   // 强制转换一个类
   function CovClass(): string;
   begin
     Result := '';
     if AIsRead or (not AIsWrite) then
     begin
       if AInst.Equals('TBrush') and AOrgName.Equals('Bitmap') then
         Result := ' as TBitmap'
       else if AInst.Equals('TStatusPanels') and AOrgName.Equals('Insert') then
         Result := ' as TStatusPanel'
       else if AInst.Equals('TValueListEditor') and AOrgName.Equals('Strings') then
         Result := ' as TValueListStrings'
       else if AInst.Equals('TCoolBand') and AOrgName.Equals('Control') then
         Result := ' as TWinControl'
     end else if AIsWrite then
     begin
       if AInst.Equals('TValueListEditor') and AOrgName.Equals('Strings') then
         Result := ' as TValueListStrings'
     end;
   end;

var
  LCode, LFirstParamName, LCType, LMName, LTempStr: string;
label
  g1;
begin
  if AIsConstructor then
  begin
    LFirstParamName := GetFirstParamName(AInst);
  end
  else LFirstParamName := 'AObj';
  if ARetType.IsEmpty then
    LCode := 'procedure '
  else
  begin
    if {AIsRead and} AIsRec then
      LCode := 'procedure '
    else
      LCode := 'function ';
  end;

//  AOrgName := GetRNameMethodName(AOrgName);

  LMName := AOrgName;
  if AIsRead then
    LMName := 'Get' + LMName
  else if AIsWrite then
    LMName := 'Set' + LMName;

  LCode := LCode + GetNewMethod(AInst, LMName, False);
  if AIsComponent then
  begin
    LCode := LCode + '(' + LFirstParamName + ': ' + IfThen(AIsConstructor, GetRealOwnerType, IfThen(AInst = 'TForm', 'TGoForm', AInst));

    if AParamsStr <> '' then
      LCode := LCode + '; ' + AParamsStr;

    if AisIndex and AIsRead then
    begin
      LCode := LCode + '; ' + AIndexName + ': ' + AIndexType;
      if not AIndexName2.IsEmpty and not AIndexType2.IsEmpty then
        LCode := LCode + '; ' + AIndexName2 + ': ' + AIndexType2;
    end;



    if not(AIsRec{ and AIsRead}) then
      LCode := LCode + ')';
  end;

  LCType := '';
  if ARetType <> '' then
  begin
    if ARetType = 'PChar' then
      LCType := 'PChar';

    if LCType <> '' then
      ARetType := LCType;

    if AIsRec {and AIsRead} then
      LCode := LCode +  '; var Result: ' + GetRetType2(ARetType) + ')'
    else
      LCode := LCode + ': ' + GetRetType2(ARetType);
  end;
  LCode := LCode + '; extdecl;'#13#10;
  LCode := LCode + 'begin'#13#10;

//  if IsOnlyWindowsFunc(LMName) then
//    LCode := LCode + '{$IFDEF MSWINDOWS}'#13#10;

  // 当定义使用异常处理时，有返回值的必须返回一个默认的
  if (ARetType <> '') and (not AIsRec) then
  begin
    LCode := LCode + '{$ifdef UsehandleException}';
    LCode := LCode + 'Result := ';

    if ATypeKind = TTypeKind.tkSet then
      LCode := LCode + '[]'
    else if (ARetType.ToLower = 'shortstring') or (AIndexType.ToLower = 'shortstring') or ARetType.Equals('TPointerList') then
      LCode := LCode + 'nil'
    else if ARetType.Equals('LongBool') then
      LCode := LCode + 'False'
    else if ARetType.Equals('TUnixDateTime') then
      LCode := LCode + '0'
    else if ARetType.Equals('TScrollBarInc') then
      LCode := LCode + '1'
    else if ARetType.Equals('Char') then
      LCode := LCode + '#0'
    else if (ATypeKind = TTypeKind.tkEnumeration) then
      LCode := LCode + 'Low(' + ARetType + ')'
    else if (ATypeKind = TTypeKind.tkInteger) or (ATypeKind = TTypeKind.tkInt64) then
      LCode := LCode + ARetType +  '(0)'
    else if (ATypeKind = TTypeKind.tkClass) or (ATypeKind = TTypeKind.tkInterface) or (ATypeKind = TTypeKind.tkPointer) then
      LCode := LCode + 'nil'
    else
      LCode := LCode + ARetType +  '(nil)';

    LCode := LCode + ';';
    LCode := LCode + '{$endif}'#13#10;
  end;
  // 异常开始
  LCode := LCode + '  handleExceptionBegin'#13#10;


  if ARetType <> '' then
    LCode := LCode + '  Result :=';



  // 特殊
  if AInst.Equals('TForm') and AOrgName.Equals('Create') then
    AOrgName := 'CreateNew';

  

//  if AIsConstructor and not AIsComponent then
//  begin
//    LCode := LCode + '  ' + AInst + '.' + AOrgName;
//    goto g1;
//  end;

   // 变通下
  if (ARetType = 'TUnixDateTime') or (AIndexType = 'TUnixDateTime') then
     LCType := 'ToUnixTime'
  else if (ARetType.ToLower = 'shortstring') or (AIndexType.ToLower = 'shortstring') then
     LCType := 'ToPChar';



  // 这里改新的方法
  AOrgName := GetRNameMethodName(AOrgName);

  if AIsWrite then
  begin
    LTempStr := AParamNames; //'AValue';
    if True then

    if AisIndex then
    begin
      LCode := LCode + '  AObj.' + AOrgName + '[' + AIndexName;
      if not AIndexName2.IsEmpty and not AIndexType2.IsEmpty then
        LCode := LCode + ', ' + AIndexName2;

      LCode := LCode + '] := ' + LTempStr

    end
    else
      LCode := LCode + '  AObj.' + AOrgName + ' := ' + LTempStr;
    goto g1;
  end;


  if LCType <> '' then
    LCode := LCode + '  ' + LCType + '(';

  if AIsConstructor then
  begin
    LCode := LCode + '  ' + IfThen(AInst = 'TForm', 'TGoForm', AInst) + '.' + AOrgName;
    if AIsComponent then
      LCode := LCode  + '(' + LFirstParamName + GetParam2Name  + ')';
    goto g1;
  end;
  // 强制转换的
  if LCType = '' then
    LCode := LCode + '  ';
  // read属性
     // macOS下这个返回的长度不对
  if LMName = 'GetTextLen' then
  begin
    LCode := LCode + '{$ifdef darwin}Length(AObj.Caption){$else}' + LFirstParamName + '.' + AOrgName + '{$endif}';
  end else
    LCode := LCode + LFirstParamName + '.' + AOrgName + IfThen(AIsRead and AisIndex, '[' + AIndexName + IfThen(not AIndexName2.IsEmpty and not AIndexType2.IsEmpty, ', ' + AIndexName2, '') + ']', '');

  if AParamNames <> '' then
    LCode := LCode + '(' + AParamNames + ')';

  if LCType <> '' then
    LCode := LCode + ')';
g1:
  LCode := LCode + CovClass + ';'#13#10;
  //if (AInst.Equals('TListView') or AInst.Equals('TTreeView')) and (AOrgName.Equals('Create')) then
  //  LCode := LCode + '  Result.ScrollBars := ssAutoBoth;' + sLineBreak;

   // 异常结束
  LCode := LCode + '  handleExceptionEnd'#13#10;

//  if IsOnlyWindowsFunc(LMName) then
//    LCode := LCode + '{$ENDIF MSWINDOWS}'#13#10;
  LCode := LCode + 'end;'#13#10;
  Result := LCode;
end;

procedure MakeObjIncFile(AGoHeaderFile, ADelphiUnitFile: TStringList; APath: string; AClass: TClass;
 AIsComponent: Boolean = True;    // 为true不一定是组件
 ANoCreateAndFree: Boolean = False; AGenDelphiInc: Boolean = True); // 有些类不需要用户进行管理的，不给他们创建和释放
var
    LExports, LIncFile: TStringList;
    LMName: string;


    function InStrArray(const AIn: string; AArrString: array of string): Boolean;
    var S: string;
    begin
      Result := False;
      for S in AArrString do
        if SameText(AIn, S) then
          Exit(True);
    end;

    procedure AddExport(AInst, AOrgMName: string);
    var
      f: string;
    begin
      f := GetNewMethod(AInst, AOrgMName, False);
      LExports.Add(Format('  %s,', [f, f]));

      //GExportTable.Add(Format('AddToExportTable(''%s'', @%s);', [f, f]));

      //LExports.Add(Format('  %s {$IFNDEF MSWINDOWS}name ''_%s''{$ENDIF},', [f, f]));
    end;

    function IsComponent: Boolean;
    begin
      Result := AClass.InheritsFrom(TComponent);
//      if AClass.InheritsFrom(TRegistry) or AClass.InheritsFrom(TIniFile) then
//        Result := False;
    end;

    function IsControl: Boolean;
    begin
      Result := AClass.InheritsFrom(TControl);
    end;

    function IsWinControl: Boolean;
    begin
      Result := AClass.InheritsFrom(TWinControl);
    end;


    function IsObject(AV: TRttiType): Boolean;
    begin
      if AV = nil then
         Exit(False);
      case AV.TypeKind of
        tkClass,tkInterface,tkClassRef:
          Result := True;
      else
        Result := False;
      end;
    end;



    function CovRetType(AMName: string; ARetType: string): string;
    begin
      Result := ARetType;
      if AMName.Equals('ClassName') then
        Result := 'shortstring'

    end;


    function isMethodSub(AName: string): Integer;
    begin
      Result := 0;
      if AName.Equals('ControlAtPos') then
        Result := -1;
    end;



    function GetNonPtrFlags(AParams: TArray<TRttiParameter>): string;
    var
     LP: TRttiParameter;
     I: Integer;
    begin
      Result := '';
      if Length(AParams) > 0 then
      begin
        for I := 0 to High(AParams) do
        begin
          LP := AParams[I];
          if TypeIsRecOrFloat(LP.ParamType) and (not TypeIsDateTime(LP.ParamType)) and ( not(pfVar in LP.Flags) and not(pfOut in LP.Flags))  then
          begin
            if Result <> '' then
              Result := Result + ',';
            Result := Result + Format('%d=nonPtr', [I+2]);   //+2，第一个参数是obj，不在列表中
          end;
        end;
      end;
    end;

    procedure MakeMethodCode(AInstName: string; AMethod: TRttiMethod; AIsMethod: Boolean);
    var
      LDRetStr: string;
      LParams: TArray<TRttiParameter>;
      LPsNonPtrFlags: string;
    begin
      LDRetStr := '';
      if AMethod.ReturnType <> nil then
        LDRetStr := DTypeConvert(AMethod.ReturnType);
      LParams := AMethod.GetParameters;
      if True then
      // 添加标识，用于标识是最后一个参数返回的
      if TypeIsRecOrFloat(AMethod.ReturnType) {and not TypeIsDateTime(AMethod.ReturnType)} then
        LIncFile.Add('//RETURNISLASTPARAM:');

     //// 2=nonPtr,4=nonPtr
      LPsNonPtrFlags := GetNonPtrFlags(AMethod.GetParameters);
      if LPsNonPtrFlags <> '' then
        LIncFile.Add('//PARAMS:' + LPsNonPtrFlags);

      LIncFile.Add(GetDelphiMethodCode(AMethod.Name, AInstName, CovRetType(AMethod.Name, LDRetStr),
                   GetDelphiParamsStr(LParams, isMethodSub(AMethod.Name)),
         GetDelphiParamsName(LParams, isMethodSub(AMethod.Name)), False, False, False, True,
         TypeIsRecOrFloat(AMethod.ReturnType) {and not TypeIsDateTime(AMethod.ReturnType)} , False, '', '', '', '', GetReturnTypeKind(AMethod.ReturnType)));
      AddExport(AInstName, AMethod.Name);
    end;

    procedure AddConstructorAndDestructor(AInstName: string);
    begin
      AddHeaderInfo(LIncFile, False);
      // Create
      LIncFile.Add(GetDelphiMethodCode('Create', AInstName, AInstName, '', '', True, False, False, AIsComponent,
        False, False, '', '', '', '', TTypeKind.tkClass));
      AddExport(AInstName, 'Create');

      // Free
      LIncFile.Add(GetDelphiMethodCode('Free', AInstName, '', '', '', False));
      AddExport(AInstName, 'Free');
    end;

    // 参数类型转换，go只我只申明两个一个是TControl一个是TObject
    function ClassParamCov(AN: string; AIsRet: Boolean): string;
    begin
      Result := AN;

      if AN.Equals('TComponent') then
        Result := '*TComponent'
      else
      if InStrArray(AN, ['TWinControl', 'TCustomListView', 'TCustomTreeView'])  then
         Result := '*TWinControl'
//      else if AN.Equals('TCustomListView') or AN.Equals('TCustomTreeView') then
//        Result := '*TControl'
      else if AN.Equals('TCustomImageList')  then
        Result := '*TImageList'
      else if AN.Equals('TCustomForm') then
        Result := '*TForm'
      else if AN.Equals('TBasicAction') then
        Result := '*TAction'
      else if AN.Equals('TCustomGrid') then
        Result := '*TStringGrid'

      else if AN.Equals('TCustomCategoryPanelGroup') then
        Result := '*TCategoryPanelGroup'
      else if InStrArray(AN, ['TObject', 'TPersistent']) then
      begin
        Result := 'IObject';
        if AIsRet then
          Result := '*TObject';
      end
      else if AN.Equals('TStream') then
      begin
        Result := 'IStream';
        if AIsRet then
          Result := '*TStream';
      end
      else if AN.Equals('TGraphic') then
      begin
        Result := 'IGraphic';
        if AIsRet then
          Result := '*TGraphic';
      end
      else if AN.Equals('TIconOptions') and not AIsRet then
        Result := 'IObject'
      else if AN.Equals('TStrings') and not AIsRet then
        Result := 'IStrings'
      else if AN.Equals('TCustomBitmap') and not AIsRet then
        Result := 'IBitmap'
      else Result := '*' + AN;
    end;

    function DelphiParamTypeToGoType(AType: TRttiType; AIsRet: Boolean = False; AIsInst: Boolean = False): string;
    var
      LArr: TArray<string>;
      LBaseType: string;
      LR: TRttiInstanceType;
    begin
      if AIsRet then
        Result := ''
      else
        Result := 'uintptr';
      if AType = nil then Exit;
      case AType.TypeKind of
        tkString,tkLString,tkWString,tkUString:
          Result := 'string';
        tkPointer:
          begin
            if InStrArray(AType.ToString, ['PChar' ,'PWideChar']) then
               Result := 'string'
            else if InStrArray(AType.ToString, ['Pointer']) and (InStrArray(LMName, ['GetData' ,'SetData', 'GetTag', 'SetTag'])) then
              Result := 'unsafe.Pointer'
            else Result := 'uintptr';
          end;
        tkDynArray:
          Result := 'uintptr';
        tkClass,tkInterface,tkClassRef:
        begin
          if InStrArray(AType.Name, ['IDispatch', 'IWebBrowser2']) then
            Exit('uintptr');

          if AType.Name.Equals('TClass') then
            Exit('TClass');

          if AIsInst  then
          begin
            if AType.IsInstance then
            begin
              LBaseType := AType.AsInstance.ToString;
              LR := AType.AsInstance;
              while LR <> nil do
              begin
                LBaseType := LR.ToString;
                if InStrArray(LBaseType, ['TComponent', 'TControl', 'TWinControl'])   then
                  Break;
                LR := LR.BaseType;
              end;
            end;

            if InStrArray(LBaseType, ['TComponent', 'TControl', 'TWinControl']) then
            begin
              if AIsRet then
              begin
                Result :=  ClassParamCov(AType.Name, AIsRet) //'uintptr'
              end
              else
              begin
                if LBaseType.Equals('TWinControl') then
                  Result := 'IWinControl'
                else
                if LBaseType.Equals('TControl') then
                  Result := 'IControl'
                else
                  Result := 'IComponent';
              end;
            end
            else Result := ClassParamCov(AType.Name, AIsRet)// Result := '*' + AType.Name;
          end
          else Result := 'uintptr';
        end;
        tkChar,
        tkWChar:
          Result := 'uint16';
      else
        if InStrArray(AType.Name, ['Integer', 'Longint', 'TImageIndex', 'TProgressRange',
          'TBorderWidth', 'TWidth', 'TMarginSize', 'TCopyMode', 'TOleEnum']) then
          Result := 'int32'
        else if InStrArray(AType.Name, ['Cardinal', 'Longword']) then
          Result := 'uint32'
        else if InStrArray(AType.Name, ['Boolean', 'ByteBool', 'WordBool', 'LongBool']) then
          Result := 'bool' // uint8 ?
        else if AType.Name.Equals('Single') then
          Result := 'float32'
        else if InStrArray(AType.Name, ['TDate', 'TTime', 'TDateTime']) then
          Result := 'time.Time'
        else if AType.Name.Equals('Double') then
          Result := 'float64'
        else if AType.Name.Equals('Word'){ or AType.Name.Equals('TTabOrder') }then
          Result := 'uint16'
        else if AType.Name.Equals('NativeUInt')  then
          Result := 'uintptr'
        else if AType.Name.Equals('NativeInt') then
          Result := 'int'
        else if AType.Name.Equals('UInt64') then
          Result := 'uint64'
        else if AType.Name.Equals('Int64') then
          Result := 'int64'
        else if AType.Name.Equals('ShortInt') then
          Result := 'int8'
        else if AType.Name.Equals('SmallInt') {or AType.Name.Equals('TTabOrder') }then
          Result := 'int16'
        else if InStrArray(AType.Name, ['Byte', 'AnsiChar', 'TOverlay']) then
          Result := 'uint8'
        else if AType.Name.Equals('NaturalNumber') then
          Result := 'int32'
        else  if AType.Name = 'TItemStates' then
          Result := 'TListItemStates'
        else if AType.Name = 'TItemState' then
          Result := 'TListItemState'
        else if AType.Name.Equals('TLMessage') then
          Result := 'TMessage'
        else
        begin
          if AType.Name.Contains('.') then
          begin
            LArr := AType.Name.Split(['.'], ExcludeEmpty);
            Result := LArr[High(LArr)];
          end
          else
            Result := AType.Name;
        end;
      end;
    end;

    // 事件
    function GetEventName(AOrgInst, AMName: string): string;
    begin
      Result := '';
      if AOrgInst.Equals('TForm') and InStrArray(AMName, ['OnClose', 'OnCloseQuery']) then
        Result := 'Form'
      else if AOrgInst.Equals('TUpDown') and AMName.Equals('OnClick') then
        Result := 'UpDown'
      else if AOrgInst.Equals('TTreeView') and (AMName.Equals('OnChange') or
        AMName.Equals('OnGetImageIndex') or AMName.Equals('OnGetSelectedIndex') or
        AMName.Equals('OnCompare') or AMName.Equals('OnAdvancedCustomDraw') or
        AMName.Equals('OnAdvancedCustomDrawItem')  or AMName.Equals('OnChanging') or  AMName.Equals('OnEdited') or
        AMName.Equals('OnEditing') or AMName.Equals('OnHint') or AMName.Equals('OnCancelEdit') or
        AMName.Equals('OnCollapsed') or AMName.Equals('OnCollapsing') or AMName.Equals('OnDeletion') or AMName.Equals('OnExpanded') or
        AMName.Equals('OnExpanding') or AMName.Equals('OnAddition') or AMName.Equals('OnCustomDraw') or AMName.Equals('OnCustomDrawItem')) then
        Result := 'TreeView'
      else if AOrgInst.Equals('TListView') and (AMName.Equals('OnChange') or  AMName.Equals('OnDataHint')) then
        Result := 'ListView'
      else if (AOrgInst.Equals('TMainMenu') or AOrgInst.Equals('TPopupMenu')) and AMName.Equals('OnChange') then
        Result := 'Menu'
       else if (AOrgInst.Equals('TListBox') or AOrgInst.Equals('TComboBox')or AOrgInst.Equals('TCheckListBox'))
         and (AMName.Equals('OnDrawItem') or AMName.Equals('OnData') or AMName.Equals('OnDataFind')
          or AMName.Equals('OnDataObject') or AMName.Equals('OnMeasureItem')) then
         Result := 'ListBox'
      else if AOrgInst.Equals('TMenuItem') and (AMName.Equals('OnDrawItem') or AMName.Equals('OnMeasureItem')) then
         Result := 'MenuItem'
      else if AOrgInst.Equals('TListView') and (AMName.Equals('OnDrawItem') or
       AMName.Equals('OnGetImageIndex')  or AMName.Equals('OnColumnClick') or
       AMName.Equals('OnColumnRightClick') or AMName.Equals('OnSelectItem') or
       AMName.Equals('OnItemChecked') or AMName.Equals('OnCompare') or
       AMName.Equals('OnChange') or AMName.Equals('OnAdvancedCustomDraw') or
        AMName.Equals('OnAdvancedCustomDrawItem') or AMName.Equals('OnAdvancedCustomDrawSubItem')  or
        AMName.Equals('OnChanging') or AMName.Equals('OnData') or AMName.Equals('OnDataFind') or AMName.Equals('OnEdited') or
        AMName.Equals('OnEditing') or AMName.Equals('OnInsert') or AMName.Equals('OnDeletion')  or AMName.Equals('OnCustomDraw') or
        AMName.Equals('OnCustomDrawItem') or AMName.Equals('OnCustomDrawSubItem') ) then
         Result := 'ListView'
      else if AOrgInst.Equals('TPageControl') and AMName.Equals('OnGetImageIndex') then
         Result := 'PageControl'
      else if AOrgInst.Equals('TToolBar') and (AMName.Equals('OnAdvancedCustomDraw') or
        AMName.Equals('OnAdvancedCustomDrawButton')) then
         Result := 'ToolBar'
      else if AOrgInst.Equals('TUpDown') and (AMName.Equals('OnChanging')) then
         Result := 'UpDown'
      else if AOrgInst.Equals('TPageControl') and (AMName.Equals('OnChanging')) then
        Result := 'PageControl'
      else if AOrgInst.Equals('TTaskDialog') {and (AMName.Equals('OnTimer'))} then
        Result := 'TaskDialog'
      //else if AOrgInst.Equals('TActionList') and AMName.Equals('OnExecute') then
      //  Result := 'ActionList';
    end;

    // 修复事件名
    function FixEventName(AName: string): string;
    begin
      Result := AName;
      if InStrArray(AName, ['OnRowMoved', 'OnColumnMoved']) then
        Result := 'OnColRowMoved';
    end;

    // 有些共用的事件名，分为down和up则需要将其分开
    function FixEvenMethodName(ATypeName, AEventName: string): string;
    begin
      Result := ATypeName + '_' + AEventName;
    end;

    // 有些事件跟lazarus中的命名不同
    function FixEventTypeName(ATypeName: string): string;
    begin
      Result := ATypeName;
      if Result.Equals('TLVOwnerDataEvent') then
        Result := 'TLVDataEvent'
      else if Result.Equals('TLVOwnerDataFindEvent') then
        Result := 'TLVDataFindEvent'
      else if Result.Equals('TLVOwnerDataHintEvent') then
        Result := 'TLVDataHintEvent'
    end;



    // 过滤事件，方法等
    function FilterX(O, M: string): Boolean;
    begin
       Result := False;
       if M.Equals('BevelInner') or M.Equals('BevelOuter') then
         if O.Equals('TPanel')then
           Exit(False)
         else Exit(True);

       if m.Equals('ScaleForPPI') and (not o.Equals('TForm')) then
         Exit(True);


//       if M.Equals('DeleteSelected') then
//       begin
//         if O.Equals('TListView') or O.Equals('TTreeView') then
//           Exit(True)
//         else Exit(False)
//       end;

       if O.Equals('TActionList') and (M.Equals('OnExecute') or M.Equals('OnUpdate')) then
          Result := True
       else if O.Equals('TGIFImage') and M.Equals('Images') then
         Result := True
//       else if O.Equals('TList') and M.Equals('Assign') then
//         Result := True
       else if (O.Equals('TMemoryStream') or O.Equals('TStream'))
         and (M.Equals('Write') or M.Equals('Read') or M.Equals('SetSize')) then
         Result := True
       else if O.Equals('TPngImage') and M.Equals('Header') then
         Result := True
       else if O.Equals('TListView')and ((* M.Equals('OnDrawItem')or*)  M.Equals('Scroll'){ or m.Equals('CustomSort') })then
         Result := True
       else if (o.Equals('TListItems') or O.Equals('TTreeNodes')) and ( M.Equals('Handle') or M.Equals('AddItem')) then
         Result := true
       else if (o.Equals('TTreeNodes') or o.Equals('TTreeNode') {or o.Equals('TTreeView')}) and (m.Equals('AlphaSort')) then
         Result := true
       else if (o.Equals('TListColumns') or o.Equals('TComboExItems') or o.Equals('TGridColumns')) and (M.Equals('Capacity')) then
          Result := true

       //else if O.Equals('TTreeView') and (M.Equals('OnHint')) then
       //  Result := True
//       else if O.Equals('TApplication') and M.Equals('Handle') then
//         Result := True
       else if O.Equals('TListItem') and (M.Equals('Update') or M.Equals('Handle') or M.Equals('Indent')
         or m.Equals('Deleting') or m.Equals('GroupID') or m.Equals('OverlayIndex'))  then
         Result:=true
       else if O.Equals('TTreeNode') and (M.Equals('Enabled')) then
       Result := true
      else if O.Equals('TPageControl') and (M.Equals('RowCount') or m.Equals('HotTrack') or m.Equals('Style')
        or m.Equals('Canvas') or m.Equals('GetHitTestInfoAt')) then
        result := true
       else if O.Equals('TGraphic') and (m.Equals('SetSize')) then
         result := true

       else if O.Equals('TPngImage') and (m.Equals('CompressionLevel')) then
         Result := true

       else if O.Equals('TGIFImage') and (m.Equals('Add') or m.Equals('Bitmap') or m.Equals('OnPaint')) then
         result := true
       else if o.Equals('TAction') and (m.Equals('Images') or m.Equals('OnHint')) then
         Result := true

      else if O.Equals('TScreen') and M.Equals('Realign') then
        result := true
       else if O.Equals('TButton') and (M.Equals('Images') or M.Equals('ImageIndex')
         or M.Equals('DisabledImageIndex') or M.Equals('ImageAlignment') or
          M.Equals('SelectedImageIndex') or M.Equals('Style') or M.Equals('WordWrap') ) then
          Result := True
//       else if (O.Equals('TEdit') or O.Equals('TMemo')) and (M.Equals('BevelEdges') or M.Equals('BevelInner')
//         or ) then
//          Result := True
       else if O.Equals('TPopupMenu') and (M.Equals('OnChange')) then
         Result := True
       else if O.Equals('TCheckBox') and (M.Equals('WordWrap')) then
         Result := True
       else if O.Equals('TRadioButton') and (M.Equals('WordWrap') or M.Equals('OnDblClick')) then
         Result := True
//       else if O.Equals('TGroupBox') and M.Equals('ParentBackground') then
//        Result := True
       else if O.Equals('TListBox') and (   M.Equals('AutoComplete') or
         M.Equals('AutoCompleteDelay') or M.Equals('TabWidth')) then
         Result := True
       else if O.Equals('TMenuItem') and M.Equals('OnDrawItem') then
         Result := True
       else if InStrArray(O, ['TCheckComboBox']) and M.Equals('DeleteSelected') then
         Result := True
       else if O.Equals('TPanel') and (M.Equals('Locked') or M.Equals('ShowCaption') or m.Equals('OnConstrainedResize')) then
         Result := True
       else if O.Equals('TRadioGroup') and ( M.Equals('WordWrap') or
         M.Equals('Buttons'){ or M.Equals('ParentBackground')}
       ) then
        Result := True
       else if O.Equals('TColorListBox') and (M.Equals('AutoComplete')) then
         Result := True
       else if O.Equals('TTrayIcon') and (M.Equals('Refresh') or M.Equals('SetDefaultIcon') or M.Equals('IconIndex')) then
          Result := True
       else if (O.Equals('TOpenDialog') or O.Equals('TSaveDialog') or O.Equals('TPrintDialog') or O.Equals('TSelectDirectoryDialog')) and
         (M.Equals('OptionsEx'){ or M.Equals('Execute')})   then
         Result := True
       else if O.Equals('TImageList') and ( M.Equals('SetSize') or
        M.Equals('Handle') or M.Equals('HandleAllocated'))
        then
         Result := True
       else if O.Equals('TProgressBar') and M.Equals('State') then
         Result := True
       else if O.Equals('TToolBar') and (M.Equals('DrawingStyle') or M.Equals('Menu')
          or M.Equals('OnAdvancedCustomDraw') or M.Equals('OnAdvancedCustomDrawButton') or m.Equals('OnGetSiteInfo') or M.Equals('HotTrackColor')) then
         Result := True
       else if (O.Equals('TStrings') or O.Equals('TStringList')) and (M.Equals('Options')) then
          Result:= true
       else if O.Equals('TColorDialog') and M.Equals('Options') then
         result := True
       else if O.Equals('TOpenPictureDialog') and m.Equals('OptionsEx') then
         result := true
         else if o.Equals('TSavePictureDialog') and m.Equals('OptionsEx') then
          result := true
         else if O.Equals('TMonthCalendar') and (m.Equals('MultiSelect')
           or {m.Equals('Date') or }m.Equals('FirstDayOfWeek') or m.Equals('MaxDate')
           or m.Equals('MaxSelectRange') or m.Equals('MinDate') or m.Equals('ParentFont')
           or m.Equals('ParentShowHint') or m.Equals('ShowToday') or m.Equals('ShowTodayCircle')
           or m.Equals('WeekNumbers')) then
         Result := true

       else if O.Equals('TScrollBar') and (M.Equals('OnMouseEnter') or
          m.Equals('OnMouseLeave') ) then
         Result := True
       else if O.Equals('TCheckListBox') and (M.Equals('AutoComplete') or
          M.Equals('Flat') or m.Equals('HeaderColor') or m.Equals('HeaderBackgroundColor') or
          m.Equals('OnDrawItem') or m.Equals('TabWidth')) then
         Result := True
       else if O.Equals('TLinkLabel') and (m.Equals('CanFocus') or m.Equals('FlipChildren') or
         m.Equals('Focused') or M.Equals('Realign') or m.Equals('ScaleBy') or
         m.Equals('SetFocus') or m.Equals('TabOrder') or m.Equals('TabStop') or
         m.Equals('UseVisualStyle') or m.Equals('DoubleBuffered') or m.Equals('ControlCount') or
         m.Equals('Brush') or m.Equals('ControlCount') or m.Equals('Handle') or
         m.Equals('ParentWindow') or m.Equals('Controls') or m.Equals('Cursor') or m.Equals('ParentDoubleBuffered') or m.Equals('Showing') or
         m.Equals('PaintTo')) then
         Result := True
//       else if o.Equals('TPageSetupDialog') and (m.Equals('Options') or m.Equals('PageWidth') or m.Equals('PageHeight')) then
//          Result := True
       else if o.Equals('TPrinter') and (m.Equals('Handle')) then
         Result := True
       else if o.Equals('TStatusPanels') and (M.Equals('AddItem')) then
          Result := True
       else if (o.Equals('TLinkLabel') or o.Equals('TBrush') or o.Equals('TPen'))

          and (m.Equals('HandleAllocated')) then
          Result := True
       else if (o.Equals('TComboBox') or o.Equals('TColorBox')) and (M.Equals('TextHint')) then
          Result := True
       else if (o.Equals('TButton') or o.Equals('TEdit') or o.Equals('TMemo') or o.Equals('TCheckBox') or
                O.Equals('TRadioButton') or o.Equals('TLabel') or o.Equals('TListBox') or
                O.Equals('TComboBox') or o.Equals('TImage') or o.Equals('TLinkLabel') or
                o.Equals('TRadioGroup') or o.Equals('TStaticText') or o.Equals('TColorBox') or
                o.Equals('TColorListBox') or o.Equals('TTrackBar') or o.Equals('TProgressBar') or
                o.Equals('TDateTimePicker') or o.Equals('TTreeView')or o.Equals('TToolBar') or
                o.Equals('TPaintBox') or o.Equals('TScrollBar') or o.Equals('TShape') or
                o.Equals('TScrollBox') or o.Equals('TCheckListBox') or o.Equals('TRichEdit') ) and

               (m.Equals('OnEndDock') or m.Equals('OnStartDock')) then
         Result := true
       else if (o.Equals('TImage') or o.Equals('TRadioGroup')) and (m.Equals('OnContextPopup')) then
          Result := true
       else if o.Equals('TLinkLabel') and (m.Equals('DockSite') or m.Equals('UseDockManager')  or
               (m.Equals('ContainsControl') or m.Equals('ControlAtPos') or m.Equals('DisableAlign') or
                m.Equals('FindChildControl') or m.Equals('InsertControl') or m.Equals('RemoveControl') or
                m.Equals('ScrollBy'))  or m.Equals('DockClientCount') or m.Equals('VisibleDockClientCount') or
                m.Equals('DockClients')  or m.Equals('EnableAlign') ) then
         Result := True
       else if (o.Equals('TRadioGroup') or o.Equals('TImage') or o.Equals('TTrackBar') ) and (m.Equals('DragKind')) then
         Result := true
       else if (o.Equals('TDateTimePicker')) and (m.Equals('DragCursor') or m.Equals('DragKind') or
         m.Equals('DragMode') or m.Equals('OnDragDrop') or m.Equals('OnDragOver') or m.Equals('OnEndDock') or
         m.Equals('OnStartDock')) then
          Result := true
       else if (o.Equals('TTabSheet')) and (m.Equals('DragMode')) then
          Result := true
       else if (o.Equals('TPaintBox')) and (m.Equals('DragKind') or m.Equals('OnContextPopup')) then
           Result := true
       else if o.Equals('TCheckListBox') and (m.Equals('DragKind')) then
           Result := true
       else if (o.Equals('TShape') or o.Equals('TScrollBox'))  and m.Equals('OnContextPopup') then
           Result := true
       else if (o.Equals('TDragObject') or o.Equals('TDragDockObject')) and (  m.Equals('Cancelling') or m.Equals('DragHandle'){ or
        m.Equals('DragTarget') }) then
           Result := true
       else if o.Equals('TDragDockObject') and m.Equals('Brush') then
         Result := true

       else if (o.Equals('TDateTimePicker') ) and (m.Equals('OnEndDrag')) then
         Result := true
       else if (o.Equals('TBitBtn')) and (m.Equals('DragCursor') or m.Equals('DragKind') or m.Equals('DragMode') or
         m.Equals('Style') or m.Equals('WordWrap') or m.Equals('OnEndDock') or m.Equals('OnStartDock')) then
         Result := true

       else if (o.Equals('TStringGrid') or o.Equals('TDrawGrid') or o.Equals('TValueListEditor') ) and (m.Equals('DrawingStyle')) then
          Result := true

       else if (o.Equals('THeaderControl') or o.Equals('THeaderSection') or O.Equals('THeaderSections'))
        and (m.Equals('FullDrag') or m.Equals('HotTrack') or m.Equals('Style')
         or m.Equals('OnStartDock') or m.Equals('AllowClick') or m.Equals('AutoSize') or m.Equals('BiDiMode') or m.Equals('CheckBox')
         or m.Equals('Checked') or m.Equals('FixedWidth') or m.Equals('Capacity') ) then
        Result := true    
       else if (o.Equals('TLabeledEdit') or o.Equals('TBoundLabel')) and (m.Equals('DragKind') or m.Equals('OnContextPopup') or m.Equals('OnEndDock')
          or m.Equals('OnStartDock')) then
            Result := True 
       else if (o.Equals('TBoundLabel')) and (m.Equals('Transparent') or m.Equals('Locked')) then
            Result := True
       else if (o.Equals('TFlowPanel')) and (m.Equals('Locked') or m.Equals('ShowCaption')) then
         Result := True
       else if o.Equals('TCoolBands') and (m.Equals('CoolBar') or m.Equals('Capacity')) then
          Result := True
       else if o.Equals('TMenuItem') and (m.Equals('Break')) then
          Result := True
       else if o.Equals('TScreen') and (m.Equals('DisableAlign') or m.Equals('EnableAlign')) then
         Result := True
       else if o.Equals('TCoolBar') and (m.Equals('InsertControl')) then
         Result := True
       else if (o.Equals('TListBox') or o.Equals('TCheckListBox')) and (m.Equals('OnData') or m.Equals('OnDataFind') or m.Equals('OnDataObject')) then
         Result:=True
       else if (o.Equals('TListView')) and (m.Equals('OnChanging')) then
         Result := true
       else if (o.Equals('TTreeView')) and (m.Equals('OnCancelEdit') or m.Equals('OnHint')) then
         Result := True
       else if (o.Equals('TCollection') or o.Equals('TFlowPanelControlList') or o.Equals('TFlowPanelControl')) and m.Equals('Capacity') then
            Result := True
       else if o.Equals('TPageControl') and m.Equals('OwnerDraw')  then
          Result := True
       else if o.Equals('TToolBar') and m.Equals('OnCustomDraw') then
         Result := True
       else if (o.Equals('TSpinEdit') or o.Equals('TFloatSpinEdit')) and (m.Equals('DragCursor') or m.Equals('DragMode') or
         m.Equals('EditorEnabled') or m.Equals('OnDblClick') or m.Equals('OnDragDrop') or m.Equals('OnDragOver') or
         m.Equals('OnEndDrag') or m.Equals('Button')) then
         Result := True
       else if O.Equals('TTaskDialog') and (m.Equals('Handle') or m.Equals('Expanded') or m.Equals('OnTimer') or m.Equals('OnExpanded')) then
         Result := True
       else if O.Equals('TTaskDialogButtons') and (m.Equals('Buttons') or m.Equals('SetInitialState')
         or m.Equals('Capacity')) then
         Result := True
       else if (o.Equals('TTaskDialogButtonItem') or o.Equals('TTaskDialogBaseButtonItem') or o.Equals('TTaskDialogRadioButtonItem'))  and (m.Equals('SetInitialState') or m.Equals('Click') or m.Equals('Enabled')) then
          Result := True
       else if o.Equals('TComboExItems') and (m.Equals('OnCompare') or m.Equals('SortType') or m.Equals('Items')) then
         Result := True
       else if o.Equals('TControlScrollBar')  and
       (m.Equals('ButtonSize') or m.Equals('Color') or m.Equals('ParentColor') or
        m.Equals('Size') or m.Equals('Style') or m.Equals('ThumbSize') or m.Equals('ChangeBiDiPosition') or m.Equals('CustomSort'))then
         Result := True
//       else if o.Equals('TFrame') and (m.Equals('ParentBackground')) then
//         Result := True
       else if o.Equals('TList') and (m.Equals('Assign'))then
          Result := True
       else if (o.Equals('TStringList') or o.Equals('TComboExItems')) and (m.Equals('CustomSort'))then
          Result := True
       else if (o.Equals('TForm')) and (m.Equals('DropTarget')) then
         Result := True
       else if o.Equals('TPngImage') and (m.Equals('Pixels')) then
         Result := True
       else if o.Equals('TClipboard') and (m.Equals('HasFormat') or m.Equals('GetAsHtml') or m.Equals('AsText') or m.Equals('GetTextBuf')) then
         Result := True

//       else if (o.Equals('TStrings') or o.Equals('TStringList')) and (m.Equals('Equals')) then
//         Result := True


//       else if (o.Equals('TForm') or o.Equals('TComboExItems')) and (m.Equals('CustomSort'))then
//          Result := True


//       else if o.Equals('TCoolBand') and (m.Equals('')) then
//          Result := True
    end;

    // 过滤属性读写
    function FilterXPropRW(AOrgInst, AMName: string; AWrite: Boolean): Boolean;
    begin
      Result := False;
      if (AOrgInst.Equals('TListBox') or
          AOrgInst.Equals('TColorListBox') or
          AOrgInst.Equals('TCheckListBox')) and AMName.Equals('Count') and AWrite then
        Result := True
      else if (AOrgInst.Equals('TScreen')) and AMName.Equals('FocusedForm') and AWrite then
        Result := True
      else if (AOrgInst.Equals('TGIFImage')) and AMName.Equals('Transparent') and AWrite then
        Result := True
      else if (AOrgInst.Equals('TClipboard')) and AMName.Equals('SetAsHandle') and AWrite then
        Result := True
      else if (AOrgInst.Equals('TPageSetupDialog')) AND (AMName.Equals('Units')) and AWrite then
        Result := True



    end;

    function FilterXParamLen(AOrgInst, AMName: string; AParam: TArray<TRttiParameter>): Boolean;
    var
      LPLen: Integer;
    begin
      Result := False;
      LPLen := 0;
      if AParam <> nil then
        LPLen := Length(AParam);
      if (AOrgInst.Equals('TOpenDialog') or
          AOrgInst.Equals('TSaveDialog') or
          AOrgInst.Equals('TColorDialog') or
          AOrgInst.Equals('TFontDialog') or
          AOrgInst.Equals('TPrintDialog') or
          AOrgInst.Equals('TOpenPictureDialog') or
          AOrgInst.Equals('TSavePictureDialog') or
          AOrgInst.Equals('TSaveTextFileDialog') or
          AOrgInst.Equals('TOpenTextFileDialog') or
          AOrgInst.Equals('TFindDialog') or
          AOrgInst.Equals('TReplaceDialog') or
          AOrgInst.Equals('TPrinterSetupDialog') or
          AOrgInst.Equals('TSelectDirectoryDialog') or
          AOrgInst.Equals('TPageSetupDialog')  ) and (AMName.Equals('Execute')) and (LPLen = 1) then
         Result := True
    end;




    function GetNotComponetFirstP(AInst: string; ARetType: Boolean; ACov: Boolean = True): string;
    begin
      Result := '';
      if AInst.Equals('TIniFile') then
      begin
        if ARetType then
          Result := 'filename string'
        else
        begin
          if ACov then
            Result := 'PascalStr(filename)'
          else Result := 'PascalStr(filename)';
        end;
      end else if AInst.Equals('TRegistry') then
      begin
        if ARetType then
          Result := 'aAccess uint32'
        else
        begin
          if ACov then
            Result := 'uintptr(aAccess)'
          else Result := 'uintptr(aAccess)';
        end;
        //   
      end else if AInst.Equals('TTreeNode') then
      begin
        if ARetType then
          Result := 'AOwner *TTreeNodes'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else if Ainst.Equals('TListItem') then
      begin
        if ARetType then
          Result := 'AOwner *TListItems'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else if AInst.Equals('TStatusPanels') then
      begin
        if ARetType then
          Result := 'AOwner *TStatusBar'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else
      if AInst.Equals('TCollection') then
      begin
        if ARetType then
          Result := 'AOwner *TCollectionItem'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else
      if AInst.Equals('TCoolBands') then
      begin
        if ARetType then
          Result := 'AOwner *TCoolBar'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else
      if AInst.Equals('TCoolBand') or AInst.Equals('THeaderSection') or AInst.Equals('TCollectionItem')
        or AInst.Equals('TStatusPanel') or AInst.Equals('TListColumn') or AInst.Equals('TTaskDialogBaseButtonItem') or
        AInst.Equals('TTaskDialogButtonItem') or AInst.Equals('TTaskDialogRadioButtonItem') then
      begin
        if ARetType then
          Result := 'AOwner *TCollection'
        else
        begin
          if ACov then
            Result := 'CheckPtr(AOwner)'
          else Result := 'CheckPtr(AOwner)';
        end;
      end else
       if AInst.Equals('TDragDockObject') or AInst.Equals('TDragObject') then
        begin
          if ARetType then
            Result := 'AOwner IControl'
          else
          begin
            if ACov then
              Result := 'CheckPtr(AOwner)'
            else Result := 'CheckPtr(AOwner)';
          end;
        end else
       if AInst.Equals('THeaderSections')  then
        begin
          if ARetType then
            Result := 'AOwner *THeaderControl'
          else
          begin
            if ACov then
              Result := 'CheckPtr(AOwner)'
            else Result := 'CheckPtr(AOwner)';
          end;
        end else
       if AInst.Equals('TListColumns') or AInst.Equals('TListItems')   then
        begin
          if ARetType then
            Result := 'AOwner *TListView'
          else
          begin
            if ACov then
              Result := 'CheckPtr(AOwner)'
            else Result := 'CheckPtr(AOwner)';
          end;
        end else
      if AInst.Equals('TTreeNodes')   then
        begin
          if ARetType then
            Result := 'AOwner *TTreeView'
          else
          begin
            if ACov then
              Result := 'CheckPtr(AOwner)'
            else Result := 'CheckPtr(AOwner)';
          end;
        end else



//       if AInst.Equals('TTaskDialogButtons') then
//        begin
//          if ARetType then
//            Result := 'AOwner IObject, AItemClass *TCollectionItem'
//          else
//          begin
//            if ACov then
//              Result := 'CheckPtr(AOwner), CheckPtr(AItemClass)'
//            else Result := 'CheckPtr(AOwner), CheckPtr(AItemClass)';
//          end;
//        end else



    end;

    function ComponentHaveConstructorParam: Boolean;
    begin

    end;

    // 添加注释
    function GetComment(AInstName, AName: string; AIsProp, AIsWrite: Boolean): string;
    var
      LItem: TCommentItem;
      LFind: Boolean;
    begin
      Result := '';
      LFind := GCommentInfo.TryGetValue(AInstName+AName, LItem);
      if not LFind then
        LFind := GCommentInfo.TryGetValue(AName, LItem);
      if LFind then
      begin
        Result := Result + '// ';
        if AIsProp and AIsWrite then
          Result := Result + 'Set';
        Result := Result + AName + sLineBreak + '//' + sLineBreak;

        if AIsProp then
        begin
          if not AIsWrite then
          begin
            LItem.CN := '获取' + LItem.CN;
            if LITem.EN <> '' then
              LItem.EN := 'Get ' + LItem.EN;
          end else
          begin
            LItem.CN := '设置' + LItem.CN;
            if LITem.EN <> '' then
              LItem.EN := 'Set ' + LItem.EN;
          end;
          //Exit;
        end;
        Result := Result + '// ' + LItem.CN + '。'#13#10;
        if LItem.EN <> '' then
        begin
          Result := Result + '//' + #13#10;
          Result := Result + '// ' + LItem.EN + '.'#13#10;
        end;
      end;
    end;

    // 修复一些与delphi不同属性的
    function FixPropName(const ASrc: string): string;
    begin
      Result := ASrc;
//      if Result.Equals('Margins') then
//        Result := 'BorderSpacing';
    end;


const
  // go中异常处理代码
//  ExceptionCode =
//             '    defer func(){'#13#10 +
//             '        if err := recover(); err != nil {'#13#10 +
//             '            DShowMessage(err.(error).Error())'#13#10+
//             '        }'#13#10+
//             '    }()'#13#10;
    ExceptionCode = '';//'    defer exceptionProc()'#13#10;

var
  LC: TRttiContext;
  LInst: TRttiInstanceType;
  LM: TRttiMethod;
  LPR: TRttiProperty;
  LIncFileName, LOrgInstName, LWithoutTInstName, LFirstCharLowerCaseName: string;
  LTempDict: TDictionary<string, string>;
  LParams: TArray<TRttiParameter>;
  LP: TRttiParameter;
  I: Integer;
  LCode: string;
  LFileGodll, LFileGoVcl: TStringList;
  LFChar: Char;
  LType, LTempStr, LTemp1, LTemp2, LPsNonPtrFlags: string;
  LNeedImport: Boolean;
  LIdxP: TRttiIndexedProperty;

  LNeedClosingBracket: Boolean;


  LMs: TArray<TRttiMethod>;
  LProps: TArray<TRttiProperty>;
  LIdxProps: TArray<TRttiIndexedProperty>;

   procedure AddGoImport(AClassName, AMName, InstName: string);
   begin
     AGoHeaderFile.Add(Format('//    %s_%s = libvcl.NewProc("%s_%s")', [AClassName, AMName, InstName, AMName]));
     //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_Free = libvcl.NewProc("' + LWithoutTInstName + '_Free")');
     //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');

   end;

   function NeedAddTypePkg: Boolean;
   begin
     Result := False;
     if GAddTypePkgs.ContainsKey(LOrgInstName) then
        Result := True;
   end;


   function NeedAddUnsafePkg: Boolean;
   begin
     Result := False;
     if GAddUnsafePkgs.ContainsKey(LOrgInstName) then
        Result := True;
   end;

   function AddToGlobalDllImport(const AName: string): string;
   var
     LIndex: Integer;
   begin
//     Result := '"' + AName + '"';
     // 行不通啊，还是只能原来的方式
     LIndex := GDllImportTable.Add(Format('    /*%d*/ {"%s", 0},', [GDllImportTable.Count, AName]));
     Result := LIndex.ToString;// (GDllImportTable.Count - 1).ToString;
   end;

var
  LHaveComponetContructorParam: Boolean;
  LBaseClassName, LNameTemp: string; // 伪的
begin
  // ??
//  AIsComponent := AClass.InheritsFrom(TComponent);
  LNeedImport := False;

  LIncFile := TStringList.Create;
  LExports := TStringList.Create;
  LFileGodll := TStringList.Create;
  LFileGoVcl := TStringList.Create;
  try
    LC := TRttiContext.Create;
    try
      LTempDict := TDictionary<string, string>.Create;
      try
        LInst := LC.GetType(AClass).AsInstance;
        LOrgInstName := LInst.Name;

        LWithoutTInstName := LOrgInstName;
        if LWithoutTInstName[1] ='T' then
          Delete(LWithoutTInstName, 1, 1);
        LFirstCharLowerCaseName := LWithoutTInstName;
        LFirstCharLowerCaseName[1] := LowerCase(LFirstCharLowerCaseName[1])[1];
        LFChar := LFirstCharLowerCaseName[1];


        Writeln(LFirstCharLowerCaseName);

		
        AGoHeaderFile.Add('    ' + Format('// %s', [LOrgInstName]));

//        if LOrgInstName[1] = 'T' then
//          LIncFileName := Format('%s.inc', [Copy(LOrgInstName, 2, LOrgInstName.Length - 1)])
//        else
        LIncFileName := Format('MyLCL_%s.inc', [LWithoutTInstName]);

//        AddHeaderInfo(LFileGodll);

//        LFileGodll.Add('');
//        LFileGodll.Add('package api');
//        LFileGodll.Add('');
        LFileGodll.Add('');
        LFileGodll.Add('//--------------------------- ' + LOrgInstName + ' ---------------------------');
        LFileGodll.Add('');

        LHaveComponetContructorParam := IsComponent;
//        if AClass.InheritsFrom(TRegistry) or AClass.InheritsFrom(TIniFile) then
//          LHaveComponetContructorParam := False;
//        LHaveComponetContructorParam := IsComponent or LHaveComponetContructorParam;

        if not ANoCreateAndFree then
        begin
          LFileGodll.Add('func ' + GetNewMethod(LOrgInstName, 'Create', False)  + '(' + IfThen(IsComponent or AIsComponent, 'obj uintptr', GetNotComponetFirstP(LOrgInstName, True)) + ') uintptr {');
          LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_Create');
//          LFileGodll.Add('    ret, _, _ := syscallN(' + LNameTemp + ').Call(' + IfThen(IsComponent or AIsComponent, 'obj', GetNotComponetFirstP(LOrgInstName, False)) + ')');
          LFileGodll.Add('    return syscallN(' + LNameTemp + ', ' + IfThen(IsComponent or AIsComponent, 'obj', GetNotComponetFirstP(LOrgInstName, False)) + ')');
//          LFileGodll.Add('    return ret');
          LFileGodll.Add('}');
          LFileGodll.Add('');
          //AddToGlobalDllImport(LNameTemp);

          //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_Create = libvcl.NewProc("' + LWithoutTInstName + '_Create")');
          AddGoImport(LFirstCharLowerCaseName, 'Create', LWithoutTInstName);

          LFileGodll.Add('func ' + GetNewMethod(LOrgInstName, 'Free', False)  + '(obj uintptr) {');

          LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_Free');
//          LFileGodll.Add('    syscallN(' + LNameTemp + ').Call(obj)');
          LFileGodll.Add('    syscallN(' + LNameTemp + ', obj)');
          LFileGodll.Add('}');
          LFileGodll.Add('');
          //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_Free = libvcl.NewProc("' + LWithoutTInstName + '_Free")');
          AddGoImport(LFirstCharLowerCaseName, 'Free', LWithoutTInstName);
          //AddToGlobalDllImport(LNameTemp);
        end;
        //-----------------------------------------

        AddHeaderInfo(LFileGoVcl, True);

        LFileGoVcl.Add('');
        LFileGoVcl.Add('package vcl');
        LFileGoVcl.Add('');
        LFileGoVcl.Add('');

        LFileGoVcl.Add('import (');  // github.com/ying32/govcl   git.oschina.net/ying32/govcl

        if LOrgInstName.Equals('TDateTimePicker') or 
           LOrgInstName.Equals('TIniFile') or
           LOrgInstName.Equals('TMonthCalendar') or
           LOrgInstName.Equals('TRegistry') then
           LFileGoVcl.Add('    "time"');
           
        LFileGoVcl.Add('    . "github.com/ying32/govcl/vcl/api"');
        //if not NeedAddTypePkg then
          LFileGoVcl.Add('    . "github.com/ying32/govcl/vcl/types"');
       // if NeedAddUnsafePkg then
          LFileGoVcl.Add('    "unsafe"');

        LFileGoVcl.Add(')');
        LFileGoVcl.Add('');
        LFileGoVcl.Add('type ' + LOrgInstName + ' struct {');

        LBaseClassName := '';
        if IsWinControl then
          LBaseClassName := 'IWinControl'
          //LFileGoVcl.Add('    IWinControl')
        else
        if IsControl then
          LBaseClassName := 'IControl'
//          LFileGoVcl.Add('    IControl')
        else if IsComponent then
          LBaseClassName := 'IComponent'
//          LFileGoVcl.Add('    IComponent');
        else
        begin
          LBaseClassName := 'IObject';
          if LOrgInstName.Equals('TStrings') or LOrgInstName.Equals('TStringList') then
            LBaseClassName := 'IStrings'
          else if LOrgInstName.Equals('TMemoryStream') then
            LBaseClassName := 'IStream'
          else if LOrgInstName.Equals('TGraphic') then
            LBaseClassName := 'IGraphic'
          else if
            LOrgInstName.Equals('TJPEGImage') or LOrgInstName.Equals('TPngImage') or
            LOrgInstName.Equals('TGIFImage') or LOrgInstName.Equals('TBitmap') or LOrgInstName.Equals('TIcon') then
            LBaseClassName := 'IBitmap'

        end;
        //  LFileGoVcl.Add('    IObject');
        if LBaseClassName <> '' then
          LFileGoVcl.Add('    ' + LBaseClassName);

        // 不要这个了
        //LFileGoVcl.Add('    instance uintptr');
        // 尝试添加
        //LFileGoVcl.Add('    // 特殊情况下使用，主要应对Go的GC问题，与LCL没有太多关系。');
        LFileGoVcl.Add('    instance unsafe.Pointer');

        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        if not ANoCreateAndFree then
        begin
          LFileGoVcl.Add('// New' + LWithoutTInstName);
          LFileGoVcl.Add('//');
          LFileGoVcl.Add('// 创建一个新的对象。');
          LFileGoVcl.Add('// ');
          LFileGoVcl.Add('// Create a new object.');
          LFileGoVcl.Add('func New' + LWithoutTInstName + '(' + IfThen(IsComponent, 'owner IComponent', GetNotComponetFirstP(LOrgInstName, True, False)) + ') *' + LOrgInstName + ' {');
          LFileGoVcl.Add('    ' + LFChar + ' := new(' + LOrgInstName + ')');
          LFileGoVcl.Add('    ' + LFChar + '.instance = unsafe.Pointer(' + GetNewMethod(LOrgInstName, 'Create', False) + IfThen(IsComponent, '('+ IfThen(IsComponent, 'CheckPtr(owner)', '') +')',
                                          '(' + GetNotComponetFirstP(LOrgInstName, False, False) + ')') + ')');
          // 特殊情况下使用的
//          LFileGoVcl.Add('    ' + LFChar + '.ptr = unsafe.Pointer(' +  LFChar + '.instance)');
          // runtime.SetFinalizer(b, (*TButton).Free)
          //LFileGoVcl.Add('    // 不是TComponent应该是可以考虑加上的');

          if not IsComponent then
            LFileGoVcl.Add(Format('    setFinalizer(%s, (*%s).Free)', [LFChar, LOrgInstName]))
          else
          begin
//            LFileGoVcl.Add('    // 不是TComponent应该是可以考虑加上的');
//            LFileGoVcl.Add(Format('    // runtime.SetFinalizer(%s, (*%s).Free)', [LFChar, LOrgInstName]));
          end;
          LFileGoVcl.Add('    return ' + LFChar);
          LFileGoVcl.Add('}');
          LFileGoVcl.Add('');
        end;

        // 添加Is As
        //GIsAsFile.Add('// ' + LOrgInstName);
        GIsAsFile.Add('');
        GIsAsFile.Add('func (i TIs) ' + LWithoutTInstName + '() bool {');
        GIsAsFile.Add('    return ' + LWithoutTInstName + '_InheritsFrom(uintptr(i), ' + LOrgInstName + 'Class())');
        GIsAsFile.Add('}');
        GIsAsFile.Add('');
        GIsAsFile.Add('//func (a TAs) ' + LWithoutTInstName + '() *' + LOrgInstName + ' {');
        GIsAsFile.Add('//    return As' + LWithoutTInstName + '(uintptr(a))');
        GIsAsFile.Add('//}');
        GIsAsFile.Add('');


        // As操作
        LFileGoVcl.Add('// As' + LWithoutTInstName);
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 动态转换一个已存在的对象实例。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Dynamically convert an existing object instance.');
        LFileGoVcl.Add('func As' + LWithoutTInstName + '(obj interface{}) *' + LOrgInstName + ' {');
        LFileGoVcl.Add('    instance := getInstance(obj)');
        LFileGoVcl.Add('    if instance == nullptr { return nil }');
        LFileGoVcl.Add('    return &' + LOrgInstName + '{instance: instance}');
//        LFileGoVcl.Add('    ' + LFChar + ' := new(' + LOrgInstName + ')');
//        LFileGoVcl.Add('    ' + LFChar + '.instance, ' + LFChar + '.ptr = instance, ptr');
//        LFileGoVcl.Add('    return ' + LFChar);
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        //
//        LFileGoVcl.Add('// -------------------------- Deprecated begin --------------------------');
//        //LFileGoVcl.Add('// ' + LWithoutTInstName + 'FromInst');
//        LFileGoVcl.Add('// 新建一个对象来自已经存在的对象实例指针。');
//        LFileGoVcl.Add('// ');
//        LFileGoVcl.Add('// Create a new object from an existing object instance pointer.');
//        LFileGoVcl.Add('// Deprecated: use As' + LWithoutTInstName + '.');
//        LFileGoVcl.Add('func ' + LWithoutTInstName + 'FromInst(inst uintptr) *' + LOrgInstName + ' {');
//        LFileGoVcl.Add('    return As' + LWithoutTInstName + '(inst)');
//        LFileGoVcl.Add('}');
//        LFileGoVcl.Add('');
//
//        //LFileGoVcl.Add('// ' + LWithoutTInstName + 'FromObj');
//        LFileGoVcl.Add('// 新建一个对象来自已经存在的对象实例。');
//        LFileGoVcl.Add('// ');
//        LFileGoVcl.Add('// Create a new object from an existing object instance.');
//        LFileGoVcl.Add('// Deprecated: use As' + LWithoutTInstName + '.');
//        LFileGoVcl.Add('func ' + LWithoutTInstName + 'FromObj(obj IObject) *' + LOrgInstName + ' {');
//        LFileGoVcl.Add('    return As' + LWithoutTInstName + '(obj)');
//        LFileGoVcl.Add('}');
//        LFileGoVcl.Add('');
//
//        // unsafeAddr
//        //LFileGoVcl.Add('// ' + LWithoutTInstName + 'FromUnsafePointer');
//        LFileGoVcl.Add('// 新建一个对象来自不安全的地址。注意：使用此函数可能造成一些不明情况，慎用。');
//        LFileGoVcl.Add('// ');
//        LFileGoVcl.Add('// Create a new object from an unsecured address. Note: Using this function may cause some unclear situations and be used with caution..');
//        LFileGoVcl.Add('// Deprecated: use As' + LWithoutTInstName + '.');
//        LFileGoVcl.Add('func ' + LWithoutTInstName + 'FromUnsafePointer(ptr unsafe.Pointer) *' + LOrgInstName + ' {');
//        LFileGoVcl.Add('    return As' + LWithoutTInstName + '(ptr)');
//        LFileGoVcl.Add('}');
//        LFileGoVcl.Add('');
//        LFileGoVcl.Add('// -------------------------- Deprecated end --------------------------');

        if not ANoCreateAndFree then
        begin
          LFileGoVcl.Add('// Free ');
          LFileGoVcl.Add('//');
          LFileGoVcl.Add('// 释放对象。');
          LFileGoVcl.Add('// ');
          LFileGoVcl.Add('// Free object.');
          LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') Free() {');
          LFileGoVcl.Add('    if ' + LFChar + '.instance != nullptr {');
          LFileGoVcl.Add('        ' + GetNewMethod(LOrgInstName, 'Free', False) + '(' + LFChar + '._instance())');
          LFileGoVcl.Add('        ' + LFChar + '.instance ' + ' = nullptr');
          // 特殊情况下使用的
          //LFileGoVcl.Add('        ' + LFChar + '.ptr = nullptr');//unsafe.Pointer(uintptr(0))');
          LFileGoVcl.Add('    }');
          LFileGoVcl.Add('}');
          LFileGoVcl.Add('');
        end;


        LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') _instance() uintptr {');
        LFileGoVcl.Add('    return uintptr(' + LFChar + '.instance)');
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        LFileGoVcl.Add('// Instance ');
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 返回对象实例指针。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Return object instance pointer.');
        LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') Instance() uintptr {');
        LFileGoVcl.Add('    return ' + LFChar + '._instance()');
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        // UnsafeAddr
        LFileGoVcl.Add('// UnsafeAddr ');
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 获取一个不安全的地址。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Get an unsafe address.');
        LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') UnsafeAddr() unsafe.Pointer {');
        LFileGoVcl.Add('    return ' + LFChar + '.instance');
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        LFileGoVcl.Add('// IsValid ');
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 检测地址是否为空。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Check if the address is empty.');
        LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') IsValid() bool {');
        LFileGoVcl.Add('    return ' + LFChar + '.instance != nullptr');
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');


        LFileGoVcl.Add('// Is ');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// 检测当前对象是否继承自目标对象。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Checks whether the current object is inherited from the target object.');
        LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') Is() TIs {');
        LFileGoVcl.Add('    return TIs(' + LFChar + '._instance())');
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');

        LFileGoVcl.Add('// As ');
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 动态转换当前对象为目标对象。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Dynamically convert the current object to the target object.');
        LFileGoVcl.Add('//func (' + LFChar + ' *' + LOrgInstName + ') As() TAs {');
        LFileGoVcl.Add('//    return TAs(' + LFChar + '._instance())');
        LFileGoVcl.Add('//}');
        LFileGoVcl.Add('');



        LFileGoVcl.Add('// ' + LOrgInstName + 'Class');
        LFileGoVcl.Add('//');
        LFileGoVcl.Add('// 获取类信息指针。');
        LFileGoVcl.Add('// ');
        LFileGoVcl.Add('// Get class information pointer.');
        LFileGoVcl.Add('func ' + LOrgInstName + 'Class() TClass {');
        LFileGoVcl.Add('    return ' +Format('%s_StaticClassType()', [LWithoutTInstName]));
        LFileGoVcl.Add('}');
        LFileGoVcl.Add('');



        // 添加TStrings和TStringList的String和SetString简化
        if LOrgInstName.Equals('TStrings') or LOrgInstName.Equals('TStringList') then
        begin
          LFileGoVcl.Add('// S ');
          LFileGoVcl.Add('//');
          LFileGoVcl.Add('// Strings()的别名。');
          LFileGoVcl.Add('// ');
          LFileGoVcl.Add('// Alias of Strings().');
          LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') S(Index int32) string {');
          LFileGoVcl.Add('    return ' + LFChar + '.Strings(Index)');
          LFileGoVcl.Add('}');
          LFileGoVcl.Add('');

          LFileGoVcl.Add('// SetS ');
          LFileGoVcl.Add('//');
          LFileGoVcl.Add('// SetStrings()的别名。');
          LFileGoVcl.Add('// ');
          LFileGoVcl.Add('// Alias of SetStrings().');
          LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') SetS(Index int32, value string) {');
          LFileGoVcl.Add('    ' + LFChar + '.SetStrings(Index, value)');
          LFileGoVcl.Add('}');
          LFileGoVcl.Add('');
        end;




//        if IsWinControl then
//        begin
//          LFileGoVcl.Add('func (' + LFChar + ' *' + LOrgInstName + ') IsWinControl() bool {');
//          LFileGoVcl.Add('    return ' + LFChar + '.instance != 0');
//          LFileGoVcl.Add('}');
//          LFileGoVcl.Add('');
//        end;

        if not ANoCreateAndFree then
          AddConstructorAndDestructor(LOrgInstName)
        else AddHeaderInfo(LIncFile, False);



        //LMs: TArray<TRttiMethod>;
        //LProps: TArray<TRttiProperty>;
        //LIdxProps: TArray<TRttiIndexedProperty>;
        LMs := LInst.GetMethods;
        AddControlDefaultMethodsRtti(AClass, LMs);
        AddWinControlDefaultMethodsRtti(AClass, LMs);

        for LM in LMs do
        begin
          if (LM.Visibility <> mvPublic) and (LM.Visibility <> mvPublished) then
          begin
            Continue;
          end;
          LMName := LM.Name;

          if CanConv(LMName) then
          begin

            if LTempDict.ContainsKey(LMName) then
              Continue;
                  // 过滤某些组件相同名称的方法
            if FilterX(LOrgInstName, LMName) then
              Continue;


            if FilterXParamLen(LOrgInstName, LMName, LM.GetParameters) then
              Continue;


            if FilterXPropRW(LOrgInstName, LMName, True) then
              Continue;

            LTempDict.Add(LMName, '');

            LIncFile.Add('//CLASSMETHOD:'); // 用于区分属性和方法的，如果非方法的，前面以Get开头的就取掉Get

            //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');
            AddGoImport(LFirstCharLowerCaseName, LMName, LWithoutTInstName);

            // 导入的二次代码
            LCode := 'func ' + LWithoutTInstName + '_' + LMName + '(obj uintptr';

            // 函数参数
            LParams := LM.GetParameters;
            if Length(LParams) > 0 then
            begin
              LCode := LCode + ', ';
              for I := 0 to Length(LParams) - 1 do
              begin
                LP := LParams[I];

//                if FiterParam(LOrgInstName,  LM.Name, LP.Name) then
//                begin
//                  Delete(LCode, Length(LCode), 1);
//                  Break;
//                end;

                if I > 0 then
                  LCode := LCode + ', ';
                LCode := LCode + LP.Name + ' ';

                LCode := LCode + IfThen(TypeIsDelphiVarFlag(LP)
                 or
                   (((AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf'))  or
                    (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')))
                     and (I = 0)), '*', '') + DelphiParamTypeToGoType(LP.ParamType);
              end;
            end;

      

            LCode := LCode + ')';
            // 返回值
            if TypeIsRecOrFloat(LM.ReturnType) and (not TypeIsDateTime(LM.ReturnType)) then
            begin
              LCode := LCode + '(result ';
            end;
            LCode := LCode + ' ' + DelphiParamTypeToGoType(LM.ReturnType, True);
            if TypeIsRecOrFloat(LM.ReturnType) and (not TypeIsDateTime(LM.ReturnType)) then
            begin
              LCode := LCode + ') ';
            end;
            LCode := LCode + ' {'#13#10;

            // 实体代码
            // 这里添加变量声明
            if TypeIsRecOrFloat(LM.ReturnType) {and not TypeIsDateTime(LM.ReturnType)} then
            begin
              LNeedImport := True;
              if TypeIsDateTime(LM.ReturnType) then
                LCode := LCode + '    var result int64'#13#10;
//                LCode := LCode + '    var ret ' + IfThen(TypeIsDateTime(LM.ReturnType), 'int64', DelphiParamTypeToGoType(LM.ReturnType)) + #13#10;
            end;

            // 判断是不是TControl 的GetTextBuf
//            if AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf') then
//            begin
//              LCode := LCode + '    if ' + LParams[0].Name + ' == nil || ' + LParams[1].Name + ' == 0 {' + sLineBreak;
//              LCode := LCode + '        return 0' + sLineBreak;
//              LCode := LCode + '    }' + sLineBreak;
//              LCode := LCode + '    var strPtr uintptr' + sLineBreak;
//            end;




             (* if (AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf')) or
                 (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')) then
              begin
                LCode := LCode + '    if Buffer == nil || BufSize == 0 {' + sLineBreak;
                LCode := LCode + '        return 0' + sLineBreak;
                LCode := LCode + '    }' + sLineBreak;
                LCode := LCode + '    strPtr := getBuff(' + LParams[1].Name + ')' + sLineBreak;
//                LCode := LCode + '    if IsloadedLcl {' + sLineBreak;
//                LCode := LCode + '        buff := make([]uint8, BufSize + 1)' + sLineBreak;
//                LCode := LCode + '        ret, _, _ := memo_GetTextBuf.Call(obj, uintptr(unsafe.Pointer(&buff[0])), uintptr(BufSize))' + sLineBreak;
//                LCode := LCode + '        *Buffer = getTextBufAnsi(buff, Buffer)' + sLineBreak;
//                LCode := LCode + '    } else {' + sLineBreak;
//                LCode := LCode + '        buff := make([]uint16, BufSize + 1)' + sLineBreak;
//                LCode := LCode + '        ret, _, _ := memo_GetTextBuf.Call(obj, uintptr(unsafe.Pointer(&buff[0])), uintptr(BufSize))' + sLineBreak;
//                LCode := LCode + '        *Buffer = getTextBufUnicode(buff, Buffer)' + sLineBreak;
//                LCode := LCode + '    }' + sLineBreak;
//                LCode := LCode + '    return int32(ret)' + sLineBreak;
//                LCode := LCode + '}' + sLineBreak;
              end;    *)



            LCode := LCode + '    ';
            if (LM.ReturnType <> nil) and (not TypeIsRecOrFloat(LM.ReturnType) {and not TypeIsDateTime(LM.ReturnType)} ) then
              LCode := LCode + 'return ';

            LNeedClosingBracket := False;
            if LM.ReturnType <> nil then
            begin
              LType := DelphiParamTypeToGoType(LM.ReturnType);
              if LType <> 'uintptr' then
              begin
                LNeedClosingBracket := True;
                if LType = 'string' then
                   LCode := LCode + 'GoStr('//#13#10
                else if LType = 'bool' then
                   LCode := LCode + 'GoBool('//#13#10
                else if TypeIsDateTime(LM.ReturnType) then
                begin
                   //LCode := LCode + 'return time.Unix(ret, 0)';//#13#10
                   LNeedClosingBracket := False;
                   //LCode := LCode + '    return time.Unix(int64(ret), 0)'#13#10
                end
                else if TypeIsRecOrFloat(LM.ReturnType) then
                begin
                  LNeedImport := True;
                  //LCode := LCode + 'return ret'//#13#10
                  LNeedClosingBracket := False;
                end
                else
                  LCode := LCode + '' + LType + '('; //#13#10

              end ;//else
               // LCode := LCode + 'return '//#13#10;
            end;

            LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);


            if (AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf')) or
               (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')) then
              LCode := LCode + 'syscallGetTextBuf'
            else
              LCode := LCode + 'syscallN';

//            LCode := LCode + 'syscallN(' + LNameTemp + ').Call(obj' + '';
            LCode := LCode + '(' + LNameTemp + ', obj' + '';
//            AddToGlobalDllImport(LNameTemp);

            if Length(LParams) > 0 then
            begin
              LCode := LCode + ', ';
              for I := 0 to Length(LParams) - 1 do
              begin
                LP := LParams[I];

//                if FiterParam(LOrgInstName,  LM.Name, LP.Name) then
//                begin
//                  Delete(LCode, Length(LCode), 1);
//                  Break;
//                end;

                if I > 0 then
                  LCode := LCode + ', ';

                // 修复一个
                LType := DelphiParamTypeToGoType(LP.ParamType);
            

                // 带有专用标识的要使用指针

                //  LType := '*' + LType;

                if LType <> 'uintptr' then
                begin
                  if LType = 'string' then
                  begin
                     if (AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf')) or
                        (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')) then
//                       LCode := LCode + 'getBuffPtr(strPtr)'
                       LCode := LCode + LP.Name
                     else
                       LCode := LCode + 'PascalStr(' + LP.Name + ') ';
                       
                  end
                  else if LType = 'bool' then
                     LCode := LCode + 'PascalBool(' + LP.Name + ') '
                  else if TypeIsDelphiVarFlag(LP) then
                  begin
                    LNeedImport := True;
                    LCode := LCode + 'uintptr(unsafe.Pointer(' + LP.Name + '))'
                  end
                  else if TypeIsDateTime(LP.ParamType) then
                    LCode := LCode + 'uintptr(' + LP.Name + '.Unix())'
                  else if TypeIsRecOrFloat(LP.ParamType) then
                  begin
                    LNeedImport := True;
                    LCode := LCode + 'uintptr(unsafe.Pointer(&' + LP.Name + '))'
                  end
                  else LCode := LCode + 'uintptr(' + LP.Name + ') '
                end else
                if TypeIsDelphiVarFlag(LP) then
                begin
                  LNeedImport := True;
                  LCode := LCode + 'uintptr(unsafe.Pointer(' + LP.Name + '))'
                end else
                  LCode := LCode + LP.Name + ' ';
              end;
            end;

            // 这里加上返回值放后面的
            if TypeIsRecOrFloat(LM.ReturnType) {and not TypeIsDateTime(LM.ReturnType)} then
            begin
              LNeedImport := True;
              LCode := LCode + ', uintptr(unsafe.Pointer(&result))';
            end;


            if LNeedClosingBracket then
              LCode := LCode + ')';


            //if not LNeedClosingBracket then
              LCode := LCode + ')'#13#10;

             if TypeIsRecOrFloat(LM.ReturnType)  then
             begin
               if TypeIsDateTime(LM.ReturnType) then
                 LCode := LCode  + '    return time.Unix(result, 0)' + slinebreak
               else
                 LCode := LCode  + '    return' + slinebreak;
             end;

           (*
            // 结尾
            if (AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf')) or
               (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')) then
            begin
              LCode := LCode + '    getTextBuf(strPtr, ' + LParams[0].Name + ', int(ret))' + sLineBreak;
              //LCode := LCode + '    getTextBuf(strPtr, ' + LParams[0].Name + ', ' + LParams[1].Name +  ')' + sLineBreak;

//              LCode := LCode + '    if IsloadedLcl {' + sLineBreak;
//              LCode := LCode + '        buff := make([]byte, ' + LParams[1].Name + ')' + sLineBreak;
//              LCode := LCode + '        DMove(strPtr, uintptr(unsafe.Pointer(&buff[0])), len(buff))' + sLineBreak;
//              LCode := LCode + '        *' + LParams[0].Name + ' = string(buff)' + sLineBreak;
//              LCode := LCode + '    } else {' + sLineBreak;
//              LCode := LCode + '        buff := make([]uint16, ' + LParams[1].Name + ')' + sLineBreak;
//              LCode := LCode + '        DMove(strPtr, uintptr(unsafe.Pointer(&buff[0])), len(buff)*2)' + sLineBreak;
//              LCode := LCode + '        *' + LParams[0].Name + ' = syscall.UTF16ToString(buff)' + sLineBreak;
//              LCode := LCode + '    }' + sLineBreak;



            end;   *)


//            if LM.ReturnType <> nil then
//            begin
//              LType := DelphiParamTypeToGoType(LM.ReturnType);
//              if LType <> 'uintptr' then
//              begin
//                if LType = 'string' then
//                   LCode := LCode + '    return GoStr(ret)'#13#10
//                else if LType = 'bool' then
//                   LCode := LCode + '    return GoBool(ret)'#13#10
//                else if TypeIsDateTime(LM.ReturnType) then
//                   LCode := LCode + '    return time.Unix(ret, 0)'#13#10
//                   //LCode := LCode + '    return time.Unix(int64(ret), 0)'#13#10
//                else if TypeIsRecOrFloat(LM.ReturnType) then
//                begin
//                  LNeedImport := True;
//                  LCode := LCode + '    return ret'#13#10
//                end
//                else
//                  LCode := LCode + '    return ' + LType + '(ret)'#13#10
//              end else
//                LCode := LCode + '    return ret'#13#10;
//            end;


            LCode := LCode + '}'#13#10;
            LFileGodll.Add(LCode);

            // 类vcl
            LCode := '';//'// ' + LMName + #13#10;
            LCode := LCode + GetComment(LOrgInstName, LMName, False, False);
            LCode := LCode + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LMName + '(';

            if Length(LParams) > 0 then
            begin
              for I := 0 to Length(LParams) - 1 do
              begin
                LP := LParams[I];

//                if FiterParam(LOrgInstName,  LM.Name, LP.Name) then
//                begin
//                //  Delete(LCode, Length(LCode), 1);
//                  Break;
//                end;


                if I > 0 then
                  LCode := LCode + ', ';
                LCode := LCode + LP.Name + ' ';
                // 这里检测
                LCode := LCode + IfThen(TypeIsDelphiVarFlag(LP) 
                  or
                  (((AClass.InheritsFrom(TControl) and LMName.Equals('GetTextBuf')) or
                   (AClass.InheritsFrom(TCustomEdit) and LMName.Equals('GetSelTextBuf')))

                  and (I = 0)) , '*', '');

                if (LOrgInstName.Equals('TStrings') or LOrgInstName.Equals('TStringList')) and (LM.Name.Equals('Equals') and LP.ParamType.Name.Equals('TStrings')) then
                begin
                  LCode := LCode + 'IObject';
                end else
                  LCode := LCode + DelphiParamTypeToGoType(LP.ParamType, False, True);
              end;
              LCode := LCode.TrimRight;
              
            end;

            LType := DelphiParamTypeToGoType(LM.ReturnType, True, True);
            LCode := LCode + ') ';
            if LM.ReturnType <> nil then
              LCode := LCode + LType + ' ';
            LCode := LCode + '{'#13#10;

            // 这里加异常处理代码
            LCode := LCode + ExceptionCode;

            LCode := LCode + '    ';
            if LM.ReturnType <> nil then
            begin
               LCode := LCode + 'return ';
               if not LType.IsEmpty and (LType[1] = '*') then
                 LCode := LCode +  'As' + IfThen(LType[2] = 'T', LType.Remove(0,2), LType.Remove(0,1)) + '('  // 'FromInst('
               //else if not LType.IsEmpty and (LType = 'IObject') then

            end;
            LCode := LCode + GetNewMethod(LOrgInstName, LMName, False);



            LCode := LCode + '(';


             LCode := LCode + LFChar + '._instance()';

            if Length(LParams) > 0 then
            begin
              for I := 0 to Length(LParams) - 1 do
              begin
                LP := LParams[I];
                if I >= 0 then
                  LCode := LCode + ', ';
                LType := DelphiParamTypeToGoType(LP.ParamType, False, True);
                //if  then         // *T
                //  LCode := LCode + LType.Remove(0,2) + 'From(' + LP.Name + '.Instance())'
                //else
                if  (LType[1] = '*') or LType.Equals('IObject') or LType.Equals('IControl') or LType.Equals('IComponent')
                  or LType.Equals('IWinControl') or LType.Equals('IStrings') or LType.Equals('IStream') or LType.Equals('IGraphic') or LType.Equals('IBitmap') then
                  LCode := LCode + 'CheckPtr(' + LP.Name + ')' // .Instance() LCode := LCode + ')';
                else
                begin
                    LCode := LCode + LP.Name + ' ';
                end;


              end;
            end;
            LCode := LCode.TrimRight;
            LType := DelphiParamTypeToGoType(LM.ReturnType, True, True);
            if not LType.IsEmpty and (LType[1] = '*') then
              LCode := LCode + ')';
            LCode := LCode + ')';

            LCode := LCode + #13#10;
            LCode := LCode + '}'#13#10;
            LFileGoVcl.Add(LCode);
            MakeMethodCode(LOrgInstName, LM, True);
          end;
        end;

        // 属性，不含index类型的

        LProps := LInst.GetProperties;
        AddControlDefaultPropsRtti(AClass, LProps);
        AddWinControlDefaultPropsRtti(AClass, LProps);
        for LPR in LProps  do
        begin
          if (LPR.Visibility <> mvPublic) and (LPR.Visibility <> mvPublished) then
          begin
            Continue;
          end;
              // 过滤某些组件相同名称的方法
          if FilterX(LOrgInstName, LPR.Name) then
            Continue;

          LMName := LPR.Name;
          if CanConv(LMName) then
          begin
            if LTempDict.ContainsKey(LMName) then
              Continue;


            LTempDict.Add(LMName, '');
            // 有读属性，生成函数
            if LPR.IsReadable then
            begin
              LMName := 'Get' + FixPropName(LPR.Name);
              if LPR.PropertyType.TypeKind <> tkMethod then
              begin
                // 添加标识，用于标识是最后一个参数返回的
                if TypeIsRecOrFloat(LPR.PropertyType) {and not TypeIsDateTime(LPR.PropertyType)} then
                  LIncFile.Add('//RETURNISLASTPARAM:');

                LIncFile.Add(GetDelphiMethodCode(LPR.Name, LOrgInstName, DTypeConvert(LPR.PropertyType), '', '', False, True, False, True,
                  TypeIsRecOrFloat(LPR.PropertyType) {and not TypeIsDateTime(LPR.PropertyType)}  , False, '', '', '', '', GetReturnTypeKind(LPR.PropertyType)));
                //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');
                AddGoImport(LFirstCharLowerCaseName, LMName, LWithoutTInstName);

                LCode := 'func ' + GetNewMethod(LOrgInstName, LMName, False) + '(obj uintptr) ';

                if TypeIsRecOrFloat(LPR.PropertyType) and (not TypeIsDateTime(LPR.PropertyType)) then
                  LCode := LCode + '(result ';
                LCode := LCode + DelphiParamTypeToGoType(LPR.PropertyType);
                if TypeIsRecOrFloat(LPR.PropertyType) and (not TypeIsDateTime(LPR.PropertyType)) then
                  LCode := LCode + ')';
                LCode := LCode + ' {'#13#10;
                LNeedClosingBracket := False;



                // 一定有返回值
                if not TypeIsRecOrFloat(LPR.PropertyType) then
                  LCode := LCode + '    return ';

                if TypeIsRecOrFloat(LPR.PropertyType) {and not TypeIsDateTime(LPR.PropertyType)} then
                begin
                  LNeedImport := True;
                  if TypeIsDateTime(LPR.PropertyType) then
                    LCode := LCode + '    var result int64'#13#10;
                
//                  LCode := LCode + '    var ret '+  ifThen(TypeIsDateTime(LPR.PropertyType), 'int64', DelphiParamTypeToGoType(LPR.PropertyType)) + #13#10;
                  LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                  LCode := LCode + '    syscallN(' + LNameTemp + ').Call(obj, uintptr(unsafe.Pointer(&ret)))'#13#10;
                  LCode := LCode + '    syscallN(' + LNameTemp + ', obj, uintptr(unsafe.Pointer(&result)))'#13#10;
                  if TypeIsDateTime(LPR.PropertyType) then
                    LCode := LCode + '    return time.Unix(result, 0)'
                  else 
                    LCode := LCode + '    return';
//                  AddToGlobalDllImport(LNameTemp);
                end
                else
                begin
                  LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);

                  LNeedClosingBracket := False;
                  LType := DelphiParamTypeToGoType(LPR.PropertyType);
                  if LType <> 'uintptr' then
                  begin

                    if LType = 'string' then
                    begin
                       LCode := LCode + 'GoStr(';
                       LNeedClosingBracket := True;
                    end
                    else if LType = 'bool' then
                    begin
                       LCode := LCode + 'GoBool(';
                       LNeedClosingBracket := True;
                    end
                    else if TypeIsDateTime(LPR.PropertyType) then
//                       LCode := LCode + 'time.Unix(result), 0)'
                    else if TypeIsRecOrFloat(LPR.PropertyType) then
                       //LCode := LCode + 'ret'#13#10//*(*' + LType + ')(unsafe.Pointer(ret))'#13#10
                    else
                    begin
                      LCode := LCode + '' + LType + '(';
                      LNeedClosingBracket := True;
                    end;
                  end;


//                  LCode := LCode + '    ret, _, _ := syscallN(' + LNameTemp + ').Call(obj)'#13#10;
                  LCode := LCode + 'syscallN(' + LNameTemp + ', obj)';
                  if LNeedClosingBracket then
                    LCode := LCode + ')';
//                  LCode := LCode + slinebreak;

//                  AddToGlobalDllImport(LNameTemp);
                end;




//                if TypeIsRecOrFloat(LPR.PropertyType) then
//                  LCode := LCode + '    return' + slinebreak;

                LCode := LCode + #13#10 + '}'#13#10;
                LFileGodll.Add(LCode);
//                LFileGoVcl

                LType := DelphiParamTypeToGoType(LPR.PropertyType, True, True);

                // vcl
                LCode := '';//'// ' + LPR.Name + #13#10;
                LCode := LCode + GetComment(LOrgInstName, LPR.Name, True, False);
                LCode := LCode + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LPR.Name + '() ' + LType + ' {'#13#10;
                // 这里加异常处理代码
                LCode := LCode + ExceptionCode;

                if not (AClass.InheritsFrom(TControl) and (LPR.Name.Equals('Text'))) then
                  LCode := LCode + '    return ';
                //if LType = 'IObject' then
                //begin
                //  LCode := LCode + 'ObjectFrom(';
                //end else
                if LType[1] = '*' then         // *T
                  LCode := LCode + 'As' + IfThen(LType[2] = 'T', LType.Remove(0,2), LType.Remove(0,1))  + '(';  // 'FromInst(

                // 针对文本控件的处理
                if AClass.InheritsFrom(TControl) and (LPR.Name.Equals('Text')) then
                begin
                  //LCode := LCode + '    if IsWindows {' + sLineBreak;

                  LCode := LCode + '    return getControlBufferText(' + LFChar + '.GetTextLen, ' + LFChar + '.GetTextBuf)' + sLineBreak;
//                  LCode := LCode + '    strLen := ' + LFChar + '.GetTextLen()' + sLineBreak;// GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '.instance)';
//                  LCode := LCode + '    if strLen != 0 {' + sLineBreak;
//                  LCode := LCode + '        var buffStr string' + sLineBreak;
//                  LCode := LCode + '        ' + LFChar + '.GetTextBuf(&buffStr, strLen + 1)' + sLineBreak;
//                  LCode := LCode + '        return buffStr' + sLineBreak;
//                  LCode := LCode + '    }' + sLineBreak;
//                  LCode := LCode + '    return ""' + sLineBreak;

                  //LCode := LCode + '    } else { ' + sLineBreak;
                  //LCode := LCode + '        return ' + GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '.instance)' + sLineBreak;
                  //LCode := LCode + '    }';
                end else
                  LCode := LCode + GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '._instance())';
                if (LType[1] = '*'){ or (LType = 'IObject')} then
                  LCode := LCode + ')';

                if not(AClass.InheritsFrom(TControl) and (LPR.Name.Equals('Text'))) then
                  LCode := LCode + #13#10;
                LCode := LCode + '}'#13#10;
                LFileGoVcl.Add(LCode);

                AddExport(LOrgInstName, LMName);
              end;
            end;

            if LPR.IsWritable then
            begin
              LMName := 'Set' + FixPropName(LPR.Name);
              if FilterXPropRW(LOrgInstName, LPR.Name, True) then
                Continue;

//              if FilterX(LOrgInstName, LPR.Name) then
//                Continue;

//              if LMName.Equals('SetOnClick') then
              if GEvents.ContainsKey(LPR.Name) and (LPR.PropertyType.TypeKind = tkMethod) then
              begin
//                if LPR.Name.Equals('OnChange') and ( LOrgInstName.Equals('TMainMenu') or LOrgInstName.Equals('TPopupMenu')
//                  or LOrgInstName.Equals('TListView') or LOrgInstName.Equals('TOpenDialog') ) then
//                  Continue;
                // 使用宏定义的
                (*LIncFile.Add('procedure ' + GetNewMethod(LOrgInstName, LMName, False) + '(AObj: ' + LOrgInstName + '; AEventId: NativeUInt); extdecl;');
                LIncFile.Add('begin');
                LIncFile.Add('  if AEventId = 0 then');
                LIncFile.Add('  begin');
                LIncFile.Add('    AObj.' + FixEventName( LPR.Name ) + ' := nil;');
                LIncFile.Add('    TEventClass.Remove(AObj, @TEventClass.' + GetEventName(LOrgInstName, LPR.Name) + LPR.Name{.Remove(0, 2)} + ');');
                LIncFile.Add('    Exit;');
                LIncFile.Add('  end;');
                LIncFile.Add('  AObj.' + FixEventName( LPR.Name  ) + ' := TEventClass.' + GetEventName(LOrgInstName, LPR.Name) + LPR.Name + ';');
                LIncFile.Add('  TEventClass.Add(AObj, @TEventClass.' + GetEventName(LOrgInstName, LPR.Name)+LPR.Name{.Remove(0, 2)} + ', AEventId);');
                LIncFile.Add('end;'#13#10); *)
                LIncFile.Add('//EVENT_TYPE:'+FixEventTypeName(LPR.PropertyType.Name)); // 方便工具生成事件
                LIncFile.Add('procedure ' + GetNewMethod(LOrgInstName, LMName, False) + '(AObj: ' + LOrgInstName + '; AEventData: Pointer); extdecl;');
                LIncFile.Add('begin');




                // 直接使用事件类型作为事件名，以减少
//                LIncFile.Add('  {$DEFINE EventName := On' + LPR.PropertyType.Name + '}');

                  // 新的
                LIncFile.Add('  {$DEFINE EventMethodName := On' + {FixEvenMethodName(}FixEventTypeName(LPR.PropertyType.Name){, LPR.Name)} + '}');
                LIncFile.Add('  {$DEFINE EventName := ' + FixEventName(LPR.Name) + '}');
                LIncFile.Add('  EventMethodCode');


                //                LIncFile.Add('  {$DEFINE EventMethodName := ' + GetEventName(LOrgInstName, LPR.Name) + LPR.Name + '}');
                //LIncFile.Add('  {$DEFINE EventMethod := TEventClass.EventMethodName}');
               // 原来的方式

//                LIncFile.Add('  if AEventId = 0 then');
//                LIncFile.Add('  begin');
//                LIncFile.Add('    AObj.' + FixEventName( LPR.Name ) + ' := nil;');
//                LIncFile.Add('    // ' + GetEventName(LOrgInstName, LPR.Name) + LPR.Name);
//                LIncFile.Add('    TEventClass.Remove(AObj, @TEventClass.On' + FixEvenMethodName(LPR.PropertyType.Name, LPR.Name) + ');');
//                LIncFile.Add('    Exit;');
//                LIncFile.Add('  end;');
//                LIncFile.Add('  AObj.' + FixEventName( LPR.Name  ) + ' := TEventClass.' + GetEventName(LOrgInstName, LPR.Name) + LPR.Name + ';');
//                LIncFile.Add('  TEventClass.Add(AObj, @TEventClass.' + GetEventName(LOrgInstName, LPR.Name)+LPR.Name{.Remove(0, 2)} + ', AEventId);');
                LIncFile.Add('end;'#13#10);


                // api
                LFileGodll.Add('func ' + GetNewMethod(LOrgInstName, LMName, False) + '(obj uintptr, fn interface{}) {');
                LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                LFileGodll.Add('    syscallN(' + LNameTemp + ').Call(obj, MakeEventDataPtr(fn))');
                LFileGodll.Add('    syscallN(' + LNameTemp + ', obj, MakeEventDataPtr(fn))');
                LFileGodll.Add('}');
                LFileGodll.Add('');
//                AddToGlobalDllImport(LNameTemp);


                // vcl
                LFileGoVcl.Add({'// ' + LMName + #13#10 + }GetComment(LOrgInstName, LPR.Name, True, True) + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LMName + '(fn ' + FixEventTypeName(LPR.PropertyType.Name) + ') {');
                // 这里加异常处理代码
                LCode := LCode + ExceptionCode;

                LFileGoVcl.Add('    ' + GetNewMethod(LOrgInstName, LMName, False) +'(' + LFChar + '._instance(), fn)');
                LFileGoVcl.Add('}');
                LFileGoVcl.Add('');

              end else
              begin

                 //// 2=nonPtr,4=nonPtr
//                LPsNonPtrFlags := GetNonPtrFlags(AMethod.GetParameters);
//                if LPsNonPtrFlags <> '' then


                LTempStr := Format('AValue: %s', [DTypeConvert(LPR.PropertyType)]);
                if TypeIsRecOrFloat(LPR.PropertyType) {and not TypeIsDateTime(LPR.PropertyType)} then
                begin
                  LIncFile.Add('//PARAMS:2=nonPtr');
                  LNeedImport := True;
                  LTempStr := Format('var AValue: %s', [DTypeConvert(LPR.PropertyType)]);
                end;
                LIncFile.Add(GetDelphiMethodCode(LPR.Name, LOrgInstName, '', LTempStr,
                   IfThen(TypeIsDateTime(LPR.PropertyType), 'UnixToTime(AValue)', 'AValue'),
                   False, False, True, True, False));

                LCode := 'func ' + GetNewMethod(LOrgInstName, LMName, False) + '(obj uintptr, value ' + DelphiParamTypeToGoType(LPR.PropertyType) + ')' + ' {'#13#10;
                // 这里加异常处理代码
                //LCode := LCode + ExceptionCode;

                if TypeIsDateTime(LPR.PropertyType) then
                  LCode := LCode + '    tVal := value.Unix()'#13#10;
                LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                LCode := LCode + '    syscallN(' + LNameTemp + ').Call(obj, ';
                LCode := LCode + '    syscallN(' + LNameTemp + ', obj, ';
//                AddToGlobalDllImport(LNameTemp);
                LType := DelphiParamTypeToGoType(LPR.PropertyType);
                if LType <> 'uintptr' then
                begin
                  if LType = 'string' then
                     LCode := LCode + 'PascalStr(value)'
                  else if LType = 'bool' then
                     LCode := LCode + 'PascalBool(value)'
                  else if TypeIsDateTime(LPR.PropertyType) then
                  begin
                    //LCode := LCode + 'val := value.Unix()'#13#10;
                    LCode := LCode + 'uintptr(unsafe.Pointer(&tVal))';
                  end
                  else if TypeIsRecOrFloat(LPR.PropertyType) then
                     LCode := LCode + 'uintptr(unsafe.Pointer(&value))'
                  else
                    LCode := LCode + 'uintptr(value)';
                end else
                  LCode := LCode + 'value';
                LCode := LCode + ')'#13#10;;

                LCode := LCode + '}'#13#10;
                LFileGodll.Add(LCode);
//                LFileGoVcl

                LType := DelphiParamTypeToGoType(LPR.PropertyType, False, True);

                // vcl
                LCode := '';//'// ' + LMName + #13#10;
                LCode := LCode + GetComment(LOrgInstName, LPR.Name, True, True);
                LCode := LCode + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LMName + '(value ' + LType + ') {'#13#10;
                // 这里加异常处理代码
                LCode := LCode + ExceptionCode;

                LCode := LCode + '    ';
              
                  LCode := LCode +  GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '._instance(), ';
//                if LType <> 'uintptr' then
//                begin
//                  if LType = 'string' then
//                     LCode := LCode + 'PascalStr(value)'
//                  else if LType = 'bool' then
//                     LCode := LCode + 'PascalBool(value)'
//                  else
//                   LCode := LCode + 'value';
//                end else
                if IsObject(LPR.PropertyType) then
                  LCode := LCode + 'CheckPtr(value)'
                else
                  LCode := LCode + 'value';

                LCode := LCode + ')'#13#10;
                LCode := LCode + '}'#13#10;
                LFileGoVcl.Add(LCode);
              end;
              AddGoImport(LFirstCharLowerCaseName, LMName, LWithoutTInstName);
              //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');
              AddExport(LOrgInstName, LMName);
            end;
          end;
        end;

//        Continue;
        // index 类别的
        LIdxProps := LInst.GetIndexedProperties;
        AddControlDefaultIndexPropsRtti(AClass, LIdxProps);
        AddWinControlDefaultIndexPropsRtti(AClass, LIdxProps);

        for LIdxP in LIdxProps do
        begin
          if (LIdxP.Visibility <> mvPublic) and (LIdxP.Visibility <> mvPublished) then
          begin
            Continue;
          end;
          LMName := LIdxP.Name;
          if CanConv(LMName) then
          begin
            if LTempDict.ContainsKey(LMName) then
              Continue;
            // 过滤某些组件相同名称的方法
            if FilterX(LOrgInstName, LIdxP.Name) then
              Continue;

            LTempDict.Add(LMName, '');

//            LIncFile.Add();

            LNeedClosingBracket := False;
            // 有读属性，生成函数
            if LIdxP.IsReadable then
            begin
              LMName := 'Get' + FixPropName(LIdxP.Name);
              if LIdxP.PropertyType.TypeKind <> tkMethod then
              begin
                LM := LIdxP.ReadMethod;

//                Writeln('LM.GetParameters[0].Name: ', LM.GetParameters[0].Name, ',   ', DTypeConvert(LM.GetParameters[0].ParamType));


                LTemp1 := '';
                LTemp2 := '';
                if Length(LM.GetParameters) >= 2 then
                begin
                  LTemp1 := LM.GetParameters[1].Name;
                  LTemp2 := DTypeConvert(LM.GetParameters[1].ParamType);

                end;
                // 添加标识，用于标识是最后一个参数返回的
                if TypeIsRecOrFloat(LIdxP.PropertyType) {and not TypeIsDateTime(LIdxP.PropertyType)} then
                  LIncFile.Add('//RETURNISLASTPARAM:');

                LIncFile.Add(GetDelphiMethodCode(LIdxP.Name, LOrgInstName, DTypeConvert(LIdxP.PropertyType),
                  '', '', False, True, False, True,
                    TypeIsRecOrFloat(LIdxP.PropertyType) {and not TypeIsDateTime(LIdxP.PropertyType) }
                    , True,
                    LM.GetParameters[0].Name, DTypeConvert(LM.GetParameters[0].ParamType),
                    LTemp1, LTemp2
                  //  IfThen(Length(LM.GetParameters) >= 2, LM.GetParameters[1].Name, ''),
                   // IfThen(Length(LM.GetParameters) >= 2, DTypeConvert(LM.GetParameters[1].ParamType), '')
                     ,GetReturnTypeKind(LIdxP.PropertyType)
                   ));
                //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');
                AddGoImport(LFirstCharLowerCaseName, LMName, LWithoutTInstName);

                LCode := 'func ' + GetNewMethod(LOrgInstName, LMName, False) + '(obj uintptr, '
                // 参数1
                + LM.GetParameters[0].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[0].ParamType);

                // 参数2
                if Length(LM.GetParameters) >= 2 then
                begin
                  LCode := LCode + ', ' + LM.GetParameters[1].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[1].ParamType);
                end;

                // 结束
                LCode := LCode + ') ';

                // 返回类型是浮点或者结构类型，则用最后一个参数传递结果
//                if TypeIsRecOrFloat(LIdxP.PropertyType) then
//                begin
//                  LCode := LCode + '(fdsff)';
//                end;

                if TypeIsRecOrFloat(LIdxP.PropertyType) and (not TypeIsDateTime(LIdxP.PropertyType)) then
                  LCode := LCode + '(result ';

                LCode := LCode + DelphiParamTypeToGoType(LIdxP.PropertyType);

                if TypeIsRecOrFloat(LIdxP.PropertyType) and (not TypeIsDateTime(LIdxP.PropertyType)) then
                  LCode := LCode + ')';

                LCode := LCode + ' {'#13#10;


                // 一定有返回值
                //LCode := LCode + '    return ';

                if TypeIsRecOrFloat(LIdxP.PropertyType) {and not TypeIsDateTime(LIdxP.PropertyType)} then
                begin
                  LNeedImport := True;
                  if TypeIsDateTime(LIdxP.PropertyType) then
                    LCode := LCode + '    var result int64'#13#10;
                    
//                  LCode := LCode + '    var ret '+ IfThen(TypeIsDateTime(LIdxP.PropertyType), 'int64', DelphiParamTypeToGoType(LIdxP.PropertyType)) + #13#10;
                  LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                  LCode := LCode + '    syscallN(' + LNameTemp + ').Call(obj, ';
                  LCode := LCode + '    syscallN(' + LNameTemp + ', obj, ';
//                  AddToGlobalDllImport(LNameTemp);

                  LType := DelphiParamTypeToGoType(LM.GetParameters[0].ParamType);
                  if LType.Equals('string') then
                     LCode := LCode  + 'PascalStr(' + LM.GetParameters[0].Name + '), '
                  else if LType <> 'uintptr' then
                     LCode := LCode + 'uintptr(' + LM.GetParameters[0].Name + '), '
                  else LCode := LCode + LType;

                  LCode := LCode + 'uintptr(unsafe.Pointer(&result)))'#13#10;
                  if TypeIsDateTime(LIdxP.PropertyType) then
                    LCode := LCode + '    return time.Unix(result, 0)'
                  else 
                    LCode := LCode + '    return';

                  
                end
                else
                begin

                  LCode := LCode + '    return ';
                  LNeedClosingBracket := False;
                  LType := DelphiParamTypeToGoType(LIdxP.PropertyType);
                  if LType <> 'uintptr' then
                  begin

                    if LType = 'string' then
                    begin
                      LCode := LCode + 'GoStr(';
                      LNeedClosingBracket := True;
                    end
                    else if LType = 'bool' then
                    begin
                      LCode := LCode + 'GoBool(';
                      LNeedClosingBracket := True;
                    end
                    else if TypeIsDateTime(LIdxP.PropertyType) then
                       LCode := LCode + 'time.Unix(int64(ret), 0)'#13#10
                    else if TypeIsRecOrFloat(LIdxP.PropertyType) then
                       LCode := LCode + 'ret'#13#10//*(*' + LType + ')(unsafe.Pointer(ret))'#13#10
                    else
                    begin
                      LCode := LCode + '' + LType + '(';
                      LNeedClosingBracket := True;
                    end;
                  end;// else
//                    LCode := LCode + 'ret'#13#10;


                  LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                  LCode := LCode + '    ret, _, _ := syscallN(' + LNameTemp + ').Call(obj, ';
                  LCode := LCode + 'syscallN(' + LNameTemp + ', obj, ';
//                  AddToGlobalDllImport(LNameTemp);

                   LType := DelphiParamTypeToGoType(LM.GetParameters[0].ParamType);
                  if LType.Equals('string') then
                     LCode := LCode  + 'PascalStr(' + LM.GetParameters[0].Name + ')'
                  else if LType <> 'uintptr' then
                     LCode := LCode + 'uintptr(' + LM.GetParameters[0].Name + ')'
                  else LCode := LCode + LType;

                  if Length(LM.GetParameters) >= 2 then
                  begin
                    LCode := LCode + ', ';
                    if LType.Equals('string') then
                       LCode := LCode  + 'PascalStr(' + LM.GetParameters[1].Name + ')'
                    else if LType <> 'uintptr' then
                       LCode := LCode + 'uintptr(' + LM.GetParameters[1].Name + ')'
                    else LCode := LCode + LType;
                  end;
                  LCode := LCode + ')';

                 if LNeedClosingBracket then
                   LCode := LCode + ')';
                end;


                LCode := LCode + slinebreak + '}'#13#10;
                LFileGodll.Add(LCode);
//                LFileGoVcl

                LType := DelphiParamTypeToGoType(LIdxP.PropertyType, True, True);

                // vcl
                LCode := '';//'// ' + LIdxP.Name + #13#10;
                LCode := LCode + GetComment(LOrgInstName, LIdxP.Name, True, False);
                LCode := LCode + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LIdxP.Name + '('

                // 参数1
                + LM.GetParameters[0].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[0].ParamType);

                // 参数2
                if Length(LM.GetParameters) >= 2 then
                begin
                  LCode := LCode + ', ' + LM.GetParameters[1].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[1].ParamType);
                end;


                // 结束
                LCode := LCode + ') ' + LType + ' {'#13#10;

                // 这里加异常处理代码
                LCode := LCode + ExceptionCode;

                LCode := LCode + '    return ';
                if LType[1] = '*' then         // *T
                  LCode := LCode + 'As' + IfThen(LType[2] = 'T', LType.Remove(0,2),  LType.Remove(0,1))  + '(';   //  'FromInst(';

                LCode := LCode + GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '._instance(), '

                 + LM.GetParameters[0].Name;
                 if Length(LM.GetParameters) >= 2 then
                   LCode := LCode + ', ' + LM.GetParameters[1].Name;

                LCode := LCode + ')';


                if (LType[1] = '*'){ or (LType = 'IObject')} then
                  LCode := LCode + ')';
                LCode := LCode + #13#10;
                LCode := LCode + '}'#13#10;
                LFileGoVcl.Add(LCode);

                AddExport(LOrgInstName, LMName);
              end;
            end;

            if LIdxP.IsWritable then
            begin
              LMName := 'Set' + FixPropName(LIdxP.Name);
              LM := LIdxP.WriteMethod;
			  
                if FilterXPropRW(LOrgInstName, LIdxP.Name, True) then
                   Continue;

                LTemp1 := '';
                LTemp2 := '';
                if Length(LM.GetParameters)>=3 then
                begin
                  LTemp1 := LM.GetParameters[1].Name;
                  LTemp2:= DTypeConvert(LM.GetParameters[1].ParamType);
                end;

                if Length(LM.GetParameters) >= 3 then
                begin
                  LTempStr := Format('%s: %s; %s: %s; AValue: %s',
                     [LM.GetParameters[0].Name, LM.GetParameters[0].ParamType.Name,
                      LM.GetParameters[1].Name, LM.GetParameters[1].ParamType.Name,

                     DTypeConvert(LIdxP.PropertyType)]);
                end else
                  LTempStr := Format('%s: %s; AValue: %s',
                     [LM.GetParameters[0].Name, LM.GetParameters[0].ParamType.Name, DTypeConvert(LIdxP.PropertyType)]);


//                if TypeIsDateTime(LIdxP.PropertyType) then
//                   LTempStr := Format('%s: %s; AValue: %s', [LM.GetParameters[0].Name, LM.GetParameters[0].ParamType.Name, DTypeConvert(LIdxP.PropertyType)])
//                else
                if TypeIsRecOrFloat(LIdxP.PropertyType) {and not TypeIsDateTime(LIdxP.PropertyType)} then
                begin
                  LIncFile.Add('//PARAMS:2=nonPtr');
                  LNeedImport := True;
                  if Length(LM.GetParameters) >= 3 then
                  begin
                    LTempStr := Format('%s: %s; %s: %s; var AValue: %s',
                     [LM.GetParameters[0].Name, LM.GetParameters[0].ParamType.Name,
                      LM.GetParameters[1].Name, LM.GetParameters[1].ParamType.Name,
                     DTypeConvert(LIdxP.PropertyType)]);
                  end else
                    LTempStr := Format('%s: %s; var AValue: %s',
                      [LM.GetParameters[0].Name, LM.GetParameters[0].ParamType.Name, DTypeConvert(LIdxP.PropertyType)]);
                end;
                LIncFile.Add(GetDelphiMethodCode(LIdxP.Name, LOrgInstName, '', LTempStr,
                   IfThen(TypeIsDateTime(LIdxP.PropertyType), 'UnixToTime(AValue)', 'AValue')
                   , False, False, True, True,
                  // 为记录或者浮点，但不为时间类型
                  TypeIsRecOrFloat(LIdxP.PropertyType){ and not TypeIsDateTime(LIdxP.PropertyType)},

                  True,
                  // index1
                  LM.GetParameters[0].Name, DTypeConvert(LM.GetParameters[0].ParamType),
                  // index2
                   LTemp1, LTemp2
                   ));

                LCode := 'func ' + GetNewMethod(LOrgInstName, LMName, False) + '(obj uintptr, '

                // 参数1
                + LM.GetParameters[0].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[0].ParamType) + ', ';

                // 参数2
                if Length(LM.GetParameters) >= 3 then
                begin
                  LCode := LCode + LM.GetParameters[1].Name + ' ' + DelphiParamTypeToGoType(LM.GetParameters[1].ParamType);
                  LCode := LCode +  ', value ' + DelphiParamTypeToGoType(LIdxP.PropertyType);
                end else
                  LCode  := LCode + 'value ' + DelphiParamTypeToGoType(LIdxP.PropertyType);

                // 结束
                LCode := LCode + ')' + ' {'#13#10;

                if TypeIsDateTime(LIdxP.PropertyType) then
                   LCode := LCode + '    tVal := value.Unix()'#13#10;

                LNameTemp := AddToGlobalDllImport(LWithoutTInstName + '_' + LMName);
//                LCode := LCode + '    syscallN(' + LNameTemp + ').Call(obj, ';
                LCode := LCode + '    syscallN(' + LNameTemp + ', obj, ';
//                AddToGlobalDllImport(LNameTemp);
                // 第一个参数
                LType := DelphiParamTypeToGoType(LM.GetParameters[0].ParamType);
                if LType.Equals('string') then
                   LCode := LCode  + 'PascalStr(' + LM.GetParameters[0].Name + '), '
                else if LType <> 'uintptr' then
                   LCode := LCode + 'uintptr(' + LM.GetParameters[0].Name + '), '
                else LCode := LCode + LType;


                if Length(LM.GetParameters) >= 3 then
                begin

                  // 第二个参数
                  LType := DelphiParamTypeToGoType(LM.GetParameters[1].ParamType);
                  if LType <> 'uintptr' then
                  begin
                    if LType = 'string' then
                       LCode := LCode + 'PascalStr(' + LM.GetParameters[1].Name + ')'
                    else if LType = 'bool' then
                       LCode := LCode + 'PascalBool(' + LM.GetParameters[1].Name + ')'
                    else if TypeIsDateTime(LM.GetParameters[1].ParamType) then
                       LCode := LCode + 'uintptr(' + LM.GetParameters[1].Name + '.Unix())'
                    else if TypeIsRecOrFloat(LM.GetParameters[1].ParamType) then
                       LCode := LCode + 'uintptr(unsafe.Pointer(&' + LM.GetParameters[1].Name + '))'
                    else
                      LCode := LCode + 'uintptr(' + LM.GetParameters[1].Name + ')';
                  end else
                    LCode := LCode + '' + LM.GetParameters[1].Name + '';

                  // 第三个参数

                  LCode := LCode + ', ';

                  LType := DelphiParamTypeToGoType(LIdxP.PropertyType);
                  if LType <> 'uintptr' then
                  begin
                    if LType = 'string' then
                       LCode := LCode + 'PascalStr(value)'
                    else if LType = 'bool' then
                       LCode := LCode + 'PascalBool(value)'
                    else if TypeIsDateTime(LIdxP.PropertyType) then
                       LCode := LCode + 'uintptr(unsafe.Pointer(&tVal))'
                    else if TypeIsRecOrFloat(LIdxP.PropertyType) then
                       LCode := LCode + 'uintptr(unsafe.Pointer(&value))'
                    else
                      LCode := LCode + 'uintptr(value)';
                  end else
                    LCode := LCode + 'value';


                end else
                begin
                  // 第二个参数
                  LType := DelphiParamTypeToGoType(LIdxP.PropertyType);
                  if LType <> 'uintptr' then
                  begin
                    if LType = 'string' then
                       LCode := LCode + 'PascalStr(value)'
                    else if LType = 'bool' then
                       LCode := LCode + 'PascalBool(value)'
                    else if TypeIsDateTime(LIdxP.PropertyType) then
                       LCode := LCode + 'uintptr(unsafe.Pointer(&tVal))'
                    else if TypeIsRecOrFloat(LIdxP.PropertyType) then
                       LCode := LCode + 'uintptr(unsafe.Pointer(&value))'
                    else
                      LCode := LCode + 'uintptr(value)';
                  end else
                    LCode := LCode + 'value';

                end;


                LCode := LCode + ')'#13#10;;

                LCode := LCode + '}'#13#10;
                LFileGodll.Add(LCode);


                // vcl
                LCode := '';//'// ' + LIdxP.Name + #13#10;
                LCode := LCode + GetComment(LOrgInstName, LIdxP.Name, True, True);
                LCode := LCode + 'func (' + LFChar + ' *' + LOrgInstName + ') ' + LMName + '(' + LM.GetParameters[0].Name + ' ' +

                  DelphiParamTypeToGoType(LM.GetParameters[0].ParamType)  +  ', ';
                // 参数1



                 if Length(LM.GetParameters) >= 3 then
                 begin
                   LType := DelphiParamTypeToGoType(LM.GetParameters[1].ParamType, False, True);
                   LCode := LCode + LM.GetParameters[1].Name  + ' ' + LType;


                   LType := DelphiParamTypeToGoType(LM.GetParameters[2].ParamType, False, True);
                   LCode := LCode +  ', value ' + LType;
                 end else
                 begin
                   LType := DelphiParamTypeToGoType(LIdxP.PropertyType, False, True);
                   LCode := LCode + 'value ' + LType;
                 end;
                LCode := LCode + ') {'#13#10;
                // 这里加异常处理代码
                LCode := LCode + ExceptionCode;

                LCode := LCode + '    ';

                LCode := LCode +  GetNewMethod(LOrgInstName, LMName, False) + '(' + LFChar + '._instance(), ' + LM.GetParameters[0].Name + ', ';

                if Length(LM.GetParameters) >= 3 then
                begin
                  LCode := LCode + LM.GetParameters[1].Name;
                  if IsObject(LIdxP.PropertyType) then
                    LCode := LCode + ', CheckPtr(value)'
                  else
                    LCode := LCode + ', value'// + LM.GetParameters[2].Name;
                end
                else
                begin

                  if IsObject(LIdxP.PropertyType) then
                    LCode := LCode + 'CheckPtr(value)'
                  else
                    LCode := LCode + 'value';

                end;
                LCode := LCode + ')'#13#10;
                LCode := LCode + '}'#13#10;
                LFileGoVcl.Add(LCode);

              AddGoImport(LFirstCharLowerCaseName, LMName, LWithoutTInstName);
              //AGoHeaderFile.Add('    ' + LFirstCharLowerCaseName + '_' + LMName + ' = libvcl.NewProc("' + LWithoutTInstName + '_' + LMName + '")');
              AddExport(LOrgInstName, LMName);
            end;
          end;
        end;

        // class信息的
        // todo:这里改变了
        //LExports.Add(Format('  %s_StaticClassType,', [LWithoutTInstName]));
        AddExport(LOrgInstName, 'StaticClassType');
        AddGoImport(LFirstCharLowerCaseName, 'StaticClassType', LWithoutTInstName);

        //  AGoHeaderFile.Add(Format('    %s_%s = libvcl.NewProc("%s_%s")', [AClassName, AMName, InstName, AMName]));
        LFileGodll.Add(Format('func %s_StaticClassType() TClass {', [LWithoutTInstName]));
        LNameTemp := AddToGlobalDllImport(Format('%s_StaticClassType', [LWithoutTInstName]));
//        LFileGodll.Add('    r, _, _:= syscallN(' + LNameTemp + ').Call()');
        LFileGodll.Add('    return TClass(syscallN(' + LNameTemp + '))');
//        LFileGodll.Add('    return TClass(r)');
        LFileGodll.Add('}');
//        AddToGlobalDllImport(LNameTemp);

        // 兼容Delphi的边距调整功能
//        if AClass.InheritsFrom(TControl) then
//        begin
//          LExports.Add(Format('  %s_GetMargins,', [LWithoutTInstName]));
//          LExports.Add(Format('  %s_SetMargins,', [LWithoutTInstName]));
//
//          // 添加Delphi的方法
//          LIncFile.Add(Format('function %s_GetMargins(AObj: %s): TControlBorderSpacing; extdecl;', [LWithoutTInstName, LOrgInstName]));
//          LIncFile.Add('begin');
//          LIncFile.Add('  Result := AObj.BorderSpacing;');
//          LIncFile.Add('end;');
//          LIncFile.Add('');
//
//
//          // 添加Delphi的方法
//          LIncFile.Add(Format('procedure %s_SetMargins(AObj: %s; AValue: TControlBorderSpacing); extdecl;', [LWithoutTInstName, LOrgInstName]));
//          LIncFile.Add('begin');
//          LIncFile.Add('  AObj.BorderSpacing := AValue;');
//          LIncFile.Add('end;');
//          LIncFile.Add('');
//        end;

        //AGoHeaderFile.Add(Format('    %s_%s = libvcl.NewProc("%s_%s")', [AClassName, AMName, InstName, AMName]));
        // 添加Delphi的方法
        LIncFile.Add(Format('function %s_StaticClassType: TClass; extdecl;', [LWithoutTInstName]));
        LIncFile.Add('begin');
        LIncFile.Add('  Result := ' + LOrgInstName + ';');
        LIncFile.Add('end;');

      finally
        LTempDict.Free;
      end;
    finally
      LC.Free;
    end;
    AGoHeaderFile.Add('');

    // todo:这里已经改变不再在inc文件中产生导出
    LIncFile.Add('');
    if LExports.Count > 0 then
    begin
      LIncFile.Add('exports');
      LExports[LExports.Count-1] := LExports[LExports.Count-1].Replace(',', ';', []);
      LIncFile.AddStrings(LExports);
    end;
    LIncFile.Add('');

    if AGenDelphiInc then
      SaveToUTF8(LIncFile, APath + LIncFileName);


    if LNeedImport then
    begin
      // 10 line， 倒过来插入
//      LFileGodll.Insert(10, '');
//      LFileGodll.Insert(10, ')');
//      LFileGodll.Insert(10, '    "unsafe"');
//      LFileGodll.Insert(10, 'import (');
    end;

    SaveToUTF8(LFileGoVcl, GGoVclPath + LWithoutTInstName.ToLower + '.go');

    //
    GGoSrcFile.AddStrings(LFileGodll);
    //SaveToUTF8(LFileGodll, GGoApiPath + LWithoutTInstName.ToLower + '.go');

    if AGenDelphiInc then
    begin
      LBaseClassName := Copy(LBaseClassName, 2, Length(LBaseClassName)-1);

      ADelphiUnitFile.Add(Format('{$I %s}  //BASECLASS:T%s', [LIncFileName, LBaseClassName]));
    end;
  finally
    LFileGoVcl.Free;
    LFileGodll.Free;
    LExports.Free;
    LIncFile.Free;
  end;
  Sleep(1);
end;


procedure MakeVclObjectUnit;
var
  LGoHeaderFile, LDelphiUnitFile, LExportTplStr, LDllImportAuto, LDllImportDef, LDllImportTable: TStringList;
  LPath: string;
  LExportI: Integer;
  LExportTplText: string;
//  LIncFilesArr: TArray<string>;

  procedure AddDefaultDelphiUnitFileHeader;
  var
    LUses: TStringList;
    I: Integer;
    s: string;
  begin

    AddHeaderInfo(LDelphiUnitFile, False);

    LDelphiUnitFile.Add('library liblcl;');
    LDelphiUnitFile.Add('');
    LDelphiUnitFile.Add('//{$mode objfpc}{$H+}');
    LDelphiUnitFile.Add('{$mode delphi}');
    LDelphiUnitFile.Add('');
	  LDelphiUnitFile.Add('{$ifndef windows}');
    LDelphiUnitFile.Add('  {$define UseCThreads}');
    LDelphiUnitFile.Add('{$endif}');
    LDelphiUnitFile.Add('');
    LUses := TStringList.Create;
    try
      if FileExists('uses.txt') then
      begin
        LUses.LoadFromFile('uses.txt');
        if LUses.Count > 0 then
          LDelphiUnitFile.Add('uses');
        for I := 0 to LUses.Count - 1 do
        begin
          s := LUses[I].Trim;
          if s <> '' then
          begin
            if S[1] = '{' then
              LDelphiUnitFile.Add(s)
            else
            begin
              if I >= LUses.Count - 1 then
                LDelphiUnitFile.Add('  ' + s + ';')
              else
                LDelphiUnitFile.Add('  ' + s + ',');
            end;
          end;
        end;
        LDelphiUnitFile.Add('');
      end;
    finally
      LUses.Free;
    end;
    LDelphiUnitFile.Add('{$IFDEF WINDOWS}');
    LDelphiUnitFile.Add('  {$R *.res}');
    LDelphiUnitFile.Add('{$ENDIF}');
    LDelphiUnitFile.Add('');
    LDelphiUnitFile.Add('');
    LDelphiUnitFile.Add('');
	  LDelphiUnitFile.Add('{$I ExtDecl.inc}');
//    LDelphiUnitFile.Add('{$I LazarusExtDef.inc}');
    LDelphiUnitFile.Add('{$I LazarusDef.inc}');
    LDelphiUnitFile.Add('');
//    LDelphiUnitFile.Add('{$I MyLCL_Margins.inc}');
//	LDelphiUnitFile.Add('{$I LazarusResForm.inc}');
//    LDelphiUnitFile.Add('{$I IniFile.inc}');
    LDelphiUnitFile.Add('');
  end;

  // 添加Go的默认，从cdef.txt文件
  procedure AddDefaultGoHeader;
  var
    LStr: TStringList;
  begin
    AddHeaderInfo(LGoHeaderFile, True);
    LStr := TStringList.Create;
    try
      LStr.LoadFromFile('godef.txt');
      LGoHeaderFile.AddStrings(LStr);
    finally
      LStr.Free;
    end;
  end;

  procedure RepaceAndSaveExportPas(ATemplateStr: string; AIndex, ACount: Integer);
  var
    LIncFiles: TStringList;
    LStr: string;
    LCount, I, LModCount: Integer;
  begin
    //LDelphiUnitFile
    LCount := LDelphiUnitFile.Count div ACount;
    LStr := '';
    for I := (AIndex - 1) * LCount to AIndex * LCount - 1 do
      LStr := LStr + LDelphiUnitFile[I] + sLineBreak;


    LModCount := LDelphiUnitFile.Count mod ACount;
    if (AIndex = ACount) and (LModCount <> 0) then
    begin
      //Writeln('LDelphiUnitFile.Count mod ACount:' , LModCount, '  ',);
      for I :=  AIndex * LCount to LDelphiUnitFile.Count - 1 do
        LStr := LStr + LDelphiUnitFile[I] + sLineBreak;
        //Writeln('I=', I);
    end;


    LIncFiles := TStringList.Create;
    try
      LIncFiles.Text := ATemplateStr.
      Replace('{%number%}', IntToStr(AIndex)).
      Replace('{%incfiles%}', LStr);
      SaveToUTF8(LIncFiles, LPath + Format('uexport%d.pas', [AIndex]));
    finally
      LIncFiles.Free;
    end;
  end;


  procedure AddDllImportTable(AList: TStrings; AVarName: string);
  begin
//    AList.Sorted := False;
    AddHeaderInfo(AList, True);
    AList.Add('');
    AList.Add('package dllimports');
    AList.Add('');
    AList.Add('var ' + AVarName + ' = []importTable{');
  end;


var
  LRootPath, LS: string;
  LIndex, LCount: Integer;
begin
  LRootPath := GetEnvironmentVariable('GOPATH') + '\src\github.com\ying32\govcl';
  if not DirectoryExists(LRootPath) then
  begin
    Writeln('GOPATH中不存在govcl项目');
    Readln;
    Exit;
  end;

  LGoHeaderFile := TStringList.Create;
  LDelphiUnitFile := TStringList.Create;
  GGoSrcFile := TStringList.Create;
  GIsAsFile := TStringList.Create;
  LExportTplStr := TStringList.Create;
  GExportTable := TStringList.Create;
  GDllImportTable := TStringList.Create;
  LDllImportAuto := TStringList.Create;
  LDllImportDef := TStringList.Create;
  LDllImportTable := TStringList.Create;
  try
    // vcl.dpr
    LPath := ExtractFilePath(ParamStr(0)) + '..\..\src\';
    if not TDirectory.Exists(LPath) then
      TDirectory.CreateDirectory(LPath);

    //
    GGoApiPath := LRootPath + '\vcl\api\';
    if not TDirectory.Exists(GGoApiPath) then
      TDirectory.CreateDirectory(GGoApiPath);

    GGoVclPath := LRootPath + '\vcl\';
    if not TDirectory.Exists(GGoVclPath) then
      TDirectory.CreateDirectory(GGoVclPath);


    AddHeaderInfo(GGoSrcFile, True);
    GGoSrcFile.Add('');
    GGoSrcFile.Add('package api');
    GGoSrcFile.Add('');
    GGoSrcFile.Add('import (');
    GGoSrcFile.Add('    "unsafe"');
    GGoSrcFile.Add('    "time"');
    GGoSrcFile.Add('    . "github.com/ying32/govcl/vcl/types"');
    GGoSrcFile.Add(')');
    GGoSrcFile.Add('');

    // 自动导入表
    AddDllImportTable(LDllImportAuto, 'dllImports');





    // Is As 操作符的单元
    AddHeaderInfo(GIsAsFile, True);
    GIsAsFile.Add('');
    GIsAsFile.Add('package vcl');
    GIsAsFile.Add('');
    GIsAsFile.Add('import . "github.com/ying32/govcl/vcl/api"');
    GIsAsFile.Add('');


    AddDefaultGoHeader;
// 这里写到单独文件里去
    LGoHeaderFile.Add('var (');
//    LGoHeaderFile.Add('vcllib = syscall.NewLazyDLL("vcllib.dll")');
//    LGoHeaderFile.Add('');

    // 不再生成liblcl工程文件了
    //AddDefaultDelphiUnitFileHeader;

    // 加载导出模板工程
    LExportTplStr.LoadFromFile('exporttpl.txt');
    LExportTplText := LExportTplStr.Text;

    // TApplication
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TApplication);
    // TForm  不再继续动太生成，因为要有些东西修改
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TForm, True, False, True);
//    LDelphiUnitFile.Add('{$I Form.inc}');
    // TButton
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TButton);
    // TEdit
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TEdit);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMainMenu);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPopupMenu);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMemo);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCheckBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TRadioButton);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGroupBox);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TLabel);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TComboBox);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPanel);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TImage);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TLinkLabel);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TSpeedButton);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TSplitter);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TRadioGroup);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TStaticText);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TColorBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TColorListBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TTrayIcon);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TBalloonHint);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TCategoryPanelGroup);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TCategoryPanel);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TOpenDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TSaveDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TColorDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TFontDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TPrintDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TOpenPictureDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TSavePictureDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TSelectDirectoryDialog);

//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TSaveTextFileDialog);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TOpenTextFileDialog);
//    Timer1: TTimer;
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TRichEdit);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TTrackBar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TImageList);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TUpDown);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TProgressBar);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,THotKey);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TDateTimePicker);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TMonthCalendar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TListView);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TTreeView);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TStatusBar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TToolBar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath,TBitBtn);




    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TIcon, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TBitmap, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMemoryStream, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFont, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TStrings, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TStringList, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TBrush, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPen, False);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMenuItem);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListGroups);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPicture, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListColumns, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListItems, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTreeNodes, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListItem, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTreeNode, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPageControl, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTabSheet, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TControl, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TWinControl, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TScreen, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMouse, False);

//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListGroup, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TListColumn, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCollectionItem, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TStatusPanels, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TStatusPanel, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TSpinEdit, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFloatSpinEdit, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TDirectoryEdit, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TColorButton, True);

//    LDelphiUnitFile.Add('{$IF Defined(LCLcocoa) or Defined(LCLgtk2) or Defined(LCLgtk3) or Defined(WINDOWS)}');
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMiniWebview, True);
//    LDelphiUnitFile.Add('{$ENDIF}');

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCanvas, False);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TObject, False);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGraphic, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPngImage, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TJPEGImage, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGIFImage, False);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGIFFrame, True);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TActionList, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TAction, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TToolButton, True);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGIFImageList, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TIniFile, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TRegistry, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TClipboard, False);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, Vcl.Forms.TMonitor, False);
    //MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TEncoding, False);

//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMargins, True, True, False);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPadding, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPaintBox, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTimer, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TList, False);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGraphic, False);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TComponent, True);

  //  MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMonthCalColors, True);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TParaAttributes, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTextAttributes, False, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TIconOptions, False, True);


    // 不自动生成了
    //MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TWebBrowser);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, Exception, False, True);


    // 不自动生成了
    //MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TWebBrowser);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TScrollBar);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TButtonedEdit);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TEditButton);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCategoryButtons);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TButtonGroup);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCustomHint);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TMaskEdit);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TShape);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TBevel);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TScrollBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCheckListBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGauge);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TImageButton);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFindDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TReplaceDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPrinterSetupDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPageSetupDialog);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TDragObject, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TDragDockObject, True);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TStringGrid);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TDrawGrid);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TValueListEditor);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, THeaderControl);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, THeaderSection);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, THeaderSections);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TLabeledEdit);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TBoundLabel);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFlowPanel);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFlowPanelControlList, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFlowPanelControl, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCoolBar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCoolBands);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCoolBand);

     MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCollection);

     MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TPrinter, False);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialog);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialogButtons, False, True);
//    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialogProgressBar);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialogButtonItem);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialogRadioButtonItem);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TTaskDialogBaseButtonItem);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TComboBoxEx);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TComboExItems, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TComboExItem, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TFrame);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TControlScrollBar, False, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TSizeConstraints, False, True);


    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TXButton);

    // 新的东西
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TAnchorSide, True, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TControlBorderSpacing, True, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TControlChildSizing, True, True);

    // lcl组件
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCheckGroup);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TToggleBox);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TCheckComboBox);

    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGridColumnTitle, True, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGridColumn, True, True);
    MakeObjIncFile(LGoHeaderFile, LDelphiUnitFile, LPath, TGridColumns, True, True);

//    LDelphiUnitFile.Add('{$I WebBrowser.inc}');
//    LDelphiUnitFile.Add('');
//    LDelphiUnitFile.Add('// 用户自己定义的组件');
//    LDelphiUnitFile.Add('{$I UserDefineComponents.inc}');
//    LDelphiUnitFile.Add('');
//    LDelphiUnitFile.Add('');
//    LDelphiUnitFile.Add('initialization');
//    LDelphiUnitFile.Add('  gClickEventDict := TDictionary<TObject, Pointer>.Create;');
//    LDelphiUnitFile.Add('finalization');
//    LDelphiUnitFile.Add('  gClickEventDict.Free;');
//    LDelphiUnitFile.Add('begin');
//	  LDelphiUnitFile.Add('  InitLazarusDef;');
//    LDelphiUnitFile.Add('end.');

    LGoHeaderFile.Add(')');
    SaveToUTF8(GGoSrcFile, GGoApiPath + 'importFuncsAuto.go');


    // 自动导入表
    LDllImportAuto.AddStrings(GDllImportTable);
    LDllImportAuto.Add('}');
    SaveToUTF8(LDllImportAuto, GGoApiPath + 'dllimports\' + 'dllimports.go');
    // 手动导出的
    LDllImportTable.LoadFromFile('dllimportdefs.txt');

        // 手动导出的
    AddDllImportTable(LDllImportDef, 'dllImportDefs');
    LCount := 0;
    for LIndex := 0 to LDllImportTable.Count - 1 do
    begin
      LS := LDllImportTable[LIndex].Trim;
      if LS.IsEmpty then
        Continue;
      if LS.StartsWith('//') then
        Continue;
      LDllImportDef.Add(Format('    /*%d*/ {"%s", 0},', [LCount, LS]));
      Inc(LCount);
    end;
    LDllImportDef.Add('}');
    LDllImportDef.Add('');
    LDllImportDef.Add('');
    LDllImportDef.Add('const (');
    LCount := 0;
    for LIndex := 0 to LDllImportTable.Count - 1 do
    begin
      LS := LDllImportTable[LIndex].Trim;
      if LS.IsEmpty then
        Continue;
      if LS.StartsWith('//') then
        Continue;
      LDllImportDef.Add(Format('    %s = %d', [LS.ToUpper, LCount]));
      Inc(LCount);
    end;

    LDllImportDef.Add(')');
    SaveToUTF8(LDllImportDef, GGoApiPath + 'dllimports\' + 'dllimportdefs.go');



//    SaveToUTF8(LGoHeaderFile, GGoApiPath + 'importAuto.go');

    // 这里不再保存了
    //SaveToUTF8(LDelphiUnitFile, LPath+ 'liblcl.lpr');

    SaveToUTF8(GIsAsFile, GGoVclPath + 'typeoperator.go');

    // 分割单元，目前2个足够用了
//    SetLength(LIncFilesArr, 2);
//    for LExportI := 0 to LDelphiUnitFile.Count - 1 do
//    begin
//
//    end;

//      Writeln('LDelphiUnitFile.Count=', LDelphiUnitFile.Count);
      for LExportI := 1 to 4 do
         RepaceAndSaveExportPas(LExportTplText, LExportI, 4);

    // 通过模板输出导出单元
    // 目前就只有2个
//    for LExportI := 1 to 2 do
//    begin
//      LExportTplStr.Clear;
//      case LExportI of
//        1:
//          begin
//            LExportTplStr.Text := LExportTplText.
//              Replace('{%number%}', IntToStr(LExportI)).
//              Replace('{%incfiles%}', Copy(LDelphiUnitFile.Text, 1, Pos('{$I MyLCL_CoolBar.inc}', LDelphiUnitFile.Text)-1));//.
////              Replace('{%exports%}', Copy(GExportTable.Text, 1, Pos('AddToExportTable(''CoolBar_', GExportTable.Text)-1));
//            SaveToUTF8(LExportTplStr, LPath + Format('uexport%d.pas', [LExportI]));
//          end;
//        2:
//          begin
//            LExportTplStr.Text := LExportTplText.
//              Replace('{%number%}', IntToStr(LExportI)).
//              Replace('{%incfiles%}', Copy(LDelphiUnitFile.Text, Pos('{$I MyLCL_CoolBar.inc}', LDelphiUnitFile.Text), Length(LDelphiUnitFile.Text)));//.
////              Replace('{%exports%}',  Copy(GExportTable.Text, Pos('AddToExportTable(''CoolBar_', GExportTable.Text), Length(GExportTable.Text)));
//
//            SaveToUTF8(LExportTplStr, LPath + Format('uexport%d.pas', [LExportI]));
//          end;
//      end;
//    end;

    // 保存导出表
    //SaveToUTF8(GExportTable, LPath + 'GlobalExports.inc');

  finally
    LDllImportDef.Free;
    LDllImportTable.Free;
    LDllImportAuto.Free;
    GDllImportTable.Free;
    GExportTable.Free;
    LExportTplStr.Free;
    GIsAsFile.Free;
    GGoSrcFile.Free;
    LDelphiUnitFile.Free;
    LGoHeaderFile.Free;
  end;
end;


procedure InitGFilterTable;
  procedure Add(s: string);
  begin
    if s = '' then
      Exit;
    if not GFilterTable.ContainsKey(s) then
      GFilterTable.Add(s, '');
  end;
var
  LFilterFile: TStringList;
  S: string;
begin
  LFilterFile := TStringList.Create;
  try
    LFilterFile.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'filter.txt');
    for S in LFilterFile do
      Add(S.Trim);
  finally
    LFilterFile.Free;
  end;
end;

procedure InitGEventsTable;
  procedure Add(s: string);
  begin
    if s = '' then
      Exit;
    if not GEvents.ContainsKey(s) then
      GEvents.Add(s, '');
  end;
var
  LFilterFile: TStringList;
  S: string;
begin
  LFilterFile := TStringList.Create;
  try
    LFilterFile.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'events.txt');
    for S in LFilterFile do
      Add(S.Trim);
  finally
    LFilterFile.Free;
  end;
end;

procedure InitGAddTypePkgTable;
  procedure Add(s: string);
  begin
    if s = '' then
      Exit;
    if not GAddTypePkgs.ContainsKey(s) then
      GAddTypePkgs.Add(s, '');
  end;
var
  LFilterFile: TStringList;
  S: string;
begin
  LFilterFile := TStringList.Create;
  try
    LFilterFile.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'typepkg.txt');
    for S in LFilterFile do
      Add(S.Trim);
  finally
    LFilterFile.Free;
  end;
end;

procedure InitGAddUnsafePkgTable;
  procedure Add(s: string);
  begin
    if s = '' then
      Exit;
    if not GAddUnsafePkgs.ContainsKey(s) then
      GAddUnsafePkgs.Add(s, '');
  end;
var
  LFilterFile: TStringList;
  S: string;
begin
  LFilterFile := TStringList.Create;
  try
    LFilterFile.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'unsafepkg.txt');
    for S in LFilterFile do
      Add(S.Trim);
  finally
    LFilterFile.Free;
  end;
end;

procedure InitGCommentInfo;
  procedure Add(AInst, AMName, ACN, AEN: string);
  var
    LItem: TCommentItem;
  begin
    if (AInst = '') or (AMName = '') then
      Exit;
    if AInst = '#' then
      AInst := '';
    if not GCommentInfo.ContainsKey(AInst+AMName) then
    begin
      LItem.CN := ACN;
      LItem.EN := AEN;
      GCommentInfo.Add(AInst+AMName, LItem);
    end;
  end;
var
  LFilterFile: TStringList;
  S: string;
  I: Integer;
  LArr: TArray<string>;
begin
  LFilterFile := TStringList.Create;
  try
    LFilterFile.LoadFromFile(ExtractFilePath(ParamStr(0)) + 'comments.txt');
    for I := 0 to LFilterFile.Count - 1 do
    begin
      if I = 0  then
        Continue;
      S := Trim(LFilterFile[I]);
      if S  = '' then
        Continue;

      LArr := S.Split(['|']);
      if Length(LArr) < 3 then
        Continue;
//      LArr[0] := LArr[0].Trim;
//      LArr[1] := LArr[1].Trim;
//      LArr[2] := LArr[2].Trim;
//      LArr[3] := LArr[3].Trim;
      case Length(LArr) of
        3: Add(LArr[0].Trim, LArr[1].Trim, LArr[2].Trim, '');
        4: Add(LArr[0].Trim, LArr[1].Trim, LArr[2].Trim, LArr[3].Trim);
      end;
    end;
  finally
    LFilterFile.Free;
  end;
end;


function GetCType(AName: string): string;
begin
  if not GCTypeTable.TryGetValue(AName, Result) then
   Result := AName;
end;

function CanConv(AName: string): Boolean;
begin
  Result := GFilterTable.ContainsKey(AName) or GEvents.ContainsKey(AName);
end;

begin
  try
    GFilterTable := TDictionary<string, string>.Create;
    GCTypeTable := TDictionary<string, string>.Create;
    GEvents :=  TDictionary<string, string>.Create;
    GAddTypePkgs := TDictionary<string, string>.Create;
    GAddUnsafePkgs := TDictionary<string, string>.Create;
    GCommentInfo := TDictionary<string, TCommentItem>.Create;
    try
      InitGFilterTable;
      InitGEventsTable;
      InitGAddTypePkgTable;
      InitGAddUnsafePkgTable;
      InitGCommentInfo;
      MakeVclObjectUnit;
    finally
      GCommentInfo.Free;
      GAddUnsafePkgs.Free;
      GAddTypePkgs.Free;
      GEvents.Free;
      GCTypeTable.Free;
      GFilterTable.Free;
    end;
  except
    on E: Exception do
      Writeln(E.ClassName, ': ', E.Message);
  end;
  Writeln('');
  Readln;
end.
