/*
    The code is automatically generated by the genBind tool.
    Author: ying32
    https://github.com/ying32
*/
##
#![allow(non_upper_case_globals)]
#![allow(non_snake_case)]
#![allow(dead_code)]
#![allow(unused_unsafe)]
##
use lclapi::*;
use types::*;
use fns::ToRustString;
##
use std::borrow::Cow;
use std::ffi::CString;
use std::mem::{transmute};
##

{{/*IObject IComponent IControl IWinControl只是用来让编译器知道这几个的关系的*/}}
pub trait IObject { fn Instance(&self) -> usize; }
pub trait IComponent: IObject {}
pub trait IControl: IComponent {}
pub trait IWinControl: IControl {}
pub trait IStrings: IObject {}
pub trait IStream: IObject {}
pub trait IForm: IWinControl {}
pub trait IGraphic: IObject {}
 
##
pub trait IApplication {
    fn run(&self);
}
##


##
{{/* usize是指向实例对象的指针，bool是标识能自动drop的，一般只有通过new的才可以 */}}
/* 先定义所有的类 */
{{range $el := .Objects}}
pub struct {{$el.ClassName}}(usize, bool);
{{end}}

{{/*模板定义*/}}
{{define "getlastPs"}}{{if .LastIsReturn}} -> {{$ps := lastParam .Params}}{{covType $ps.Type}}{{end}}{{end}}

{{define "memoryStreamMethods"}}
##
	  pub fn Write<T>(&self, buffer: *const T, count: i32) -> i32  {
        return method_Call_1!(MemoryStream_Write, self.0, buffer as usize, count);
      }
##
      pub fn Read<T>(&self, buffer: *const T, count: i32) -> i32  {
        return method_Call_1!(MemoryStream_Read, self.0, buffer as usize, count);
      }
##
      pub fn WriteByte(&self, value: i8) -> i32 {
          return self.Write(&value as *const i8, 1);
      }
##
      pub fn ReadByte(&self) -> i8 {
          let value: i8 = 0;
          self.Read(&value as *const i8, 1);
          return value;
      }
##
      pub fn WriteArray<T>(&self, data: &[T]) -> i32 {
          if data.len() == 0 {
              return 0
          }
          return self.Write(data.as_ptr(), (std::mem::size_of::<T>() * data.len()) as i32);
      }
##
      pub fn ReadArray<T>(&self, data: &[T]) -> i32 {
        if data.len() == 0 {
            return 0
        }
        return self.Read(data.as_ptr(), (std::mem::size_of::<T>() * data.len()) as i32);
      }
{{end}}

/* 开始实现接口 */
{{range $el := .Objects}}
{{$className := $el.ClassName}}
{{$baseClass := $el.BaseClassName}}
{{$classN := rmObjectT $className}}
##
{{$buff := newBuffer}}


impl {{$className}} {
  {{range $mm := $el.Methods}}
      {{if eq $mm.RealName "Create"}}
          {{$buff.Clear}}
          {{/* TXXX::new  */}}

          {{$buff.Write "pub fn new("}}
          {{range $idx, $ps := $mm.Params}}
              {{if gt $idx 0}}
                  {{$buff.Write ", "}}
              {{end}}
              {{fLowCase $ps.Name|$buff.Write}}
              {{$buff.Write ": "}}
              {{if isObject $ps.Type}}
                  {{$buff.Write "&"}}
                  {{if isIntf $ps.Type}}
                      {{$buff.Write "dyn "}}
                  {{end}}
              {{end}}
              {{covType2 (getIntfName $ps.Type)|$buff.Write}}
          {{end}}
          {{$buff.Write ")"}}
          {{$buff.Writeln " -> Self {"}}

          {{$buff.Write "        "}}
          {{$buff.Write "method_Create!(" $className ", " $classN "_Create" ", "}}
		  {{range $idx, $ps := $mm.Params}}
		      {{if gt $idx 0}}
		          {{$buff.Write ", "}}
		      {{end}}
		      {{if eq $ps.Type "string"}}
		          {{$buff.Write "to_CString!(" (fLowCase $ps.Name) ")"}}
		      {{else}}
		          {{fLowCase $ps.Name|$buff.Write}}
		      {{end}}
		      {{if isObject $ps.Type}}
		          {{$buff.Write ".Instance()"}}
		      {{end}}
		  {{end}}
		  {{$buff.Writeln ");"}}

      {{$buff.ToStr}}
      }

##
      {{else if eq $mm.RealName "Free"}}
	  impl_Free_method!({{$classN}}_Free);
##
      {{else if eq $mm.RealName "CreateForm"}}
      pub fn CreateForm(&self) -> TForm  {
	      return method_Call_2!(TForm, Application_CreateForm, self.0, false);
      }
##
      {{else}}
          {{if not $mm.IsStatic}}
              {{if inStrArray $mm.Name "MemoryStream_Read" "MemoryStream_Write"}}

			  {{else}}

                  {{$isSetProp := $mm.IsSetter}}
                  {{$notProp := not $mm.IsProp}}
				  
                  {{$buff.Clear}}
                  {{$buff.Write "pub fn "}}
				  {{if and $mm.IsProp $mm.IsGetter}}
				      {{$buff.Write $mm.PropName}}
				  {{else}}
				      {{$buff.Write $mm.RealName}}
				  {{end}}
                  {{if eq $mm.Return "string"}}
                      {{$buff.Write "<'a>"}}
                  {{end}}
				  
				  {{if $mm.IsSetEvent}}
				      {{$buff.Write "<T,T2>"}}
				  {{end}}
                  {{$buff.Write "(&self"}}
				  {{if $mm.IsSetEvent}}
				      {{$buff.Write ", aSelfId: &T"}}
				  {{end}}

                  {{range $idx, $ps := $mm.Params}}
                      {{if canOutParam $mm $idx}}
                          {{if gt $idx 0}}
                              {{$buff.Write ", " (fLowCase $ps.Name) ": "}}
                              {{if isObject $ps.Type}}
                                  {{$buff.Write "&"}}
                                  {{if isIntf $ps.Type}}
                                      {{$buff.Write "dyn "}}
                                  {{end}}
                              {{end}}
                              {{if $ps.IsVar}}
                                  {{if ne $ps.Flag "nonPtr"}}
                                      {{$buff.Write "*mut "}}
                                  {{else}}
                                      {{if inStrArray $ps.Type "TRect" "TSize" "TPoint" "TGUID" "TGridRect" "TGridCoord"}}
                                           {{$buff.Write "&"}}
                                      {{end}}
                                  {{end}}
                              {{end}}
                              {{covType2 (getIntfName $ps.Type)|$buff.Write}}
							  {{if $mm.IsSetEvent}}
				                   {{$buff.Write "<T2>"}}
				              {{end}}
                          {{end}}
                      {{end}}
                  {{end}}

                  {{$buff.Write ")"}}
                  {{if not (isEmpty $mm.Return)}}
                      {{$buff.Write " -> "}}
                      {{if eq $mm.Return "string"}}
                          {{$buff.Write "Cow<'a, str>"}}
                      {{else}}
                          {{covType2 $mm.Return|$buff.Write}}
                      {{end}}
                  {{else}}
                      {{if $mm.LastIsReturn}}
                          {{$buff.Write " -> "}}
                          {{covType2 (lastParam $mm.Params).Type|$buff.Write}}
					  {{else}}
					      {{/*if $isSetProp*/}}
						      {{$buff.Write " -> &Self"}}
						  {{/*end*/}}
                      {{end}}
                  {{end}}
                  {{if $notProp}}
                      {{if isBaseMethod $el.ClassName $mm.RealName}}
                          {{$buff.Write " "}}
                      {{end}}
                  {{else}}
                      {{$buff.Write " "}}
                  {{end}}
                  {{$buff.Writeln " {"}}

                  {{/* ---------------- call func ---------------- */}}
                  {{$retIsObj := isObject $mm.Return}}
                  {{$retIsStr := eq $mm.Return "string"}}

                  {{if $mm.LastIsReturn}}
                      {{$lastP := lastParam $mm.Params}}
                      {{$buff.Write "          let mut result = "}}
                      {{if inStrArray $lastP.Type "TRect" "TSize" "TPoint" "TGUID" "TGridRect" "TGridCoord"}}
                          {{$buff.Write (covType2 $lastP.Type) "::empty()"}}
                      {{else}}
                          {{$buff.Write "0 as " (covType2 $lastP.Type)}}
                      {{end}}
                      {{$buff.Writeln ";"}}
                  {{end}}

                  {{/* 参数不需要指针的 */}}
                  {{range $idx, $ps := $mm.Params}}
                      {{if eq $ps.Flag "nonPtr"}}
                          {{$buff.Write "          let mut ps" $idx " = "}}
                          {{if inStrArray $ps.Type "TRect" "TSize" "TPoint" "TGUID" "TGridRect" "TGridCoord"}}
                              {{$buff.Write (fLowCase $ps.Name) ".clone()"}}
                          {{else}}
                              {{$buff.Write (fLowCase $ps.Name)}}
                          {{end}}
                          {{$buff.Writeln ";"}}
                      {{end}}
                  {{end}}

                  {{$buff.Write "          "}}
                  {{if not (isEmpty $mm.Return)}}
                      {{$buff.Write "return "}}
                  {{end}}
                  {{if $retIsStr}}
                      {{$buff.Write "ToRustString("}}
                  {{end}}
                  {{$buff.Write "method_Call_"}}
                  {{if $retIsObj}}
                      {{$buff.Write 2}}
                  {{else}}
                      {{$buff.Write 1}}
                  {{end}}
                  {{$buff.Write "!("}}
                  {{if $retIsObj}}
                      {{$buff.Write $mm.Return ", "}}
                  {{end}}
                  {{$buff.Write $mm.Name ", self.0"}}

		          {{range $idx, $ps := $mm.Params}}
		              {{if canOutParam $mm $idx}}
                          {{if gt $idx 0}}
                              {{$buff.Write ", "}}
                              {{if eq $ps.Type "string"}}
                                  {{$buff.Write "to_CString!(" (fLowCase $ps.Name) ")"}}
                              {{else}}
                                  {{if eq $ps.Flag "nonPtr"}}
                                       {{$buff.Write "&mut ps" $idx}}
                                  {{else}}
								        
									   {{if $ps.IsEvent}}
									       {{$buff.Write "insert_Id!("}}
									   {{end}}
                                       {{fLowCase $ps.Name|$buff.Write}}
									   {{if $ps.IsEvent}}
									       {{$buff.Write ", aSelfId)"}}
									   {{end}}
                                  {{end}}

                                  {{if isObject $ps.Type}}
                                       {{$buff.Write ".Instance()"}}
                                  {{end}}
                              {{end}}
                          {{end}}
			          {{end}}
			      {{end}}
			      {{if $mm.LastIsReturn}}
			          {{$buff.Write ", &mut result"}}
			      {{end}}
			      {{$buff.Write ")"}}
		          {{if $retIsStr}}
		              {{$buff.Write ")"}}
		          {{end}}
                  {{$buff.Writeln ";"}}


                  {{if $mm.LastIsReturn}}
                        {{$buff.Writeln "          return result;"}}
                  {{end}}
				  {{/*无返回值的，全都统一反回 self*/}}
				  {{if and (isEmpty $mm.Return) (not $mm.LastIsReturn)}}
				        {{$buff.Writeln "          return &self;"}}
				  {{end}}


	  {{$buff.ToStr}}
      }

               {{end}}
##
           {{else}}
##
      impl_Object_methods!({{$className}});
##
      // static class
	  impl_Class_method!({{$mm.Name}});
##
      {{if eq $className "TMemoryStream"}}
      {{template "memoryStreamMethods" .}}
      {{end}}

           {{end}}
      {{end}}
  {{end}}
}
##
impl_IObject!({{$className}});
//impl_Object_Convert!({{$className}});


{{if $el.IsComponent}}
impl_IComponent!({{$className}});
{{end}}

{{if $el.IsControl}}
impl_IControl!({{$className}});
{{end}}

{{if $el.IsWinControl}}
impl_IWinControl!({{$className}});
{{end}}

{{if or (eq $className "TStrings") (eq $className "TStringList")}}
impl_IStrings!({{$className}});
{{end}}

{{if or (eq $className "TStream") (eq $className "TMemoryStream")}}
impl_IStream!({{$className}});
{{end}}

{{if eq $className "TForm"}}
impl IForm for {{$className}} {}
{{end}}

{{if or (eq $el.BaseClassName "TGraphic") (eq $className "TGraphic")}}
impl IGraphic for {{$className}} {}
{{end}}

{{/* 所有不为TComponent和TControl和TWinControl的实现drop方法 */}}
{{if haveFree $el.Methods}}
  {{if not $el.IsComponent }}
 
impl_Drop_method!({{$className}});

  {{end}}
{{end}}


{{/*循环一次结束*/}}
{{end}}

##
##
pub struct TNull(usize, bool);
impl_IObject!(TNull);
impl_IComponent!(TNull);
impl_IControl!(TNull);
impl_IWinControl!(TNull);

pub fn Null() -> TNull {
   TNull { 0: 0, 1: false, }
}
##
fn getApplication() -> TApplication {
   initLibLCLCallback();
   TApplication {
       0: unsafe { Application_Instance() }, 1: false, 
   }
}
##
// ------------------------------------ global vars ------------------------------------
##
lazy_static! {
{{range $el := .InstanceObjects}}
    pub static ref {{$el.Name}}: {{$el.Type}} = {{if eq $el.Name "Application"}}getApplication(){{else}}{{$el.Type}}::from(unsafe { {{$el.InstanceFunc}}() }){{end}};
{{end}}
}
