/*
    The code is automatically generated by the genBind tool.
    Author: ying32
    https://github.com/ying32
*/
##
#![allow(non_snake_case)]
#![allow(improper_ctypes)]
#![allow(dead_code)]
##
use std::collections::HashMap;
use std::mem::{size_of, transmute};
use std::os::raw::c_char;
use std::sync::Mutex;
use types::*;
##

{{define "genFunc"}}
    {{$el := .}}
    {{$buff := newBuffer}}

    {{if eq $el.Platform "windows"}}
        {{$buff.Writeln "  #[cfg(target_os = \"windows\")]"}}
    {{end}}
    {{if eq $el.Platform "linux,macos"}}
        {{$buff.Writeln "  #[cfg(not(target_os = \"windows\"))]"}}
    {{end}}
    {{if eq $el.Platform "macos"}}
        {{$buff.Writeln "  #[cfg(target_os = \"macos\")]"}}
    {{end}}
    {{if eq $el.Platform "linux"}}
        {{$buff.Writeln "  #[cfg(target_os = \"linux\")]"}}
    {{end}}
    {{$buff.Write "  "}}
    {{if not (inStrArray $el.Name "SetEventCallback" "SetMessageCallback" "SetThreadSyncCallback" "SetExceptionHandlerCallback")}}
        {{$buff.Write "pub "}}
    {{end}}

    {{$buff.Write "fn " $el.Name "("}}
    {{range $idx, $ps := $el.Params}}
        {{if gt $idx 0}}
            {{$buff.Write ", "}}
        {{end}}
        {{$buff.Write $ps.Name ": "}}
        {{if not (isObject $ps.Type)}}
		    {{if and (hasPrefix $el.RealName "SetOn") (eq $ps.Name "AEventId")}}
			    {{$buff.Write "usize"}}
			{{else}}
				{{if $ps.IsVar}}
					{{$buff.Write "*mut "}}
				{{end}}
				{{covType $ps.Type|$buff.Write}}
			{{end}}
        {{else}}
            {{$buff.Write "usize"}}
        {{end}}
    {{end}}
    {{$buff.Write ")"}}
    {{if not (isEmpty $el.Return)}}
        {{$buff.Write " -> "}}
        {{if not (isObject $el.Return)}}
            {{covType $el.Return|$buff.Write}}
        {{else}}
            {{$buff.Write "usize"}}
        {{end}}
    {{end}}
    {{$buff.Writeln ";"}}


{{$buff.ToStr}}
{{end}}

// MSVC 编译器，静态加载
#[link(name = "liblcl")]
extern "system" {
##
##
{{range $el := .Functions}}
    {{template "genFunc" $el}}
{{end}}
##
##
{{range $el := .Objects}}
##
  // ----------------- {{$el.ClassName}} ----------------------
    {{range $fn := $el.Methods}}
        {{template "genFunc" $fn}}
    {{end}}
{{end}}
##
}
##
##
##
// 根据索引获取参数
#[inline]
unsafe fn getParamOf(index: usize, ptr: usize) -> usize {
    return *((ptr + index * size_of::<usize>()) as *const usize);
}
##
// 回调函数
##
extern "system" fn doEventCallback(f: usize, args: usize, arg_count: i32) -> usize {
    macro_rules! tt {
        ($x:expr) => {
            usize
        };
    }
    macro_rules! sys_call {
        () => {
            transmute::<usize, fn()>(f)()
        };
        ($sid: expr, $($arg:expr),*) => {
            transmute::<usize, fn(usize, $( tt!($arg)),*)>(f)($sid, $(getParamOf($arg, args)),* )
        };
    }
    unsafe {
        let sid = getSelfId(f);
        //println!("sid={}, fid={}", sid, f);
        match arg_count {
            00 => sys_call!(),
            01 => sys_call!(sid, 0),
            02 => sys_call!(sid, 0, 1),
            03 => sys_call!(sid, 0, 1, 2),
            04 => sys_call!(sid, 0, 1, 2, 3),
            05 => sys_call!(sid, 0, 1, 2, 3, 4),
            06 => sys_call!(sid, 0, 1, 2, 3, 4, 5),
            07 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6),
            08 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6, 7),
            09 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6, 7, 8),
            10 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9),
            11 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10),
            12 => sys_call!(sid, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11),
            _ => println!("none"),
        }
    }
    return 0;
}
##
// 消息回调
extern "system" fn doMessageCallback(f: usize, msg: usize) -> usize {
    let sid = getSelfId(f);
    unsafe { transmute::<usize, fn(usize, usize)>(f)(sid, msg) };
    return 0;
}
##
// 线程同步回调(未实现)
extern "system" fn doThreadSyncCallback() -> usize {
    return 0;
}
##
pub fn initLibLCLCallback() {
    unsafe {
        // 基本事件回调
        SetEventCallback(doEventCallback as usize);
        SetMessageCallback(doMessageCallback as usize);
        SetThreadSyncCallback(doThreadSyncCallback as usize);
    }
}
##
##
lazy_static! {
    static ref EVENT_HASH: Mutex{{html "<HashMap<usize, usize>>"}} = {
        let map: HashMap<usize, usize> = HashMap::new();
        Mutex::new(map)
    };
}
##
pub fn insertMap(key: usize, val: usize) -> usize {
    EVENT_HASH.lock().unwrap().insert(key, val);  
    key
}
##
fn getSelfId(eid: usize) -> usize {
    match EVENT_HASH.lock().unwrap().get(&eid) {
        Some(&number) => number,
        _ => 0,
    }
}
