/*
   The code is automatically generated by the genBind tool. 
   Author: ying32
   https://github.com/ying32  
*/

##
##
#ifndef _LIBLCL_H
#define _LIBLCL_H
##
#ifdef __cplusplus
//extern "C" {
#define CChar const
#else
#define CChar
#endif
##
#ifdef __GNUC__
   // #pragma GCC diagnostic ignored "-Wint-to-pointer-cast"
#endif
##
#include <stdint.h>
#include <stdio.h>
#include <assert.h>
##
#ifdef __GNUC__
#include <pthread.h>
#endif
##
#ifdef _WIN32
    #include<Windows.h>
    #define LCLAPI __stdcall
#else
    #include <dlfcn.h>
    #include <stddef.h>
    #include <stdbool.h>
    // __cdecl 默认
    #define LCLAPI
    #define TRUE 1
    #define FALSE 0
#endif
##
#ifndef NULL
    #define NULL 0
#endif
##
//#ifdef __APPLE__
//    #include <Cocoa/Cocoa.h>
//#endif
##
##
##
// 非Windows下的类型定义
#ifndef _WIN32
    typedef int32_t BOOL;
#endif
##
#ifdef __linux__
    typedef void* PGdkWindow;
    //typedef uintptr_t TXId;
    typedef void* PGtkFixed;
#endif
##
#ifdef __APPLE__
    //#include <Cocoa/Cocoa.h>
    typedef void* MyNSWindow;
#endif
##
// printf("GetFunc: %s=%p\n", ""#name"", p##name);
##
// 获取dll函数地址
#define GET_FUNC_ADDR(name) \
if(!p##name) \
   p##name = get_proc_addr(""#name""); \
assert(p##name != NULL);
##
// 定义dll函数指针
#define DEFINE_FUNC_PTR(name) \
static void* p##name;
##
// 转换参数
#define COV_PARAM(name) \
(uintptr_t)name
##
##
/*--------------------常量定义--------------------*/
{{range $el := .Consts}}
  {{if not (isEmpty $el.Name)}}
    {{if eq $el.Name "CF_BITMAP"}}
#ifndef _WIN32
##
    {{end}}
#define {{$el.Name}}  {{$el.Value}}{{if not (isEmpty $el.Value2)}} + {{$el.Value2}}{{end}}{{if not (isEmpty $el.Comment)}} // {{html $el.Comment}}{{end}}
  {{else}}
##
// {{html $el.Comment}}
  {{end}}
    {{if eq $el.Name "CF_TIFF"}}
##
#endif
    {{end}}
{{end}}
##
/*--------------------枚举定义/集合定义--------------------*/
// 集合定义
typedef uint32_t TSet;
##
{{range $el := .Types}}
  {{if eq $el.Kind "enum"}}
##
typedef enum {
      {{range $enum := $el.Enums}}
    {{$enum.Name}}{{if not (isEmpty $enum.Value)}} = {{$enum.Value}}{{end}},{{if not (isEmpty $enum.Comment)}} // {{html $enum.Comment}}{{end}}
      {{end}}
} {{$el.Name}};
  {{else if eq $el.Kind "set"}}
##
typedef TSet {{$el.Name}};
  {{end}}
{{end}}


##
/*--------------------类型定义--------------------*/
{{/* 基础类型定义 */}}

{{range $tidex, $el := .BaseTypes}}
  {{if isEmpty $el.FieldArch}}
    {{if eq $el.Kind "struct"}}
##
typedef struct {{$el.Name}} {
      {{range $field := $el.Fields}}
    {{covType $field.Type}} {{covKeyword $field.Name}}{{if $field.IsArr}}[{{$field.ArrLength}}]{{end}};
      {{end}}
} {{$el.Name}};
  {{else if eq $el.Kind "type"}}
      {{if ne $el.Name "TSet"}}
        {{if or (or (eq $el.Name "HWND") (eq $el.Name "HPALETTE")) (eq $el.Name "LPCWSTR")}}
##
#ifndef _WIN32
##
        {{end}}
##
typedef {{covType $el.Type}} {{$el.Name}};

        {{if or (or (eq $el.Name "HGLOBAL") (eq $el.Name "LRESULT")) (eq $el.Name "HCURSOR")}}
##
#endif
##
        {{end}}
      {{end}}
    {{end}}
  {{end}}
{{end}}

{{/* 类型，不要arc的 */}}
{{range $el := .Types}}
  {{if isEmpty $el.FieldArch}}
    {{if eq $el.Kind "struct"}}
##
typedef struct {{$el.Name}} {
      {{range $field := $el.Fields}}
    {{covType $field.Type}} {{covKeyword $field.Name}}{{if $field.IsArr}}[{{$field.ArrLength}}]{{end}};
      {{end}}
} {{$el.Name}};
  {{else if eq $el.Kind "type"}}
##
typedef {{covType $el.Type}} {{$el.Name}};
    {{end}}
  {{end}}
{{end}}
##
{{/* 类型，arc的 */}}
#if defined(_WIN64) || defined(__x86_64__)
{{range $el := .BaseTypes}}
  {{if eq $el.FieldArch "amd64"}}
    {{if eq $el.Kind "struct"}}
##
typedef struct {{$el.Name}} {
      {{range $field := $el.Fields}}
    {{covType $field.Type}} {{covKeyword $field.Name}}{{if $field.IsArr}}[{{$field.ArrLength}}]{{end}};
      {{end}}
} {{$el.Name}};
    {{end}}
  {{end}}
{{end}}
#else
{{range $el := .BaseTypes}}
  {{if eq $el.FieldArch "i386"}}
    {{if eq $el.Kind "struct"}}
##
typedef struct {{$el.Name}} {
      {{range $field := $el.Fields}}
    {{covType $field.Type}} {{covKeyword $field.Name}}{{if $field.IsArr}}[{{$field.ArrLength}}]{{end}};
      {{end}}
} {{$el.Name}};
    {{end}}
  {{end}}
{{end}}
#endif

##
##
/*--------------------类的定义--------------------*/
{{range $el := .Objects}}
typedef void* {{$el.ClassName}};
{{end}}

##
/*--------------------事件定义--------------------*/
{{range $el := .Events}}
// void ({{range $idx, $ps := $el.Params}}{{if gt $idx 0}}, {{end}}{{if and (eq $el.Name "TDropFilesEvent") (eq $ps.Type "int")}}intptr_t{{else}}{{covType $ps.Type}}{{end}}{{if $ps.IsVar}}*{{end}} {{$ps.Name}}{{end}})
typedef void(*{{$el.Name}})({{range $idx, $ps := $el.Params}}{{if gt $idx 0}}, {{end}}{{if and (eq $el.Name "TDropFilesEvent") (eq $ps.Type "int")}}intptr_t{{else}}{{covType $ps.Type}}{{end}}{{if $ps.IsVar}}*{{end}}{{end}});
##
{{end}}
##


##
##
// 集合加法，val...中存储为位的索引，下标为0
TSet Include(TSet s, uint8_t val) {
    return (TSet)(s | (1 {{html "<<"}} val));
}
//TSet Include(TSet s, ...) {
//    uint32_t r = (uint32_t)s;
//    va_list varlist;
//    va_start(varlist, s);
//    uint8_t val;
//    while ((val = va_arg(varlist, int)) != -1) {
//        r |= (1 {{html "<<"}} (uint8_t)val);
//    }
//    va_end(varlist);
//    return (TSet)r;
//}
##
// 集合减法，val...中存储为位的索引，下标为0
TSet Exclude(TSet s, uint8_t val) {
    return (TSet)(s & (~(1 {{html "<<"}} val)));
}
//TSet Exclude(TSet s, ...) {
//    uint32_t r = (uint32_t)s;
//    va_list varlist;
//    va_start(varlist, s);
//    uint8_t val;
//    while ((val = va_arg(varlist, int)) != -1) {
//        r &= ~(1 {{html "<<"}} (uint8_t)val);
//    }
//    va_end(varlist);
//    return (TSet)r;
//}
##
// 集合类型的判断，val表示位数，下标为0
BOOL InSet(uint32_t s, uint8_t val) {
    if ((s&(1 {{html "<<"}} val)) != 0) {
        return TRUE;
    }
    return FALSE;
}
##
##
// liblcl句柄
static uintptr_t libHandle;
##

##
// 函数call
typedef intptr_t LCLAPI (*SYSCALL0)();
typedef intptr_t LCLAPI (*SYSCALL1)(intptr_t);
typedef intptr_t LCLAPI (*SYSCALL2)(intptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL3)(intptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL4)(intptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL5)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL6)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL7)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL8)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL9)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL10)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL11)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL12)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
##

// 全局实例类定义
{{range $el := .InstanceObjects}}
{{$el.Type}} {{$el.Name}};
{{end}}
##
// 全局互斥锁
#ifdef __GNUC__
static pthread_mutex_t threadSyncMutex;
#else
static RTL_CRITICAL_SECTION threadSyncMutex;
#endif
##
// 初始liblcl库
static void init_lib_lcl();
// 反向初始liblcl库
static void un_init_lib_lcl();
##
##
// 获取过程地址
static void* get_proc_addr(const char *name) {
#ifdef _WIN32
    return (void*)GetProcAddress((HMODULE)libHandle, name);
#else
    return (void*)dlsym((void*)libHandle, name);
#endif
}
##
// 加载库
BOOL load_liblcl(const char *name) {
    if(libHandle > 0)
        return TRUE;
#ifdef _WIN32
    libHandle = (uintptr_t)LoadLibraryA(name);
#else
    libHandle = (uintptr_t)dlopen(name, RTLD_LAZY|RTLD_GLOBAL);
#endif
    if(libHandle > 0) {
         // 初始库
         init_lib_lcl();
    }
    return libHandle > 0;
}
##
// 关闭库
void close_liblcl() {
    if(libHandle > 0) {
	#ifdef _WIN32
	    FreeLibrary((HMODULE)libHandle);
	#else
	    dlclose((void*)libHandle);
	#endif
        libHandle = 0;
        un_init_lib_lcl();
    }
}
##


{{define "genFunc"}}
    {{$el := .}}
    {{$isPsRet := $el.LastIsReturn}}
    {{$buff := newBuffer}}
    {{/*dll函数指针变量声明*/}}
    {{$buff.Writeln "DEFINE_FUNC_PTR(" $el.Name ")" }}
    {{/*返回值确认*/}}
    {{if isEmpty $el.Return}}
       {{if $isPsRet}}
          {{covType (lastParam $el.Params).Type|$buff.Writeln}}
       {{else}}
          {{$buff.Writeln "void"}}
       {{end}}
    {{else}}
       {{covType $el.Return|$buff.Writeln}}
    {{end}}
    {{/*函数名*/}}
    {{delDChar $el.Name|$buff.Write}}
    {{$buff.Write "("}}
    {{/*函数声明参数*/}}
    {{range $idx, $ps := $el.Params}}
       {{if canOutParam $el $idx}}
          {{if gt $idx 0}}
            {{$buff.Write ", "}}
          {{end}}
          {{if eq $ps.Type "string"}}
            {{$buff.Write "CChar "}}
          {{end}}
          {{covType $ps.Type|$buff.Write}}
          {{if $ps.IsVar}}
            {{if ne $ps.Flag "nonPtr"}}
              {{$buff.Write "*"}}
            {{end}}
          {{end}}
          {{$buff.Write " " $ps.Name}}
       {{end}}
    {{end}}
    {{$buff.Writeln ") {"}}
    {{/*获取dll函数*/}}
    {{$buff.Writeln "    GET_FUNC_ADDR(" $el.Name ")"}}
    {{/*使用参数返回的，重新定义一个result变量来接收*/}}
    {{if $isPsRet}}
       {{$buff.Writeln "    " (covType (lastParam $el.Params).Type) " result;"}}
    {{end}}

    {{$buff.Write "    "}}
    {{if not (isEmpty $el.Return)}}
       {{$buff.Write "return (" (covType $el.Return) ")"}}
    {{end}}
	{{$buff.Write "(((SYSCALL" (len $el.Params) ") (p" $el.Name "))(" }}
    {{/*参数传递*/}}
    {{range $idx, $ps := $el.Params}}
      {{if canOutParam $el $idx}}
		{{if gt $idx 0}}
          {{$buff.Write ", "}}
		{{end}}
		{{$buff.Write "COV_PARAM("}}
        {{if and $ps.IsVar (eq $ps.Flag "nonPtr")}}
          {{$buff.Write "&"}}
        {{end}}
        {{$buff.Write $ps.Name}}
		{{$buff.Write ")"}}
      {{end}}
    {{end}}
    {{if $isPsRet}}
	  {{if gt (len $el.Params) 1}}
        {{$buff.Write ", "}}
	  {{end}} 		
      {{$buff.Write "COV_PARAM(&result)"}}
    {{end}}
    {{$buff.Writeln "));"}}

    {{if $isPsRet}}
       {{$buff.Writeln "    return result;"}}
    {{end}}
    {{$buff.Writeln "}"}}
{{$buff.ToStr}}
{{end}}




/*--------------------一些其它函数--------------------*/
{{range $el := .Functions}}

{{if ne $el.Name "DMove"}}

{{if eq $el.Name "DSendMessage"}}
#ifndef _WIN32
##
{{end}}
{{if eq $el.Name "DCreateURLShortCut"}}
#ifdef _WIN32
##
{{end}}
{{if eq $el.Name "GtkWidget_GetGtkFixed"}}
##
#ifdef __linux__
##
{{end}}
{{if eq $el.Name "NSWindow_FromForm"}}
##
#ifdef __APPLE__
##
{{end}}

##

{{template "genFunc" $el}}

{{if or (or (or (eq $el.Name "DWindowFromPoint") (eq $el.Name "DCreateShortCut")) (eq $el.Name "NSWindow_FromForm")) (eq $el.Name "GtkWidget_Window")}}
##
#endif
##
{{end}}
{{end}}
{{end}}


/*--------------------类成员函数--------------------*/

{{range $obj := .Objects}}
##
// -------------------{{$obj.ClassName}}-------------------
  {{range $el := $obj.Methods}}
##
{{template "genFunc" $el}}
  {{end}}
{{end}}

##
##

/* ------------------函数重定义------------------------------- */
static inline char* GetFPStringArrayMember(void* P, intptr_t AIndex) {
    return GetStringArrOf(P, AIndex);
}

##
##

##
// 事件call
typedef void(*ESYSCALL0)();
typedef void(*ESYSCALL1)(intptr_t);
typedef void(*ESYSCALL2)(intptr_t, uintptr_t);
typedef void(*ESYSCALL3)(intptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL4)(intptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL5)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL6)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL7)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL8)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL9)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL10)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL11)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef void(*ESYSCALL12)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
##

// getParam 从指定索引和地址获取事件中的参数
#define getParamOf(index, ptr) \
 (*((uintptr_t*)((uintptr_t)ptr + (uintptr_t)index*sizeof(uintptr_t))))
##
##
// 事件回调
static void* LCLAPI doEventCallbackProc(void* f, void* args, long argCount) {
##
	// 获取参数的宏
	#define _A_(index) \
	   getParamOf(index, args)
##
    switch (argCount) {
    case 0:  ((ESYSCALL0) (f))(); break;
    case 1:  ((ESYSCALL1) (f))(_A_(0)); break;
    case 2:  ((ESYSCALL2) (f))(_A_(0), _A_(1)); break;
    case 3:  ((ESYSCALL3) (f))(_A_(0), _A_(1), _A_(2)); break;
    case 4:  ((ESYSCALL4) (f))(_A_(0), _A_(1), _A_(2), _A_(2)); break;
    case 5:  ((ESYSCALL5) (f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4)); break;
    case 6:  ((ESYSCALL6) (f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5)); break;
    case 7:  ((ESYSCALL7) (f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6)); break;
    case 8:  ((ESYSCALL8) (f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6), _A_(7)); break;
    case 9:  ((ESYSCALL9) (f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6), _A_(7), _A_(8)); break;
    case 10: ((ESYSCALL10)(f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6), _A_(7), _A_(8), _A_(9)); break;
    case 11: ((ESYSCALL11)(f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6), _A_(7), _A_(8), _A_(9), _A_(10)); break;
    case 12: ((ESYSCALL12)(f))(_A_(0), _A_(1), _A_(2), _A_(3), _A_(4), _A_(5), _A_(6), _A_(7), _A_(8), _A_(9), _A_(10), _A_(11)); break;
    }
    return NULL;
}
##
##
// 消息回调
static void* LCLAPI doMessageCallbackProc(void* f, void* msg) {
   ((void(*)(void*))f)(msg);
    return NULL;
}
##
// 线程同步过程
static TThreadProc threadSyncProc;
// 线程同步回调
static void* LCLAPI doThreadSyncCallbackProc() {
    if (threadSyncProc) {
        ((TThreadProc)threadSyncProc)();
        threadSyncProc = NULL;
    }
    return NULL;
}
##
// 线程同步方法
// 无参数，无返回值的一个函数
void ThreadSync(TThreadProc fn) {
    // 加锁
#ifdef __GNUC__
    pthread_mutex_lock(&threadSyncMutex);
#else
    EnterCriticalSection(&threadSyncMutex);
#endif
    threadSyncProc = fn;
    Synchronize(FALSE);
    threadSyncProc = NULL;
#ifdef __GNUC__
    pthread_mutex_unlock(&threadSyncMutex);
#else
    LeaveCriticalSection(&threadSyncMutex);
#endif
##
}
##
#define GET_CALLBACK(name) \
  (void*)&name
##
static void init_lib_lcl() {
#ifdef __GNUC__
    pthread_mutex_init(&threadSyncMutex, NULL);
#else
    InitializeCriticalSection(&threadSyncMutex);
#endif
##
    // 设置事件的回调函数
	SetEventCallback(GET_CALLBACK(doEventCallbackProc));
	// 消息回调
	SetMessageCallback(GET_CALLBACK(doMessageCallbackProc));
	// 线程同步回调
	SetThreadSyncCallback(GET_CALLBACK(doThreadSyncCallbackProc));
##
{{range $el := .InstanceObjects}}
    {{$el.Name}} = {{$el.InstanceFunc}}();
{{end}}
##
}
##
static void un_init_lib_lcl() {
#ifdef __GNUC__
    pthread_mutex_destroy(&threadSyncMutex);
#else
    DeleteCriticalSection(&threadSyncMutex);
#endif
}
##
//#ifdef __cplusplus
//}
//#endif
##
#endif // _LIBLCL_H
