/*
   The code is automatically generated by the genBind tool. 
   Author: ying32
   https://github.com/ying32  
*/


#ifndef _LIBLCL_H
#define _LIBLCL_H

#ifdef __cplusplus
//extern "C" {
#define CChar const
#else
#define CChar
#endif

#ifdef __GNUC__
   // #pragma GCC diagnostic ignored "-Wint-to-pointer-cast"
#endif

#include <stdint.h>
#include <stdio.h>
#include <assert.h>

#ifdef __GNUC__
#include <pthread.h>
#endif

#ifdef _WIN32
    #include<Windows.h>
    #define LCLAPI __stdcall
#else
    #include <dlfcn.h>
    #include <stddef.h>
    #include <stdbool.h>
    // __cdecl 默认
    #define LCLAPI
    #define TRUE 1
    #define FALSE 0
#endif

#ifndef NULL
    #define NULL 0
#endif

//#ifdef __APPLE__
//    #include <Cocoa/Cocoa.h>
//#endif



// 非Windows下的类型定义
#ifndef _WIN32
    typedef int32_t BOOL;
#endif

#ifdef __linux__
    typedef void* PGdkWindow;
    //typedef uintptr_t TXId;
    typedef void* PGtkFixed;
#endif

#ifdef __APPLE__
    //#include <Cocoa/Cocoa.h>
    typedef void* MyNSWindow;
#endif

// printf("GetFunc: %s=%p\n", ""#name"", p##name);

// 获取dll函数地址
#define GET_FUNC_ADDR(name) \
if(!p##name) \
   p##name = get_proc_addr(""#name""); \
assert(p##name != NULL);

// 定义dll函数指针
#define DEFINE_FUNC_PTR(name) \
static void* p##name;

// 转换参数
#define COV_PARAM(name) \
(uintptr_t)name


/*--------------------常量定义--------------------*/

// Lazarus中的颜色表，Lazarus中的TColor与一般HTML的RGB有点不一样，反过来的以BGR表示.
#define clClSysNone  0x1FFFFFFF
#define clSysDefault  0x20000000

// Actual colors
#define clAliceblue  0xFFF8F0
#define clAntiquewhite  0xD7EBFA
#define clAqua  0xFFFF00
#define clAquamarine  0xD4FF7F
#define clAzure  0xFFFFF0
#define clBeige  0xDCF5F5
#define clBisque  0xC4E4FF
#define clBlack  0x000000
#define clBlanchedalmond  0xCDEBFF
#define clBlue  0xFF0000
#define clBlueviolet  0xE22B8A
#define clBrown  0x2A2AA5
#define clBurlywood  0x87B8DE
#define clCadetblue  0xA09E5F
#define clChartreuse  0x00FF7F
#define clChocolate  0x1E69D2
#define clCoral  0x507FFF
#define clCornflowerblue  0xED9564
#define clCornsilk  0xDCF8FF
#define clCrimson  0x3C14DC
#define clCyan  0xFFFF00
#define clDarkblue  0x8B0000
#define clDarkcyan  0x8B8B00
#define clDarkgoldenrod  0x0B86B8
#define clDarkgray  0xA9A9A9
#define clDarkgreen  0x006400
#define clDarkgrey  0xA9A9A9
#define clDarkkhaki  0x6BB7BD
#define clDarkmagenta  0x8B008B
#define clDarkolivegreen  0x2F6B55
#define clDarkorange  0x008CFF
#define clDarkorchid  0xCC3299
#define clDarkred  0x00008B
#define clDarksalmon  0x7A96E9
#define clDarkseagreen  0x8FBC8F
#define clDarkslateblue  0x8B3D48
#define clDarkslategray  0x4F4F2F
#define clDarkslategrey  0x4F4F2F
#define clDarkturquoise  0xD1CE00
#define clDarkviolet  0xD30094
#define clDeeppink  0x9314FF
#define clDeepskyblue  0xFFBF00
#define clDimgray  0x696969
#define clDimgrey  0x696969
#define clDodgerblue  0xFF901E
#define clFirebrick  0x2222B2
#define clFloralwhite  0xF0FAFF
#define clForestgreen  0x228B22
#define clFuchsia  0xFF00FF
#define clGainsboro  0xDCDCDC
#define clGhostwhite  0xFFF8F8
#define clGold  0x00D7FF
#define clGoldenrod  0x20A5DA
#define clGray  0x808080
#define clGreen  0x008000
#define clGreenyellow  0x2FFFAD
#define clGrey  0x808080
#define clHoneydew  0xF0FFF0
#define clHotpink  0xB469FF
#define clIndianred  0x5C5CCD
#define clIndigo  0x82004B
#define clIvory  0xF0FFFF
#define clKhaki  0x8CE6F0
#define clLavender  0xFAE6E6
#define clLavenderblush  0xF5F0FF
#define clLawngreen  0x00FC7C
#define clLemonchiffon  0xCDFAFF
#define clLightblue  0xE6D8AD
#define clLightcoral  0x8080F0
#define clLightcyan  0xFFFFE0
#define clLightgoldenrodyellow  0xD2FAFA
#define clLightgray  0xD3D3D3
#define clLightgreen  0x90EE90
#define clLightgrey  0xD3D3D3
#define clLightpink  0xC1B6FF
#define clLightsalmon  0x7AA0FF
#define clLightseagreen  0xAAB220
#define clLightskyblue  0xFACE87
#define clLightslategray  0x998877
#define clLightslategrey  0x998877
#define clLightsteelblue  0xDEC4B0
#define clLightyellow  0xE0FFFF
#define clLtGray  0xC0C0C0
#define clMedGray  0xA4A0A0
#define clDkGray  0x808080
#define clMoneyGreen  0xC0DCC0
#define clLegacySkyBlue  0xF0CAA6
#define clCream  0xF0FBFF
#define clLime  0x00FF00
#define clLimegreen  0x32CD32
#define clLinen  0xE6F0FA
#define clMagenta  0xFF00FF
#define clMaroon  0x000080
#define clMediumaquamarine  0xAACD66
#define clMediumblue  0xCD0000
#define clMediumorchid  0xD355BA
#define clMediumpurple  0xDB7093
#define clMediumseagreen  0x71B33C
#define clMediumslateblue  0xEE687B
#define clMediumspringgreen  0x9AFA00
#define clMediumturquoise  0xCCD148
#define clMediumvioletred  0x8515C7
#define clMidnightblue  0x701919
#define clMintcream  0xFAFFF5
#define clMistyrose  0xE1E4FF
#define clMoccasin  0xB5E4FF
#define clNavajowhite  0xADDEFF
#define clNavy  0x800000
#define clOldlace  0xE6F5FD
#define clOlive  0x008080
#define clOlivedrab  0x238E6B
#define clOrange  0x00A5FF
#define clOrangered  0x0045FF
#define clOrchid  0xD670DA
#define clPalegoldenrod  0xAAE8EE
#define clPalegreen  0x98FB98
#define clPaleturquoise  0xEEEEAF
#define clPalevioletred  0x9370DB
#define clPapayawhip  0xD5EFFF
#define clPeachpuff  0xB9DAFF
#define clPeru  0x3F85CD
#define clPink  0xCBC0FF
#define clPlum  0xDDA0DD
#define clPowderblue  0xE6E0B0
#define clPurple  0x800080
#define clRed  0x0000FF
#define clRosybrown  0x8F8FBC
#define clRoyalblue  0xE16941
#define clSaddlebrown  0x13458B
#define clSalmon  0x7280FA
#define clSandybrown  0x60A4F4
#define clSeagreen  0x578B2E
#define clSeashell  0xEEF5FF
#define clSienna  0x2D52A0
#define clSilver  0xC0C0C0
#define clSkyblue  0xEBCE87
#define clSlateblue  0xCD5A6A
#define clSlategray  0x908070
#define clSlategrey  0x908070
#define clSnow  0xFAFAFF
#define clSpringgreen  0x7FFF00
#define clSteelblue  0xB48246
#define clTan  0x8CB4D2
#define clTeal  0x808000
#define clThistle  0xD8BFD8
#define clTomato  0x4763FF
#define clTurquoise  0xD0E040
#define clViolet  0xEE82EE
#define clWheat  0xB3DEF5
#define clWhite  0xFFFFFF
#define clWhitesmoke  0xF5F5F5
#define clYellow  0x00FFFF
#define clYellowgreen  0x32CD9A
#define clBtnFace  0xFF00000F
#define clNull  0x00000000

// Virtual Keys, Standard Set
#define vkLButton  0x01 // 1
#define vkRButton  0x02 // 2
#define vkCancel  0x03 // 3
#define vkMButton  0x04 // 4
#define vkXButton1  0x05 // 5
#define vkXButton2  0x06 // 6
#define vkBack  0x08 // 8
#define vkTab  0x09 // 9
#define vkLineFeed  0x0A // 10
#define vkClear  0x0C // 12
#define vkReturn  0x0D // 13
#define vkShift  0x10 // 16
#define vkControl  0x11 // 17
#define vkMenu  0x12 // 18
#define vkPause  0x13 // 19
#define vkCapital  0x14 // 20
#define vkKana  0x15 // 21
#define vkHangul  0x15 // 21
#define vkJunja  0x17 // 23
#define vkFinal  0x18 // 24
#define vkHanja  0x19 // 25
#define vkKanji  0x19 // 25
#define vkConvert  0x1C // 28
#define vkNonConvert  0x1D // 29
#define vkAccept  0x1E // 30
#define vkModeChange  0x1F // 31
#define vkEscape  0x1B // 27
#define vkSpace  0x20 // 32
#define vkPrior  0x21 // 33
#define vkNext  0x22 // 34
#define vkEnd  0x23 // 35
#define vkHome  0x24 // 36
#define vkLeft  0x25 // 37
#define vkUp  0x26 // 38
#define vkRight  0x27 // 39
#define vkDown  0x28 // 40
#define vkSelect  0x29 // 41
#define vkPrint  0x2A // 42
#define vkExecute  0x2B // 43
#define vkSnapshot  0x2C // 44
#define vkInsert  0x2D // 45
#define vkDelete  0x2E // 46
#define vkHelp  0x2F // 47

// vk0 thru vk9 are the same as ASCII '0' thru '9' (0x30 - 0x39)
#define vk0  0x30 // 48
#define vk1  0x31 // 49
#define vk2  0x32 // 50
#define vk3  0x33 // 51
#define vk4  0x34 // 52
#define vk5  0x35 // 53
#define vk6  0x36 // 54
#define vk7  0x37 // 55
#define vk8  0x38 // 56
#define vk9  0x39 // 57

// vkA thru vkZ are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)
#define vkA  0x41 // 65
#define vkB  0x42 // 66
#define vkC  0x43 // 67
#define vkD  0x44 // 68
#define vkE  0x45 // 69
#define vkF  0x46 // 70
#define vkG  0x47 // 71
#define vkH  0x48 // 72
#define vkI  0x49 // 73
#define vkJ  0x4A // 74
#define vkK  0x4B // 75
#define vkL  0x4C // 76
#define vkM  0x4D // 77
#define vkN  0x4E // 78
#define vkO  0x4F // 79
#define vkP  0x50 // 80
#define vkQ  0x51 // 81
#define vkR  0x52 // 82
#define vkS  0x53 // 83
#define vkT  0x54 // 84
#define vkU  0x55 // 85
#define vkV  0x56 // 86
#define vkW  0x57 // 87
#define vkX  0x58 // 88
#define vkY  0x59 // 89
#define vkZ  0x5A // 90
#define vkLWin  0x5B // 91
#define vkRWin  0x5C // 92
#define vkApps  0x5D // 93
#define vkSleep  0x5F // 95
#define vkNumpad0  0x60 // 96
#define vkNumpad1  0x61 // 97
#define vkNumpad2  0x62 // 98
#define vkNumpad3  0x63 // 99
#define vkNumpad4  0x64 // 100
#define vkNumpad5  0x65 // 101
#define vkNumpad6  0x66 // 102
#define vkNumpad7  0x67 // 103
#define vkNumpad8  0x68 // 104
#define vkNumpad9  0x69 // 105
#define vkMultiply  0x6A // 106
#define vkAdd  0x6B // 107
#define vkSeparator  0x6C // 108
#define vkSubtract  0x6D // 109
#define vkDecimal  0x6E // 110
#define vkDivide  0x6F // 111
#define vkF1  0x70 // 112
#define vkF2  0x71 // 113
#define vkF3  0x72 // 114
#define vkF4  0x73 // 115
#define vkF5  0x74 // 116
#define vkF6  0x75 // 117
#define vkF7  0x76 // 118
#define vkF8  0x77 // 119
#define vkF9  0x78 // 120
#define vkF10  0x79 // 121
#define vkF11  0x7A // 122
#define vkF12  0x7B // 123
#define vkF13  0x7C // 124
#define vkF14  0x7D // 125
#define vkF15  0x7E // 126
#define vkF16  0x7F // 127
#define vkF17  0x80 // 128
#define vkF18  0x81 // 129
#define vkF19  0x82 // 130
#define vkF20  0x83 // 131
#define vkF21  0x84 // 132
#define vkF22  0x85 // 133
#define vkF23  0x86 // 134
#define vkF24  0x87 // 135
#define vkCamera  0x88 // 136
#define vkHardwareBack  0x89 // 137
#define vkNumLock  0x90 // 144
#define vkScroll  0x91 // 145
#define vkLShift  0xA0 // 160
#define vkRShift  0xA1 // 161
#define vkLControl  0xA2 // 162
#define vkRControl  0xA3 // 163
#define vkLMenu  0xA4 // 164
#define vkRMenu  0xA5 // 165
#define vkBrowserBack  0xA6 // 166
#define vkBrowserForward  0xA7 // 167
#define vkBrowserRefresh  0xA8 // 168
#define vkBrowserStop  0xA9 // 169
#define vkBrowserSearch  0xAA // 170
#define vkBrowserFavorites  0xAB // 171
#define vkBrowserHome  0xAC // 172
#define vkVolumeMute  0xAD // 173
#define vkVolumeDown  0xAE // 174
#define vkVolumeUp  0xAF // 175
#define vkMediaNextTrack  0xB0 // 176
#define vkMediaPrevTrack  0xB1 // 177
#define vkMediaStop  0xB2 // 178
#define vkMediaPlayPause  0xB3 // 179
#define vkLaunchMail  0xB4 // 180
#define vkLaunchMediaSelect  0xB5 // 181
#define vkLaunchApp1  0xB6 // 182
#define vkLaunchApp2  0xB7 // 183
#define vkSemicolon  0xBA // 186
#define vkEqual  0xBB // 187
#define vkComma  0xBC // 188
#define vkMinus  0xBD // 189
#define vkPeriod  0xBE // 190
#define vkSlash  0xBF // 191
#define vkTilde  0xC0 // 192
#define vkLeftBracket  0xDB // 219
#define vkBackslash  0xDC // 220
#define vkRightBracket  0xDD // 221
#define vkQuote  0xDE // 222
#define vkPara  0xDF // 223
#define vkOem102  0xE2 // 226
#define vkIcoHelp  0xE3 // 227
#define vkIco00  0xE4 // 228
#define vkProcessKey  0xE5 // 229
#define vkIcoClear  0xE6 // 230
#define vkPacket  0xE7 // 231
#define vkAttn  0xF6 // 246
#define vkCrsel  0xF7 // 247
#define vkExsel  0xF8 // 248
#define vkErEof  0xF9 // 249
#define vkPlay  0xFA // 250
#define vkZoom  0xFB // 251
#define vkNoname  0xFC // 252
#define vkPA1  0xFD // 253
#define vkOemClear  0xFE // 254
#define vkNone  0xFF // 255

// MessageBox or MessageDlg return value
#define idOK  1
#define idCancel  2
#define idAbort  3
#define idRetry  4
#define idIgnore  5
#define idYes  6
#define idNo  7
#define idClose  8
#define idHelp  9
#define idTryAgain  10
#define idContinue  11
#define mrNone  0
#define mrOk  idOK
#define mrCancel  idCancel
#define mrAbort  idAbort
#define mrRetry  idRetry
#define mrIgnore  idIgnore
#define mrYes  idYes
#define mrNo  idNo
#define mrClose  idClose
#define mrHelp  idHelp
#define mrTryAgain  idTryAgain
#define mrContinue  idContinue
#define mrAll  mrContinue + 1
#define mrNoToAll  mrAll + 1
#define mrYesToAll  mrNoToAll + 1

// Predefined Clipboard Formats
#ifndef _WIN32

#define CF_BITMAP  2
#define CF_DIB  8
#define CF_PALETTE  9
#define CF_ENHMETAFILE  14
#define CF_METAFILEPICT  3
#define CF_OEMTEXT  7
#define CF_TEXT  1
#define CF_UNICODETEXT  13
#define CF_DIF  5
#define CF_DSPBITMAP  130
#define CF_DSPENHMETAFILE  142
#define CF_DSPMETAFILEPICT  131
#define CF_DSPTEXT  129
#define CF_GDIOBJFIRST  768
#define CF_GDIOBJLAST  1023
#define CF_HDROP  15
#define CF_LOCALE  16
#define CF_OWNERDISPLAY  128
#define CF_PENDATA  10
#define CF_PRIVATEFIRST  512
#define CF_PRIVATELAST  767
#define CF_RIFF  11
#define CF_SYLK  4
#define CF_WAVE  12
#define CF_TIFF  6

#endif

// custom
#define CF_PICTURE  700
#define CF_HTML  701
#define CF_COMPONENT  702

// mouse cursor definition.
#define crHigh  TCursor(0)
#define crDefault  TCursor(0)
#define crNone  TCursor(-1)
#define crArrow  TCursor(-2)
#define crCross  TCursor(-3)
#define crIBeam  TCursor(-4)
#define crSize  TCursor(-22)
#define crSizeNESW  TCursor(-6) // diagonal north east - south west
#define crSizeNS  TCursor(-7)
#define crSizeNWSE  TCursor(-8)
#define crSizeWE  TCursor(-9)
#define crSizeNW  TCursor(-23)
#define crSizeN  TCursor(-24)
#define crSizeNE  TCursor(-25)
#define crSizeW  TCursor(-26)
#define crSizeE  TCursor(-27)
#define crSizeSW  TCursor(-28)
#define crSizeS  TCursor(-29)
#define crSizeSE  TCursor(-30)
#define crUpArrow  TCursor(-10)
#define crHourGlass  TCursor(-11)
#define crDrag  TCursor(-12)
#define crNoDrop  TCursor(-13)
#define crHSplit  TCursor(-14)
#define crVSplit  TCursor(-15)
#define crMultiDrag  TCursor(-16)
#define crSQLWait  TCursor(-17)
#define crNo  TCursor(-18)
#define crAppStart  TCursor(-19)
#define crHelp  TCursor(-20)
#define crHandPoint  TCursor(-21)
#define crSizeAll  TCursor(-22)
#define crLow  TCursor(-30)

/*--------------------枚举定义/集合定义--------------------*/
// 集合定义
typedef uint32_t TSet;


typedef enum {
    alNone,
    alTop,
    alBottom,
    alLeft,
    alRight,
    alClient,
    alCustom,
} TAlign;

typedef TSet TAlignSet;

typedef enum {
    bsNone,
    bsSingle,
    bsSizeable,
    bsDialog,
    bsToolWindow,
    bsSizeToolWin,
} TBorderStyle;

typedef enum {
    fsNormal,
    fsMDIChild,
    fsMDIForm,
    fsStayOnTop,
    fsSplash,
    fsSystemStayOnTop,
} TFormStyle;

typedef enum {
    poDesigned, // use bounds from the designer (read from stream)
    poDefault, // LCL decision (normally window manager decides)
    poDefaultPosOnly, // designed size and LCL position
    poDefaultSizeOnly, // designed position and LCL size
    poScreenCenter, // center form on screen (depends on DefaultMonitor)
    poDesktopCenter, // center form on desktop (total of all screens)
    poMainFormCenter, // center form on main form (depends on DefaultMonitor)
    poOwnerFormCenter, // center form on owner form (depends on DefaultMonitor)
    poWorkAreaCenter, // center form on working area (depends on DefaultMonitor)
} TPosition;

typedef enum {
    soBeginning,
    soCurrent,
    soEnd,
} TSeekOrigin;

typedef enum {
    pfDevice,
    pf1bit,
    pf4bit,
    pf8bit,
    pf15bit,
    pf16bit,
    pf24bit,
    pf32bit,
    pfCustom,
} TPixelFormat;

typedef enum {
    taLeftJustify,
    taRightJustify,
    taCenter,
} TAlignment;

typedef enum {
    bdLeftToRight,
    bdRightToLeft,
    bdRightToLeftNoAlign,
    bdRightToLeftReadingOnly,
} TBiDiMode;

typedef enum {
    taAlignTop,
    taAlignBottom,
    taVerticalCenter,
} TVerticalAlignment;

typedef enum {
    csDropDown, // like an TEdit plus a button to drop down the list, default
    csSimple, // like an TEdit plus a TListBox
    csDropDownList, // like TLabel plus a button to drop down the list
    csOwnerDrawFixed, // like csDropDownList, but custom drawn
    csOwnerDrawVariable, // like csDropDownList, but custom drawn and with each item can have another height
    csOwnerDrawEditableFixed, // like csOwnerDrawFixed, but with TEdit
    csOwnerDrawEditableVariable, // like csOwnerDrawVariable, but with TEdit
} TComboBoxStyle;

typedef enum {
    wsNormal,
    wsMinimized,
    wsMaximized,
    wsFullScreen,
} TWindowState;

typedef enum {
    tlTop,
    tlCenter,
    tlBottom,
} TTextLayout;

typedef enum {
    epNone,
    epPathEllipsis,
    epEndEllipsis,
    epWordEllipsis,
} TEllipsisPosition;

typedef enum {
    lbStandard,
    lbOwnerDrawFixed,
    lbOwnerDrawVariable,
    lbVirtual,
} TListBoxStyle;

typedef enum {
    paLeft,
    paRight,
    paCenter,
} TPopupAlignment;

typedef enum {
    tbRightButton,
    tbLeftButton,
} TTrackButton;

typedef enum {
    pbHorizontal,
    pbVertical,
    pbRightToLeft,
    pbTopDown,
} TProgressBarOrientation;

typedef enum {
    pbstNormal,
    pbstMarquee,
} TProgressBarStyle;

typedef enum {
    pbsNormal,
    pbsError,
    pbsPaused,
} TProgressBarState;

typedef enum {
    blGlyphLeft,
    blGlyphRight,
    blGlyphTop,
    blGlyphBottom,
} TButtonLayout;

typedef enum {
    bsUp, // button is up
    bsDisabled, // button disabled (grayed)
    bsDown, // button is down
    bsExclusive, // button is the only down in his group
    bsHot, // button is under mouse
} TButtonState;

typedef enum {
    bsAutoDetect,
    bsWin31,
    bsNew,
} TButtonStyle;

typedef enum {
    sbsNone,
    sbsSingle,
    sbsSunken,
} TStaticBorderStyle;

typedef enum {
    fsBold,
    fsItalic,
    fsUnderline,
    fsStrikeOut,
} TFontStyle;

typedef TSet TFontStyles;

typedef enum {
    ssNone,
    ssHorizontal,
    ssVertical,
    ssBoth,
    ssAutoHorizontal,
    ssAutoVertical,
    ssAutoBoth,
} TScrollStyle;

typedef enum {
    stNone,
    stData,
    stText,
    stBoth,
} TSortType;

typedef enum {
    arAlignBottom,
    arAlignLeft,
    arAlignRight,
    arAlignTop,
    arDefault,
    arSnapToGrid,
} TListArrangement;

typedef enum {
    vsIcon,
    vsSmallIcon,
    vsList,
    vsReport,
} TViewStyle;

typedef enum {
    isNone,
    isCut,
    isDropHilited,
    isFocused,
    isSelected,
    isActivating,
} TItemState;

typedef TSet TItemStates;

typedef enum {
    ctText,
    ctImage,
    ctState,
} TItemChange;

typedef enum {
    ifData,
    ifPartialString,
    ifExactString,
    ifNearest,
} TItemFind;

typedef enum {
    sdLeft,
    sdRight,
    sdAbove,
    sdBelow,
    sdAll,
} TSearchDirection;

typedef enum {
    htHandPoint,
    htUnderlineCold,
    htUnderlineHot,
} TListHotTrackStyle;

typedef TSet TListHotTrackStyles;

typedef enum {
    irText,
    irImage,
    irParam,
    irState,
    irIndent,
} TItemRequests;

typedef enum {
    bsSolid,
    bsClear,
    bsHorizontal,
    bsVertical,
    bsFDiagonal,
    bsBDiagonal,
    bsCross,
    bsDiagCross,
    bsImage,
    bsPattern,
} TBrushStyle;

typedef enum {
    psSolid,
    psDash,
    psDot,
    psDashDot,
    psDashDotDot,
    psinsideFrame,
    psPattern,
    psClear,
} TPenStyle;

typedef enum {
    btNext,
    btPrev,
} TUDBtnType;

typedef enum {
    tpTop,
    tpBottom,
    tpLeft,
    tpRight,
} TTabPosition;

typedef enum {
    tsTabs,
    tsButtons,
    tsFlatButtons,
} TTabStyle;

typedef enum {
    fpDefault,
    fpVariable,
    fpFixed,
} TFontPitch;

typedef enum {
    pmBlack,
    pmWhite,
    pmNop,
    pmNot,
    pmCopy,
    pmNotCopy,
    pmMergePenNot,
    pmMaskPenNot,
    pmMergeNotPen,
    pmMaskNotPen,
    pmMerge,
    pmNotMerge,
    pmMask,
    pmNotMask,
    pmXor,
    pmNotXor,
} TPenMode;

typedef enum {
    trHorizontal,
    trVertical,
} TTrackBarOrientation;

typedef enum {
    udHorizontal,
    udVertical,
} TUDOrientation;

typedef enum {
    fqDefault,
    fqDraft,
    fqProof,
    fqNonAntialiased,
    fqAntialiased,
    fqClearType,
    fqClearTypeNatural,
} TFontQuality;

typedef enum {
    caNone,
    caHide,
    caFree,
    caMinimize,
} TCloseAction;

typedef enum {
    bfNone,
    bfInfo,
    bfWarning,
    bfError,
} TBalloonFlags;

typedef enum {
    mtWarning,
    mtError,
    mtInformation,
    mtConfirmation,
    mtCustom,
} TMsgDlgType;

typedef enum {
    mbYes,
    mbNo,
    mbOK,
    mbCancel,
    mbAbort,
    mbRetry,
    mbIgnore,
    mbAll,
    mbNoToAll,
    mbYesToAll,
    mbHelp,
    mbClose,
} TMsgDlgBtn;

typedef TSet TMsgDlgButtons;

typedef enum {
    sltURL,
    sltID,
} TSysLinkType;

typedef enum {
    psText,
    psOwnerDraw,
} TStatusPanelStyle;

typedef enum {
    jpBestQuality,
    jpBestSpeed,
} TJPEGPerformance;

typedef enum {
    nsCut,
    nsDropHilite, // = Node.DropTarget
    nsFocused, // = Node.Focused
    nsSelected, // = Node.Selected
    nsMultiSelected, // = Node.MultiSelected
    nsExpanded, // = Node.Expanded
    nsHasChildren, // = Node.HasChildren
    nsDeleting, // = Node.Deleting, set on Destroy
    nsVisible, // = Node.Visible
    nsBound, // bound to a tree, e.g. has Parent or is top lvl node
} TNodeState;

typedef enum {
    naAdd, // add as last sibling of Destination
    naAddFirst, // add as first sibling of Destination
    naAddChild, // add as last child of Destination
    naAddChildFirst, // add as first child of Destination
    naInsert, // insert in front of Destination
    naInsertBehind, // insert behind Destination
} TNodeAttachMode;

typedef enum {
    taAddFirst,
    taAdd,
    taInsert,
} TAddMode;

typedef enum {
    msControlSelect,
    msShiftSelect,
    msVisibleOnly,
    msSiblingOnly,
} TMultiSelectStyles;

typedef TSet TMultiSelectStyle;

typedef enum {
    asNormal,
    asSuspended,
    asSuspendedEnabled,
} TActionListState;

typedef enum {
    gdHorizontal,
    gdVertical,
} TGradientDirection;

typedef enum {
    dSFocus,
    dSSelected,
    dSNormal,
    dSTransparent,
} TDrawingStyle;

typedef enum {
    itImage,
    itMask,
} TImageType;

typedef enum {
    rtBitmap,
    rtCursor,
    rtIcon,
} TResType;

typedef enum {
    lrDefaultColor,
    lrDefaultSize,
    lrFromFile,
    lrMap3DColors,
    lrTransparent,
    lrMonoChrome,
} TLoadResource;

typedef TSet TLoadResources;

typedef enum {
    cdDefault,
    cdDeviceDependent,
    cd4Bit,
    cd8Bit,
    cd16Bit,
    cd24Bit,
    cd32Bit,
} TColorDepth;

typedef enum {
    cbUnchecked,
    cbChecked,
    cbGrayed,
} TCheckBoxState;

typedef enum {
    tbsButton, // button (can be clicked)
    tbsCheck, // check item (click to toggle state, can be grouped)
    tbsDropDown, // button with dropdown button to show a popup menu
    tbsSeparator, // space holder
    tbsDivider, // space holder with line
    tbsButtonDrop, // button with arrow (not separated from each other)
} TToolButtonStyle;

typedef enum {
    gdoHotTrack,
    gdoGradient,
} TTBGradientDrawingOption;

typedef TSet TTBGradientDrawingOptions;

typedef enum {
    cdFullOpen,
    cdPreventFullOpen,
    cdShowHelp,
    cdSolidColor,
    cdAnyColor,
} TColorDialogOption;

typedef TSet TColorDialogOptions;

typedef enum {
    biSystemMenu,
    biMinimize,
    biMaximize,
    biHelp,
} TBorderIcon;

typedef TSet TBorderIcons;

typedef enum {
    fdAnsiOnly,
    fdTrueTypeOnly,
    fdEffects,
    fdFixedPitchOnly,
    fdForceFontExist,
    fdNoFaceSel,
    fdNoOEMFonts,
    fdNoSimulations,
    fdNoSizeSel,
    fdNoStyleSel,
    fdNoVectorFonts,
    fdShowHelp,
    fdWysiwyg,
    fdLimitSize,
    fdScalableOnly,
    fdApplyButton,
} TFontDialogOption;

typedef TSet TFontDialogOptions;

typedef enum {
    ofReadOnly,
    ofOverwritePrompt, // if selected file exists shows a message, that file
    ofHideReadOnly, // hide read only file
    ofNoChangeDir, // do not change current directory
    ofShowHelp, // show a help button
    ofNoValidate,
    ofAllowMultiSelect, // allow multiselection
    ofExtensionDifferent,
    ofPathMustExist, // shows an error message if selected path does not exist
    ofFileMustExist, // shows an error message if selected file does not exist
    ofCreatePrompt,
    ofShareAware,
    ofNoReadOnlyReturn, // do not return filenames that are readonly
    ofNoTestFileCreate,
    ofNoNetworkButton,
    ofNoLongNames,
    ofOldStyleDialog,
    ofNoDereferenceLinks, // do not resolve links while dialog is shown (only on Windows, see OFN_NODEREFERENCELINKS)
    ofNoResolveLinks, // do not resolve links after Execute
    ofEnableIncludeNotify,
    ofEnableSizing, // dialog can be resized, e.g. via the mouse
    ofDontAddToRecent, // do not add the path to the history list
    ofForceShowHidden, // show hidden files
    ofViewDetail, // details are OS and interface dependent
    ofAutoPreview, // details are OS and interface dependent
} TOpenOption;

typedef TSet TOpenOptions;

typedef enum {
    ofExNoPlacesBar,
} TOpenOptionEx;

typedef TSet TOpenOptionsEx;

typedef enum {
    prAllPages,
    prSelection,
    prPageNums,
    prCurrentPage,
} TPrintRange;

typedef enum {
    poPrintToFile,
    poPageNums,
    poSelection,
    poWarning,
    poHelp,
    poDisablePrintToFile,
    poBeforeBeginDoc,
} TPrintDialogOption;

typedef TSet TPrintDialogOptions;

typedef enum {
    psoDefaultMinMargins,
    psoDisableMargins,
    psoDisableOrientation,
    psoDisablePagePainting,
    psoDisablePaper,
    psoDisablePrinter,
    psoMargins,
    psoMinMargins,
    psoShowHelp,
    psoWarning,
    psoNoNetworkButton,
} TPageSetupDialogOption;

typedef TSet TPageSetupDialogOptions;

typedef enum {
    pkDotMatrix,
    pkHPPCL,
} TPrinterKind;

typedef enum {
    ptEnvelope,
    ptPaper,
} TPageType;

typedef enum {
    pmDefault,
    pmMillimeters,
    pmInches,
} TPageMeasureUnits;

typedef enum {
    soStrictDelimiter,
    soWriteBOM,
    soTrailingLineBreak,
    soUseLocale,
} TStringsOption;

typedef TSet TStringsOptions;

typedef enum {
    ssShift,
    ssAlt,
    ssCtrl,
    ssLeft,
    ssRight,
    ssMiddle,
    ssDouble,
    ssMeta,
    ssSuper,
    ssHyper,
    ssAltGr,
    ssCaps,
    ssNum,
    ssScroll,
    ssTriple,
    ssQuad,
    ssExtra1,
    ssExtra2,
} TShiftStateEnum;

typedef TSet TShiftState;

typedef enum {
    mbLeft,
    mbRight,
    mbMiddle,
    mbExtra1,
    mbExtra2,
} TMouseButton;

typedef enum {
    fsSurface,
    fsBorder,
} TFillStyle;

typedef enum {
    fmAlternate,
    fmWinding,
} TFillMode;

typedef enum {
    csHandleValid,
    csFontValid,
    csPenValid,
    csBrushValid,
    csRegionValid,
} TCanvasStates;

typedef TSet TCanvasState;

typedef enum {
    coLeftToRight,
    coRightToLeft,
} TCanvasOrientation;

typedef enum {
    tfBottom,
    tfCalcRect,
    tfCenter,
    tfEditControl,
    tfEndEllipsis,
    tfPathEllipsis,
    tfExpandTabs,
    tfExternalLeading,
    tfLeft,
    tfModifyString,
    tfNoClip,
    tfNoPrefix,
    tfRight,
    tfRtlReading,
    tfSingleLine,
    tfTop,
    tfVerticalCenter,
    tfWordBreak,
    tfHidePrefix,
    tfNoFullWidthCharBreak,
    tfPrefixOnly,
    tfTabStop,
    tfWordEllipsis,
    tfComposited,
} TTextFormats;

typedef TSet TTextFormat;

typedef enum {
    bvNone,
    bvLowered,
    bvRaised,
    bvSpace,
} TBevelCut;

typedef enum {
    beLeft,
    beTop,
    beRight,
    beBottom,
} TBevelEdge;

typedef TSet TBevelEdges;

typedef enum {
    bkNone,
    bkTile,
    bkSoft,
    bkFlat,
} TBevelKind;

typedef enum {
    tmBottomRight,
    tmTopLeft,
    tmBoth,
} TTickMark;

typedef enum {
    tsNone,
    tsAuto,
    tsManual,
} TTickStyle;

typedef enum {
    ptNone,
    ptTop,
    ptLeft,
    ptBottom,
    ptRight,
} TPositionToolTip;

typedef enum {
    dtkDate,
    dtkTime,
    dtkDateTime,
} TDateTimeKind;

typedef enum {
    dmComboBox,
    dmUpDown,
    dmNone,
} TDTDateMode;

typedef enum {
    dfShort,
    dfLong,
} TDTDateFormat;

typedef enum {
    dtaLeft,
    dtaRight,
    dtaDefault,
} TDTCalAlignment;

typedef enum {
    dowMonday,
    dowTuesday,
    dowWednesday,
    dowThursday,
    dowFriday,
    dowSaturday,
    dowSunday,
    dowLocaleDefault,
} TCalDayOfWeek;

typedef enum {
    stWholeWord,
    stMatchCase,
} TSearchType;

typedef TSet TSearchTypes;

typedef enum {
    nsNone,
    nsBullte,
} TNumberingStyle;

typedef enum {
    atSelected,
    atDefaultText,
} TAttributeType;

typedef enum {
    caBold,
    caColor,
    caFace,
    caItalic,
    caSize,
    caStrikeOut,
    caUnderline,
    caProtected,
} TConsistentAttribute;

typedef TSet TConsistentAttributes;

typedef enum {
    iaTop,
    iaLeft,
} TIconArrangement;

typedef enum {
    hsGradient,
    hsImage,
    hsThemed,
} THeaderStyle;

typedef enum {
    iiaLeft,
    iiaRight,
    iiaTop,
    iiaBottom,
    iiaCenter,
} TImageAlignment;

typedef enum {
    akTop,
    akLeft,
    akRight,
    akBottom,
} TAnchorKind;

typedef TSet TAnchors;

typedef enum {
    odSelected,
    odGrayed,
    odDisabled,
    odChecked,
    odFocused,
    odDefault,
    odHotLight,
    odInactive,
    odNoAccel,
    odNoFocusRect,
    odReserved1,
    odReserved2,
    odComboBoxEdit,
    odBackgroundPainted, // item background already painted
} TOwnerDrawStateType;

typedef TSet TOwnerDrawState;

typedef enum {
    bkCustom,
    bkOK,
    bkCancel,
    bkHelp,
    bkYes,
    bkNo,
    bkClose,
    bkAbort,
    bkRetry,
    bkIgnore,
    bkAll,
    bkNoToAll,
    bkYesToAll,
} TBitBtnKind;

typedef enum {
    sbHorizontal,
    sbVertical,
} TScrollBarKind;

typedef enum {
    ssRegular,
    ssFlat,
    ssHotTrack,
} TScrollBarStyle;

typedef enum {
    stRectangle,
    stSquare,
    stRoundRect,
    stRoundSquare,
    stEllipse,
    stCircle,
    stSquaredDiamond,
    stDiamond,
    stTriangle,
    stTriangleLeft,
    stTriangleRight,
    stTriangleDown,
    stStar,
    stStarDown,
} TShapeType;

typedef enum {
    bsBox,
    bsFrame,
    bsTopLine,
    bsBottomLine,
    bsLeftLine,
    bsRightLine,
    bsSpacer,
} TBevelShape;

typedef enum {
    gkText,
    gkHorizontalBar,
    gkVerticalBar,
    gkPie,
    gkNeedle,
    gkHalfPie,
} TGaugeKind;

typedef enum {
    dtControl,
    dtItem,
    dtSubItem,
} TCustomDrawTarget;

typedef enum {
    cdPrePaint,
    cdPostPaint,
    cdPreErase,
    cdPostErase,
} TCustomDrawStage;

typedef enum {
    cdsSelected,
    cdsGrayed,
    cdsDisabled,
    cdsChecked,
    cdsFocused,
    cdsDefault,
    cdsHot,
    cdsMarked,
    cdsIndeterminate,
} TCustomDrawStateFlag;

typedef TSet TCustomDrawState;

typedef enum {
    drBounds,
    drIcon,
    drLabel,
    drSelectBounds,
} TDisplayCode;

typedef enum {
    sdAllowCreate,
    sdPerformCreate,
    sdPrompt,
} TSelectDirOpt;

typedef TSet TSelectDirOpts;

typedef enum {
    frDown,
    frFindNext,
    frHideMatchCase,
    frHideWholeWord,
    frHideUpDown,
    frMatchCase,
    frDisableMatchCase,
    frDisableUpDown,
    frDisableWholeWord,
    frReplace,
    frReplaceAll,
    frWholeWord,
    frShowHelp,
    frEntireScope,
    frHideEntireScope,
    frPromptOnReplace,
    frHidePromptOnReplace,
    frButtonsAtBottom,
} TFindOption;

typedef TSet TFindOptions;

typedef enum {
    dmManual,
    dmAutomatic,
} TDragMode;

typedef enum {
    dsDragEnter,
    dsDragLeave,
    dsDragMove,
} TDragState;

typedef enum {
    dkDrag,
    dkDock,
} TDragKind;

typedef enum {
    ecNormal,
    ecUpperCase,
    ecLowerCase,
} TEditCharCase;

typedef enum {
    ebLeft,
    ebTop,
    ebRight,
    ebBottom,
} TEdgeBorder;

typedef TSet TEdgeBorders;

typedef enum {
    esNone,
    esRaised,
    esLowered,
} TEdgeStyle;

typedef enum {
    gdsClassic,
    gdsThemed,
    gdsGradient,
} TGridDrawingStyle;

typedef enum {
    goFixedVertLine,
    goFixedHorzLine,
    goVertLine,
    goHorzLine,
    goRangeSelect,
    goDrawFocusSelected,
    goRowSizing,
    goColSizing,
    goRowMoving,
    goColMoving,
    goEditing,
    goAutoAddRows,
    goTabs,
    goRowSelect,
    goAlwaysShowEditor,
    goThumbTracking,
    goColSpanning, // Enable cellextent calcs
    goRelaxedRowSelect, // User can see focused cell on goRowSelect
    goDblClickAutoSize, // dblclicking columns borders (on hdrs) resize col.
    goSmoothScroll, // Switch scrolling mode (pixel scroll is by default)
    goFixedRowNumbering, // Ya
    goScrollKeepVisible, // keeps focused cell visible while scrolling
    goHeaderHotTracking, // Header cells change look when mouse is over them
    goHeaderPushedLook, // Header cells looks pushed when clicked
    goSelectionActive, // Setting grid.Selection moves also cell cursor
    goFixedColSizing, // Allow to resize fixed columns
    goDontScrollPartCell, // clicking partially visible cells will not scroll
    goCellHints, // show individual cell hints
    goTruncCellHints, // show cell hints if cell text is too long
    goCellEllipsis, // show "..." if cell text is too long
    goAutoAddRowsSkipContentCheck, // BB Also add a row (if AutoAddRows in Options) if last row is empty
    goRowHighlight, // Highlight the current Row
} TGridOption;

typedef TSet TGridOptions;

typedef enum {
    gdSelected,
    gdFocused,
    gdFixed,
    gdHot,
    gdPushed,
    gdRowHighlight,
} TGridDrawStates;

typedef TSet TGridDrawState;

typedef enum {
    hsText,
    hsOwnerDraw,
} THeaderSectionStyle;

typedef enum {
    lpAbove,
    lpBelow,
    lpLeft,
    lpRight,
} TLabelPosition;

typedef enum {
    fsLeftRightTopBottom,
    fsRightLeftTopBottom,
    fsLeftRightBottomTop,
    fsRightLeftBottomTop,
    fsTopBottomLeftRight,
    fsBottomTopLeftRight,
    fsTopBottomRightLeft,
    fsBottomTopRightLeft,
} TFlowStyle;

typedef enum {
    bmNone,
    bmClick,
    bmDblClick,
} TCoolBandMaximize;

typedef enum {
    mbNone,
    mbBreak,
    mbBarBreak,
} TMenuBreak;

typedef enum {
    tsTrackBegin,
    tsTrackMove,
    tsTrackEnd,
} TSectionTrackState;

typedef enum {
    csLButtonDown,
    csClicked,
    csPalette,
    csReadingState,
    csFocusing,
    csCreating, // not used, exists for Delphi compatibility
    csPaintCopy,
    csCustomPaint,
    csDestroyingHandle,
    csDocking,
    csVisibleSetInLoading,
} TControlStateType;

typedef TSet TControlState;

typedef enum {
    csAcceptsControls, // can have children in the designer
    csCaptureMouse, // auto capture mouse when clicked
    csDesignInteractive, // wants mouse events in design mode
    csClickEvents, // handles mouse events
    csFramed, // not implemented, has 3d frame
    csSetCaption, // if Name=Caption, changing the Name changes the Caption
    csOpaque, // the control paints its area completely
    csDoubleClicks, // understands mouse double clicks
    csTripleClicks, // understands mouse triple clicks
    csQuadClicks, // understands mouse quad clicks
    csFixedWidth, // cannot change its width
    csFixedHeight, // cannot change its height (for example combobox)
    csNoDesignVisible, // is invisible in the designer
    csReplicatable, // PaintTo works
    csNoStdEvents, // standard events such as mouse, key, and click events are ignored.
    csDisplayDragImage, // display images from dragimagelist during drag operation over control
    csReflector, // not implemented, the controls respond to size, focus and dlg messages - it can be used as ActiveX control under Windows
    csActionClient, // Action is set
    csMenuEvents, // not implemented
    csNoFocus, // control will not take focus when clicked with mouse.
    csNeedsBorderPaint, // not implemented
    csParentBackground, // tells WinXP to paint the theme background of parent on controls background
    csDesignNoSmoothResize, // when resizing control in the designer do not SetBounds while dragging
    csDesignFixedBounds, // can not be moved nor resized in designer
    csHasDefaultAction, // implements useful ExecuteDefaultAction
    csHasCancelAction, // implements useful ExecuteCancelAction
    csNoDesignSelectable, // can not be selected at design time
    csOwnedChildrenNotSelectable, // child controls owned by this control are NOT selectable in the designer
    csAutoSize0x0, // if the preferred size is 0x0 then control is shrinked ot 0x0
    csAutoSizeKeepChildLeft, // when AutoSize=true do not move children horizontally
    csAutoSizeKeepChildTop, // when AutoSize=true do not move children vertically
    csRequiresKeyboardInput, // If the device has no physical keyboard then show the virtual keyboard when this control gets focus (therefore available only to TWinControl descendents)
} TControlStyleType;

typedef TSet TControlStyle;

typedef enum {
    maDefault,
    maActivate,
    maActivateAndEat,
    maNoActivate,
    maNoActivateAndEat,
} TMouseActivate;

typedef enum {
    none,
    indeterminate,
    normal,
    error,
    paused,
} TTaskBarProgressState;

typedef enum {
    bmDIB,
    bmDDB,
} TBitmapHandleType;

typedef enum {
    psNoDefine,
    psReady,
    psPrinting,
    psStopped,
} TPrinterState;

typedef enum {
    poPortrait,
    poLandscape,
    poReverseLandscape,
    poReversePortrait,
} TPrinterOrientation;

typedef enum {
    pcCopies,
    pcOrientation,
    pcCollation,
} TPrinterCapability;

typedef TSet TPrinterCapabilities;

typedef enum {
    ptLocal,
    ptNetWork,
} TPrinterType;

typedef enum {
    rsUninitialized,
    rsLoading,
    rsLoaded,
    rsInterActive,
    rsComplete,
} TReadyState;

typedef enum {
    seUnknown,
    seANSI,
    seUnicode,
    seUTF8,
} TStringEncoding;

typedef enum {
    stDefault, // use default rules for showing taskbar item
    stAlways, // always show taskbar item for the form
    stNever, // never show taskbar item for the form
} TShowInTaskbar;

typedef enum {
    tcbOk,
    tcbYes,
    tcbNo,
    tcbCancel,
    tcbRetry,
    tcbClose,
} TTaskDialogCommonButton;

typedef TSet TTaskDialogCommonButtons;

typedef enum {
    tfEnableHyperlinks,
    tfUseHiconMain,
    tfUseHiconFooter,
    tfAllowDialogCancellation,
    tfUseCommandLinks,
    tfUseCommandLinksNoIcon,
    tfExpandFooterArea,
    tfExpandedByDefault,
    tfVerificationFlagChecked,
    tfShowProgressBar,
    tfShowMarqueeProgressBar,
    tfCallbackTimer,
    tfPositionRelativeToWindow,
    tfRtlLayout,
    tfNoDefaultRadioButton,
    tfCanBeMinimized,
} TTaskDialogFlag;

typedef TSet TTaskDialogFlags;

typedef enum {
    tdiNone,
    tdiWarning,
    tdiError,
    tdiInformation,
    tdiShield,
    tdiQuestion,
} TTaskDialogIcon;

typedef enum {
    csExDropDown,
    csExSimple,
    csExDropDownList,
} TComboBoxExStyle;

typedef enum {
    csExCaseSensitive,
    csExNoEditImage,
    csExNoEditImageIndent,
    csExNoSizeLimit,
    csExPathWordBreak,
} TComboBoxExStyleEx;

typedef TSet TComboBoxExStyles;

typedef enum {
    acoAutoSuggest,
    acoAutoAppend,
    acoSearch,
    acoFilterPrefixes,
    acoUseTab,
    acoUpDownKeyDropsList,
    acoRtlReading,
} TAutoCompleteOption;

typedef TSet TAutoCompleteOptions;

typedef enum {
    dmDesktop,
    dmPrimary,
    dmMainForm,
    dmActiveForm,
} TDefaultMonitor;

typedef enum {
    tmAuto,
    tmFixed,
} TTransparentMode;

typedef enum {
    dimNormal,
    dimCenter,
    dimStretch,
} TDrawImageMode;

typedef enum {
    lboDrawFocusRect, // draw focus rect in case of owner drawing
} TListBoxOption;

typedef TSet TListBoxOptions;

typedef enum {
    amDontCare, // default antialiasing
    amOn, // enabled
    amOff, // disabled
} TAntialiasingMode;

typedef enum {
    sdAscending,
    sdDescending,
} TSortDirection;

typedef enum {
    tvestTheme, // use themed sign
    tvestPlusMinus, // use +/- sign
    tvestArrow, // use blank arrow
    tvestArrowFill, // use filled arrow
} TTreeViewExpandSignType;

typedef enum {
    tvoAllowMultiselect,
    tvoAutoExpand,
    tvoAutoInsertMark,
    tvoAutoItemHeight,
    tvoHideSelection,
    tvoHotTrack,
    tvoKeepCollapsedNodes,
    tvoReadOnly,
    tvoRightClickSelect,
    tvoRowSelect,
    tvoShowButtons,
    tvoShowLines,
    tvoShowRoot,
    tvoShowSeparators,
    tvoToolTips,
    tvoNoDoubleClickExpand,
    tvoThemedDraw,
} TTreeViewOption;

typedef TSet TTreeViewOptions;

typedef enum {
    gsmAlways, // always show
    gsmNever, // never show
    gsmApplication, // depends on application settings
    gsmSystem, // depends on system settings
} TGlyphShowMode;

typedef enum {
    nboShowCloseButtons,
    nboMultiLine,
    nboHidePageListPopup,
    nboKeyboardTabSwitch,
    nboShowAddTabButton,
    nboDoChangeOnSetIndex,
} TCTabControlOption;

typedef TSet TCTabControlOptions;

typedef enum {
    asrTop,
    asrBottom,
    asrCenter,
} TAnchorSideReference;

typedef enum {
    ccaFill,
    ccaLeftTop,
    ccaRightBottom,
    ccaCenter,
} TControlCellAlign;

typedef TSet TControlCellAligns;

typedef enum {
    crsAnchorAligning, // (like Delphi)
    crsScaleChilds, // scale children equally, keep space between children fixed
    crsHomogenousChildResize, // enlarge children equally (i.e. by the same amount of pixel)
    crsHomogenousSpaceResize, // enlarge space between children equally
} TChildControlResizeStyle;

typedef enum {
    cclNone,
    cclLeftToRightThenTopToBottom, // if BiDiMode <> bdLeftToRight then it becomes RightToLeft
    cclTopToBottomThenLeftToRight,
} TControlChildrenLayout;

typedef enum {
    clHorizontalThenVertical,
    clVerticalThenHorizontal,
} TColumnLayout;

typedef enum {
    siNone,
    siAscending,
    siDescending,
} TSortIndicator;

typedef enum {
    cbsAuto,
    cbsEllipsis,
    cbsNone,
    cbsPickList,
    cbsCheckboxColumn,
    cbsButton,
    cbsButtonColumn,
} TColumnButtonStyle;

typedef enum {
    gzNormal,
    gzFixedCols,
    gzFixedRows,
    gzFixedCells,
    gzInvalid,
} TGridZone;

typedef TSet TGridZoneSet;

typedef enum {
    soAscending,
    soDescending,
} TSortOrder;

typedef enum {
    aaNone,
    aaDown,
    aaRight,
    aaLeft,
    aaRightDown,
    aaLeftDown,
    aaRightUp,
    aaLeftUp,
} TAutoAdvance;

typedef enum {
    chpAll,
    chpAllNoDefault,
    chpTruncOnly,
} TCellHintPriority;

typedef enum {
    mwCursor,
    mwGrid,
} TMouseWheelOption;

typedef enum {
    goScrollToLastCol, // allow scrolling to last column (so that last column can be leftcol)
    goScrollToLastRow, // allow scrolling to last row (so that last row can be toprow)
} TGridOption2;

typedef TSet TGridOptions2;

typedef enum {
    rsmSingle,
    rsmMulti,
} TRangeSelectMode;

typedef enum {
    tsLazarus,
    tsStandard,
    tsNative,
} TTitleStyle;

typedef enum {
    poNone,
    poHeaderClick,
} TPrefixOption;

typedef enum {
    dsShowHeadings,
    dsShowDayNames,
    dsNoMonthChange,
    dsShowWeekNumbers,
    dsStartMonday,
} TDisplaySetting;

typedef enum {
    tf12, // 12 hours format, with am/pm string
    tf24, // 24 hours format
} TTimeFormat;

typedef enum {
    tdHM, // hour and minute
    tdHMS, // hour Minute and second
    tdHMSMs, // hour Minute Second and milisecond
} TTimeDisplay;

typedef enum {
    asClassicSmaller,
    asClassicLarger,
    asModernSmaller,
    asModernLarger,
    asYetAnotherShape,
    asTheme,
} TArrowShape;

typedef enum {
    ddoDMY,
    ddoMDY,
    ddoYMD,
    ddoTryDefault,
} TDateDisplayOrder;

typedef enum {
    dtpDay,
    dtpMonth,
    dtpYear,
    dtpHour,
    dtpMinute,
    dtpSecond,
    dtpMiliSec,
    dtpAMPM,
} TDateTimePart;

typedef TSet TDateTimeParts;

typedef enum {
    dtpoDoChangeOnSetDateTime,
    dtpoEnabledIfUnchecked,
    dtpoAutoCheck,
    dtpoFlatButton,
} TDateTimePickerOption;

typedef TSet TDateTimePickerOptions;

typedef enum {
    ioHorizontal,
    ioVertical,
} TImageOrientation;

typedef enum {
    lapDefault, // widgetset dependent
    lapFixedLayout, // A fixed absolute layout in all platforms
    lapAutoAdjustWithoutHorizontalScrolling, // Smartphone platforms use this one,
    lapAutoAdjustForDPI, // For desktops using High DPI, scale x and y to fit the DPI
} TLayoutAdjustmentPolicy;

typedef enum {
    htAbove,
    htBelow,
    htNowhere,
    htOnItem,
    htOnButton,
    htOnIcon,
    htOnIndent,
    htOnLabel,
    htOnRight,
    htOnStateIcon,
    htToLeft,
    htToRight,
} THitTest;

typedef TSet THitTests;

typedef enum {
    lisCut,
    lisDropTarget,
    lisFocused,
    lisSelected,
} TListItemState;

typedef TSet TListItemStates;

typedef enum {
    pcfText,
    pcfBitmap,
    pcfPixmap,
    pcfIcon,
    pcfPicture,
    pcfMetaFilePict,
    pcfObject,
    pcfComponent,
    pcfCustomData,
} TPredefinedClipboardFormat;

typedef enum {
    waAuto, // auto
    waForce, // always wrap after this control
    waAvoid, // try not to wrap after this control, if the control is already at the beginning of the row, wrap though
    waForbid, // never wrap after this control
} TWrapAfter;

typedef enum {
    gdeNormal, // no effect
    gdeDisabled, // grayed image
    gdeHighlighted, // a bit highlighted image
    gdeShadowed, // a bit shadowed image
    gde1Bit, // 1 Bit image (for non-XP windows buttons)
} TGraphicsDrawEffect;

/*--------------------类型定义--------------------*/

typedef struct TPoint {
    int32_t x;
    int32_t y;
} TPoint;

typedef struct TRect {
    int32_t left;
    int32_t top;
    int32_t right;
    int32_t bottom;
} TRect;

typedef struct TSize {
    int32_t cx;
    int32_t cy;
} TSize;

#ifndef _WIN32


typedef uintptr_t HWND;

typedef uintptr_t HBITMAP;

typedef uintptr_t HMENU;

typedef uintptr_t HICON;

typedef uintptr_t HDC;

typedef uintptr_t HFONT;

typedef uintptr_t HBRUSH;

typedef uintptr_t HPEN;

typedef uintptr_t HKEY;

typedef uintptr_t HMONITOR;

typedef uintptr_t HGDIOBJ;

typedef uintptr_t HMODULE;

typedef uint32_t COLORREF;

typedef uint32_t DWORD;

typedef HICON HCURSOR;

#endif


typedef uintptr_t HINST;

#ifndef _WIN32


typedef uintptr_t LPCWSTR;

typedef uintptr_t HRGN;

typedef uint32_t UINT;

typedef uintptr_t LPARAM;

typedef uintptr_t WPARAM;

typedef uintptr_t LRESULT;

#endif


typedef uintptr_t HResult;

#ifndef _WIN32


typedef uintptr_t HPALETTE;

typedef uintptr_t HRSRC;

typedef uintptr_t HGLOBAL;

#endif


typedef uintptr_t TFNWndEnumProc;

typedef uint64_t TXId;

typedef uint16_t ATOM;

typedef uint16_t TAtom;

typedef uintptr_t SIZE_T;

typedef uintptr_t DWORD_PTR;

typedef struct TUTF8Char {
    int8_t len;
    int8_t content[7];
} TUTF8Char;

typedef struct TMsg {
    HWND hwnd;
    uint32_t message;
    uintptr_t wParam;
    uintptr_t lParam;
    uint32_t time;
    TPoint pt;
} TMsg;

typedef struct TCursorInfo {
    uint32_t cbSize;
    uint32_t flags;
    HCURSOR hCursor;
    TPoint ptScreenPos;
} TCursorInfo;

typedef struct TWndClass {
    uint32_t style;
    uintptr_t lpfnWndProc;
    int32_t cbClsExtra;
    int32_t cbWndExtra;
    uintptr_t hInstance;
    HICON hIcon;
    HCURSOR hCursor;
    HBRUSH hbrBackground;
    LPCWSTR lpszMenuName;
    LPCWSTR lpszClassName;
} TWndClass;

typedef int32_t TModalResult;

typedef uint32_t TColor;

typedef uintptr_t THelpEventData;

typedef int16_t TTabOrder;

typedef uintptr_t PFNLVCOMPARE;

typedef uintptr_t PFNTVCOMPARE;

typedef int32_t Integer;

typedef uint32_t Cardinal;

typedef float Single;

typedef uint16_t Word;

typedef uint8_t Byte;

typedef uint8_t TFontCharset;

typedef int32_t TSpacingSize;

typedef uint16_t Char;

typedef uintptr_t TClass;

typedef uintptr_t TThreadID;

typedef uintptr_t TClipboardFormat;

typedef struct TGridCoord {
    int32_t x;
    int32_t y;
} TGridCoord;

typedef uintptr_t TCustomData;

typedef TRect TGridRect;

typedef uintptr_t IObjectArray;

typedef struct TSysLocale {
    int32_t defaultLCID;
    int32_t priLangID;
    int32_t subLangID;
    BOOL farEast;
    BOOL middleEast;
} TSysLocale;

typedef struct TSmallPoint {
    int16_t x;
    int16_t y;
} TSmallPoint;

typedef struct TGUID {
    uint32_t d1;
    uint16_t d2;
    uint16_t d3;
    uint8_t d4[8];
} TGUID;

typedef struct TLibResource {
    char* name;
    uintptr_t ptr;
} TLibResource;

typedef struct TResItem {
    uintptr_t name;
    uintptr_t value;
} TResItem;

typedef int32_t TConstraintSize;

typedef struct TAlignInfo {
    uintptr_t alignList;
    int32_t controlIndex;
    TAlign align;
    int32_t scratch;
} TAlignInfo;

typedef struct TCreateParams {
    LPCWSTR caption;
    uint32_t style;
    uint32_t exStyle;
    int32_t x;
    int32_t y;
    int32_t width;
    int32_t height;
    HWND wndParent;
    uintptr_t param;
    TWndClass windowClass;
    int8_t winClassName[64];
} TCreateParams;

typedef TBorderStyle TFormBorderStyle;

typedef int16_t TCursor;

typedef int32_t TLeftRight;

typedef TComboBoxStyle TColorBoxStyle;

typedef TAlignment TLinkAlignment;

typedef int32_t TNumGlyphs;

typedef TPixelFormat TJPEGPixelFormat;

typedef uint16_t TShortCut;

typedef int16_t TScrollBarInc;

typedef int32_t TBevelStyle;

typedef int32_t TLibType;

#if defined(_WIN64) || defined(__x86_64__)

typedef struct TDWordFiller {
    uint8_t filler[4];
} TDWordFiller;

typedef struct TWMKey {
    uint32_t msg;
    TDWordFiller msgFiller;
    uint16_t charCode[2];
    TDWordFiller charCodeUnusedFiller;
    uint32_t keyData;
    TDWordFiller keyDataFiller;
    uintptr_t result;
} TWMKey;

typedef struct TMessage {
    uint32_t msg;
    uint32_t _UnusedMsg;
    WPARAM wParam;
    LPARAM lParam;
    LRESULT result;
} TMessage;
#else

typedef struct TDWordFiller {
} TDWordFiller;

typedef struct TWMKey {
    uint32_t msg;
    TDWordFiller msgFiller;
    uint16_t charCode[2];
    TDWordFiller charCodeUnusedFiller;
    uint32_t keyData;
    TDWordFiller keyDataFiller;
    uintptr_t result;
} TWMKey;

typedef struct TMessage {
    uint32_t msg;
    WPARAM wParam;
    LPARAM lParam;
    LRESULT result;
} TMessage;
#endif


/*--------------------类的定义--------------------*/
typedef void* TObject;
typedef void* TComponent;
typedef void* TControl;
typedef void* TWinControl;
typedef void* TGraphic;
typedef void* TStrings;
typedef void* TStream;
typedef void* TCheckBox;
typedef void* TRadioButton;
typedef void* TGroupBox;
typedef void* TLabel;
typedef void* TListBox;
typedef void* TComboBox;
typedef void* TPanel;
typedef void* TImage;
typedef void* TLinkLabel;
typedef void* TSpeedButton;
typedef void* TSplitter;
typedef void* TRadioGroup;
typedef void* TStaticText;
typedef void* TColorBox;
typedef void* TColorListBox;
typedef void* TTrayIcon;
typedef void* TOpenDialog;
typedef void* TSaveDialog;
typedef void* TColorDialog;
typedef void* TFontDialog;
typedef void* TPrintDialog;
typedef void* TOpenPictureDialog;
typedef void* TSavePictureDialog;
typedef void* TSelectDirectoryDialog;
typedef void* TRichEdit;
typedef void* TTrackBar;
typedef void* TImageList;
typedef void* TUpDown;
typedef void* TProgressBar;
typedef void* TDateTimePicker;
typedef void* TMonthCalendar;
typedef void* TListView;
typedef void* TTreeView;
typedef void* TStatusBar;
typedef void* TToolBar;
typedef void* TBitBtn;
typedef void* TIcon;
typedef void* TBitmap;
typedef void* TMemo;
typedef void* TMemoryStream;
typedef void* TFont;
typedef void* TPopupMenu;
typedef void* TStringList;
typedef void* TBrush;
typedef void* TPen;
typedef void* TMenuItem;
typedef void* TPicture;
typedef void* TListColumns;
typedef void* TListItems;
typedef void* TTreeNodes;
typedef void* TListItem;
typedef void* TTreeNode;
typedef void* TPageControl;
typedef void* TTabSheet;
typedef void* TButton;
typedef void* TEdit;
typedef void* TScreen;
typedef void* TMouse;
typedef void* TListColumn;
typedef void* TCollectionItem;
typedef void* TStatusPanels;
typedef void* TStatusPanel;
typedef void* TSpinEdit;
typedef void* TFloatSpinEdit;
typedef void* TDirectoryEdit;
typedef void* TColorButton;
typedef void* TMiniWebview;
typedef void* TCanvas;
typedef void* TApplication;
typedef void* TMainMenu;
typedef void* TPngImage;
typedef void* TJPEGImage;
typedef void* TGIFImage;
typedef void* TActionList;
typedef void* TAction;
typedef void* TToolButton;
typedef void* TIniFile;
typedef void* TRegistry;
typedef void* TClipboard;
typedef void* TMonitor;
typedef void* TPaintBox;
typedef void* TTimer;
typedef void* TList;
typedef void* TForm;
typedef void* TParaAttributes;
typedef void* TTextAttributes;
typedef void* TIconOptions;
typedef void* Exception;
typedef void* TScrollBar;
typedef void* TMaskEdit;
typedef void* TShape;
typedef void* TBevel;
typedef void* TScrollBox;
typedef void* TCheckListBox;
typedef void* TGauge;
typedef void* TImageButton;
typedef void* TFindDialog;
typedef void* TReplaceDialog;
typedef void* TPrinterSetupDialog;
typedef void* TPageSetupDialog;
typedef void* TDragObject;
typedef void* TDragDockObject;
typedef void* TStringGrid;
typedef void* TDrawGrid;
typedef void* TValueListEditor;
typedef void* THeaderControl;
typedef void* THeaderSection;
typedef void* THeaderSections;
typedef void* TLabeledEdit;
typedef void* TBoundLabel;
typedef void* TFlowPanel;
typedef void* TFlowPanelControlList;
typedef void* TFlowPanelControl;
typedef void* TCoolBar;
typedef void* TCoolBands;
typedef void* TCoolBand;
typedef void* TCollection;
typedef void* TPrinter;
typedef void* TTaskDialog;
typedef void* TTaskDialogButtons;
typedef void* TTaskDialogButtonItem;
typedef void* TTaskDialogRadioButtonItem;
typedef void* TTaskDialogBaseButtonItem;
typedef void* TComboBoxEx;
typedef void* TComboExItems;
typedef void* TComboExItem;
typedef void* TFrame;
typedef void* TControlScrollBar;
typedef void* TSizeConstraints;
typedef void* TXButton;
typedef void* TAnchorSide;
typedef void* TControlBorderSpacing;
typedef void* TControlChildSizing;
typedef void* TCheckGroup;
typedef void* TToggleBox;
typedef void* TCheckComboBox;
typedef void* TGridColumnTitle;
typedef void* TGridColumn;
typedef void* TGridColumns;

/*--------------------事件定义--------------------*/
// void (TObject sender)
typedef void(*TNotifyEvent)(TObject);

// void (TObject sender, TUDBtnType button)
typedef void(*TUDClickEvent)(TObject, TUDBtnType);

// void (TObject sender, TCloseAction* action)
typedef void(*TCloseEvent)(TObject, TCloseAction*);

// void (TObject sender, BOOL* canClose)
typedef void(*TCloseQueryEvent)(TObject, BOOL*);

// void (TObject sender, TMenuItem source, BOOL rebuild)
typedef void(*TMenuChangeEvent)(TObject, TMenuItem, BOOL);

// void (TObject sender, char* link, TSysLinkType linkType)
typedef void(*TSysLinkEvent)(TObject, char*, TSysLinkType);

// void (TObject sender, Exception e)
typedef void(*TExceptionEvent)(TObject, Exception);

// void (TObject sender, Char* key, TShiftState shift)
typedef void(*TKeyEvent)(TObject, Char*, TShiftState);

// void (TObject sender, Char* key)
typedef void(*TKeyPressEvent)(TObject, Char*);

// void (TObject sender, TMouseButton button, TShiftState shift, int32_t x, int32_t y)
typedef void(*TMouseEvent)(TObject, TMouseButton, TShiftState, int32_t, int32_t);

// void (TObject sender, TShiftState shift, int32_t x, int32_t y)
typedef void(*TMouseMoveEvent)(TObject, TShiftState, int32_t, int32_t);

// void (TObject sender, TShiftState shift, int32_t wheelDelta, int32_t x, int32_t y, BOOL* handled)
typedef void(*TMouseWheelEvent)(TObject, TShiftState, int32_t, int32_t, int32_t, BOOL*);

// void (TWinControl control, int32_t index, TRect* aRect, TOwnerDrawState state)
typedef void(*TDrawItemEvent)(TWinControl, int32_t, TRect*, TOwnerDrawState);

// void (TObject sender, TListColumn column)
typedef void(*TLVColumnClickEvent)(TObject, TListColumn);

// void (TObject sender, TListColumn column, TPoint* point)
typedef void(*TLVColumnRClickEvent)(TObject, TListColumn, TPoint*);

// void (TObject sender, TListItem item, BOOL selected)
typedef void(*TLVSelectItemEvent)(TObject, TListItem, BOOL);

// void (TObject sender, TListItem item)
typedef void(*TLVCheckedItemEvent)(TObject, TListItem);

// void (TObject sender, TListItem item1, TListItem item2, int32_t data, int32_t* compare)
typedef void(*TLVCompareEvent)(TObject, TListItem, TListItem, int32_t, int32_t*);

// void (TObject sender, TListItem item, TItemChange change)
typedef void(*TLVChangeEvent)(TObject, TListItem, TItemChange);

// void (TObject sender, TListItem item)
typedef void(*TLVNotifyEvent)(TObject, TListItem);

// void (TListView sender, TRect* aRect, TCustomDrawStage stage, BOOL* defaultDraw)
typedef void(*TLVAdvancedCustomDrawEvent)(TListView, TRect*, TCustomDrawStage, BOOL*);

// void (TListView sender, TListItem item, TCustomDrawState state, TCustomDrawStage Stage, BOOL* defaultDraw)
typedef void(*TLVAdvancedCustomDrawItemEvent)(TListView, TListItem, TCustomDrawState, TCustomDrawStage, BOOL*);

// void (TListView sender, TListItem item, int32_t subItem, TCustomDrawState state, TCustomDrawStage stage, BOOL* defaultDraw)
typedef void(*TLVAdvancedCustomDrawSubItemEvent)(TListView, TListItem, int32_t, TCustomDrawState, TCustomDrawStage, BOOL*);

// void (TObject sender, TTreeNode node1, TTreeNode node2, int32_t data, int32_t* compare)
typedef void(*TTVCompareEvent)(TObject, TTreeNode, TTreeNode, int32_t, int32_t*);

// void (TObject sender, TTreeNode node)
typedef void(*TTVExpandedEvent)(TObject, TTreeNode);

// void (TObject sender, TTreeNode node)
typedef void(*TTVChangedEvent)(TObject, TTreeNode);

// void (TTreeView sender, TRect* aRect, TCustomDrawStage stage, BOOL* defaultDraw)
typedef void(*TTVAdvancedCustomDrawEvent)(TTreeView, TRect*, TCustomDrawStage, BOOL*);

// void (TTreeView sender, TTreeNode node, TCustomDrawState state, TCustomDrawStage stage, BOOL* paintImages, BOOL* defaultDraw)
typedef void(*TTVAdvancedCustomDrawItemEvent)(TTreeView, TTreeNode, TCustomDrawState, TCustomDrawStage, BOOL*, BOOL*);

// void (TObject sender, int32_t tabIndex, int32_t* imageIndex)
typedef void(*TTabGetImageEvent)(TObject, int32_t, int32_t*);

// void (TToolBar sender, TRect* aRect, TCustomDrawStage stage, BOOL* defaultDraw)
typedef void(*TTBAdvancedCustomDrawEvent)(TToolBar, TRect*, TCustomDrawStage, BOOL*);

// void ()
typedef void(*TThreadProc)();

// void (TObject sender, void* aFileNames, intptr_t len)
typedef void(*TDropFilesEvent)(TObject, void*, intptr_t);

// void (TObject sender, int32_t* minWidth, int32_t* minHeight, int32_t* maxWidth, int32_t* maxHeight)
typedef void(*TConstrainedResizeEvent)(TObject, int32_t*, int32_t*, int32_t*, int32_t*);

// void (uint16_t command, THelpEventData data, BOOL* callHelp, BOOL* result)
typedef void(*THelpEvent)(uint16_t, THelpEventData, BOOL*, BOOL*);

// void (TWMKey* msg, BOOL* handled)
typedef void(*TShortCutEvent)(TWMKey*, BOOL*);

// void (TObject sender, TPoint* mousePos, BOOL* handled)
typedef void(*TContextPopupEvent)(TObject, TPoint*, BOOL*);

// void (TObject sender, TObject source, int32_t x, int32_t y, TDragState state, BOOL* accept)
typedef void(*TDragOverEvent)(TObject, TObject, int32_t, int32_t, TDragState, BOOL*);

// void (TObject sender, TObject source, int32_t x, int32_t y)
typedef void(*TDragDropEvent)(TObject, TObject, int32_t, int32_t);

// void (TObject sender, TObject target, int32_t x, int32_t y)
typedef void(*TEndDragEvent)(TObject, TObject, int32_t, int32_t);

// void (TObject sender, TDragDockObject source, int32_t x, int32_t y)
typedef void(*TDockDropEvent)(TObject, TDragDockObject, int32_t, int32_t);

// void (TObject sender, TDragDockObject source, int32_t x, int32_t y, TDragState state, BOOL* accept)
typedef void(*TDockOverEvent)(TObject, TDragDockObject, int32_t, int32_t, TDragState, BOOL*);

// void (TObject sender, TControl client, TControl newTarget, BOOL* allow)
typedef void(*TUnDockEvent)(TObject, TControl, TControl, BOOL*);

// void (TObject sender, TDragDockObject* dragObject)
typedef void(*TStartDockEvent)(TObject, TDragDockObject*);

// void (TObject sender, TControl dockClient, TRect* influenceRect, TPoint* mousePos, BOOL* canDock)
typedef void(*TGetSiteInfoEvent)(TObject, TControl, TRect*, TPoint*, BOOL*);

// void (TObject sender, TShiftState shift, TPoint* mousePos, BOOL* handled)
typedef void(*TMouseWheelUpDownEvent)(TObject, TShiftState, TPoint*, BOOL*);

// void (TObject sender, BOOL isColumn, int32_t sIndex, int32_t tIndex)
typedef void(*TGridOperationEvent)(TObject, BOOL, int32_t, int32_t);

// void (TObject sender, int32_t aCol, int32_t aRow, TRect* aRect, TGridDrawState state)
typedef void(*TDrawCellEvent)(TObject, int32_t, int32_t, TRect*, TGridDrawState);

// void (TObject sender, int32_t aCol, int32_t aRow)
typedef void(*TFixedCellClickEvent)(TObject, int32_t, int32_t);

// void (TObject sender, int32_t aCol, int32_t aRow, char** value)
typedef void(*TGetEditEvent)(TObject, int32_t, int32_t, char**);

// void (TObject sender, int32_t aCol, int32_t aRow, BOOL* canSelect)
typedef void(*TSelectCellEvent)(TObject, int32_t, int32_t, BOOL*);

// void (TObject sender, int32_t aCol, int32_t aRow, char* value)
typedef void(*TSetEditEvent)(TObject, int32_t, int32_t, char*);

// void (THeaderControl headerControl, THeaderSection section, TRect* aRect, BOOL pressed)
typedef void(*TDrawSectionEvent)(THeaderControl, THeaderSection, TRect*, BOOL);

// void (THeaderControl headerControl, THeaderSection section)
typedef void(*TSectionNotifyEvent)(THeaderControl, THeaderSection);

// void (THeaderControl headerControl, THeaderSection section, int32_t width, TSectionTrackState state)
typedef void(*TSectionTrackEvent)(THeaderControl, THeaderSection, int32_t, TSectionTrackState);

// void (TObject sender, THeaderSection fromSection, THeaderSection toSection, BOOL* allowDrag)
typedef void(*TSectionDragEvent)(TObject, THeaderSection, THeaderSection, BOOL*);

// void (THeaderControl headerControl, THeaderSection section)
typedef void(*TCustomSectionNotifyEvent)(THeaderControl, THeaderSection);

// void (TObject sender, TMouseButton button, TShiftState shift, int32_t x, int32_t y, int32_t hitTest, TMouseActivate* mouseActivate)
typedef void(*TMouseActivateEvent)(TObject, TMouseButton, TShiftState, int32_t, int32_t, int32_t, TMouseActivate*);

// void (TWinControl control, int32_t index, char** data)
typedef void(*TLBGetDataEvent)(TWinControl, int32_t, char**);

// void (TWinControl control, int32_t index, TObject dataObject)
typedef void(*TLBGetDataObjectEvent)(TWinControl, int32_t, TObject);

// void (TWinControl control, char* findString, int32_t result)
typedef void(*TLBFindDataEvent)(TWinControl, char*, int32_t);

// void (TWinControl control, int32_t index, int32_t* height)
typedef void(*TMeasureItemEvent)(TWinControl, int32_t, int32_t*);

// void (TObject sender, TListItem item, TItemChange change, BOOL* allowChange)
typedef void(*TLVChangingEvent)(TObject, TListItem, TItemChange, BOOL*);

// void (TObject sender, TListItem item)
typedef void(*TLVDataEvent)(TObject, TListItem);

// void (TObject sender, TItemFind find, char* findString, TPoint* findPosition, TCustomData findData, int32_t startIndex, TSearchDirection direction, BOOL warp, int32_t* index)
typedef void(*TLVDataFindEvent)(TObject, TItemFind, char*, TPoint*, TCustomData, int32_t, TSearchDirection, BOOL, int32_t*);

// void (TObject sender, TListItem item)
typedef void(*TLVDeletedEvent)(TObject, TListItem);

// void (TObject sender, TListItem item, BOOL* allowEdit)
typedef void(*TLVEditingEvent)(TObject, TListItem, BOOL*);

// void (TObject sender, TListItem item, char** s)
typedef void(*TLVEditedEvent)(TObject, TListItem, char**);

// void (TObject sender, TCanvas aCanvas, int32_t* width, int32_t* height)
typedef void(*TMenuMeasureItemEvent)(TObject, TCanvas, int32_t*, int32_t*);

// void (TObject sender, BOOL* allowChange)
typedef void(*TTabChangingEvent)(TObject, BOOL*);

// void (TObject sender, TTreeNode node, BOOL* allowChange)
typedef void(*TTVChangingEvent)(TObject, TTreeNode, BOOL*);

// void (TObject sender, TTreeNode node, BOOL* allowCollapse)
typedef void(*TTVCollapsingEvent)(TObject, TTreeNode, BOOL*);

// void (TObject sender, TTreeNode node, char** s)
typedef void(*TTVEditedEvent)(TObject, TTreeNode, char**);

// void (TObject sender, TTreeNode node, BOOL* allowEdit)
typedef void(*TTVEditingEvent)(TObject, TTreeNode, BOOL*);

// void (TObject sender, TTreeNode node, BOOL* allowExpansion)
typedef void(*TTVExpandingEvent)(TObject, TTreeNode, BOOL*);

// void (TObject sender, TTreeNode node, char** hint)
typedef void(*TTVHintEvent)(TObject, TTreeNode, char**);

// void (TObject sender, BOOL* allowChange)
typedef void(*TUDChangingEvent)(TObject, BOOL*);

// void (TObject sender, uint32_t winErrorCode, char* errorDescription, BOOL* handled)
typedef void(*TCreatingListErrorEvent)(TObject, uint32_t, char*, BOOL*);

// void (TListView sender, TRect* aRect, BOOL* defaultDraw)
typedef void(*TLVCustomDrawEvent)(TListView, TRect*, BOOL*);

// void (TListView sender, TListItem item, TCustomDrawState state, BOOL* defaultDraw)
typedef void(*TLVCustomDrawItemEvent)(TListView, TListItem, TCustomDrawState, BOOL*);

// void (TListView sender, TListItem item, int32_t subItem, TCustomDrawState state, BOOL* defaultDraw)
typedef void(*TLVCustomDrawSubItemEvent)(TListView, TListItem, int32_t, TCustomDrawState, BOOL*);

// void (TListView sender, TListItem item, TRect* rect, TOwnerDrawState state)
typedef void(*TLVDrawItemEvent)(TListView, TListItem, TRect*, TOwnerDrawState);

// void (TObject sender, int32_t startIndex, int32_t endIndex)
typedef void(*TLVDataHintEvent)(TObject, int32_t, int32_t);

// void (TTreeView sender, TRect* aRect, BOOL* defaultDraw)
typedef void(*TTVCustomDrawEvent)(TTreeView, TRect*, BOOL*);

// void (TTreeView sender, TTreeNode node, TCustomDrawState state, BOOL* defaultDraw)
typedef void(*TTVCustomDrawItemEvent)(TTreeView, TTreeNode, TCustomDrawState, BOOL*);

// void (TMessage* msg)
typedef void(*TWndProcEvent)(TMessage*);

// void (TObject sender, char* text)
typedef void(*TWebTitleChangeEvent)(TObject, char*);

// void (TObject sender, char* funcName, char* args, char** retVal)
typedef void(*TWebJSExternalEvent)(TObject, char*, char*, char**);

// void (TObject sender, TModalResult modalResult, BOOL* canClose)
typedef void(*TTaskDlgClickEvent)(TObject, TModalResult, BOOL*);

// void (TObject sender, uint32_t tickCount, BOOL* reset)
typedef void(*TTaskDlgTimerEvent)(TObject, uint32_t, BOOL*);

// void (TWinControl sender, TControl control, int32_t* newLeft, int32_t* newTop, int32_t* newWidth, int32_t* newHeight, TRect* alignRect, TAlignInfo alignInfo)
typedef void(*TAlignPositionEvent)(TWinControl, TControl, int32_t*, int32_t*, int32_t*, int32_t*, TRect*, TAlignInfo);

// void (TObject sender, int32_t index)
typedef void(*TCheckGroupClicked)(TObject, int32_t);

// void (TObject sender, int32_t aCol, int32_t aRow)
typedef void(*TOnSelectEvent)(TObject, int32_t, int32_t);

// void (TObject sender, int32_t aCol, int32_t aRow, TCheckBoxState aState)
typedef void(*TToggledCheckboxEvent)(TObject, int32_t, int32_t, TCheckBoxState);

// void (TObject sender, int32_t ACol, int32_t ARow, int32_t BCol, int32_t BRow, int32_t* result)
typedef void(*TOnCompareCells)(TObject, int32_t, int32_t, int32_t, int32_t, int32_t*);

// void (TObject sender, int32_t ACol, int32_t ARow, char** hintText)
typedef void(*TGetCellHintEvent)(TObject, int32_t, int32_t, char**);

// void (TObject sender, int32_t ACol, int32_t ARow, TCheckBoxState* value)
typedef void(*TGetCheckboxStateEvent)(TObject, int32_t, int32_t, TCheckBoxState*);

// void (TObject sender, int32_t ACol, int32_t ARow, TCheckBoxState Value)
typedef void(*TSetCheckboxStateEvent)(TObject, int32_t, int32_t, TCheckBoxState);

// void (TObject sender, BOOL isColumn, int32_t index)
typedef void(*THdrEvent)(TObject, BOOL, int32_t);

// void (TObject sender, BOOL isColumn, int32_t aIndex, int32_t aSize)
typedef void(*THeaderSizingEvent)(TObject, BOOL, int32_t, int32_t);

// void (TObject sender, int32_t aCol, int32_t aRow, TWinControl* editor)
typedef void(*TSelectEditorEvent)(TObject, int32_t, int32_t, TWinControl*);

// void (TObject sender, int32_t aCol, int32_t aRow, TCheckBoxState CheckedState, TBitmap* aBitmap)
typedef void(*TUserCheckBoxBitmapEvent)(TObject, int32_t, int32_t, TCheckBoxState, TBitmap*);

// void (TObject sender, int32_t aCol, int32_t aRow, char* oldValue, char** newValue)
typedef void(*TValidateEntryEvent)(TObject, int32_t, int32_t, char*, char**);

// void (TObject sender, int32_t aCol, int32_t aRow, TGridDrawState aState)
typedef void(*TOnPrepareCanvasEvent)(TObject, int32_t, int32_t, TGridDrawState);

// void (TObject sender, char** value)
typedef void(*TAcceptFileNameEvent)(TObject, char**);

// void (TObject sender, int32_t index)
typedef void(*TCheckItemChange)(TObject, int32_t);

// void (TObject sender, TUTF8Char* utf8key)
typedef void(*TUTF8KeyPressEvent)(TObject, TUTF8Char*);

// void (TObject sender, TCanvas aCanvas, TRect* aRect, TOwnerDrawState aState)
typedef void(*TMenuDrawItemEvent)(TObject, TCanvas, TRect*, TOwnerDrawState);




// 集合加法，val...中存储为位的索引，下标为0
TSet Include(TSet s, uint8_t val) {
    return (TSet)(s | (1 << val));
}
//TSet Include(TSet s, ...) {
//    uint32_t r = (uint32_t)s;
//    va_list varlist;
//    va_start(varlist, s);
//    uint8_t val;
//    while ((val = va_arg(varlist, int)) != -1) {
//        r |= (1 << (uint8_t)val);
//    }
//    va_end(varlist);
//    return (TSet)r;
//}

// 集合减法，val...中存储为位的索引，下标为0
TSet Exclude(TSet s, uint8_t val) {
    return (TSet)(s & (~(1 << val)));
}
//TSet Exclude(TSet s, ...) {
//    uint32_t r = (uint32_t)s;
//    va_list varlist;
//    va_start(varlist, s);
//    uint8_t val;
//    while ((val = va_arg(varlist, int)) != -1) {
//        r &= ~(1 << (uint8_t)val);
//    }
//    va_end(varlist);
//    return (TSet)r;
//}

// 集合类型的判断，val表示位数，下标为0
BOOL InSet(uint32_t s, uint8_t val) {
    if ((s&(1 << val)) != 0) {
        return TRUE;
    }
    return FALSE;
}


// liblcl句柄
static uintptr_t libHandle;


// 函数call
typedef intptr_t LCLAPI (*SYSCALL0)();
typedef intptr_t LCLAPI (*SYSCALL1)(intptr_t);
typedef intptr_t LCLAPI (*SYSCALL2)(intptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL3)(intptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL4)(intptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL5)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL6)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL7)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL8)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL9)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL10)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL11)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);
typedef intptr_t LCLAPI (*SYSCALL12)(intptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t, uintptr_t);

// 全局实例类定义
TApplication Application;
TScreen Screen;
TMouse Mouse;
TClipboard Clipboard;
TPrinter Printer;

// 全局互斥锁
#ifdef __GNUC__
static pthread_mutex_t threadSyncMutex;
#else
static RTL_CRITICAL_SECTION threadSyncMutex;
#endif

// 初始liblcl库
static void init_lib_lcl();
// 反向初始liblcl库
static void un_init_lib_lcl();


// 获取过程地址
static void* get_proc_addr(const char *name) {
#ifdef _WIN32
    return (void*)GetProcAddress((HMODULE)libHandle, name);
#else
    return (void*)dlsym((void*)libHandle, name);
#endif
}

// 加载库
BOOL load_liblcl(const char *name) {
    if(libHandle > 0)
        return TRUE;
#ifdef _WIN32
    libHandle = (uintptr_t)LoadLibraryA(name);
#else
    libHandle = (uintptr_t)dlopen(name, RTLD_LAZY|RTLD_GLOBAL);
#endif
    if(libHandle > 0) {
         // 初始库
         init_lib_lcl();
    }
    return libHandle > 0;
}

// 关闭库
void close_liblcl() {
    if(libHandle > 0) {
	#ifdef _WIN32
	    FreeLibrary((HMODULE)libHandle);
	#else
	    dlclose((void*)libHandle);
	#endif
        libHandle = 0;
        un_init_lib_lcl();
    }
}

/*--------------------一些其它函数--------------------*/

DEFINE_FUNC_PTR(DLibStringEncoding)
TStringEncoding
LibStringEncoding() {
    GET_FUNC_ADDR(DLibStringEncoding)
    return (TStringEncoding)(((SYSCALL0) (pDLibStringEncoding))());
}

DEFINE_FUNC_PTR(DLibVersion)
uint32_t
LibVersion() {
    GET_FUNC_ADDR(DLibVersion)
    return (uint32_t)(((SYSCALL0) (pDLibVersion))());
}

DEFINE_FUNC_PTR(DSysLocale)
void
SysLocale(TSysLocale* AInfo) {
    GET_FUNC_ADDR(DSysLocale)
    (((SYSCALL1) (pDSysLocale))(COV_PARAM(AInfo)));
}

DEFINE_FUNC_PTR(Application_Instance)
TApplication
Application_Instance() {
    GET_FUNC_ADDR(Application_Instance)
    return (TApplication)(((SYSCALL0) (pApplication_Instance))());
}

DEFINE_FUNC_PTR(Mouse_Instance)
TMouse
Mouse_Instance() {
    GET_FUNC_ADDR(Mouse_Instance)
    return (TMouse)(((SYSCALL0) (pMouse_Instance))());
}

DEFINE_FUNC_PTR(Screen_Instance)
TScreen
Screen_Instance() {
    GET_FUNC_ADDR(Screen_Instance)
    return (TScreen)(((SYSCALL0) (pScreen_Instance))());
}

DEFINE_FUNC_PTR(DTextToShortCut)
TShortCut
TextToShortCut(CChar char* AText) {
    GET_FUNC_ADDR(DTextToShortCut)
    return (TShortCut)(((SYSCALL1) (pDTextToShortCut))(COV_PARAM(AText)));
}

DEFINE_FUNC_PTR(DShortCutToText)
char*
ShortCutToText(TShortCut AVal) {
    GET_FUNC_ADDR(DShortCutToText)
    return (char*)(((SYSCALL1) (pDShortCutToText))(COV_PARAM(AVal)));
}

DEFINE_FUNC_PTR(Clipboard_Instance)
TClipboard
Clipboard_Instance() {
    GET_FUNC_ADDR(Clipboard_Instance)
    return (TClipboard)(((SYSCALL0) (pClipboard_Instance))());
}

DEFINE_FUNC_PTR(DPredefinedClipboardFormat)
TClipboardFormat
PredefinedClipboardFormat(TPredefinedClipboardFormat AFormat) {
    GET_FUNC_ADDR(DPredefinedClipboardFormat)
    return (TClipboardFormat)(((SYSCALL1) (pDPredefinedClipboardFormat))(COV_PARAM(AFormat)));
}

DEFINE_FUNC_PTR(DSetClipboard)
TClipboard
SetClipboard(TClipboard ANewClipboard) {
    GET_FUNC_ADDR(DSetClipboard)
    return (TClipboard)(((SYSCALL1) (pDSetClipboard))(COV_PARAM(ANewClipboard)));
}
#ifndef _WIN32


DEFINE_FUNC_PTR(DSendMessage)
LRESULT
SendMessage(HWND hWd, uint32_t msg, WPARAM wParam, LPARAM lParam) {
    GET_FUNC_ADDR(DSendMessage)
    return (LRESULT)(((SYSCALL4) (pDSendMessage))(COV_PARAM(hWd), COV_PARAM(msg), COV_PARAM(wParam), COV_PARAM(lParam)));
}

DEFINE_FUNC_PTR(DPostMessage)
BOOL
PostMessage(HWND hWd, uint32_t msg, WPARAM wParam, LPARAM lParam) {
    GET_FUNC_ADDR(DPostMessage)
    return (BOOL)(((SYSCALL4) (pDPostMessage))(COV_PARAM(hWd), COV_PARAM(msg), COV_PARAM(wParam), COV_PARAM(lParam)));
}

DEFINE_FUNC_PTR(DIsIconic)
BOOL
IsIconic(HWND hWnd) {
    GET_FUNC_ADDR(DIsIconic)
    return (BOOL)(((SYSCALL1) (pDIsIconic))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DIsWindow)
BOOL
IsWindow(HWND hWnd) {
    GET_FUNC_ADDR(DIsWindow)
    return (BOOL)(((SYSCALL1) (pDIsWindow))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DIsZoomed)
BOOL
IsZoomed(HWND hWnd) {
    GET_FUNC_ADDR(DIsZoomed)
    return (BOOL)(((SYSCALL1) (pDIsZoomed))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DIsWindowVisible)
BOOL
IsWindowVisible(HWND hWnd) {
    GET_FUNC_ADDR(DIsWindowVisible)
    return (BOOL)(((SYSCALL1) (pDIsWindowVisible))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DGetDC)
HDC
GetDC(HWND hWnd) {
    GET_FUNC_ADDR(DGetDC)
    return (HDC)(((SYSCALL1) (pDGetDC))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DReleaseDC)
int32_t
ReleaseDC(HWND hWnd, HDC dc) {
    GET_FUNC_ADDR(DReleaseDC)
    return (int32_t)(((SYSCALL2) (pDReleaseDC))(COV_PARAM(hWnd), COV_PARAM(dc)));
}

DEFINE_FUNC_PTR(DSetForegroundWindow)
BOOL
SetForegroundWindow(HWND hWnd) {
    GET_FUNC_ADDR(DSetForegroundWindow)
    return (BOOL)(((SYSCALL1) (pDSetForegroundWindow))(COV_PARAM(hWnd)));
}

DEFINE_FUNC_PTR(DRegisterClipboardFormat)
TClipboardFormat
RegisterClipboardFormat(CChar char* AFormat) {
    GET_FUNC_ADDR(DRegisterClipboardFormat)
    return (TClipboardFormat)(((SYSCALL1) (pDRegisterClipboardFormat))(COV_PARAM(AFormat)));
}

DEFINE_FUNC_PTR(DWindowFromPoint)
HWND
WindowFromPoint(TPoint* point) {
    GET_FUNC_ADDR(DWindowFromPoint)
    return (HWND)(((SYSCALL1) (pDWindowFromPoint))(COV_PARAM(point)));
}

#endif


DEFINE_FUNC_PTR(SetEventCallback)
void
SetEventCallback(void* APtr) {
    GET_FUNC_ADDR(SetEventCallback)
    (((SYSCALL1) (pSetEventCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(SetMessageCallback)
void
SetMessageCallback(void* APtr) {
    GET_FUNC_ADDR(SetMessageCallback)
    (((SYSCALL1) (pSetMessageCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(SetThreadSyncCallback)
void
SetThreadSyncCallback(void* APtr) {
    GET_FUNC_ADDR(SetThreadSyncCallback)
    (((SYSCALL1) (pSetThreadSyncCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(SetExceptionHandlerCallback)
void
SetExceptionHandlerCallback(void* APtr) {
    GET_FUNC_ADDR(SetExceptionHandlerCallback)
    (((SYSCALL1) (pSetExceptionHandlerCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(SetRequestCallCreateParamsCallback)
void
SetRequestCallCreateParamsCallback(void* APtr) {
    GET_FUNC_ADDR(SetRequestCallCreateParamsCallback)
    (((SYSCALL1) (pSetRequestCallCreateParamsCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(SetRemoveEventCallback)
void
SetRemoveEventCallback(void* APtr) {
    GET_FUNC_ADDR(SetRemoveEventCallback)
    (((SYSCALL1) (pSetRemoveEventCallback))(COV_PARAM(APtr)));
}

DEFINE_FUNC_PTR(DGetStringArrOf)
char*
GetStringArrOf(void* P, intptr_t AIndex) {
    GET_FUNC_ADDR(DGetStringArrOf)
    return (char*)(((SYSCALL2) (pDGetStringArrOf))(COV_PARAM(P), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(DStrLen)
intptr_t
StrLen(CChar char* p) {
    GET_FUNC_ADDR(DStrLen)
    return (intptr_t)(((SYSCALL1) (pDStrLen))(COV_PARAM(p)));
}

DEFINE_FUNC_PTR(DShowMessage)
void
ShowMessage(CChar char* AMsg) {
    GET_FUNC_ADDR(DShowMessage)
    (((SYSCALL1) (pDShowMessage))(COV_PARAM(AMsg)));
}

DEFINE_FUNC_PTR(DGetMainInstance)
HINST
GetMainInstance() {
    GET_FUNC_ADDR(DGetMainInstance)
    return (HINST)(((SYSCALL0) (pDGetMainInstance))());
}

DEFINE_FUNC_PTR(DMessageDlg)
int32_t
MessageDlg(CChar char* Msg, TMsgDlgType DlgType, TMsgDlgButtons Buttons, int32_t HelpCtx) {
    GET_FUNC_ADDR(DMessageDlg)
    return (int32_t)(((SYSCALL4) (pDMessageDlg))(COV_PARAM(Msg), COV_PARAM(DlgType), COV_PARAM(Buttons), COV_PARAM(HelpCtx)));
}

DEFINE_FUNC_PTR(DSynchronize)
void
Synchronize(BOOL AUseMsg) {
    GET_FUNC_ADDR(DSynchronize)
    (((SYSCALL1) (pDSynchronize))(COV_PARAM(AUseMsg)));
}

DEFINE_FUNC_PTR(DMainThreadId)
TThreadID
MainThreadId() {
    GET_FUNC_ADDR(DMainThreadId)
    return (TThreadID)(((SYSCALL0) (pDMainThreadId))());
}

DEFINE_FUNC_PTR(DCurrentThreadId)
TThreadID
CurrentThreadId() {
    GET_FUNC_ADDR(DCurrentThreadId)
    return (TThreadID)(((SYSCALL0) (pDCurrentThreadId))());
}

DEFINE_FUNC_PTR(DSysOpen)
void
SysOpen(CChar char* FileName) {
    GET_FUNC_ADDR(DSysOpen)
    (((SYSCALL1) (pDSysOpen))(COV_PARAM(FileName)));
}

DEFINE_FUNC_PTR(DExtractFilePath)
char*
ExtractFilePath(CChar char* AFileName) {
    GET_FUNC_ADDR(DExtractFilePath)
    return (char*)(((SYSCALL1) (pDExtractFilePath))(COV_PARAM(AFileName)));
}

DEFINE_FUNC_PTR(DFileExists)
BOOL
FileExists(CChar char* AFileName) {
    GET_FUNC_ADDR(DFileExists)
    return (BOOL)(((SYSCALL1) (pDFileExists))(COV_PARAM(AFileName)));
}

DEFINE_FUNC_PTR(DSelectDirectory1)
BOOL
SelectDirectory1(CChar char** Directory, TSelectDirOpts Options, int32_t HelpCtx) {
    GET_FUNC_ADDR(DSelectDirectory1)
    return (BOOL)(((SYSCALL3) (pDSelectDirectory1))(COV_PARAM(Directory), COV_PARAM(Options), COV_PARAM(HelpCtx)));
}

DEFINE_FUNC_PTR(DSelectDirectory2)
BOOL
SelectDirectory2(CChar char* Caption, CChar char* Root, BOOL AShowHidden, CChar char** Directory) {
    GET_FUNC_ADDR(DSelectDirectory2)
    return (BOOL)(((SYSCALL4) (pDSelectDirectory2))(COV_PARAM(Caption), COV_PARAM(Root), COV_PARAM(AShowHidden), COV_PARAM(Directory)));
}

DEFINE_FUNC_PTR(DInputBox)
char*
InputBox(CChar char* ACaption, CChar char* APrompt, CChar char* ADefault) {
    GET_FUNC_ADDR(DInputBox)
    return (char*)(((SYSCALL3) (pDInputBox))(COV_PARAM(ACaption), COV_PARAM(APrompt), COV_PARAM(ADefault)));
}

DEFINE_FUNC_PTR(DInputQuery)
BOOL
InputQuery(CChar char* ACaption, CChar char* APrompt, CChar char* Value, CChar char** AOut) {
    GET_FUNC_ADDR(DInputQuery)
    return (BOOL)(((SYSCALL4) (pDInputQuery))(COV_PARAM(ACaption), COV_PARAM(APrompt), COV_PARAM(Value), COV_PARAM(AOut)));
}

DEFINE_FUNC_PTR(DPasswordBox)
char*
PasswordBox(CChar char* ACaption, CChar char* APrompt) {
    GET_FUNC_ADDR(DPasswordBox)
    return (char*)(((SYSCALL2) (pDPasswordBox))(COV_PARAM(ACaption), COV_PARAM(APrompt)));
}

DEFINE_FUNC_PTR(DInputCombo)
int32_t
InputCombo(CChar char* ACaption, CChar char* APrompt, TStrings AList) {
    GET_FUNC_ADDR(DInputCombo)
    return (int32_t)(((SYSCALL3) (pDInputCombo))(COV_PARAM(ACaption), COV_PARAM(APrompt), COV_PARAM(AList)));
}

DEFINE_FUNC_PTR(DInputComboEx)
char*
InputComboEx(CChar char* ACaption, CChar char* APrompt, TStrings AList, BOOL AllowCustomText) {
    GET_FUNC_ADDR(DInputComboEx)
    return (char*)(((SYSCALL4) (pDInputComboEx))(COV_PARAM(ACaption), COV_PARAM(APrompt), COV_PARAM(AList), COV_PARAM(AllowCustomText)));
}
#ifdef _WIN32


DEFINE_FUNC_PTR(DCreateURLShortCut)
void
CreateURLShortCut(CChar char* ADestPath, CChar char* AShortCutName, CChar char* AURL) {
    GET_FUNC_ADDR(DCreateURLShortCut)
    (((SYSCALL3) (pDCreateURLShortCut))(COV_PARAM(ADestPath), COV_PARAM(AShortCutName), COV_PARAM(AURL)));
}

DEFINE_FUNC_PTR(DCreateShortCut)
BOOL
CreateShortCut(CChar char* ADestPath, CChar char* AShortCutName, CChar char* ASrcFileName, CChar char* AIconFileName, CChar char* ADescription, CChar char* ACmdArgs) {
    GET_FUNC_ADDR(DCreateShortCut)
    return (BOOL)(((SYSCALL6) (pDCreateShortCut))(COV_PARAM(ADestPath), COV_PARAM(AShortCutName), COV_PARAM(ASrcFileName), COV_PARAM(AIconFileName), COV_PARAM(ADescription), COV_PARAM(ACmdArgs)));
}

#endif


DEFINE_FUNC_PTR(DSetPropertyValue)
void
SetPropertyValue(TObject Instance, CChar char* PropName, CChar char* Value) {
    GET_FUNC_ADDR(DSetPropertyValue)
    (((SYSCALL3) (pDSetPropertyValue))(COV_PARAM(Instance), COV_PARAM(PropName), COV_PARAM(Value)));
}

DEFINE_FUNC_PTR(DSetPropertySecValue)
void
SetPropertySecValue(TObject Instance, CChar char* PropName, CChar char* SecPropName, CChar char* Value) {
    GET_FUNC_ADDR(DSetPropertySecValue)
    (((SYSCALL4) (pDSetPropertySecValue))(COV_PARAM(Instance), COV_PARAM(PropName), COV_PARAM(SecPropName), COV_PARAM(Value)));
}

DEFINE_FUNC_PTR(DGUIDToString)
char*
GUIDToString(TGUID AGUID) {
    GET_FUNC_ADDR(DGUIDToString)
    return (char*)(((SYSCALL1) (pDGUIDToString))(COV_PARAM(&AGUID)));
}

DEFINE_FUNC_PTR(DStringToGUID)
TGUID
StringToGUID(CChar char* AGUIDStr) {
    GET_FUNC_ADDR(DStringToGUID)
    TGUID result;
    (((SYSCALL2) (pDStringToGUID))(COV_PARAM(AGUIDStr), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(DCreateGUID)
TGUID
CreateGUID() {
    GET_FUNC_ADDR(DCreateGUID)
    TGUID result;
    (((SYSCALL1) (pDCreateGUID))(COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Printer_Instance)
TPrinter
Printer_Instance() {
    GET_FUNC_ADDR(Printer_Instance)
    return (TPrinter)(((SYSCALL0) (pPrinter_Instance))());
}

DEFINE_FUNC_PTR(DLibAbout)
char*
LibAbout() {
    GET_FUNC_ADDR(DLibAbout)
    return (char*)(((SYSCALL0) (pDLibAbout))());
}

DEFINE_FUNC_PTR(DGetLibResourceCount)
int32_t
GetLibResourceCount() {
    GET_FUNC_ADDR(DGetLibResourceCount)
    return (int32_t)(((SYSCALL0) (pDGetLibResourceCount))());
}

DEFINE_FUNC_PTR(DGetLibResourceItem)
TResItem
GetLibResourceItem(int32_t AIndex) {
    GET_FUNC_ADDR(DGetLibResourceItem)
    TResItem result;
    (((SYSCALL2) (pDGetLibResourceItem))(COV_PARAM(AIndex), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(DModifyLibResource)
void
ModifyLibResource(void* APtr, CChar char* AValue) {
    GET_FUNC_ADDR(DModifyLibResource)
    (((SYSCALL2) (pDModifyLibResource))(COV_PARAM(APtr), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(DGetLibType)
TLibType
GetLibType() {
    GET_FUNC_ADDR(DGetLibType)
    return (TLibType)(((SYSCALL0) (pDGetLibType))());
}

DEFINE_FUNC_PTR(DInitGoDll)
void
InitGoDll(TThreadID AMainThreadId) {
    GET_FUNC_ADDR(DInitGoDll)
    (((SYSCALL1) (pDInitGoDll))(COV_PARAM(AMainThreadId)));
}

DEFINE_FUNC_PTR(DFindControl)
TWinControl
FindControl(HWND AHandle) {
    GET_FUNC_ADDR(DFindControl)
    return (TWinControl)(((SYSCALL1) (pDFindControl))(COV_PARAM(AHandle)));
}

DEFINE_FUNC_PTR(DFindLCLControl)
TControl
FindLCLControl(TPoint AScreenPos) {
    GET_FUNC_ADDR(DFindLCLControl)
    return (TControl)(((SYSCALL1) (pDFindLCLControl))(COV_PARAM(&AScreenPos)));
}

DEFINE_FUNC_PTR(DFindOwnerControl)
TWinControl
FindOwnerControl(HWND Handle) {
    GET_FUNC_ADDR(DFindOwnerControl)
    return (TWinControl)(((SYSCALL1) (pDFindOwnerControl))(COV_PARAM(Handle)));
}

DEFINE_FUNC_PTR(DFindControlAtPosition)
TControl
FindControlAtPosition(TPoint APosition, BOOL AllowDisabled) {
    GET_FUNC_ADDR(DFindControlAtPosition)
    return (TControl)(((SYSCALL2) (pDFindControlAtPosition))(COV_PARAM(&APosition), COV_PARAM(AllowDisabled)));
}

DEFINE_FUNC_PTR(DFindLCLWindow)
TWinControl
FindLCLWindow(TPoint AScreenPos, BOOL AllowDisabled) {
    GET_FUNC_ADDR(DFindLCLWindow)
    return (TWinControl)(((SYSCALL2) (pDFindLCLWindow))(COV_PARAM(&AScreenPos), COV_PARAM(AllowDisabled)));
}

DEFINE_FUNC_PTR(DFindDragTarget)
TControl
FindDragTarget(TPoint APosition, BOOL AllowDisabled) {
    GET_FUNC_ADDR(DFindDragTarget)
    return (TControl)(((SYSCALL2) (pDFindDragTarget))(COV_PARAM(&APosition), COV_PARAM(AllowDisabled)));
}

#ifdef __linux__


DEFINE_FUNC_PTR(GtkWidget_GetGtkFixed)
PGtkFixed
GtkWidget_GetGtkFixed(HWND Ah) {
    GET_FUNC_ADDR(GtkWidget_GetGtkFixed)
    return (PGtkFixed)(((SYSCALL1) (pGtkWidget_GetGtkFixed))(COV_PARAM(Ah)));
}

DEFINE_FUNC_PTR(GdkWindow_FromForm)
PGdkWindow
GdkWindow_FromForm(TForm AForm) {
    GET_FUNC_ADDR(GdkWindow_FromForm)
    return (PGdkWindow)(((SYSCALL1) (pGdkWindow_FromForm))(COV_PARAM(AForm)));
}

DEFINE_FUNC_PTR(GdkWindow_GetXId)
void
GdkWindow_GetXId(PGdkWindow AW, TXId* AXId) {
    GET_FUNC_ADDR(GdkWindow_GetXId)
    (((SYSCALL2) (pGdkWindow_GetXId))(COV_PARAM(AW), COV_PARAM(AXId)));
}

DEFINE_FUNC_PTR(GtkWidget_Window)
PGdkWindow
GtkWidget_Window(HWND Ah) {
    GET_FUNC_ADDR(GtkWidget_Window)
    return (PGdkWindow)(((SYSCALL1) (pGtkWidget_Window))(COV_PARAM(Ah)));
}

#endif


#ifdef __APPLE__


DEFINE_FUNC_PTR(NSWindow_FromForm)
MyNSWindow
NSWindow_FromForm(TForm AForm) {
    GET_FUNC_ADDR(NSWindow_FromForm)
    return (MyNSWindow)(((SYSCALL1) (pNSWindow_FromForm))(COV_PARAM(AForm)));
}

#endif


DEFINE_FUNC_PTR(ResFormLoadFromResourceName)
void
ResFormLoadFromResourceName(uintptr_t AInstance, CChar char* AResName, TComponent ARoot) {
    GET_FUNC_ADDR(ResFormLoadFromResourceName)
    (((SYSCALL3) (pResFormLoadFromResourceName))(COV_PARAM(AInstance), COV_PARAM(AResName), COV_PARAM(ARoot)));
}

DEFINE_FUNC_PTR(ResFormLoadFromFile)
void
ResFormLoadFromFile(CChar char* AFileName, TComponent ARoot) {
    GET_FUNC_ADDR(ResFormLoadFromFile)
    (((SYSCALL2) (pResFormLoadFromFile))(COV_PARAM(AFileName), COV_PARAM(ARoot)));
}

DEFINE_FUNC_PTR(ResFormLoadFromStream)
void
ResFormLoadFromStream(TStream AStream, TComponent ARoot) {
    GET_FUNC_ADDR(ResFormLoadFromStream)
    (((SYSCALL2) (pResFormLoadFromStream))(COV_PARAM(AStream), COV_PARAM(ARoot)));
}

DEFINE_FUNC_PTR(ResFormRegisterFormResource)
BOOL
ResFormRegisterFormResource(CChar char* AClassName, void* AData, int32_t ALen) {
    GET_FUNC_ADDR(ResFormRegisterFormResource)
    return (BOOL)(((SYSCALL3) (pResFormRegisterFormResource))(COV_PARAM(AClassName), COV_PARAM(AData), COV_PARAM(ALen)));
}

DEFINE_FUNC_PTR(ResFormLoadFromClassName)
BOOL
ResFormLoadFromClassName(CChar char* AClassName, TComponent ARoot) {
    GET_FUNC_ADDR(ResFormLoadFromClassName)
    return (BOOL)(((SYSCALL2) (pResFormLoadFromClassName))(COV_PARAM(AClassName), COV_PARAM(ARoot)));
}
/*--------------------类成员函数--------------------*/

// -------------------TObject-------------------

DEFINE_FUNC_PTR(Object_Create)
TObject
Object_Create() {
    GET_FUNC_ADDR(Object_Create)
    return (TObject)(((SYSCALL0) (pObject_Create))());
}

DEFINE_FUNC_PTR(Object_Free)
void
Object_Free(TObject AObj) {
    GET_FUNC_ADDR(Object_Free)
    (((SYSCALL1) (pObject_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_ClassType)
TClass
Object_ClassType(TObject AObj) {
    GET_FUNC_ADDR(Object_ClassType)
    return (TClass)(((SYSCALL1) (pObject_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_ClassName)
char*
Object_ClassName(TObject AObj) {
    GET_FUNC_ADDR(Object_ClassName)
    return (char*)(((SYSCALL1) (pObject_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_InstanceSize)
int32_t
Object_InstanceSize(TObject AObj) {
    GET_FUNC_ADDR(Object_InstanceSize)
    return (int32_t)(((SYSCALL1) (pObject_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_InheritsFrom)
BOOL
Object_InheritsFrom(TObject AObj, TClass AClass) {
    GET_FUNC_ADDR(Object_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pObject_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Object_Equals)
BOOL
Object_Equals(TObject AObj, TObject Obj) {
    GET_FUNC_ADDR(Object_Equals)
    return (BOOL)(((SYSCALL2) (pObject_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Object_GetHashCode)
int32_t
Object_GetHashCode(TObject AObj) {
    GET_FUNC_ADDR(Object_GetHashCode)
    return (int32_t)(((SYSCALL1) (pObject_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_ToString)
char*
Object_ToString(TObject AObj) {
    GET_FUNC_ADDR(Object_ToString)
    return (char*)(((SYSCALL1) (pObject_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Object_StaticClassType)
TClass
Object_StaticClassType() {
    GET_FUNC_ADDR(Object_StaticClassType)
    return (TClass)(((SYSCALL0) (pObject_StaticClassType))());
}

// -------------------TComponent-------------------

DEFINE_FUNC_PTR(Component_Create)
TComponent
Component_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Component_Create)
    return (TComponent)(((SYSCALL1) (pComponent_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Component_Free)
void
Component_Free(TComponent AObj) {
    GET_FUNC_ADDR(Component_Free)
    (((SYSCALL1) (pComponent_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_FindComponent)
TComponent
Component_FindComponent(TComponent AObj, CChar char* AName) {
    GET_FUNC_ADDR(Component_FindComponent)
    return (TComponent)(((SYSCALL2) (pComponent_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Component_GetNamePath)
char*
Component_GetNamePath(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetNamePath)
    return (char*)(((SYSCALL1) (pComponent_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_HasParent)
BOOL
Component_HasParent(TComponent AObj) {
    GET_FUNC_ADDR(Component_HasParent)
    return (BOOL)(((SYSCALL1) (pComponent_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_Assign)
void
Component_Assign(TComponent AObj, TObject Source) {
    GET_FUNC_ADDR(Component_Assign)
    (((SYSCALL2) (pComponent_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Component_ClassType)
TClass
Component_ClassType(TComponent AObj) {
    GET_FUNC_ADDR(Component_ClassType)
    return (TClass)(((SYSCALL1) (pComponent_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_ClassName)
char*
Component_ClassName(TComponent AObj) {
    GET_FUNC_ADDR(Component_ClassName)
    return (char*)(((SYSCALL1) (pComponent_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_InstanceSize)
int32_t
Component_InstanceSize(TComponent AObj) {
    GET_FUNC_ADDR(Component_InstanceSize)
    return (int32_t)(((SYSCALL1) (pComponent_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_InheritsFrom)
BOOL
Component_InheritsFrom(TComponent AObj, TClass AClass) {
    GET_FUNC_ADDR(Component_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pComponent_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Component_Equals)
BOOL
Component_Equals(TComponent AObj, TObject Obj) {
    GET_FUNC_ADDR(Component_Equals)
    return (BOOL)(((SYSCALL2) (pComponent_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Component_GetHashCode)
int32_t
Component_GetHashCode(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetHashCode)
    return (int32_t)(((SYSCALL1) (pComponent_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_ToString)
char*
Component_ToString(TComponent AObj) {
    GET_FUNC_ADDR(Component_ToString)
    return (char*)(((SYSCALL1) (pComponent_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_GetComponentCount)
int32_t
Component_GetComponentCount(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pComponent_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_GetComponentIndex)
int32_t
Component_GetComponentIndex(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pComponent_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_SetComponentIndex)
void
Component_SetComponentIndex(TComponent AObj, int32_t AValue) {
    GET_FUNC_ADDR(Component_SetComponentIndex)
    (((SYSCALL2) (pComponent_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Component_GetOwner)
TComponent
Component_GetOwner(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetOwner)
    return (TComponent)(((SYSCALL1) (pComponent_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_GetName)
char*
Component_GetName(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetName)
    return (char*)(((SYSCALL1) (pComponent_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_SetName)
void
Component_SetName(TComponent AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Component_SetName)
    (((SYSCALL2) (pComponent_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Component_GetTag)
intptr_t
Component_GetTag(TComponent AObj) {
    GET_FUNC_ADDR(Component_GetTag)
    return (intptr_t)(((SYSCALL1) (pComponent_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Component_SetTag)
void
Component_SetTag(TComponent AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Component_SetTag)
    (((SYSCALL2) (pComponent_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Component_GetComponents)
TComponent
Component_GetComponents(TComponent AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Component_GetComponents)
    return (TComponent)(((SYSCALL2) (pComponent_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Component_StaticClassType)
TClass
Component_StaticClassType() {
    GET_FUNC_ADDR(Component_StaticClassType)
    return (TClass)(((SYSCALL0) (pComponent_StaticClassType))());
}

// -------------------TControl-------------------

DEFINE_FUNC_PTR(Control_Create)
TControl
Control_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Control_Create)
    return (TControl)(((SYSCALL1) (pControl_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Control_Free)
void
Control_Free(TControl AObj) {
    GET_FUNC_ADDR(Control_Free)
    (((SYSCALL1) (pControl_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_BringToFront)
void
Control_BringToFront(TControl AObj) {
    GET_FUNC_ADDR(Control_BringToFront)
    (((SYSCALL1) (pControl_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_ClientToScreen)
TPoint
Control_ClientToScreen(TControl AObj, TPoint Point) {
    GET_FUNC_ADDR(Control_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pControl_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_ClientToParent)
TPoint
Control_ClientToParent(TControl AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Control_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pControl_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_Dragging)
BOOL
Control_Dragging(TControl AObj) {
    GET_FUNC_ADDR(Control_Dragging)
    return (BOOL)(((SYSCALL1) (pControl_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_HasParent)
BOOL
Control_HasParent(TControl AObj) {
    GET_FUNC_ADDR(Control_HasParent)
    return (BOOL)(((SYSCALL1) (pControl_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Hide)
void
Control_Hide(TControl AObj) {
    GET_FUNC_ADDR(Control_Hide)
    (((SYSCALL1) (pControl_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Invalidate)
void
Control_Invalidate(TControl AObj) {
    GET_FUNC_ADDR(Control_Invalidate)
    (((SYSCALL1) (pControl_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Perform)
intptr_t
Control_Perform(TControl AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(Control_Perform)
    return (intptr_t)(((SYSCALL4) (pControl_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(Control_Refresh)
void
Control_Refresh(TControl AObj) {
    GET_FUNC_ADDR(Control_Refresh)
    (((SYSCALL1) (pControl_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Repaint)
void
Control_Repaint(TControl AObj) {
    GET_FUNC_ADDR(Control_Repaint)
    (((SYSCALL1) (pControl_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_ScreenToClient)
TPoint
Control_ScreenToClient(TControl AObj, TPoint Point) {
    GET_FUNC_ADDR(Control_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pControl_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_ParentToClient)
TPoint
Control_ParentToClient(TControl AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Control_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pControl_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_SendToBack)
void
Control_SendToBack(TControl AObj) {
    GET_FUNC_ADDR(Control_SendToBack)
    (((SYSCALL1) (pControl_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetBounds)
void
Control_SetBounds(TControl AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(Control_SetBounds)
    (((SYSCALL5) (pControl_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(Control_Show)
void
Control_Show(TControl AObj) {
    GET_FUNC_ADDR(Control_Show)
    (((SYSCALL1) (pControl_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Update)
void
Control_Update(TControl AObj) {
    GET_FUNC_ADDR(Control_Update)
    (((SYSCALL1) (pControl_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_GetTextBuf)
int32_t
Control_GetTextBuf(TControl AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(Control_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pControl_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(Control_GetTextLen)
int32_t
Control_GetTextLen(TControl AObj) {
    GET_FUNC_ADDR(Control_GetTextLen)
    return (int32_t)(((SYSCALL1) (pControl_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetTextBuf)
void
Control_SetTextBuf(TControl AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(Control_SetTextBuf)
    (((SYSCALL2) (pControl_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(Control_FindComponent)
TComponent
Control_FindComponent(TControl AObj, CChar char* AName) {
    GET_FUNC_ADDR(Control_FindComponent)
    return (TComponent)(((SYSCALL2) (pControl_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Control_GetNamePath)
char*
Control_GetNamePath(TControl AObj) {
    GET_FUNC_ADDR(Control_GetNamePath)
    return (char*)(((SYSCALL1) (pControl_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_Assign)
void
Control_Assign(TControl AObj, TObject Source) {
    GET_FUNC_ADDR(Control_Assign)
    (((SYSCALL2) (pControl_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Control_ClassType)
TClass
Control_ClassType(TControl AObj) {
    GET_FUNC_ADDR(Control_ClassType)
    return (TClass)(((SYSCALL1) (pControl_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_ClassName)
char*
Control_ClassName(TControl AObj) {
    GET_FUNC_ADDR(Control_ClassName)
    return (char*)(((SYSCALL1) (pControl_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_InstanceSize)
int32_t
Control_InstanceSize(TControl AObj) {
    GET_FUNC_ADDR(Control_InstanceSize)
    return (int32_t)(((SYSCALL1) (pControl_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_InheritsFrom)
BOOL
Control_InheritsFrom(TControl AObj, TClass AClass) {
    GET_FUNC_ADDR(Control_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pControl_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Control_Equals)
BOOL
Control_Equals(TControl AObj, TObject Obj) {
    GET_FUNC_ADDR(Control_Equals)
    return (BOOL)(((SYSCALL2) (pControl_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Control_GetHashCode)
int32_t
Control_GetHashCode(TControl AObj) {
    GET_FUNC_ADDR(Control_GetHashCode)
    return (int32_t)(((SYSCALL1) (pControl_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_ToString)
char*
Control_ToString(TControl AObj) {
    GET_FUNC_ADDR(Control_ToString)
    return (char*)(((SYSCALL1) (pControl_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_AnchorToNeighbour)
void
Control_AnchorToNeighbour(TControl AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Control_AnchorToNeighbour)
    (((SYSCALL4) (pControl_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Control_AnchorParallel)
void
Control_AnchorParallel(TControl AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Control_AnchorParallel)
    (((SYSCALL4) (pControl_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Control_AnchorHorizontalCenterTo)
void
Control_AnchorHorizontalCenterTo(TControl AObj, TControl ASibling) {
    GET_FUNC_ADDR(Control_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pControl_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Control_AnchorVerticalCenterTo)
void
Control_AnchorVerticalCenterTo(TControl AObj, TControl ASibling) {
    GET_FUNC_ADDR(Control_AnchorVerticalCenterTo)
    (((SYSCALL2) (pControl_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Control_AnchorSame)
void
Control_AnchorSame(TControl AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(Control_AnchorSame)
    (((SYSCALL3) (pControl_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Control_AnchorAsAlign)
void
Control_AnchorAsAlign(TControl AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(Control_AnchorAsAlign)
    (((SYSCALL3) (pControl_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Control_AnchorClient)
void
Control_AnchorClient(TControl AObj, int32_t ASpace) {
    GET_FUNC_ADDR(Control_AnchorClient)
    (((SYSCALL2) (pControl_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Control_ScaleDesignToForm)
int32_t
Control_ScaleDesignToForm(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pControl_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleFormToDesign)
int32_t
Control_ScaleFormToDesign(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pControl_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_Scale96ToForm)
int32_t
Control_Scale96ToForm(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pControl_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleFormTo96)
int32_t
Control_ScaleFormTo96(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pControl_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_Scale96ToFont)
int32_t
Control_Scale96ToFont(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pControl_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleFontTo96)
int32_t
Control_ScaleFontTo96(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pControl_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleScreenToFont)
int32_t
Control_ScaleScreenToFont(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pControl_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleFontToScreen)
int32_t
Control_ScaleFontToScreen(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pControl_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_Scale96ToScreen)
int32_t
Control_Scale96ToScreen(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pControl_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_ScaleScreenTo96)
int32_t
Control_ScaleScreenTo96(TControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(Control_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pControl_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Control_AutoAdjustLayout)
void
Control_AutoAdjustLayout(TControl AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(Control_AutoAdjustLayout)
    (((SYSCALL6) (pControl_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(Control_FixDesignFontsPPI)
void
Control_FixDesignFontsPPI(TControl AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(Control_FixDesignFontsPPI)
    (((SYSCALL2) (pControl_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(Control_ScaleFontsPPI)
void
Control_ScaleFontsPPI(TControl AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(Control_ScaleFontsPPI)
    (((SYSCALL3) (pControl_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(Control_GetEnabled)
BOOL
Control_GetEnabled(TControl AObj) {
    GET_FUNC_ADDR(Control_GetEnabled)
    return (BOOL)(((SYSCALL1) (pControl_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetEnabled)
void
Control_SetEnabled(TControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(Control_SetEnabled)
    (((SYSCALL2) (pControl_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAction)
TAction
Control_GetAction(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAction)
    return (TAction)(((SYSCALL1) (pControl_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAction)
void
Control_SetAction(TControl AObj, TAction AValue) {
    GET_FUNC_ADDR(Control_SetAction)
    (((SYSCALL2) (pControl_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAlign)
TAlign
Control_GetAlign(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAlign)
    return (TAlign)(((SYSCALL1) (pControl_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAlign)
void
Control_SetAlign(TControl AObj, TAlign AValue) {
    GET_FUNC_ADDR(Control_SetAlign)
    (((SYSCALL2) (pControl_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAnchors)
TAnchors
Control_GetAnchors(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pControl_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAnchors)
void
Control_SetAnchors(TControl AObj, TAnchors AValue) {
    GET_FUNC_ADDR(Control_SetAnchors)
    (((SYSCALL2) (pControl_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetBiDiMode)
TBiDiMode
Control_GetBiDiMode(TControl AObj) {
    GET_FUNC_ADDR(Control_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pControl_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetBiDiMode)
void
Control_SetBiDiMode(TControl AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(Control_SetBiDiMode)
    (((SYSCALL2) (pControl_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetBoundsRect)
TRect
Control_GetBoundsRect(TControl AObj) {
    GET_FUNC_ADDR(Control_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pControl_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_SetBoundsRect)
void
Control_SetBoundsRect(TControl AObj, TRect AValue) {
    GET_FUNC_ADDR(Control_SetBoundsRect)
    (((SYSCALL2) (pControl_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(Control_GetClientHeight)
int32_t
Control_GetClientHeight(TControl AObj) {
    GET_FUNC_ADDR(Control_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pControl_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetClientHeight)
void
Control_SetClientHeight(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetClientHeight)
    (((SYSCALL2) (pControl_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetClientOrigin)
TPoint
Control_GetClientOrigin(TControl AObj) {
    GET_FUNC_ADDR(Control_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pControl_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_GetClientRect)
TRect
Control_GetClientRect(TControl AObj) {
    GET_FUNC_ADDR(Control_GetClientRect)
    TRect result;
    (((SYSCALL2) (pControl_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Control_GetClientWidth)
int32_t
Control_GetClientWidth(TControl AObj) {
    GET_FUNC_ADDR(Control_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pControl_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetClientWidth)
void
Control_SetClientWidth(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetClientWidth)
    (((SYSCALL2) (pControl_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetConstraints)
TSizeConstraints
Control_GetConstraints(TControl AObj) {
    GET_FUNC_ADDR(Control_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pControl_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetConstraints)
void
Control_SetConstraints(TControl AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(Control_SetConstraints)
    (((SYSCALL2) (pControl_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetControlState)
TControlState
Control_GetControlState(TControl AObj) {
    GET_FUNC_ADDR(Control_GetControlState)
    return (TControlState)(((SYSCALL1) (pControl_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetControlState)
void
Control_SetControlState(TControl AObj, TControlState AValue) {
    GET_FUNC_ADDR(Control_SetControlState)
    (((SYSCALL2) (pControl_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetControlStyle)
TControlStyle
Control_GetControlStyle(TControl AObj) {
    GET_FUNC_ADDR(Control_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pControl_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetControlStyle)
void
Control_SetControlStyle(TControl AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(Control_SetControlStyle)
    (((SYSCALL2) (pControl_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetFloating)
BOOL
Control_GetFloating(TControl AObj) {
    GET_FUNC_ADDR(Control_GetFloating)
    return (BOOL)(((SYSCALL1) (pControl_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_GetShowHint)
BOOL
Control_GetShowHint(TControl AObj) {
    GET_FUNC_ADDR(Control_GetShowHint)
    return (BOOL)(((SYSCALL1) (pControl_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetShowHint)
void
Control_SetShowHint(TControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(Control_SetShowHint)
    (((SYSCALL2) (pControl_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetVisible)
BOOL
Control_GetVisible(TControl AObj) {
    GET_FUNC_ADDR(Control_GetVisible)
    return (BOOL)(((SYSCALL1) (pControl_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetVisible)
void
Control_SetVisible(TControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(Control_SetVisible)
    (((SYSCALL2) (pControl_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetParent)
TWinControl
Control_GetParent(TControl AObj) {
    GET_FUNC_ADDR(Control_GetParent)
    return (TWinControl)(((SYSCALL1) (pControl_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetParent)
void
Control_SetParent(TControl AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Control_SetParent)
    (((SYSCALL2) (pControl_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetLeft)
int32_t
Control_GetLeft(TControl AObj) {
    GET_FUNC_ADDR(Control_GetLeft)
    return (int32_t)(((SYSCALL1) (pControl_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetLeft)
void
Control_SetLeft(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetLeft)
    (((SYSCALL2) (pControl_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetTop)
int32_t
Control_GetTop(TControl AObj) {
    GET_FUNC_ADDR(Control_GetTop)
    return (int32_t)(((SYSCALL1) (pControl_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetTop)
void
Control_SetTop(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetTop)
    (((SYSCALL2) (pControl_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetWidth)
int32_t
Control_GetWidth(TControl AObj) {
    GET_FUNC_ADDR(Control_GetWidth)
    return (int32_t)(((SYSCALL1) (pControl_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetWidth)
void
Control_SetWidth(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetWidth)
    (((SYSCALL2) (pControl_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetHeight)
int32_t
Control_GetHeight(TControl AObj) {
    GET_FUNC_ADDR(Control_GetHeight)
    return (int32_t)(((SYSCALL1) (pControl_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetHeight)
void
Control_SetHeight(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetHeight)
    (((SYSCALL2) (pControl_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetCursor)
TCursor
Control_GetCursor(TControl AObj) {
    GET_FUNC_ADDR(Control_GetCursor)
    return (TCursor)(((SYSCALL1) (pControl_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetCursor)
void
Control_SetCursor(TControl AObj, TCursor AValue) {
    GET_FUNC_ADDR(Control_SetCursor)
    (((SYSCALL2) (pControl_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetHint)
char*
Control_GetHint(TControl AObj) {
    GET_FUNC_ADDR(Control_GetHint)
    return (char*)(((SYSCALL1) (pControl_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetHint)
void
Control_SetHint(TControl AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Control_SetHint)
    (((SYSCALL2) (pControl_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetComponentCount)
int32_t
Control_GetComponentCount(TControl AObj) {
    GET_FUNC_ADDR(Control_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pControl_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_GetComponentIndex)
int32_t
Control_GetComponentIndex(TControl AObj) {
    GET_FUNC_ADDR(Control_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pControl_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetComponentIndex)
void
Control_SetComponentIndex(TControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(Control_SetComponentIndex)
    (((SYSCALL2) (pControl_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetOwner)
TComponent
Control_GetOwner(TControl AObj) {
    GET_FUNC_ADDR(Control_GetOwner)
    return (TComponent)(((SYSCALL1) (pControl_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_GetName)
char*
Control_GetName(TControl AObj) {
    GET_FUNC_ADDR(Control_GetName)
    return (char*)(((SYSCALL1) (pControl_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetName)
void
Control_SetName(TControl AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Control_SetName)
    (((SYSCALL2) (pControl_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetTag)
intptr_t
Control_GetTag(TControl AObj) {
    GET_FUNC_ADDR(Control_GetTag)
    return (intptr_t)(((SYSCALL1) (pControl_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetTag)
void
Control_SetTag(TControl AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Control_SetTag)
    (((SYSCALL2) (pControl_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAnchorSideLeft)
TAnchorSide
Control_GetAnchorSideLeft(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pControl_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAnchorSideLeft)
void
Control_SetAnchorSideLeft(TControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Control_SetAnchorSideLeft)
    (((SYSCALL2) (pControl_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAnchorSideTop)
TAnchorSide
Control_GetAnchorSideTop(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pControl_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAnchorSideTop)
void
Control_SetAnchorSideTop(TControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Control_SetAnchorSideTop)
    (((SYSCALL2) (pControl_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAnchorSideRight)
TAnchorSide
Control_GetAnchorSideRight(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pControl_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAnchorSideRight)
void
Control_SetAnchorSideRight(TControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Control_SetAnchorSideRight)
    (((SYSCALL2) (pControl_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetAnchorSideBottom)
TAnchorSide
Control_GetAnchorSideBottom(TControl AObj) {
    GET_FUNC_ADDR(Control_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pControl_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetAnchorSideBottom)
void
Control_SetAnchorSideBottom(TControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Control_SetAnchorSideBottom)
    (((SYSCALL2) (pControl_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetBorderSpacing)
TControlBorderSpacing
Control_GetBorderSpacing(TControl AObj) {
    GET_FUNC_ADDR(Control_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pControl_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Control_SetBorderSpacing)
void
Control_SetBorderSpacing(TControl AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(Control_SetBorderSpacing)
    (((SYSCALL2) (pControl_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Control_GetComponents)
TComponent
Control_GetComponents(TControl AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Control_GetComponents)
    return (TComponent)(((SYSCALL2) (pControl_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Control_GetAnchorSide)
TAnchorSide
Control_GetAnchorSide(TControl AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(Control_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pControl_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(Control_StaticClassType)
TClass
Control_StaticClassType() {
    GET_FUNC_ADDR(Control_StaticClassType)
    return (TClass)(((SYSCALL0) (pControl_StaticClassType))());
}

// -------------------TWinControl-------------------

DEFINE_FUNC_PTR(WinControl_Create)
TWinControl
WinControl_Create(TComponent AOwner) {
    GET_FUNC_ADDR(WinControl_Create)
    return (TWinControl)(((SYSCALL1) (pWinControl_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(WinControl_Free)
void
WinControl_Free(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Free)
    (((SYSCALL1) (pWinControl_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_CanFocus)
BOOL
WinControl_CanFocus(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_CanFocus)
    return (BOOL)(((SYSCALL1) (pWinControl_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ContainsControl)
BOOL
WinControl_ContainsControl(TWinControl AObj, TControl Control) {
    GET_FUNC_ADDR(WinControl_ContainsControl)
    return (BOOL)(((SYSCALL2) (pWinControl_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(WinControl_ControlAtPos)
TControl
WinControl_ControlAtPos(TWinControl AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(WinControl_ControlAtPos)
    return (TControl)(((SYSCALL4) (pWinControl_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(WinControl_DisableAlign)
void
WinControl_DisableAlign(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_DisableAlign)
    (((SYSCALL1) (pWinControl_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_EnableAlign)
void
WinControl_EnableAlign(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_EnableAlign)
    (((SYSCALL1) (pWinControl_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_FindChildControl)
TControl
WinControl_FindChildControl(TWinControl AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(WinControl_FindChildControl)
    return (TControl)(((SYSCALL2) (pWinControl_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(WinControl_FlipChildren)
void
WinControl_FlipChildren(TWinControl AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(WinControl_FlipChildren)
    (((SYSCALL2) (pWinControl_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(WinControl_Focused)
BOOL
WinControl_Focused(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Focused)
    return (BOOL)(((SYSCALL1) (pWinControl_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_HandleAllocated)
BOOL
WinControl_HandleAllocated(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pWinControl_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_InsertControl)
void
WinControl_InsertControl(TWinControl AObj, TControl AControl) {
    GET_FUNC_ADDR(WinControl_InsertControl)
    (((SYSCALL2) (pWinControl_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(WinControl_Invalidate)
void
WinControl_Invalidate(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Invalidate)
    (((SYSCALL1) (pWinControl_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_PaintTo)
void
WinControl_PaintTo(TWinControl AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(WinControl_PaintTo)
    (((SYSCALL4) (pWinControl_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(WinControl_RemoveControl)
void
WinControl_RemoveControl(TWinControl AObj, TControl AControl) {
    GET_FUNC_ADDR(WinControl_RemoveControl)
    (((SYSCALL2) (pWinControl_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(WinControl_Realign)
void
WinControl_Realign(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Realign)
    (((SYSCALL1) (pWinControl_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Repaint)
void
WinControl_Repaint(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Repaint)
    (((SYSCALL1) (pWinControl_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ScaleBy)
void
WinControl_ScaleBy(TWinControl AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(WinControl_ScaleBy)
    (((SYSCALL3) (pWinControl_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(WinControl_ScrollBy)
void
WinControl_ScrollBy(TWinControl AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(WinControl_ScrollBy)
    (((SYSCALL3) (pWinControl_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(WinControl_SetBounds)
void
WinControl_SetBounds(TWinControl AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(WinControl_SetBounds)
    (((SYSCALL5) (pWinControl_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(WinControl_SetFocus)
void
WinControl_SetFocus(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_SetFocus)
    (((SYSCALL1) (pWinControl_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Update)
void
WinControl_Update(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Update)
    (((SYSCALL1) (pWinControl_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_BringToFront)
void
WinControl_BringToFront(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_BringToFront)
    (((SYSCALL1) (pWinControl_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ClientToScreen)
TPoint
WinControl_ClientToScreen(TWinControl AObj, TPoint Point) {
    GET_FUNC_ADDR(WinControl_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pWinControl_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_ClientToParent)
TPoint
WinControl_ClientToParent(TWinControl AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(WinControl_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pWinControl_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_Dragging)
BOOL
WinControl_Dragging(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Dragging)
    return (BOOL)(((SYSCALL1) (pWinControl_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_HasParent)
BOOL
WinControl_HasParent(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_HasParent)
    return (BOOL)(((SYSCALL1) (pWinControl_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Hide)
void
WinControl_Hide(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Hide)
    (((SYSCALL1) (pWinControl_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Perform)
intptr_t
WinControl_Perform(TWinControl AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(WinControl_Perform)
    return (intptr_t)(((SYSCALL4) (pWinControl_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(WinControl_Refresh)
void
WinControl_Refresh(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Refresh)
    (((SYSCALL1) (pWinControl_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ScreenToClient)
TPoint
WinControl_ScreenToClient(TWinControl AObj, TPoint Point) {
    GET_FUNC_ADDR(WinControl_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pWinControl_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_ParentToClient)
TPoint
WinControl_ParentToClient(TWinControl AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(WinControl_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pWinControl_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_SendToBack)
void
WinControl_SendToBack(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_SendToBack)
    (((SYSCALL1) (pWinControl_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Show)
void
WinControl_Show(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_Show)
    (((SYSCALL1) (pWinControl_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetTextBuf)
int32_t
WinControl_GetTextBuf(TWinControl AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(WinControl_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pWinControl_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(WinControl_GetTextLen)
int32_t
WinControl_GetTextLen(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetTextLen)
    return (int32_t)(((SYSCALL1) (pWinControl_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetTextBuf)
void
WinControl_SetTextBuf(TWinControl AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(WinControl_SetTextBuf)
    (((SYSCALL2) (pWinControl_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(WinControl_FindComponent)
TComponent
WinControl_FindComponent(TWinControl AObj, CChar char* AName) {
    GET_FUNC_ADDR(WinControl_FindComponent)
    return (TComponent)(((SYSCALL2) (pWinControl_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(WinControl_GetNamePath)
char*
WinControl_GetNamePath(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetNamePath)
    return (char*)(((SYSCALL1) (pWinControl_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_Assign)
void
WinControl_Assign(TWinControl AObj, TObject Source) {
    GET_FUNC_ADDR(WinControl_Assign)
    (((SYSCALL2) (pWinControl_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(WinControl_ClassType)
TClass
WinControl_ClassType(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_ClassType)
    return (TClass)(((SYSCALL1) (pWinControl_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ClassName)
char*
WinControl_ClassName(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_ClassName)
    return (char*)(((SYSCALL1) (pWinControl_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_InstanceSize)
int32_t
WinControl_InstanceSize(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_InstanceSize)
    return (int32_t)(((SYSCALL1) (pWinControl_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_InheritsFrom)
BOOL
WinControl_InheritsFrom(TWinControl AObj, TClass AClass) {
    GET_FUNC_ADDR(WinControl_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pWinControl_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(WinControl_Equals)
BOOL
WinControl_Equals(TWinControl AObj, TObject Obj) {
    GET_FUNC_ADDR(WinControl_Equals)
    return (BOOL)(((SYSCALL2) (pWinControl_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(WinControl_GetHashCode)
int32_t
WinControl_GetHashCode(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetHashCode)
    return (int32_t)(((SYSCALL1) (pWinControl_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_ToString)
char*
WinControl_ToString(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_ToString)
    return (char*)(((SYSCALL1) (pWinControl_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_AnchorToNeighbour)
void
WinControl_AnchorToNeighbour(TWinControl AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(WinControl_AnchorToNeighbour)
    (((SYSCALL4) (pWinControl_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(WinControl_AnchorParallel)
void
WinControl_AnchorParallel(TWinControl AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(WinControl_AnchorParallel)
    (((SYSCALL4) (pWinControl_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(WinControl_AnchorHorizontalCenterTo)
void
WinControl_AnchorHorizontalCenterTo(TWinControl AObj, TControl ASibling) {
    GET_FUNC_ADDR(WinControl_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pWinControl_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(WinControl_AnchorVerticalCenterTo)
void
WinControl_AnchorVerticalCenterTo(TWinControl AObj, TControl ASibling) {
    GET_FUNC_ADDR(WinControl_AnchorVerticalCenterTo)
    (((SYSCALL2) (pWinControl_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(WinControl_AnchorSame)
void
WinControl_AnchorSame(TWinControl AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(WinControl_AnchorSame)
    (((SYSCALL3) (pWinControl_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(WinControl_AnchorAsAlign)
void
WinControl_AnchorAsAlign(TWinControl AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(WinControl_AnchorAsAlign)
    (((SYSCALL3) (pWinControl_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(WinControl_AnchorClient)
void
WinControl_AnchorClient(TWinControl AObj, int32_t ASpace) {
    GET_FUNC_ADDR(WinControl_AnchorClient)
    (((SYSCALL2) (pWinControl_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(WinControl_ScaleDesignToForm)
int32_t
WinControl_ScaleDesignToForm(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleFormToDesign)
int32_t
WinControl_ScaleFormToDesign(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_Scale96ToForm)
int32_t
WinControl_Scale96ToForm(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pWinControl_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleFormTo96)
int32_t
WinControl_ScaleFormTo96(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_Scale96ToFont)
int32_t
WinControl_Scale96ToFont(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pWinControl_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleFontTo96)
int32_t
WinControl_ScaleFontTo96(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleScreenToFont)
int32_t
WinControl_ScaleScreenToFont(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleFontToScreen)
int32_t
WinControl_ScaleFontToScreen(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_Scale96ToScreen)
int32_t
WinControl_Scale96ToScreen(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pWinControl_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_ScaleScreenTo96)
int32_t
WinControl_ScaleScreenTo96(TWinControl AObj, int32_t ASize) {
    GET_FUNC_ADDR(WinControl_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pWinControl_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(WinControl_AutoAdjustLayout)
void
WinControl_AutoAdjustLayout(TWinControl AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(WinControl_AutoAdjustLayout)
    (((SYSCALL6) (pWinControl_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(WinControl_FixDesignFontsPPI)
void
WinControl_FixDesignFontsPPI(TWinControl AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(WinControl_FixDesignFontsPPI)
    (((SYSCALL2) (pWinControl_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(WinControl_ScaleFontsPPI)
void
WinControl_ScaleFontsPPI(TWinControl AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(WinControl_ScaleFontsPPI)
    (((SYSCALL3) (pWinControl_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(WinControl_GetDockClientCount)
int32_t
WinControl_GetDockClientCount(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pWinControl_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetDockSite)
BOOL
WinControl_GetDockSite(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetDockSite)
    return (BOOL)(((SYSCALL1) (pWinControl_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetDockSite)
void
WinControl_SetDockSite(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetDockSite)
    (((SYSCALL2) (pWinControl_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetDoubleBuffered)
BOOL
WinControl_GetDoubleBuffered(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pWinControl_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetDoubleBuffered)
void
WinControl_SetDoubleBuffered(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetDoubleBuffered)
    (((SYSCALL2) (pWinControl_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetMouseInClient)
BOOL
WinControl_GetMouseInClient(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pWinControl_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetVisibleDockClientCount)
int32_t
WinControl_GetVisibleDockClientCount(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pWinControl_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetBrush)
TBrush
WinControl_GetBrush(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetBrush)
    return (TBrush)(((SYSCALL1) (pWinControl_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetControlCount)
int32_t
WinControl_GetControlCount(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetControlCount)
    return (int32_t)(((SYSCALL1) (pWinControl_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetHandle)
HWND
WinControl_GetHandle(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetHandle)
    return (HWND)(((SYSCALL1) (pWinControl_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetParentDoubleBuffered)
BOOL
WinControl_GetParentDoubleBuffered(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pWinControl_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetParentDoubleBuffered)
void
WinControl_SetParentDoubleBuffered(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetParentDoubleBuffered)
    (((SYSCALL2) (pWinControl_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetParentWindow)
HWND
WinControl_GetParentWindow(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetParentWindow)
    return (HWND)(((SYSCALL1) (pWinControl_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetParentWindow)
void
WinControl_SetParentWindow(TWinControl AObj, HWND AValue) {
    GET_FUNC_ADDR(WinControl_SetParentWindow)
    (((SYSCALL2) (pWinControl_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetShowing)
BOOL
WinControl_GetShowing(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetShowing)
    return (BOOL)(((SYSCALL1) (pWinControl_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetTabOrder)
TTabOrder
WinControl_GetTabOrder(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pWinControl_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetTabOrder)
void
WinControl_SetTabOrder(TWinControl AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(WinControl_SetTabOrder)
    (((SYSCALL2) (pWinControl_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetTabStop)
BOOL
WinControl_GetTabStop(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetTabStop)
    return (BOOL)(((SYSCALL1) (pWinControl_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetTabStop)
void
WinControl_SetTabStop(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetTabStop)
    (((SYSCALL2) (pWinControl_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetUseDockManager)
BOOL
WinControl_GetUseDockManager(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pWinControl_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetUseDockManager)
void
WinControl_SetUseDockManager(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetUseDockManager)
    (((SYSCALL2) (pWinControl_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetEnabled)
BOOL
WinControl_GetEnabled(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetEnabled)
    return (BOOL)(((SYSCALL1) (pWinControl_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetEnabled)
void
WinControl_SetEnabled(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetEnabled)
    (((SYSCALL2) (pWinControl_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAction)
TAction
WinControl_GetAction(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAction)
    return (TAction)(((SYSCALL1) (pWinControl_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAction)
void
WinControl_SetAction(TWinControl AObj, TAction AValue) {
    GET_FUNC_ADDR(WinControl_SetAction)
    (((SYSCALL2) (pWinControl_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAlign)
TAlign
WinControl_GetAlign(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAlign)
    return (TAlign)(((SYSCALL1) (pWinControl_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAlign)
void
WinControl_SetAlign(TWinControl AObj, TAlign AValue) {
    GET_FUNC_ADDR(WinControl_SetAlign)
    (((SYSCALL2) (pWinControl_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchors)
TAnchors
WinControl_GetAnchors(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pWinControl_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAnchors)
void
WinControl_SetAnchors(TWinControl AObj, TAnchors AValue) {
    GET_FUNC_ADDR(WinControl_SetAnchors)
    (((SYSCALL2) (pWinControl_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetBiDiMode)
TBiDiMode
WinControl_GetBiDiMode(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pWinControl_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetBiDiMode)
void
WinControl_SetBiDiMode(TWinControl AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(WinControl_SetBiDiMode)
    (((SYSCALL2) (pWinControl_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetBoundsRect)
TRect
WinControl_GetBoundsRect(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pWinControl_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_SetBoundsRect)
void
WinControl_SetBoundsRect(TWinControl AObj, TRect AValue) {
    GET_FUNC_ADDR(WinControl_SetBoundsRect)
    (((SYSCALL2) (pWinControl_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetClientHeight)
int32_t
WinControl_GetClientHeight(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pWinControl_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetClientHeight)
void
WinControl_SetClientHeight(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetClientHeight)
    (((SYSCALL2) (pWinControl_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetClientOrigin)
TPoint
WinControl_GetClientOrigin(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pWinControl_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_GetClientRect)
TRect
WinControl_GetClientRect(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetClientRect)
    TRect result;
    (((SYSCALL2) (pWinControl_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(WinControl_GetClientWidth)
int32_t
WinControl_GetClientWidth(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pWinControl_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetClientWidth)
void
WinControl_SetClientWidth(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetClientWidth)
    (((SYSCALL2) (pWinControl_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetConstraints)
TSizeConstraints
WinControl_GetConstraints(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pWinControl_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetConstraints)
void
WinControl_SetConstraints(TWinControl AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(WinControl_SetConstraints)
    (((SYSCALL2) (pWinControl_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetControlState)
TControlState
WinControl_GetControlState(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetControlState)
    return (TControlState)(((SYSCALL1) (pWinControl_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetControlState)
void
WinControl_SetControlState(TWinControl AObj, TControlState AValue) {
    GET_FUNC_ADDR(WinControl_SetControlState)
    (((SYSCALL2) (pWinControl_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetControlStyle)
TControlStyle
WinControl_GetControlStyle(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pWinControl_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetControlStyle)
void
WinControl_SetControlStyle(TWinControl AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(WinControl_SetControlStyle)
    (((SYSCALL2) (pWinControl_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetFloating)
BOOL
WinControl_GetFloating(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetFloating)
    return (BOOL)(((SYSCALL1) (pWinControl_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetShowHint)
BOOL
WinControl_GetShowHint(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetShowHint)
    return (BOOL)(((SYSCALL1) (pWinControl_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetShowHint)
void
WinControl_SetShowHint(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetShowHint)
    (((SYSCALL2) (pWinControl_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetVisible)
BOOL
WinControl_GetVisible(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetVisible)
    return (BOOL)(((SYSCALL1) (pWinControl_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetVisible)
void
WinControl_SetVisible(TWinControl AObj, BOOL AValue) {
    GET_FUNC_ADDR(WinControl_SetVisible)
    (((SYSCALL2) (pWinControl_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetParent)
TWinControl
WinControl_GetParent(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetParent)
    return (TWinControl)(((SYSCALL1) (pWinControl_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetParent)
void
WinControl_SetParent(TWinControl AObj, TWinControl AValue) {
    GET_FUNC_ADDR(WinControl_SetParent)
    (((SYSCALL2) (pWinControl_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetLeft)
int32_t
WinControl_GetLeft(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetLeft)
    return (int32_t)(((SYSCALL1) (pWinControl_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetLeft)
void
WinControl_SetLeft(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetLeft)
    (((SYSCALL2) (pWinControl_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetTop)
int32_t
WinControl_GetTop(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetTop)
    return (int32_t)(((SYSCALL1) (pWinControl_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetTop)
void
WinControl_SetTop(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetTop)
    (((SYSCALL2) (pWinControl_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetWidth)
int32_t
WinControl_GetWidth(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetWidth)
    return (int32_t)(((SYSCALL1) (pWinControl_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetWidth)
void
WinControl_SetWidth(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetWidth)
    (((SYSCALL2) (pWinControl_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetHeight)
int32_t
WinControl_GetHeight(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetHeight)
    return (int32_t)(((SYSCALL1) (pWinControl_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetHeight)
void
WinControl_SetHeight(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetHeight)
    (((SYSCALL2) (pWinControl_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetCursor)
TCursor
WinControl_GetCursor(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetCursor)
    return (TCursor)(((SYSCALL1) (pWinControl_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetCursor)
void
WinControl_SetCursor(TWinControl AObj, TCursor AValue) {
    GET_FUNC_ADDR(WinControl_SetCursor)
    (((SYSCALL2) (pWinControl_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetHint)
char*
WinControl_GetHint(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetHint)
    return (char*)(((SYSCALL1) (pWinControl_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetHint)
void
WinControl_SetHint(TWinControl AObj, CChar char* AValue) {
    GET_FUNC_ADDR(WinControl_SetHint)
    (((SYSCALL2) (pWinControl_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetComponentCount)
int32_t
WinControl_GetComponentCount(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pWinControl_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetComponentIndex)
int32_t
WinControl_GetComponentIndex(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pWinControl_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetComponentIndex)
void
WinControl_SetComponentIndex(TWinControl AObj, int32_t AValue) {
    GET_FUNC_ADDR(WinControl_SetComponentIndex)
    (((SYSCALL2) (pWinControl_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetOwner)
TComponent
WinControl_GetOwner(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetOwner)
    return (TComponent)(((SYSCALL1) (pWinControl_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_GetName)
char*
WinControl_GetName(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetName)
    return (char*)(((SYSCALL1) (pWinControl_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetName)
void
WinControl_SetName(TWinControl AObj, CChar char* AValue) {
    GET_FUNC_ADDR(WinControl_SetName)
    (((SYSCALL2) (pWinControl_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetTag)
intptr_t
WinControl_GetTag(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetTag)
    return (intptr_t)(((SYSCALL1) (pWinControl_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetTag)
void
WinControl_SetTag(TWinControl AObj, intptr_t AValue) {
    GET_FUNC_ADDR(WinControl_SetTag)
    (((SYSCALL2) (pWinControl_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchorSideLeft)
TAnchorSide
WinControl_GetAnchorSideLeft(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pWinControl_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAnchorSideLeft)
void
WinControl_SetAnchorSideLeft(TWinControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(WinControl_SetAnchorSideLeft)
    (((SYSCALL2) (pWinControl_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchorSideTop)
TAnchorSide
WinControl_GetAnchorSideTop(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pWinControl_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAnchorSideTop)
void
WinControl_SetAnchorSideTop(TWinControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(WinControl_SetAnchorSideTop)
    (((SYSCALL2) (pWinControl_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchorSideRight)
TAnchorSide
WinControl_GetAnchorSideRight(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pWinControl_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAnchorSideRight)
void
WinControl_SetAnchorSideRight(TWinControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(WinControl_SetAnchorSideRight)
    (((SYSCALL2) (pWinControl_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchorSideBottom)
TAnchorSide
WinControl_GetAnchorSideBottom(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pWinControl_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetAnchorSideBottom)
void
WinControl_SetAnchorSideBottom(TWinControl AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(WinControl_SetAnchorSideBottom)
    (((SYSCALL2) (pWinControl_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetChildSizing)
TControlChildSizing
WinControl_GetChildSizing(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pWinControl_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetChildSizing)
void
WinControl_SetChildSizing(TWinControl AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(WinControl_SetChildSizing)
    (((SYSCALL2) (pWinControl_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetBorderSpacing)
TControlBorderSpacing
WinControl_GetBorderSpacing(TWinControl AObj) {
    GET_FUNC_ADDR(WinControl_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pWinControl_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(WinControl_SetBorderSpacing)
void
WinControl_SetBorderSpacing(TWinControl AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(WinControl_SetBorderSpacing)
    (((SYSCALL2) (pWinControl_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(WinControl_GetDockClients)
TControl
WinControl_GetDockClients(TWinControl AObj, int32_t Index) {
    GET_FUNC_ADDR(WinControl_GetDockClients)
    return (TControl)(((SYSCALL2) (pWinControl_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(WinControl_GetControls)
TControl
WinControl_GetControls(TWinControl AObj, int32_t Index) {
    GET_FUNC_ADDR(WinControl_GetControls)
    return (TControl)(((SYSCALL2) (pWinControl_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(WinControl_GetComponents)
TComponent
WinControl_GetComponents(TWinControl AObj, int32_t AIndex) {
    GET_FUNC_ADDR(WinControl_GetComponents)
    return (TComponent)(((SYSCALL2) (pWinControl_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(WinControl_GetAnchorSide)
TAnchorSide
WinControl_GetAnchorSide(TWinControl AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(WinControl_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pWinControl_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(WinControl_StaticClassType)
TClass
WinControl_StaticClassType() {
    GET_FUNC_ADDR(WinControl_StaticClassType)
    return (TClass)(((SYSCALL0) (pWinControl_StaticClassType))());
}

// -------------------TGraphic-------------------

DEFINE_FUNC_PTR(Graphic_Create)
TGraphic
Graphic_Create() {
    GET_FUNC_ADDR(Graphic_Create)
    return (TGraphic)(((SYSCALL0) (pGraphic_Create))());
}

DEFINE_FUNC_PTR(Graphic_Free)
void
Graphic_Free(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_Free)
    (((SYSCALL1) (pGraphic_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_Equals)
BOOL
Graphic_Equals(TGraphic AObj, TObject Obj) {
    GET_FUNC_ADDR(Graphic_Equals)
    return (BOOL)(((SYSCALL2) (pGraphic_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Graphic_LoadFromFile)
void
Graphic_LoadFromFile(TGraphic AObj, CChar char* Filename) {
    GET_FUNC_ADDR(Graphic_LoadFromFile)
    (((SYSCALL2) (pGraphic_LoadFromFile))(COV_PARAM(AObj), COV_PARAM(Filename)));
}

DEFINE_FUNC_PTR(Graphic_SaveToFile)
void
Graphic_SaveToFile(TGraphic AObj, CChar char* Filename) {
    GET_FUNC_ADDR(Graphic_SaveToFile)
    (((SYSCALL2) (pGraphic_SaveToFile))(COV_PARAM(AObj), COV_PARAM(Filename)));
}

DEFINE_FUNC_PTR(Graphic_LoadFromStream)
void
Graphic_LoadFromStream(TGraphic AObj, TStream Stream) {
    GET_FUNC_ADDR(Graphic_LoadFromStream)
    (((SYSCALL2) (pGraphic_LoadFromStream))(COV_PARAM(AObj), COV_PARAM(Stream)));
}

DEFINE_FUNC_PTR(Graphic_SaveToStream)
void
Graphic_SaveToStream(TGraphic AObj, TStream Stream) {
    GET_FUNC_ADDR(Graphic_SaveToStream)
    (((SYSCALL2) (pGraphic_SaveToStream))(COV_PARAM(AObj), COV_PARAM(Stream)));
}

DEFINE_FUNC_PTR(Graphic_Assign)
void
Graphic_Assign(TGraphic AObj, TObject Source) {
    GET_FUNC_ADDR(Graphic_Assign)
    (((SYSCALL2) (pGraphic_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Graphic_GetNamePath)
char*
Graphic_GetNamePath(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetNamePath)
    return (char*)(((SYSCALL1) (pGraphic_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_ClassType)
TClass
Graphic_ClassType(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_ClassType)
    return (TClass)(((SYSCALL1) (pGraphic_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_ClassName)
char*
Graphic_ClassName(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_ClassName)
    return (char*)(((SYSCALL1) (pGraphic_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_InstanceSize)
int32_t
Graphic_InstanceSize(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_InstanceSize)
    return (int32_t)(((SYSCALL1) (pGraphic_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_InheritsFrom)
BOOL
Graphic_InheritsFrom(TGraphic AObj, TClass AClass) {
    GET_FUNC_ADDR(Graphic_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pGraphic_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Graphic_GetHashCode)
int32_t
Graphic_GetHashCode(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetHashCode)
    return (int32_t)(((SYSCALL1) (pGraphic_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_ToString)
char*
Graphic_ToString(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_ToString)
    return (char*)(((SYSCALL1) (pGraphic_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_GetEmpty)
BOOL
Graphic_GetEmpty(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetEmpty)
    return (BOOL)(((SYSCALL1) (pGraphic_GetEmpty))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_GetHeight)
int32_t
Graphic_GetHeight(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetHeight)
    return (int32_t)(((SYSCALL1) (pGraphic_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetHeight)
void
Graphic_SetHeight(TGraphic AObj, int32_t AValue) {
    GET_FUNC_ADDR(Graphic_SetHeight)
    (((SYSCALL2) (pGraphic_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_GetModified)
BOOL
Graphic_GetModified(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetModified)
    return (BOOL)(((SYSCALL1) (pGraphic_GetModified))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetModified)
void
Graphic_SetModified(TGraphic AObj, BOOL AValue) {
    GET_FUNC_ADDR(Graphic_SetModified)
    (((SYSCALL2) (pGraphic_SetModified))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_GetPalette)
HPALETTE
Graphic_GetPalette(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetPalette)
    return (HPALETTE)(((SYSCALL1) (pGraphic_GetPalette))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetPalette)
void
Graphic_SetPalette(TGraphic AObj, HPALETTE AValue) {
    GET_FUNC_ADDR(Graphic_SetPalette)
    (((SYSCALL2) (pGraphic_SetPalette))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_GetPaletteModified)
BOOL
Graphic_GetPaletteModified(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetPaletteModified)
    return (BOOL)(((SYSCALL1) (pGraphic_GetPaletteModified))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetPaletteModified)
void
Graphic_SetPaletteModified(TGraphic AObj, BOOL AValue) {
    GET_FUNC_ADDR(Graphic_SetPaletteModified)
    (((SYSCALL2) (pGraphic_SetPaletteModified))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_GetTransparent)
BOOL
Graphic_GetTransparent(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetTransparent)
    return (BOOL)(((SYSCALL1) (pGraphic_GetTransparent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetTransparent)
void
Graphic_SetTransparent(TGraphic AObj, BOOL AValue) {
    GET_FUNC_ADDR(Graphic_SetTransparent)
    (((SYSCALL2) (pGraphic_SetTransparent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_GetWidth)
int32_t
Graphic_GetWidth(TGraphic AObj) {
    GET_FUNC_ADDR(Graphic_GetWidth)
    return (int32_t)(((SYSCALL1) (pGraphic_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Graphic_SetWidth)
void
Graphic_SetWidth(TGraphic AObj, int32_t AValue) {
    GET_FUNC_ADDR(Graphic_SetWidth)
    (((SYSCALL2) (pGraphic_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Graphic_SetOnChange)
void
Graphic_SetOnChange(TGraphic AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Graphic_SetOnChange)
    (((SYSCALL2) (pGraphic_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Graphic_StaticClassType)
TClass
Graphic_StaticClassType() {
    GET_FUNC_ADDR(Graphic_StaticClassType)
    return (TClass)(((SYSCALL0) (pGraphic_StaticClassType))());
}

// -------------------TStrings-------------------

DEFINE_FUNC_PTR(Strings_Create)
TStrings
Strings_Create() {
    GET_FUNC_ADDR(Strings_Create)
    return (TStrings)(((SYSCALL0) (pStrings_Create))());
}

DEFINE_FUNC_PTR(Strings_Free)
void
Strings_Free(TStrings AObj) {
    GET_FUNC_ADDR(Strings_Free)
    (((SYSCALL1) (pStrings_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_Add)
int32_t
Strings_Add(TStrings AObj, CChar char* S) {
    GET_FUNC_ADDR(Strings_Add)
    return (int32_t)(((SYSCALL2) (pStrings_Add))(COV_PARAM(AObj), COV_PARAM(S)));
}

DEFINE_FUNC_PTR(Strings_AddObject)
int32_t
Strings_AddObject(TStrings AObj, CChar char* S, TObject AObject) {
    GET_FUNC_ADDR(Strings_AddObject)
    return (int32_t)(((SYSCALL3) (pStrings_AddObject))(COV_PARAM(AObj), COV_PARAM(S), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(Strings_Append)
void
Strings_Append(TStrings AObj, CChar char* S) {
    GET_FUNC_ADDR(Strings_Append)
    (((SYSCALL2) (pStrings_Append))(COV_PARAM(AObj), COV_PARAM(S)));
}

DEFINE_FUNC_PTR(Strings_Assign)
void
Strings_Assign(TStrings AObj, TObject Source) {
    GET_FUNC_ADDR(Strings_Assign)
    (((SYSCALL2) (pStrings_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Strings_BeginUpdate)
void
Strings_BeginUpdate(TStrings AObj) {
    GET_FUNC_ADDR(Strings_BeginUpdate)
    (((SYSCALL1) (pStrings_BeginUpdate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_Clear)
void
Strings_Clear(TStrings AObj) {
    GET_FUNC_ADDR(Strings_Clear)
    (((SYSCALL1) (pStrings_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_Delete)
void
Strings_Delete(TStrings AObj, int32_t Index) {
    GET_FUNC_ADDR(Strings_Delete)
    (((SYSCALL2) (pStrings_Delete))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Strings_EndUpdate)
void
Strings_EndUpdate(TStrings AObj) {
    GET_FUNC_ADDR(Strings_EndUpdate)
    (((SYSCALL1) (pStrings_EndUpdate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_Equals)
BOOL
Strings_Equals(TStrings AObj, TStrings Strings) {
    GET_FUNC_ADDR(Strings_Equals)
    return (BOOL)(((SYSCALL2) (pStrings_Equals))(COV_PARAM(AObj), COV_PARAM(Strings)));
}

DEFINE_FUNC_PTR(Strings_Exchange)
void
Strings_Exchange(TStrings AObj, int32_t Index1, int32_t Index2) {
    GET_FUNC_ADDR(Strings_Exchange)
    (((SYSCALL3) (pStrings_Exchange))(COV_PARAM(AObj), COV_PARAM(Index1), COV_PARAM(Index2)));
}

DEFINE_FUNC_PTR(Strings_IndexOf)
int32_t
Strings_IndexOf(TStrings AObj, CChar char* S) {
    GET_FUNC_ADDR(Strings_IndexOf)
    return (int32_t)(((SYSCALL2) (pStrings_IndexOf))(COV_PARAM(AObj), COV_PARAM(S)));
}

DEFINE_FUNC_PTR(Strings_IndexOfName)
int32_t
Strings_IndexOfName(TStrings AObj, CChar char* Name) {
    GET_FUNC_ADDR(Strings_IndexOfName)
    return (int32_t)(((SYSCALL2) (pStrings_IndexOfName))(COV_PARAM(AObj), COV_PARAM(Name)));
}

DEFINE_FUNC_PTR(Strings_IndexOfObject)
int32_t
Strings_IndexOfObject(TStrings AObj, TObject AObject) {
    GET_FUNC_ADDR(Strings_IndexOfObject)
    return (int32_t)(((SYSCALL2) (pStrings_IndexOfObject))(COV_PARAM(AObj), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(Strings_Insert)
void
Strings_Insert(TStrings AObj, int32_t Index, CChar char* S) {
    GET_FUNC_ADDR(Strings_Insert)
    (((SYSCALL3) (pStrings_Insert))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(S)));
}

DEFINE_FUNC_PTR(Strings_InsertObject)
void
Strings_InsertObject(TStrings AObj, int32_t Index, CChar char* S, TObject AObject) {
    GET_FUNC_ADDR(Strings_InsertObject)
    (((SYSCALL4) (pStrings_InsertObject))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(S), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(Strings_LoadFromFile)
void
Strings_LoadFromFile(TStrings AObj, CChar char* FileName) {
    GET_FUNC_ADDR(Strings_LoadFromFile)
    (((SYSCALL2) (pStrings_LoadFromFile))(COV_PARAM(AObj), COV_PARAM(FileName)));
}

DEFINE_FUNC_PTR(Strings_LoadFromStream)
void
Strings_LoadFromStream(TStrings AObj, TStream Stream) {
    GET_FUNC_ADDR(Strings_LoadFromStream)
    (((SYSCALL2) (pStrings_LoadFromStream))(COV_PARAM(AObj), COV_PARAM(Stream)));
}

DEFINE_FUNC_PTR(Strings_Move)
void
Strings_Move(TStrings AObj, int32_t CurIndex, int32_t NewIndex) {
    GET_FUNC_ADDR(Strings_Move)
    (((SYSCALL3) (pStrings_Move))(COV_PARAM(AObj), COV_PARAM(CurIndex), COV_PARAM(NewIndex)));
}

DEFINE_FUNC_PTR(Strings_SaveToFile)
void
Strings_SaveToFile(TStrings AObj, CChar char* FileName) {
    GET_FUNC_ADDR(Strings_SaveToFile)
    (((SYSCALL2) (pStrings_SaveToFile))(COV_PARAM(AObj), COV_PARAM(FileName)));
}

DEFINE_FUNC_PTR(Strings_SaveToStream)
void
Strings_SaveToStream(TStrings AObj, TStream Stream) {
    GET_FUNC_ADDR(Strings_SaveToStream)
    (((SYSCALL2) (pStrings_SaveToStream))(COV_PARAM(AObj), COV_PARAM(Stream)));
}

DEFINE_FUNC_PTR(Strings_GetNamePath)
char*
Strings_GetNamePath(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetNamePath)
    return (char*)(((SYSCALL1) (pStrings_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_ClassType)
TClass
Strings_ClassType(TStrings AObj) {
    GET_FUNC_ADDR(Strings_ClassType)
    return (TClass)(((SYSCALL1) (pStrings_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_ClassName)
char*
Strings_ClassName(TStrings AObj) {
    GET_FUNC_ADDR(Strings_ClassName)
    return (char*)(((SYSCALL1) (pStrings_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_InstanceSize)
int32_t
Strings_InstanceSize(TStrings AObj) {
    GET_FUNC_ADDR(Strings_InstanceSize)
    return (int32_t)(((SYSCALL1) (pStrings_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_InheritsFrom)
BOOL
Strings_InheritsFrom(TStrings AObj, TClass AClass) {
    GET_FUNC_ADDR(Strings_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pStrings_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Strings_GetHashCode)
int32_t
Strings_GetHashCode(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetHashCode)
    return (int32_t)(((SYSCALL1) (pStrings_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_ToString)
char*
Strings_ToString(TStrings AObj) {
    GET_FUNC_ADDR(Strings_ToString)
    return (char*)(((SYSCALL1) (pStrings_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_GetCapacity)
int32_t
Strings_GetCapacity(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetCapacity)
    return (int32_t)(((SYSCALL1) (pStrings_GetCapacity))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_SetCapacity)
void
Strings_SetCapacity(TStrings AObj, int32_t AValue) {
    GET_FUNC_ADDR(Strings_SetCapacity)
    (((SYSCALL2) (pStrings_SetCapacity))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetCommaText)
char*
Strings_GetCommaText(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetCommaText)
    return (char*)(((SYSCALL1) (pStrings_GetCommaText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_SetCommaText)
void
Strings_SetCommaText(TStrings AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Strings_SetCommaText)
    (((SYSCALL2) (pStrings_SetCommaText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetCount)
int32_t
Strings_GetCount(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetCount)
    return (int32_t)(((SYSCALL1) (pStrings_GetCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_GetDelimiter)
Char
Strings_GetDelimiter(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetDelimiter)
    return (Char)(((SYSCALL1) (pStrings_GetDelimiter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_SetDelimiter)
void
Strings_SetDelimiter(TStrings AObj, Char AValue) {
    GET_FUNC_ADDR(Strings_SetDelimiter)
    (((SYSCALL2) (pStrings_SetDelimiter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetNameValueSeparator)
Char
Strings_GetNameValueSeparator(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetNameValueSeparator)
    return (Char)(((SYSCALL1) (pStrings_GetNameValueSeparator))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_SetNameValueSeparator)
void
Strings_SetNameValueSeparator(TStrings AObj, Char AValue) {
    GET_FUNC_ADDR(Strings_SetNameValueSeparator)
    (((SYSCALL2) (pStrings_SetNameValueSeparator))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetText)
char*
Strings_GetText(TStrings AObj) {
    GET_FUNC_ADDR(Strings_GetText)
    return (char*)(((SYSCALL1) (pStrings_GetText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Strings_SetText)
void
Strings_SetText(TStrings AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Strings_SetText)
    (((SYSCALL2) (pStrings_SetText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetObjects)
TObject
Strings_GetObjects(TStrings AObj, int32_t Index) {
    GET_FUNC_ADDR(Strings_GetObjects)
    return (TObject)(((SYSCALL2) (pStrings_GetObjects))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Strings_SetObjects)
void
Strings_SetObjects(TStrings AObj, int32_t Index, TObject AValue) {
    GET_FUNC_ADDR(Strings_SetObjects)
    (((SYSCALL3) (pStrings_SetObjects))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetValues)
char*
Strings_GetValues(TStrings AObj, CChar char* Name) {
    GET_FUNC_ADDR(Strings_GetValues)
    return (char*)(((SYSCALL2) (pStrings_GetValues))(COV_PARAM(AObj), COV_PARAM(Name)));
}

DEFINE_FUNC_PTR(Strings_SetValues)
void
Strings_SetValues(TStrings AObj, CChar char* Name, CChar char* AValue) {
    GET_FUNC_ADDR(Strings_SetValues)
    (((SYSCALL3) (pStrings_SetValues))(COV_PARAM(AObj), COV_PARAM(Name), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetValueFromIndex)
char*
Strings_GetValueFromIndex(TStrings AObj, int32_t Index) {
    GET_FUNC_ADDR(Strings_GetValueFromIndex)
    return (char*)(((SYSCALL2) (pStrings_GetValueFromIndex))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Strings_SetValueFromIndex)
void
Strings_SetValueFromIndex(TStrings AObj, int32_t Index, CChar char* AValue) {
    GET_FUNC_ADDR(Strings_SetValueFromIndex)
    (((SYSCALL3) (pStrings_SetValueFromIndex))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_GetStrings)
char*
Strings_GetStrings(TStrings AObj, int32_t Index) {
    GET_FUNC_ADDR(Strings_GetStrings)
    return (char*)(((SYSCALL2) (pStrings_GetStrings))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Strings_SetStrings)
void
Strings_SetStrings(TStrings AObj, int32_t Index, CChar char* AValue) {
    GET_FUNC_ADDR(Strings_SetStrings)
    (((SYSCALL3) (pStrings_SetStrings))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Strings_StaticClassType)
TClass
Strings_StaticClassType() {
    GET_FUNC_ADDR(Strings_StaticClassType)
    return (TClass)(((SYSCALL0) (pStrings_StaticClassType))());
}

// -------------------TStream-------------------

// -------------------TCheckBox-------------------

DEFINE_FUNC_PTR(CheckBox_Create)
TCheckBox
CheckBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(CheckBox_Create)
    return (TCheckBox)(((SYSCALL1) (pCheckBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(CheckBox_Free)
void
CheckBox_Free(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Free)
    (((SYSCALL1) (pCheckBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_CanFocus)
BOOL
CheckBox_CanFocus(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pCheckBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ContainsControl)
BOOL
CheckBox_ContainsControl(TCheckBox AObj, TControl Control) {
    GET_FUNC_ADDR(CheckBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pCheckBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(CheckBox_ControlAtPos)
TControl
CheckBox_ControlAtPos(TCheckBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(CheckBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pCheckBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(CheckBox_DisableAlign)
void
CheckBox_DisableAlign(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_DisableAlign)
    (((SYSCALL1) (pCheckBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_EnableAlign)
void
CheckBox_EnableAlign(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_EnableAlign)
    (((SYSCALL1) (pCheckBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_FindChildControl)
TControl
CheckBox_FindChildControl(TCheckBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(CheckBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pCheckBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(CheckBox_FlipChildren)
void
CheckBox_FlipChildren(TCheckBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(CheckBox_FlipChildren)
    (((SYSCALL2) (pCheckBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(CheckBox_Focused)
BOOL
CheckBox_Focused(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Focused)
    return (BOOL)(((SYSCALL1) (pCheckBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_HandleAllocated)
BOOL
CheckBox_HandleAllocated(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pCheckBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_InsertControl)
void
CheckBox_InsertControl(TCheckBox AObj, TControl AControl) {
    GET_FUNC_ADDR(CheckBox_InsertControl)
    (((SYSCALL2) (pCheckBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(CheckBox_Invalidate)
void
CheckBox_Invalidate(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Invalidate)
    (((SYSCALL1) (pCheckBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_PaintTo)
void
CheckBox_PaintTo(TCheckBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(CheckBox_PaintTo)
    (((SYSCALL4) (pCheckBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(CheckBox_RemoveControl)
void
CheckBox_RemoveControl(TCheckBox AObj, TControl AControl) {
    GET_FUNC_ADDR(CheckBox_RemoveControl)
    (((SYSCALL2) (pCheckBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(CheckBox_Realign)
void
CheckBox_Realign(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Realign)
    (((SYSCALL1) (pCheckBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Repaint)
void
CheckBox_Repaint(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Repaint)
    (((SYSCALL1) (pCheckBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleBy)
void
CheckBox_ScaleBy(TCheckBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(CheckBox_ScaleBy)
    (((SYSCALL3) (pCheckBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(CheckBox_ScrollBy)
void
CheckBox_ScrollBy(TCheckBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(CheckBox_ScrollBy)
    (((SYSCALL3) (pCheckBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(CheckBox_SetBounds)
void
CheckBox_SetBounds(TCheckBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(CheckBox_SetBounds)
    (((SYSCALL5) (pCheckBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(CheckBox_SetFocus)
void
CheckBox_SetFocus(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_SetFocus)
    (((SYSCALL1) (pCheckBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Update)
void
CheckBox_Update(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Update)
    (((SYSCALL1) (pCheckBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_BringToFront)
void
CheckBox_BringToFront(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_BringToFront)
    (((SYSCALL1) (pCheckBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ClientToScreen)
TPoint
CheckBox_ClientToScreen(TCheckBox AObj, TPoint Point) {
    GET_FUNC_ADDR(CheckBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pCheckBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_ClientToParent)
TPoint
CheckBox_ClientToParent(TCheckBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(CheckBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pCheckBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_Dragging)
BOOL
CheckBox_Dragging(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Dragging)
    return (BOOL)(((SYSCALL1) (pCheckBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_HasParent)
BOOL
CheckBox_HasParent(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_HasParent)
    return (BOOL)(((SYSCALL1) (pCheckBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Hide)
void
CheckBox_Hide(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Hide)
    (((SYSCALL1) (pCheckBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Perform)
intptr_t
CheckBox_Perform(TCheckBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(CheckBox_Perform)
    return (intptr_t)(((SYSCALL4) (pCheckBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(CheckBox_Refresh)
void
CheckBox_Refresh(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Refresh)
    (((SYSCALL1) (pCheckBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ScreenToClient)
TPoint
CheckBox_ScreenToClient(TCheckBox AObj, TPoint Point) {
    GET_FUNC_ADDR(CheckBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pCheckBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_ParentToClient)
TPoint
CheckBox_ParentToClient(TCheckBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(CheckBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pCheckBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_SendToBack)
void
CheckBox_SendToBack(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_SendToBack)
    (((SYSCALL1) (pCheckBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Show)
void
CheckBox_Show(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_Show)
    (((SYSCALL1) (pCheckBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetTextBuf)
int32_t
CheckBox_GetTextBuf(TCheckBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(CheckBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pCheckBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(CheckBox_GetTextLen)
int32_t
CheckBox_GetTextLen(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetTextBuf)
void
CheckBox_SetTextBuf(TCheckBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(CheckBox_SetTextBuf)
    (((SYSCALL2) (pCheckBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(CheckBox_FindComponent)
TComponent
CheckBox_FindComponent(TCheckBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(CheckBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pCheckBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(CheckBox_GetNamePath)
char*
CheckBox_GetNamePath(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetNamePath)
    return (char*)(((SYSCALL1) (pCheckBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_Assign)
void
CheckBox_Assign(TCheckBox AObj, TObject Source) {
    GET_FUNC_ADDR(CheckBox_Assign)
    (((SYSCALL2) (pCheckBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(CheckBox_ClassType)
TClass
CheckBox_ClassType(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_ClassType)
    return (TClass)(((SYSCALL1) (pCheckBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ClassName)
char*
CheckBox_ClassName(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_ClassName)
    return (char*)(((SYSCALL1) (pCheckBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_InstanceSize)
int32_t
CheckBox_InstanceSize(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pCheckBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_InheritsFrom)
BOOL
CheckBox_InheritsFrom(TCheckBox AObj, TClass AClass) {
    GET_FUNC_ADDR(CheckBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pCheckBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(CheckBox_Equals)
BOOL
CheckBox_Equals(TCheckBox AObj, TObject Obj) {
    GET_FUNC_ADDR(CheckBox_Equals)
    return (BOOL)(((SYSCALL2) (pCheckBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(CheckBox_GetHashCode)
int32_t
CheckBox_GetHashCode(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_ToString)
char*
CheckBox_ToString(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_ToString)
    return (char*)(((SYSCALL1) (pCheckBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorToNeighbour)
void
CheckBox_AnchorToNeighbour(TCheckBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(CheckBox_AnchorToNeighbour)
    (((SYSCALL4) (pCheckBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorParallel)
void
CheckBox_AnchorParallel(TCheckBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(CheckBox_AnchorParallel)
    (((SYSCALL4) (pCheckBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorHorizontalCenterTo)
void
CheckBox_AnchorHorizontalCenterTo(TCheckBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(CheckBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pCheckBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorVerticalCenterTo)
void
CheckBox_AnchorVerticalCenterTo(TCheckBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(CheckBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pCheckBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorSame)
void
CheckBox_AnchorSame(TCheckBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(CheckBox_AnchorSame)
    (((SYSCALL3) (pCheckBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorAsAlign)
void
CheckBox_AnchorAsAlign(TCheckBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(CheckBox_AnchorAsAlign)
    (((SYSCALL3) (pCheckBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(CheckBox_AnchorClient)
void
CheckBox_AnchorClient(TCheckBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(CheckBox_AnchorClient)
    (((SYSCALL2) (pCheckBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleDesignToForm)
int32_t
CheckBox_ScaleDesignToForm(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleFormToDesign)
int32_t
CheckBox_ScaleFormToDesign(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_Scale96ToForm)
int32_t
CheckBox_Scale96ToForm(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pCheckBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleFormTo96)
int32_t
CheckBox_ScaleFormTo96(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_Scale96ToFont)
int32_t
CheckBox_Scale96ToFont(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pCheckBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleFontTo96)
int32_t
CheckBox_ScaleFontTo96(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleScreenToFont)
int32_t
CheckBox_ScaleScreenToFont(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleFontToScreen)
int32_t
CheckBox_ScaleFontToScreen(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_Scale96ToScreen)
int32_t
CheckBox_Scale96ToScreen(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pCheckBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleScreenTo96)
int32_t
CheckBox_ScaleScreenTo96(TCheckBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(CheckBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pCheckBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(CheckBox_AutoAdjustLayout)
void
CheckBox_AutoAdjustLayout(TCheckBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(CheckBox_AutoAdjustLayout)
    (((SYSCALL6) (pCheckBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(CheckBox_FixDesignFontsPPI)
void
CheckBox_FixDesignFontsPPI(TCheckBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(CheckBox_FixDesignFontsPPI)
    (((SYSCALL2) (pCheckBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(CheckBox_ScaleFontsPPI)
void
CheckBox_ScaleFontsPPI(TCheckBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(CheckBox_ScaleFontsPPI)
    (((SYSCALL3) (pCheckBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnChange)
void
CheckBox_SetOnChange(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnChange)
    (((SYSCALL2) (pCheckBox_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_GetAction)
TAction
CheckBox_GetAction(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAction)
    return (TAction)(((SYSCALL1) (pCheckBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAction)
void
CheckBox_SetAction(TCheckBox AObj, TAction AValue) {
    GET_FUNC_ADDR(CheckBox_SetAction)
    (((SYSCALL2) (pCheckBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAlign)
TAlign
CheckBox_GetAlign(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pCheckBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAlign)
void
CheckBox_SetAlign(TCheckBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(CheckBox_SetAlign)
    (((SYSCALL2) (pCheckBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAlignment)
TLeftRight
CheckBox_GetAlignment(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAlignment)
    return (TLeftRight)(((SYSCALL1) (pCheckBox_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAlignment)
void
CheckBox_SetAlignment(TCheckBox AObj, TLeftRight AValue) {
    GET_FUNC_ADDR(CheckBox_SetAlignment)
    (((SYSCALL2) (pCheckBox_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAllowGrayed)
BOOL
CheckBox_GetAllowGrayed(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAllowGrayed)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetAllowGrayed))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAllowGrayed)
void
CheckBox_SetAllowGrayed(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetAllowGrayed)
    (((SYSCALL2) (pCheckBox_SetAllowGrayed))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchors)
TAnchors
CheckBox_GetAnchors(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pCheckBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAnchors)
void
CheckBox_SetAnchors(TCheckBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(CheckBox_SetAnchors)
    (((SYSCALL2) (pCheckBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetBiDiMode)
TBiDiMode
CheckBox_GetBiDiMode(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pCheckBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetBiDiMode)
void
CheckBox_SetBiDiMode(TCheckBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(CheckBox_SetBiDiMode)
    (((SYSCALL2) (pCheckBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetCaption)
char*
CheckBox_GetCaption(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetCaption)
    return (char*)(((SYSCALL1) (pCheckBox_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetCaption)
void
CheckBox_SetCaption(TCheckBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(CheckBox_SetCaption)
    (((SYSCALL2) (pCheckBox_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetChecked)
BOOL
CheckBox_GetChecked(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetChecked)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetChecked))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetChecked)
void
CheckBox_SetChecked(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetChecked)
    (((SYSCALL2) (pCheckBox_SetChecked))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetColor)
TColor
CheckBox_GetColor(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetColor)
    return (TColor)(((SYSCALL1) (pCheckBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetColor)
void
CheckBox_SetColor(TCheckBox AObj, TColor AValue) {
    GET_FUNC_ADDR(CheckBox_SetColor)
    (((SYSCALL2) (pCheckBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetConstraints)
TSizeConstraints
CheckBox_GetConstraints(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pCheckBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetConstraints)
void
CheckBox_SetConstraints(TCheckBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(CheckBox_SetConstraints)
    (((SYSCALL2) (pCheckBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetDoubleBuffered)
BOOL
CheckBox_GetDoubleBuffered(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetDoubleBuffered)
void
CheckBox_SetDoubleBuffered(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetDoubleBuffered)
    (((SYSCALL2) (pCheckBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetDragCursor)
TCursor
CheckBox_GetDragCursor(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pCheckBox_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetDragCursor)
void
CheckBox_SetDragCursor(TCheckBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(CheckBox_SetDragCursor)
    (((SYSCALL2) (pCheckBox_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetDragKind)
TDragKind
CheckBox_GetDragKind(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pCheckBox_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetDragKind)
void
CheckBox_SetDragKind(TCheckBox AObj, TDragKind AValue) {
    GET_FUNC_ADDR(CheckBox_SetDragKind)
    (((SYSCALL2) (pCheckBox_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetDragMode)
TDragMode
CheckBox_GetDragMode(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pCheckBox_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetDragMode)
void
CheckBox_SetDragMode(TCheckBox AObj, TDragMode AValue) {
    GET_FUNC_ADDR(CheckBox_SetDragMode)
    (((SYSCALL2) (pCheckBox_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetEnabled)
BOOL
CheckBox_GetEnabled(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetEnabled)
void
CheckBox_SetEnabled(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetEnabled)
    (((SYSCALL2) (pCheckBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetFont)
TFont
CheckBox_GetFont(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetFont)
    return (TFont)(((SYSCALL1) (pCheckBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetFont)
void
CheckBox_SetFont(TCheckBox AObj, TFont AValue) {
    GET_FUNC_ADDR(CheckBox_SetFont)
    (((SYSCALL2) (pCheckBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetParentColor)
BOOL
CheckBox_GetParentColor(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParentColor)
void
CheckBox_SetParentColor(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetParentColor)
    (((SYSCALL2) (pCheckBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetParentDoubleBuffered)
BOOL
CheckBox_GetParentDoubleBuffered(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParentDoubleBuffered)
void
CheckBox_SetParentDoubleBuffered(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pCheckBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetParentFont)
BOOL
CheckBox_GetParentFont(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParentFont)
void
CheckBox_SetParentFont(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetParentFont)
    (((SYSCALL2) (pCheckBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetParentShowHint)
BOOL
CheckBox_GetParentShowHint(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParentShowHint)
void
CheckBox_SetParentShowHint(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetParentShowHint)
    (((SYSCALL2) (pCheckBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetPopupMenu)
TPopupMenu
CheckBox_GetPopupMenu(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pCheckBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetPopupMenu)
void
CheckBox_SetPopupMenu(TCheckBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(CheckBox_SetPopupMenu)
    (((SYSCALL2) (pCheckBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetShowHint)
BOOL
CheckBox_GetShowHint(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetShowHint)
void
CheckBox_SetShowHint(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetShowHint)
    (((SYSCALL2) (pCheckBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetState)
TCheckBoxState
CheckBox_GetState(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetState)
    return (TCheckBoxState)(((SYSCALL1) (pCheckBox_GetState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetState)
void
CheckBox_SetState(TCheckBox AObj, TCheckBoxState AValue) {
    GET_FUNC_ADDR(CheckBox_SetState)
    (((SYSCALL2) (pCheckBox_SetState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetTabOrder)
TTabOrder
CheckBox_GetTabOrder(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pCheckBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetTabOrder)
void
CheckBox_SetTabOrder(TCheckBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(CheckBox_SetTabOrder)
    (((SYSCALL2) (pCheckBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetTabStop)
BOOL
CheckBox_GetTabStop(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetTabStop)
void
CheckBox_SetTabStop(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetTabStop)
    (((SYSCALL2) (pCheckBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetVisible)
BOOL
CheckBox_GetVisible(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetVisible)
void
CheckBox_SetVisible(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetVisible)
    (((SYSCALL2) (pCheckBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnClick)
void
CheckBox_SetOnClick(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnClick)
    (((SYSCALL2) (pCheckBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnContextPopup)
void
CheckBox_SetOnContextPopup(TCheckBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnContextPopup)
    (((SYSCALL2) (pCheckBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnDragDrop)
void
CheckBox_SetOnDragDrop(TCheckBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnDragDrop)
    (((SYSCALL2) (pCheckBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnDragOver)
void
CheckBox_SetOnDragOver(TCheckBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnDragOver)
    (((SYSCALL2) (pCheckBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnEndDrag)
void
CheckBox_SetOnEndDrag(TCheckBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnEndDrag)
    (((SYSCALL2) (pCheckBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnEnter)
void
CheckBox_SetOnEnter(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnEnter)
    (((SYSCALL2) (pCheckBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnExit)
void
CheckBox_SetOnExit(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnExit)
    (((SYSCALL2) (pCheckBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnKeyDown)
void
CheckBox_SetOnKeyDown(TCheckBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnKeyDown)
    (((SYSCALL2) (pCheckBox_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnKeyPress)
void
CheckBox_SetOnKeyPress(TCheckBox AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnKeyPress)
    (((SYSCALL2) (pCheckBox_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnKeyUp)
void
CheckBox_SetOnKeyUp(TCheckBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnKeyUp)
    (((SYSCALL2) (pCheckBox_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnMouseDown)
void
CheckBox_SetOnMouseDown(TCheckBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnMouseDown)
    (((SYSCALL2) (pCheckBox_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnMouseEnter)
void
CheckBox_SetOnMouseEnter(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnMouseEnter)
    (((SYSCALL2) (pCheckBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnMouseLeave)
void
CheckBox_SetOnMouseLeave(TCheckBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnMouseLeave)
    (((SYSCALL2) (pCheckBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnMouseMove)
void
CheckBox_SetOnMouseMove(TCheckBox AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnMouseMove)
    (((SYSCALL2) (pCheckBox_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_SetOnMouseUp)
void
CheckBox_SetOnMouseUp(TCheckBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(CheckBox_SetOnMouseUp)
    (((SYSCALL2) (pCheckBox_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(CheckBox_GetDockClientCount)
int32_t
CheckBox_GetDockClientCount(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetDockSite)
BOOL
CheckBox_GetDockSite(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetDockSite)
void
CheckBox_SetDockSite(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetDockSite)
    (((SYSCALL2) (pCheckBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetMouseInClient)
BOOL
CheckBox_GetMouseInClient(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetVisibleDockClientCount)
int32_t
CheckBox_GetVisibleDockClientCount(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetBrush)
TBrush
CheckBox_GetBrush(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pCheckBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetControlCount)
int32_t
CheckBox_GetControlCount(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetHandle)
HWND
CheckBox_GetHandle(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetHandle)
    return (HWND)(((SYSCALL1) (pCheckBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetParentWindow)
HWND
CheckBox_GetParentWindow(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pCheckBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParentWindow)
void
CheckBox_SetParentWindow(TCheckBox AObj, HWND AValue) {
    GET_FUNC_ADDR(CheckBox_SetParentWindow)
    (((SYSCALL2) (pCheckBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetShowing)
BOOL
CheckBox_GetShowing(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetUseDockManager)
BOOL
CheckBox_GetUseDockManager(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetUseDockManager)
void
CheckBox_SetUseDockManager(TCheckBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(CheckBox_SetUseDockManager)
    (((SYSCALL2) (pCheckBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetBoundsRect)
TRect
CheckBox_GetBoundsRect(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pCheckBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_SetBoundsRect)
void
CheckBox_SetBoundsRect(TCheckBox AObj, TRect AValue) {
    GET_FUNC_ADDR(CheckBox_SetBoundsRect)
    (((SYSCALL2) (pCheckBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetClientHeight)
int32_t
CheckBox_GetClientHeight(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetClientHeight)
void
CheckBox_SetClientHeight(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetClientHeight)
    (((SYSCALL2) (pCheckBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetClientOrigin)
TPoint
CheckBox_GetClientOrigin(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pCheckBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_GetClientRect)
TRect
CheckBox_GetClientRect(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pCheckBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(CheckBox_GetClientWidth)
int32_t
CheckBox_GetClientWidth(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetClientWidth)
void
CheckBox_SetClientWidth(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetClientWidth)
    (((SYSCALL2) (pCheckBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetControlState)
TControlState
CheckBox_GetControlState(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pCheckBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetControlState)
void
CheckBox_SetControlState(TCheckBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(CheckBox_SetControlState)
    (((SYSCALL2) (pCheckBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetControlStyle)
TControlStyle
CheckBox_GetControlStyle(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pCheckBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetControlStyle)
void
CheckBox_SetControlStyle(TCheckBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(CheckBox_SetControlStyle)
    (((SYSCALL2) (pCheckBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetFloating)
BOOL
CheckBox_GetFloating(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pCheckBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetParent)
TWinControl
CheckBox_GetParent(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pCheckBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetParent)
void
CheckBox_SetParent(TCheckBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(CheckBox_SetParent)
    (((SYSCALL2) (pCheckBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetLeft)
int32_t
CheckBox_GetLeft(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetLeft)
void
CheckBox_SetLeft(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetLeft)
    (((SYSCALL2) (pCheckBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetTop)
int32_t
CheckBox_GetTop(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetTop)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetTop)
void
CheckBox_SetTop(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetTop)
    (((SYSCALL2) (pCheckBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetWidth)
int32_t
CheckBox_GetWidth(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetWidth)
void
CheckBox_SetWidth(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetWidth)
    (((SYSCALL2) (pCheckBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetHeight)
int32_t
CheckBox_GetHeight(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetHeight)
void
CheckBox_SetHeight(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetHeight)
    (((SYSCALL2) (pCheckBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetCursor)
TCursor
CheckBox_GetCursor(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pCheckBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetCursor)
void
CheckBox_SetCursor(TCheckBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(CheckBox_SetCursor)
    (((SYSCALL2) (pCheckBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetHint)
char*
CheckBox_GetHint(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetHint)
    return (char*)(((SYSCALL1) (pCheckBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetHint)
void
CheckBox_SetHint(TCheckBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(CheckBox_SetHint)
    (((SYSCALL2) (pCheckBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetComponentCount)
int32_t
CheckBox_GetComponentCount(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetComponentIndex)
int32_t
CheckBox_GetComponentIndex(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pCheckBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetComponentIndex)
void
CheckBox_SetComponentIndex(TCheckBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetComponentIndex)
    (((SYSCALL2) (pCheckBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetOwner)
TComponent
CheckBox_GetOwner(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pCheckBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_GetName)
char*
CheckBox_GetName(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetName)
    return (char*)(((SYSCALL1) (pCheckBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetName)
void
CheckBox_SetName(TCheckBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(CheckBox_SetName)
    (((SYSCALL2) (pCheckBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetTag)
intptr_t
CheckBox_GetTag(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pCheckBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetTag)
void
CheckBox_SetTag(TCheckBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(CheckBox_SetTag)
    (((SYSCALL2) (pCheckBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchorSideLeft)
TAnchorSide
CheckBox_GetAnchorSideLeft(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pCheckBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAnchorSideLeft)
void
CheckBox_SetAnchorSideLeft(TCheckBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(CheckBox_SetAnchorSideLeft)
    (((SYSCALL2) (pCheckBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchorSideTop)
TAnchorSide
CheckBox_GetAnchorSideTop(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pCheckBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAnchorSideTop)
void
CheckBox_SetAnchorSideTop(TCheckBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(CheckBox_SetAnchorSideTop)
    (((SYSCALL2) (pCheckBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchorSideRight)
TAnchorSide
CheckBox_GetAnchorSideRight(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pCheckBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAnchorSideRight)
void
CheckBox_SetAnchorSideRight(TCheckBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(CheckBox_SetAnchorSideRight)
    (((SYSCALL2) (pCheckBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchorSideBottom)
TAnchorSide
CheckBox_GetAnchorSideBottom(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pCheckBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetAnchorSideBottom)
void
CheckBox_SetAnchorSideBottom(TCheckBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(CheckBox_SetAnchorSideBottom)
    (((SYSCALL2) (pCheckBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetChildSizing)
TControlChildSizing
CheckBox_GetChildSizing(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pCheckBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetChildSizing)
void
CheckBox_SetChildSizing(TCheckBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(CheckBox_SetChildSizing)
    (((SYSCALL2) (pCheckBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetBorderSpacing)
TControlBorderSpacing
CheckBox_GetBorderSpacing(TCheckBox AObj) {
    GET_FUNC_ADDR(CheckBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pCheckBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(CheckBox_SetBorderSpacing)
void
CheckBox_SetBorderSpacing(TCheckBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(CheckBox_SetBorderSpacing)
    (((SYSCALL2) (pCheckBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(CheckBox_GetDockClients)
TControl
CheckBox_GetDockClients(TCheckBox AObj, int32_t Index) {
    GET_FUNC_ADDR(CheckBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pCheckBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(CheckBox_GetControls)
TControl
CheckBox_GetControls(TCheckBox AObj, int32_t Index) {
    GET_FUNC_ADDR(CheckBox_GetControls)
    return (TControl)(((SYSCALL2) (pCheckBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(CheckBox_GetComponents)
TComponent
CheckBox_GetComponents(TCheckBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(CheckBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pCheckBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(CheckBox_GetAnchorSide)
TAnchorSide
CheckBox_GetAnchorSide(TCheckBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(CheckBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pCheckBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(CheckBox_StaticClassType)
TClass
CheckBox_StaticClassType() {
    GET_FUNC_ADDR(CheckBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pCheckBox_StaticClassType))());
}

// -------------------TRadioButton-------------------

DEFINE_FUNC_PTR(RadioButton_Create)
TRadioButton
RadioButton_Create(TComponent AOwner) {
    GET_FUNC_ADDR(RadioButton_Create)
    return (TRadioButton)(((SYSCALL1) (pRadioButton_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(RadioButton_Free)
void
RadioButton_Free(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Free)
    (((SYSCALL1) (pRadioButton_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_CanFocus)
BOOL
RadioButton_CanFocus(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_CanFocus)
    return (BOOL)(((SYSCALL1) (pRadioButton_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ContainsControl)
BOOL
RadioButton_ContainsControl(TRadioButton AObj, TControl Control) {
    GET_FUNC_ADDR(RadioButton_ContainsControl)
    return (BOOL)(((SYSCALL2) (pRadioButton_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(RadioButton_ControlAtPos)
TControl
RadioButton_ControlAtPos(TRadioButton AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(RadioButton_ControlAtPos)
    return (TControl)(((SYSCALL4) (pRadioButton_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(RadioButton_DisableAlign)
void
RadioButton_DisableAlign(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_DisableAlign)
    (((SYSCALL1) (pRadioButton_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_EnableAlign)
void
RadioButton_EnableAlign(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_EnableAlign)
    (((SYSCALL1) (pRadioButton_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_FindChildControl)
TControl
RadioButton_FindChildControl(TRadioButton AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(RadioButton_FindChildControl)
    return (TControl)(((SYSCALL2) (pRadioButton_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(RadioButton_FlipChildren)
void
RadioButton_FlipChildren(TRadioButton AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(RadioButton_FlipChildren)
    (((SYSCALL2) (pRadioButton_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(RadioButton_Focused)
BOOL
RadioButton_Focused(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Focused)
    return (BOOL)(((SYSCALL1) (pRadioButton_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_HandleAllocated)
BOOL
RadioButton_HandleAllocated(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pRadioButton_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_InsertControl)
void
RadioButton_InsertControl(TRadioButton AObj, TControl AControl) {
    GET_FUNC_ADDR(RadioButton_InsertControl)
    (((SYSCALL2) (pRadioButton_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RadioButton_Invalidate)
void
RadioButton_Invalidate(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Invalidate)
    (((SYSCALL1) (pRadioButton_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_PaintTo)
void
RadioButton_PaintTo(TRadioButton AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(RadioButton_PaintTo)
    (((SYSCALL4) (pRadioButton_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(RadioButton_RemoveControl)
void
RadioButton_RemoveControl(TRadioButton AObj, TControl AControl) {
    GET_FUNC_ADDR(RadioButton_RemoveControl)
    (((SYSCALL2) (pRadioButton_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RadioButton_Realign)
void
RadioButton_Realign(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Realign)
    (((SYSCALL1) (pRadioButton_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Repaint)
void
RadioButton_Repaint(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Repaint)
    (((SYSCALL1) (pRadioButton_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleBy)
void
RadioButton_ScaleBy(TRadioButton AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(RadioButton_ScaleBy)
    (((SYSCALL3) (pRadioButton_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(RadioButton_ScrollBy)
void
RadioButton_ScrollBy(TRadioButton AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(RadioButton_ScrollBy)
    (((SYSCALL3) (pRadioButton_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(RadioButton_SetBounds)
void
RadioButton_SetBounds(TRadioButton AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(RadioButton_SetBounds)
    (((SYSCALL5) (pRadioButton_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(RadioButton_SetFocus)
void
RadioButton_SetFocus(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_SetFocus)
    (((SYSCALL1) (pRadioButton_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Update)
void
RadioButton_Update(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Update)
    (((SYSCALL1) (pRadioButton_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_BringToFront)
void
RadioButton_BringToFront(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_BringToFront)
    (((SYSCALL1) (pRadioButton_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ClientToScreen)
TPoint
RadioButton_ClientToScreen(TRadioButton AObj, TPoint Point) {
    GET_FUNC_ADDR(RadioButton_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pRadioButton_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_ClientToParent)
TPoint
RadioButton_ClientToParent(TRadioButton AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RadioButton_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pRadioButton_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_Dragging)
BOOL
RadioButton_Dragging(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Dragging)
    return (BOOL)(((SYSCALL1) (pRadioButton_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_HasParent)
BOOL
RadioButton_HasParent(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_HasParent)
    return (BOOL)(((SYSCALL1) (pRadioButton_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Hide)
void
RadioButton_Hide(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Hide)
    (((SYSCALL1) (pRadioButton_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Perform)
intptr_t
RadioButton_Perform(TRadioButton AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(RadioButton_Perform)
    return (intptr_t)(((SYSCALL4) (pRadioButton_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(RadioButton_Refresh)
void
RadioButton_Refresh(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Refresh)
    (((SYSCALL1) (pRadioButton_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ScreenToClient)
TPoint
RadioButton_ScreenToClient(TRadioButton AObj, TPoint Point) {
    GET_FUNC_ADDR(RadioButton_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pRadioButton_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_ParentToClient)
TPoint
RadioButton_ParentToClient(TRadioButton AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RadioButton_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pRadioButton_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_SendToBack)
void
RadioButton_SendToBack(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_SendToBack)
    (((SYSCALL1) (pRadioButton_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Show)
void
RadioButton_Show(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_Show)
    (((SYSCALL1) (pRadioButton_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetTextBuf)
int32_t
RadioButton_GetTextBuf(TRadioButton AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(RadioButton_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pRadioButton_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(RadioButton_GetTextLen)
int32_t
RadioButton_GetTextLen(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetTextLen)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetTextBuf)
void
RadioButton_SetTextBuf(TRadioButton AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(RadioButton_SetTextBuf)
    (((SYSCALL2) (pRadioButton_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(RadioButton_FindComponent)
TComponent
RadioButton_FindComponent(TRadioButton AObj, CChar char* AName) {
    GET_FUNC_ADDR(RadioButton_FindComponent)
    return (TComponent)(((SYSCALL2) (pRadioButton_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(RadioButton_GetNamePath)
char*
RadioButton_GetNamePath(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetNamePath)
    return (char*)(((SYSCALL1) (pRadioButton_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_Assign)
void
RadioButton_Assign(TRadioButton AObj, TObject Source) {
    GET_FUNC_ADDR(RadioButton_Assign)
    (((SYSCALL2) (pRadioButton_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(RadioButton_ClassType)
TClass
RadioButton_ClassType(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_ClassType)
    return (TClass)(((SYSCALL1) (pRadioButton_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ClassName)
char*
RadioButton_ClassName(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_ClassName)
    return (char*)(((SYSCALL1) (pRadioButton_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_InstanceSize)
int32_t
RadioButton_InstanceSize(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_InstanceSize)
    return (int32_t)(((SYSCALL1) (pRadioButton_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_InheritsFrom)
BOOL
RadioButton_InheritsFrom(TRadioButton AObj, TClass AClass) {
    GET_FUNC_ADDR(RadioButton_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pRadioButton_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(RadioButton_Equals)
BOOL
RadioButton_Equals(TRadioButton AObj, TObject Obj) {
    GET_FUNC_ADDR(RadioButton_Equals)
    return (BOOL)(((SYSCALL2) (pRadioButton_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(RadioButton_GetHashCode)
int32_t
RadioButton_GetHashCode(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetHashCode)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_ToString)
char*
RadioButton_ToString(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_ToString)
    return (char*)(((SYSCALL1) (pRadioButton_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorToNeighbour)
void
RadioButton_AnchorToNeighbour(TRadioButton AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RadioButton_AnchorToNeighbour)
    (((SYSCALL4) (pRadioButton_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorParallel)
void
RadioButton_AnchorParallel(TRadioButton AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RadioButton_AnchorParallel)
    (((SYSCALL4) (pRadioButton_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorHorizontalCenterTo)
void
RadioButton_AnchorHorizontalCenterTo(TRadioButton AObj, TControl ASibling) {
    GET_FUNC_ADDR(RadioButton_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pRadioButton_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorVerticalCenterTo)
void
RadioButton_AnchorVerticalCenterTo(TRadioButton AObj, TControl ASibling) {
    GET_FUNC_ADDR(RadioButton_AnchorVerticalCenterTo)
    (((SYSCALL2) (pRadioButton_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorSame)
void
RadioButton_AnchorSame(TRadioButton AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(RadioButton_AnchorSame)
    (((SYSCALL3) (pRadioButton_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorAsAlign)
void
RadioButton_AnchorAsAlign(TRadioButton AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(RadioButton_AnchorAsAlign)
    (((SYSCALL3) (pRadioButton_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RadioButton_AnchorClient)
void
RadioButton_AnchorClient(TRadioButton AObj, int32_t ASpace) {
    GET_FUNC_ADDR(RadioButton_AnchorClient)
    (((SYSCALL2) (pRadioButton_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleDesignToForm)
int32_t
RadioButton_ScaleDesignToForm(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleFormToDesign)
int32_t
RadioButton_ScaleFormToDesign(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_Scale96ToForm)
int32_t
RadioButton_Scale96ToForm(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pRadioButton_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleFormTo96)
int32_t
RadioButton_ScaleFormTo96(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_Scale96ToFont)
int32_t
RadioButton_Scale96ToFont(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pRadioButton_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleFontTo96)
int32_t
RadioButton_ScaleFontTo96(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleScreenToFont)
int32_t
RadioButton_ScaleScreenToFont(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleFontToScreen)
int32_t
RadioButton_ScaleFontToScreen(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_Scale96ToScreen)
int32_t
RadioButton_Scale96ToScreen(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pRadioButton_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleScreenTo96)
int32_t
RadioButton_ScaleScreenTo96(TRadioButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioButton_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pRadioButton_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioButton_AutoAdjustLayout)
void
RadioButton_AutoAdjustLayout(TRadioButton AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(RadioButton_AutoAdjustLayout)
    (((SYSCALL6) (pRadioButton_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(RadioButton_FixDesignFontsPPI)
void
RadioButton_FixDesignFontsPPI(TRadioButton AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(RadioButton_FixDesignFontsPPI)
    (((SYSCALL2) (pRadioButton_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(RadioButton_ScaleFontsPPI)
void
RadioButton_ScaleFontsPPI(TRadioButton AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(RadioButton_ScaleFontsPPI)
    (((SYSCALL3) (pRadioButton_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnChange)
void
RadioButton_SetOnChange(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnChange)
    (((SYSCALL2) (pRadioButton_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_GetAction)
TAction
RadioButton_GetAction(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAction)
    return (TAction)(((SYSCALL1) (pRadioButton_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAction)
void
RadioButton_SetAction(TRadioButton AObj, TAction AValue) {
    GET_FUNC_ADDR(RadioButton_SetAction)
    (((SYSCALL2) (pRadioButton_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAlign)
TAlign
RadioButton_GetAlign(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAlign)
    return (TAlign)(((SYSCALL1) (pRadioButton_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAlign)
void
RadioButton_SetAlign(TRadioButton AObj, TAlign AValue) {
    GET_FUNC_ADDR(RadioButton_SetAlign)
    (((SYSCALL2) (pRadioButton_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAlignment)
TLeftRight
RadioButton_GetAlignment(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAlignment)
    return (TLeftRight)(((SYSCALL1) (pRadioButton_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAlignment)
void
RadioButton_SetAlignment(TRadioButton AObj, TLeftRight AValue) {
    GET_FUNC_ADDR(RadioButton_SetAlignment)
    (((SYSCALL2) (pRadioButton_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchors)
TAnchors
RadioButton_GetAnchors(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pRadioButton_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAnchors)
void
RadioButton_SetAnchors(TRadioButton AObj, TAnchors AValue) {
    GET_FUNC_ADDR(RadioButton_SetAnchors)
    (((SYSCALL2) (pRadioButton_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetBiDiMode)
TBiDiMode
RadioButton_GetBiDiMode(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pRadioButton_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetBiDiMode)
void
RadioButton_SetBiDiMode(TRadioButton AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(RadioButton_SetBiDiMode)
    (((SYSCALL2) (pRadioButton_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetCaption)
char*
RadioButton_GetCaption(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetCaption)
    return (char*)(((SYSCALL1) (pRadioButton_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetCaption)
void
RadioButton_SetCaption(TRadioButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioButton_SetCaption)
    (((SYSCALL2) (pRadioButton_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetChecked)
BOOL
RadioButton_GetChecked(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetChecked)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetChecked))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetChecked)
void
RadioButton_SetChecked(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetChecked)
    (((SYSCALL2) (pRadioButton_SetChecked))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetColor)
TColor
RadioButton_GetColor(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetColor)
    return (TColor)(((SYSCALL1) (pRadioButton_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetColor)
void
RadioButton_SetColor(TRadioButton AObj, TColor AValue) {
    GET_FUNC_ADDR(RadioButton_SetColor)
    (((SYSCALL2) (pRadioButton_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetConstraints)
TSizeConstraints
RadioButton_GetConstraints(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pRadioButton_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetConstraints)
void
RadioButton_SetConstraints(TRadioButton AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(RadioButton_SetConstraints)
    (((SYSCALL2) (pRadioButton_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetDoubleBuffered)
BOOL
RadioButton_GetDoubleBuffered(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetDoubleBuffered)
void
RadioButton_SetDoubleBuffered(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetDoubleBuffered)
    (((SYSCALL2) (pRadioButton_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetDragCursor)
TCursor
RadioButton_GetDragCursor(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pRadioButton_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetDragCursor)
void
RadioButton_SetDragCursor(TRadioButton AObj, TCursor AValue) {
    GET_FUNC_ADDR(RadioButton_SetDragCursor)
    (((SYSCALL2) (pRadioButton_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetDragKind)
TDragKind
RadioButton_GetDragKind(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pRadioButton_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetDragKind)
void
RadioButton_SetDragKind(TRadioButton AObj, TDragKind AValue) {
    GET_FUNC_ADDR(RadioButton_SetDragKind)
    (((SYSCALL2) (pRadioButton_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetDragMode)
TDragMode
RadioButton_GetDragMode(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pRadioButton_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetDragMode)
void
RadioButton_SetDragMode(TRadioButton AObj, TDragMode AValue) {
    GET_FUNC_ADDR(RadioButton_SetDragMode)
    (((SYSCALL2) (pRadioButton_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetEnabled)
BOOL
RadioButton_GetEnabled(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetEnabled)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetEnabled)
void
RadioButton_SetEnabled(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetEnabled)
    (((SYSCALL2) (pRadioButton_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetFont)
TFont
RadioButton_GetFont(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetFont)
    return (TFont)(((SYSCALL1) (pRadioButton_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetFont)
void
RadioButton_SetFont(TRadioButton AObj, TFont AValue) {
    GET_FUNC_ADDR(RadioButton_SetFont)
    (((SYSCALL2) (pRadioButton_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetParentColor)
BOOL
RadioButton_GetParentColor(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParentColor)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParentColor)
void
RadioButton_SetParentColor(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetParentColor)
    (((SYSCALL2) (pRadioButton_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetParentDoubleBuffered)
BOOL
RadioButton_GetParentDoubleBuffered(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParentDoubleBuffered)
void
RadioButton_SetParentDoubleBuffered(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetParentDoubleBuffered)
    (((SYSCALL2) (pRadioButton_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetParentFont)
BOOL
RadioButton_GetParentFont(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParentFont)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParentFont)
void
RadioButton_SetParentFont(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetParentFont)
    (((SYSCALL2) (pRadioButton_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetParentShowHint)
BOOL
RadioButton_GetParentShowHint(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParentShowHint)
void
RadioButton_SetParentShowHint(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetParentShowHint)
    (((SYSCALL2) (pRadioButton_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetPopupMenu)
TPopupMenu
RadioButton_GetPopupMenu(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pRadioButton_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetPopupMenu)
void
RadioButton_SetPopupMenu(TRadioButton AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(RadioButton_SetPopupMenu)
    (((SYSCALL2) (pRadioButton_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetShowHint)
BOOL
RadioButton_GetShowHint(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetShowHint)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetShowHint)
void
RadioButton_SetShowHint(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetShowHint)
    (((SYSCALL2) (pRadioButton_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetTabOrder)
TTabOrder
RadioButton_GetTabOrder(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pRadioButton_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetTabOrder)
void
RadioButton_SetTabOrder(TRadioButton AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(RadioButton_SetTabOrder)
    (((SYSCALL2) (pRadioButton_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetTabStop)
BOOL
RadioButton_GetTabStop(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetTabStop)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetTabStop)
void
RadioButton_SetTabStop(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetTabStop)
    (((SYSCALL2) (pRadioButton_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetVisible)
BOOL
RadioButton_GetVisible(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetVisible)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetVisible)
void
RadioButton_SetVisible(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetVisible)
    (((SYSCALL2) (pRadioButton_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnClick)
void
RadioButton_SetOnClick(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnClick)
    (((SYSCALL2) (pRadioButton_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnContextPopup)
void
RadioButton_SetOnContextPopup(TRadioButton AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnContextPopup)
    (((SYSCALL2) (pRadioButton_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnDragDrop)
void
RadioButton_SetOnDragDrop(TRadioButton AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnDragDrop)
    (((SYSCALL2) (pRadioButton_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnDragOver)
void
RadioButton_SetOnDragOver(TRadioButton AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnDragOver)
    (((SYSCALL2) (pRadioButton_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnEndDrag)
void
RadioButton_SetOnEndDrag(TRadioButton AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnEndDrag)
    (((SYSCALL2) (pRadioButton_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnEnter)
void
RadioButton_SetOnEnter(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnEnter)
    (((SYSCALL2) (pRadioButton_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnExit)
void
RadioButton_SetOnExit(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnExit)
    (((SYSCALL2) (pRadioButton_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnKeyDown)
void
RadioButton_SetOnKeyDown(TRadioButton AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnKeyDown)
    (((SYSCALL2) (pRadioButton_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnKeyPress)
void
RadioButton_SetOnKeyPress(TRadioButton AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnKeyPress)
    (((SYSCALL2) (pRadioButton_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnKeyUp)
void
RadioButton_SetOnKeyUp(TRadioButton AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnKeyUp)
    (((SYSCALL2) (pRadioButton_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnMouseDown)
void
RadioButton_SetOnMouseDown(TRadioButton AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnMouseDown)
    (((SYSCALL2) (pRadioButton_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnMouseEnter)
void
RadioButton_SetOnMouseEnter(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnMouseEnter)
    (((SYSCALL2) (pRadioButton_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnMouseLeave)
void
RadioButton_SetOnMouseLeave(TRadioButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnMouseLeave)
    (((SYSCALL2) (pRadioButton_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnMouseMove)
void
RadioButton_SetOnMouseMove(TRadioButton AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnMouseMove)
    (((SYSCALL2) (pRadioButton_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_SetOnMouseUp)
void
RadioButton_SetOnMouseUp(TRadioButton AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(RadioButton_SetOnMouseUp)
    (((SYSCALL2) (pRadioButton_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioButton_GetDockClientCount)
int32_t
RadioButton_GetDockClientCount(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetDockSite)
BOOL
RadioButton_GetDockSite(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetDockSite)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetDockSite)
void
RadioButton_SetDockSite(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetDockSite)
    (((SYSCALL2) (pRadioButton_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetMouseInClient)
BOOL
RadioButton_GetMouseInClient(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetVisibleDockClientCount)
int32_t
RadioButton_GetVisibleDockClientCount(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetBrush)
TBrush
RadioButton_GetBrush(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetBrush)
    return (TBrush)(((SYSCALL1) (pRadioButton_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetControlCount)
int32_t
RadioButton_GetControlCount(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetControlCount)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetHandle)
HWND
RadioButton_GetHandle(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetHandle)
    return (HWND)(((SYSCALL1) (pRadioButton_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetParentWindow)
HWND
RadioButton_GetParentWindow(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParentWindow)
    return (HWND)(((SYSCALL1) (pRadioButton_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParentWindow)
void
RadioButton_SetParentWindow(TRadioButton AObj, HWND AValue) {
    GET_FUNC_ADDR(RadioButton_SetParentWindow)
    (((SYSCALL2) (pRadioButton_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetShowing)
BOOL
RadioButton_GetShowing(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetShowing)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetUseDockManager)
BOOL
RadioButton_GetUseDockManager(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetUseDockManager)
void
RadioButton_SetUseDockManager(TRadioButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioButton_SetUseDockManager)
    (((SYSCALL2) (pRadioButton_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetBoundsRect)
TRect
RadioButton_GetBoundsRect(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pRadioButton_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_SetBoundsRect)
void
RadioButton_SetBoundsRect(TRadioButton AObj, TRect AValue) {
    GET_FUNC_ADDR(RadioButton_SetBoundsRect)
    (((SYSCALL2) (pRadioButton_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetClientHeight)
int32_t
RadioButton_GetClientHeight(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetClientHeight)
void
RadioButton_SetClientHeight(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetClientHeight)
    (((SYSCALL2) (pRadioButton_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetClientOrigin)
TPoint
RadioButton_GetClientOrigin(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pRadioButton_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_GetClientRect)
TRect
RadioButton_GetClientRect(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetClientRect)
    TRect result;
    (((SYSCALL2) (pRadioButton_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioButton_GetClientWidth)
int32_t
RadioButton_GetClientWidth(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetClientWidth)
void
RadioButton_SetClientWidth(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetClientWidth)
    (((SYSCALL2) (pRadioButton_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetControlState)
TControlState
RadioButton_GetControlState(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetControlState)
    return (TControlState)(((SYSCALL1) (pRadioButton_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetControlState)
void
RadioButton_SetControlState(TRadioButton AObj, TControlState AValue) {
    GET_FUNC_ADDR(RadioButton_SetControlState)
    (((SYSCALL2) (pRadioButton_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetControlStyle)
TControlStyle
RadioButton_GetControlStyle(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pRadioButton_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetControlStyle)
void
RadioButton_SetControlStyle(TRadioButton AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(RadioButton_SetControlStyle)
    (((SYSCALL2) (pRadioButton_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetFloating)
BOOL
RadioButton_GetFloating(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetFloating)
    return (BOOL)(((SYSCALL1) (pRadioButton_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetParent)
TWinControl
RadioButton_GetParent(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetParent)
    return (TWinControl)(((SYSCALL1) (pRadioButton_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetParent)
void
RadioButton_SetParent(TRadioButton AObj, TWinControl AValue) {
    GET_FUNC_ADDR(RadioButton_SetParent)
    (((SYSCALL2) (pRadioButton_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetLeft)
int32_t
RadioButton_GetLeft(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetLeft)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetLeft)
void
RadioButton_SetLeft(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetLeft)
    (((SYSCALL2) (pRadioButton_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetTop)
int32_t
RadioButton_GetTop(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetTop)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetTop)
void
RadioButton_SetTop(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetTop)
    (((SYSCALL2) (pRadioButton_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetWidth)
int32_t
RadioButton_GetWidth(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetWidth)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetWidth)
void
RadioButton_SetWidth(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetWidth)
    (((SYSCALL2) (pRadioButton_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetHeight)
int32_t
RadioButton_GetHeight(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetHeight)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetHeight)
void
RadioButton_SetHeight(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetHeight)
    (((SYSCALL2) (pRadioButton_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetCursor)
TCursor
RadioButton_GetCursor(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetCursor)
    return (TCursor)(((SYSCALL1) (pRadioButton_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetCursor)
void
RadioButton_SetCursor(TRadioButton AObj, TCursor AValue) {
    GET_FUNC_ADDR(RadioButton_SetCursor)
    (((SYSCALL2) (pRadioButton_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetHint)
char*
RadioButton_GetHint(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetHint)
    return (char*)(((SYSCALL1) (pRadioButton_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetHint)
void
RadioButton_SetHint(TRadioButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioButton_SetHint)
    (((SYSCALL2) (pRadioButton_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetComponentCount)
int32_t
RadioButton_GetComponentCount(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetComponentIndex)
int32_t
RadioButton_GetComponentIndex(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pRadioButton_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetComponentIndex)
void
RadioButton_SetComponentIndex(TRadioButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetComponentIndex)
    (((SYSCALL2) (pRadioButton_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetOwner)
TComponent
RadioButton_GetOwner(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetOwner)
    return (TComponent)(((SYSCALL1) (pRadioButton_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_GetName)
char*
RadioButton_GetName(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetName)
    return (char*)(((SYSCALL1) (pRadioButton_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetName)
void
RadioButton_SetName(TRadioButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioButton_SetName)
    (((SYSCALL2) (pRadioButton_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetTag)
intptr_t
RadioButton_GetTag(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetTag)
    return (intptr_t)(((SYSCALL1) (pRadioButton_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetTag)
void
RadioButton_SetTag(TRadioButton AObj, intptr_t AValue) {
    GET_FUNC_ADDR(RadioButton_SetTag)
    (((SYSCALL2) (pRadioButton_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchorSideLeft)
TAnchorSide
RadioButton_GetAnchorSideLeft(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pRadioButton_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAnchorSideLeft)
void
RadioButton_SetAnchorSideLeft(TRadioButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioButton_SetAnchorSideLeft)
    (((SYSCALL2) (pRadioButton_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchorSideTop)
TAnchorSide
RadioButton_GetAnchorSideTop(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pRadioButton_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAnchorSideTop)
void
RadioButton_SetAnchorSideTop(TRadioButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioButton_SetAnchorSideTop)
    (((SYSCALL2) (pRadioButton_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchorSideRight)
TAnchorSide
RadioButton_GetAnchorSideRight(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pRadioButton_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAnchorSideRight)
void
RadioButton_SetAnchorSideRight(TRadioButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioButton_SetAnchorSideRight)
    (((SYSCALL2) (pRadioButton_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchorSideBottom)
TAnchorSide
RadioButton_GetAnchorSideBottom(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pRadioButton_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetAnchorSideBottom)
void
RadioButton_SetAnchorSideBottom(TRadioButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioButton_SetAnchorSideBottom)
    (((SYSCALL2) (pRadioButton_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetChildSizing)
TControlChildSizing
RadioButton_GetChildSizing(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pRadioButton_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetChildSizing)
void
RadioButton_SetChildSizing(TRadioButton AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(RadioButton_SetChildSizing)
    (((SYSCALL2) (pRadioButton_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetBorderSpacing)
TControlBorderSpacing
RadioButton_GetBorderSpacing(TRadioButton AObj) {
    GET_FUNC_ADDR(RadioButton_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pRadioButton_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioButton_SetBorderSpacing)
void
RadioButton_SetBorderSpacing(TRadioButton AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(RadioButton_SetBorderSpacing)
    (((SYSCALL2) (pRadioButton_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioButton_GetDockClients)
TControl
RadioButton_GetDockClients(TRadioButton AObj, int32_t Index) {
    GET_FUNC_ADDR(RadioButton_GetDockClients)
    return (TControl)(((SYSCALL2) (pRadioButton_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RadioButton_GetControls)
TControl
RadioButton_GetControls(TRadioButton AObj, int32_t Index) {
    GET_FUNC_ADDR(RadioButton_GetControls)
    return (TControl)(((SYSCALL2) (pRadioButton_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RadioButton_GetComponents)
TComponent
RadioButton_GetComponents(TRadioButton AObj, int32_t AIndex) {
    GET_FUNC_ADDR(RadioButton_GetComponents)
    return (TComponent)(((SYSCALL2) (pRadioButton_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(RadioButton_GetAnchorSide)
TAnchorSide
RadioButton_GetAnchorSide(TRadioButton AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(RadioButton_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pRadioButton_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(RadioButton_StaticClassType)
TClass
RadioButton_StaticClassType() {
    GET_FUNC_ADDR(RadioButton_StaticClassType)
    return (TClass)(((SYSCALL0) (pRadioButton_StaticClassType))());
}

// -------------------TGroupBox-------------------

DEFINE_FUNC_PTR(GroupBox_Create)
TGroupBox
GroupBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(GroupBox_Create)
    return (TGroupBox)(((SYSCALL1) (pGroupBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(GroupBox_Free)
void
GroupBox_Free(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Free)
    (((SYSCALL1) (pGroupBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_CanFocus)
BOOL
GroupBox_CanFocus(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pGroupBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ContainsControl)
BOOL
GroupBox_ContainsControl(TGroupBox AObj, TControl Control) {
    GET_FUNC_ADDR(GroupBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pGroupBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(GroupBox_ControlAtPos)
TControl
GroupBox_ControlAtPos(TGroupBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(GroupBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pGroupBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(GroupBox_DisableAlign)
void
GroupBox_DisableAlign(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_DisableAlign)
    (((SYSCALL1) (pGroupBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_EnableAlign)
void
GroupBox_EnableAlign(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_EnableAlign)
    (((SYSCALL1) (pGroupBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_FindChildControl)
TControl
GroupBox_FindChildControl(TGroupBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(GroupBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pGroupBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(GroupBox_FlipChildren)
void
GroupBox_FlipChildren(TGroupBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(GroupBox_FlipChildren)
    (((SYSCALL2) (pGroupBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(GroupBox_Focused)
BOOL
GroupBox_Focused(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Focused)
    return (BOOL)(((SYSCALL1) (pGroupBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_HandleAllocated)
BOOL
GroupBox_HandleAllocated(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pGroupBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_InsertControl)
void
GroupBox_InsertControl(TGroupBox AObj, TControl AControl) {
    GET_FUNC_ADDR(GroupBox_InsertControl)
    (((SYSCALL2) (pGroupBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(GroupBox_Invalidate)
void
GroupBox_Invalidate(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Invalidate)
    (((SYSCALL1) (pGroupBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_PaintTo)
void
GroupBox_PaintTo(TGroupBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(GroupBox_PaintTo)
    (((SYSCALL4) (pGroupBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(GroupBox_RemoveControl)
void
GroupBox_RemoveControl(TGroupBox AObj, TControl AControl) {
    GET_FUNC_ADDR(GroupBox_RemoveControl)
    (((SYSCALL2) (pGroupBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(GroupBox_Realign)
void
GroupBox_Realign(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Realign)
    (((SYSCALL1) (pGroupBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Repaint)
void
GroupBox_Repaint(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Repaint)
    (((SYSCALL1) (pGroupBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleBy)
void
GroupBox_ScaleBy(TGroupBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(GroupBox_ScaleBy)
    (((SYSCALL3) (pGroupBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(GroupBox_ScrollBy)
void
GroupBox_ScrollBy(TGroupBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(GroupBox_ScrollBy)
    (((SYSCALL3) (pGroupBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(GroupBox_SetBounds)
void
GroupBox_SetBounds(TGroupBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(GroupBox_SetBounds)
    (((SYSCALL5) (pGroupBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(GroupBox_SetFocus)
void
GroupBox_SetFocus(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_SetFocus)
    (((SYSCALL1) (pGroupBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Update)
void
GroupBox_Update(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Update)
    (((SYSCALL1) (pGroupBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_BringToFront)
void
GroupBox_BringToFront(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_BringToFront)
    (((SYSCALL1) (pGroupBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ClientToScreen)
TPoint
GroupBox_ClientToScreen(TGroupBox AObj, TPoint Point) {
    GET_FUNC_ADDR(GroupBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pGroupBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_ClientToParent)
TPoint
GroupBox_ClientToParent(TGroupBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(GroupBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pGroupBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_Dragging)
BOOL
GroupBox_Dragging(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Dragging)
    return (BOOL)(((SYSCALL1) (pGroupBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_HasParent)
BOOL
GroupBox_HasParent(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_HasParent)
    return (BOOL)(((SYSCALL1) (pGroupBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Hide)
void
GroupBox_Hide(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Hide)
    (((SYSCALL1) (pGroupBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Perform)
intptr_t
GroupBox_Perform(TGroupBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(GroupBox_Perform)
    return (intptr_t)(((SYSCALL4) (pGroupBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(GroupBox_Refresh)
void
GroupBox_Refresh(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Refresh)
    (((SYSCALL1) (pGroupBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ScreenToClient)
TPoint
GroupBox_ScreenToClient(TGroupBox AObj, TPoint Point) {
    GET_FUNC_ADDR(GroupBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pGroupBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_ParentToClient)
TPoint
GroupBox_ParentToClient(TGroupBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(GroupBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pGroupBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_SendToBack)
void
GroupBox_SendToBack(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_SendToBack)
    (((SYSCALL1) (pGroupBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Show)
void
GroupBox_Show(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_Show)
    (((SYSCALL1) (pGroupBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetTextBuf)
int32_t
GroupBox_GetTextBuf(TGroupBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(GroupBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pGroupBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(GroupBox_GetTextLen)
int32_t
GroupBox_GetTextLen(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetTextBuf)
void
GroupBox_SetTextBuf(TGroupBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(GroupBox_SetTextBuf)
    (((SYSCALL2) (pGroupBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(GroupBox_FindComponent)
TComponent
GroupBox_FindComponent(TGroupBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(GroupBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pGroupBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(GroupBox_GetNamePath)
char*
GroupBox_GetNamePath(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetNamePath)
    return (char*)(((SYSCALL1) (pGroupBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_Assign)
void
GroupBox_Assign(TGroupBox AObj, TObject Source) {
    GET_FUNC_ADDR(GroupBox_Assign)
    (((SYSCALL2) (pGroupBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(GroupBox_ClassType)
TClass
GroupBox_ClassType(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_ClassType)
    return (TClass)(((SYSCALL1) (pGroupBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ClassName)
char*
GroupBox_ClassName(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_ClassName)
    return (char*)(((SYSCALL1) (pGroupBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_InstanceSize)
int32_t
GroupBox_InstanceSize(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pGroupBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_InheritsFrom)
BOOL
GroupBox_InheritsFrom(TGroupBox AObj, TClass AClass) {
    GET_FUNC_ADDR(GroupBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pGroupBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(GroupBox_Equals)
BOOL
GroupBox_Equals(TGroupBox AObj, TObject Obj) {
    GET_FUNC_ADDR(GroupBox_Equals)
    return (BOOL)(((SYSCALL2) (pGroupBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(GroupBox_GetHashCode)
int32_t
GroupBox_GetHashCode(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_ToString)
char*
GroupBox_ToString(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_ToString)
    return (char*)(((SYSCALL1) (pGroupBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorToNeighbour)
void
GroupBox_AnchorToNeighbour(TGroupBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(GroupBox_AnchorToNeighbour)
    (((SYSCALL4) (pGroupBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorParallel)
void
GroupBox_AnchorParallel(TGroupBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(GroupBox_AnchorParallel)
    (((SYSCALL4) (pGroupBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorHorizontalCenterTo)
void
GroupBox_AnchorHorizontalCenterTo(TGroupBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(GroupBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pGroupBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorVerticalCenterTo)
void
GroupBox_AnchorVerticalCenterTo(TGroupBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(GroupBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pGroupBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorSame)
void
GroupBox_AnchorSame(TGroupBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(GroupBox_AnchorSame)
    (((SYSCALL3) (pGroupBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorAsAlign)
void
GroupBox_AnchorAsAlign(TGroupBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(GroupBox_AnchorAsAlign)
    (((SYSCALL3) (pGroupBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(GroupBox_AnchorClient)
void
GroupBox_AnchorClient(TGroupBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(GroupBox_AnchorClient)
    (((SYSCALL2) (pGroupBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleDesignToForm)
int32_t
GroupBox_ScaleDesignToForm(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleFormToDesign)
int32_t
GroupBox_ScaleFormToDesign(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_Scale96ToForm)
int32_t
GroupBox_Scale96ToForm(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pGroupBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleFormTo96)
int32_t
GroupBox_ScaleFormTo96(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_Scale96ToFont)
int32_t
GroupBox_Scale96ToFont(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pGroupBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleFontTo96)
int32_t
GroupBox_ScaleFontTo96(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleScreenToFont)
int32_t
GroupBox_ScaleScreenToFont(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleFontToScreen)
int32_t
GroupBox_ScaleFontToScreen(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_Scale96ToScreen)
int32_t
GroupBox_Scale96ToScreen(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pGroupBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleScreenTo96)
int32_t
GroupBox_ScaleScreenTo96(TGroupBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(GroupBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pGroupBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(GroupBox_AutoAdjustLayout)
void
GroupBox_AutoAdjustLayout(TGroupBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(GroupBox_AutoAdjustLayout)
    (((SYSCALL6) (pGroupBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(GroupBox_FixDesignFontsPPI)
void
GroupBox_FixDesignFontsPPI(TGroupBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(GroupBox_FixDesignFontsPPI)
    (((SYSCALL2) (pGroupBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(GroupBox_ScaleFontsPPI)
void
GroupBox_ScaleFontsPPI(TGroupBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(GroupBox_ScaleFontsPPI)
    (((SYSCALL3) (pGroupBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(GroupBox_GetAlign)
TAlign
GroupBox_GetAlign(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pGroupBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAlign)
void
GroupBox_SetAlign(TGroupBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(GroupBox_SetAlign)
    (((SYSCALL2) (pGroupBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchors)
TAnchors
GroupBox_GetAnchors(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pGroupBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAnchors)
void
GroupBox_SetAnchors(TGroupBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(GroupBox_SetAnchors)
    (((SYSCALL2) (pGroupBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetBiDiMode)
TBiDiMode
GroupBox_GetBiDiMode(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pGroupBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetBiDiMode)
void
GroupBox_SetBiDiMode(TGroupBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(GroupBox_SetBiDiMode)
    (((SYSCALL2) (pGroupBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetCaption)
char*
GroupBox_GetCaption(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetCaption)
    return (char*)(((SYSCALL1) (pGroupBox_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetCaption)
void
GroupBox_SetCaption(TGroupBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(GroupBox_SetCaption)
    (((SYSCALL2) (pGroupBox_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetColor)
TColor
GroupBox_GetColor(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetColor)
    return (TColor)(((SYSCALL1) (pGroupBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetColor)
void
GroupBox_SetColor(TGroupBox AObj, TColor AValue) {
    GET_FUNC_ADDR(GroupBox_SetColor)
    (((SYSCALL2) (pGroupBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetConstraints)
TSizeConstraints
GroupBox_GetConstraints(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pGroupBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetConstraints)
void
GroupBox_SetConstraints(TGroupBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(GroupBox_SetConstraints)
    (((SYSCALL2) (pGroupBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDockSite)
BOOL
GroupBox_GetDockSite(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetDockSite)
void
GroupBox_SetDockSite(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetDockSite)
    (((SYSCALL2) (pGroupBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDoubleBuffered)
BOOL
GroupBox_GetDoubleBuffered(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetDoubleBuffered)
void
GroupBox_SetDoubleBuffered(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetDoubleBuffered)
    (((SYSCALL2) (pGroupBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDragCursor)
TCursor
GroupBox_GetDragCursor(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pGroupBox_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetDragCursor)
void
GroupBox_SetDragCursor(TGroupBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(GroupBox_SetDragCursor)
    (((SYSCALL2) (pGroupBox_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDragKind)
TDragKind
GroupBox_GetDragKind(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pGroupBox_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetDragKind)
void
GroupBox_SetDragKind(TGroupBox AObj, TDragKind AValue) {
    GET_FUNC_ADDR(GroupBox_SetDragKind)
    (((SYSCALL2) (pGroupBox_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDragMode)
TDragMode
GroupBox_GetDragMode(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pGroupBox_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetDragMode)
void
GroupBox_SetDragMode(TGroupBox AObj, TDragMode AValue) {
    GET_FUNC_ADDR(GroupBox_SetDragMode)
    (((SYSCALL2) (pGroupBox_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetEnabled)
BOOL
GroupBox_GetEnabled(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetEnabled)
void
GroupBox_SetEnabled(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetEnabled)
    (((SYSCALL2) (pGroupBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetFont)
TFont
GroupBox_GetFont(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetFont)
    return (TFont)(((SYSCALL1) (pGroupBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetFont)
void
GroupBox_SetFont(TGroupBox AObj, TFont AValue) {
    GET_FUNC_ADDR(GroupBox_SetFont)
    (((SYSCALL2) (pGroupBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentBackground)
BOOL
GroupBox_GetParentBackground(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentBackground)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetParentBackground))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentBackground)
void
GroupBox_SetParentBackground(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentBackground)
    (((SYSCALL2) (pGroupBox_SetParentBackground))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentColor)
BOOL
GroupBox_GetParentColor(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentColor)
void
GroupBox_SetParentColor(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentColor)
    (((SYSCALL2) (pGroupBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentDoubleBuffered)
BOOL
GroupBox_GetParentDoubleBuffered(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentDoubleBuffered)
void
GroupBox_SetParentDoubleBuffered(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pGroupBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentFont)
BOOL
GroupBox_GetParentFont(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentFont)
void
GroupBox_SetParentFont(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentFont)
    (((SYSCALL2) (pGroupBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentShowHint)
BOOL
GroupBox_GetParentShowHint(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentShowHint)
void
GroupBox_SetParentShowHint(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentShowHint)
    (((SYSCALL2) (pGroupBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetPopupMenu)
TPopupMenu
GroupBox_GetPopupMenu(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pGroupBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetPopupMenu)
void
GroupBox_SetPopupMenu(TGroupBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(GroupBox_SetPopupMenu)
    (((SYSCALL2) (pGroupBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetShowHint)
BOOL
GroupBox_GetShowHint(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetShowHint)
void
GroupBox_SetShowHint(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetShowHint)
    (((SYSCALL2) (pGroupBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetTabOrder)
TTabOrder
GroupBox_GetTabOrder(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pGroupBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetTabOrder)
void
GroupBox_SetTabOrder(TGroupBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(GroupBox_SetTabOrder)
    (((SYSCALL2) (pGroupBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetTabStop)
BOOL
GroupBox_GetTabStop(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetTabStop)
void
GroupBox_SetTabStop(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetTabStop)
    (((SYSCALL2) (pGroupBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetVisible)
BOOL
GroupBox_GetVisible(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetVisible)
void
GroupBox_SetVisible(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetVisible)
    (((SYSCALL2) (pGroupBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnAlignPosition)
void
GroupBox_SetOnAlignPosition(TGroupBox AObj, TAlignPositionEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnAlignPosition)
    (((SYSCALL2) (pGroupBox_SetOnAlignPosition))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnClick)
void
GroupBox_SetOnClick(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnClick)
    (((SYSCALL2) (pGroupBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnContextPopup)
void
GroupBox_SetOnContextPopup(TGroupBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnContextPopup)
    (((SYSCALL2) (pGroupBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnDblClick)
void
GroupBox_SetOnDblClick(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnDblClick)
    (((SYSCALL2) (pGroupBox_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnDragDrop)
void
GroupBox_SetOnDragDrop(TGroupBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnDragDrop)
    (((SYSCALL2) (pGroupBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnDockDrop)
void
GroupBox_SetOnDockDrop(TGroupBox AObj, TDockDropEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnDockDrop)
    (((SYSCALL2) (pGroupBox_SetOnDockDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnDragOver)
void
GroupBox_SetOnDragOver(TGroupBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnDragOver)
    (((SYSCALL2) (pGroupBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnEndDock)
void
GroupBox_SetOnEndDock(TGroupBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnEndDock)
    (((SYSCALL2) (pGroupBox_SetOnEndDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnEndDrag)
void
GroupBox_SetOnEndDrag(TGroupBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnEndDrag)
    (((SYSCALL2) (pGroupBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnEnter)
void
GroupBox_SetOnEnter(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnEnter)
    (((SYSCALL2) (pGroupBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnExit)
void
GroupBox_SetOnExit(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnExit)
    (((SYSCALL2) (pGroupBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnGetSiteInfo)
void
GroupBox_SetOnGetSiteInfo(TGroupBox AObj, TGetSiteInfoEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnGetSiteInfo)
    (((SYSCALL2) (pGroupBox_SetOnGetSiteInfo))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnMouseDown)
void
GroupBox_SetOnMouseDown(TGroupBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnMouseDown)
    (((SYSCALL2) (pGroupBox_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnMouseEnter)
void
GroupBox_SetOnMouseEnter(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnMouseEnter)
    (((SYSCALL2) (pGroupBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnMouseLeave)
void
GroupBox_SetOnMouseLeave(TGroupBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnMouseLeave)
    (((SYSCALL2) (pGroupBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnMouseMove)
void
GroupBox_SetOnMouseMove(TGroupBox AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnMouseMove)
    (((SYSCALL2) (pGroupBox_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnMouseUp)
void
GroupBox_SetOnMouseUp(TGroupBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnMouseUp)
    (((SYSCALL2) (pGroupBox_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnStartDock)
void
GroupBox_SetOnStartDock(TGroupBox AObj, TStartDockEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnStartDock)
    (((SYSCALL2) (pGroupBox_SetOnStartDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_SetOnUnDock)
void
GroupBox_SetOnUnDock(TGroupBox AObj, TUnDockEvent AEventData) {
    GET_FUNC_ADDR(GroupBox_SetOnUnDock)
    (((SYSCALL2) (pGroupBox_SetOnUnDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(GroupBox_GetDockClientCount)
int32_t
GroupBox_GetDockClientCount(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetMouseInClient)
BOOL
GroupBox_GetMouseInClient(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetVisibleDockClientCount)
int32_t
GroupBox_GetVisibleDockClientCount(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetBrush)
TBrush
GroupBox_GetBrush(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pGroupBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetControlCount)
int32_t
GroupBox_GetControlCount(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetHandle)
HWND
GroupBox_GetHandle(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetHandle)
    return (HWND)(((SYSCALL1) (pGroupBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetParentWindow)
HWND
GroupBox_GetParentWindow(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pGroupBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParentWindow)
void
GroupBox_SetParentWindow(TGroupBox AObj, HWND AValue) {
    GET_FUNC_ADDR(GroupBox_SetParentWindow)
    (((SYSCALL2) (pGroupBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetShowing)
BOOL
GroupBox_GetShowing(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetUseDockManager)
BOOL
GroupBox_GetUseDockManager(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetUseDockManager)
void
GroupBox_SetUseDockManager(TGroupBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(GroupBox_SetUseDockManager)
    (((SYSCALL2) (pGroupBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAction)
TAction
GroupBox_GetAction(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAction)
    return (TAction)(((SYSCALL1) (pGroupBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAction)
void
GroupBox_SetAction(TGroupBox AObj, TAction AValue) {
    GET_FUNC_ADDR(GroupBox_SetAction)
    (((SYSCALL2) (pGroupBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetBoundsRect)
TRect
GroupBox_GetBoundsRect(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pGroupBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_SetBoundsRect)
void
GroupBox_SetBoundsRect(TGroupBox AObj, TRect AValue) {
    GET_FUNC_ADDR(GroupBox_SetBoundsRect)
    (((SYSCALL2) (pGroupBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetClientHeight)
int32_t
GroupBox_GetClientHeight(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetClientHeight)
void
GroupBox_SetClientHeight(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetClientHeight)
    (((SYSCALL2) (pGroupBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetClientOrigin)
TPoint
GroupBox_GetClientOrigin(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pGroupBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_GetClientRect)
TRect
GroupBox_GetClientRect(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pGroupBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(GroupBox_GetClientWidth)
int32_t
GroupBox_GetClientWidth(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetClientWidth)
void
GroupBox_SetClientWidth(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetClientWidth)
    (((SYSCALL2) (pGroupBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetControlState)
TControlState
GroupBox_GetControlState(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pGroupBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetControlState)
void
GroupBox_SetControlState(TGroupBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(GroupBox_SetControlState)
    (((SYSCALL2) (pGroupBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetControlStyle)
TControlStyle
GroupBox_GetControlStyle(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pGroupBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetControlStyle)
void
GroupBox_SetControlStyle(TGroupBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(GroupBox_SetControlStyle)
    (((SYSCALL2) (pGroupBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetFloating)
BOOL
GroupBox_GetFloating(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pGroupBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetParent)
TWinControl
GroupBox_GetParent(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pGroupBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetParent)
void
GroupBox_SetParent(TGroupBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(GroupBox_SetParent)
    (((SYSCALL2) (pGroupBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetLeft)
int32_t
GroupBox_GetLeft(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetLeft)
void
GroupBox_SetLeft(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetLeft)
    (((SYSCALL2) (pGroupBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetTop)
int32_t
GroupBox_GetTop(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetTop)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetTop)
void
GroupBox_SetTop(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetTop)
    (((SYSCALL2) (pGroupBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetWidth)
int32_t
GroupBox_GetWidth(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetWidth)
void
GroupBox_SetWidth(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetWidth)
    (((SYSCALL2) (pGroupBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetHeight)
int32_t
GroupBox_GetHeight(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetHeight)
void
GroupBox_SetHeight(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetHeight)
    (((SYSCALL2) (pGroupBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetCursor)
TCursor
GroupBox_GetCursor(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pGroupBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetCursor)
void
GroupBox_SetCursor(TGroupBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(GroupBox_SetCursor)
    (((SYSCALL2) (pGroupBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetHint)
char*
GroupBox_GetHint(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetHint)
    return (char*)(((SYSCALL1) (pGroupBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetHint)
void
GroupBox_SetHint(TGroupBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(GroupBox_SetHint)
    (((SYSCALL2) (pGroupBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetComponentCount)
int32_t
GroupBox_GetComponentCount(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetComponentIndex)
int32_t
GroupBox_GetComponentIndex(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pGroupBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetComponentIndex)
void
GroupBox_SetComponentIndex(TGroupBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetComponentIndex)
    (((SYSCALL2) (pGroupBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetOwner)
TComponent
GroupBox_GetOwner(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pGroupBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_GetName)
char*
GroupBox_GetName(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetName)
    return (char*)(((SYSCALL1) (pGroupBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetName)
void
GroupBox_SetName(TGroupBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(GroupBox_SetName)
    (((SYSCALL2) (pGroupBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetTag)
intptr_t
GroupBox_GetTag(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pGroupBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetTag)
void
GroupBox_SetTag(TGroupBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(GroupBox_SetTag)
    (((SYSCALL2) (pGroupBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchorSideLeft)
TAnchorSide
GroupBox_GetAnchorSideLeft(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pGroupBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAnchorSideLeft)
void
GroupBox_SetAnchorSideLeft(TGroupBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(GroupBox_SetAnchorSideLeft)
    (((SYSCALL2) (pGroupBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchorSideTop)
TAnchorSide
GroupBox_GetAnchorSideTop(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pGroupBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAnchorSideTop)
void
GroupBox_SetAnchorSideTop(TGroupBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(GroupBox_SetAnchorSideTop)
    (((SYSCALL2) (pGroupBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchorSideRight)
TAnchorSide
GroupBox_GetAnchorSideRight(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pGroupBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAnchorSideRight)
void
GroupBox_SetAnchorSideRight(TGroupBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(GroupBox_SetAnchorSideRight)
    (((SYSCALL2) (pGroupBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchorSideBottom)
TAnchorSide
GroupBox_GetAnchorSideBottom(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pGroupBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetAnchorSideBottom)
void
GroupBox_SetAnchorSideBottom(TGroupBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(GroupBox_SetAnchorSideBottom)
    (((SYSCALL2) (pGroupBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetChildSizing)
TControlChildSizing
GroupBox_GetChildSizing(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pGroupBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetChildSizing)
void
GroupBox_SetChildSizing(TGroupBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(GroupBox_SetChildSizing)
    (((SYSCALL2) (pGroupBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetBorderSpacing)
TControlBorderSpacing
GroupBox_GetBorderSpacing(TGroupBox AObj) {
    GET_FUNC_ADDR(GroupBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pGroupBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(GroupBox_SetBorderSpacing)
void
GroupBox_SetBorderSpacing(TGroupBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(GroupBox_SetBorderSpacing)
    (((SYSCALL2) (pGroupBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(GroupBox_GetDockClients)
TControl
GroupBox_GetDockClients(TGroupBox AObj, int32_t Index) {
    GET_FUNC_ADDR(GroupBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pGroupBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(GroupBox_GetControls)
TControl
GroupBox_GetControls(TGroupBox AObj, int32_t Index) {
    GET_FUNC_ADDR(GroupBox_GetControls)
    return (TControl)(((SYSCALL2) (pGroupBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(GroupBox_GetComponents)
TComponent
GroupBox_GetComponents(TGroupBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(GroupBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pGroupBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(GroupBox_GetAnchorSide)
TAnchorSide
GroupBox_GetAnchorSide(TGroupBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(GroupBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pGroupBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(GroupBox_StaticClassType)
TClass
GroupBox_StaticClassType() {
    GET_FUNC_ADDR(GroupBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pGroupBox_StaticClassType))());
}

// -------------------TLabel-------------------

DEFINE_FUNC_PTR(Label_Create)
TLabel
Label_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Label_Create)
    return (TLabel)(((SYSCALL1) (pLabel_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Label_Free)
void
Label_Free(TLabel AObj) {
    GET_FUNC_ADDR(Label_Free)
    (((SYSCALL1) (pLabel_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_BringToFront)
void
Label_BringToFront(TLabel AObj) {
    GET_FUNC_ADDR(Label_BringToFront)
    (((SYSCALL1) (pLabel_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_ClientToScreen)
TPoint
Label_ClientToScreen(TLabel AObj, TPoint Point) {
    GET_FUNC_ADDR(Label_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pLabel_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_ClientToParent)
TPoint
Label_ClientToParent(TLabel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Label_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pLabel_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_Dragging)
BOOL
Label_Dragging(TLabel AObj) {
    GET_FUNC_ADDR(Label_Dragging)
    return (BOOL)(((SYSCALL1) (pLabel_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_HasParent)
BOOL
Label_HasParent(TLabel AObj) {
    GET_FUNC_ADDR(Label_HasParent)
    return (BOOL)(((SYSCALL1) (pLabel_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Hide)
void
Label_Hide(TLabel AObj) {
    GET_FUNC_ADDR(Label_Hide)
    (((SYSCALL1) (pLabel_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Invalidate)
void
Label_Invalidate(TLabel AObj) {
    GET_FUNC_ADDR(Label_Invalidate)
    (((SYSCALL1) (pLabel_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Perform)
intptr_t
Label_Perform(TLabel AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(Label_Perform)
    return (intptr_t)(((SYSCALL4) (pLabel_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(Label_Refresh)
void
Label_Refresh(TLabel AObj) {
    GET_FUNC_ADDR(Label_Refresh)
    (((SYSCALL1) (pLabel_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Repaint)
void
Label_Repaint(TLabel AObj) {
    GET_FUNC_ADDR(Label_Repaint)
    (((SYSCALL1) (pLabel_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_ScreenToClient)
TPoint
Label_ScreenToClient(TLabel AObj, TPoint Point) {
    GET_FUNC_ADDR(Label_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pLabel_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_ParentToClient)
TPoint
Label_ParentToClient(TLabel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Label_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pLabel_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_SendToBack)
void
Label_SendToBack(TLabel AObj) {
    GET_FUNC_ADDR(Label_SendToBack)
    (((SYSCALL1) (pLabel_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetBounds)
void
Label_SetBounds(TLabel AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(Label_SetBounds)
    (((SYSCALL5) (pLabel_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(Label_Show)
void
Label_Show(TLabel AObj) {
    GET_FUNC_ADDR(Label_Show)
    (((SYSCALL1) (pLabel_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Update)
void
Label_Update(TLabel AObj) {
    GET_FUNC_ADDR(Label_Update)
    (((SYSCALL1) (pLabel_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_GetTextBuf)
int32_t
Label_GetTextBuf(TLabel AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(Label_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pLabel_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(Label_GetTextLen)
int32_t
Label_GetTextLen(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetTextLen)
    return (int32_t)(((SYSCALL1) (pLabel_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetTextBuf)
void
Label_SetTextBuf(TLabel AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(Label_SetTextBuf)
    (((SYSCALL2) (pLabel_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(Label_FindComponent)
TComponent
Label_FindComponent(TLabel AObj, CChar char* AName) {
    GET_FUNC_ADDR(Label_FindComponent)
    return (TComponent)(((SYSCALL2) (pLabel_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Label_GetNamePath)
char*
Label_GetNamePath(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetNamePath)
    return (char*)(((SYSCALL1) (pLabel_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_Assign)
void
Label_Assign(TLabel AObj, TObject Source) {
    GET_FUNC_ADDR(Label_Assign)
    (((SYSCALL2) (pLabel_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Label_ClassType)
TClass
Label_ClassType(TLabel AObj) {
    GET_FUNC_ADDR(Label_ClassType)
    return (TClass)(((SYSCALL1) (pLabel_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_ClassName)
char*
Label_ClassName(TLabel AObj) {
    GET_FUNC_ADDR(Label_ClassName)
    return (char*)(((SYSCALL1) (pLabel_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_InstanceSize)
int32_t
Label_InstanceSize(TLabel AObj) {
    GET_FUNC_ADDR(Label_InstanceSize)
    return (int32_t)(((SYSCALL1) (pLabel_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_InheritsFrom)
BOOL
Label_InheritsFrom(TLabel AObj, TClass AClass) {
    GET_FUNC_ADDR(Label_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pLabel_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Label_Equals)
BOOL
Label_Equals(TLabel AObj, TObject Obj) {
    GET_FUNC_ADDR(Label_Equals)
    return (BOOL)(((SYSCALL2) (pLabel_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Label_GetHashCode)
int32_t
Label_GetHashCode(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetHashCode)
    return (int32_t)(((SYSCALL1) (pLabel_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_ToString)
char*
Label_ToString(TLabel AObj) {
    GET_FUNC_ADDR(Label_ToString)
    return (char*)(((SYSCALL1) (pLabel_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_AnchorToNeighbour)
void
Label_AnchorToNeighbour(TLabel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Label_AnchorToNeighbour)
    (((SYSCALL4) (pLabel_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Label_AnchorParallel)
void
Label_AnchorParallel(TLabel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Label_AnchorParallel)
    (((SYSCALL4) (pLabel_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Label_AnchorHorizontalCenterTo)
void
Label_AnchorHorizontalCenterTo(TLabel AObj, TControl ASibling) {
    GET_FUNC_ADDR(Label_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pLabel_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Label_AnchorVerticalCenterTo)
void
Label_AnchorVerticalCenterTo(TLabel AObj, TControl ASibling) {
    GET_FUNC_ADDR(Label_AnchorVerticalCenterTo)
    (((SYSCALL2) (pLabel_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Label_AnchorSame)
void
Label_AnchorSame(TLabel AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(Label_AnchorSame)
    (((SYSCALL3) (pLabel_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Label_AnchorAsAlign)
void
Label_AnchorAsAlign(TLabel AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(Label_AnchorAsAlign)
    (((SYSCALL3) (pLabel_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Label_AnchorClient)
void
Label_AnchorClient(TLabel AObj, int32_t ASpace) {
    GET_FUNC_ADDR(Label_AnchorClient)
    (((SYSCALL2) (pLabel_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Label_ScaleDesignToForm)
int32_t
Label_ScaleDesignToForm(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleFormToDesign)
int32_t
Label_ScaleFormToDesign(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_Scale96ToForm)
int32_t
Label_Scale96ToForm(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pLabel_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleFormTo96)
int32_t
Label_ScaleFormTo96(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_Scale96ToFont)
int32_t
Label_Scale96ToFont(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pLabel_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleFontTo96)
int32_t
Label_ScaleFontTo96(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleScreenToFont)
int32_t
Label_ScaleScreenToFont(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleFontToScreen)
int32_t
Label_ScaleFontToScreen(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_Scale96ToScreen)
int32_t
Label_Scale96ToScreen(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pLabel_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_ScaleScreenTo96)
int32_t
Label_ScaleScreenTo96(TLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Label_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pLabel_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Label_AutoAdjustLayout)
void
Label_AutoAdjustLayout(TLabel AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(Label_AutoAdjustLayout)
    (((SYSCALL6) (pLabel_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(Label_FixDesignFontsPPI)
void
Label_FixDesignFontsPPI(TLabel AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(Label_FixDesignFontsPPI)
    (((SYSCALL2) (pLabel_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(Label_ScaleFontsPPI)
void
Label_ScaleFontsPPI(TLabel AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(Label_ScaleFontsPPI)
    (((SYSCALL3) (pLabel_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(Label_GetOptimalFill)
BOOL
Label_GetOptimalFill(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetOptimalFill)
    return (BOOL)(((SYSCALL1) (pLabel_GetOptimalFill))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetOptimalFill)
void
Label_SetOptimalFill(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetOptimalFill)
    (((SYSCALL2) (pLabel_SetOptimalFill))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAlign)
TAlign
Label_GetAlign(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAlign)
    return (TAlign)(((SYSCALL1) (pLabel_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAlign)
void
Label_SetAlign(TLabel AObj, TAlign AValue) {
    GET_FUNC_ADDR(Label_SetAlign)
    (((SYSCALL2) (pLabel_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAlignment)
TAlignment
Label_GetAlignment(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAlignment)
    return (TAlignment)(((SYSCALL1) (pLabel_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAlignment)
void
Label_SetAlignment(TLabel AObj, TAlignment AValue) {
    GET_FUNC_ADDR(Label_SetAlignment)
    (((SYSCALL2) (pLabel_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAnchors)
TAnchors
Label_GetAnchors(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pLabel_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAnchors)
void
Label_SetAnchors(TLabel AObj, TAnchors AValue) {
    GET_FUNC_ADDR(Label_SetAnchors)
    (((SYSCALL2) (pLabel_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAutoSize)
BOOL
Label_GetAutoSize(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAutoSize)
    return (BOOL)(((SYSCALL1) (pLabel_GetAutoSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAutoSize)
void
Label_SetAutoSize(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetAutoSize)
    (((SYSCALL2) (pLabel_SetAutoSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetBiDiMode)
TBiDiMode
Label_GetBiDiMode(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pLabel_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetBiDiMode)
void
Label_SetBiDiMode(TLabel AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(Label_SetBiDiMode)
    (((SYSCALL2) (pLabel_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetCaption)
char*
Label_GetCaption(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetCaption)
    return (char*)(((SYSCALL1) (pLabel_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetCaption)
void
Label_SetCaption(TLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Label_SetCaption)
    (((SYSCALL2) (pLabel_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetColor)
TColor
Label_GetColor(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetColor)
    return (TColor)(((SYSCALL1) (pLabel_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetColor)
void
Label_SetColor(TLabel AObj, TColor AValue) {
    GET_FUNC_ADDR(Label_SetColor)
    (((SYSCALL2) (pLabel_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetConstraints)
TSizeConstraints
Label_GetConstraints(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pLabel_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetConstraints)
void
Label_SetConstraints(TLabel AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(Label_SetConstraints)
    (((SYSCALL2) (pLabel_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetDragCursor)
TCursor
Label_GetDragCursor(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pLabel_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetDragCursor)
void
Label_SetDragCursor(TLabel AObj, TCursor AValue) {
    GET_FUNC_ADDR(Label_SetDragCursor)
    (((SYSCALL2) (pLabel_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetDragKind)
TDragKind
Label_GetDragKind(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pLabel_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetDragKind)
void
Label_SetDragKind(TLabel AObj, TDragKind AValue) {
    GET_FUNC_ADDR(Label_SetDragKind)
    (((SYSCALL2) (pLabel_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetDragMode)
TDragMode
Label_GetDragMode(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pLabel_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetDragMode)
void
Label_SetDragMode(TLabel AObj, TDragMode AValue) {
    GET_FUNC_ADDR(Label_SetDragMode)
    (((SYSCALL2) (pLabel_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetEnabled)
BOOL
Label_GetEnabled(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetEnabled)
    return (BOOL)(((SYSCALL1) (pLabel_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetEnabled)
void
Label_SetEnabled(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetEnabled)
    (((SYSCALL2) (pLabel_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetFocusControl)
TWinControl
Label_GetFocusControl(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetFocusControl)
    return (TWinControl)(((SYSCALL1) (pLabel_GetFocusControl))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetFocusControl)
void
Label_SetFocusControl(TLabel AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Label_SetFocusControl)
    (((SYSCALL2) (pLabel_SetFocusControl))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetFont)
TFont
Label_GetFont(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetFont)
    return (TFont)(((SYSCALL1) (pLabel_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetFont)
void
Label_SetFont(TLabel AObj, TFont AValue) {
    GET_FUNC_ADDR(Label_SetFont)
    (((SYSCALL2) (pLabel_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetParentColor)
BOOL
Label_GetParentColor(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetParentColor)
    return (BOOL)(((SYSCALL1) (pLabel_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetParentColor)
void
Label_SetParentColor(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetParentColor)
    (((SYSCALL2) (pLabel_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetParentFont)
BOOL
Label_GetParentFont(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetParentFont)
    return (BOOL)(((SYSCALL1) (pLabel_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetParentFont)
void
Label_SetParentFont(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetParentFont)
    (((SYSCALL2) (pLabel_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetParentShowHint)
BOOL
Label_GetParentShowHint(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pLabel_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetParentShowHint)
void
Label_SetParentShowHint(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetParentShowHint)
    (((SYSCALL2) (pLabel_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetPopupMenu)
TPopupMenu
Label_GetPopupMenu(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pLabel_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetPopupMenu)
void
Label_SetPopupMenu(TLabel AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(Label_SetPopupMenu)
    (((SYSCALL2) (pLabel_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetShowAccelChar)
BOOL
Label_GetShowAccelChar(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetShowAccelChar)
    return (BOOL)(((SYSCALL1) (pLabel_GetShowAccelChar))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetShowAccelChar)
void
Label_SetShowAccelChar(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetShowAccelChar)
    (((SYSCALL2) (pLabel_SetShowAccelChar))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetShowHint)
BOOL
Label_GetShowHint(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetShowHint)
    return (BOOL)(((SYSCALL1) (pLabel_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetShowHint)
void
Label_SetShowHint(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetShowHint)
    (((SYSCALL2) (pLabel_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetTransparent)
BOOL
Label_GetTransparent(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetTransparent)
    return (BOOL)(((SYSCALL1) (pLabel_GetTransparent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetTransparent)
void
Label_SetTransparent(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetTransparent)
    (((SYSCALL2) (pLabel_SetTransparent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetLayout)
TTextLayout
Label_GetLayout(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetLayout)
    return (TTextLayout)(((SYSCALL1) (pLabel_GetLayout))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetLayout)
void
Label_SetLayout(TLabel AObj, TTextLayout AValue) {
    GET_FUNC_ADDR(Label_SetLayout)
    (((SYSCALL2) (pLabel_SetLayout))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetVisible)
BOOL
Label_GetVisible(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetVisible)
    return (BOOL)(((SYSCALL1) (pLabel_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetVisible)
void
Label_SetVisible(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetVisible)
    (((SYSCALL2) (pLabel_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetWordWrap)
BOOL
Label_GetWordWrap(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetWordWrap)
    return (BOOL)(((SYSCALL1) (pLabel_GetWordWrap))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetWordWrap)
void
Label_SetWordWrap(TLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Label_SetWordWrap)
    (((SYSCALL2) (pLabel_SetWordWrap))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_SetOnClick)
void
Label_SetOnClick(TLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnClick)
    (((SYSCALL2) (pLabel_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnContextPopup)
void
Label_SetOnContextPopup(TLabel AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnContextPopup)
    (((SYSCALL2) (pLabel_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnDblClick)
void
Label_SetOnDblClick(TLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnDblClick)
    (((SYSCALL2) (pLabel_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnDragDrop)
void
Label_SetOnDragDrop(TLabel AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnDragDrop)
    (((SYSCALL2) (pLabel_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnDragOver)
void
Label_SetOnDragOver(TLabel AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnDragOver)
    (((SYSCALL2) (pLabel_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnEndDrag)
void
Label_SetOnEndDrag(TLabel AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnEndDrag)
    (((SYSCALL2) (pLabel_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnMouseDown)
void
Label_SetOnMouseDown(TLabel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnMouseDown)
    (((SYSCALL2) (pLabel_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnMouseMove)
void
Label_SetOnMouseMove(TLabel AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnMouseMove)
    (((SYSCALL2) (pLabel_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnMouseUp)
void
Label_SetOnMouseUp(TLabel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnMouseUp)
    (((SYSCALL2) (pLabel_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnMouseEnter)
void
Label_SetOnMouseEnter(TLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnMouseEnter)
    (((SYSCALL2) (pLabel_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_SetOnMouseLeave)
void
Label_SetOnMouseLeave(TLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Label_SetOnMouseLeave)
    (((SYSCALL2) (pLabel_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Label_GetCanvas)
TCanvas
Label_GetCanvas(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pLabel_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_GetAction)
TAction
Label_GetAction(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAction)
    return (TAction)(((SYSCALL1) (pLabel_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAction)
void
Label_SetAction(TLabel AObj, TAction AValue) {
    GET_FUNC_ADDR(Label_SetAction)
    (((SYSCALL2) (pLabel_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetBoundsRect)
TRect
Label_GetBoundsRect(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pLabel_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_SetBoundsRect)
void
Label_SetBoundsRect(TLabel AObj, TRect AValue) {
    GET_FUNC_ADDR(Label_SetBoundsRect)
    (((SYSCALL2) (pLabel_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(Label_GetClientHeight)
int32_t
Label_GetClientHeight(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pLabel_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetClientHeight)
void
Label_SetClientHeight(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetClientHeight)
    (((SYSCALL2) (pLabel_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetClientOrigin)
TPoint
Label_GetClientOrigin(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pLabel_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_GetClientRect)
TRect
Label_GetClientRect(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetClientRect)
    TRect result;
    (((SYSCALL2) (pLabel_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Label_GetClientWidth)
int32_t
Label_GetClientWidth(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pLabel_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetClientWidth)
void
Label_SetClientWidth(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetClientWidth)
    (((SYSCALL2) (pLabel_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetControlState)
TControlState
Label_GetControlState(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetControlState)
    return (TControlState)(((SYSCALL1) (pLabel_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetControlState)
void
Label_SetControlState(TLabel AObj, TControlState AValue) {
    GET_FUNC_ADDR(Label_SetControlState)
    (((SYSCALL2) (pLabel_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetControlStyle)
TControlStyle
Label_GetControlStyle(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pLabel_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetControlStyle)
void
Label_SetControlStyle(TLabel AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(Label_SetControlStyle)
    (((SYSCALL2) (pLabel_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetFloating)
BOOL
Label_GetFloating(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetFloating)
    return (BOOL)(((SYSCALL1) (pLabel_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_GetParent)
TWinControl
Label_GetParent(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetParent)
    return (TWinControl)(((SYSCALL1) (pLabel_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetParent)
void
Label_SetParent(TLabel AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Label_SetParent)
    (((SYSCALL2) (pLabel_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetLeft)
int32_t
Label_GetLeft(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetLeft)
    return (int32_t)(((SYSCALL1) (pLabel_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetLeft)
void
Label_SetLeft(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetLeft)
    (((SYSCALL2) (pLabel_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetTop)
int32_t
Label_GetTop(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetTop)
    return (int32_t)(((SYSCALL1) (pLabel_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetTop)
void
Label_SetTop(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetTop)
    (((SYSCALL2) (pLabel_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetWidth)
int32_t
Label_GetWidth(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetWidth)
    return (int32_t)(((SYSCALL1) (pLabel_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetWidth)
void
Label_SetWidth(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetWidth)
    (((SYSCALL2) (pLabel_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetHeight)
int32_t
Label_GetHeight(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetHeight)
    return (int32_t)(((SYSCALL1) (pLabel_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetHeight)
void
Label_SetHeight(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetHeight)
    (((SYSCALL2) (pLabel_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetCursor)
TCursor
Label_GetCursor(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetCursor)
    return (TCursor)(((SYSCALL1) (pLabel_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetCursor)
void
Label_SetCursor(TLabel AObj, TCursor AValue) {
    GET_FUNC_ADDR(Label_SetCursor)
    (((SYSCALL2) (pLabel_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetHint)
char*
Label_GetHint(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetHint)
    return (char*)(((SYSCALL1) (pLabel_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetHint)
void
Label_SetHint(TLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Label_SetHint)
    (((SYSCALL2) (pLabel_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetComponentCount)
int32_t
Label_GetComponentCount(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pLabel_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_GetComponentIndex)
int32_t
Label_GetComponentIndex(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pLabel_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetComponentIndex)
void
Label_SetComponentIndex(TLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Label_SetComponentIndex)
    (((SYSCALL2) (pLabel_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetOwner)
TComponent
Label_GetOwner(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetOwner)
    return (TComponent)(((SYSCALL1) (pLabel_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_GetName)
char*
Label_GetName(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetName)
    return (char*)(((SYSCALL1) (pLabel_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetName)
void
Label_SetName(TLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Label_SetName)
    (((SYSCALL2) (pLabel_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetTag)
intptr_t
Label_GetTag(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetTag)
    return (intptr_t)(((SYSCALL1) (pLabel_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetTag)
void
Label_SetTag(TLabel AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Label_SetTag)
    (((SYSCALL2) (pLabel_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAnchorSideLeft)
TAnchorSide
Label_GetAnchorSideLeft(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pLabel_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAnchorSideLeft)
void
Label_SetAnchorSideLeft(TLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Label_SetAnchorSideLeft)
    (((SYSCALL2) (pLabel_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAnchorSideTop)
TAnchorSide
Label_GetAnchorSideTop(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pLabel_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAnchorSideTop)
void
Label_SetAnchorSideTop(TLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Label_SetAnchorSideTop)
    (((SYSCALL2) (pLabel_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAnchorSideRight)
TAnchorSide
Label_GetAnchorSideRight(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pLabel_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAnchorSideRight)
void
Label_SetAnchorSideRight(TLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Label_SetAnchorSideRight)
    (((SYSCALL2) (pLabel_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetAnchorSideBottom)
TAnchorSide
Label_GetAnchorSideBottom(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pLabel_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetAnchorSideBottom)
void
Label_SetAnchorSideBottom(TLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Label_SetAnchorSideBottom)
    (((SYSCALL2) (pLabel_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetBorderSpacing)
TControlBorderSpacing
Label_GetBorderSpacing(TLabel AObj) {
    GET_FUNC_ADDR(Label_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pLabel_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Label_SetBorderSpacing)
void
Label_SetBorderSpacing(TLabel AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(Label_SetBorderSpacing)
    (((SYSCALL2) (pLabel_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Label_GetComponents)
TComponent
Label_GetComponents(TLabel AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Label_GetComponents)
    return (TComponent)(((SYSCALL2) (pLabel_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Label_GetAnchorSide)
TAnchorSide
Label_GetAnchorSide(TLabel AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(Label_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pLabel_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(Label_StaticClassType)
TClass
Label_StaticClassType() {
    GET_FUNC_ADDR(Label_StaticClassType)
    return (TClass)(((SYSCALL0) (pLabel_StaticClassType))());
}

// -------------------TListBox-------------------

DEFINE_FUNC_PTR(ListBox_Create)
TListBox
ListBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(ListBox_Create)
    return (TListBox)(((SYSCALL1) (pListBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(ListBox_Free)
void
ListBox_Free(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Free)
    (((SYSCALL1) (pListBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_AddItem)
void
ListBox_AddItem(TListBox AObj, CChar char* Item, TObject AObject) {
    GET_FUNC_ADDR(ListBox_AddItem)
    (((SYSCALL3) (pListBox_AddItem))(COV_PARAM(AObj), COV_PARAM(Item), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(ListBox_Clear)
void
ListBox_Clear(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Clear)
    (((SYSCALL1) (pListBox_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ClearSelection)
void
ListBox_ClearSelection(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_ClearSelection)
    (((SYSCALL1) (pListBox_ClearSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_DeleteSelected)
void
ListBox_DeleteSelected(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_DeleteSelected)
    (((SYSCALL1) (pListBox_DeleteSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ItemAtPos)
int32_t
ListBox_ItemAtPos(TListBox AObj, TPoint Pos, BOOL Existing) {
    GET_FUNC_ADDR(ListBox_ItemAtPos)
    return (int32_t)(((SYSCALL3) (pListBox_ItemAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(Existing)));
}

DEFINE_FUNC_PTR(ListBox_ItemRect)
TRect
ListBox_ItemRect(TListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ListBox_ItemRect)
    TRect result;
    (((SYSCALL3) (pListBox_ItemRect))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_SelectAll)
void
ListBox_SelectAll(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_SelectAll)
    (((SYSCALL1) (pListBox_SelectAll))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_CanFocus)
BOOL
ListBox_CanFocus(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pListBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ContainsControl)
BOOL
ListBox_ContainsControl(TListBox AObj, TControl Control) {
    GET_FUNC_ADDR(ListBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pListBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(ListBox_ControlAtPos)
TControl
ListBox_ControlAtPos(TListBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(ListBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pListBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(ListBox_DisableAlign)
void
ListBox_DisableAlign(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_DisableAlign)
    (((SYSCALL1) (pListBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_EnableAlign)
void
ListBox_EnableAlign(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_EnableAlign)
    (((SYSCALL1) (pListBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_FindChildControl)
TControl
ListBox_FindChildControl(TListBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(ListBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pListBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(ListBox_FlipChildren)
void
ListBox_FlipChildren(TListBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(ListBox_FlipChildren)
    (((SYSCALL2) (pListBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(ListBox_Focused)
BOOL
ListBox_Focused(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Focused)
    return (BOOL)(((SYSCALL1) (pListBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_HandleAllocated)
BOOL
ListBox_HandleAllocated(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pListBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_InsertControl)
void
ListBox_InsertControl(TListBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ListBox_InsertControl)
    (((SYSCALL2) (pListBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ListBox_Invalidate)
void
ListBox_Invalidate(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Invalidate)
    (((SYSCALL1) (pListBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_PaintTo)
void
ListBox_PaintTo(TListBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(ListBox_PaintTo)
    (((SYSCALL4) (pListBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(ListBox_RemoveControl)
void
ListBox_RemoveControl(TListBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ListBox_RemoveControl)
    (((SYSCALL2) (pListBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ListBox_Realign)
void
ListBox_Realign(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Realign)
    (((SYSCALL1) (pListBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Repaint)
void
ListBox_Repaint(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Repaint)
    (((SYSCALL1) (pListBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ScaleBy)
void
ListBox_ScaleBy(TListBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(ListBox_ScaleBy)
    (((SYSCALL3) (pListBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(ListBox_ScrollBy)
void
ListBox_ScrollBy(TListBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(ListBox_ScrollBy)
    (((SYSCALL3) (pListBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(ListBox_SetBounds)
void
ListBox_SetBounds(TListBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(ListBox_SetBounds)
    (((SYSCALL5) (pListBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(ListBox_SetFocus)
void
ListBox_SetFocus(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_SetFocus)
    (((SYSCALL1) (pListBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Update)
void
ListBox_Update(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Update)
    (((SYSCALL1) (pListBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_BringToFront)
void
ListBox_BringToFront(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_BringToFront)
    (((SYSCALL1) (pListBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ClientToScreen)
TPoint
ListBox_ClientToScreen(TListBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ListBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pListBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_ClientToParent)
TPoint
ListBox_ClientToParent(TListBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ListBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pListBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_Dragging)
BOOL
ListBox_Dragging(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Dragging)
    return (BOOL)(((SYSCALL1) (pListBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_HasParent)
BOOL
ListBox_HasParent(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_HasParent)
    return (BOOL)(((SYSCALL1) (pListBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Hide)
void
ListBox_Hide(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Hide)
    (((SYSCALL1) (pListBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Perform)
intptr_t
ListBox_Perform(TListBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(ListBox_Perform)
    return (intptr_t)(((SYSCALL4) (pListBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(ListBox_Refresh)
void
ListBox_Refresh(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Refresh)
    (((SYSCALL1) (pListBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ScreenToClient)
TPoint
ListBox_ScreenToClient(TListBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ListBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pListBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_ParentToClient)
TPoint
ListBox_ParentToClient(TListBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ListBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pListBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_SendToBack)
void
ListBox_SendToBack(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_SendToBack)
    (((SYSCALL1) (pListBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Show)
void
ListBox_Show(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_Show)
    (((SYSCALL1) (pListBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetTextBuf)
int32_t
ListBox_GetTextBuf(TListBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(ListBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pListBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(ListBox_GetTextLen)
int32_t
ListBox_GetTextLen(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pListBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTextBuf)
void
ListBox_SetTextBuf(TListBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(ListBox_SetTextBuf)
    (((SYSCALL2) (pListBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(ListBox_FindComponent)
TComponent
ListBox_FindComponent(TListBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(ListBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pListBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(ListBox_GetNamePath)
char*
ListBox_GetNamePath(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetNamePath)
    return (char*)(((SYSCALL1) (pListBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_Assign)
void
ListBox_Assign(TListBox AObj, TObject Source) {
    GET_FUNC_ADDR(ListBox_Assign)
    (((SYSCALL2) (pListBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(ListBox_ClassType)
TClass
ListBox_ClassType(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_ClassType)
    return (TClass)(((SYSCALL1) (pListBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ClassName)
char*
ListBox_ClassName(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_ClassName)
    return (char*)(((SYSCALL1) (pListBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_InstanceSize)
int32_t
ListBox_InstanceSize(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pListBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_InheritsFrom)
BOOL
ListBox_InheritsFrom(TListBox AObj, TClass AClass) {
    GET_FUNC_ADDR(ListBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pListBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(ListBox_Equals)
BOOL
ListBox_Equals(TListBox AObj, TObject Obj) {
    GET_FUNC_ADDR(ListBox_Equals)
    return (BOOL)(((SYSCALL2) (pListBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(ListBox_GetHashCode)
int32_t
ListBox_GetHashCode(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pListBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_ToString)
char*
ListBox_ToString(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_ToString)
    return (char*)(((SYSCALL1) (pListBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_AnchorToNeighbour)
void
ListBox_AnchorToNeighbour(TListBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ListBox_AnchorToNeighbour)
    (((SYSCALL4) (pListBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ListBox_AnchorParallel)
void
ListBox_AnchorParallel(TListBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ListBox_AnchorParallel)
    (((SYSCALL4) (pListBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ListBox_AnchorHorizontalCenterTo)
void
ListBox_AnchorHorizontalCenterTo(TListBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ListBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pListBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ListBox_AnchorVerticalCenterTo)
void
ListBox_AnchorVerticalCenterTo(TListBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ListBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pListBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ListBox_AnchorSame)
void
ListBox_AnchorSame(TListBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(ListBox_AnchorSame)
    (((SYSCALL3) (pListBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ListBox_AnchorAsAlign)
void
ListBox_AnchorAsAlign(TListBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(ListBox_AnchorAsAlign)
    (((SYSCALL3) (pListBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ListBox_AnchorClient)
void
ListBox_AnchorClient(TListBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(ListBox_AnchorClient)
    (((SYSCALL2) (pListBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ListBox_ScaleDesignToForm)
int32_t
ListBox_ScaleDesignToForm(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleFormToDesign)
int32_t
ListBox_ScaleFormToDesign(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_Scale96ToForm)
int32_t
ListBox_Scale96ToForm(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pListBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleFormTo96)
int32_t
ListBox_ScaleFormTo96(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_Scale96ToFont)
int32_t
ListBox_Scale96ToFont(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pListBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleFontTo96)
int32_t
ListBox_ScaleFontTo96(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleScreenToFont)
int32_t
ListBox_ScaleScreenToFont(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleFontToScreen)
int32_t
ListBox_ScaleFontToScreen(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_Scale96ToScreen)
int32_t
ListBox_Scale96ToScreen(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pListBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_ScaleScreenTo96)
int32_t
ListBox_ScaleScreenTo96(TListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ListBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pListBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ListBox_AutoAdjustLayout)
void
ListBox_AutoAdjustLayout(TListBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(ListBox_AutoAdjustLayout)
    (((SYSCALL6) (pListBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(ListBox_FixDesignFontsPPI)
void
ListBox_FixDesignFontsPPI(TListBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(ListBox_FixDesignFontsPPI)
    (((SYSCALL2) (pListBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(ListBox_ScaleFontsPPI)
void
ListBox_ScaleFontsPPI(TListBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(ListBox_ScaleFontsPPI)
    (((SYSCALL3) (pListBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(ListBox_GetClickOnSelChange)
BOOL
ListBox_GetClickOnSelChange(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetClickOnSelChange)
    return (BOOL)(((SYSCALL1) (pListBox_GetClickOnSelChange))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetClickOnSelChange)
void
ListBox_SetClickOnSelChange(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetClickOnSelChange)
    (((SYSCALL2) (pListBox_SetClickOnSelChange))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetOptions)
TListBoxOptions
ListBox_GetOptions(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetOptions)
    return (TListBoxOptions)(((SYSCALL1) (pListBox_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetOptions)
void
ListBox_SetOptions(TListBox AObj, TListBoxOptions AValue) {
    GET_FUNC_ADDR(ListBox_SetOptions)
    (((SYSCALL2) (pListBox_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetTopIndex)
int32_t
ListBox_GetTopIndex(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTopIndex)
    return (int32_t)(((SYSCALL1) (pListBox_GetTopIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTopIndex)
void
ListBox_SetTopIndex(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetTopIndex)
    (((SYSCALL2) (pListBox_SetTopIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetStyle)
TListBoxStyle
ListBox_GetStyle(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetStyle)
    return (TListBoxStyle)(((SYSCALL1) (pListBox_GetStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetStyle)
void
ListBox_SetStyle(TListBox AObj, TListBoxStyle AValue) {
    GET_FUNC_ADDR(ListBox_SetStyle)
    (((SYSCALL2) (pListBox_SetStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAlign)
TAlign
ListBox_GetAlign(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pListBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAlign)
void
ListBox_SetAlign(TListBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(ListBox_SetAlign)
    (((SYSCALL2) (pListBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchors)
TAnchors
ListBox_GetAnchors(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pListBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAnchors)
void
ListBox_SetAnchors(TListBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(ListBox_SetAnchors)
    (((SYSCALL2) (pListBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetBiDiMode)
TBiDiMode
ListBox_GetBiDiMode(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pListBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetBiDiMode)
void
ListBox_SetBiDiMode(TListBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(ListBox_SetBiDiMode)
    (((SYSCALL2) (pListBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetBorderStyle)
TBorderStyle
ListBox_GetBorderStyle(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetBorderStyle)
    return (TBorderStyle)(((SYSCALL1) (pListBox_GetBorderStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetBorderStyle)
void
ListBox_SetBorderStyle(TListBox AObj, TBorderStyle AValue) {
    GET_FUNC_ADDR(ListBox_SetBorderStyle)
    (((SYSCALL2) (pListBox_SetBorderStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetColor)
TColor
ListBox_GetColor(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetColor)
    return (TColor)(((SYSCALL1) (pListBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetColor)
void
ListBox_SetColor(TListBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ListBox_SetColor)
    (((SYSCALL2) (pListBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetColumns)
int32_t
ListBox_GetColumns(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetColumns)
    return (int32_t)(((SYSCALL1) (pListBox_GetColumns))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetColumns)
void
ListBox_SetColumns(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetColumns)
    (((SYSCALL2) (pListBox_SetColumns))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetConstraints)
TSizeConstraints
ListBox_GetConstraints(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pListBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetConstraints)
void
ListBox_SetConstraints(TListBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(ListBox_SetConstraints)
    (((SYSCALL2) (pListBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDoubleBuffered)
BOOL
ListBox_GetDoubleBuffered(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pListBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetDoubleBuffered)
void
ListBox_SetDoubleBuffered(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetDoubleBuffered)
    (((SYSCALL2) (pListBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDragCursor)
TCursor
ListBox_GetDragCursor(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pListBox_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetDragCursor)
void
ListBox_SetDragCursor(TListBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ListBox_SetDragCursor)
    (((SYSCALL2) (pListBox_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDragKind)
TDragKind
ListBox_GetDragKind(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pListBox_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetDragKind)
void
ListBox_SetDragKind(TListBox AObj, TDragKind AValue) {
    GET_FUNC_ADDR(ListBox_SetDragKind)
    (((SYSCALL2) (pListBox_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDragMode)
TDragMode
ListBox_GetDragMode(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pListBox_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetDragMode)
void
ListBox_SetDragMode(TListBox AObj, TDragMode AValue) {
    GET_FUNC_ADDR(ListBox_SetDragMode)
    (((SYSCALL2) (pListBox_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetEnabled)
BOOL
ListBox_GetEnabled(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pListBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetEnabled)
void
ListBox_SetEnabled(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetEnabled)
    (((SYSCALL2) (pListBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetExtendedSelect)
BOOL
ListBox_GetExtendedSelect(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetExtendedSelect)
    return (BOOL)(((SYSCALL1) (pListBox_GetExtendedSelect))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetExtendedSelect)
void
ListBox_SetExtendedSelect(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetExtendedSelect)
    (((SYSCALL2) (pListBox_SetExtendedSelect))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetFont)
TFont
ListBox_GetFont(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetFont)
    return (TFont)(((SYSCALL1) (pListBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetFont)
void
ListBox_SetFont(TListBox AObj, TFont AValue) {
    GET_FUNC_ADDR(ListBox_SetFont)
    (((SYSCALL2) (pListBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetItemHeight)
int32_t
ListBox_GetItemHeight(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetItemHeight)
    return (int32_t)(((SYSCALL1) (pListBox_GetItemHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetItemHeight)
void
ListBox_SetItemHeight(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetItemHeight)
    (((SYSCALL2) (pListBox_SetItemHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetItems)
TStrings
ListBox_GetItems(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetItems)
    return (TStrings)(((SYSCALL1) (pListBox_GetItems))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetItems)
void
ListBox_SetItems(TListBox AObj, TStrings AValue) {
    GET_FUNC_ADDR(ListBox_SetItems)
    (((SYSCALL2) (pListBox_SetItems))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetMultiSelect)
BOOL
ListBox_GetMultiSelect(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetMultiSelect)
    return (BOOL)(((SYSCALL1) (pListBox_GetMultiSelect))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetMultiSelect)
void
ListBox_SetMultiSelect(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetMultiSelect)
    (((SYSCALL2) (pListBox_SetMultiSelect))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetParentColor)
BOOL
ListBox_GetParentColor(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pListBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParentColor)
void
ListBox_SetParentColor(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetParentColor)
    (((SYSCALL2) (pListBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetParentDoubleBuffered)
BOOL
ListBox_GetParentDoubleBuffered(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pListBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParentDoubleBuffered)
void
ListBox_SetParentDoubleBuffered(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pListBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetParentFont)
BOOL
ListBox_GetParentFont(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pListBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParentFont)
void
ListBox_SetParentFont(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetParentFont)
    (((SYSCALL2) (pListBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetParentShowHint)
BOOL
ListBox_GetParentShowHint(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pListBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParentShowHint)
void
ListBox_SetParentShowHint(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetParentShowHint)
    (((SYSCALL2) (pListBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetPopupMenu)
TPopupMenu
ListBox_GetPopupMenu(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pListBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetPopupMenu)
void
ListBox_SetPopupMenu(TListBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(ListBox_SetPopupMenu)
    (((SYSCALL2) (pListBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetShowHint)
BOOL
ListBox_GetShowHint(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pListBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetShowHint)
void
ListBox_SetShowHint(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetShowHint)
    (((SYSCALL2) (pListBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetSorted)
BOOL
ListBox_GetSorted(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetSorted)
    return (BOOL)(((SYSCALL1) (pListBox_GetSorted))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetSorted)
void
ListBox_SetSorted(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetSorted)
    (((SYSCALL2) (pListBox_SetSorted))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetTabOrder)
TTabOrder
ListBox_GetTabOrder(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pListBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTabOrder)
void
ListBox_SetTabOrder(TListBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(ListBox_SetTabOrder)
    (((SYSCALL2) (pListBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetTabStop)
BOOL
ListBox_GetTabStop(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pListBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTabStop)
void
ListBox_SetTabStop(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetTabStop)
    (((SYSCALL2) (pListBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetVisible)
BOOL
ListBox_GetVisible(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pListBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetVisible)
void
ListBox_SetVisible(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetVisible)
    (((SYSCALL2) (pListBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_SetOnClick)
void
ListBox_SetOnClick(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnClick)
    (((SYSCALL2) (pListBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnContextPopup)
void
ListBox_SetOnContextPopup(TListBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnContextPopup)
    (((SYSCALL2) (pListBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnDblClick)
void
ListBox_SetOnDblClick(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnDblClick)
    (((SYSCALL2) (pListBox_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnDragDrop)
void
ListBox_SetOnDragDrop(TListBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnDragDrop)
    (((SYSCALL2) (pListBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnDragOver)
void
ListBox_SetOnDragOver(TListBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnDragOver)
    (((SYSCALL2) (pListBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnDrawItem)
void
ListBox_SetOnDrawItem(TListBox AObj, TDrawItemEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnDrawItem)
    (((SYSCALL2) (pListBox_SetOnDrawItem))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnEndDrag)
void
ListBox_SetOnEndDrag(TListBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnEndDrag)
    (((SYSCALL2) (pListBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnEnter)
void
ListBox_SetOnEnter(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnEnter)
    (((SYSCALL2) (pListBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnExit)
void
ListBox_SetOnExit(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnExit)
    (((SYSCALL2) (pListBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnKeyDown)
void
ListBox_SetOnKeyDown(TListBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnKeyDown)
    (((SYSCALL2) (pListBox_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnKeyPress)
void
ListBox_SetOnKeyPress(TListBox AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnKeyPress)
    (((SYSCALL2) (pListBox_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnKeyUp)
void
ListBox_SetOnKeyUp(TListBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnKeyUp)
    (((SYSCALL2) (pListBox_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMeasureItem)
void
ListBox_SetOnMeasureItem(TListBox AObj, TMeasureItemEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMeasureItem)
    (((SYSCALL2) (pListBox_SetOnMeasureItem))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMouseDown)
void
ListBox_SetOnMouseDown(TListBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMouseDown)
    (((SYSCALL2) (pListBox_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMouseEnter)
void
ListBox_SetOnMouseEnter(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMouseEnter)
    (((SYSCALL2) (pListBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMouseLeave)
void
ListBox_SetOnMouseLeave(TListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMouseLeave)
    (((SYSCALL2) (pListBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMouseMove)
void
ListBox_SetOnMouseMove(TListBox AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMouseMove)
    (((SYSCALL2) (pListBox_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_SetOnMouseUp)
void
ListBox_SetOnMouseUp(TListBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(ListBox_SetOnMouseUp)
    (((SYSCALL2) (pListBox_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ListBox_GetCanvas)
TCanvas
ListBox_GetCanvas(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pListBox_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetCount)
int32_t
ListBox_GetCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetSelCount)
int32_t
ListBox_GetSelCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetSelCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetSelCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetItemIndex)
int32_t
ListBox_GetItemIndex(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetItemIndex)
    return (int32_t)(((SYSCALL1) (pListBox_GetItemIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetItemIndex)
void
ListBox_SetItemIndex(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetItemIndex)
    (((SYSCALL2) (pListBox_SetItemIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDockClientCount)
int32_t
ListBox_GetDockClientCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetDockSite)
BOOL
ListBox_GetDockSite(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pListBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetDockSite)
void
ListBox_SetDockSite(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetDockSite)
    (((SYSCALL2) (pListBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetMouseInClient)
BOOL
ListBox_GetMouseInClient(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pListBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetVisibleDockClientCount)
int32_t
ListBox_GetVisibleDockClientCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetBrush)
TBrush
ListBox_GetBrush(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pListBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetControlCount)
int32_t
ListBox_GetControlCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetHandle)
HWND
ListBox_GetHandle(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetHandle)
    return (HWND)(((SYSCALL1) (pListBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetParentWindow)
HWND
ListBox_GetParentWindow(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pListBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParentWindow)
void
ListBox_SetParentWindow(TListBox AObj, HWND AValue) {
    GET_FUNC_ADDR(ListBox_SetParentWindow)
    (((SYSCALL2) (pListBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetShowing)
BOOL
ListBox_GetShowing(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pListBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetUseDockManager)
BOOL
ListBox_GetUseDockManager(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pListBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetUseDockManager)
void
ListBox_SetUseDockManager(TListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetUseDockManager)
    (((SYSCALL2) (pListBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAction)
TAction
ListBox_GetAction(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAction)
    return (TAction)(((SYSCALL1) (pListBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAction)
void
ListBox_SetAction(TListBox AObj, TAction AValue) {
    GET_FUNC_ADDR(ListBox_SetAction)
    (((SYSCALL2) (pListBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetBoundsRect)
TRect
ListBox_GetBoundsRect(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pListBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_SetBoundsRect)
void
ListBox_SetBoundsRect(TListBox AObj, TRect AValue) {
    GET_FUNC_ADDR(ListBox_SetBoundsRect)
    (((SYSCALL2) (pListBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetClientHeight)
int32_t
ListBox_GetClientHeight(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pListBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetClientHeight)
void
ListBox_SetClientHeight(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetClientHeight)
    (((SYSCALL2) (pListBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetClientOrigin)
TPoint
ListBox_GetClientOrigin(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pListBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_GetClientRect)
TRect
ListBox_GetClientRect(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pListBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ListBox_GetClientWidth)
int32_t
ListBox_GetClientWidth(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pListBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetClientWidth)
void
ListBox_SetClientWidth(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetClientWidth)
    (((SYSCALL2) (pListBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetControlState)
TControlState
ListBox_GetControlState(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pListBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetControlState)
void
ListBox_SetControlState(TListBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(ListBox_SetControlState)
    (((SYSCALL2) (pListBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetControlStyle)
TControlStyle
ListBox_GetControlStyle(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pListBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetControlStyle)
void
ListBox_SetControlStyle(TListBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(ListBox_SetControlStyle)
    (((SYSCALL2) (pListBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetFloating)
BOOL
ListBox_GetFloating(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pListBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetParent)
TWinControl
ListBox_GetParent(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pListBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetParent)
void
ListBox_SetParent(TListBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(ListBox_SetParent)
    (((SYSCALL2) (pListBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetLeft)
int32_t
ListBox_GetLeft(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pListBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetLeft)
void
ListBox_SetLeft(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetLeft)
    (((SYSCALL2) (pListBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetTop)
int32_t
ListBox_GetTop(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTop)
    return (int32_t)(((SYSCALL1) (pListBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTop)
void
ListBox_SetTop(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetTop)
    (((SYSCALL2) (pListBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetWidth)
int32_t
ListBox_GetWidth(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pListBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetWidth)
void
ListBox_SetWidth(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetWidth)
    (((SYSCALL2) (pListBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetHeight)
int32_t
ListBox_GetHeight(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pListBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetHeight)
void
ListBox_SetHeight(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetHeight)
    (((SYSCALL2) (pListBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetCursor)
TCursor
ListBox_GetCursor(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pListBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetCursor)
void
ListBox_SetCursor(TListBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ListBox_SetCursor)
    (((SYSCALL2) (pListBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetHint)
char*
ListBox_GetHint(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetHint)
    return (char*)(((SYSCALL1) (pListBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetHint)
void
ListBox_SetHint(TListBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ListBox_SetHint)
    (((SYSCALL2) (pListBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetComponentCount)
int32_t
ListBox_GetComponentCount(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pListBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetComponentIndex)
int32_t
ListBox_GetComponentIndex(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pListBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetComponentIndex)
void
ListBox_SetComponentIndex(TListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ListBox_SetComponentIndex)
    (((SYSCALL2) (pListBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetOwner)
TComponent
ListBox_GetOwner(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pListBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_GetName)
char*
ListBox_GetName(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetName)
    return (char*)(((SYSCALL1) (pListBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetName)
void
ListBox_SetName(TListBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ListBox_SetName)
    (((SYSCALL2) (pListBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetTag)
intptr_t
ListBox_GetTag(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pListBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetTag)
void
ListBox_SetTag(TListBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(ListBox_SetTag)
    (((SYSCALL2) (pListBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchorSideLeft)
TAnchorSide
ListBox_GetAnchorSideLeft(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pListBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAnchorSideLeft)
void
ListBox_SetAnchorSideLeft(TListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ListBox_SetAnchorSideLeft)
    (((SYSCALL2) (pListBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchorSideTop)
TAnchorSide
ListBox_GetAnchorSideTop(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pListBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAnchorSideTop)
void
ListBox_SetAnchorSideTop(TListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ListBox_SetAnchorSideTop)
    (((SYSCALL2) (pListBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchorSideRight)
TAnchorSide
ListBox_GetAnchorSideRight(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pListBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAnchorSideRight)
void
ListBox_SetAnchorSideRight(TListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ListBox_SetAnchorSideRight)
    (((SYSCALL2) (pListBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchorSideBottom)
TAnchorSide
ListBox_GetAnchorSideBottom(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pListBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetAnchorSideBottom)
void
ListBox_SetAnchorSideBottom(TListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ListBox_SetAnchorSideBottom)
    (((SYSCALL2) (pListBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetChildSizing)
TControlChildSizing
ListBox_GetChildSizing(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pListBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetChildSizing)
void
ListBox_SetChildSizing(TListBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(ListBox_SetChildSizing)
    (((SYSCALL2) (pListBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetBorderSpacing)
TControlBorderSpacing
ListBox_GetBorderSpacing(TListBox AObj) {
    GET_FUNC_ADDR(ListBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pListBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ListBox_SetBorderSpacing)
void
ListBox_SetBorderSpacing(TListBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(ListBox_SetBorderSpacing)
    (((SYSCALL2) (pListBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetSelected)
BOOL
ListBox_GetSelected(TListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ListBox_GetSelected)
    return (BOOL)(((SYSCALL2) (pListBox_GetSelected))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ListBox_SetSelected)
void
ListBox_SetSelected(TListBox AObj, int32_t Index, BOOL AValue) {
    GET_FUNC_ADDR(ListBox_SetSelected)
    (((SYSCALL3) (pListBox_SetSelected))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ListBox_GetDockClients)
TControl
ListBox_GetDockClients(TListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ListBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pListBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ListBox_GetControls)
TControl
ListBox_GetControls(TListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ListBox_GetControls)
    return (TControl)(((SYSCALL2) (pListBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ListBox_GetComponents)
TComponent
ListBox_GetComponents(TListBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(ListBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pListBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(ListBox_GetAnchorSide)
TAnchorSide
ListBox_GetAnchorSide(TListBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(ListBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pListBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(ListBox_StaticClassType)
TClass
ListBox_StaticClassType() {
    GET_FUNC_ADDR(ListBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pListBox_StaticClassType))());
}

// -------------------TComboBox-------------------

DEFINE_FUNC_PTR(ComboBox_Create)
TComboBox
ComboBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(ComboBox_Create)
    return (TComboBox)(((SYSCALL1) (pComboBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(ComboBox_Free)
void
ComboBox_Free(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Free)
    (((SYSCALL1) (pComboBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_AddItem)
void
ComboBox_AddItem(TComboBox AObj, CChar char* Item, TObject AObject) {
    GET_FUNC_ADDR(ComboBox_AddItem)
    (((SYSCALL3) (pComboBox_AddItem))(COV_PARAM(AObj), COV_PARAM(Item), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(ComboBox_Clear)
void
ComboBox_Clear(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Clear)
    (((SYSCALL1) (pComboBox_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ClearSelection)
void
ComboBox_ClearSelection(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_ClearSelection)
    (((SYSCALL1) (pComboBox_ClearSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_DeleteSelected)
void
ComboBox_DeleteSelected(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_DeleteSelected)
    (((SYSCALL1) (pComboBox_DeleteSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Focused)
BOOL
ComboBox_Focused(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Focused)
    return (BOOL)(((SYSCALL1) (pComboBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SelectAll)
void
ComboBox_SelectAll(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_SelectAll)
    (((SYSCALL1) (pComboBox_SelectAll))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_CanFocus)
BOOL
ComboBox_CanFocus(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pComboBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ContainsControl)
BOOL
ComboBox_ContainsControl(TComboBox AObj, TControl Control) {
    GET_FUNC_ADDR(ComboBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pComboBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(ComboBox_ControlAtPos)
TControl
ComboBox_ControlAtPos(TComboBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(ComboBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pComboBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(ComboBox_DisableAlign)
void
ComboBox_DisableAlign(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_DisableAlign)
    (((SYSCALL1) (pComboBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_EnableAlign)
void
ComboBox_EnableAlign(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_EnableAlign)
    (((SYSCALL1) (pComboBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_FindChildControl)
TControl
ComboBox_FindChildControl(TComboBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(ComboBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pComboBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(ComboBox_FlipChildren)
void
ComboBox_FlipChildren(TComboBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(ComboBox_FlipChildren)
    (((SYSCALL2) (pComboBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(ComboBox_HandleAllocated)
BOOL
ComboBox_HandleAllocated(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pComboBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_InsertControl)
void
ComboBox_InsertControl(TComboBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ComboBox_InsertControl)
    (((SYSCALL2) (pComboBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ComboBox_Invalidate)
void
ComboBox_Invalidate(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Invalidate)
    (((SYSCALL1) (pComboBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_PaintTo)
void
ComboBox_PaintTo(TComboBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(ComboBox_PaintTo)
    (((SYSCALL4) (pComboBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(ComboBox_RemoveControl)
void
ComboBox_RemoveControl(TComboBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ComboBox_RemoveControl)
    (((SYSCALL2) (pComboBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ComboBox_Realign)
void
ComboBox_Realign(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Realign)
    (((SYSCALL1) (pComboBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Repaint)
void
ComboBox_Repaint(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Repaint)
    (((SYSCALL1) (pComboBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleBy)
void
ComboBox_ScaleBy(TComboBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(ComboBox_ScaleBy)
    (((SYSCALL3) (pComboBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(ComboBox_ScrollBy)
void
ComboBox_ScrollBy(TComboBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(ComboBox_ScrollBy)
    (((SYSCALL3) (pComboBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(ComboBox_SetBounds)
void
ComboBox_SetBounds(TComboBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(ComboBox_SetBounds)
    (((SYSCALL5) (pComboBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(ComboBox_SetFocus)
void
ComboBox_SetFocus(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_SetFocus)
    (((SYSCALL1) (pComboBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Update)
void
ComboBox_Update(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Update)
    (((SYSCALL1) (pComboBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_BringToFront)
void
ComboBox_BringToFront(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_BringToFront)
    (((SYSCALL1) (pComboBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ClientToScreen)
TPoint
ComboBox_ClientToScreen(TComboBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ComboBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pComboBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_ClientToParent)
TPoint
ComboBox_ClientToParent(TComboBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ComboBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pComboBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_Dragging)
BOOL
ComboBox_Dragging(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Dragging)
    return (BOOL)(((SYSCALL1) (pComboBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_HasParent)
BOOL
ComboBox_HasParent(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_HasParent)
    return (BOOL)(((SYSCALL1) (pComboBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Hide)
void
ComboBox_Hide(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Hide)
    (((SYSCALL1) (pComboBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Perform)
intptr_t
ComboBox_Perform(TComboBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(ComboBox_Perform)
    return (intptr_t)(((SYSCALL4) (pComboBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(ComboBox_Refresh)
void
ComboBox_Refresh(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Refresh)
    (((SYSCALL1) (pComboBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ScreenToClient)
TPoint
ComboBox_ScreenToClient(TComboBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ComboBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pComboBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_ParentToClient)
TPoint
ComboBox_ParentToClient(TComboBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ComboBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pComboBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_SendToBack)
void
ComboBox_SendToBack(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_SendToBack)
    (((SYSCALL1) (pComboBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Show)
void
ComboBox_Show(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_Show)
    (((SYSCALL1) (pComboBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetTextBuf)
int32_t
ComboBox_GetTextBuf(TComboBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(ComboBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pComboBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(ComboBox_GetTextLen)
int32_t
ComboBox_GetTextLen(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pComboBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetTextBuf)
void
ComboBox_SetTextBuf(TComboBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(ComboBox_SetTextBuf)
    (((SYSCALL2) (pComboBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(ComboBox_FindComponent)
TComponent
ComboBox_FindComponent(TComboBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(ComboBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pComboBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(ComboBox_GetNamePath)
char*
ComboBox_GetNamePath(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetNamePath)
    return (char*)(((SYSCALL1) (pComboBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_Assign)
void
ComboBox_Assign(TComboBox AObj, TObject Source) {
    GET_FUNC_ADDR(ComboBox_Assign)
    (((SYSCALL2) (pComboBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(ComboBox_ClassType)
TClass
ComboBox_ClassType(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_ClassType)
    return (TClass)(((SYSCALL1) (pComboBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ClassName)
char*
ComboBox_ClassName(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_ClassName)
    return (char*)(((SYSCALL1) (pComboBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_InstanceSize)
int32_t
ComboBox_InstanceSize(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pComboBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_InheritsFrom)
BOOL
ComboBox_InheritsFrom(TComboBox AObj, TClass AClass) {
    GET_FUNC_ADDR(ComboBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pComboBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(ComboBox_Equals)
BOOL
ComboBox_Equals(TComboBox AObj, TObject Obj) {
    GET_FUNC_ADDR(ComboBox_Equals)
    return (BOOL)(((SYSCALL2) (pComboBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(ComboBox_GetHashCode)
int32_t
ComboBox_GetHashCode(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pComboBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_ToString)
char*
ComboBox_ToString(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_ToString)
    return (char*)(((SYSCALL1) (pComboBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorToNeighbour)
void
ComboBox_AnchorToNeighbour(TComboBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ComboBox_AnchorToNeighbour)
    (((SYSCALL4) (pComboBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorParallel)
void
ComboBox_AnchorParallel(TComboBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ComboBox_AnchorParallel)
    (((SYSCALL4) (pComboBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorHorizontalCenterTo)
void
ComboBox_AnchorHorizontalCenterTo(TComboBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ComboBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pComboBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorVerticalCenterTo)
void
ComboBox_AnchorVerticalCenterTo(TComboBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ComboBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pComboBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorSame)
void
ComboBox_AnchorSame(TComboBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(ComboBox_AnchorSame)
    (((SYSCALL3) (pComboBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorAsAlign)
void
ComboBox_AnchorAsAlign(TComboBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(ComboBox_AnchorAsAlign)
    (((SYSCALL3) (pComboBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ComboBox_AnchorClient)
void
ComboBox_AnchorClient(TComboBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(ComboBox_AnchorClient)
    (((SYSCALL2) (pComboBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleDesignToForm)
int32_t
ComboBox_ScaleDesignToForm(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleFormToDesign)
int32_t
ComboBox_ScaleFormToDesign(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_Scale96ToForm)
int32_t
ComboBox_Scale96ToForm(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pComboBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleFormTo96)
int32_t
ComboBox_ScaleFormTo96(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_Scale96ToFont)
int32_t
ComboBox_Scale96ToFont(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pComboBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleFontTo96)
int32_t
ComboBox_ScaleFontTo96(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleScreenToFont)
int32_t
ComboBox_ScaleScreenToFont(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleFontToScreen)
int32_t
ComboBox_ScaleFontToScreen(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_Scale96ToScreen)
int32_t
ComboBox_Scale96ToScreen(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pComboBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleScreenTo96)
int32_t
ComboBox_ScaleScreenTo96(TComboBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ComboBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pComboBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ComboBox_AutoAdjustLayout)
void
ComboBox_AutoAdjustLayout(TComboBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(ComboBox_AutoAdjustLayout)
    (((SYSCALL6) (pComboBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(ComboBox_FixDesignFontsPPI)
void
ComboBox_FixDesignFontsPPI(TComboBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(ComboBox_FixDesignFontsPPI)
    (((SYSCALL2) (pComboBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(ComboBox_ScaleFontsPPI)
void
ComboBox_ScaleFontsPPI(TComboBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(ComboBox_ScaleFontsPPI)
    (((SYSCALL3) (pComboBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(ComboBox_GetReadOnly)
BOOL
ComboBox_GetReadOnly(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetReadOnly)
    return (BOOL)(((SYSCALL1) (pComboBox_GetReadOnly))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetReadOnly)
void
ComboBox_SetReadOnly(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetReadOnly)
    (((SYSCALL2) (pComboBox_SetReadOnly))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAlign)
TAlign
ComboBox_GetAlign(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pComboBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAlign)
void
ComboBox_SetAlign(TComboBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(ComboBox_SetAlign)
    (((SYSCALL2) (pComboBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAutoComplete)
BOOL
ComboBox_GetAutoComplete(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAutoComplete)
    return (BOOL)(((SYSCALL1) (pComboBox_GetAutoComplete))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAutoComplete)
void
ComboBox_SetAutoComplete(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetAutoComplete)
    (((SYSCALL2) (pComboBox_SetAutoComplete))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAutoDropDown)
BOOL
ComboBox_GetAutoDropDown(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAutoDropDown)
    return (BOOL)(((SYSCALL1) (pComboBox_GetAutoDropDown))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAutoDropDown)
void
ComboBox_SetAutoDropDown(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetAutoDropDown)
    (((SYSCALL2) (pComboBox_SetAutoDropDown))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetStyle)
TComboBoxStyle
ComboBox_GetStyle(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetStyle)
    return (TComboBoxStyle)(((SYSCALL1) (pComboBox_GetStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetStyle)
void
ComboBox_SetStyle(TComboBox AObj, TComboBoxStyle AValue) {
    GET_FUNC_ADDR(ComboBox_SetStyle)
    (((SYSCALL2) (pComboBox_SetStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchors)
TAnchors
ComboBox_GetAnchors(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pComboBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAnchors)
void
ComboBox_SetAnchors(TComboBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(ComboBox_SetAnchors)
    (((SYSCALL2) (pComboBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetBiDiMode)
TBiDiMode
ComboBox_GetBiDiMode(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pComboBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetBiDiMode)
void
ComboBox_SetBiDiMode(TComboBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(ComboBox_SetBiDiMode)
    (((SYSCALL2) (pComboBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetCharCase)
TEditCharCase
ComboBox_GetCharCase(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetCharCase)
    return (TEditCharCase)(((SYSCALL1) (pComboBox_GetCharCase))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetCharCase)
void
ComboBox_SetCharCase(TComboBox AObj, TEditCharCase AValue) {
    GET_FUNC_ADDR(ComboBox_SetCharCase)
    (((SYSCALL2) (pComboBox_SetCharCase))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetColor)
TColor
ComboBox_GetColor(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetColor)
    return (TColor)(((SYSCALL1) (pComboBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetColor)
void
ComboBox_SetColor(TComboBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ComboBox_SetColor)
    (((SYSCALL2) (pComboBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetConstraints)
TSizeConstraints
ComboBox_GetConstraints(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pComboBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetConstraints)
void
ComboBox_SetConstraints(TComboBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(ComboBox_SetConstraints)
    (((SYSCALL2) (pComboBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDoubleBuffered)
BOOL
ComboBox_GetDoubleBuffered(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pComboBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDoubleBuffered)
void
ComboBox_SetDoubleBuffered(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetDoubleBuffered)
    (((SYSCALL2) (pComboBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDragCursor)
TCursor
ComboBox_GetDragCursor(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pComboBox_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDragCursor)
void
ComboBox_SetDragCursor(TComboBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ComboBox_SetDragCursor)
    (((SYSCALL2) (pComboBox_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDragKind)
TDragKind
ComboBox_GetDragKind(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pComboBox_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDragKind)
void
ComboBox_SetDragKind(TComboBox AObj, TDragKind AValue) {
    GET_FUNC_ADDR(ComboBox_SetDragKind)
    (((SYSCALL2) (pComboBox_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDragMode)
TDragMode
ComboBox_GetDragMode(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pComboBox_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDragMode)
void
ComboBox_SetDragMode(TComboBox AObj, TDragMode AValue) {
    GET_FUNC_ADDR(ComboBox_SetDragMode)
    (((SYSCALL2) (pComboBox_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDropDownCount)
int32_t
ComboBox_GetDropDownCount(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDropDownCount)
    return (int32_t)(((SYSCALL1) (pComboBox_GetDropDownCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDropDownCount)
void
ComboBox_SetDropDownCount(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetDropDownCount)
    (((SYSCALL2) (pComboBox_SetDropDownCount))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetEnabled)
BOOL
ComboBox_GetEnabled(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pComboBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetEnabled)
void
ComboBox_SetEnabled(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetEnabled)
    (((SYSCALL2) (pComboBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetFont)
TFont
ComboBox_GetFont(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetFont)
    return (TFont)(((SYSCALL1) (pComboBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetFont)
void
ComboBox_SetFont(TComboBox AObj, TFont AValue) {
    GET_FUNC_ADDR(ComboBox_SetFont)
    (((SYSCALL2) (pComboBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetItemHeight)
int32_t
ComboBox_GetItemHeight(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetItemHeight)
    return (int32_t)(((SYSCALL1) (pComboBox_GetItemHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetItemHeight)
void
ComboBox_SetItemHeight(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetItemHeight)
    (((SYSCALL2) (pComboBox_SetItemHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetItemIndex)
int32_t
ComboBox_GetItemIndex(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetItemIndex)
    return (int32_t)(((SYSCALL1) (pComboBox_GetItemIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetItemIndex)
void
ComboBox_SetItemIndex(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetItemIndex)
    (((SYSCALL2) (pComboBox_SetItemIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetMaxLength)
int32_t
ComboBox_GetMaxLength(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetMaxLength)
    return (int32_t)(((SYSCALL1) (pComboBox_GetMaxLength))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetMaxLength)
void
ComboBox_SetMaxLength(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetMaxLength)
    (((SYSCALL2) (pComboBox_SetMaxLength))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetParentColor)
BOOL
ComboBox_GetParentColor(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pComboBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParentColor)
void
ComboBox_SetParentColor(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetParentColor)
    (((SYSCALL2) (pComboBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetParentDoubleBuffered)
BOOL
ComboBox_GetParentDoubleBuffered(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pComboBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParentDoubleBuffered)
void
ComboBox_SetParentDoubleBuffered(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pComboBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetParentFont)
BOOL
ComboBox_GetParentFont(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pComboBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParentFont)
void
ComboBox_SetParentFont(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetParentFont)
    (((SYSCALL2) (pComboBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetParentShowHint)
BOOL
ComboBox_GetParentShowHint(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pComboBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParentShowHint)
void
ComboBox_SetParentShowHint(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetParentShowHint)
    (((SYSCALL2) (pComboBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetPopupMenu)
TPopupMenu
ComboBox_GetPopupMenu(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pComboBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetPopupMenu)
void
ComboBox_SetPopupMenu(TComboBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(ComboBox_SetPopupMenu)
    (((SYSCALL2) (pComboBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetShowHint)
BOOL
ComboBox_GetShowHint(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pComboBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetShowHint)
void
ComboBox_SetShowHint(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetShowHint)
    (((SYSCALL2) (pComboBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetSorted)
BOOL
ComboBox_GetSorted(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetSorted)
    return (BOOL)(((SYSCALL1) (pComboBox_GetSorted))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetSorted)
void
ComboBox_SetSorted(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetSorted)
    (((SYSCALL2) (pComboBox_SetSorted))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetTabOrder)
TTabOrder
ComboBox_GetTabOrder(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pComboBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetTabOrder)
void
ComboBox_SetTabOrder(TComboBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(ComboBox_SetTabOrder)
    (((SYSCALL2) (pComboBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetTabStop)
BOOL
ComboBox_GetTabStop(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pComboBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetTabStop)
void
ComboBox_SetTabStop(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetTabStop)
    (((SYSCALL2) (pComboBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetText)
char*
ComboBox_GetText(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetText)
    return (char*)(((SYSCALL1) (pComboBox_GetText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetText)
void
ComboBox_SetText(TComboBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ComboBox_SetText)
    (((SYSCALL2) (pComboBox_SetText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetVisible)
BOOL
ComboBox_GetVisible(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pComboBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetVisible)
void
ComboBox_SetVisible(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetVisible)
    (((SYSCALL2) (pComboBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnChange)
void
ComboBox_SetOnChange(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnChange)
    (((SYSCALL2) (pComboBox_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnClick)
void
ComboBox_SetOnClick(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnClick)
    (((SYSCALL2) (pComboBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnCloseUp)
void
ComboBox_SetOnCloseUp(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnCloseUp)
    (((SYSCALL2) (pComboBox_SetOnCloseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnContextPopup)
void
ComboBox_SetOnContextPopup(TComboBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnContextPopup)
    (((SYSCALL2) (pComboBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnDblClick)
void
ComboBox_SetOnDblClick(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnDblClick)
    (((SYSCALL2) (pComboBox_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnDragDrop)
void
ComboBox_SetOnDragDrop(TComboBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnDragDrop)
    (((SYSCALL2) (pComboBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnDragOver)
void
ComboBox_SetOnDragOver(TComboBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnDragOver)
    (((SYSCALL2) (pComboBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnDrawItem)
void
ComboBox_SetOnDrawItem(TComboBox AObj, TDrawItemEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnDrawItem)
    (((SYSCALL2) (pComboBox_SetOnDrawItem))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnDropDown)
void
ComboBox_SetOnDropDown(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnDropDown)
    (((SYSCALL2) (pComboBox_SetOnDropDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnEndDrag)
void
ComboBox_SetOnEndDrag(TComboBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnEndDrag)
    (((SYSCALL2) (pComboBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnEnter)
void
ComboBox_SetOnEnter(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnEnter)
    (((SYSCALL2) (pComboBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnExit)
void
ComboBox_SetOnExit(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnExit)
    (((SYSCALL2) (pComboBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnKeyDown)
void
ComboBox_SetOnKeyDown(TComboBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnKeyDown)
    (((SYSCALL2) (pComboBox_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnKeyPress)
void
ComboBox_SetOnKeyPress(TComboBox AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnKeyPress)
    (((SYSCALL2) (pComboBox_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnKeyUp)
void
ComboBox_SetOnKeyUp(TComboBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnKeyUp)
    (((SYSCALL2) (pComboBox_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnMeasureItem)
void
ComboBox_SetOnMeasureItem(TComboBox AObj, TMeasureItemEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnMeasureItem)
    (((SYSCALL2) (pComboBox_SetOnMeasureItem))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnMouseEnter)
void
ComboBox_SetOnMouseEnter(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnMouseEnter)
    (((SYSCALL2) (pComboBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnMouseLeave)
void
ComboBox_SetOnMouseLeave(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnMouseLeave)
    (((SYSCALL2) (pComboBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_SetOnSelect)
void
ComboBox_SetOnSelect(TComboBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ComboBox_SetOnSelect)
    (((SYSCALL2) (pComboBox_SetOnSelect))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ComboBox_GetItems)
TStrings
ComboBox_GetItems(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetItems)
    return (TStrings)(((SYSCALL1) (pComboBox_GetItems))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetItems)
void
ComboBox_SetItems(TComboBox AObj, TStrings AValue) {
    GET_FUNC_ADDR(ComboBox_SetItems)
    (((SYSCALL2) (pComboBox_SetItems))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetSelText)
char*
ComboBox_GetSelText(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetSelText)
    return (char*)(((SYSCALL1) (pComboBox_GetSelText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetSelText)
void
ComboBox_SetSelText(TComboBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ComboBox_SetSelText)
    (((SYSCALL2) (pComboBox_SetSelText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetCanvas)
TCanvas
ComboBox_GetCanvas(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pComboBox_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetDroppedDown)
BOOL
ComboBox_GetDroppedDown(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDroppedDown)
    return (BOOL)(((SYSCALL1) (pComboBox_GetDroppedDown))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDroppedDown)
void
ComboBox_SetDroppedDown(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetDroppedDown)
    (((SYSCALL2) (pComboBox_SetDroppedDown))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetSelLength)
int32_t
ComboBox_GetSelLength(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetSelLength)
    return (int32_t)(((SYSCALL1) (pComboBox_GetSelLength))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetSelLength)
void
ComboBox_SetSelLength(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetSelLength)
    (((SYSCALL2) (pComboBox_SetSelLength))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetSelStart)
int32_t
ComboBox_GetSelStart(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetSelStart)
    return (int32_t)(((SYSCALL1) (pComboBox_GetSelStart))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetSelStart)
void
ComboBox_SetSelStart(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetSelStart)
    (((SYSCALL2) (pComboBox_SetSelStart))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDockClientCount)
int32_t
ComboBox_GetDockClientCount(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pComboBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetDockSite)
BOOL
ComboBox_GetDockSite(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pComboBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetDockSite)
void
ComboBox_SetDockSite(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetDockSite)
    (((SYSCALL2) (pComboBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetMouseInClient)
BOOL
ComboBox_GetMouseInClient(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pComboBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetVisibleDockClientCount)
int32_t
ComboBox_GetVisibleDockClientCount(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pComboBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetBrush)
TBrush
ComboBox_GetBrush(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pComboBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetControlCount)
int32_t
ComboBox_GetControlCount(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pComboBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetHandle)
HWND
ComboBox_GetHandle(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetHandle)
    return (HWND)(((SYSCALL1) (pComboBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetParentWindow)
HWND
ComboBox_GetParentWindow(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pComboBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParentWindow)
void
ComboBox_SetParentWindow(TComboBox AObj, HWND AValue) {
    GET_FUNC_ADDR(ComboBox_SetParentWindow)
    (((SYSCALL2) (pComboBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetShowing)
BOOL
ComboBox_GetShowing(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pComboBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetUseDockManager)
BOOL
ComboBox_GetUseDockManager(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pComboBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetUseDockManager)
void
ComboBox_SetUseDockManager(TComboBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ComboBox_SetUseDockManager)
    (((SYSCALL2) (pComboBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAction)
TAction
ComboBox_GetAction(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAction)
    return (TAction)(((SYSCALL1) (pComboBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAction)
void
ComboBox_SetAction(TComboBox AObj, TAction AValue) {
    GET_FUNC_ADDR(ComboBox_SetAction)
    (((SYSCALL2) (pComboBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetBoundsRect)
TRect
ComboBox_GetBoundsRect(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pComboBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_SetBoundsRect)
void
ComboBox_SetBoundsRect(TComboBox AObj, TRect AValue) {
    GET_FUNC_ADDR(ComboBox_SetBoundsRect)
    (((SYSCALL2) (pComboBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetClientHeight)
int32_t
ComboBox_GetClientHeight(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pComboBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetClientHeight)
void
ComboBox_SetClientHeight(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetClientHeight)
    (((SYSCALL2) (pComboBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetClientOrigin)
TPoint
ComboBox_GetClientOrigin(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pComboBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_GetClientRect)
TRect
ComboBox_GetClientRect(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pComboBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ComboBox_GetClientWidth)
int32_t
ComboBox_GetClientWidth(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pComboBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetClientWidth)
void
ComboBox_SetClientWidth(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetClientWidth)
    (((SYSCALL2) (pComboBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetControlState)
TControlState
ComboBox_GetControlState(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pComboBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetControlState)
void
ComboBox_SetControlState(TComboBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(ComboBox_SetControlState)
    (((SYSCALL2) (pComboBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetControlStyle)
TControlStyle
ComboBox_GetControlStyle(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pComboBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetControlStyle)
void
ComboBox_SetControlStyle(TComboBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(ComboBox_SetControlStyle)
    (((SYSCALL2) (pComboBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetFloating)
BOOL
ComboBox_GetFloating(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pComboBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetParent)
TWinControl
ComboBox_GetParent(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pComboBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetParent)
void
ComboBox_SetParent(TComboBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(ComboBox_SetParent)
    (((SYSCALL2) (pComboBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetLeft)
int32_t
ComboBox_GetLeft(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pComboBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetLeft)
void
ComboBox_SetLeft(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetLeft)
    (((SYSCALL2) (pComboBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetTop)
int32_t
ComboBox_GetTop(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetTop)
    return (int32_t)(((SYSCALL1) (pComboBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetTop)
void
ComboBox_SetTop(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetTop)
    (((SYSCALL2) (pComboBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetWidth)
int32_t
ComboBox_GetWidth(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pComboBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetWidth)
void
ComboBox_SetWidth(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetWidth)
    (((SYSCALL2) (pComboBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetHeight)
int32_t
ComboBox_GetHeight(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pComboBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetHeight)
void
ComboBox_SetHeight(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetHeight)
    (((SYSCALL2) (pComboBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetCursor)
TCursor
ComboBox_GetCursor(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pComboBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetCursor)
void
ComboBox_SetCursor(TComboBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ComboBox_SetCursor)
    (((SYSCALL2) (pComboBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetHint)
char*
ComboBox_GetHint(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetHint)
    return (char*)(((SYSCALL1) (pComboBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetHint)
void
ComboBox_SetHint(TComboBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ComboBox_SetHint)
    (((SYSCALL2) (pComboBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetComponentCount)
int32_t
ComboBox_GetComponentCount(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pComboBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetComponentIndex)
int32_t
ComboBox_GetComponentIndex(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pComboBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetComponentIndex)
void
ComboBox_SetComponentIndex(TComboBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetComponentIndex)
    (((SYSCALL2) (pComboBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetOwner)
TComponent
ComboBox_GetOwner(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pComboBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_GetName)
char*
ComboBox_GetName(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetName)
    return (char*)(((SYSCALL1) (pComboBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetName)
void
ComboBox_SetName(TComboBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ComboBox_SetName)
    (((SYSCALL2) (pComboBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetTag)
intptr_t
ComboBox_GetTag(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pComboBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetTag)
void
ComboBox_SetTag(TComboBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(ComboBox_SetTag)
    (((SYSCALL2) (pComboBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchorSideLeft)
TAnchorSide
ComboBox_GetAnchorSideLeft(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pComboBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAnchorSideLeft)
void
ComboBox_SetAnchorSideLeft(TComboBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ComboBox_SetAnchorSideLeft)
    (((SYSCALL2) (pComboBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchorSideTop)
TAnchorSide
ComboBox_GetAnchorSideTop(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pComboBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAnchorSideTop)
void
ComboBox_SetAnchorSideTop(TComboBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ComboBox_SetAnchorSideTop)
    (((SYSCALL2) (pComboBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchorSideRight)
TAnchorSide
ComboBox_GetAnchorSideRight(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pComboBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAnchorSideRight)
void
ComboBox_SetAnchorSideRight(TComboBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ComboBox_SetAnchorSideRight)
    (((SYSCALL2) (pComboBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchorSideBottom)
TAnchorSide
ComboBox_GetAnchorSideBottom(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pComboBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetAnchorSideBottom)
void
ComboBox_SetAnchorSideBottom(TComboBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ComboBox_SetAnchorSideBottom)
    (((SYSCALL2) (pComboBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetChildSizing)
TControlChildSizing
ComboBox_GetChildSizing(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pComboBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetChildSizing)
void
ComboBox_SetChildSizing(TComboBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(ComboBox_SetChildSizing)
    (((SYSCALL2) (pComboBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetBorderSpacing)
TControlBorderSpacing
ComboBox_GetBorderSpacing(TComboBox AObj) {
    GET_FUNC_ADDR(ComboBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pComboBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ComboBox_SetBorderSpacing)
void
ComboBox_SetBorderSpacing(TComboBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(ComboBox_SetBorderSpacing)
    (((SYSCALL2) (pComboBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ComboBox_GetDockClients)
TControl
ComboBox_GetDockClients(TComboBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ComboBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pComboBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ComboBox_GetControls)
TControl
ComboBox_GetControls(TComboBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ComboBox_GetControls)
    return (TControl)(((SYSCALL2) (pComboBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ComboBox_GetComponents)
TComponent
ComboBox_GetComponents(TComboBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(ComboBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pComboBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(ComboBox_GetAnchorSide)
TAnchorSide
ComboBox_GetAnchorSide(TComboBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(ComboBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pComboBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(ComboBox_StaticClassType)
TClass
ComboBox_StaticClassType() {
    GET_FUNC_ADDR(ComboBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pComboBox_StaticClassType))());
}

// -------------------TPanel-------------------

DEFINE_FUNC_PTR(Panel_Create)
TPanel
Panel_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Panel_Create)
    return (TPanel)(((SYSCALL1) (pPanel_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Panel_Free)
void
Panel_Free(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Free)
    (((SYSCALL1) (pPanel_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_CanFocus)
BOOL
Panel_CanFocus(TPanel AObj) {
    GET_FUNC_ADDR(Panel_CanFocus)
    return (BOOL)(((SYSCALL1) (pPanel_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ContainsControl)
BOOL
Panel_ContainsControl(TPanel AObj, TControl Control) {
    GET_FUNC_ADDR(Panel_ContainsControl)
    return (BOOL)(((SYSCALL2) (pPanel_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(Panel_ControlAtPos)
TControl
Panel_ControlAtPos(TPanel AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(Panel_ControlAtPos)
    return (TControl)(((SYSCALL4) (pPanel_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(Panel_DisableAlign)
void
Panel_DisableAlign(TPanel AObj) {
    GET_FUNC_ADDR(Panel_DisableAlign)
    (((SYSCALL1) (pPanel_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_EnableAlign)
void
Panel_EnableAlign(TPanel AObj) {
    GET_FUNC_ADDR(Panel_EnableAlign)
    (((SYSCALL1) (pPanel_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_FindChildControl)
TControl
Panel_FindChildControl(TPanel AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(Panel_FindChildControl)
    return (TControl)(((SYSCALL2) (pPanel_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(Panel_FlipChildren)
void
Panel_FlipChildren(TPanel AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(Panel_FlipChildren)
    (((SYSCALL2) (pPanel_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(Panel_Focused)
BOOL
Panel_Focused(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Focused)
    return (BOOL)(((SYSCALL1) (pPanel_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_HandleAllocated)
BOOL
Panel_HandleAllocated(TPanel AObj) {
    GET_FUNC_ADDR(Panel_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pPanel_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_InsertControl)
void
Panel_InsertControl(TPanel AObj, TControl AControl) {
    GET_FUNC_ADDR(Panel_InsertControl)
    (((SYSCALL2) (pPanel_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(Panel_Invalidate)
void
Panel_Invalidate(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Invalidate)
    (((SYSCALL1) (pPanel_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_PaintTo)
void
Panel_PaintTo(TPanel AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(Panel_PaintTo)
    (((SYSCALL4) (pPanel_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(Panel_RemoveControl)
void
Panel_RemoveControl(TPanel AObj, TControl AControl) {
    GET_FUNC_ADDR(Panel_RemoveControl)
    (((SYSCALL2) (pPanel_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(Panel_Realign)
void
Panel_Realign(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Realign)
    (((SYSCALL1) (pPanel_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Repaint)
void
Panel_Repaint(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Repaint)
    (((SYSCALL1) (pPanel_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ScaleBy)
void
Panel_ScaleBy(TPanel AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(Panel_ScaleBy)
    (((SYSCALL3) (pPanel_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(Panel_ScrollBy)
void
Panel_ScrollBy(TPanel AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(Panel_ScrollBy)
    (((SYSCALL3) (pPanel_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(Panel_SetBounds)
void
Panel_SetBounds(TPanel AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(Panel_SetBounds)
    (((SYSCALL5) (pPanel_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(Panel_SetFocus)
void
Panel_SetFocus(TPanel AObj) {
    GET_FUNC_ADDR(Panel_SetFocus)
    (((SYSCALL1) (pPanel_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Update)
void
Panel_Update(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Update)
    (((SYSCALL1) (pPanel_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_BringToFront)
void
Panel_BringToFront(TPanel AObj) {
    GET_FUNC_ADDR(Panel_BringToFront)
    (((SYSCALL1) (pPanel_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ClientToScreen)
TPoint
Panel_ClientToScreen(TPanel AObj, TPoint Point) {
    GET_FUNC_ADDR(Panel_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pPanel_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_ClientToParent)
TPoint
Panel_ClientToParent(TPanel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Panel_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pPanel_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_Dragging)
BOOL
Panel_Dragging(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Dragging)
    return (BOOL)(((SYSCALL1) (pPanel_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_HasParent)
BOOL
Panel_HasParent(TPanel AObj) {
    GET_FUNC_ADDR(Panel_HasParent)
    return (BOOL)(((SYSCALL1) (pPanel_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Hide)
void
Panel_Hide(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Hide)
    (((SYSCALL1) (pPanel_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Perform)
intptr_t
Panel_Perform(TPanel AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(Panel_Perform)
    return (intptr_t)(((SYSCALL4) (pPanel_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(Panel_Refresh)
void
Panel_Refresh(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Refresh)
    (((SYSCALL1) (pPanel_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ScreenToClient)
TPoint
Panel_ScreenToClient(TPanel AObj, TPoint Point) {
    GET_FUNC_ADDR(Panel_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pPanel_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_ParentToClient)
TPoint
Panel_ParentToClient(TPanel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Panel_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pPanel_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_SendToBack)
void
Panel_SendToBack(TPanel AObj) {
    GET_FUNC_ADDR(Panel_SendToBack)
    (((SYSCALL1) (pPanel_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Show)
void
Panel_Show(TPanel AObj) {
    GET_FUNC_ADDR(Panel_Show)
    (((SYSCALL1) (pPanel_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetTextBuf)
int32_t
Panel_GetTextBuf(TPanel AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(Panel_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pPanel_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(Panel_GetTextLen)
int32_t
Panel_GetTextLen(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetTextLen)
    return (int32_t)(((SYSCALL1) (pPanel_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetTextBuf)
void
Panel_SetTextBuf(TPanel AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(Panel_SetTextBuf)
    (((SYSCALL2) (pPanel_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(Panel_FindComponent)
TComponent
Panel_FindComponent(TPanel AObj, CChar char* AName) {
    GET_FUNC_ADDR(Panel_FindComponent)
    return (TComponent)(((SYSCALL2) (pPanel_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Panel_GetNamePath)
char*
Panel_GetNamePath(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetNamePath)
    return (char*)(((SYSCALL1) (pPanel_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_Assign)
void
Panel_Assign(TPanel AObj, TObject Source) {
    GET_FUNC_ADDR(Panel_Assign)
    (((SYSCALL2) (pPanel_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Panel_ClassType)
TClass
Panel_ClassType(TPanel AObj) {
    GET_FUNC_ADDR(Panel_ClassType)
    return (TClass)(((SYSCALL1) (pPanel_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ClassName)
char*
Panel_ClassName(TPanel AObj) {
    GET_FUNC_ADDR(Panel_ClassName)
    return (char*)(((SYSCALL1) (pPanel_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_InstanceSize)
int32_t
Panel_InstanceSize(TPanel AObj) {
    GET_FUNC_ADDR(Panel_InstanceSize)
    return (int32_t)(((SYSCALL1) (pPanel_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_InheritsFrom)
BOOL
Panel_InheritsFrom(TPanel AObj, TClass AClass) {
    GET_FUNC_ADDR(Panel_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pPanel_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Panel_Equals)
BOOL
Panel_Equals(TPanel AObj, TObject Obj) {
    GET_FUNC_ADDR(Panel_Equals)
    return (BOOL)(((SYSCALL2) (pPanel_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Panel_GetHashCode)
int32_t
Panel_GetHashCode(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetHashCode)
    return (int32_t)(((SYSCALL1) (pPanel_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_ToString)
char*
Panel_ToString(TPanel AObj) {
    GET_FUNC_ADDR(Panel_ToString)
    return (char*)(((SYSCALL1) (pPanel_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_AnchorToNeighbour)
void
Panel_AnchorToNeighbour(TPanel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Panel_AnchorToNeighbour)
    (((SYSCALL4) (pPanel_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Panel_AnchorParallel)
void
Panel_AnchorParallel(TPanel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Panel_AnchorParallel)
    (((SYSCALL4) (pPanel_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Panel_AnchorHorizontalCenterTo)
void
Panel_AnchorHorizontalCenterTo(TPanel AObj, TControl ASibling) {
    GET_FUNC_ADDR(Panel_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pPanel_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Panel_AnchorVerticalCenterTo)
void
Panel_AnchorVerticalCenterTo(TPanel AObj, TControl ASibling) {
    GET_FUNC_ADDR(Panel_AnchorVerticalCenterTo)
    (((SYSCALL2) (pPanel_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Panel_AnchorSame)
void
Panel_AnchorSame(TPanel AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(Panel_AnchorSame)
    (((SYSCALL3) (pPanel_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Panel_AnchorAsAlign)
void
Panel_AnchorAsAlign(TPanel AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(Panel_AnchorAsAlign)
    (((SYSCALL3) (pPanel_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Panel_AnchorClient)
void
Panel_AnchorClient(TPanel AObj, int32_t ASpace) {
    GET_FUNC_ADDR(Panel_AnchorClient)
    (((SYSCALL2) (pPanel_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Panel_ScaleDesignToForm)
int32_t
Panel_ScaleDesignToForm(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleFormToDesign)
int32_t
Panel_ScaleFormToDesign(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_Scale96ToForm)
int32_t
Panel_Scale96ToForm(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pPanel_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleFormTo96)
int32_t
Panel_ScaleFormTo96(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_Scale96ToFont)
int32_t
Panel_Scale96ToFont(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pPanel_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleFontTo96)
int32_t
Panel_ScaleFontTo96(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleScreenToFont)
int32_t
Panel_ScaleScreenToFont(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleFontToScreen)
int32_t
Panel_ScaleFontToScreen(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_Scale96ToScreen)
int32_t
Panel_Scale96ToScreen(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pPanel_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_ScaleScreenTo96)
int32_t
Panel_ScaleScreenTo96(TPanel AObj, int32_t ASize) {
    GET_FUNC_ADDR(Panel_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pPanel_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Panel_AutoAdjustLayout)
void
Panel_AutoAdjustLayout(TPanel AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(Panel_AutoAdjustLayout)
    (((SYSCALL6) (pPanel_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(Panel_FixDesignFontsPPI)
void
Panel_FixDesignFontsPPI(TPanel AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(Panel_FixDesignFontsPPI)
    (((SYSCALL2) (pPanel_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(Panel_ScaleFontsPPI)
void
Panel_ScaleFontsPPI(TPanel AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(Panel_ScaleFontsPPI)
    (((SYSCALL3) (pPanel_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(Panel_GetCanvas)
TCanvas
Panel_GetCanvas(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pPanel_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetCanvas)
void
Panel_SetCanvas(TPanel AObj, TCanvas AValue) {
    GET_FUNC_ADDR(Panel_SetCanvas)
    (((SYSCALL2) (pPanel_SetCanvas))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_SetOnPaint)
void
Panel_SetOnPaint(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnPaint)
    (((SYSCALL2) (pPanel_SetOnPaint))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_GetAlign)
TAlign
Panel_GetAlign(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAlign)
    return (TAlign)(((SYSCALL1) (pPanel_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAlign)
void
Panel_SetAlign(TPanel AObj, TAlign AValue) {
    GET_FUNC_ADDR(Panel_SetAlign)
    (((SYSCALL2) (pPanel_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAlignment)
TAlignment
Panel_GetAlignment(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAlignment)
    return (TAlignment)(((SYSCALL1) (pPanel_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAlignment)
void
Panel_SetAlignment(TPanel AObj, TAlignment AValue) {
    GET_FUNC_ADDR(Panel_SetAlignment)
    (((SYSCALL2) (pPanel_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAnchors)
TAnchors
Panel_GetAnchors(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pPanel_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAnchors)
void
Panel_SetAnchors(TPanel AObj, TAnchors AValue) {
    GET_FUNC_ADDR(Panel_SetAnchors)
    (((SYSCALL2) (pPanel_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAutoSize)
BOOL
Panel_GetAutoSize(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAutoSize)
    return (BOOL)(((SYSCALL1) (pPanel_GetAutoSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAutoSize)
void
Panel_SetAutoSize(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetAutoSize)
    (((SYSCALL2) (pPanel_SetAutoSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBevelInner)
TBevelCut
Panel_GetBevelInner(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBevelInner)
    return (TBevelCut)(((SYSCALL1) (pPanel_GetBevelInner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBevelInner)
void
Panel_SetBevelInner(TPanel AObj, TBevelCut AValue) {
    GET_FUNC_ADDR(Panel_SetBevelInner)
    (((SYSCALL2) (pPanel_SetBevelInner))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBevelOuter)
TBevelCut
Panel_GetBevelOuter(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBevelOuter)
    return (TBevelCut)(((SYSCALL1) (pPanel_GetBevelOuter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBevelOuter)
void
Panel_SetBevelOuter(TPanel AObj, TBevelCut AValue) {
    GET_FUNC_ADDR(Panel_SetBevelOuter)
    (((SYSCALL2) (pPanel_SetBevelOuter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBiDiMode)
TBiDiMode
Panel_GetBiDiMode(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pPanel_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBiDiMode)
void
Panel_SetBiDiMode(TPanel AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(Panel_SetBiDiMode)
    (((SYSCALL2) (pPanel_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBorderWidth)
int32_t
Panel_GetBorderWidth(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBorderWidth)
    return (int32_t)(((SYSCALL1) (pPanel_GetBorderWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBorderWidth)
void
Panel_SetBorderWidth(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetBorderWidth)
    (((SYSCALL2) (pPanel_SetBorderWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBorderStyle)
TBorderStyle
Panel_GetBorderStyle(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBorderStyle)
    return (TBorderStyle)(((SYSCALL1) (pPanel_GetBorderStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBorderStyle)
void
Panel_SetBorderStyle(TPanel AObj, TBorderStyle AValue) {
    GET_FUNC_ADDR(Panel_SetBorderStyle)
    (((SYSCALL2) (pPanel_SetBorderStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetCaption)
char*
Panel_GetCaption(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetCaption)
    return (char*)(((SYSCALL1) (pPanel_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetCaption)
void
Panel_SetCaption(TPanel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Panel_SetCaption)
    (((SYSCALL2) (pPanel_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetColor)
TColor
Panel_GetColor(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetColor)
    return (TColor)(((SYSCALL1) (pPanel_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetColor)
void
Panel_SetColor(TPanel AObj, TColor AValue) {
    GET_FUNC_ADDR(Panel_SetColor)
    (((SYSCALL2) (pPanel_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetConstraints)
TSizeConstraints
Panel_GetConstraints(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pPanel_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetConstraints)
void
Panel_SetConstraints(TPanel AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(Panel_SetConstraints)
    (((SYSCALL2) (pPanel_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetUseDockManager)
BOOL
Panel_GetUseDockManager(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pPanel_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetUseDockManager)
void
Panel_SetUseDockManager(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetUseDockManager)
    (((SYSCALL2) (pPanel_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDockSite)
BOOL
Panel_GetDockSite(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDockSite)
    return (BOOL)(((SYSCALL1) (pPanel_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetDockSite)
void
Panel_SetDockSite(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetDockSite)
    (((SYSCALL2) (pPanel_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDoubleBuffered)
BOOL
Panel_GetDoubleBuffered(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pPanel_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetDoubleBuffered)
void
Panel_SetDoubleBuffered(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetDoubleBuffered)
    (((SYSCALL2) (pPanel_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDragCursor)
TCursor
Panel_GetDragCursor(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pPanel_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetDragCursor)
void
Panel_SetDragCursor(TPanel AObj, TCursor AValue) {
    GET_FUNC_ADDR(Panel_SetDragCursor)
    (((SYSCALL2) (pPanel_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDragKind)
TDragKind
Panel_GetDragKind(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pPanel_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetDragKind)
void
Panel_SetDragKind(TPanel AObj, TDragKind AValue) {
    GET_FUNC_ADDR(Panel_SetDragKind)
    (((SYSCALL2) (pPanel_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDragMode)
TDragMode
Panel_GetDragMode(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pPanel_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetDragMode)
void
Panel_SetDragMode(TPanel AObj, TDragMode AValue) {
    GET_FUNC_ADDR(Panel_SetDragMode)
    (((SYSCALL2) (pPanel_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetEnabled)
BOOL
Panel_GetEnabled(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetEnabled)
    return (BOOL)(((SYSCALL1) (pPanel_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetEnabled)
void
Panel_SetEnabled(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetEnabled)
    (((SYSCALL2) (pPanel_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetFullRepaint)
BOOL
Panel_GetFullRepaint(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetFullRepaint)
    return (BOOL)(((SYSCALL1) (pPanel_GetFullRepaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetFullRepaint)
void
Panel_SetFullRepaint(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetFullRepaint)
    (((SYSCALL2) (pPanel_SetFullRepaint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetFont)
TFont
Panel_GetFont(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetFont)
    return (TFont)(((SYSCALL1) (pPanel_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetFont)
void
Panel_SetFont(TPanel AObj, TFont AValue) {
    GET_FUNC_ADDR(Panel_SetFont)
    (((SYSCALL2) (pPanel_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetParentBackground)
BOOL
Panel_GetParentBackground(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentBackground)
    return (BOOL)(((SYSCALL1) (pPanel_GetParentBackground))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentBackground)
void
Panel_SetParentBackground(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetParentBackground)
    (((SYSCALL2) (pPanel_SetParentBackground))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetParentColor)
BOOL
Panel_GetParentColor(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentColor)
    return (BOOL)(((SYSCALL1) (pPanel_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentColor)
void
Panel_SetParentColor(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetParentColor)
    (((SYSCALL2) (pPanel_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetParentDoubleBuffered)
BOOL
Panel_GetParentDoubleBuffered(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pPanel_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentDoubleBuffered)
void
Panel_SetParentDoubleBuffered(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetParentDoubleBuffered)
    (((SYSCALL2) (pPanel_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetParentFont)
BOOL
Panel_GetParentFont(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentFont)
    return (BOOL)(((SYSCALL1) (pPanel_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentFont)
void
Panel_SetParentFont(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetParentFont)
    (((SYSCALL2) (pPanel_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetParentShowHint)
BOOL
Panel_GetParentShowHint(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pPanel_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentShowHint)
void
Panel_SetParentShowHint(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetParentShowHint)
    (((SYSCALL2) (pPanel_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetPopupMenu)
TPopupMenu
Panel_GetPopupMenu(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pPanel_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetPopupMenu)
void
Panel_SetPopupMenu(TPanel AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(Panel_SetPopupMenu)
    (((SYSCALL2) (pPanel_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetShowHint)
BOOL
Panel_GetShowHint(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetShowHint)
    return (BOOL)(((SYSCALL1) (pPanel_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetShowHint)
void
Panel_SetShowHint(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetShowHint)
    (((SYSCALL2) (pPanel_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetTabOrder)
TTabOrder
Panel_GetTabOrder(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pPanel_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetTabOrder)
void
Panel_SetTabOrder(TPanel AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(Panel_SetTabOrder)
    (((SYSCALL2) (pPanel_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetTabStop)
BOOL
Panel_GetTabStop(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetTabStop)
    return (BOOL)(((SYSCALL1) (pPanel_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetTabStop)
void
Panel_SetTabStop(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetTabStop)
    (((SYSCALL2) (pPanel_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetVisible)
BOOL
Panel_GetVisible(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetVisible)
    return (BOOL)(((SYSCALL1) (pPanel_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetVisible)
void
Panel_SetVisible(TPanel AObj, BOOL AValue) {
    GET_FUNC_ADDR(Panel_SetVisible)
    (((SYSCALL2) (pPanel_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_SetOnAlignPosition)
void
Panel_SetOnAlignPosition(TPanel AObj, TAlignPositionEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnAlignPosition)
    (((SYSCALL2) (pPanel_SetOnAlignPosition))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnClick)
void
Panel_SetOnClick(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnClick)
    (((SYSCALL2) (pPanel_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnContextPopup)
void
Panel_SetOnContextPopup(TPanel AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnContextPopup)
    (((SYSCALL2) (pPanel_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnDockDrop)
void
Panel_SetOnDockDrop(TPanel AObj, TDockDropEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnDockDrop)
    (((SYSCALL2) (pPanel_SetOnDockDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnDblClick)
void
Panel_SetOnDblClick(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnDblClick)
    (((SYSCALL2) (pPanel_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnDragDrop)
void
Panel_SetOnDragDrop(TPanel AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnDragDrop)
    (((SYSCALL2) (pPanel_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnDragOver)
void
Panel_SetOnDragOver(TPanel AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnDragOver)
    (((SYSCALL2) (pPanel_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnEndDock)
void
Panel_SetOnEndDock(TPanel AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnEndDock)
    (((SYSCALL2) (pPanel_SetOnEndDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnEndDrag)
void
Panel_SetOnEndDrag(TPanel AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnEndDrag)
    (((SYSCALL2) (pPanel_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnEnter)
void
Panel_SetOnEnter(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnEnter)
    (((SYSCALL2) (pPanel_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnExit)
void
Panel_SetOnExit(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnExit)
    (((SYSCALL2) (pPanel_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnGetSiteInfo)
void
Panel_SetOnGetSiteInfo(TPanel AObj, TGetSiteInfoEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnGetSiteInfo)
    (((SYSCALL2) (pPanel_SetOnGetSiteInfo))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnMouseDown)
void
Panel_SetOnMouseDown(TPanel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnMouseDown)
    (((SYSCALL2) (pPanel_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnMouseEnter)
void
Panel_SetOnMouseEnter(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnMouseEnter)
    (((SYSCALL2) (pPanel_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnMouseLeave)
void
Panel_SetOnMouseLeave(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnMouseLeave)
    (((SYSCALL2) (pPanel_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnMouseMove)
void
Panel_SetOnMouseMove(TPanel AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnMouseMove)
    (((SYSCALL2) (pPanel_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnMouseUp)
void
Panel_SetOnMouseUp(TPanel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnMouseUp)
    (((SYSCALL2) (pPanel_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnResize)
void
Panel_SetOnResize(TPanel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnResize)
    (((SYSCALL2) (pPanel_SetOnResize))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnStartDock)
void
Panel_SetOnStartDock(TPanel AObj, TStartDockEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnStartDock)
    (((SYSCALL2) (pPanel_SetOnStartDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_SetOnUnDock)
void
Panel_SetOnUnDock(TPanel AObj, TUnDockEvent AEventData) {
    GET_FUNC_ADDR(Panel_SetOnUnDock)
    (((SYSCALL2) (pPanel_SetOnUnDock))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Panel_GetDockClientCount)
int32_t
Panel_GetDockClientCount(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pPanel_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetMouseInClient)
BOOL
Panel_GetMouseInClient(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pPanel_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetVisibleDockClientCount)
int32_t
Panel_GetVisibleDockClientCount(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pPanel_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetBrush)
TBrush
Panel_GetBrush(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBrush)
    return (TBrush)(((SYSCALL1) (pPanel_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetControlCount)
int32_t
Panel_GetControlCount(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetControlCount)
    return (int32_t)(((SYSCALL1) (pPanel_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetHandle)
HWND
Panel_GetHandle(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetHandle)
    return (HWND)(((SYSCALL1) (pPanel_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetParentWindow)
HWND
Panel_GetParentWindow(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParentWindow)
    return (HWND)(((SYSCALL1) (pPanel_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParentWindow)
void
Panel_SetParentWindow(TPanel AObj, HWND AValue) {
    GET_FUNC_ADDR(Panel_SetParentWindow)
    (((SYSCALL2) (pPanel_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetShowing)
BOOL
Panel_GetShowing(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetShowing)
    return (BOOL)(((SYSCALL1) (pPanel_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetAction)
TAction
Panel_GetAction(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAction)
    return (TAction)(((SYSCALL1) (pPanel_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAction)
void
Panel_SetAction(TPanel AObj, TAction AValue) {
    GET_FUNC_ADDR(Panel_SetAction)
    (((SYSCALL2) (pPanel_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBoundsRect)
TRect
Panel_GetBoundsRect(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pPanel_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_SetBoundsRect)
void
Panel_SetBoundsRect(TPanel AObj, TRect AValue) {
    GET_FUNC_ADDR(Panel_SetBoundsRect)
    (((SYSCALL2) (pPanel_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(Panel_GetClientHeight)
int32_t
Panel_GetClientHeight(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pPanel_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetClientHeight)
void
Panel_SetClientHeight(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetClientHeight)
    (((SYSCALL2) (pPanel_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetClientOrigin)
TPoint
Panel_GetClientOrigin(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pPanel_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_GetClientRect)
TRect
Panel_GetClientRect(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetClientRect)
    TRect result;
    (((SYSCALL2) (pPanel_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Panel_GetClientWidth)
int32_t
Panel_GetClientWidth(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pPanel_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetClientWidth)
void
Panel_SetClientWidth(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetClientWidth)
    (((SYSCALL2) (pPanel_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetControlState)
TControlState
Panel_GetControlState(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetControlState)
    return (TControlState)(((SYSCALL1) (pPanel_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetControlState)
void
Panel_SetControlState(TPanel AObj, TControlState AValue) {
    GET_FUNC_ADDR(Panel_SetControlState)
    (((SYSCALL2) (pPanel_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetControlStyle)
TControlStyle
Panel_GetControlStyle(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pPanel_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetControlStyle)
void
Panel_SetControlStyle(TPanel AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(Panel_SetControlStyle)
    (((SYSCALL2) (pPanel_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetFloating)
BOOL
Panel_GetFloating(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetFloating)
    return (BOOL)(((SYSCALL1) (pPanel_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetParent)
TWinControl
Panel_GetParent(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetParent)
    return (TWinControl)(((SYSCALL1) (pPanel_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetParent)
void
Panel_SetParent(TPanel AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Panel_SetParent)
    (((SYSCALL2) (pPanel_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetLeft)
int32_t
Panel_GetLeft(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetLeft)
    return (int32_t)(((SYSCALL1) (pPanel_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetLeft)
void
Panel_SetLeft(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetLeft)
    (((SYSCALL2) (pPanel_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetTop)
int32_t
Panel_GetTop(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetTop)
    return (int32_t)(((SYSCALL1) (pPanel_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetTop)
void
Panel_SetTop(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetTop)
    (((SYSCALL2) (pPanel_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetWidth)
int32_t
Panel_GetWidth(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetWidth)
    return (int32_t)(((SYSCALL1) (pPanel_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetWidth)
void
Panel_SetWidth(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetWidth)
    (((SYSCALL2) (pPanel_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetHeight)
int32_t
Panel_GetHeight(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetHeight)
    return (int32_t)(((SYSCALL1) (pPanel_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetHeight)
void
Panel_SetHeight(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetHeight)
    (((SYSCALL2) (pPanel_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetCursor)
TCursor
Panel_GetCursor(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetCursor)
    return (TCursor)(((SYSCALL1) (pPanel_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetCursor)
void
Panel_SetCursor(TPanel AObj, TCursor AValue) {
    GET_FUNC_ADDR(Panel_SetCursor)
    (((SYSCALL2) (pPanel_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetHint)
char*
Panel_GetHint(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetHint)
    return (char*)(((SYSCALL1) (pPanel_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetHint)
void
Panel_SetHint(TPanel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Panel_SetHint)
    (((SYSCALL2) (pPanel_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetComponentCount)
int32_t
Panel_GetComponentCount(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pPanel_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetComponentIndex)
int32_t
Panel_GetComponentIndex(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pPanel_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetComponentIndex)
void
Panel_SetComponentIndex(TPanel AObj, int32_t AValue) {
    GET_FUNC_ADDR(Panel_SetComponentIndex)
    (((SYSCALL2) (pPanel_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetOwner)
TComponent
Panel_GetOwner(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetOwner)
    return (TComponent)(((SYSCALL1) (pPanel_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_GetName)
char*
Panel_GetName(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetName)
    return (char*)(((SYSCALL1) (pPanel_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetName)
void
Panel_SetName(TPanel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Panel_SetName)
    (((SYSCALL2) (pPanel_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetTag)
intptr_t
Panel_GetTag(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetTag)
    return (intptr_t)(((SYSCALL1) (pPanel_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetTag)
void
Panel_SetTag(TPanel AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Panel_SetTag)
    (((SYSCALL2) (pPanel_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAnchorSideLeft)
TAnchorSide
Panel_GetAnchorSideLeft(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pPanel_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAnchorSideLeft)
void
Panel_SetAnchorSideLeft(TPanel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Panel_SetAnchorSideLeft)
    (((SYSCALL2) (pPanel_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAnchorSideTop)
TAnchorSide
Panel_GetAnchorSideTop(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pPanel_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAnchorSideTop)
void
Panel_SetAnchorSideTop(TPanel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Panel_SetAnchorSideTop)
    (((SYSCALL2) (pPanel_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAnchorSideRight)
TAnchorSide
Panel_GetAnchorSideRight(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pPanel_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAnchorSideRight)
void
Panel_SetAnchorSideRight(TPanel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Panel_SetAnchorSideRight)
    (((SYSCALL2) (pPanel_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetAnchorSideBottom)
TAnchorSide
Panel_GetAnchorSideBottom(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pPanel_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetAnchorSideBottom)
void
Panel_SetAnchorSideBottom(TPanel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Panel_SetAnchorSideBottom)
    (((SYSCALL2) (pPanel_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetChildSizing)
TControlChildSizing
Panel_GetChildSizing(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pPanel_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetChildSizing)
void
Panel_SetChildSizing(TPanel AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(Panel_SetChildSizing)
    (((SYSCALL2) (pPanel_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetBorderSpacing)
TControlBorderSpacing
Panel_GetBorderSpacing(TPanel AObj) {
    GET_FUNC_ADDR(Panel_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pPanel_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Panel_SetBorderSpacing)
void
Panel_SetBorderSpacing(TPanel AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(Panel_SetBorderSpacing)
    (((SYSCALL2) (pPanel_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Panel_GetDockClients)
TControl
Panel_GetDockClients(TPanel AObj, int32_t Index) {
    GET_FUNC_ADDR(Panel_GetDockClients)
    return (TControl)(((SYSCALL2) (pPanel_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Panel_GetControls)
TControl
Panel_GetControls(TPanel AObj, int32_t Index) {
    GET_FUNC_ADDR(Panel_GetControls)
    return (TControl)(((SYSCALL2) (pPanel_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(Panel_GetComponents)
TComponent
Panel_GetComponents(TPanel AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Panel_GetComponents)
    return (TComponent)(((SYSCALL2) (pPanel_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Panel_GetAnchorSide)
TAnchorSide
Panel_GetAnchorSide(TPanel AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(Panel_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pPanel_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(Panel_StaticClassType)
TClass
Panel_StaticClassType() {
    GET_FUNC_ADDR(Panel_StaticClassType)
    return (TClass)(((SYSCALL0) (pPanel_StaticClassType))());
}

// -------------------TImage-------------------

DEFINE_FUNC_PTR(Image_Create)
TImage
Image_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Image_Create)
    return (TImage)(((SYSCALL1) (pImage_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Image_Free)
void
Image_Free(TImage AObj) {
    GET_FUNC_ADDR(Image_Free)
    (((SYSCALL1) (pImage_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_BringToFront)
void
Image_BringToFront(TImage AObj) {
    GET_FUNC_ADDR(Image_BringToFront)
    (((SYSCALL1) (pImage_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_ClientToScreen)
TPoint
Image_ClientToScreen(TImage AObj, TPoint Point) {
    GET_FUNC_ADDR(Image_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pImage_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_ClientToParent)
TPoint
Image_ClientToParent(TImage AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Image_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pImage_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_Dragging)
BOOL
Image_Dragging(TImage AObj) {
    GET_FUNC_ADDR(Image_Dragging)
    return (BOOL)(((SYSCALL1) (pImage_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_HasParent)
BOOL
Image_HasParent(TImage AObj) {
    GET_FUNC_ADDR(Image_HasParent)
    return (BOOL)(((SYSCALL1) (pImage_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Hide)
void
Image_Hide(TImage AObj) {
    GET_FUNC_ADDR(Image_Hide)
    (((SYSCALL1) (pImage_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Invalidate)
void
Image_Invalidate(TImage AObj) {
    GET_FUNC_ADDR(Image_Invalidate)
    (((SYSCALL1) (pImage_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Perform)
intptr_t
Image_Perform(TImage AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(Image_Perform)
    return (intptr_t)(((SYSCALL4) (pImage_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(Image_Refresh)
void
Image_Refresh(TImage AObj) {
    GET_FUNC_ADDR(Image_Refresh)
    (((SYSCALL1) (pImage_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Repaint)
void
Image_Repaint(TImage AObj) {
    GET_FUNC_ADDR(Image_Repaint)
    (((SYSCALL1) (pImage_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_ScreenToClient)
TPoint
Image_ScreenToClient(TImage AObj, TPoint Point) {
    GET_FUNC_ADDR(Image_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pImage_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_ParentToClient)
TPoint
Image_ParentToClient(TImage AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Image_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pImage_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_SendToBack)
void
Image_SendToBack(TImage AObj) {
    GET_FUNC_ADDR(Image_SendToBack)
    (((SYSCALL1) (pImage_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetBounds)
void
Image_SetBounds(TImage AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(Image_SetBounds)
    (((SYSCALL5) (pImage_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(Image_Show)
void
Image_Show(TImage AObj) {
    GET_FUNC_ADDR(Image_Show)
    (((SYSCALL1) (pImage_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Update)
void
Image_Update(TImage AObj) {
    GET_FUNC_ADDR(Image_Update)
    (((SYSCALL1) (pImage_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_GetTextBuf)
int32_t
Image_GetTextBuf(TImage AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(Image_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pImage_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(Image_GetTextLen)
int32_t
Image_GetTextLen(TImage AObj) {
    GET_FUNC_ADDR(Image_GetTextLen)
    return (int32_t)(((SYSCALL1) (pImage_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetTextBuf)
void
Image_SetTextBuf(TImage AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(Image_SetTextBuf)
    (((SYSCALL2) (pImage_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(Image_FindComponent)
TComponent
Image_FindComponent(TImage AObj, CChar char* AName) {
    GET_FUNC_ADDR(Image_FindComponent)
    return (TComponent)(((SYSCALL2) (pImage_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Image_GetNamePath)
char*
Image_GetNamePath(TImage AObj) {
    GET_FUNC_ADDR(Image_GetNamePath)
    return (char*)(((SYSCALL1) (pImage_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_Assign)
void
Image_Assign(TImage AObj, TObject Source) {
    GET_FUNC_ADDR(Image_Assign)
    (((SYSCALL2) (pImage_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Image_ClassType)
TClass
Image_ClassType(TImage AObj) {
    GET_FUNC_ADDR(Image_ClassType)
    return (TClass)(((SYSCALL1) (pImage_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_ClassName)
char*
Image_ClassName(TImage AObj) {
    GET_FUNC_ADDR(Image_ClassName)
    return (char*)(((SYSCALL1) (pImage_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_InstanceSize)
int32_t
Image_InstanceSize(TImage AObj) {
    GET_FUNC_ADDR(Image_InstanceSize)
    return (int32_t)(((SYSCALL1) (pImage_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_InheritsFrom)
BOOL
Image_InheritsFrom(TImage AObj, TClass AClass) {
    GET_FUNC_ADDR(Image_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pImage_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Image_Equals)
BOOL
Image_Equals(TImage AObj, TObject Obj) {
    GET_FUNC_ADDR(Image_Equals)
    return (BOOL)(((SYSCALL2) (pImage_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Image_GetHashCode)
int32_t
Image_GetHashCode(TImage AObj) {
    GET_FUNC_ADDR(Image_GetHashCode)
    return (int32_t)(((SYSCALL1) (pImage_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_ToString)
char*
Image_ToString(TImage AObj) {
    GET_FUNC_ADDR(Image_ToString)
    return (char*)(((SYSCALL1) (pImage_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_AnchorToNeighbour)
void
Image_AnchorToNeighbour(TImage AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Image_AnchorToNeighbour)
    (((SYSCALL4) (pImage_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Image_AnchorParallel)
void
Image_AnchorParallel(TImage AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Image_AnchorParallel)
    (((SYSCALL4) (pImage_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Image_AnchorHorizontalCenterTo)
void
Image_AnchorHorizontalCenterTo(TImage AObj, TControl ASibling) {
    GET_FUNC_ADDR(Image_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pImage_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Image_AnchorVerticalCenterTo)
void
Image_AnchorVerticalCenterTo(TImage AObj, TControl ASibling) {
    GET_FUNC_ADDR(Image_AnchorVerticalCenterTo)
    (((SYSCALL2) (pImage_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Image_AnchorSame)
void
Image_AnchorSame(TImage AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(Image_AnchorSame)
    (((SYSCALL3) (pImage_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Image_AnchorAsAlign)
void
Image_AnchorAsAlign(TImage AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(Image_AnchorAsAlign)
    (((SYSCALL3) (pImage_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Image_AnchorClient)
void
Image_AnchorClient(TImage AObj, int32_t ASpace) {
    GET_FUNC_ADDR(Image_AnchorClient)
    (((SYSCALL2) (pImage_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Image_ScaleDesignToForm)
int32_t
Image_ScaleDesignToForm(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pImage_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleFormToDesign)
int32_t
Image_ScaleFormToDesign(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pImage_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_Scale96ToForm)
int32_t
Image_Scale96ToForm(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pImage_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleFormTo96)
int32_t
Image_ScaleFormTo96(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pImage_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_Scale96ToFont)
int32_t
Image_Scale96ToFont(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pImage_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleFontTo96)
int32_t
Image_ScaleFontTo96(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pImage_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleScreenToFont)
int32_t
Image_ScaleScreenToFont(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pImage_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleFontToScreen)
int32_t
Image_ScaleFontToScreen(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pImage_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_Scale96ToScreen)
int32_t
Image_Scale96ToScreen(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pImage_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_ScaleScreenTo96)
int32_t
Image_ScaleScreenTo96(TImage AObj, int32_t ASize) {
    GET_FUNC_ADDR(Image_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pImage_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Image_AutoAdjustLayout)
void
Image_AutoAdjustLayout(TImage AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(Image_AutoAdjustLayout)
    (((SYSCALL6) (pImage_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(Image_FixDesignFontsPPI)
void
Image_FixDesignFontsPPI(TImage AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(Image_FixDesignFontsPPI)
    (((SYSCALL2) (pImage_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(Image_ScaleFontsPPI)
void
Image_ScaleFontsPPI(TImage AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(Image_ScaleFontsPPI)
    (((SYSCALL3) (pImage_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(Image_GetAntialiasingMode)
TAntialiasingMode
Image_GetAntialiasingMode(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAntialiasingMode)
    return (TAntialiasingMode)(((SYSCALL1) (pImage_GetAntialiasingMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAntialiasingMode)
void
Image_SetAntialiasingMode(TImage AObj, TAntialiasingMode AValue) {
    GET_FUNC_ADDR(Image_SetAntialiasingMode)
    (((SYSCALL2) (pImage_SetAntialiasingMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetKeepOriginXWhenClipped)
BOOL
Image_GetKeepOriginXWhenClipped(TImage AObj) {
    GET_FUNC_ADDR(Image_GetKeepOriginXWhenClipped)
    return (BOOL)(((SYSCALL1) (pImage_GetKeepOriginXWhenClipped))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetKeepOriginXWhenClipped)
void
Image_SetKeepOriginXWhenClipped(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetKeepOriginXWhenClipped)
    (((SYSCALL2) (pImage_SetKeepOriginXWhenClipped))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetKeepOriginYWhenClipped)
BOOL
Image_GetKeepOriginYWhenClipped(TImage AObj) {
    GET_FUNC_ADDR(Image_GetKeepOriginYWhenClipped)
    return (BOOL)(((SYSCALL1) (pImage_GetKeepOriginYWhenClipped))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetKeepOriginYWhenClipped)
void
Image_SetKeepOriginYWhenClipped(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetKeepOriginYWhenClipped)
    (((SYSCALL2) (pImage_SetKeepOriginYWhenClipped))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetStretchInEnabled)
BOOL
Image_GetStretchInEnabled(TImage AObj) {
    GET_FUNC_ADDR(Image_GetStretchInEnabled)
    return (BOOL)(((SYSCALL1) (pImage_GetStretchInEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetStretchInEnabled)
void
Image_SetStretchInEnabled(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetStretchInEnabled)
    (((SYSCALL2) (pImage_SetStretchInEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetStretchOutEnabled)
BOOL
Image_GetStretchOutEnabled(TImage AObj) {
    GET_FUNC_ADDR(Image_GetStretchOutEnabled)
    return (BOOL)(((SYSCALL1) (pImage_GetStretchOutEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetStretchOutEnabled)
void
Image_SetStretchOutEnabled(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetStretchOutEnabled)
    (((SYSCALL2) (pImage_SetStretchOutEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetCanvas)
TCanvas
Image_GetCanvas(TImage AObj) {
    GET_FUNC_ADDR(Image_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pImage_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_GetAlign)
TAlign
Image_GetAlign(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAlign)
    return (TAlign)(((SYSCALL1) (pImage_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAlign)
void
Image_SetAlign(TImage AObj, TAlign AValue) {
    GET_FUNC_ADDR(Image_SetAlign)
    (((SYSCALL2) (pImage_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAnchors)
TAnchors
Image_GetAnchors(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pImage_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAnchors)
void
Image_SetAnchors(TImage AObj, TAnchors AValue) {
    GET_FUNC_ADDR(Image_SetAnchors)
    (((SYSCALL2) (pImage_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAutoSize)
BOOL
Image_GetAutoSize(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAutoSize)
    return (BOOL)(((SYSCALL1) (pImage_GetAutoSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAutoSize)
void
Image_SetAutoSize(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetAutoSize)
    (((SYSCALL2) (pImage_SetAutoSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetCenter)
BOOL
Image_GetCenter(TImage AObj) {
    GET_FUNC_ADDR(Image_GetCenter)
    return (BOOL)(((SYSCALL1) (pImage_GetCenter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetCenter)
void
Image_SetCenter(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetCenter)
    (((SYSCALL2) (pImage_SetCenter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetConstraints)
TSizeConstraints
Image_GetConstraints(TImage AObj) {
    GET_FUNC_ADDR(Image_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pImage_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetConstraints)
void
Image_SetConstraints(TImage AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(Image_SetConstraints)
    (((SYSCALL2) (pImage_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetDragCursor)
TCursor
Image_GetDragCursor(TImage AObj) {
    GET_FUNC_ADDR(Image_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pImage_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetDragCursor)
void
Image_SetDragCursor(TImage AObj, TCursor AValue) {
    GET_FUNC_ADDR(Image_SetDragCursor)
    (((SYSCALL2) (pImage_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetDragMode)
TDragMode
Image_GetDragMode(TImage AObj) {
    GET_FUNC_ADDR(Image_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pImage_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetDragMode)
void
Image_SetDragMode(TImage AObj, TDragMode AValue) {
    GET_FUNC_ADDR(Image_SetDragMode)
    (((SYSCALL2) (pImage_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetEnabled)
BOOL
Image_GetEnabled(TImage AObj) {
    GET_FUNC_ADDR(Image_GetEnabled)
    return (BOOL)(((SYSCALL1) (pImage_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetEnabled)
void
Image_SetEnabled(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetEnabled)
    (((SYSCALL2) (pImage_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetParentShowHint)
BOOL
Image_GetParentShowHint(TImage AObj) {
    GET_FUNC_ADDR(Image_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pImage_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetParentShowHint)
void
Image_SetParentShowHint(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetParentShowHint)
    (((SYSCALL2) (pImage_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetPicture)
TPicture
Image_GetPicture(TImage AObj) {
    GET_FUNC_ADDR(Image_GetPicture)
    return (TPicture)(((SYSCALL1) (pImage_GetPicture))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetPicture)
void
Image_SetPicture(TImage AObj, TPicture AValue) {
    GET_FUNC_ADDR(Image_SetPicture)
    (((SYSCALL2) (pImage_SetPicture))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetPopupMenu)
TPopupMenu
Image_GetPopupMenu(TImage AObj) {
    GET_FUNC_ADDR(Image_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pImage_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetPopupMenu)
void
Image_SetPopupMenu(TImage AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(Image_SetPopupMenu)
    (((SYSCALL2) (pImage_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetProportional)
BOOL
Image_GetProportional(TImage AObj) {
    GET_FUNC_ADDR(Image_GetProportional)
    return (BOOL)(((SYSCALL1) (pImage_GetProportional))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetProportional)
void
Image_SetProportional(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetProportional)
    (((SYSCALL2) (pImage_SetProportional))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetShowHint)
BOOL
Image_GetShowHint(TImage AObj) {
    GET_FUNC_ADDR(Image_GetShowHint)
    return (BOOL)(((SYSCALL1) (pImage_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetShowHint)
void
Image_SetShowHint(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetShowHint)
    (((SYSCALL2) (pImage_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetStretch)
BOOL
Image_GetStretch(TImage AObj) {
    GET_FUNC_ADDR(Image_GetStretch)
    return (BOOL)(((SYSCALL1) (pImage_GetStretch))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetStretch)
void
Image_SetStretch(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetStretch)
    (((SYSCALL2) (pImage_SetStretch))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetTransparent)
BOOL
Image_GetTransparent(TImage AObj) {
    GET_FUNC_ADDR(Image_GetTransparent)
    return (BOOL)(((SYSCALL1) (pImage_GetTransparent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetTransparent)
void
Image_SetTransparent(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetTransparent)
    (((SYSCALL2) (pImage_SetTransparent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetVisible)
BOOL
Image_GetVisible(TImage AObj) {
    GET_FUNC_ADDR(Image_GetVisible)
    return (BOOL)(((SYSCALL1) (pImage_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetVisible)
void
Image_SetVisible(TImage AObj, BOOL AValue) {
    GET_FUNC_ADDR(Image_SetVisible)
    (((SYSCALL2) (pImage_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_SetOnClick)
void
Image_SetOnClick(TImage AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnClick)
    (((SYSCALL2) (pImage_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnDblClick)
void
Image_SetOnDblClick(TImage AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnDblClick)
    (((SYSCALL2) (pImage_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnDragDrop)
void
Image_SetOnDragDrop(TImage AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnDragDrop)
    (((SYSCALL2) (pImage_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnDragOver)
void
Image_SetOnDragOver(TImage AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnDragOver)
    (((SYSCALL2) (pImage_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnEndDrag)
void
Image_SetOnEndDrag(TImage AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnEndDrag)
    (((SYSCALL2) (pImage_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnMouseDown)
void
Image_SetOnMouseDown(TImage AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnMouseDown)
    (((SYSCALL2) (pImage_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnMouseEnter)
void
Image_SetOnMouseEnter(TImage AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnMouseEnter)
    (((SYSCALL2) (pImage_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnMouseLeave)
void
Image_SetOnMouseLeave(TImage AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnMouseLeave)
    (((SYSCALL2) (pImage_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnMouseMove)
void
Image_SetOnMouseMove(TImage AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnMouseMove)
    (((SYSCALL2) (pImage_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_SetOnMouseUp)
void
Image_SetOnMouseUp(TImage AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(Image_SetOnMouseUp)
    (((SYSCALL2) (pImage_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Image_GetAction)
TAction
Image_GetAction(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAction)
    return (TAction)(((SYSCALL1) (pImage_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAction)
void
Image_SetAction(TImage AObj, TAction AValue) {
    GET_FUNC_ADDR(Image_SetAction)
    (((SYSCALL2) (pImage_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetBiDiMode)
TBiDiMode
Image_GetBiDiMode(TImage AObj) {
    GET_FUNC_ADDR(Image_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pImage_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetBiDiMode)
void
Image_SetBiDiMode(TImage AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(Image_SetBiDiMode)
    (((SYSCALL2) (pImage_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetBoundsRect)
TRect
Image_GetBoundsRect(TImage AObj) {
    GET_FUNC_ADDR(Image_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pImage_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_SetBoundsRect)
void
Image_SetBoundsRect(TImage AObj, TRect AValue) {
    GET_FUNC_ADDR(Image_SetBoundsRect)
    (((SYSCALL2) (pImage_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(Image_GetClientHeight)
int32_t
Image_GetClientHeight(TImage AObj) {
    GET_FUNC_ADDR(Image_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pImage_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetClientHeight)
void
Image_SetClientHeight(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetClientHeight)
    (((SYSCALL2) (pImage_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetClientOrigin)
TPoint
Image_GetClientOrigin(TImage AObj) {
    GET_FUNC_ADDR(Image_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pImage_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_GetClientRect)
TRect
Image_GetClientRect(TImage AObj) {
    GET_FUNC_ADDR(Image_GetClientRect)
    TRect result;
    (((SYSCALL2) (pImage_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Image_GetClientWidth)
int32_t
Image_GetClientWidth(TImage AObj) {
    GET_FUNC_ADDR(Image_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pImage_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetClientWidth)
void
Image_SetClientWidth(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetClientWidth)
    (((SYSCALL2) (pImage_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetControlState)
TControlState
Image_GetControlState(TImage AObj) {
    GET_FUNC_ADDR(Image_GetControlState)
    return (TControlState)(((SYSCALL1) (pImage_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetControlState)
void
Image_SetControlState(TImage AObj, TControlState AValue) {
    GET_FUNC_ADDR(Image_SetControlState)
    (((SYSCALL2) (pImage_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetControlStyle)
TControlStyle
Image_GetControlStyle(TImage AObj) {
    GET_FUNC_ADDR(Image_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pImage_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetControlStyle)
void
Image_SetControlStyle(TImage AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(Image_SetControlStyle)
    (((SYSCALL2) (pImage_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetFloating)
BOOL
Image_GetFloating(TImage AObj) {
    GET_FUNC_ADDR(Image_GetFloating)
    return (BOOL)(((SYSCALL1) (pImage_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_GetParent)
TWinControl
Image_GetParent(TImage AObj) {
    GET_FUNC_ADDR(Image_GetParent)
    return (TWinControl)(((SYSCALL1) (pImage_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetParent)
void
Image_SetParent(TImage AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Image_SetParent)
    (((SYSCALL2) (pImage_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetLeft)
int32_t
Image_GetLeft(TImage AObj) {
    GET_FUNC_ADDR(Image_GetLeft)
    return (int32_t)(((SYSCALL1) (pImage_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetLeft)
void
Image_SetLeft(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetLeft)
    (((SYSCALL2) (pImage_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetTop)
int32_t
Image_GetTop(TImage AObj) {
    GET_FUNC_ADDR(Image_GetTop)
    return (int32_t)(((SYSCALL1) (pImage_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetTop)
void
Image_SetTop(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetTop)
    (((SYSCALL2) (pImage_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetWidth)
int32_t
Image_GetWidth(TImage AObj) {
    GET_FUNC_ADDR(Image_GetWidth)
    return (int32_t)(((SYSCALL1) (pImage_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetWidth)
void
Image_SetWidth(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetWidth)
    (((SYSCALL2) (pImage_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetHeight)
int32_t
Image_GetHeight(TImage AObj) {
    GET_FUNC_ADDR(Image_GetHeight)
    return (int32_t)(((SYSCALL1) (pImage_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetHeight)
void
Image_SetHeight(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetHeight)
    (((SYSCALL2) (pImage_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetCursor)
TCursor
Image_GetCursor(TImage AObj) {
    GET_FUNC_ADDR(Image_GetCursor)
    return (TCursor)(((SYSCALL1) (pImage_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetCursor)
void
Image_SetCursor(TImage AObj, TCursor AValue) {
    GET_FUNC_ADDR(Image_SetCursor)
    (((SYSCALL2) (pImage_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetHint)
char*
Image_GetHint(TImage AObj) {
    GET_FUNC_ADDR(Image_GetHint)
    return (char*)(((SYSCALL1) (pImage_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetHint)
void
Image_SetHint(TImage AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Image_SetHint)
    (((SYSCALL2) (pImage_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetComponentCount)
int32_t
Image_GetComponentCount(TImage AObj) {
    GET_FUNC_ADDR(Image_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pImage_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_GetComponentIndex)
int32_t
Image_GetComponentIndex(TImage AObj) {
    GET_FUNC_ADDR(Image_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pImage_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetComponentIndex)
void
Image_SetComponentIndex(TImage AObj, int32_t AValue) {
    GET_FUNC_ADDR(Image_SetComponentIndex)
    (((SYSCALL2) (pImage_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetOwner)
TComponent
Image_GetOwner(TImage AObj) {
    GET_FUNC_ADDR(Image_GetOwner)
    return (TComponent)(((SYSCALL1) (pImage_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_GetName)
char*
Image_GetName(TImage AObj) {
    GET_FUNC_ADDR(Image_GetName)
    return (char*)(((SYSCALL1) (pImage_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetName)
void
Image_SetName(TImage AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Image_SetName)
    (((SYSCALL2) (pImage_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetTag)
intptr_t
Image_GetTag(TImage AObj) {
    GET_FUNC_ADDR(Image_GetTag)
    return (intptr_t)(((SYSCALL1) (pImage_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetTag)
void
Image_SetTag(TImage AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Image_SetTag)
    (((SYSCALL2) (pImage_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAnchorSideLeft)
TAnchorSide
Image_GetAnchorSideLeft(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pImage_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAnchorSideLeft)
void
Image_SetAnchorSideLeft(TImage AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Image_SetAnchorSideLeft)
    (((SYSCALL2) (pImage_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAnchorSideTop)
TAnchorSide
Image_GetAnchorSideTop(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pImage_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAnchorSideTop)
void
Image_SetAnchorSideTop(TImage AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Image_SetAnchorSideTop)
    (((SYSCALL2) (pImage_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAnchorSideRight)
TAnchorSide
Image_GetAnchorSideRight(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pImage_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAnchorSideRight)
void
Image_SetAnchorSideRight(TImage AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Image_SetAnchorSideRight)
    (((SYSCALL2) (pImage_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetAnchorSideBottom)
TAnchorSide
Image_GetAnchorSideBottom(TImage AObj) {
    GET_FUNC_ADDR(Image_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pImage_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetAnchorSideBottom)
void
Image_SetAnchorSideBottom(TImage AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Image_SetAnchorSideBottom)
    (((SYSCALL2) (pImage_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetBorderSpacing)
TControlBorderSpacing
Image_GetBorderSpacing(TImage AObj) {
    GET_FUNC_ADDR(Image_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pImage_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Image_SetBorderSpacing)
void
Image_SetBorderSpacing(TImage AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(Image_SetBorderSpacing)
    (((SYSCALL2) (pImage_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Image_GetComponents)
TComponent
Image_GetComponents(TImage AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Image_GetComponents)
    return (TComponent)(((SYSCALL2) (pImage_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Image_GetAnchorSide)
TAnchorSide
Image_GetAnchorSide(TImage AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(Image_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pImage_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(Image_StaticClassType)
TClass
Image_StaticClassType() {
    GET_FUNC_ADDR(Image_StaticClassType)
    return (TClass)(((SYSCALL0) (pImage_StaticClassType))());
}

// -------------------TLinkLabel-------------------

DEFINE_FUNC_PTR(LinkLabel_Create)
TLinkLabel
LinkLabel_Create(TComponent AOwner) {
    GET_FUNC_ADDR(LinkLabel_Create)
    return (TLinkLabel)(((SYSCALL1) (pLinkLabel_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(LinkLabel_Free)
void
LinkLabel_Free(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Free)
    (((SYSCALL1) (pLinkLabel_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Invalidate)
void
LinkLabel_Invalidate(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Invalidate)
    (((SYSCALL1) (pLinkLabel_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Repaint)
void
LinkLabel_Repaint(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Repaint)
    (((SYSCALL1) (pLinkLabel_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetBounds)
void
LinkLabel_SetBounds(TLinkLabel AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(LinkLabel_SetBounds)
    (((SYSCALL5) (pLinkLabel_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(LinkLabel_Update)
void
LinkLabel_Update(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Update)
    (((SYSCALL1) (pLinkLabel_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_BringToFront)
void
LinkLabel_BringToFront(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_BringToFront)
    (((SYSCALL1) (pLinkLabel_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_ClientToScreen)
TPoint
LinkLabel_ClientToScreen(TLinkLabel AObj, TPoint Point) {
    GET_FUNC_ADDR(LinkLabel_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pLinkLabel_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_ClientToParent)
TPoint
LinkLabel_ClientToParent(TLinkLabel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(LinkLabel_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pLinkLabel_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_Dragging)
BOOL
LinkLabel_Dragging(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Dragging)
    return (BOOL)(((SYSCALL1) (pLinkLabel_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_HasParent)
BOOL
LinkLabel_HasParent(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_HasParent)
    return (BOOL)(((SYSCALL1) (pLinkLabel_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Hide)
void
LinkLabel_Hide(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Hide)
    (((SYSCALL1) (pLinkLabel_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Perform)
intptr_t
LinkLabel_Perform(TLinkLabel AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(LinkLabel_Perform)
    return (intptr_t)(((SYSCALL4) (pLinkLabel_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(LinkLabel_Refresh)
void
LinkLabel_Refresh(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Refresh)
    (((SYSCALL1) (pLinkLabel_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_ScreenToClient)
TPoint
LinkLabel_ScreenToClient(TLinkLabel AObj, TPoint Point) {
    GET_FUNC_ADDR(LinkLabel_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pLinkLabel_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_ParentToClient)
TPoint
LinkLabel_ParentToClient(TLinkLabel AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(LinkLabel_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pLinkLabel_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_SendToBack)
void
LinkLabel_SendToBack(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_SendToBack)
    (((SYSCALL1) (pLinkLabel_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Show)
void
LinkLabel_Show(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_Show)
    (((SYSCALL1) (pLinkLabel_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetTextBuf)
int32_t
LinkLabel_GetTextBuf(TLinkLabel AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(LinkLabel_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pLinkLabel_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(LinkLabel_GetTextLen)
int32_t
LinkLabel_GetTextLen(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetTextLen)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetTextBuf)
void
LinkLabel_SetTextBuf(TLinkLabel AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(LinkLabel_SetTextBuf)
    (((SYSCALL2) (pLinkLabel_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(LinkLabel_FindComponent)
TComponent
LinkLabel_FindComponent(TLinkLabel AObj, CChar char* AName) {
    GET_FUNC_ADDR(LinkLabel_FindComponent)
    return (TComponent)(((SYSCALL2) (pLinkLabel_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(LinkLabel_GetNamePath)
char*
LinkLabel_GetNamePath(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetNamePath)
    return (char*)(((SYSCALL1) (pLinkLabel_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_Assign)
void
LinkLabel_Assign(TLinkLabel AObj, TObject Source) {
    GET_FUNC_ADDR(LinkLabel_Assign)
    (((SYSCALL2) (pLinkLabel_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(LinkLabel_ClassType)
TClass
LinkLabel_ClassType(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_ClassType)
    return (TClass)(((SYSCALL1) (pLinkLabel_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_ClassName)
char*
LinkLabel_ClassName(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_ClassName)
    return (char*)(((SYSCALL1) (pLinkLabel_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_InstanceSize)
int32_t
LinkLabel_InstanceSize(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_InstanceSize)
    return (int32_t)(((SYSCALL1) (pLinkLabel_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_InheritsFrom)
BOOL
LinkLabel_InheritsFrom(TLinkLabel AObj, TClass AClass) {
    GET_FUNC_ADDR(LinkLabel_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pLinkLabel_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(LinkLabel_Equals)
BOOL
LinkLabel_Equals(TLinkLabel AObj, TObject Obj) {
    GET_FUNC_ADDR(LinkLabel_Equals)
    return (BOOL)(((SYSCALL2) (pLinkLabel_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetHashCode)
int32_t
LinkLabel_GetHashCode(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetHashCode)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_ToString)
char*
LinkLabel_ToString(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_ToString)
    return (char*)(((SYSCALL1) (pLinkLabel_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorToNeighbour)
void
LinkLabel_AnchorToNeighbour(TLinkLabel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(LinkLabel_AnchorToNeighbour)
    (((SYSCALL4) (pLinkLabel_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorParallel)
void
LinkLabel_AnchorParallel(TLinkLabel AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(LinkLabel_AnchorParallel)
    (((SYSCALL4) (pLinkLabel_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorHorizontalCenterTo)
void
LinkLabel_AnchorHorizontalCenterTo(TLinkLabel AObj, TControl ASibling) {
    GET_FUNC_ADDR(LinkLabel_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pLinkLabel_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorVerticalCenterTo)
void
LinkLabel_AnchorVerticalCenterTo(TLinkLabel AObj, TControl ASibling) {
    GET_FUNC_ADDR(LinkLabel_AnchorVerticalCenterTo)
    (((SYSCALL2) (pLinkLabel_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorSame)
void
LinkLabel_AnchorSame(TLinkLabel AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(LinkLabel_AnchorSame)
    (((SYSCALL3) (pLinkLabel_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorAsAlign)
void
LinkLabel_AnchorAsAlign(TLinkLabel AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(LinkLabel_AnchorAsAlign)
    (((SYSCALL3) (pLinkLabel_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(LinkLabel_AnchorClient)
void
LinkLabel_AnchorClient(TLinkLabel AObj, int32_t ASpace) {
    GET_FUNC_ADDR(LinkLabel_AnchorClient)
    (((SYSCALL2) (pLinkLabel_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleDesignToForm)
int32_t
LinkLabel_ScaleDesignToForm(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleFormToDesign)
int32_t
LinkLabel_ScaleFormToDesign(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_Scale96ToForm)
int32_t
LinkLabel_Scale96ToForm(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pLinkLabel_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleFormTo96)
int32_t
LinkLabel_ScaleFormTo96(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_Scale96ToFont)
int32_t
LinkLabel_Scale96ToFont(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pLinkLabel_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleFontTo96)
int32_t
LinkLabel_ScaleFontTo96(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleScreenToFont)
int32_t
LinkLabel_ScaleScreenToFont(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleFontToScreen)
int32_t
LinkLabel_ScaleFontToScreen(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_Scale96ToScreen)
int32_t
LinkLabel_Scale96ToScreen(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pLinkLabel_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleScreenTo96)
int32_t
LinkLabel_ScaleScreenTo96(TLinkLabel AObj, int32_t ASize) {
    GET_FUNC_ADDR(LinkLabel_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pLinkLabel_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(LinkLabel_AutoAdjustLayout)
void
LinkLabel_AutoAdjustLayout(TLinkLabel AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(LinkLabel_AutoAdjustLayout)
    (((SYSCALL6) (pLinkLabel_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(LinkLabel_FixDesignFontsPPI)
void
LinkLabel_FixDesignFontsPPI(TLinkLabel AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(LinkLabel_FixDesignFontsPPI)
    (((SYSCALL2) (pLinkLabel_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(LinkLabel_ScaleFontsPPI)
void
LinkLabel_ScaleFontsPPI(TLinkLabel AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(LinkLabel_ScaleFontsPPI)
    (((SYSCALL3) (pLinkLabel_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAlign)
TAlign
LinkLabel_GetAlign(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAlign)
    return (TAlign)(((SYSCALL1) (pLinkLabel_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAlign)
void
LinkLabel_SetAlign(TLinkLabel AObj, TAlign AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAlign)
    (((SYSCALL2) (pLinkLabel_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAlignment)
TAlignment
LinkLabel_GetAlignment(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAlignment)
    return (TAlignment)(((SYSCALL1) (pLinkLabel_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAlignment)
void
LinkLabel_SetAlignment(TLinkLabel AObj, TAlignment AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAlignment)
    (((SYSCALL2) (pLinkLabel_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchors)
TAnchors
LinkLabel_GetAnchors(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pLinkLabel_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAnchors)
void
LinkLabel_SetAnchors(TLinkLabel AObj, TAnchors AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAnchors)
    (((SYSCALL2) (pLinkLabel_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAutoSize)
BOOL
LinkLabel_GetAutoSize(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAutoSize)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetAutoSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAutoSize)
void
LinkLabel_SetAutoSize(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAutoSize)
    (((SYSCALL2) (pLinkLabel_SetAutoSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetCaption)
char*
LinkLabel_GetCaption(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetCaption)
    return (char*)(((SYSCALL1) (pLinkLabel_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetCaption)
void
LinkLabel_SetCaption(TLinkLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(LinkLabel_SetCaption)
    (((SYSCALL2) (pLinkLabel_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetColor)
TColor
LinkLabel_GetColor(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetColor)
    return (TColor)(((SYSCALL1) (pLinkLabel_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetColor)
void
LinkLabel_SetColor(TLinkLabel AObj, TColor AValue) {
    GET_FUNC_ADDR(LinkLabel_SetColor)
    (((SYSCALL2) (pLinkLabel_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetConstraints)
TSizeConstraints
LinkLabel_GetConstraints(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pLinkLabel_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetConstraints)
void
LinkLabel_SetConstraints(TLinkLabel AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(LinkLabel_SetConstraints)
    (((SYSCALL2) (pLinkLabel_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetDragCursor)
TCursor
LinkLabel_GetDragCursor(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pLinkLabel_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetDragCursor)
void
LinkLabel_SetDragCursor(TLinkLabel AObj, TCursor AValue) {
    GET_FUNC_ADDR(LinkLabel_SetDragCursor)
    (((SYSCALL2) (pLinkLabel_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetDragKind)
TDragKind
LinkLabel_GetDragKind(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pLinkLabel_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetDragKind)
void
LinkLabel_SetDragKind(TLinkLabel AObj, TDragKind AValue) {
    GET_FUNC_ADDR(LinkLabel_SetDragKind)
    (((SYSCALL2) (pLinkLabel_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetDragMode)
TDragMode
LinkLabel_GetDragMode(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pLinkLabel_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetDragMode)
void
LinkLabel_SetDragMode(TLinkLabel AObj, TDragMode AValue) {
    GET_FUNC_ADDR(LinkLabel_SetDragMode)
    (((SYSCALL2) (pLinkLabel_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetEnabled)
BOOL
LinkLabel_GetEnabled(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetEnabled)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetEnabled)
void
LinkLabel_SetEnabled(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetEnabled)
    (((SYSCALL2) (pLinkLabel_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetFont)
TFont
LinkLabel_GetFont(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetFont)
    return (TFont)(((SYSCALL1) (pLinkLabel_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetFont)
void
LinkLabel_SetFont(TLinkLabel AObj, TFont AValue) {
    GET_FUNC_ADDR(LinkLabel_SetFont)
    (((SYSCALL2) (pLinkLabel_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetParentColor)
BOOL
LinkLabel_GetParentColor(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetParentColor)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetParentColor)
void
LinkLabel_SetParentColor(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetParentColor)
    (((SYSCALL2) (pLinkLabel_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetParentFont)
BOOL
LinkLabel_GetParentFont(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetParentFont)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetParentFont)
void
LinkLabel_SetParentFont(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetParentFont)
    (((SYSCALL2) (pLinkLabel_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetParentShowHint)
BOOL
LinkLabel_GetParentShowHint(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetParentShowHint)
void
LinkLabel_SetParentShowHint(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetParentShowHint)
    (((SYSCALL2) (pLinkLabel_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetPopupMenu)
TPopupMenu
LinkLabel_GetPopupMenu(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pLinkLabel_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetPopupMenu)
void
LinkLabel_SetPopupMenu(TLinkLabel AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(LinkLabel_SetPopupMenu)
    (((SYSCALL2) (pLinkLabel_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetShowHint)
BOOL
LinkLabel_GetShowHint(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetShowHint)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetShowHint)
void
LinkLabel_SetShowHint(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetShowHint)
    (((SYSCALL2) (pLinkLabel_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetVisible)
BOOL
LinkLabel_GetVisible(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetVisible)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetVisible)
void
LinkLabel_SetVisible(TLinkLabel AObj, BOOL AValue) {
    GET_FUNC_ADDR(LinkLabel_SetVisible)
    (((SYSCALL2) (pLinkLabel_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnClick)
void
LinkLabel_SetOnClick(TLinkLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnClick)
    (((SYSCALL2) (pLinkLabel_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnContextPopup)
void
LinkLabel_SetOnContextPopup(TLinkLabel AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnContextPopup)
    (((SYSCALL2) (pLinkLabel_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnDblClick)
void
LinkLabel_SetOnDblClick(TLinkLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnDblClick)
    (((SYSCALL2) (pLinkLabel_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnDragDrop)
void
LinkLabel_SetOnDragDrop(TLinkLabel AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnDragDrop)
    (((SYSCALL2) (pLinkLabel_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnDragOver)
void
LinkLabel_SetOnDragOver(TLinkLabel AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnDragOver)
    (((SYSCALL2) (pLinkLabel_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnEndDrag)
void
LinkLabel_SetOnEndDrag(TLinkLabel AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnEndDrag)
    (((SYSCALL2) (pLinkLabel_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnMouseDown)
void
LinkLabel_SetOnMouseDown(TLinkLabel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnMouseDown)
    (((SYSCALL2) (pLinkLabel_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnMouseEnter)
void
LinkLabel_SetOnMouseEnter(TLinkLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnMouseEnter)
    (((SYSCALL2) (pLinkLabel_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnMouseLeave)
void
LinkLabel_SetOnMouseLeave(TLinkLabel AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnMouseLeave)
    (((SYSCALL2) (pLinkLabel_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnMouseMove)
void
LinkLabel_SetOnMouseMove(TLinkLabel AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnMouseMove)
    (((SYSCALL2) (pLinkLabel_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnMouseUp)
void
LinkLabel_SetOnMouseUp(TLinkLabel AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnMouseUp)
    (((SYSCALL2) (pLinkLabel_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_SetOnLinkClick)
void
LinkLabel_SetOnLinkClick(TLinkLabel AObj, TSysLinkEvent AEventData) {
    GET_FUNC_ADDR(LinkLabel_SetOnLinkClick)
    (((SYSCALL2) (pLinkLabel_SetOnLinkClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(LinkLabel_GetMouseInClient)
BOOL
LinkLabel_GetMouseInClient(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAction)
TAction
LinkLabel_GetAction(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAction)
    return (TAction)(((SYSCALL1) (pLinkLabel_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAction)
void
LinkLabel_SetAction(TLinkLabel AObj, TAction AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAction)
    (((SYSCALL2) (pLinkLabel_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetBiDiMode)
TBiDiMode
LinkLabel_GetBiDiMode(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pLinkLabel_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetBiDiMode)
void
LinkLabel_SetBiDiMode(TLinkLabel AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(LinkLabel_SetBiDiMode)
    (((SYSCALL2) (pLinkLabel_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetBoundsRect)
TRect
LinkLabel_GetBoundsRect(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pLinkLabel_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_SetBoundsRect)
void
LinkLabel_SetBoundsRect(TLinkLabel AObj, TRect AValue) {
    GET_FUNC_ADDR(LinkLabel_SetBoundsRect)
    (((SYSCALL2) (pLinkLabel_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetClientHeight)
int32_t
LinkLabel_GetClientHeight(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetClientHeight)
void
LinkLabel_SetClientHeight(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetClientHeight)
    (((SYSCALL2) (pLinkLabel_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetClientOrigin)
TPoint
LinkLabel_GetClientOrigin(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pLinkLabel_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_GetClientRect)
TRect
LinkLabel_GetClientRect(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetClientRect)
    TRect result;
    (((SYSCALL2) (pLinkLabel_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(LinkLabel_GetClientWidth)
int32_t
LinkLabel_GetClientWidth(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetClientWidth)
void
LinkLabel_SetClientWidth(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetClientWidth)
    (((SYSCALL2) (pLinkLabel_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetControlState)
TControlState
LinkLabel_GetControlState(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetControlState)
    return (TControlState)(((SYSCALL1) (pLinkLabel_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetControlState)
void
LinkLabel_SetControlState(TLinkLabel AObj, TControlState AValue) {
    GET_FUNC_ADDR(LinkLabel_SetControlState)
    (((SYSCALL2) (pLinkLabel_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetControlStyle)
TControlStyle
LinkLabel_GetControlStyle(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pLinkLabel_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetControlStyle)
void
LinkLabel_SetControlStyle(TLinkLabel AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(LinkLabel_SetControlStyle)
    (((SYSCALL2) (pLinkLabel_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetFloating)
BOOL
LinkLabel_GetFloating(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetFloating)
    return (BOOL)(((SYSCALL1) (pLinkLabel_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetParent)
TWinControl
LinkLabel_GetParent(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetParent)
    return (TWinControl)(((SYSCALL1) (pLinkLabel_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetParent)
void
LinkLabel_SetParent(TLinkLabel AObj, TWinControl AValue) {
    GET_FUNC_ADDR(LinkLabel_SetParent)
    (((SYSCALL2) (pLinkLabel_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetLeft)
int32_t
LinkLabel_GetLeft(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetLeft)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetLeft)
void
LinkLabel_SetLeft(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetLeft)
    (((SYSCALL2) (pLinkLabel_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetTop)
int32_t
LinkLabel_GetTop(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetTop)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetTop)
void
LinkLabel_SetTop(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetTop)
    (((SYSCALL2) (pLinkLabel_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetWidth)
int32_t
LinkLabel_GetWidth(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetWidth)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetWidth)
void
LinkLabel_SetWidth(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetWidth)
    (((SYSCALL2) (pLinkLabel_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetHeight)
int32_t
LinkLabel_GetHeight(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetHeight)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetHeight)
void
LinkLabel_SetHeight(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetHeight)
    (((SYSCALL2) (pLinkLabel_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetHint)
char*
LinkLabel_GetHint(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetHint)
    return (char*)(((SYSCALL1) (pLinkLabel_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetHint)
void
LinkLabel_SetHint(TLinkLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(LinkLabel_SetHint)
    (((SYSCALL2) (pLinkLabel_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetComponentCount)
int32_t
LinkLabel_GetComponentCount(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetComponentIndex)
int32_t
LinkLabel_GetComponentIndex(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pLinkLabel_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetComponentIndex)
void
LinkLabel_SetComponentIndex(TLinkLabel AObj, int32_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetComponentIndex)
    (((SYSCALL2) (pLinkLabel_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetOwner)
TComponent
LinkLabel_GetOwner(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetOwner)
    return (TComponent)(((SYSCALL1) (pLinkLabel_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_GetName)
char*
LinkLabel_GetName(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetName)
    return (char*)(((SYSCALL1) (pLinkLabel_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetName)
void
LinkLabel_SetName(TLinkLabel AObj, CChar char* AValue) {
    GET_FUNC_ADDR(LinkLabel_SetName)
    (((SYSCALL2) (pLinkLabel_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetTag)
intptr_t
LinkLabel_GetTag(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetTag)
    return (intptr_t)(((SYSCALL1) (pLinkLabel_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetTag)
void
LinkLabel_SetTag(TLinkLabel AObj, intptr_t AValue) {
    GET_FUNC_ADDR(LinkLabel_SetTag)
    (((SYSCALL2) (pLinkLabel_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchorSideLeft)
TAnchorSide
LinkLabel_GetAnchorSideLeft(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pLinkLabel_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAnchorSideLeft)
void
LinkLabel_SetAnchorSideLeft(TLinkLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAnchorSideLeft)
    (((SYSCALL2) (pLinkLabel_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchorSideTop)
TAnchorSide
LinkLabel_GetAnchorSideTop(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pLinkLabel_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAnchorSideTop)
void
LinkLabel_SetAnchorSideTop(TLinkLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAnchorSideTop)
    (((SYSCALL2) (pLinkLabel_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchorSideRight)
TAnchorSide
LinkLabel_GetAnchorSideRight(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pLinkLabel_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAnchorSideRight)
void
LinkLabel_SetAnchorSideRight(TLinkLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAnchorSideRight)
    (((SYSCALL2) (pLinkLabel_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchorSideBottom)
TAnchorSide
LinkLabel_GetAnchorSideBottom(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pLinkLabel_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetAnchorSideBottom)
void
LinkLabel_SetAnchorSideBottom(TLinkLabel AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(LinkLabel_SetAnchorSideBottom)
    (((SYSCALL2) (pLinkLabel_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetBorderSpacing)
TControlBorderSpacing
LinkLabel_GetBorderSpacing(TLinkLabel AObj) {
    GET_FUNC_ADDR(LinkLabel_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pLinkLabel_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(LinkLabel_SetBorderSpacing)
void
LinkLabel_SetBorderSpacing(TLinkLabel AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(LinkLabel_SetBorderSpacing)
    (((SYSCALL2) (pLinkLabel_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(LinkLabel_GetComponents)
TComponent
LinkLabel_GetComponents(TLinkLabel AObj, int32_t AIndex) {
    GET_FUNC_ADDR(LinkLabel_GetComponents)
    return (TComponent)(((SYSCALL2) (pLinkLabel_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(LinkLabel_GetAnchorSide)
TAnchorSide
LinkLabel_GetAnchorSide(TLinkLabel AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(LinkLabel_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pLinkLabel_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(LinkLabel_StaticClassType)
TClass
LinkLabel_StaticClassType() {
    GET_FUNC_ADDR(LinkLabel_StaticClassType)
    return (TClass)(((SYSCALL0) (pLinkLabel_StaticClassType))());
}

// -------------------TSpeedButton-------------------

DEFINE_FUNC_PTR(SpeedButton_Create)
TSpeedButton
SpeedButton_Create(TComponent AOwner) {
    GET_FUNC_ADDR(SpeedButton_Create)
    return (TSpeedButton)(((SYSCALL1) (pSpeedButton_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(SpeedButton_Free)
void
SpeedButton_Free(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Free)
    (((SYSCALL1) (pSpeedButton_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Click)
void
SpeedButton_Click(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Click)
    (((SYSCALL1) (pSpeedButton_Click))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_BringToFront)
void
SpeedButton_BringToFront(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_BringToFront)
    (((SYSCALL1) (pSpeedButton_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_ClientToScreen)
TPoint
SpeedButton_ClientToScreen(TSpeedButton AObj, TPoint Point) {
    GET_FUNC_ADDR(SpeedButton_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pSpeedButton_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_ClientToParent)
TPoint
SpeedButton_ClientToParent(TSpeedButton AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(SpeedButton_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pSpeedButton_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_Dragging)
BOOL
SpeedButton_Dragging(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Dragging)
    return (BOOL)(((SYSCALL1) (pSpeedButton_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_HasParent)
BOOL
SpeedButton_HasParent(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_HasParent)
    return (BOOL)(((SYSCALL1) (pSpeedButton_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Hide)
void
SpeedButton_Hide(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Hide)
    (((SYSCALL1) (pSpeedButton_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Invalidate)
void
SpeedButton_Invalidate(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Invalidate)
    (((SYSCALL1) (pSpeedButton_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Perform)
intptr_t
SpeedButton_Perform(TSpeedButton AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(SpeedButton_Perform)
    return (intptr_t)(((SYSCALL4) (pSpeedButton_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(SpeedButton_Refresh)
void
SpeedButton_Refresh(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Refresh)
    (((SYSCALL1) (pSpeedButton_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Repaint)
void
SpeedButton_Repaint(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Repaint)
    (((SYSCALL1) (pSpeedButton_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_ScreenToClient)
TPoint
SpeedButton_ScreenToClient(TSpeedButton AObj, TPoint Point) {
    GET_FUNC_ADDR(SpeedButton_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pSpeedButton_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_ParentToClient)
TPoint
SpeedButton_ParentToClient(TSpeedButton AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(SpeedButton_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pSpeedButton_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_SendToBack)
void
SpeedButton_SendToBack(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_SendToBack)
    (((SYSCALL1) (pSpeedButton_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetBounds)
void
SpeedButton_SetBounds(TSpeedButton AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(SpeedButton_SetBounds)
    (((SYSCALL5) (pSpeedButton_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(SpeedButton_Show)
void
SpeedButton_Show(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Show)
    (((SYSCALL1) (pSpeedButton_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Update)
void
SpeedButton_Update(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_Update)
    (((SYSCALL1) (pSpeedButton_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_GetTextBuf)
int32_t
SpeedButton_GetTextBuf(TSpeedButton AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(SpeedButton_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pSpeedButton_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(SpeedButton_GetTextLen)
int32_t
SpeedButton_GetTextLen(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetTextLen)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetTextBuf)
void
SpeedButton_SetTextBuf(TSpeedButton AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(SpeedButton_SetTextBuf)
    (((SYSCALL2) (pSpeedButton_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(SpeedButton_FindComponent)
TComponent
SpeedButton_FindComponent(TSpeedButton AObj, CChar char* AName) {
    GET_FUNC_ADDR(SpeedButton_FindComponent)
    return (TComponent)(((SYSCALL2) (pSpeedButton_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(SpeedButton_GetNamePath)
char*
SpeedButton_GetNamePath(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetNamePath)
    return (char*)(((SYSCALL1) (pSpeedButton_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_Assign)
void
SpeedButton_Assign(TSpeedButton AObj, TObject Source) {
    GET_FUNC_ADDR(SpeedButton_Assign)
    (((SYSCALL2) (pSpeedButton_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(SpeedButton_ClassType)
TClass
SpeedButton_ClassType(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_ClassType)
    return (TClass)(((SYSCALL1) (pSpeedButton_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_ClassName)
char*
SpeedButton_ClassName(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_ClassName)
    return (char*)(((SYSCALL1) (pSpeedButton_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_InstanceSize)
int32_t
SpeedButton_InstanceSize(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_InstanceSize)
    return (int32_t)(((SYSCALL1) (pSpeedButton_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_InheritsFrom)
BOOL
SpeedButton_InheritsFrom(TSpeedButton AObj, TClass AClass) {
    GET_FUNC_ADDR(SpeedButton_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pSpeedButton_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(SpeedButton_Equals)
BOOL
SpeedButton_Equals(TSpeedButton AObj, TObject Obj) {
    GET_FUNC_ADDR(SpeedButton_Equals)
    return (BOOL)(((SYSCALL2) (pSpeedButton_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(SpeedButton_GetHashCode)
int32_t
SpeedButton_GetHashCode(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetHashCode)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_ToString)
char*
SpeedButton_ToString(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_ToString)
    return (char*)(((SYSCALL1) (pSpeedButton_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorToNeighbour)
void
SpeedButton_AnchorToNeighbour(TSpeedButton AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(SpeedButton_AnchorToNeighbour)
    (((SYSCALL4) (pSpeedButton_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorParallel)
void
SpeedButton_AnchorParallel(TSpeedButton AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(SpeedButton_AnchorParallel)
    (((SYSCALL4) (pSpeedButton_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorHorizontalCenterTo)
void
SpeedButton_AnchorHorizontalCenterTo(TSpeedButton AObj, TControl ASibling) {
    GET_FUNC_ADDR(SpeedButton_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pSpeedButton_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorVerticalCenterTo)
void
SpeedButton_AnchorVerticalCenterTo(TSpeedButton AObj, TControl ASibling) {
    GET_FUNC_ADDR(SpeedButton_AnchorVerticalCenterTo)
    (((SYSCALL2) (pSpeedButton_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorSame)
void
SpeedButton_AnchorSame(TSpeedButton AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(SpeedButton_AnchorSame)
    (((SYSCALL3) (pSpeedButton_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorAsAlign)
void
SpeedButton_AnchorAsAlign(TSpeedButton AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(SpeedButton_AnchorAsAlign)
    (((SYSCALL3) (pSpeedButton_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(SpeedButton_AnchorClient)
void
SpeedButton_AnchorClient(TSpeedButton AObj, int32_t ASpace) {
    GET_FUNC_ADDR(SpeedButton_AnchorClient)
    (((SYSCALL2) (pSpeedButton_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleDesignToForm)
int32_t
SpeedButton_ScaleDesignToForm(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleFormToDesign)
int32_t
SpeedButton_ScaleFormToDesign(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_Scale96ToForm)
int32_t
SpeedButton_Scale96ToForm(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pSpeedButton_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleFormTo96)
int32_t
SpeedButton_ScaleFormTo96(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_Scale96ToFont)
int32_t
SpeedButton_Scale96ToFont(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pSpeedButton_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleFontTo96)
int32_t
SpeedButton_ScaleFontTo96(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleScreenToFont)
int32_t
SpeedButton_ScaleScreenToFont(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleFontToScreen)
int32_t
SpeedButton_ScaleFontToScreen(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_Scale96ToScreen)
int32_t
SpeedButton_Scale96ToScreen(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pSpeedButton_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleScreenTo96)
int32_t
SpeedButton_ScaleScreenTo96(TSpeedButton AObj, int32_t ASize) {
    GET_FUNC_ADDR(SpeedButton_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pSpeedButton_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(SpeedButton_AutoAdjustLayout)
void
SpeedButton_AutoAdjustLayout(TSpeedButton AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(SpeedButton_AutoAdjustLayout)
    (((SYSCALL6) (pSpeedButton_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(SpeedButton_FixDesignFontsPPI)
void
SpeedButton_FixDesignFontsPPI(TSpeedButton AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(SpeedButton_FixDesignFontsPPI)
    (((SYSCALL2) (pSpeedButton_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(SpeedButton_ScaleFontsPPI)
void
SpeedButton_ScaleFontsPPI(TSpeedButton AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(SpeedButton_ScaleFontsPPI)
    (((SYSCALL3) (pSpeedButton_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(SpeedButton_GetImageIndex)
int32_t
SpeedButton_GetImageIndex(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetImageIndex)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetImageIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetImageIndex)
void
SpeedButton_SetImageIndex(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetImageIndex)
    (((SYSCALL2) (pSpeedButton_SetImageIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetImages)
TImageList
SpeedButton_GetImages(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetImages)
    return (TImageList)(((SYSCALL1) (pSpeedButton_GetImages))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetImages)
void
SpeedButton_SetImages(TSpeedButton AObj, TImageList AValue) {
    GET_FUNC_ADDR(SpeedButton_SetImages)
    (((SYSCALL2) (pSpeedButton_SetImages))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetImageWidth)
int32_t
SpeedButton_GetImageWidth(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetImageWidth)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetImageWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetImageWidth)
void
SpeedButton_SetImageWidth(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetImageWidth)
    (((SYSCALL2) (pSpeedButton_SetImageWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetShowCaption)
BOOL
SpeedButton_GetShowCaption(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetShowCaption)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetShowCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetShowCaption)
void
SpeedButton_SetShowCaption(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetShowCaption)
    (((SYSCALL2) (pSpeedButton_SetShowCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAction)
TAction
SpeedButton_GetAction(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAction)
    return (TAction)(((SYSCALL1) (pSpeedButton_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAction)
void
SpeedButton_SetAction(TSpeedButton AObj, TAction AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAction)
    (((SYSCALL2) (pSpeedButton_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAlign)
TAlign
SpeedButton_GetAlign(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAlign)
    return (TAlign)(((SYSCALL1) (pSpeedButton_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAlign)
void
SpeedButton_SetAlign(TSpeedButton AObj, TAlign AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAlign)
    (((SYSCALL2) (pSpeedButton_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAllowAllUp)
BOOL
SpeedButton_GetAllowAllUp(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAllowAllUp)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetAllowAllUp))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAllowAllUp)
void
SpeedButton_SetAllowAllUp(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAllowAllUp)
    (((SYSCALL2) (pSpeedButton_SetAllowAllUp))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchors)
TAnchors
SpeedButton_GetAnchors(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pSpeedButton_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAnchors)
void
SpeedButton_SetAnchors(TSpeedButton AObj, TAnchors AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAnchors)
    (((SYSCALL2) (pSpeedButton_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetBiDiMode)
TBiDiMode
SpeedButton_GetBiDiMode(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pSpeedButton_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetBiDiMode)
void
SpeedButton_SetBiDiMode(TSpeedButton AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(SpeedButton_SetBiDiMode)
    (((SYSCALL2) (pSpeedButton_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetConstraints)
TSizeConstraints
SpeedButton_GetConstraints(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pSpeedButton_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetConstraints)
void
SpeedButton_SetConstraints(TSpeedButton AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(SpeedButton_SetConstraints)
    (((SYSCALL2) (pSpeedButton_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetGroupIndex)
int32_t
SpeedButton_GetGroupIndex(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetGroupIndex)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetGroupIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetGroupIndex)
void
SpeedButton_SetGroupIndex(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetGroupIndex)
    (((SYSCALL2) (pSpeedButton_SetGroupIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetDown)
BOOL
SpeedButton_GetDown(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetDown)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetDown))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetDown)
void
SpeedButton_SetDown(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetDown)
    (((SYSCALL2) (pSpeedButton_SetDown))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetCaption)
char*
SpeedButton_GetCaption(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetCaption)
    return (char*)(((SYSCALL1) (pSpeedButton_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetCaption)
void
SpeedButton_SetCaption(TSpeedButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SpeedButton_SetCaption)
    (((SYSCALL2) (pSpeedButton_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetEnabled)
BOOL
SpeedButton_GetEnabled(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetEnabled)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetEnabled)
void
SpeedButton_SetEnabled(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetEnabled)
    (((SYSCALL2) (pSpeedButton_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetFlat)
BOOL
SpeedButton_GetFlat(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetFlat)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetFlat))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetFlat)
void
SpeedButton_SetFlat(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetFlat)
    (((SYSCALL2) (pSpeedButton_SetFlat))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetFont)
TFont
SpeedButton_GetFont(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetFont)
    return (TFont)(((SYSCALL1) (pSpeedButton_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetFont)
void
SpeedButton_SetFont(TSpeedButton AObj, TFont AValue) {
    GET_FUNC_ADDR(SpeedButton_SetFont)
    (((SYSCALL2) (pSpeedButton_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetGlyph)
TBitmap
SpeedButton_GetGlyph(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetGlyph)
    return (TBitmap)(((SYSCALL1) (pSpeedButton_GetGlyph))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetGlyph)
void
SpeedButton_SetGlyph(TSpeedButton AObj, TBitmap AValue) {
    GET_FUNC_ADDR(SpeedButton_SetGlyph)
    (((SYSCALL2) (pSpeedButton_SetGlyph))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetLayout)
TButtonLayout
SpeedButton_GetLayout(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetLayout)
    return (TButtonLayout)(((SYSCALL1) (pSpeedButton_GetLayout))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetLayout)
void
SpeedButton_SetLayout(TSpeedButton AObj, TButtonLayout AValue) {
    GET_FUNC_ADDR(SpeedButton_SetLayout)
    (((SYSCALL2) (pSpeedButton_SetLayout))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetNumGlyphs)
TNumGlyphs
SpeedButton_GetNumGlyphs(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetNumGlyphs)
    return (TNumGlyphs)(((SYSCALL1) (pSpeedButton_GetNumGlyphs))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetNumGlyphs)
void
SpeedButton_SetNumGlyphs(TSpeedButton AObj, TNumGlyphs AValue) {
    GET_FUNC_ADDR(SpeedButton_SetNumGlyphs)
    (((SYSCALL2) (pSpeedButton_SetNumGlyphs))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetParentFont)
BOOL
SpeedButton_GetParentFont(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetParentFont)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetParentFont)
void
SpeedButton_SetParentFont(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetParentFont)
    (((SYSCALL2) (pSpeedButton_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetParentShowHint)
BOOL
SpeedButton_GetParentShowHint(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetParentShowHint)
void
SpeedButton_SetParentShowHint(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetParentShowHint)
    (((SYSCALL2) (pSpeedButton_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetPopupMenu)
TPopupMenu
SpeedButton_GetPopupMenu(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pSpeedButton_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetPopupMenu)
void
SpeedButton_SetPopupMenu(TSpeedButton AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(SpeedButton_SetPopupMenu)
    (((SYSCALL2) (pSpeedButton_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetShowHint)
BOOL
SpeedButton_GetShowHint(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetShowHint)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetShowHint)
void
SpeedButton_SetShowHint(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetShowHint)
    (((SYSCALL2) (pSpeedButton_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetSpacing)
int32_t
SpeedButton_GetSpacing(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetSpacing)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetSpacing)
void
SpeedButton_SetSpacing(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetSpacing)
    (((SYSCALL2) (pSpeedButton_SetSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetTransparent)
BOOL
SpeedButton_GetTransparent(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetTransparent)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetTransparent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetTransparent)
void
SpeedButton_SetTransparent(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetTransparent)
    (((SYSCALL2) (pSpeedButton_SetTransparent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetVisible)
BOOL
SpeedButton_GetVisible(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetVisible)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetVisible)
void
SpeedButton_SetVisible(TSpeedButton AObj, BOOL AValue) {
    GET_FUNC_ADDR(SpeedButton_SetVisible)
    (((SYSCALL2) (pSpeedButton_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnClick)
void
SpeedButton_SetOnClick(TSpeedButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnClick)
    (((SYSCALL2) (pSpeedButton_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnDblClick)
void
SpeedButton_SetOnDblClick(TSpeedButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnDblClick)
    (((SYSCALL2) (pSpeedButton_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnMouseDown)
void
SpeedButton_SetOnMouseDown(TSpeedButton AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnMouseDown)
    (((SYSCALL2) (pSpeedButton_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnMouseEnter)
void
SpeedButton_SetOnMouseEnter(TSpeedButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnMouseEnter)
    (((SYSCALL2) (pSpeedButton_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnMouseLeave)
void
SpeedButton_SetOnMouseLeave(TSpeedButton AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnMouseLeave)
    (((SYSCALL2) (pSpeedButton_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnMouseMove)
void
SpeedButton_SetOnMouseMove(TSpeedButton AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnMouseMove)
    (((SYSCALL2) (pSpeedButton_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_SetOnMouseUp)
void
SpeedButton_SetOnMouseUp(TSpeedButton AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(SpeedButton_SetOnMouseUp)
    (((SYSCALL2) (pSpeedButton_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SpeedButton_GetBoundsRect)
TRect
SpeedButton_GetBoundsRect(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pSpeedButton_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_SetBoundsRect)
void
SpeedButton_SetBoundsRect(TSpeedButton AObj, TRect AValue) {
    GET_FUNC_ADDR(SpeedButton_SetBoundsRect)
    (((SYSCALL2) (pSpeedButton_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetClientHeight)
int32_t
SpeedButton_GetClientHeight(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetClientHeight)
void
SpeedButton_SetClientHeight(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetClientHeight)
    (((SYSCALL2) (pSpeedButton_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetClientOrigin)
TPoint
SpeedButton_GetClientOrigin(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pSpeedButton_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_GetClientRect)
TRect
SpeedButton_GetClientRect(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetClientRect)
    TRect result;
    (((SYSCALL2) (pSpeedButton_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(SpeedButton_GetClientWidth)
int32_t
SpeedButton_GetClientWidth(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetClientWidth)
void
SpeedButton_SetClientWidth(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetClientWidth)
    (((SYSCALL2) (pSpeedButton_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetControlState)
TControlState
SpeedButton_GetControlState(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetControlState)
    return (TControlState)(((SYSCALL1) (pSpeedButton_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetControlState)
void
SpeedButton_SetControlState(TSpeedButton AObj, TControlState AValue) {
    GET_FUNC_ADDR(SpeedButton_SetControlState)
    (((SYSCALL2) (pSpeedButton_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetControlStyle)
TControlStyle
SpeedButton_GetControlStyle(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pSpeedButton_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetControlStyle)
void
SpeedButton_SetControlStyle(TSpeedButton AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(SpeedButton_SetControlStyle)
    (((SYSCALL2) (pSpeedButton_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetFloating)
BOOL
SpeedButton_GetFloating(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetFloating)
    return (BOOL)(((SYSCALL1) (pSpeedButton_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_GetParent)
TWinControl
SpeedButton_GetParent(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetParent)
    return (TWinControl)(((SYSCALL1) (pSpeedButton_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetParent)
void
SpeedButton_SetParent(TSpeedButton AObj, TWinControl AValue) {
    GET_FUNC_ADDR(SpeedButton_SetParent)
    (((SYSCALL2) (pSpeedButton_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetLeft)
int32_t
SpeedButton_GetLeft(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetLeft)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetLeft)
void
SpeedButton_SetLeft(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetLeft)
    (((SYSCALL2) (pSpeedButton_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetTop)
int32_t
SpeedButton_GetTop(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetTop)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetTop)
void
SpeedButton_SetTop(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetTop)
    (((SYSCALL2) (pSpeedButton_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetWidth)
int32_t
SpeedButton_GetWidth(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetWidth)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetWidth)
void
SpeedButton_SetWidth(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetWidth)
    (((SYSCALL2) (pSpeedButton_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetHeight)
int32_t
SpeedButton_GetHeight(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetHeight)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetHeight)
void
SpeedButton_SetHeight(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetHeight)
    (((SYSCALL2) (pSpeedButton_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetCursor)
TCursor
SpeedButton_GetCursor(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetCursor)
    return (TCursor)(((SYSCALL1) (pSpeedButton_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetCursor)
void
SpeedButton_SetCursor(TSpeedButton AObj, TCursor AValue) {
    GET_FUNC_ADDR(SpeedButton_SetCursor)
    (((SYSCALL2) (pSpeedButton_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetHint)
char*
SpeedButton_GetHint(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetHint)
    return (char*)(((SYSCALL1) (pSpeedButton_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetHint)
void
SpeedButton_SetHint(TSpeedButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SpeedButton_SetHint)
    (((SYSCALL2) (pSpeedButton_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetComponentCount)
int32_t
SpeedButton_GetComponentCount(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_GetComponentIndex)
int32_t
SpeedButton_GetComponentIndex(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pSpeedButton_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetComponentIndex)
void
SpeedButton_SetComponentIndex(TSpeedButton AObj, int32_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetComponentIndex)
    (((SYSCALL2) (pSpeedButton_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetOwner)
TComponent
SpeedButton_GetOwner(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetOwner)
    return (TComponent)(((SYSCALL1) (pSpeedButton_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_GetName)
char*
SpeedButton_GetName(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetName)
    return (char*)(((SYSCALL1) (pSpeedButton_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetName)
void
SpeedButton_SetName(TSpeedButton AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SpeedButton_SetName)
    (((SYSCALL2) (pSpeedButton_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetTag)
intptr_t
SpeedButton_GetTag(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetTag)
    return (intptr_t)(((SYSCALL1) (pSpeedButton_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetTag)
void
SpeedButton_SetTag(TSpeedButton AObj, intptr_t AValue) {
    GET_FUNC_ADDR(SpeedButton_SetTag)
    (((SYSCALL2) (pSpeedButton_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchorSideLeft)
TAnchorSide
SpeedButton_GetAnchorSideLeft(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pSpeedButton_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAnchorSideLeft)
void
SpeedButton_SetAnchorSideLeft(TSpeedButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAnchorSideLeft)
    (((SYSCALL2) (pSpeedButton_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchorSideTop)
TAnchorSide
SpeedButton_GetAnchorSideTop(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pSpeedButton_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAnchorSideTop)
void
SpeedButton_SetAnchorSideTop(TSpeedButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAnchorSideTop)
    (((SYSCALL2) (pSpeedButton_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchorSideRight)
TAnchorSide
SpeedButton_GetAnchorSideRight(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pSpeedButton_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAnchorSideRight)
void
SpeedButton_SetAnchorSideRight(TSpeedButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAnchorSideRight)
    (((SYSCALL2) (pSpeedButton_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchorSideBottom)
TAnchorSide
SpeedButton_GetAnchorSideBottom(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pSpeedButton_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetAnchorSideBottom)
void
SpeedButton_SetAnchorSideBottom(TSpeedButton AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(SpeedButton_SetAnchorSideBottom)
    (((SYSCALL2) (pSpeedButton_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetBorderSpacing)
TControlBorderSpacing
SpeedButton_GetBorderSpacing(TSpeedButton AObj) {
    GET_FUNC_ADDR(SpeedButton_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pSpeedButton_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SpeedButton_SetBorderSpacing)
void
SpeedButton_SetBorderSpacing(TSpeedButton AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(SpeedButton_SetBorderSpacing)
    (((SYSCALL2) (pSpeedButton_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SpeedButton_GetComponents)
TComponent
SpeedButton_GetComponents(TSpeedButton AObj, int32_t AIndex) {
    GET_FUNC_ADDR(SpeedButton_GetComponents)
    return (TComponent)(((SYSCALL2) (pSpeedButton_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(SpeedButton_GetAnchorSide)
TAnchorSide
SpeedButton_GetAnchorSide(TSpeedButton AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(SpeedButton_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pSpeedButton_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(SpeedButton_StaticClassType)
TClass
SpeedButton_StaticClassType() {
    GET_FUNC_ADDR(SpeedButton_StaticClassType)
    return (TClass)(((SYSCALL0) (pSpeedButton_StaticClassType))());
}

// -------------------TSplitter-------------------

DEFINE_FUNC_PTR(Splitter_Create)
TSplitter
Splitter_Create(TComponent AOwner) {
    GET_FUNC_ADDR(Splitter_Create)
    return (TSplitter)(((SYSCALL1) (pSplitter_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(Splitter_Free)
void
Splitter_Free(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Free)
    (((SYSCALL1) (pSplitter_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_BringToFront)
void
Splitter_BringToFront(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_BringToFront)
    (((SYSCALL1) (pSplitter_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_ClientToScreen)
TPoint
Splitter_ClientToScreen(TSplitter AObj, TPoint Point) {
    GET_FUNC_ADDR(Splitter_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pSplitter_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_ClientToParent)
TPoint
Splitter_ClientToParent(TSplitter AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Splitter_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pSplitter_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_Dragging)
BOOL
Splitter_Dragging(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Dragging)
    return (BOOL)(((SYSCALL1) (pSplitter_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_HasParent)
BOOL
Splitter_HasParent(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_HasParent)
    return (BOOL)(((SYSCALL1) (pSplitter_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Hide)
void
Splitter_Hide(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Hide)
    (((SYSCALL1) (pSplitter_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Invalidate)
void
Splitter_Invalidate(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Invalidate)
    (((SYSCALL1) (pSplitter_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Perform)
intptr_t
Splitter_Perform(TSplitter AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(Splitter_Perform)
    return (intptr_t)(((SYSCALL4) (pSplitter_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(Splitter_Refresh)
void
Splitter_Refresh(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Refresh)
    (((SYSCALL1) (pSplitter_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Repaint)
void
Splitter_Repaint(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Repaint)
    (((SYSCALL1) (pSplitter_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_ScreenToClient)
TPoint
Splitter_ScreenToClient(TSplitter AObj, TPoint Point) {
    GET_FUNC_ADDR(Splitter_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pSplitter_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_ParentToClient)
TPoint
Splitter_ParentToClient(TSplitter AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(Splitter_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pSplitter_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_SendToBack)
void
Splitter_SendToBack(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_SendToBack)
    (((SYSCALL1) (pSplitter_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetBounds)
void
Splitter_SetBounds(TSplitter AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(Splitter_SetBounds)
    (((SYSCALL5) (pSplitter_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(Splitter_Show)
void
Splitter_Show(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Show)
    (((SYSCALL1) (pSplitter_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Update)
void
Splitter_Update(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_Update)
    (((SYSCALL1) (pSplitter_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_GetTextBuf)
int32_t
Splitter_GetTextBuf(TSplitter AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(Splitter_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pSplitter_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(Splitter_GetTextLen)
int32_t
Splitter_GetTextLen(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetTextLen)
    return (int32_t)(((SYSCALL1) (pSplitter_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetTextBuf)
void
Splitter_SetTextBuf(TSplitter AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(Splitter_SetTextBuf)
    (((SYSCALL2) (pSplitter_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(Splitter_FindComponent)
TComponent
Splitter_FindComponent(TSplitter AObj, CChar char* AName) {
    GET_FUNC_ADDR(Splitter_FindComponent)
    return (TComponent)(((SYSCALL2) (pSplitter_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(Splitter_GetNamePath)
char*
Splitter_GetNamePath(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetNamePath)
    return (char*)(((SYSCALL1) (pSplitter_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_Assign)
void
Splitter_Assign(TSplitter AObj, TObject Source) {
    GET_FUNC_ADDR(Splitter_Assign)
    (((SYSCALL2) (pSplitter_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(Splitter_ClassType)
TClass
Splitter_ClassType(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_ClassType)
    return (TClass)(((SYSCALL1) (pSplitter_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_ClassName)
char*
Splitter_ClassName(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_ClassName)
    return (char*)(((SYSCALL1) (pSplitter_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_InstanceSize)
int32_t
Splitter_InstanceSize(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_InstanceSize)
    return (int32_t)(((SYSCALL1) (pSplitter_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_InheritsFrom)
BOOL
Splitter_InheritsFrom(TSplitter AObj, TClass AClass) {
    GET_FUNC_ADDR(Splitter_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pSplitter_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(Splitter_Equals)
BOOL
Splitter_Equals(TSplitter AObj, TObject Obj) {
    GET_FUNC_ADDR(Splitter_Equals)
    return (BOOL)(((SYSCALL2) (pSplitter_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(Splitter_GetHashCode)
int32_t
Splitter_GetHashCode(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetHashCode)
    return (int32_t)(((SYSCALL1) (pSplitter_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_ToString)
char*
Splitter_ToString(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_ToString)
    return (char*)(((SYSCALL1) (pSplitter_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_AnchorToNeighbour)
void
Splitter_AnchorToNeighbour(TSplitter AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Splitter_AnchorToNeighbour)
    (((SYSCALL4) (pSplitter_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Splitter_AnchorParallel)
void
Splitter_AnchorParallel(TSplitter AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(Splitter_AnchorParallel)
    (((SYSCALL4) (pSplitter_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Splitter_AnchorHorizontalCenterTo)
void
Splitter_AnchorHorizontalCenterTo(TSplitter AObj, TControl ASibling) {
    GET_FUNC_ADDR(Splitter_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pSplitter_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Splitter_AnchorVerticalCenterTo)
void
Splitter_AnchorVerticalCenterTo(TSplitter AObj, TControl ASibling) {
    GET_FUNC_ADDR(Splitter_AnchorVerticalCenterTo)
    (((SYSCALL2) (pSplitter_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Splitter_AnchorSame)
void
Splitter_AnchorSame(TSplitter AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(Splitter_AnchorSame)
    (((SYSCALL3) (pSplitter_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(Splitter_AnchorAsAlign)
void
Splitter_AnchorAsAlign(TSplitter AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(Splitter_AnchorAsAlign)
    (((SYSCALL3) (pSplitter_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Splitter_AnchorClient)
void
Splitter_AnchorClient(TSplitter AObj, int32_t ASpace) {
    GET_FUNC_ADDR(Splitter_AnchorClient)
    (((SYSCALL2) (pSplitter_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(Splitter_ScaleDesignToForm)
int32_t
Splitter_ScaleDesignToForm(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleFormToDesign)
int32_t
Splitter_ScaleFormToDesign(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_Scale96ToForm)
int32_t
Splitter_Scale96ToForm(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pSplitter_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleFormTo96)
int32_t
Splitter_ScaleFormTo96(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_Scale96ToFont)
int32_t
Splitter_Scale96ToFont(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pSplitter_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleFontTo96)
int32_t
Splitter_ScaleFontTo96(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleScreenToFont)
int32_t
Splitter_ScaleScreenToFont(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleFontToScreen)
int32_t
Splitter_ScaleFontToScreen(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_Scale96ToScreen)
int32_t
Splitter_Scale96ToScreen(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pSplitter_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_ScaleScreenTo96)
int32_t
Splitter_ScaleScreenTo96(TSplitter AObj, int32_t ASize) {
    GET_FUNC_ADDR(Splitter_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pSplitter_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(Splitter_AutoAdjustLayout)
void
Splitter_AutoAdjustLayout(TSplitter AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(Splitter_AutoAdjustLayout)
    (((SYSCALL6) (pSplitter_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(Splitter_FixDesignFontsPPI)
void
Splitter_FixDesignFontsPPI(TSplitter AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(Splitter_FixDesignFontsPPI)
    (((SYSCALL2) (pSplitter_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(Splitter_ScaleFontsPPI)
void
Splitter_ScaleFontsPPI(TSplitter AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(Splitter_ScaleFontsPPI)
    (((SYSCALL3) (pSplitter_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(Splitter_GetResizeAnchor)
TAnchorKind
Splitter_GetResizeAnchor(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetResizeAnchor)
    return (TAnchorKind)(((SYSCALL1) (pSplitter_GetResizeAnchor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetResizeAnchor)
void
Splitter_SetResizeAnchor(TSplitter AObj, TAnchorKind AValue) {
    GET_FUNC_ADDR(Splitter_SetResizeAnchor)
    (((SYSCALL2) (pSplitter_SetResizeAnchor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetCanvas)
TCanvas
Splitter_GetCanvas(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pSplitter_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_GetAlign)
TAlign
Splitter_GetAlign(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAlign)
    return (TAlign)(((SYSCALL1) (pSplitter_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAlign)
void
Splitter_SetAlign(TSplitter AObj, TAlign AValue) {
    GET_FUNC_ADDR(Splitter_SetAlign)
    (((SYSCALL2) (pSplitter_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetColor)
TColor
Splitter_GetColor(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetColor)
    return (TColor)(((SYSCALL1) (pSplitter_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetColor)
void
Splitter_SetColor(TSplitter AObj, TColor AValue) {
    GET_FUNC_ADDR(Splitter_SetColor)
    (((SYSCALL2) (pSplitter_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetCursor)
TCursor
Splitter_GetCursor(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetCursor)
    return (TCursor)(((SYSCALL1) (pSplitter_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetCursor)
void
Splitter_SetCursor(TSplitter AObj, TCursor AValue) {
    GET_FUNC_ADDR(Splitter_SetCursor)
    (((SYSCALL2) (pSplitter_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetConstraints)
TSizeConstraints
Splitter_GetConstraints(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pSplitter_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetConstraints)
void
Splitter_SetConstraints(TSplitter AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(Splitter_SetConstraints)
    (((SYSCALL2) (pSplitter_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetMinSize)
int32_t
Splitter_GetMinSize(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetMinSize)
    return (int32_t)(((SYSCALL1) (pSplitter_GetMinSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetMinSize)
void
Splitter_SetMinSize(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetMinSize)
    (((SYSCALL2) (pSplitter_SetMinSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetParentColor)
BOOL
Splitter_GetParentColor(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetParentColor)
    return (BOOL)(((SYSCALL1) (pSplitter_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetParentColor)
void
Splitter_SetParentColor(TSplitter AObj, BOOL AValue) {
    GET_FUNC_ADDR(Splitter_SetParentColor)
    (((SYSCALL2) (pSplitter_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetVisible)
BOOL
Splitter_GetVisible(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetVisible)
    return (BOOL)(((SYSCALL1) (pSplitter_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetVisible)
void
Splitter_SetVisible(TSplitter AObj, BOOL AValue) {
    GET_FUNC_ADDR(Splitter_SetVisible)
    (((SYSCALL2) (pSplitter_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetWidth)
int32_t
Splitter_GetWidth(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetWidth)
    return (int32_t)(((SYSCALL1) (pSplitter_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetWidth)
void
Splitter_SetWidth(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetWidth)
    (((SYSCALL2) (pSplitter_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_SetOnPaint)
void
Splitter_SetOnPaint(TSplitter AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(Splitter_SetOnPaint)
    (((SYSCALL2) (pSplitter_SetOnPaint))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(Splitter_GetEnabled)
BOOL
Splitter_GetEnabled(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetEnabled)
    return (BOOL)(((SYSCALL1) (pSplitter_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetEnabled)
void
Splitter_SetEnabled(TSplitter AObj, BOOL AValue) {
    GET_FUNC_ADDR(Splitter_SetEnabled)
    (((SYSCALL2) (pSplitter_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAction)
TAction
Splitter_GetAction(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAction)
    return (TAction)(((SYSCALL1) (pSplitter_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAction)
void
Splitter_SetAction(TSplitter AObj, TAction AValue) {
    GET_FUNC_ADDR(Splitter_SetAction)
    (((SYSCALL2) (pSplitter_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchors)
TAnchors
Splitter_GetAnchors(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pSplitter_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAnchors)
void
Splitter_SetAnchors(TSplitter AObj, TAnchors AValue) {
    GET_FUNC_ADDR(Splitter_SetAnchors)
    (((SYSCALL2) (pSplitter_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetBiDiMode)
TBiDiMode
Splitter_GetBiDiMode(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pSplitter_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetBiDiMode)
void
Splitter_SetBiDiMode(TSplitter AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(Splitter_SetBiDiMode)
    (((SYSCALL2) (pSplitter_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetBoundsRect)
TRect
Splitter_GetBoundsRect(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pSplitter_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_SetBoundsRect)
void
Splitter_SetBoundsRect(TSplitter AObj, TRect AValue) {
    GET_FUNC_ADDR(Splitter_SetBoundsRect)
    (((SYSCALL2) (pSplitter_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetClientHeight)
int32_t
Splitter_GetClientHeight(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pSplitter_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetClientHeight)
void
Splitter_SetClientHeight(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetClientHeight)
    (((SYSCALL2) (pSplitter_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetClientOrigin)
TPoint
Splitter_GetClientOrigin(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pSplitter_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_GetClientRect)
TRect
Splitter_GetClientRect(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetClientRect)
    TRect result;
    (((SYSCALL2) (pSplitter_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(Splitter_GetClientWidth)
int32_t
Splitter_GetClientWidth(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pSplitter_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetClientWidth)
void
Splitter_SetClientWidth(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetClientWidth)
    (((SYSCALL2) (pSplitter_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetControlState)
TControlState
Splitter_GetControlState(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetControlState)
    return (TControlState)(((SYSCALL1) (pSplitter_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetControlState)
void
Splitter_SetControlState(TSplitter AObj, TControlState AValue) {
    GET_FUNC_ADDR(Splitter_SetControlState)
    (((SYSCALL2) (pSplitter_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetControlStyle)
TControlStyle
Splitter_GetControlStyle(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pSplitter_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetControlStyle)
void
Splitter_SetControlStyle(TSplitter AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(Splitter_SetControlStyle)
    (((SYSCALL2) (pSplitter_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetFloating)
BOOL
Splitter_GetFloating(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetFloating)
    return (BOOL)(((SYSCALL1) (pSplitter_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_GetShowHint)
BOOL
Splitter_GetShowHint(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetShowHint)
    return (BOOL)(((SYSCALL1) (pSplitter_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetShowHint)
void
Splitter_SetShowHint(TSplitter AObj, BOOL AValue) {
    GET_FUNC_ADDR(Splitter_SetShowHint)
    (((SYSCALL2) (pSplitter_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetParent)
TWinControl
Splitter_GetParent(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetParent)
    return (TWinControl)(((SYSCALL1) (pSplitter_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetParent)
void
Splitter_SetParent(TSplitter AObj, TWinControl AValue) {
    GET_FUNC_ADDR(Splitter_SetParent)
    (((SYSCALL2) (pSplitter_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetLeft)
int32_t
Splitter_GetLeft(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetLeft)
    return (int32_t)(((SYSCALL1) (pSplitter_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetLeft)
void
Splitter_SetLeft(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetLeft)
    (((SYSCALL2) (pSplitter_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetTop)
int32_t
Splitter_GetTop(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetTop)
    return (int32_t)(((SYSCALL1) (pSplitter_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetTop)
void
Splitter_SetTop(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetTop)
    (((SYSCALL2) (pSplitter_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetHeight)
int32_t
Splitter_GetHeight(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetHeight)
    return (int32_t)(((SYSCALL1) (pSplitter_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetHeight)
void
Splitter_SetHeight(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetHeight)
    (((SYSCALL2) (pSplitter_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetHint)
char*
Splitter_GetHint(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetHint)
    return (char*)(((SYSCALL1) (pSplitter_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetHint)
void
Splitter_SetHint(TSplitter AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Splitter_SetHint)
    (((SYSCALL2) (pSplitter_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetComponentCount)
int32_t
Splitter_GetComponentCount(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pSplitter_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_GetComponentIndex)
int32_t
Splitter_GetComponentIndex(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pSplitter_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetComponentIndex)
void
Splitter_SetComponentIndex(TSplitter AObj, int32_t AValue) {
    GET_FUNC_ADDR(Splitter_SetComponentIndex)
    (((SYSCALL2) (pSplitter_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetOwner)
TComponent
Splitter_GetOwner(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetOwner)
    return (TComponent)(((SYSCALL1) (pSplitter_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_GetName)
char*
Splitter_GetName(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetName)
    return (char*)(((SYSCALL1) (pSplitter_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetName)
void
Splitter_SetName(TSplitter AObj, CChar char* AValue) {
    GET_FUNC_ADDR(Splitter_SetName)
    (((SYSCALL2) (pSplitter_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetTag)
intptr_t
Splitter_GetTag(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetTag)
    return (intptr_t)(((SYSCALL1) (pSplitter_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetTag)
void
Splitter_SetTag(TSplitter AObj, intptr_t AValue) {
    GET_FUNC_ADDR(Splitter_SetTag)
    (((SYSCALL2) (pSplitter_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchorSideLeft)
TAnchorSide
Splitter_GetAnchorSideLeft(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pSplitter_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAnchorSideLeft)
void
Splitter_SetAnchorSideLeft(TSplitter AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Splitter_SetAnchorSideLeft)
    (((SYSCALL2) (pSplitter_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchorSideTop)
TAnchorSide
Splitter_GetAnchorSideTop(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pSplitter_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAnchorSideTop)
void
Splitter_SetAnchorSideTop(TSplitter AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Splitter_SetAnchorSideTop)
    (((SYSCALL2) (pSplitter_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchorSideRight)
TAnchorSide
Splitter_GetAnchorSideRight(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pSplitter_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAnchorSideRight)
void
Splitter_SetAnchorSideRight(TSplitter AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Splitter_SetAnchorSideRight)
    (((SYSCALL2) (pSplitter_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchorSideBottom)
TAnchorSide
Splitter_GetAnchorSideBottom(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pSplitter_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetAnchorSideBottom)
void
Splitter_SetAnchorSideBottom(TSplitter AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(Splitter_SetAnchorSideBottom)
    (((SYSCALL2) (pSplitter_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetBorderSpacing)
TControlBorderSpacing
Splitter_GetBorderSpacing(TSplitter AObj) {
    GET_FUNC_ADDR(Splitter_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pSplitter_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(Splitter_SetBorderSpacing)
void
Splitter_SetBorderSpacing(TSplitter AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(Splitter_SetBorderSpacing)
    (((SYSCALL2) (pSplitter_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(Splitter_GetComponents)
TComponent
Splitter_GetComponents(TSplitter AObj, int32_t AIndex) {
    GET_FUNC_ADDR(Splitter_GetComponents)
    return (TComponent)(((SYSCALL2) (pSplitter_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(Splitter_GetAnchorSide)
TAnchorSide
Splitter_GetAnchorSide(TSplitter AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(Splitter_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pSplitter_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(Splitter_StaticClassType)
TClass
Splitter_StaticClassType() {
    GET_FUNC_ADDR(Splitter_StaticClassType)
    return (TClass)(((SYSCALL0) (pSplitter_StaticClassType))());
}

// -------------------TRadioGroup-------------------

DEFINE_FUNC_PTR(RadioGroup_Create)
TRadioGroup
RadioGroup_Create(TComponent AOwner) {
    GET_FUNC_ADDR(RadioGroup_Create)
    return (TRadioGroup)(((SYSCALL1) (pRadioGroup_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(RadioGroup_Free)
void
RadioGroup_Free(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Free)
    (((SYSCALL1) (pRadioGroup_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_FlipChildren)
void
RadioGroup_FlipChildren(TRadioGroup AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(RadioGroup_FlipChildren)
    (((SYSCALL2) (pRadioGroup_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(RadioGroup_CanFocus)
BOOL
RadioGroup_CanFocus(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_CanFocus)
    return (BOOL)(((SYSCALL1) (pRadioGroup_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ContainsControl)
BOOL
RadioGroup_ContainsControl(TRadioGroup AObj, TControl Control) {
    GET_FUNC_ADDR(RadioGroup_ContainsControl)
    return (BOOL)(((SYSCALL2) (pRadioGroup_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(RadioGroup_ControlAtPos)
TControl
RadioGroup_ControlAtPos(TRadioGroup AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(RadioGroup_ControlAtPos)
    return (TControl)(((SYSCALL4) (pRadioGroup_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(RadioGroup_DisableAlign)
void
RadioGroup_DisableAlign(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_DisableAlign)
    (((SYSCALL1) (pRadioGroup_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_EnableAlign)
void
RadioGroup_EnableAlign(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_EnableAlign)
    (((SYSCALL1) (pRadioGroup_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_FindChildControl)
TControl
RadioGroup_FindChildControl(TRadioGroup AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(RadioGroup_FindChildControl)
    return (TControl)(((SYSCALL2) (pRadioGroup_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(RadioGroup_Focused)
BOOL
RadioGroup_Focused(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Focused)
    return (BOOL)(((SYSCALL1) (pRadioGroup_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_HandleAllocated)
BOOL
RadioGroup_HandleAllocated(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pRadioGroup_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_InsertControl)
void
RadioGroup_InsertControl(TRadioGroup AObj, TControl AControl) {
    GET_FUNC_ADDR(RadioGroup_InsertControl)
    (((SYSCALL2) (pRadioGroup_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RadioGroup_Invalidate)
void
RadioGroup_Invalidate(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Invalidate)
    (((SYSCALL1) (pRadioGroup_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_PaintTo)
void
RadioGroup_PaintTo(TRadioGroup AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(RadioGroup_PaintTo)
    (((SYSCALL4) (pRadioGroup_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(RadioGroup_RemoveControl)
void
RadioGroup_RemoveControl(TRadioGroup AObj, TControl AControl) {
    GET_FUNC_ADDR(RadioGroup_RemoveControl)
    (((SYSCALL2) (pRadioGroup_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RadioGroup_Realign)
void
RadioGroup_Realign(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Realign)
    (((SYSCALL1) (pRadioGroup_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Repaint)
void
RadioGroup_Repaint(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Repaint)
    (((SYSCALL1) (pRadioGroup_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleBy)
void
RadioGroup_ScaleBy(TRadioGroup AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(RadioGroup_ScaleBy)
    (((SYSCALL3) (pRadioGroup_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(RadioGroup_ScrollBy)
void
RadioGroup_ScrollBy(TRadioGroup AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(RadioGroup_ScrollBy)
    (((SYSCALL3) (pRadioGroup_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(RadioGroup_SetBounds)
void
RadioGroup_SetBounds(TRadioGroup AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(RadioGroup_SetBounds)
    (((SYSCALL5) (pRadioGroup_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(RadioGroup_SetFocus)
void
RadioGroup_SetFocus(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_SetFocus)
    (((SYSCALL1) (pRadioGroup_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Update)
void
RadioGroup_Update(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Update)
    (((SYSCALL1) (pRadioGroup_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_BringToFront)
void
RadioGroup_BringToFront(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_BringToFront)
    (((SYSCALL1) (pRadioGroup_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ClientToScreen)
TPoint
RadioGroup_ClientToScreen(TRadioGroup AObj, TPoint Point) {
    GET_FUNC_ADDR(RadioGroup_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pRadioGroup_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_ClientToParent)
TPoint
RadioGroup_ClientToParent(TRadioGroup AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RadioGroup_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pRadioGroup_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_Dragging)
BOOL
RadioGroup_Dragging(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Dragging)
    return (BOOL)(((SYSCALL1) (pRadioGroup_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_HasParent)
BOOL
RadioGroup_HasParent(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_HasParent)
    return (BOOL)(((SYSCALL1) (pRadioGroup_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Hide)
void
RadioGroup_Hide(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Hide)
    (((SYSCALL1) (pRadioGroup_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Perform)
intptr_t
RadioGroup_Perform(TRadioGroup AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(RadioGroup_Perform)
    return (intptr_t)(((SYSCALL4) (pRadioGroup_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(RadioGroup_Refresh)
void
RadioGroup_Refresh(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Refresh)
    (((SYSCALL1) (pRadioGroup_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ScreenToClient)
TPoint
RadioGroup_ScreenToClient(TRadioGroup AObj, TPoint Point) {
    GET_FUNC_ADDR(RadioGroup_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pRadioGroup_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_ParentToClient)
TPoint
RadioGroup_ParentToClient(TRadioGroup AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RadioGroup_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pRadioGroup_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_SendToBack)
void
RadioGroup_SendToBack(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_SendToBack)
    (((SYSCALL1) (pRadioGroup_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Show)
void
RadioGroup_Show(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_Show)
    (((SYSCALL1) (pRadioGroup_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTextBuf)
int32_t
RadioGroup_GetTextBuf(TRadioGroup AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(RadioGroup_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pRadioGroup_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTextLen)
int32_t
RadioGroup_GetTextLen(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetTextLen)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetTextBuf)
void
RadioGroup_SetTextBuf(TRadioGroup AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(RadioGroup_SetTextBuf)
    (((SYSCALL2) (pRadioGroup_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(RadioGroup_FindComponent)
TComponent
RadioGroup_FindComponent(TRadioGroup AObj, CChar char* AName) {
    GET_FUNC_ADDR(RadioGroup_FindComponent)
    return (TComponent)(((SYSCALL2) (pRadioGroup_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(RadioGroup_GetNamePath)
char*
RadioGroup_GetNamePath(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetNamePath)
    return (char*)(((SYSCALL1) (pRadioGroup_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_Assign)
void
RadioGroup_Assign(TRadioGroup AObj, TObject Source) {
    GET_FUNC_ADDR(RadioGroup_Assign)
    (((SYSCALL2) (pRadioGroup_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(RadioGroup_ClassType)
TClass
RadioGroup_ClassType(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_ClassType)
    return (TClass)(((SYSCALL1) (pRadioGroup_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ClassName)
char*
RadioGroup_ClassName(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_ClassName)
    return (char*)(((SYSCALL1) (pRadioGroup_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_InstanceSize)
int32_t
RadioGroup_InstanceSize(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_InstanceSize)
    return (int32_t)(((SYSCALL1) (pRadioGroup_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_InheritsFrom)
BOOL
RadioGroup_InheritsFrom(TRadioGroup AObj, TClass AClass) {
    GET_FUNC_ADDR(RadioGroup_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pRadioGroup_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(RadioGroup_Equals)
BOOL
RadioGroup_Equals(TRadioGroup AObj, TObject Obj) {
    GET_FUNC_ADDR(RadioGroup_Equals)
    return (BOOL)(((SYSCALL2) (pRadioGroup_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetHashCode)
int32_t
RadioGroup_GetHashCode(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetHashCode)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_ToString)
char*
RadioGroup_ToString(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_ToString)
    return (char*)(((SYSCALL1) (pRadioGroup_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorToNeighbour)
void
RadioGroup_AnchorToNeighbour(TRadioGroup AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RadioGroup_AnchorToNeighbour)
    (((SYSCALL4) (pRadioGroup_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorParallel)
void
RadioGroup_AnchorParallel(TRadioGroup AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RadioGroup_AnchorParallel)
    (((SYSCALL4) (pRadioGroup_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorHorizontalCenterTo)
void
RadioGroup_AnchorHorizontalCenterTo(TRadioGroup AObj, TControl ASibling) {
    GET_FUNC_ADDR(RadioGroup_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pRadioGroup_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorVerticalCenterTo)
void
RadioGroup_AnchorVerticalCenterTo(TRadioGroup AObj, TControl ASibling) {
    GET_FUNC_ADDR(RadioGroup_AnchorVerticalCenterTo)
    (((SYSCALL2) (pRadioGroup_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorSame)
void
RadioGroup_AnchorSame(TRadioGroup AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(RadioGroup_AnchorSame)
    (((SYSCALL3) (pRadioGroup_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorAsAlign)
void
RadioGroup_AnchorAsAlign(TRadioGroup AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(RadioGroup_AnchorAsAlign)
    (((SYSCALL3) (pRadioGroup_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RadioGroup_AnchorClient)
void
RadioGroup_AnchorClient(TRadioGroup AObj, int32_t ASpace) {
    GET_FUNC_ADDR(RadioGroup_AnchorClient)
    (((SYSCALL2) (pRadioGroup_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleDesignToForm)
int32_t
RadioGroup_ScaleDesignToForm(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleFormToDesign)
int32_t
RadioGroup_ScaleFormToDesign(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_Scale96ToForm)
int32_t
RadioGroup_Scale96ToForm(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pRadioGroup_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleFormTo96)
int32_t
RadioGroup_ScaleFormTo96(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_Scale96ToFont)
int32_t
RadioGroup_Scale96ToFont(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pRadioGroup_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleFontTo96)
int32_t
RadioGroup_ScaleFontTo96(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleScreenToFont)
int32_t
RadioGroup_ScaleScreenToFont(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleFontToScreen)
int32_t
RadioGroup_ScaleFontToScreen(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_Scale96ToScreen)
int32_t
RadioGroup_Scale96ToScreen(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pRadioGroup_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleScreenTo96)
int32_t
RadioGroup_ScaleScreenTo96(TRadioGroup AObj, int32_t ASize) {
    GET_FUNC_ADDR(RadioGroup_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pRadioGroup_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RadioGroup_AutoAdjustLayout)
void
RadioGroup_AutoAdjustLayout(TRadioGroup AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(RadioGroup_AutoAdjustLayout)
    (((SYSCALL6) (pRadioGroup_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(RadioGroup_FixDesignFontsPPI)
void
RadioGroup_FixDesignFontsPPI(TRadioGroup AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(RadioGroup_FixDesignFontsPPI)
    (((SYSCALL2) (pRadioGroup_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(RadioGroup_ScaleFontsPPI)
void
RadioGroup_ScaleFontsPPI(TRadioGroup AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(RadioGroup_ScaleFontsPPI)
    (((SYSCALL3) (pRadioGroup_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnSelectionChanged)
void
RadioGroup_SetOnSelectionChanged(TRadioGroup AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnSelectionChanged)
    (((SYSCALL2) (pRadioGroup_SetOnSelectionChanged))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAlign)
TAlign
RadioGroup_GetAlign(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAlign)
    return (TAlign)(((SYSCALL1) (pRadioGroup_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAlign)
void
RadioGroup_SetAlign(TRadioGroup AObj, TAlign AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAlign)
    (((SYSCALL2) (pRadioGroup_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchors)
TAnchors
RadioGroup_GetAnchors(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pRadioGroup_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAnchors)
void
RadioGroup_SetAnchors(TRadioGroup AObj, TAnchors AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAnchors)
    (((SYSCALL2) (pRadioGroup_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetBiDiMode)
TBiDiMode
RadioGroup_GetBiDiMode(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pRadioGroup_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetBiDiMode)
void
RadioGroup_SetBiDiMode(TRadioGroup AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(RadioGroup_SetBiDiMode)
    (((SYSCALL2) (pRadioGroup_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetCaption)
char*
RadioGroup_GetCaption(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetCaption)
    return (char*)(((SYSCALL1) (pRadioGroup_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetCaption)
void
RadioGroup_SetCaption(TRadioGroup AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioGroup_SetCaption)
    (((SYSCALL2) (pRadioGroup_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetColor)
TColor
RadioGroup_GetColor(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetColor)
    return (TColor)(((SYSCALL1) (pRadioGroup_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetColor)
void
RadioGroup_SetColor(TRadioGroup AObj, TColor AValue) {
    GET_FUNC_ADDR(RadioGroup_SetColor)
    (((SYSCALL2) (pRadioGroup_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetColumns)
int32_t
RadioGroup_GetColumns(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetColumns)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetColumns))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetColumns)
void
RadioGroup_SetColumns(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetColumns)
    (((SYSCALL2) (pRadioGroup_SetColumns))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDoubleBuffered)
BOOL
RadioGroup_GetDoubleBuffered(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetDoubleBuffered)
void
RadioGroup_SetDoubleBuffered(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetDoubleBuffered)
    (((SYSCALL2) (pRadioGroup_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDragCursor)
TCursor
RadioGroup_GetDragCursor(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pRadioGroup_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetDragCursor)
void
RadioGroup_SetDragCursor(TRadioGroup AObj, TCursor AValue) {
    GET_FUNC_ADDR(RadioGroup_SetDragCursor)
    (((SYSCALL2) (pRadioGroup_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDragMode)
TDragMode
RadioGroup_GetDragMode(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pRadioGroup_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetDragMode)
void
RadioGroup_SetDragMode(TRadioGroup AObj, TDragMode AValue) {
    GET_FUNC_ADDR(RadioGroup_SetDragMode)
    (((SYSCALL2) (pRadioGroup_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetEnabled)
BOOL
RadioGroup_GetEnabled(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetEnabled)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetEnabled)
void
RadioGroup_SetEnabled(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetEnabled)
    (((SYSCALL2) (pRadioGroup_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetFont)
TFont
RadioGroup_GetFont(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetFont)
    return (TFont)(((SYSCALL1) (pRadioGroup_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetFont)
void
RadioGroup_SetFont(TRadioGroup AObj, TFont AValue) {
    GET_FUNC_ADDR(RadioGroup_SetFont)
    (((SYSCALL2) (pRadioGroup_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetItemIndex)
int32_t
RadioGroup_GetItemIndex(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetItemIndex)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetItemIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetItemIndex)
void
RadioGroup_SetItemIndex(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetItemIndex)
    (((SYSCALL2) (pRadioGroup_SetItemIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetItems)
TStrings
RadioGroup_GetItems(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetItems)
    return (TStrings)(((SYSCALL1) (pRadioGroup_GetItems))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetItems)
void
RadioGroup_SetItems(TRadioGroup AObj, TStrings AValue) {
    GET_FUNC_ADDR(RadioGroup_SetItems)
    (((SYSCALL2) (pRadioGroup_SetItems))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetConstraints)
TSizeConstraints
RadioGroup_GetConstraints(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pRadioGroup_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetConstraints)
void
RadioGroup_SetConstraints(TRadioGroup AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(RadioGroup_SetConstraints)
    (((SYSCALL2) (pRadioGroup_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentBackground)
BOOL
RadioGroup_GetParentBackground(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentBackground)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetParentBackground))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentBackground)
void
RadioGroup_SetParentBackground(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentBackground)
    (((SYSCALL2) (pRadioGroup_SetParentBackground))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentColor)
BOOL
RadioGroup_GetParentColor(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentColor)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentColor)
void
RadioGroup_SetParentColor(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentColor)
    (((SYSCALL2) (pRadioGroup_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentDoubleBuffered)
BOOL
RadioGroup_GetParentDoubleBuffered(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentDoubleBuffered)
void
RadioGroup_SetParentDoubleBuffered(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentDoubleBuffered)
    (((SYSCALL2) (pRadioGroup_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentFont)
BOOL
RadioGroup_GetParentFont(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentFont)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentFont)
void
RadioGroup_SetParentFont(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentFont)
    (((SYSCALL2) (pRadioGroup_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentShowHint)
BOOL
RadioGroup_GetParentShowHint(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentShowHint)
void
RadioGroup_SetParentShowHint(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentShowHint)
    (((SYSCALL2) (pRadioGroup_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetPopupMenu)
TPopupMenu
RadioGroup_GetPopupMenu(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pRadioGroup_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetPopupMenu)
void
RadioGroup_SetPopupMenu(TRadioGroup AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(RadioGroup_SetPopupMenu)
    (((SYSCALL2) (pRadioGroup_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetShowHint)
BOOL
RadioGroup_GetShowHint(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetShowHint)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetShowHint)
void
RadioGroup_SetShowHint(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetShowHint)
    (((SYSCALL2) (pRadioGroup_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTabOrder)
TTabOrder
RadioGroup_GetTabOrder(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pRadioGroup_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetTabOrder)
void
RadioGroup_SetTabOrder(TRadioGroup AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(RadioGroup_SetTabOrder)
    (((SYSCALL2) (pRadioGroup_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTabStop)
BOOL
RadioGroup_GetTabStop(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetTabStop)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetTabStop)
void
RadioGroup_SetTabStop(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetTabStop)
    (((SYSCALL2) (pRadioGroup_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetVisible)
BOOL
RadioGroup_GetVisible(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetVisible)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetVisible)
void
RadioGroup_SetVisible(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetVisible)
    (((SYSCALL2) (pRadioGroup_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnClick)
void
RadioGroup_SetOnClick(TRadioGroup AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnClick)
    (((SYSCALL2) (pRadioGroup_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnDragDrop)
void
RadioGroup_SetOnDragDrop(TRadioGroup AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnDragDrop)
    (((SYSCALL2) (pRadioGroup_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnDragOver)
void
RadioGroup_SetOnDragOver(TRadioGroup AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnDragOver)
    (((SYSCALL2) (pRadioGroup_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnEndDrag)
void
RadioGroup_SetOnEndDrag(TRadioGroup AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnEndDrag)
    (((SYSCALL2) (pRadioGroup_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnEnter)
void
RadioGroup_SetOnEnter(TRadioGroup AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnEnter)
    (((SYSCALL2) (pRadioGroup_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_SetOnExit)
void
RadioGroup_SetOnExit(TRadioGroup AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RadioGroup_SetOnExit)
    (((SYSCALL2) (pRadioGroup_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDockClientCount)
int32_t
RadioGroup_GetDockClientCount(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDockSite)
BOOL
RadioGroup_GetDockSite(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetDockSite)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetDockSite)
void
RadioGroup_SetDockSite(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetDockSite)
    (((SYSCALL2) (pRadioGroup_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetMouseInClient)
BOOL
RadioGroup_GetMouseInClient(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetVisibleDockClientCount)
int32_t
RadioGroup_GetVisibleDockClientCount(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetBrush)
TBrush
RadioGroup_GetBrush(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetBrush)
    return (TBrush)(((SYSCALL1) (pRadioGroup_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetControlCount)
int32_t
RadioGroup_GetControlCount(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetControlCount)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetHandle)
HWND
RadioGroup_GetHandle(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetHandle)
    return (HWND)(((SYSCALL1) (pRadioGroup_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParentWindow)
HWND
RadioGroup_GetParentWindow(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParentWindow)
    return (HWND)(((SYSCALL1) (pRadioGroup_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParentWindow)
void
RadioGroup_SetParentWindow(TRadioGroup AObj, HWND AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParentWindow)
    (((SYSCALL2) (pRadioGroup_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetShowing)
BOOL
RadioGroup_GetShowing(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetShowing)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetUseDockManager)
BOOL
RadioGroup_GetUseDockManager(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetUseDockManager)
void
RadioGroup_SetUseDockManager(TRadioGroup AObj, BOOL AValue) {
    GET_FUNC_ADDR(RadioGroup_SetUseDockManager)
    (((SYSCALL2) (pRadioGroup_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAction)
TAction
RadioGroup_GetAction(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAction)
    return (TAction)(((SYSCALL1) (pRadioGroup_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAction)
void
RadioGroup_SetAction(TRadioGroup AObj, TAction AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAction)
    (((SYSCALL2) (pRadioGroup_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetBoundsRect)
TRect
RadioGroup_GetBoundsRect(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pRadioGroup_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_SetBoundsRect)
void
RadioGroup_SetBoundsRect(TRadioGroup AObj, TRect AValue) {
    GET_FUNC_ADDR(RadioGroup_SetBoundsRect)
    (((SYSCALL2) (pRadioGroup_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetClientHeight)
int32_t
RadioGroup_GetClientHeight(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetClientHeight)
void
RadioGroup_SetClientHeight(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetClientHeight)
    (((SYSCALL2) (pRadioGroup_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetClientOrigin)
TPoint
RadioGroup_GetClientOrigin(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pRadioGroup_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_GetClientRect)
TRect
RadioGroup_GetClientRect(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetClientRect)
    TRect result;
    (((SYSCALL2) (pRadioGroup_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RadioGroup_GetClientWidth)
int32_t
RadioGroup_GetClientWidth(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetClientWidth)
void
RadioGroup_SetClientWidth(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetClientWidth)
    (((SYSCALL2) (pRadioGroup_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetControlState)
TControlState
RadioGroup_GetControlState(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetControlState)
    return (TControlState)(((SYSCALL1) (pRadioGroup_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetControlState)
void
RadioGroup_SetControlState(TRadioGroup AObj, TControlState AValue) {
    GET_FUNC_ADDR(RadioGroup_SetControlState)
    (((SYSCALL2) (pRadioGroup_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetControlStyle)
TControlStyle
RadioGroup_GetControlStyle(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pRadioGroup_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetControlStyle)
void
RadioGroup_SetControlStyle(TRadioGroup AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(RadioGroup_SetControlStyle)
    (((SYSCALL2) (pRadioGroup_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetFloating)
BOOL
RadioGroup_GetFloating(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetFloating)
    return (BOOL)(((SYSCALL1) (pRadioGroup_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetParent)
TWinControl
RadioGroup_GetParent(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetParent)
    return (TWinControl)(((SYSCALL1) (pRadioGroup_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetParent)
void
RadioGroup_SetParent(TRadioGroup AObj, TWinControl AValue) {
    GET_FUNC_ADDR(RadioGroup_SetParent)
    (((SYSCALL2) (pRadioGroup_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetLeft)
int32_t
RadioGroup_GetLeft(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetLeft)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetLeft)
void
RadioGroup_SetLeft(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetLeft)
    (((SYSCALL2) (pRadioGroup_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTop)
int32_t
RadioGroup_GetTop(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetTop)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetTop)
void
RadioGroup_SetTop(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetTop)
    (((SYSCALL2) (pRadioGroup_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetWidth)
int32_t
RadioGroup_GetWidth(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetWidth)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetWidth)
void
RadioGroup_SetWidth(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetWidth)
    (((SYSCALL2) (pRadioGroup_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetHeight)
int32_t
RadioGroup_GetHeight(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetHeight)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetHeight)
void
RadioGroup_SetHeight(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetHeight)
    (((SYSCALL2) (pRadioGroup_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetCursor)
TCursor
RadioGroup_GetCursor(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetCursor)
    return (TCursor)(((SYSCALL1) (pRadioGroup_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetCursor)
void
RadioGroup_SetCursor(TRadioGroup AObj, TCursor AValue) {
    GET_FUNC_ADDR(RadioGroup_SetCursor)
    (((SYSCALL2) (pRadioGroup_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetHint)
char*
RadioGroup_GetHint(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetHint)
    return (char*)(((SYSCALL1) (pRadioGroup_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetHint)
void
RadioGroup_SetHint(TRadioGroup AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioGroup_SetHint)
    (((SYSCALL2) (pRadioGroup_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetComponentCount)
int32_t
RadioGroup_GetComponentCount(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetComponentIndex)
int32_t
RadioGroup_GetComponentIndex(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pRadioGroup_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetComponentIndex)
void
RadioGroup_SetComponentIndex(TRadioGroup AObj, int32_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetComponentIndex)
    (((SYSCALL2) (pRadioGroup_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetOwner)
TComponent
RadioGroup_GetOwner(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetOwner)
    return (TComponent)(((SYSCALL1) (pRadioGroup_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_GetName)
char*
RadioGroup_GetName(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetName)
    return (char*)(((SYSCALL1) (pRadioGroup_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetName)
void
RadioGroup_SetName(TRadioGroup AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RadioGroup_SetName)
    (((SYSCALL2) (pRadioGroup_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetTag)
intptr_t
RadioGroup_GetTag(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetTag)
    return (intptr_t)(((SYSCALL1) (pRadioGroup_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetTag)
void
RadioGroup_SetTag(TRadioGroup AObj, intptr_t AValue) {
    GET_FUNC_ADDR(RadioGroup_SetTag)
    (((SYSCALL2) (pRadioGroup_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchorSideLeft)
TAnchorSide
RadioGroup_GetAnchorSideLeft(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pRadioGroup_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAnchorSideLeft)
void
RadioGroup_SetAnchorSideLeft(TRadioGroup AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAnchorSideLeft)
    (((SYSCALL2) (pRadioGroup_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchorSideTop)
TAnchorSide
RadioGroup_GetAnchorSideTop(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pRadioGroup_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAnchorSideTop)
void
RadioGroup_SetAnchorSideTop(TRadioGroup AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAnchorSideTop)
    (((SYSCALL2) (pRadioGroup_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchorSideRight)
TAnchorSide
RadioGroup_GetAnchorSideRight(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pRadioGroup_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAnchorSideRight)
void
RadioGroup_SetAnchorSideRight(TRadioGroup AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAnchorSideRight)
    (((SYSCALL2) (pRadioGroup_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchorSideBottom)
TAnchorSide
RadioGroup_GetAnchorSideBottom(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pRadioGroup_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetAnchorSideBottom)
void
RadioGroup_SetAnchorSideBottom(TRadioGroup AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RadioGroup_SetAnchorSideBottom)
    (((SYSCALL2) (pRadioGroup_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetChildSizing)
TControlChildSizing
RadioGroup_GetChildSizing(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pRadioGroup_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetChildSizing)
void
RadioGroup_SetChildSizing(TRadioGroup AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(RadioGroup_SetChildSizing)
    (((SYSCALL2) (pRadioGroup_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetBorderSpacing)
TControlBorderSpacing
RadioGroup_GetBorderSpacing(TRadioGroup AObj) {
    GET_FUNC_ADDR(RadioGroup_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pRadioGroup_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RadioGroup_SetBorderSpacing)
void
RadioGroup_SetBorderSpacing(TRadioGroup AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(RadioGroup_SetBorderSpacing)
    (((SYSCALL2) (pRadioGroup_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RadioGroup_GetDockClients)
TControl
RadioGroup_GetDockClients(TRadioGroup AObj, int32_t Index) {
    GET_FUNC_ADDR(RadioGroup_GetDockClients)
    return (TControl)(((SYSCALL2) (pRadioGroup_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RadioGroup_GetControls)
TControl
RadioGroup_GetControls(TRadioGroup AObj, int32_t Index) {
    GET_FUNC_ADDR(RadioGroup_GetControls)
    return (TControl)(((SYSCALL2) (pRadioGroup_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RadioGroup_GetComponents)
TComponent
RadioGroup_GetComponents(TRadioGroup AObj, int32_t AIndex) {
    GET_FUNC_ADDR(RadioGroup_GetComponents)
    return (TComponent)(((SYSCALL2) (pRadioGroup_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(RadioGroup_GetAnchorSide)
TAnchorSide
RadioGroup_GetAnchorSide(TRadioGroup AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(RadioGroup_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pRadioGroup_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(RadioGroup_StaticClassType)
TClass
RadioGroup_StaticClassType() {
    GET_FUNC_ADDR(RadioGroup_StaticClassType)
    return (TClass)(((SYSCALL0) (pRadioGroup_StaticClassType))());
}

// -------------------TStaticText-------------------

DEFINE_FUNC_PTR(StaticText_Create)
TStaticText
StaticText_Create(TComponent AOwner) {
    GET_FUNC_ADDR(StaticText_Create)
    return (TStaticText)(((SYSCALL1) (pStaticText_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(StaticText_Free)
void
StaticText_Free(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Free)
    (((SYSCALL1) (pStaticText_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_CanFocus)
BOOL
StaticText_CanFocus(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_CanFocus)
    return (BOOL)(((SYSCALL1) (pStaticText_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ContainsControl)
BOOL
StaticText_ContainsControl(TStaticText AObj, TControl Control) {
    GET_FUNC_ADDR(StaticText_ContainsControl)
    return (BOOL)(((SYSCALL2) (pStaticText_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(StaticText_ControlAtPos)
TControl
StaticText_ControlAtPos(TStaticText AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(StaticText_ControlAtPos)
    return (TControl)(((SYSCALL4) (pStaticText_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(StaticText_DisableAlign)
void
StaticText_DisableAlign(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_DisableAlign)
    (((SYSCALL1) (pStaticText_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_EnableAlign)
void
StaticText_EnableAlign(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_EnableAlign)
    (((SYSCALL1) (pStaticText_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_FindChildControl)
TControl
StaticText_FindChildControl(TStaticText AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(StaticText_FindChildControl)
    return (TControl)(((SYSCALL2) (pStaticText_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(StaticText_FlipChildren)
void
StaticText_FlipChildren(TStaticText AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(StaticText_FlipChildren)
    (((SYSCALL2) (pStaticText_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(StaticText_Focused)
BOOL
StaticText_Focused(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Focused)
    return (BOOL)(((SYSCALL1) (pStaticText_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_HandleAllocated)
BOOL
StaticText_HandleAllocated(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pStaticText_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_InsertControl)
void
StaticText_InsertControl(TStaticText AObj, TControl AControl) {
    GET_FUNC_ADDR(StaticText_InsertControl)
    (((SYSCALL2) (pStaticText_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(StaticText_Invalidate)
void
StaticText_Invalidate(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Invalidate)
    (((SYSCALL1) (pStaticText_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_PaintTo)
void
StaticText_PaintTo(TStaticText AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(StaticText_PaintTo)
    (((SYSCALL4) (pStaticText_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(StaticText_RemoveControl)
void
StaticText_RemoveControl(TStaticText AObj, TControl AControl) {
    GET_FUNC_ADDR(StaticText_RemoveControl)
    (((SYSCALL2) (pStaticText_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(StaticText_Realign)
void
StaticText_Realign(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Realign)
    (((SYSCALL1) (pStaticText_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Repaint)
void
StaticText_Repaint(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Repaint)
    (((SYSCALL1) (pStaticText_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ScaleBy)
void
StaticText_ScaleBy(TStaticText AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(StaticText_ScaleBy)
    (((SYSCALL3) (pStaticText_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(StaticText_ScrollBy)
void
StaticText_ScrollBy(TStaticText AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(StaticText_ScrollBy)
    (((SYSCALL3) (pStaticText_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(StaticText_SetBounds)
void
StaticText_SetBounds(TStaticText AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(StaticText_SetBounds)
    (((SYSCALL5) (pStaticText_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(StaticText_SetFocus)
void
StaticText_SetFocus(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_SetFocus)
    (((SYSCALL1) (pStaticText_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Update)
void
StaticText_Update(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Update)
    (((SYSCALL1) (pStaticText_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_BringToFront)
void
StaticText_BringToFront(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_BringToFront)
    (((SYSCALL1) (pStaticText_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ClientToScreen)
TPoint
StaticText_ClientToScreen(TStaticText AObj, TPoint Point) {
    GET_FUNC_ADDR(StaticText_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pStaticText_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_ClientToParent)
TPoint
StaticText_ClientToParent(TStaticText AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(StaticText_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pStaticText_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_Dragging)
BOOL
StaticText_Dragging(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Dragging)
    return (BOOL)(((SYSCALL1) (pStaticText_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_HasParent)
BOOL
StaticText_HasParent(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_HasParent)
    return (BOOL)(((SYSCALL1) (pStaticText_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Hide)
void
StaticText_Hide(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Hide)
    (((SYSCALL1) (pStaticText_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Perform)
intptr_t
StaticText_Perform(TStaticText AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(StaticText_Perform)
    return (intptr_t)(((SYSCALL4) (pStaticText_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(StaticText_Refresh)
void
StaticText_Refresh(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Refresh)
    (((SYSCALL1) (pStaticText_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ScreenToClient)
TPoint
StaticText_ScreenToClient(TStaticText AObj, TPoint Point) {
    GET_FUNC_ADDR(StaticText_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pStaticText_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_ParentToClient)
TPoint
StaticText_ParentToClient(TStaticText AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(StaticText_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pStaticText_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_SendToBack)
void
StaticText_SendToBack(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_SendToBack)
    (((SYSCALL1) (pStaticText_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Show)
void
StaticText_Show(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_Show)
    (((SYSCALL1) (pStaticText_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetTextBuf)
int32_t
StaticText_GetTextBuf(TStaticText AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(StaticText_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pStaticText_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(StaticText_GetTextLen)
int32_t
StaticText_GetTextLen(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTextLen)
    return (int32_t)(((SYSCALL1) (pStaticText_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTextBuf)
void
StaticText_SetTextBuf(TStaticText AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(StaticText_SetTextBuf)
    (((SYSCALL2) (pStaticText_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(StaticText_FindComponent)
TComponent
StaticText_FindComponent(TStaticText AObj, CChar char* AName) {
    GET_FUNC_ADDR(StaticText_FindComponent)
    return (TComponent)(((SYSCALL2) (pStaticText_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(StaticText_GetNamePath)
char*
StaticText_GetNamePath(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetNamePath)
    return (char*)(((SYSCALL1) (pStaticText_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_Assign)
void
StaticText_Assign(TStaticText AObj, TObject Source) {
    GET_FUNC_ADDR(StaticText_Assign)
    (((SYSCALL2) (pStaticText_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(StaticText_ClassType)
TClass
StaticText_ClassType(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_ClassType)
    return (TClass)(((SYSCALL1) (pStaticText_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ClassName)
char*
StaticText_ClassName(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_ClassName)
    return (char*)(((SYSCALL1) (pStaticText_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_InstanceSize)
int32_t
StaticText_InstanceSize(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_InstanceSize)
    return (int32_t)(((SYSCALL1) (pStaticText_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_InheritsFrom)
BOOL
StaticText_InheritsFrom(TStaticText AObj, TClass AClass) {
    GET_FUNC_ADDR(StaticText_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pStaticText_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(StaticText_Equals)
BOOL
StaticText_Equals(TStaticText AObj, TObject Obj) {
    GET_FUNC_ADDR(StaticText_Equals)
    return (BOOL)(((SYSCALL2) (pStaticText_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(StaticText_GetHashCode)
int32_t
StaticText_GetHashCode(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetHashCode)
    return (int32_t)(((SYSCALL1) (pStaticText_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_ToString)
char*
StaticText_ToString(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_ToString)
    return (char*)(((SYSCALL1) (pStaticText_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_AnchorToNeighbour)
void
StaticText_AnchorToNeighbour(TStaticText AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(StaticText_AnchorToNeighbour)
    (((SYSCALL4) (pStaticText_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(StaticText_AnchorParallel)
void
StaticText_AnchorParallel(TStaticText AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(StaticText_AnchorParallel)
    (((SYSCALL4) (pStaticText_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(StaticText_AnchorHorizontalCenterTo)
void
StaticText_AnchorHorizontalCenterTo(TStaticText AObj, TControl ASibling) {
    GET_FUNC_ADDR(StaticText_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pStaticText_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(StaticText_AnchorVerticalCenterTo)
void
StaticText_AnchorVerticalCenterTo(TStaticText AObj, TControl ASibling) {
    GET_FUNC_ADDR(StaticText_AnchorVerticalCenterTo)
    (((SYSCALL2) (pStaticText_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(StaticText_AnchorSame)
void
StaticText_AnchorSame(TStaticText AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(StaticText_AnchorSame)
    (((SYSCALL3) (pStaticText_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(StaticText_AnchorAsAlign)
void
StaticText_AnchorAsAlign(TStaticText AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(StaticText_AnchorAsAlign)
    (((SYSCALL3) (pStaticText_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(StaticText_AnchorClient)
void
StaticText_AnchorClient(TStaticText AObj, int32_t ASpace) {
    GET_FUNC_ADDR(StaticText_AnchorClient)
    (((SYSCALL2) (pStaticText_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(StaticText_ScaleDesignToForm)
int32_t
StaticText_ScaleDesignToForm(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleFormToDesign)
int32_t
StaticText_ScaleFormToDesign(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_Scale96ToForm)
int32_t
StaticText_Scale96ToForm(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pStaticText_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleFormTo96)
int32_t
StaticText_ScaleFormTo96(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_Scale96ToFont)
int32_t
StaticText_Scale96ToFont(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pStaticText_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleFontTo96)
int32_t
StaticText_ScaleFontTo96(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleScreenToFont)
int32_t
StaticText_ScaleScreenToFont(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleFontToScreen)
int32_t
StaticText_ScaleFontToScreen(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_Scale96ToScreen)
int32_t
StaticText_Scale96ToScreen(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pStaticText_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_ScaleScreenTo96)
int32_t
StaticText_ScaleScreenTo96(TStaticText AObj, int32_t ASize) {
    GET_FUNC_ADDR(StaticText_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pStaticText_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(StaticText_AutoAdjustLayout)
void
StaticText_AutoAdjustLayout(TStaticText AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(StaticText_AutoAdjustLayout)
    (((SYSCALL6) (pStaticText_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(StaticText_FixDesignFontsPPI)
void
StaticText_FixDesignFontsPPI(TStaticText AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(StaticText_FixDesignFontsPPI)
    (((SYSCALL2) (pStaticText_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(StaticText_ScaleFontsPPI)
void
StaticText_ScaleFontsPPI(TStaticText AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(StaticText_ScaleFontsPPI)
    (((SYSCALL3) (pStaticText_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(StaticText_GetAlign)
TAlign
StaticText_GetAlign(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAlign)
    return (TAlign)(((SYSCALL1) (pStaticText_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAlign)
void
StaticText_SetAlign(TStaticText AObj, TAlign AValue) {
    GET_FUNC_ADDR(StaticText_SetAlign)
    (((SYSCALL2) (pStaticText_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAlignment)
TAlignment
StaticText_GetAlignment(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAlignment)
    return (TAlignment)(((SYSCALL1) (pStaticText_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAlignment)
void
StaticText_SetAlignment(TStaticText AObj, TAlignment AValue) {
    GET_FUNC_ADDR(StaticText_SetAlignment)
    (((SYSCALL2) (pStaticText_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchors)
TAnchors
StaticText_GetAnchors(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pStaticText_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAnchors)
void
StaticText_SetAnchors(TStaticText AObj, TAnchors AValue) {
    GET_FUNC_ADDR(StaticText_SetAnchors)
    (((SYSCALL2) (pStaticText_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAutoSize)
BOOL
StaticText_GetAutoSize(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAutoSize)
    return (BOOL)(((SYSCALL1) (pStaticText_GetAutoSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAutoSize)
void
StaticText_SetAutoSize(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetAutoSize)
    (((SYSCALL2) (pStaticText_SetAutoSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetBiDiMode)
TBiDiMode
StaticText_GetBiDiMode(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pStaticText_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetBiDiMode)
void
StaticText_SetBiDiMode(TStaticText AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(StaticText_SetBiDiMode)
    (((SYSCALL2) (pStaticText_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetBorderStyle)
TStaticBorderStyle
StaticText_GetBorderStyle(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetBorderStyle)
    return (TStaticBorderStyle)(((SYSCALL1) (pStaticText_GetBorderStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetBorderStyle)
void
StaticText_SetBorderStyle(TStaticText AObj, TStaticBorderStyle AValue) {
    GET_FUNC_ADDR(StaticText_SetBorderStyle)
    (((SYSCALL2) (pStaticText_SetBorderStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetCaption)
char*
StaticText_GetCaption(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetCaption)
    return (char*)(((SYSCALL1) (pStaticText_GetCaption))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetCaption)
void
StaticText_SetCaption(TStaticText AObj, CChar char* AValue) {
    GET_FUNC_ADDR(StaticText_SetCaption)
    (((SYSCALL2) (pStaticText_SetCaption))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetColor)
TColor
StaticText_GetColor(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetColor)
    return (TColor)(((SYSCALL1) (pStaticText_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetColor)
void
StaticText_SetColor(TStaticText AObj, TColor AValue) {
    GET_FUNC_ADDR(StaticText_SetColor)
    (((SYSCALL2) (pStaticText_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetConstraints)
TSizeConstraints
StaticText_GetConstraints(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pStaticText_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetConstraints)
void
StaticText_SetConstraints(TStaticText AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(StaticText_SetConstraints)
    (((SYSCALL2) (pStaticText_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetDoubleBuffered)
BOOL
StaticText_GetDoubleBuffered(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pStaticText_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetDoubleBuffered)
void
StaticText_SetDoubleBuffered(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetDoubleBuffered)
    (((SYSCALL2) (pStaticText_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetDragCursor)
TCursor
StaticText_GetDragCursor(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pStaticText_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetDragCursor)
void
StaticText_SetDragCursor(TStaticText AObj, TCursor AValue) {
    GET_FUNC_ADDR(StaticText_SetDragCursor)
    (((SYSCALL2) (pStaticText_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetDragKind)
TDragKind
StaticText_GetDragKind(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pStaticText_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetDragKind)
void
StaticText_SetDragKind(TStaticText AObj, TDragKind AValue) {
    GET_FUNC_ADDR(StaticText_SetDragKind)
    (((SYSCALL2) (pStaticText_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetDragMode)
TDragMode
StaticText_GetDragMode(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pStaticText_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetDragMode)
void
StaticText_SetDragMode(TStaticText AObj, TDragMode AValue) {
    GET_FUNC_ADDR(StaticText_SetDragMode)
    (((SYSCALL2) (pStaticText_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetEnabled)
BOOL
StaticText_GetEnabled(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetEnabled)
    return (BOOL)(((SYSCALL1) (pStaticText_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetEnabled)
void
StaticText_SetEnabled(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetEnabled)
    (((SYSCALL2) (pStaticText_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetFocusControl)
TWinControl
StaticText_GetFocusControl(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetFocusControl)
    return (TWinControl)(((SYSCALL1) (pStaticText_GetFocusControl))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetFocusControl)
void
StaticText_SetFocusControl(TStaticText AObj, TWinControl AValue) {
    GET_FUNC_ADDR(StaticText_SetFocusControl)
    (((SYSCALL2) (pStaticText_SetFocusControl))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetFont)
TFont
StaticText_GetFont(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetFont)
    return (TFont)(((SYSCALL1) (pStaticText_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetFont)
void
StaticText_SetFont(TStaticText AObj, TFont AValue) {
    GET_FUNC_ADDR(StaticText_SetFont)
    (((SYSCALL2) (pStaticText_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetParentColor)
BOOL
StaticText_GetParentColor(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParentColor)
    return (BOOL)(((SYSCALL1) (pStaticText_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParentColor)
void
StaticText_SetParentColor(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetParentColor)
    (((SYSCALL2) (pStaticText_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetParentDoubleBuffered)
BOOL
StaticText_GetParentDoubleBuffered(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pStaticText_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParentDoubleBuffered)
void
StaticText_SetParentDoubleBuffered(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetParentDoubleBuffered)
    (((SYSCALL2) (pStaticText_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetParentFont)
BOOL
StaticText_GetParentFont(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParentFont)
    return (BOOL)(((SYSCALL1) (pStaticText_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParentFont)
void
StaticText_SetParentFont(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetParentFont)
    (((SYSCALL2) (pStaticText_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetParentShowHint)
BOOL
StaticText_GetParentShowHint(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pStaticText_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParentShowHint)
void
StaticText_SetParentShowHint(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetParentShowHint)
    (((SYSCALL2) (pStaticText_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetPopupMenu)
TPopupMenu
StaticText_GetPopupMenu(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pStaticText_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetPopupMenu)
void
StaticText_SetPopupMenu(TStaticText AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(StaticText_SetPopupMenu)
    (((SYSCALL2) (pStaticText_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetShowAccelChar)
BOOL
StaticText_GetShowAccelChar(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetShowAccelChar)
    return (BOOL)(((SYSCALL1) (pStaticText_GetShowAccelChar))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetShowAccelChar)
void
StaticText_SetShowAccelChar(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetShowAccelChar)
    (((SYSCALL2) (pStaticText_SetShowAccelChar))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetShowHint)
BOOL
StaticText_GetShowHint(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetShowHint)
    return (BOOL)(((SYSCALL1) (pStaticText_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetShowHint)
void
StaticText_SetShowHint(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetShowHint)
    (((SYSCALL2) (pStaticText_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetTabOrder)
TTabOrder
StaticText_GetTabOrder(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pStaticText_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTabOrder)
void
StaticText_SetTabOrder(TStaticText AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(StaticText_SetTabOrder)
    (((SYSCALL2) (pStaticText_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetTabStop)
BOOL
StaticText_GetTabStop(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTabStop)
    return (BOOL)(((SYSCALL1) (pStaticText_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTabStop)
void
StaticText_SetTabStop(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetTabStop)
    (((SYSCALL2) (pStaticText_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetTransparent)
BOOL
StaticText_GetTransparent(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTransparent)
    return (BOOL)(((SYSCALL1) (pStaticText_GetTransparent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTransparent)
void
StaticText_SetTransparent(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetTransparent)
    (((SYSCALL2) (pStaticText_SetTransparent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetVisible)
BOOL
StaticText_GetVisible(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetVisible)
    return (BOOL)(((SYSCALL1) (pStaticText_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetVisible)
void
StaticText_SetVisible(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetVisible)
    (((SYSCALL2) (pStaticText_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_SetOnClick)
void
StaticText_SetOnClick(TStaticText AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnClick)
    (((SYSCALL2) (pStaticText_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnContextPopup)
void
StaticText_SetOnContextPopup(TStaticText AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnContextPopup)
    (((SYSCALL2) (pStaticText_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnDblClick)
void
StaticText_SetOnDblClick(TStaticText AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnDblClick)
    (((SYSCALL2) (pStaticText_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnDragDrop)
void
StaticText_SetOnDragDrop(TStaticText AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnDragDrop)
    (((SYSCALL2) (pStaticText_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnDragOver)
void
StaticText_SetOnDragOver(TStaticText AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnDragOver)
    (((SYSCALL2) (pStaticText_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnEndDrag)
void
StaticText_SetOnEndDrag(TStaticText AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnEndDrag)
    (((SYSCALL2) (pStaticText_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnMouseDown)
void
StaticText_SetOnMouseDown(TStaticText AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnMouseDown)
    (((SYSCALL2) (pStaticText_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnMouseEnter)
void
StaticText_SetOnMouseEnter(TStaticText AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnMouseEnter)
    (((SYSCALL2) (pStaticText_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnMouseLeave)
void
StaticText_SetOnMouseLeave(TStaticText AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnMouseLeave)
    (((SYSCALL2) (pStaticText_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnMouseMove)
void
StaticText_SetOnMouseMove(TStaticText AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnMouseMove)
    (((SYSCALL2) (pStaticText_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_SetOnMouseUp)
void
StaticText_SetOnMouseUp(TStaticText AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(StaticText_SetOnMouseUp)
    (((SYSCALL2) (pStaticText_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(StaticText_GetDockClientCount)
int32_t
StaticText_GetDockClientCount(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pStaticText_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetDockSite)
BOOL
StaticText_GetDockSite(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetDockSite)
    return (BOOL)(((SYSCALL1) (pStaticText_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetDockSite)
void
StaticText_SetDockSite(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetDockSite)
    (((SYSCALL2) (pStaticText_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetMouseInClient)
BOOL
StaticText_GetMouseInClient(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pStaticText_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetVisibleDockClientCount)
int32_t
StaticText_GetVisibleDockClientCount(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pStaticText_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetBrush)
TBrush
StaticText_GetBrush(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetBrush)
    return (TBrush)(((SYSCALL1) (pStaticText_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetControlCount)
int32_t
StaticText_GetControlCount(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetControlCount)
    return (int32_t)(((SYSCALL1) (pStaticText_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetHandle)
HWND
StaticText_GetHandle(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetHandle)
    return (HWND)(((SYSCALL1) (pStaticText_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetParentWindow)
HWND
StaticText_GetParentWindow(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParentWindow)
    return (HWND)(((SYSCALL1) (pStaticText_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParentWindow)
void
StaticText_SetParentWindow(TStaticText AObj, HWND AValue) {
    GET_FUNC_ADDR(StaticText_SetParentWindow)
    (((SYSCALL2) (pStaticText_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetShowing)
BOOL
StaticText_GetShowing(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetShowing)
    return (BOOL)(((SYSCALL1) (pStaticText_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetUseDockManager)
BOOL
StaticText_GetUseDockManager(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pStaticText_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetUseDockManager)
void
StaticText_SetUseDockManager(TStaticText AObj, BOOL AValue) {
    GET_FUNC_ADDR(StaticText_SetUseDockManager)
    (((SYSCALL2) (pStaticText_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAction)
TAction
StaticText_GetAction(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAction)
    return (TAction)(((SYSCALL1) (pStaticText_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAction)
void
StaticText_SetAction(TStaticText AObj, TAction AValue) {
    GET_FUNC_ADDR(StaticText_SetAction)
    (((SYSCALL2) (pStaticText_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetBoundsRect)
TRect
StaticText_GetBoundsRect(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pStaticText_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_SetBoundsRect)
void
StaticText_SetBoundsRect(TStaticText AObj, TRect AValue) {
    GET_FUNC_ADDR(StaticText_SetBoundsRect)
    (((SYSCALL2) (pStaticText_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetClientHeight)
int32_t
StaticText_GetClientHeight(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pStaticText_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetClientHeight)
void
StaticText_SetClientHeight(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetClientHeight)
    (((SYSCALL2) (pStaticText_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetClientOrigin)
TPoint
StaticText_GetClientOrigin(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pStaticText_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_GetClientRect)
TRect
StaticText_GetClientRect(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetClientRect)
    TRect result;
    (((SYSCALL2) (pStaticText_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(StaticText_GetClientWidth)
int32_t
StaticText_GetClientWidth(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pStaticText_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetClientWidth)
void
StaticText_SetClientWidth(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetClientWidth)
    (((SYSCALL2) (pStaticText_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetControlState)
TControlState
StaticText_GetControlState(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetControlState)
    return (TControlState)(((SYSCALL1) (pStaticText_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetControlState)
void
StaticText_SetControlState(TStaticText AObj, TControlState AValue) {
    GET_FUNC_ADDR(StaticText_SetControlState)
    (((SYSCALL2) (pStaticText_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetControlStyle)
TControlStyle
StaticText_GetControlStyle(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pStaticText_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetControlStyle)
void
StaticText_SetControlStyle(TStaticText AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(StaticText_SetControlStyle)
    (((SYSCALL2) (pStaticText_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetFloating)
BOOL
StaticText_GetFloating(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetFloating)
    return (BOOL)(((SYSCALL1) (pStaticText_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetParent)
TWinControl
StaticText_GetParent(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetParent)
    return (TWinControl)(((SYSCALL1) (pStaticText_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetParent)
void
StaticText_SetParent(TStaticText AObj, TWinControl AValue) {
    GET_FUNC_ADDR(StaticText_SetParent)
    (((SYSCALL2) (pStaticText_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetLeft)
int32_t
StaticText_GetLeft(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetLeft)
    return (int32_t)(((SYSCALL1) (pStaticText_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetLeft)
void
StaticText_SetLeft(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetLeft)
    (((SYSCALL2) (pStaticText_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetTop)
int32_t
StaticText_GetTop(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTop)
    return (int32_t)(((SYSCALL1) (pStaticText_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTop)
void
StaticText_SetTop(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetTop)
    (((SYSCALL2) (pStaticText_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetWidth)
int32_t
StaticText_GetWidth(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetWidth)
    return (int32_t)(((SYSCALL1) (pStaticText_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetWidth)
void
StaticText_SetWidth(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetWidth)
    (((SYSCALL2) (pStaticText_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetHeight)
int32_t
StaticText_GetHeight(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetHeight)
    return (int32_t)(((SYSCALL1) (pStaticText_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetHeight)
void
StaticText_SetHeight(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetHeight)
    (((SYSCALL2) (pStaticText_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetCursor)
TCursor
StaticText_GetCursor(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetCursor)
    return (TCursor)(((SYSCALL1) (pStaticText_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetCursor)
void
StaticText_SetCursor(TStaticText AObj, TCursor AValue) {
    GET_FUNC_ADDR(StaticText_SetCursor)
    (((SYSCALL2) (pStaticText_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetHint)
char*
StaticText_GetHint(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetHint)
    return (char*)(((SYSCALL1) (pStaticText_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetHint)
void
StaticText_SetHint(TStaticText AObj, CChar char* AValue) {
    GET_FUNC_ADDR(StaticText_SetHint)
    (((SYSCALL2) (pStaticText_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetComponentCount)
int32_t
StaticText_GetComponentCount(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pStaticText_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetComponentIndex)
int32_t
StaticText_GetComponentIndex(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pStaticText_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetComponentIndex)
void
StaticText_SetComponentIndex(TStaticText AObj, int32_t AValue) {
    GET_FUNC_ADDR(StaticText_SetComponentIndex)
    (((SYSCALL2) (pStaticText_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetOwner)
TComponent
StaticText_GetOwner(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetOwner)
    return (TComponent)(((SYSCALL1) (pStaticText_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_GetName)
char*
StaticText_GetName(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetName)
    return (char*)(((SYSCALL1) (pStaticText_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetName)
void
StaticText_SetName(TStaticText AObj, CChar char* AValue) {
    GET_FUNC_ADDR(StaticText_SetName)
    (((SYSCALL2) (pStaticText_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetTag)
intptr_t
StaticText_GetTag(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetTag)
    return (intptr_t)(((SYSCALL1) (pStaticText_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetTag)
void
StaticText_SetTag(TStaticText AObj, intptr_t AValue) {
    GET_FUNC_ADDR(StaticText_SetTag)
    (((SYSCALL2) (pStaticText_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchorSideLeft)
TAnchorSide
StaticText_GetAnchorSideLeft(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pStaticText_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAnchorSideLeft)
void
StaticText_SetAnchorSideLeft(TStaticText AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(StaticText_SetAnchorSideLeft)
    (((SYSCALL2) (pStaticText_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchorSideTop)
TAnchorSide
StaticText_GetAnchorSideTop(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pStaticText_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAnchorSideTop)
void
StaticText_SetAnchorSideTop(TStaticText AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(StaticText_SetAnchorSideTop)
    (((SYSCALL2) (pStaticText_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchorSideRight)
TAnchorSide
StaticText_GetAnchorSideRight(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pStaticText_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAnchorSideRight)
void
StaticText_SetAnchorSideRight(TStaticText AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(StaticText_SetAnchorSideRight)
    (((SYSCALL2) (pStaticText_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchorSideBottom)
TAnchorSide
StaticText_GetAnchorSideBottom(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pStaticText_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetAnchorSideBottom)
void
StaticText_SetAnchorSideBottom(TStaticText AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(StaticText_SetAnchorSideBottom)
    (((SYSCALL2) (pStaticText_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetChildSizing)
TControlChildSizing
StaticText_GetChildSizing(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pStaticText_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetChildSizing)
void
StaticText_SetChildSizing(TStaticText AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(StaticText_SetChildSizing)
    (((SYSCALL2) (pStaticText_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetBorderSpacing)
TControlBorderSpacing
StaticText_GetBorderSpacing(TStaticText AObj) {
    GET_FUNC_ADDR(StaticText_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pStaticText_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(StaticText_SetBorderSpacing)
void
StaticText_SetBorderSpacing(TStaticText AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(StaticText_SetBorderSpacing)
    (((SYSCALL2) (pStaticText_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(StaticText_GetDockClients)
TControl
StaticText_GetDockClients(TStaticText AObj, int32_t Index) {
    GET_FUNC_ADDR(StaticText_GetDockClients)
    return (TControl)(((SYSCALL2) (pStaticText_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(StaticText_GetControls)
TControl
StaticText_GetControls(TStaticText AObj, int32_t Index) {
    GET_FUNC_ADDR(StaticText_GetControls)
    return (TControl)(((SYSCALL2) (pStaticText_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(StaticText_GetComponents)
TComponent
StaticText_GetComponents(TStaticText AObj, int32_t AIndex) {
    GET_FUNC_ADDR(StaticText_GetComponents)
    return (TComponent)(((SYSCALL2) (pStaticText_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(StaticText_GetAnchorSide)
TAnchorSide
StaticText_GetAnchorSide(TStaticText AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(StaticText_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pStaticText_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(StaticText_StaticClassType)
TClass
StaticText_StaticClassType() {
    GET_FUNC_ADDR(StaticText_StaticClassType)
    return (TClass)(((SYSCALL0) (pStaticText_StaticClassType))());
}

// -------------------TColorBox-------------------

DEFINE_FUNC_PTR(ColorBox_Create)
TColorBox
ColorBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(ColorBox_Create)
    return (TColorBox)(((SYSCALL1) (pColorBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(ColorBox_Free)
void
ColorBox_Free(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Free)
    (((SYSCALL1) (pColorBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_AddItem)
void
ColorBox_AddItem(TColorBox AObj, CChar char* Item, TObject AObject) {
    GET_FUNC_ADDR(ColorBox_AddItem)
    (((SYSCALL3) (pColorBox_AddItem))(COV_PARAM(AObj), COV_PARAM(Item), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(ColorBox_Clear)
void
ColorBox_Clear(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Clear)
    (((SYSCALL1) (pColorBox_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ClearSelection)
void
ColorBox_ClearSelection(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_ClearSelection)
    (((SYSCALL1) (pColorBox_ClearSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_DeleteSelected)
void
ColorBox_DeleteSelected(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_DeleteSelected)
    (((SYSCALL1) (pColorBox_DeleteSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Focused)
BOOL
ColorBox_Focused(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Focused)
    return (BOOL)(((SYSCALL1) (pColorBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SelectAll)
void
ColorBox_SelectAll(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_SelectAll)
    (((SYSCALL1) (pColorBox_SelectAll))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_CanFocus)
BOOL
ColorBox_CanFocus(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pColorBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ContainsControl)
BOOL
ColorBox_ContainsControl(TColorBox AObj, TControl Control) {
    GET_FUNC_ADDR(ColorBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pColorBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(ColorBox_ControlAtPos)
TControl
ColorBox_ControlAtPos(TColorBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(ColorBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pColorBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(ColorBox_DisableAlign)
void
ColorBox_DisableAlign(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_DisableAlign)
    (((SYSCALL1) (pColorBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_EnableAlign)
void
ColorBox_EnableAlign(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_EnableAlign)
    (((SYSCALL1) (pColorBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_FindChildControl)
TControl
ColorBox_FindChildControl(TColorBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(ColorBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pColorBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(ColorBox_FlipChildren)
void
ColorBox_FlipChildren(TColorBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(ColorBox_FlipChildren)
    (((SYSCALL2) (pColorBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(ColorBox_HandleAllocated)
BOOL
ColorBox_HandleAllocated(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pColorBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_InsertControl)
void
ColorBox_InsertControl(TColorBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ColorBox_InsertControl)
    (((SYSCALL2) (pColorBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ColorBox_Invalidate)
void
ColorBox_Invalidate(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Invalidate)
    (((SYSCALL1) (pColorBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_PaintTo)
void
ColorBox_PaintTo(TColorBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(ColorBox_PaintTo)
    (((SYSCALL4) (pColorBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(ColorBox_RemoveControl)
void
ColorBox_RemoveControl(TColorBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ColorBox_RemoveControl)
    (((SYSCALL2) (pColorBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ColorBox_Realign)
void
ColorBox_Realign(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Realign)
    (((SYSCALL1) (pColorBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Repaint)
void
ColorBox_Repaint(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Repaint)
    (((SYSCALL1) (pColorBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleBy)
void
ColorBox_ScaleBy(TColorBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(ColorBox_ScaleBy)
    (((SYSCALL3) (pColorBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(ColorBox_ScrollBy)
void
ColorBox_ScrollBy(TColorBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(ColorBox_ScrollBy)
    (((SYSCALL3) (pColorBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(ColorBox_SetBounds)
void
ColorBox_SetBounds(TColorBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(ColorBox_SetBounds)
    (((SYSCALL5) (pColorBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(ColorBox_SetFocus)
void
ColorBox_SetFocus(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_SetFocus)
    (((SYSCALL1) (pColorBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Update)
void
ColorBox_Update(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Update)
    (((SYSCALL1) (pColorBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_BringToFront)
void
ColorBox_BringToFront(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_BringToFront)
    (((SYSCALL1) (pColorBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ClientToScreen)
TPoint
ColorBox_ClientToScreen(TColorBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ColorBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pColorBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_ClientToParent)
TPoint
ColorBox_ClientToParent(TColorBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ColorBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pColorBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_Dragging)
BOOL
ColorBox_Dragging(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Dragging)
    return (BOOL)(((SYSCALL1) (pColorBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_HasParent)
BOOL
ColorBox_HasParent(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_HasParent)
    return (BOOL)(((SYSCALL1) (pColorBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Hide)
void
ColorBox_Hide(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Hide)
    (((SYSCALL1) (pColorBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Perform)
intptr_t
ColorBox_Perform(TColorBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(ColorBox_Perform)
    return (intptr_t)(((SYSCALL4) (pColorBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(ColorBox_Refresh)
void
ColorBox_Refresh(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Refresh)
    (((SYSCALL1) (pColorBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ScreenToClient)
TPoint
ColorBox_ScreenToClient(TColorBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ColorBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pColorBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_ParentToClient)
TPoint
ColorBox_ParentToClient(TColorBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ColorBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pColorBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_SendToBack)
void
ColorBox_SendToBack(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_SendToBack)
    (((SYSCALL1) (pColorBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Show)
void
ColorBox_Show(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_Show)
    (((SYSCALL1) (pColorBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetTextBuf)
int32_t
ColorBox_GetTextBuf(TColorBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(ColorBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pColorBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(ColorBox_GetTextLen)
int32_t
ColorBox_GetTextLen(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pColorBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetTextBuf)
void
ColorBox_SetTextBuf(TColorBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(ColorBox_SetTextBuf)
    (((SYSCALL2) (pColorBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(ColorBox_FindComponent)
TComponent
ColorBox_FindComponent(TColorBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(ColorBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pColorBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(ColorBox_GetNamePath)
char*
ColorBox_GetNamePath(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetNamePath)
    return (char*)(((SYSCALL1) (pColorBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_Assign)
void
ColorBox_Assign(TColorBox AObj, TObject Source) {
    GET_FUNC_ADDR(ColorBox_Assign)
    (((SYSCALL2) (pColorBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(ColorBox_ClassType)
TClass
ColorBox_ClassType(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_ClassType)
    return (TClass)(((SYSCALL1) (pColorBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ClassName)
char*
ColorBox_ClassName(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_ClassName)
    return (char*)(((SYSCALL1) (pColorBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_InstanceSize)
int32_t
ColorBox_InstanceSize(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pColorBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_InheritsFrom)
BOOL
ColorBox_InheritsFrom(TColorBox AObj, TClass AClass) {
    GET_FUNC_ADDR(ColorBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pColorBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(ColorBox_Equals)
BOOL
ColorBox_Equals(TColorBox AObj, TObject Obj) {
    GET_FUNC_ADDR(ColorBox_Equals)
    return (BOOL)(((SYSCALL2) (pColorBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(ColorBox_GetHashCode)
int32_t
ColorBox_GetHashCode(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pColorBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_ToString)
char*
ColorBox_ToString(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_ToString)
    return (char*)(((SYSCALL1) (pColorBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorToNeighbour)
void
ColorBox_AnchorToNeighbour(TColorBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ColorBox_AnchorToNeighbour)
    (((SYSCALL4) (pColorBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorParallel)
void
ColorBox_AnchorParallel(TColorBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ColorBox_AnchorParallel)
    (((SYSCALL4) (pColorBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorHorizontalCenterTo)
void
ColorBox_AnchorHorizontalCenterTo(TColorBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ColorBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pColorBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorVerticalCenterTo)
void
ColorBox_AnchorVerticalCenterTo(TColorBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ColorBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pColorBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorSame)
void
ColorBox_AnchorSame(TColorBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(ColorBox_AnchorSame)
    (((SYSCALL3) (pColorBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorAsAlign)
void
ColorBox_AnchorAsAlign(TColorBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(ColorBox_AnchorAsAlign)
    (((SYSCALL3) (pColorBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ColorBox_AnchorClient)
void
ColorBox_AnchorClient(TColorBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(ColorBox_AnchorClient)
    (((SYSCALL2) (pColorBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleDesignToForm)
int32_t
ColorBox_ScaleDesignToForm(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleFormToDesign)
int32_t
ColorBox_ScaleFormToDesign(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_Scale96ToForm)
int32_t
ColorBox_Scale96ToForm(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pColorBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleFormTo96)
int32_t
ColorBox_ScaleFormTo96(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_Scale96ToFont)
int32_t
ColorBox_Scale96ToFont(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pColorBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleFontTo96)
int32_t
ColorBox_ScaleFontTo96(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleScreenToFont)
int32_t
ColorBox_ScaleScreenToFont(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleFontToScreen)
int32_t
ColorBox_ScaleFontToScreen(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_Scale96ToScreen)
int32_t
ColorBox_Scale96ToScreen(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pColorBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleScreenTo96)
int32_t
ColorBox_ScaleScreenTo96(TColorBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pColorBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorBox_AutoAdjustLayout)
void
ColorBox_AutoAdjustLayout(TColorBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(ColorBox_AutoAdjustLayout)
    (((SYSCALL6) (pColorBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(ColorBox_FixDesignFontsPPI)
void
ColorBox_FixDesignFontsPPI(TColorBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(ColorBox_FixDesignFontsPPI)
    (((SYSCALL2) (pColorBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(ColorBox_ScaleFontsPPI)
void
ColorBox_ScaleFontsPPI(TColorBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(ColorBox_ScaleFontsPPI)
    (((SYSCALL3) (pColorBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(ColorBox_GetAlign)
TAlign
ColorBox_GetAlign(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pColorBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAlign)
void
ColorBox_SetAlign(TColorBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(ColorBox_SetAlign)
    (((SYSCALL2) (pColorBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAutoComplete)
BOOL
ColorBox_GetAutoComplete(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAutoComplete)
    return (BOOL)(((SYSCALL1) (pColorBox_GetAutoComplete))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAutoComplete)
void
ColorBox_SetAutoComplete(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetAutoComplete)
    (((SYSCALL2) (pColorBox_SetAutoComplete))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAutoDropDown)
BOOL
ColorBox_GetAutoDropDown(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAutoDropDown)
    return (BOOL)(((SYSCALL1) (pColorBox_GetAutoDropDown))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAutoDropDown)
void
ColorBox_SetAutoDropDown(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetAutoDropDown)
    (((SYSCALL2) (pColorBox_SetAutoDropDown))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetDefaultColorColor)
TColor
ColorBox_GetDefaultColorColor(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDefaultColorColor)
    return (TColor)(((SYSCALL1) (pColorBox_GetDefaultColorColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetDefaultColorColor)
void
ColorBox_SetDefaultColorColor(TColorBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorBox_SetDefaultColorColor)
    (((SYSCALL2) (pColorBox_SetDefaultColorColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetNoneColorColor)
TColor
ColorBox_GetNoneColorColor(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetNoneColorColor)
    return (TColor)(((SYSCALL1) (pColorBox_GetNoneColorColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetNoneColorColor)
void
ColorBox_SetNoneColorColor(TColorBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorBox_SetNoneColorColor)
    (((SYSCALL2) (pColorBox_SetNoneColorColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetSelected)
TColor
ColorBox_GetSelected(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetSelected)
    return (TColor)(((SYSCALL1) (pColorBox_GetSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetSelected)
void
ColorBox_SetSelected(TColorBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorBox_SetSelected)
    (((SYSCALL2) (pColorBox_SetSelected))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetStyle)
TColorBoxStyle
ColorBox_GetStyle(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetStyle)
    return (TColorBoxStyle)(((SYSCALL1) (pColorBox_GetStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetStyle)
void
ColorBox_SetStyle(TColorBox AObj, TColorBoxStyle AValue) {
    GET_FUNC_ADDR(ColorBox_SetStyle)
    (((SYSCALL2) (pColorBox_SetStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchors)
TAnchors
ColorBox_GetAnchors(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pColorBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAnchors)
void
ColorBox_SetAnchors(TColorBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(ColorBox_SetAnchors)
    (((SYSCALL2) (pColorBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetBiDiMode)
TBiDiMode
ColorBox_GetBiDiMode(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pColorBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetBiDiMode)
void
ColorBox_SetBiDiMode(TColorBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(ColorBox_SetBiDiMode)
    (((SYSCALL2) (pColorBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetColor)
TColor
ColorBox_GetColor(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetColor)
    return (TColor)(((SYSCALL1) (pColorBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetColor)
void
ColorBox_SetColor(TColorBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorBox_SetColor)
    (((SYSCALL2) (pColorBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetConstraints)
TSizeConstraints
ColorBox_GetConstraints(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pColorBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetConstraints)
void
ColorBox_SetConstraints(TColorBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(ColorBox_SetConstraints)
    (((SYSCALL2) (pColorBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetDoubleBuffered)
BOOL
ColorBox_GetDoubleBuffered(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pColorBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetDoubleBuffered)
void
ColorBox_SetDoubleBuffered(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetDoubleBuffered)
    (((SYSCALL2) (pColorBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetDropDownCount)
int32_t
ColorBox_GetDropDownCount(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDropDownCount)
    return (int32_t)(((SYSCALL1) (pColorBox_GetDropDownCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetDropDownCount)
void
ColorBox_SetDropDownCount(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetDropDownCount)
    (((SYSCALL2) (pColorBox_SetDropDownCount))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetEnabled)
BOOL
ColorBox_GetEnabled(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pColorBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetEnabled)
void
ColorBox_SetEnabled(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetEnabled)
    (((SYSCALL2) (pColorBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetFont)
TFont
ColorBox_GetFont(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetFont)
    return (TFont)(((SYSCALL1) (pColorBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetFont)
void
ColorBox_SetFont(TColorBox AObj, TFont AValue) {
    GET_FUNC_ADDR(ColorBox_SetFont)
    (((SYSCALL2) (pColorBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetItemHeight)
int32_t
ColorBox_GetItemHeight(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetItemHeight)
    return (int32_t)(((SYSCALL1) (pColorBox_GetItemHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetItemHeight)
void
ColorBox_SetItemHeight(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetItemHeight)
    (((SYSCALL2) (pColorBox_SetItemHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetParentColor)
BOOL
ColorBox_GetParentColor(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pColorBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParentColor)
void
ColorBox_SetParentColor(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetParentColor)
    (((SYSCALL2) (pColorBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetParentDoubleBuffered)
BOOL
ColorBox_GetParentDoubleBuffered(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pColorBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParentDoubleBuffered)
void
ColorBox_SetParentDoubleBuffered(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pColorBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetParentFont)
BOOL
ColorBox_GetParentFont(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pColorBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParentFont)
void
ColorBox_SetParentFont(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetParentFont)
    (((SYSCALL2) (pColorBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetParentShowHint)
BOOL
ColorBox_GetParentShowHint(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pColorBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParentShowHint)
void
ColorBox_SetParentShowHint(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetParentShowHint)
    (((SYSCALL2) (pColorBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetPopupMenu)
TPopupMenu
ColorBox_GetPopupMenu(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pColorBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetPopupMenu)
void
ColorBox_SetPopupMenu(TColorBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(ColorBox_SetPopupMenu)
    (((SYSCALL2) (pColorBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetShowHint)
BOOL
ColorBox_GetShowHint(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pColorBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetShowHint)
void
ColorBox_SetShowHint(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetShowHint)
    (((SYSCALL2) (pColorBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetTabOrder)
TTabOrder
ColorBox_GetTabOrder(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pColorBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetTabOrder)
void
ColorBox_SetTabOrder(TColorBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(ColorBox_SetTabOrder)
    (((SYSCALL2) (pColorBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetTabStop)
BOOL
ColorBox_GetTabStop(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pColorBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetTabStop)
void
ColorBox_SetTabStop(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetTabStop)
    (((SYSCALL2) (pColorBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetVisible)
BOOL
ColorBox_GetVisible(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pColorBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetVisible)
void
ColorBox_SetVisible(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetVisible)
    (((SYSCALL2) (pColorBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnChange)
void
ColorBox_SetOnChange(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnChange)
    (((SYSCALL2) (pColorBox_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnCloseUp)
void
ColorBox_SetOnCloseUp(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnCloseUp)
    (((SYSCALL2) (pColorBox_SetOnCloseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnClick)
void
ColorBox_SetOnClick(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnClick)
    (((SYSCALL2) (pColorBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnContextPopup)
void
ColorBox_SetOnContextPopup(TColorBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnContextPopup)
    (((SYSCALL2) (pColorBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnDragDrop)
void
ColorBox_SetOnDragDrop(TColorBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnDragDrop)
    (((SYSCALL2) (pColorBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnDragOver)
void
ColorBox_SetOnDragOver(TColorBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnDragOver)
    (((SYSCALL2) (pColorBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnDropDown)
void
ColorBox_SetOnDropDown(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnDropDown)
    (((SYSCALL2) (pColorBox_SetOnDropDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnEndDrag)
void
ColorBox_SetOnEndDrag(TColorBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnEndDrag)
    (((SYSCALL2) (pColorBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnEnter)
void
ColorBox_SetOnEnter(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnEnter)
    (((SYSCALL2) (pColorBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnExit)
void
ColorBox_SetOnExit(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnExit)
    (((SYSCALL2) (pColorBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnKeyDown)
void
ColorBox_SetOnKeyDown(TColorBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnKeyDown)
    (((SYSCALL2) (pColorBox_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnKeyPress)
void
ColorBox_SetOnKeyPress(TColorBox AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnKeyPress)
    (((SYSCALL2) (pColorBox_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnKeyUp)
void
ColorBox_SetOnKeyUp(TColorBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnKeyUp)
    (((SYSCALL2) (pColorBox_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnMouseEnter)
void
ColorBox_SetOnMouseEnter(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnMouseEnter)
    (((SYSCALL2) (pColorBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnMouseLeave)
void
ColorBox_SetOnMouseLeave(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnMouseLeave)
    (((SYSCALL2) (pColorBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_SetOnSelect)
void
ColorBox_SetOnSelect(TColorBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorBox_SetOnSelect)
    (((SYSCALL2) (pColorBox_SetOnSelect))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorBox_GetCharCase)
TEditCharCase
ColorBox_GetCharCase(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetCharCase)
    return (TEditCharCase)(((SYSCALL1) (pColorBox_GetCharCase))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetCharCase)
void
ColorBox_SetCharCase(TColorBox AObj, TEditCharCase AValue) {
    GET_FUNC_ADDR(ColorBox_SetCharCase)
    (((SYSCALL2) (pColorBox_SetCharCase))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetSelText)
char*
ColorBox_GetSelText(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetSelText)
    return (char*)(((SYSCALL1) (pColorBox_GetSelText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetSelText)
void
ColorBox_SetSelText(TColorBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorBox_SetSelText)
    (((SYSCALL2) (pColorBox_SetSelText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetCanvas)
TCanvas
ColorBox_GetCanvas(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pColorBox_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetDroppedDown)
BOOL
ColorBox_GetDroppedDown(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDroppedDown)
    return (BOOL)(((SYSCALL1) (pColorBox_GetDroppedDown))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetDroppedDown)
void
ColorBox_SetDroppedDown(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetDroppedDown)
    (((SYSCALL2) (pColorBox_SetDroppedDown))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetItems)
TStrings
ColorBox_GetItems(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetItems)
    return (TStrings)(((SYSCALL1) (pColorBox_GetItems))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetItems)
void
ColorBox_SetItems(TColorBox AObj, TStrings AValue) {
    GET_FUNC_ADDR(ColorBox_SetItems)
    (((SYSCALL2) (pColorBox_SetItems))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetSelLength)
int32_t
ColorBox_GetSelLength(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetSelLength)
    return (int32_t)(((SYSCALL1) (pColorBox_GetSelLength))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetSelLength)
void
ColorBox_SetSelLength(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetSelLength)
    (((SYSCALL2) (pColorBox_SetSelLength))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetSelStart)
int32_t
ColorBox_GetSelStart(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetSelStart)
    return (int32_t)(((SYSCALL1) (pColorBox_GetSelStart))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetSelStart)
void
ColorBox_SetSelStart(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetSelStart)
    (((SYSCALL2) (pColorBox_SetSelStart))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetItemIndex)
int32_t
ColorBox_GetItemIndex(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetItemIndex)
    return (int32_t)(((SYSCALL1) (pColorBox_GetItemIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetItemIndex)
void
ColorBox_SetItemIndex(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetItemIndex)
    (((SYSCALL2) (pColorBox_SetItemIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetDockClientCount)
int32_t
ColorBox_GetDockClientCount(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pColorBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetDockSite)
BOOL
ColorBox_GetDockSite(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pColorBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetDockSite)
void
ColorBox_SetDockSite(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetDockSite)
    (((SYSCALL2) (pColorBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetMouseInClient)
BOOL
ColorBox_GetMouseInClient(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pColorBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetVisibleDockClientCount)
int32_t
ColorBox_GetVisibleDockClientCount(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pColorBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetBrush)
TBrush
ColorBox_GetBrush(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pColorBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetControlCount)
int32_t
ColorBox_GetControlCount(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pColorBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetHandle)
HWND
ColorBox_GetHandle(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetHandle)
    return (HWND)(((SYSCALL1) (pColorBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetParentWindow)
HWND
ColorBox_GetParentWindow(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pColorBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParentWindow)
void
ColorBox_SetParentWindow(TColorBox AObj, HWND AValue) {
    GET_FUNC_ADDR(ColorBox_SetParentWindow)
    (((SYSCALL2) (pColorBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetShowing)
BOOL
ColorBox_GetShowing(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pColorBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetUseDockManager)
BOOL
ColorBox_GetUseDockManager(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pColorBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetUseDockManager)
void
ColorBox_SetUseDockManager(TColorBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorBox_SetUseDockManager)
    (((SYSCALL2) (pColorBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAction)
TAction
ColorBox_GetAction(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAction)
    return (TAction)(((SYSCALL1) (pColorBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAction)
void
ColorBox_SetAction(TColorBox AObj, TAction AValue) {
    GET_FUNC_ADDR(ColorBox_SetAction)
    (((SYSCALL2) (pColorBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetBoundsRect)
TRect
ColorBox_GetBoundsRect(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pColorBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_SetBoundsRect)
void
ColorBox_SetBoundsRect(TColorBox AObj, TRect AValue) {
    GET_FUNC_ADDR(ColorBox_SetBoundsRect)
    (((SYSCALL2) (pColorBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetClientHeight)
int32_t
ColorBox_GetClientHeight(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pColorBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetClientHeight)
void
ColorBox_SetClientHeight(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetClientHeight)
    (((SYSCALL2) (pColorBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetClientOrigin)
TPoint
ColorBox_GetClientOrigin(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pColorBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_GetClientRect)
TRect
ColorBox_GetClientRect(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pColorBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorBox_GetClientWidth)
int32_t
ColorBox_GetClientWidth(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pColorBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetClientWidth)
void
ColorBox_SetClientWidth(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetClientWidth)
    (((SYSCALL2) (pColorBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetControlState)
TControlState
ColorBox_GetControlState(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pColorBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetControlState)
void
ColorBox_SetControlState(TColorBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(ColorBox_SetControlState)
    (((SYSCALL2) (pColorBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetControlStyle)
TControlStyle
ColorBox_GetControlStyle(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pColorBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetControlStyle)
void
ColorBox_SetControlStyle(TColorBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(ColorBox_SetControlStyle)
    (((SYSCALL2) (pColorBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetFloating)
BOOL
ColorBox_GetFloating(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pColorBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetParent)
TWinControl
ColorBox_GetParent(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pColorBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetParent)
void
ColorBox_SetParent(TColorBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(ColorBox_SetParent)
    (((SYSCALL2) (pColorBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetLeft)
int32_t
ColorBox_GetLeft(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pColorBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetLeft)
void
ColorBox_SetLeft(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetLeft)
    (((SYSCALL2) (pColorBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetTop)
int32_t
ColorBox_GetTop(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetTop)
    return (int32_t)(((SYSCALL1) (pColorBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetTop)
void
ColorBox_SetTop(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetTop)
    (((SYSCALL2) (pColorBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetWidth)
int32_t
ColorBox_GetWidth(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pColorBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetWidth)
void
ColorBox_SetWidth(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetWidth)
    (((SYSCALL2) (pColorBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetHeight)
int32_t
ColorBox_GetHeight(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pColorBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetHeight)
void
ColorBox_SetHeight(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetHeight)
    (((SYSCALL2) (pColorBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetCursor)
TCursor
ColorBox_GetCursor(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pColorBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetCursor)
void
ColorBox_SetCursor(TColorBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ColorBox_SetCursor)
    (((SYSCALL2) (pColorBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetHint)
char*
ColorBox_GetHint(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetHint)
    return (char*)(((SYSCALL1) (pColorBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetHint)
void
ColorBox_SetHint(TColorBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorBox_SetHint)
    (((SYSCALL2) (pColorBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetComponentCount)
int32_t
ColorBox_GetComponentCount(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pColorBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetComponentIndex)
int32_t
ColorBox_GetComponentIndex(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pColorBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetComponentIndex)
void
ColorBox_SetComponentIndex(TColorBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetComponentIndex)
    (((SYSCALL2) (pColorBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetOwner)
TComponent
ColorBox_GetOwner(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pColorBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_GetName)
char*
ColorBox_GetName(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetName)
    return (char*)(((SYSCALL1) (pColorBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetName)
void
ColorBox_SetName(TColorBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorBox_SetName)
    (((SYSCALL2) (pColorBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetTag)
intptr_t
ColorBox_GetTag(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pColorBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetTag)
void
ColorBox_SetTag(TColorBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(ColorBox_SetTag)
    (((SYSCALL2) (pColorBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchorSideLeft)
TAnchorSide
ColorBox_GetAnchorSideLeft(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pColorBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAnchorSideLeft)
void
ColorBox_SetAnchorSideLeft(TColorBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorBox_SetAnchorSideLeft)
    (((SYSCALL2) (pColorBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchorSideTop)
TAnchorSide
ColorBox_GetAnchorSideTop(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pColorBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAnchorSideTop)
void
ColorBox_SetAnchorSideTop(TColorBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorBox_SetAnchorSideTop)
    (((SYSCALL2) (pColorBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchorSideRight)
TAnchorSide
ColorBox_GetAnchorSideRight(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pColorBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAnchorSideRight)
void
ColorBox_SetAnchorSideRight(TColorBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorBox_SetAnchorSideRight)
    (((SYSCALL2) (pColorBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchorSideBottom)
TAnchorSide
ColorBox_GetAnchorSideBottom(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pColorBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetAnchorSideBottom)
void
ColorBox_SetAnchorSideBottom(TColorBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorBox_SetAnchorSideBottom)
    (((SYSCALL2) (pColorBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetChildSizing)
TControlChildSizing
ColorBox_GetChildSizing(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pColorBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetChildSizing)
void
ColorBox_SetChildSizing(TColorBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(ColorBox_SetChildSizing)
    (((SYSCALL2) (pColorBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetBorderSpacing)
TControlBorderSpacing
ColorBox_GetBorderSpacing(TColorBox AObj) {
    GET_FUNC_ADDR(ColorBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pColorBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorBox_SetBorderSpacing)
void
ColorBox_SetBorderSpacing(TColorBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(ColorBox_SetBorderSpacing)
    (((SYSCALL2) (pColorBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorBox_GetColors)
TColor
ColorBox_GetColors(TColorBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorBox_GetColors)
    return (TColor)(((SYSCALL2) (pColorBox_GetColors))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorBox_GetColorNames)
char*
ColorBox_GetColorNames(TColorBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorBox_GetColorNames)
    return (char*)(((SYSCALL2) (pColorBox_GetColorNames))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorBox_GetDockClients)
TControl
ColorBox_GetDockClients(TColorBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pColorBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorBox_GetControls)
TControl
ColorBox_GetControls(TColorBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorBox_GetControls)
    return (TControl)(((SYSCALL2) (pColorBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorBox_GetComponents)
TComponent
ColorBox_GetComponents(TColorBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(ColorBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pColorBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(ColorBox_GetAnchorSide)
TAnchorSide
ColorBox_GetAnchorSide(TColorBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(ColorBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pColorBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(ColorBox_StaticClassType)
TClass
ColorBox_StaticClassType() {
    GET_FUNC_ADDR(ColorBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pColorBox_StaticClassType))());
}

// -------------------TColorListBox-------------------

DEFINE_FUNC_PTR(ColorListBox_Create)
TColorListBox
ColorListBox_Create(TComponent AOwner) {
    GET_FUNC_ADDR(ColorListBox_Create)
    return (TColorListBox)(((SYSCALL1) (pColorListBox_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(ColorListBox_Free)
void
ColorListBox_Free(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Free)
    (((SYSCALL1) (pColorListBox_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_AddItem)
void
ColorListBox_AddItem(TColorListBox AObj, CChar char* Item, TObject AObject) {
    GET_FUNC_ADDR(ColorListBox_AddItem)
    (((SYSCALL3) (pColorListBox_AddItem))(COV_PARAM(AObj), COV_PARAM(Item), COV_PARAM(AObject)));
}

DEFINE_FUNC_PTR(ColorListBox_Clear)
void
ColorListBox_Clear(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Clear)
    (((SYSCALL1) (pColorListBox_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ClearSelection)
void
ColorListBox_ClearSelection(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_ClearSelection)
    (((SYSCALL1) (pColorListBox_ClearSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_DeleteSelected)
void
ColorListBox_DeleteSelected(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_DeleteSelected)
    (((SYSCALL1) (pColorListBox_DeleteSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ItemAtPos)
int32_t
ColorListBox_ItemAtPos(TColorListBox AObj, TPoint Pos, BOOL Existing) {
    GET_FUNC_ADDR(ColorListBox_ItemAtPos)
    return (int32_t)(((SYSCALL3) (pColorListBox_ItemAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(Existing)));
}

DEFINE_FUNC_PTR(ColorListBox_ItemRect)
TRect
ColorListBox_ItemRect(TColorListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorListBox_ItemRect)
    TRect result;
    (((SYSCALL3) (pColorListBox_ItemRect))(COV_PARAM(AObj), COV_PARAM(Index), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_SelectAll)
void
ColorListBox_SelectAll(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_SelectAll)
    (((SYSCALL1) (pColorListBox_SelectAll))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_CanFocus)
BOOL
ColorListBox_CanFocus(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_CanFocus)
    return (BOOL)(((SYSCALL1) (pColorListBox_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ContainsControl)
BOOL
ColorListBox_ContainsControl(TColorListBox AObj, TControl Control) {
    GET_FUNC_ADDR(ColorListBox_ContainsControl)
    return (BOOL)(((SYSCALL2) (pColorListBox_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(ColorListBox_ControlAtPos)
TControl
ColorListBox_ControlAtPos(TColorListBox AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(ColorListBox_ControlAtPos)
    return (TControl)(((SYSCALL4) (pColorListBox_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(ColorListBox_DisableAlign)
void
ColorListBox_DisableAlign(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_DisableAlign)
    (((SYSCALL1) (pColorListBox_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_EnableAlign)
void
ColorListBox_EnableAlign(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_EnableAlign)
    (((SYSCALL1) (pColorListBox_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_FindChildControl)
TControl
ColorListBox_FindChildControl(TColorListBox AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(ColorListBox_FindChildControl)
    return (TControl)(((SYSCALL2) (pColorListBox_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(ColorListBox_FlipChildren)
void
ColorListBox_FlipChildren(TColorListBox AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(ColorListBox_FlipChildren)
    (((SYSCALL2) (pColorListBox_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(ColorListBox_Focused)
BOOL
ColorListBox_Focused(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Focused)
    return (BOOL)(((SYSCALL1) (pColorListBox_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_HandleAllocated)
BOOL
ColorListBox_HandleAllocated(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pColorListBox_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_InsertControl)
void
ColorListBox_InsertControl(TColorListBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ColorListBox_InsertControl)
    (((SYSCALL2) (pColorListBox_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ColorListBox_Invalidate)
void
ColorListBox_Invalidate(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Invalidate)
    (((SYSCALL1) (pColorListBox_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_PaintTo)
void
ColorListBox_PaintTo(TColorListBox AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(ColorListBox_PaintTo)
    (((SYSCALL4) (pColorListBox_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(ColorListBox_RemoveControl)
void
ColorListBox_RemoveControl(TColorListBox AObj, TControl AControl) {
    GET_FUNC_ADDR(ColorListBox_RemoveControl)
    (((SYSCALL2) (pColorListBox_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(ColorListBox_Realign)
void
ColorListBox_Realign(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Realign)
    (((SYSCALL1) (pColorListBox_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Repaint)
void
ColorListBox_Repaint(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Repaint)
    (((SYSCALL1) (pColorListBox_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleBy)
void
ColorListBox_ScaleBy(TColorListBox AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(ColorListBox_ScaleBy)
    (((SYSCALL3) (pColorListBox_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(ColorListBox_ScrollBy)
void
ColorListBox_ScrollBy(TColorListBox AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(ColorListBox_ScrollBy)
    (((SYSCALL3) (pColorListBox_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(ColorListBox_SetBounds)
void
ColorListBox_SetBounds(TColorListBox AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(ColorListBox_SetBounds)
    (((SYSCALL5) (pColorListBox_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(ColorListBox_SetFocus)
void
ColorListBox_SetFocus(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_SetFocus)
    (((SYSCALL1) (pColorListBox_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Update)
void
ColorListBox_Update(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Update)
    (((SYSCALL1) (pColorListBox_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_BringToFront)
void
ColorListBox_BringToFront(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_BringToFront)
    (((SYSCALL1) (pColorListBox_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ClientToScreen)
TPoint
ColorListBox_ClientToScreen(TColorListBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ColorListBox_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pColorListBox_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_ClientToParent)
TPoint
ColorListBox_ClientToParent(TColorListBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ColorListBox_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pColorListBox_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_Dragging)
BOOL
ColorListBox_Dragging(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Dragging)
    return (BOOL)(((SYSCALL1) (pColorListBox_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_HasParent)
BOOL
ColorListBox_HasParent(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_HasParent)
    return (BOOL)(((SYSCALL1) (pColorListBox_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Hide)
void
ColorListBox_Hide(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Hide)
    (((SYSCALL1) (pColorListBox_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Perform)
intptr_t
ColorListBox_Perform(TColorListBox AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(ColorListBox_Perform)
    return (intptr_t)(((SYSCALL4) (pColorListBox_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(ColorListBox_Refresh)
void
ColorListBox_Refresh(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Refresh)
    (((SYSCALL1) (pColorListBox_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ScreenToClient)
TPoint
ColorListBox_ScreenToClient(TColorListBox AObj, TPoint Point) {
    GET_FUNC_ADDR(ColorListBox_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pColorListBox_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_ParentToClient)
TPoint
ColorListBox_ParentToClient(TColorListBox AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(ColorListBox_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pColorListBox_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_SendToBack)
void
ColorListBox_SendToBack(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_SendToBack)
    (((SYSCALL1) (pColorListBox_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Show)
void
ColorListBox_Show(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_Show)
    (((SYSCALL1) (pColorListBox_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTextBuf)
int32_t
ColorListBox_GetTextBuf(TColorListBox AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(ColorListBox_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pColorListBox_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTextLen)
int32_t
ColorListBox_GetTextLen(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTextLen)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTextBuf)
void
ColorListBox_SetTextBuf(TColorListBox AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(ColorListBox_SetTextBuf)
    (((SYSCALL2) (pColorListBox_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(ColorListBox_FindComponent)
TComponent
ColorListBox_FindComponent(TColorListBox AObj, CChar char* AName) {
    GET_FUNC_ADDR(ColorListBox_FindComponent)
    return (TComponent)(((SYSCALL2) (pColorListBox_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(ColorListBox_GetNamePath)
char*
ColorListBox_GetNamePath(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetNamePath)
    return (char*)(((SYSCALL1) (pColorListBox_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_Assign)
void
ColorListBox_Assign(TColorListBox AObj, TObject Source) {
    GET_FUNC_ADDR(ColorListBox_Assign)
    (((SYSCALL2) (pColorListBox_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(ColorListBox_ClassType)
TClass
ColorListBox_ClassType(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_ClassType)
    return (TClass)(((SYSCALL1) (pColorListBox_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ClassName)
char*
ColorListBox_ClassName(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_ClassName)
    return (char*)(((SYSCALL1) (pColorListBox_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_InstanceSize)
int32_t
ColorListBox_InstanceSize(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_InstanceSize)
    return (int32_t)(((SYSCALL1) (pColorListBox_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_InheritsFrom)
BOOL
ColorListBox_InheritsFrom(TColorListBox AObj, TClass AClass) {
    GET_FUNC_ADDR(ColorListBox_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pColorListBox_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(ColorListBox_Equals)
BOOL
ColorListBox_Equals(TColorListBox AObj, TObject Obj) {
    GET_FUNC_ADDR(ColorListBox_Equals)
    return (BOOL)(((SYSCALL2) (pColorListBox_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetHashCode)
int32_t
ColorListBox_GetHashCode(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetHashCode)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_ToString)
char*
ColorListBox_ToString(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_ToString)
    return (char*)(((SYSCALL1) (pColorListBox_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorToNeighbour)
void
ColorListBox_AnchorToNeighbour(TColorListBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ColorListBox_AnchorToNeighbour)
    (((SYSCALL4) (pColorListBox_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorParallel)
void
ColorListBox_AnchorParallel(TColorListBox AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(ColorListBox_AnchorParallel)
    (((SYSCALL4) (pColorListBox_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorHorizontalCenterTo)
void
ColorListBox_AnchorHorizontalCenterTo(TColorListBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ColorListBox_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pColorListBox_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorVerticalCenterTo)
void
ColorListBox_AnchorVerticalCenterTo(TColorListBox AObj, TControl ASibling) {
    GET_FUNC_ADDR(ColorListBox_AnchorVerticalCenterTo)
    (((SYSCALL2) (pColorListBox_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorSame)
void
ColorListBox_AnchorSame(TColorListBox AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(ColorListBox_AnchorSame)
    (((SYSCALL3) (pColorListBox_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorAsAlign)
void
ColorListBox_AnchorAsAlign(TColorListBox AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(ColorListBox_AnchorAsAlign)
    (((SYSCALL3) (pColorListBox_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ColorListBox_AnchorClient)
void
ColorListBox_AnchorClient(TColorListBox AObj, int32_t ASpace) {
    GET_FUNC_ADDR(ColorListBox_AnchorClient)
    (((SYSCALL2) (pColorListBox_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleDesignToForm)
int32_t
ColorListBox_ScaleDesignToForm(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleFormToDesign)
int32_t
ColorListBox_ScaleFormToDesign(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_Scale96ToForm)
int32_t
ColorListBox_Scale96ToForm(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pColorListBox_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleFormTo96)
int32_t
ColorListBox_ScaleFormTo96(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_Scale96ToFont)
int32_t
ColorListBox_Scale96ToFont(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pColorListBox_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleFontTo96)
int32_t
ColorListBox_ScaleFontTo96(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleScreenToFont)
int32_t
ColorListBox_ScaleScreenToFont(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleFontToScreen)
int32_t
ColorListBox_ScaleFontToScreen(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_Scale96ToScreen)
int32_t
ColorListBox_Scale96ToScreen(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pColorListBox_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleScreenTo96)
int32_t
ColorListBox_ScaleScreenTo96(TColorListBox AObj, int32_t ASize) {
    GET_FUNC_ADDR(ColorListBox_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pColorListBox_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(ColorListBox_AutoAdjustLayout)
void
ColorListBox_AutoAdjustLayout(TColorListBox AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(ColorListBox_AutoAdjustLayout)
    (((SYSCALL6) (pColorListBox_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(ColorListBox_FixDesignFontsPPI)
void
ColorListBox_FixDesignFontsPPI(TColorListBox AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(ColorListBox_FixDesignFontsPPI)
    (((SYSCALL2) (pColorListBox_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(ColorListBox_ScaleFontsPPI)
void
ColorListBox_ScaleFontsPPI(TColorListBox AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(ColorListBox_ScaleFontsPPI)
    (((SYSCALL3) (pColorListBox_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAlign)
TAlign
ColorListBox_GetAlign(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAlign)
    return (TAlign)(((SYSCALL1) (pColorListBox_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAlign)
void
ColorListBox_SetAlign(TColorListBox AObj, TAlign AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAlign)
    (((SYSCALL2) (pColorListBox_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetDefaultColorColor)
TColor
ColorListBox_GetDefaultColorColor(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetDefaultColorColor)
    return (TColor)(((SYSCALL1) (pColorListBox_GetDefaultColorColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetDefaultColorColor)
void
ColorListBox_SetDefaultColorColor(TColorListBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorListBox_SetDefaultColorColor)
    (((SYSCALL2) (pColorListBox_SetDefaultColorColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetNoneColorColor)
TColor
ColorListBox_GetNoneColorColor(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetNoneColorColor)
    return (TColor)(((SYSCALL1) (pColorListBox_GetNoneColorColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetNoneColorColor)
void
ColorListBox_SetNoneColorColor(TColorListBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorListBox_SetNoneColorColor)
    (((SYSCALL2) (pColorListBox_SetNoneColorColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetSelected)
TColor
ColorListBox_GetSelected(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetSelected)
    return (TColor)(((SYSCALL1) (pColorListBox_GetSelected))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetSelected)
void
ColorListBox_SetSelected(TColorListBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorListBox_SetSelected)
    (((SYSCALL2) (pColorListBox_SetSelected))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetStyle)
TColorBoxStyle
ColorListBox_GetStyle(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetStyle)
    return (TColorBoxStyle)(((SYSCALL1) (pColorListBox_GetStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetStyle)
void
ColorListBox_SetStyle(TColorListBox AObj, TColorBoxStyle AValue) {
    GET_FUNC_ADDR(ColorListBox_SetStyle)
    (((SYSCALL2) (pColorListBox_SetStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchors)
TAnchors
ColorListBox_GetAnchors(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pColorListBox_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAnchors)
void
ColorListBox_SetAnchors(TColorListBox AObj, TAnchors AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAnchors)
    (((SYSCALL2) (pColorListBox_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetBiDiMode)
TBiDiMode
ColorListBox_GetBiDiMode(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pColorListBox_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetBiDiMode)
void
ColorListBox_SetBiDiMode(TColorListBox AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(ColorListBox_SetBiDiMode)
    (((SYSCALL2) (pColorListBox_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetColor)
TColor
ColorListBox_GetColor(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetColor)
    return (TColor)(((SYSCALL1) (pColorListBox_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetColor)
void
ColorListBox_SetColor(TColorListBox AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorListBox_SetColor)
    (((SYSCALL2) (pColorListBox_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetConstraints)
TSizeConstraints
ColorListBox_GetConstraints(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pColorListBox_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetConstraints)
void
ColorListBox_SetConstraints(TColorListBox AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(ColorListBox_SetConstraints)
    (((SYSCALL2) (pColorListBox_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetDoubleBuffered)
BOOL
ColorListBox_GetDoubleBuffered(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetDoubleBuffered)
void
ColorListBox_SetDoubleBuffered(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetDoubleBuffered)
    (((SYSCALL2) (pColorListBox_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetEnabled)
BOOL
ColorListBox_GetEnabled(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetEnabled)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetEnabled)
void
ColorListBox_SetEnabled(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetEnabled)
    (((SYSCALL2) (pColorListBox_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetFont)
TFont
ColorListBox_GetFont(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetFont)
    return (TFont)(((SYSCALL1) (pColorListBox_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetFont)
void
ColorListBox_SetFont(TColorListBox AObj, TFont AValue) {
    GET_FUNC_ADDR(ColorListBox_SetFont)
    (((SYSCALL2) (pColorListBox_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetItemHeight)
int32_t
ColorListBox_GetItemHeight(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetItemHeight)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetItemHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetItemHeight)
void
ColorListBox_SetItemHeight(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetItemHeight)
    (((SYSCALL2) (pColorListBox_SetItemHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParentColor)
BOOL
ColorListBox_GetParentColor(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParentColor)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParentColor)
void
ColorListBox_SetParentColor(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParentColor)
    (((SYSCALL2) (pColorListBox_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParentDoubleBuffered)
BOOL
ColorListBox_GetParentDoubleBuffered(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParentDoubleBuffered)
void
ColorListBox_SetParentDoubleBuffered(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParentDoubleBuffered)
    (((SYSCALL2) (pColorListBox_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParentFont)
BOOL
ColorListBox_GetParentFont(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParentFont)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParentFont)
void
ColorListBox_SetParentFont(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParentFont)
    (((SYSCALL2) (pColorListBox_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParentShowHint)
BOOL
ColorListBox_GetParentShowHint(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParentShowHint)
void
ColorListBox_SetParentShowHint(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParentShowHint)
    (((SYSCALL2) (pColorListBox_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetPopupMenu)
TPopupMenu
ColorListBox_GetPopupMenu(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pColorListBox_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetPopupMenu)
void
ColorListBox_SetPopupMenu(TColorListBox AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(ColorListBox_SetPopupMenu)
    (((SYSCALL2) (pColorListBox_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetShowHint)
BOOL
ColorListBox_GetShowHint(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetShowHint)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetShowHint)
void
ColorListBox_SetShowHint(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetShowHint)
    (((SYSCALL2) (pColorListBox_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTabOrder)
TTabOrder
ColorListBox_GetTabOrder(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pColorListBox_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTabOrder)
void
ColorListBox_SetTabOrder(TColorListBox AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(ColorListBox_SetTabOrder)
    (((SYSCALL2) (pColorListBox_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTabStop)
BOOL
ColorListBox_GetTabStop(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTabStop)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTabStop)
void
ColorListBox_SetTabStop(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetTabStop)
    (((SYSCALL2) (pColorListBox_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetVisible)
BOOL
ColorListBox_GetVisible(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetVisible)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetVisible)
void
ColorListBox_SetVisible(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetVisible)
    (((SYSCALL2) (pColorListBox_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnClick)
void
ColorListBox_SetOnClick(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnClick)
    (((SYSCALL2) (pColorListBox_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnContextPopup)
void
ColorListBox_SetOnContextPopup(TColorListBox AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnContextPopup)
    (((SYSCALL2) (pColorListBox_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnDblClick)
void
ColorListBox_SetOnDblClick(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnDblClick)
    (((SYSCALL2) (pColorListBox_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnDragDrop)
void
ColorListBox_SetOnDragDrop(TColorListBox AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnDragDrop)
    (((SYSCALL2) (pColorListBox_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnDragOver)
void
ColorListBox_SetOnDragOver(TColorListBox AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnDragOver)
    (((SYSCALL2) (pColorListBox_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnEndDrag)
void
ColorListBox_SetOnEndDrag(TColorListBox AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnEndDrag)
    (((SYSCALL2) (pColorListBox_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnEnter)
void
ColorListBox_SetOnEnter(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnEnter)
    (((SYSCALL2) (pColorListBox_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnExit)
void
ColorListBox_SetOnExit(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnExit)
    (((SYSCALL2) (pColorListBox_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnKeyDown)
void
ColorListBox_SetOnKeyDown(TColorListBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnKeyDown)
    (((SYSCALL2) (pColorListBox_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnKeyPress)
void
ColorListBox_SetOnKeyPress(TColorListBox AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnKeyPress)
    (((SYSCALL2) (pColorListBox_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnKeyUp)
void
ColorListBox_SetOnKeyUp(TColorListBox AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnKeyUp)
    (((SYSCALL2) (pColorListBox_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnMouseDown)
void
ColorListBox_SetOnMouseDown(TColorListBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnMouseDown)
    (((SYSCALL2) (pColorListBox_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnMouseEnter)
void
ColorListBox_SetOnMouseEnter(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnMouseEnter)
    (((SYSCALL2) (pColorListBox_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnMouseLeave)
void
ColorListBox_SetOnMouseLeave(TColorListBox AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnMouseLeave)
    (((SYSCALL2) (pColorListBox_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnMouseMove)
void
ColorListBox_SetOnMouseMove(TColorListBox AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnMouseMove)
    (((SYSCALL2) (pColorListBox_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_SetOnMouseUp)
void
ColorListBox_SetOnMouseUp(TColorListBox AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(ColorListBox_SetOnMouseUp)
    (((SYSCALL2) (pColorListBox_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorListBox_GetCanvas)
TCanvas
ColorListBox_GetCanvas(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetCanvas)
    return (TCanvas)(((SYSCALL1) (pColorListBox_GetCanvas))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetCount)
int32_t
ColorListBox_GetCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetItems)
TStrings
ColorListBox_GetItems(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetItems)
    return (TStrings)(((SYSCALL1) (pColorListBox_GetItems))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetItems)
void
ColorListBox_SetItems(TColorListBox AObj, TStrings AValue) {
    GET_FUNC_ADDR(ColorListBox_SetItems)
    (((SYSCALL2) (pColorListBox_SetItems))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTopIndex)
int32_t
ColorListBox_GetTopIndex(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTopIndex)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetTopIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTopIndex)
void
ColorListBox_SetTopIndex(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetTopIndex)
    (((SYSCALL2) (pColorListBox_SetTopIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetMultiSelect)
BOOL
ColorListBox_GetMultiSelect(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetMultiSelect)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetMultiSelect))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetMultiSelect)
void
ColorListBox_SetMultiSelect(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetMultiSelect)
    (((SYSCALL2) (pColorListBox_SetMultiSelect))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetSelCount)
int32_t
ColorListBox_GetSelCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetSelCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetSelCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetItemIndex)
int32_t
ColorListBox_GetItemIndex(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetItemIndex)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetItemIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetItemIndex)
void
ColorListBox_SetItemIndex(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetItemIndex)
    (((SYSCALL2) (pColorListBox_SetItemIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetDockClientCount)
int32_t
ColorListBox_GetDockClientCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetDockSite)
BOOL
ColorListBox_GetDockSite(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetDockSite)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetDockSite)
void
ColorListBox_SetDockSite(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetDockSite)
    (((SYSCALL2) (pColorListBox_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetMouseInClient)
BOOL
ColorListBox_GetMouseInClient(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetVisibleDockClientCount)
int32_t
ColorListBox_GetVisibleDockClientCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetBrush)
TBrush
ColorListBox_GetBrush(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetBrush)
    return (TBrush)(((SYSCALL1) (pColorListBox_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetControlCount)
int32_t
ColorListBox_GetControlCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetControlCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetHandle)
HWND
ColorListBox_GetHandle(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetHandle)
    return (HWND)(((SYSCALL1) (pColorListBox_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParentWindow)
HWND
ColorListBox_GetParentWindow(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParentWindow)
    return (HWND)(((SYSCALL1) (pColorListBox_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParentWindow)
void
ColorListBox_SetParentWindow(TColorListBox AObj, HWND AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParentWindow)
    (((SYSCALL2) (pColorListBox_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetShowing)
BOOL
ColorListBox_GetShowing(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetShowing)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetUseDockManager)
BOOL
ColorListBox_GetUseDockManager(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetUseDockManager)
void
ColorListBox_SetUseDockManager(TColorListBox AObj, BOOL AValue) {
    GET_FUNC_ADDR(ColorListBox_SetUseDockManager)
    (((SYSCALL2) (pColorListBox_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAction)
TAction
ColorListBox_GetAction(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAction)
    return (TAction)(((SYSCALL1) (pColorListBox_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAction)
void
ColorListBox_SetAction(TColorListBox AObj, TAction AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAction)
    (((SYSCALL2) (pColorListBox_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetBoundsRect)
TRect
ColorListBox_GetBoundsRect(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pColorListBox_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_SetBoundsRect)
void
ColorListBox_SetBoundsRect(TColorListBox AObj, TRect AValue) {
    GET_FUNC_ADDR(ColorListBox_SetBoundsRect)
    (((SYSCALL2) (pColorListBox_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetClientHeight)
int32_t
ColorListBox_GetClientHeight(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetClientHeight)
void
ColorListBox_SetClientHeight(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetClientHeight)
    (((SYSCALL2) (pColorListBox_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetClientOrigin)
TPoint
ColorListBox_GetClientOrigin(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pColorListBox_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_GetClientRect)
TRect
ColorListBox_GetClientRect(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetClientRect)
    TRect result;
    (((SYSCALL2) (pColorListBox_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(ColorListBox_GetClientWidth)
int32_t
ColorListBox_GetClientWidth(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetClientWidth)
void
ColorListBox_SetClientWidth(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetClientWidth)
    (((SYSCALL2) (pColorListBox_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetControlState)
TControlState
ColorListBox_GetControlState(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetControlState)
    return (TControlState)(((SYSCALL1) (pColorListBox_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetControlState)
void
ColorListBox_SetControlState(TColorListBox AObj, TControlState AValue) {
    GET_FUNC_ADDR(ColorListBox_SetControlState)
    (((SYSCALL2) (pColorListBox_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetControlStyle)
TControlStyle
ColorListBox_GetControlStyle(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pColorListBox_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetControlStyle)
void
ColorListBox_SetControlStyle(TColorListBox AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(ColorListBox_SetControlStyle)
    (((SYSCALL2) (pColorListBox_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetFloating)
BOOL
ColorListBox_GetFloating(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetFloating)
    return (BOOL)(((SYSCALL1) (pColorListBox_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetParent)
TWinControl
ColorListBox_GetParent(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetParent)
    return (TWinControl)(((SYSCALL1) (pColorListBox_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetParent)
void
ColorListBox_SetParent(TColorListBox AObj, TWinControl AValue) {
    GET_FUNC_ADDR(ColorListBox_SetParent)
    (((SYSCALL2) (pColorListBox_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetLeft)
int32_t
ColorListBox_GetLeft(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetLeft)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetLeft)
void
ColorListBox_SetLeft(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetLeft)
    (((SYSCALL2) (pColorListBox_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTop)
int32_t
ColorListBox_GetTop(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTop)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTop)
void
ColorListBox_SetTop(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetTop)
    (((SYSCALL2) (pColorListBox_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetWidth)
int32_t
ColorListBox_GetWidth(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetWidth)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetWidth)
void
ColorListBox_SetWidth(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetWidth)
    (((SYSCALL2) (pColorListBox_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetHeight)
int32_t
ColorListBox_GetHeight(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetHeight)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetHeight)
void
ColorListBox_SetHeight(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetHeight)
    (((SYSCALL2) (pColorListBox_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetCursor)
TCursor
ColorListBox_GetCursor(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetCursor)
    return (TCursor)(((SYSCALL1) (pColorListBox_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetCursor)
void
ColorListBox_SetCursor(TColorListBox AObj, TCursor AValue) {
    GET_FUNC_ADDR(ColorListBox_SetCursor)
    (((SYSCALL2) (pColorListBox_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetHint)
char*
ColorListBox_GetHint(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetHint)
    return (char*)(((SYSCALL1) (pColorListBox_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetHint)
void
ColorListBox_SetHint(TColorListBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorListBox_SetHint)
    (((SYSCALL2) (pColorListBox_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetComponentCount)
int32_t
ColorListBox_GetComponentCount(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetComponentIndex)
int32_t
ColorListBox_GetComponentIndex(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pColorListBox_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetComponentIndex)
void
ColorListBox_SetComponentIndex(TColorListBox AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetComponentIndex)
    (((SYSCALL2) (pColorListBox_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetOwner)
TComponent
ColorListBox_GetOwner(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetOwner)
    return (TComponent)(((SYSCALL1) (pColorListBox_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_GetName)
char*
ColorListBox_GetName(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetName)
    return (char*)(((SYSCALL1) (pColorListBox_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetName)
void
ColorListBox_SetName(TColorListBox AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorListBox_SetName)
    (((SYSCALL2) (pColorListBox_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetTag)
intptr_t
ColorListBox_GetTag(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetTag)
    return (intptr_t)(((SYSCALL1) (pColorListBox_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetTag)
void
ColorListBox_SetTag(TColorListBox AObj, intptr_t AValue) {
    GET_FUNC_ADDR(ColorListBox_SetTag)
    (((SYSCALL2) (pColorListBox_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchorSideLeft)
TAnchorSide
ColorListBox_GetAnchorSideLeft(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pColorListBox_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAnchorSideLeft)
void
ColorListBox_SetAnchorSideLeft(TColorListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAnchorSideLeft)
    (((SYSCALL2) (pColorListBox_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchorSideTop)
TAnchorSide
ColorListBox_GetAnchorSideTop(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pColorListBox_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAnchorSideTop)
void
ColorListBox_SetAnchorSideTop(TColorListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAnchorSideTop)
    (((SYSCALL2) (pColorListBox_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchorSideRight)
TAnchorSide
ColorListBox_GetAnchorSideRight(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pColorListBox_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAnchorSideRight)
void
ColorListBox_SetAnchorSideRight(TColorListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAnchorSideRight)
    (((SYSCALL2) (pColorListBox_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchorSideBottom)
TAnchorSide
ColorListBox_GetAnchorSideBottom(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pColorListBox_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetAnchorSideBottom)
void
ColorListBox_SetAnchorSideBottom(TColorListBox AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(ColorListBox_SetAnchorSideBottom)
    (((SYSCALL2) (pColorListBox_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetChildSizing)
TControlChildSizing
ColorListBox_GetChildSizing(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pColorListBox_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetChildSizing)
void
ColorListBox_SetChildSizing(TColorListBox AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(ColorListBox_SetChildSizing)
    (((SYSCALL2) (pColorListBox_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetBorderSpacing)
TControlBorderSpacing
ColorListBox_GetBorderSpacing(TColorListBox AObj) {
    GET_FUNC_ADDR(ColorListBox_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pColorListBox_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorListBox_SetBorderSpacing)
void
ColorListBox_SetBorderSpacing(TColorListBox AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(ColorListBox_SetBorderSpacing)
    (((SYSCALL2) (pColorListBox_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorListBox_GetColors)
TColor
ColorListBox_GetColors(TColorListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorListBox_GetColors)
    return (TColor)(((SYSCALL2) (pColorListBox_GetColors))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorListBox_GetColorNames)
char*
ColorListBox_GetColorNames(TColorListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorListBox_GetColorNames)
    return (char*)(((SYSCALL2) (pColorListBox_GetColorNames))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorListBox_GetDockClients)
TControl
ColorListBox_GetDockClients(TColorListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorListBox_GetDockClients)
    return (TControl)(((SYSCALL2) (pColorListBox_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorListBox_GetControls)
TControl
ColorListBox_GetControls(TColorListBox AObj, int32_t Index) {
    GET_FUNC_ADDR(ColorListBox_GetControls)
    return (TControl)(((SYSCALL2) (pColorListBox_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(ColorListBox_GetComponents)
TComponent
ColorListBox_GetComponents(TColorListBox AObj, int32_t AIndex) {
    GET_FUNC_ADDR(ColorListBox_GetComponents)
    return (TComponent)(((SYSCALL2) (pColorListBox_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(ColorListBox_GetAnchorSide)
TAnchorSide
ColorListBox_GetAnchorSide(TColorListBox AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(ColorListBox_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pColorListBox_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(ColorListBox_StaticClassType)
TClass
ColorListBox_StaticClassType() {
    GET_FUNC_ADDR(ColorListBox_StaticClassType)
    return (TClass)(((SYSCALL0) (pColorListBox_StaticClassType))());
}

// -------------------TTrayIcon-------------------

DEFINE_FUNC_PTR(TrayIcon_Create)
TTrayIcon
TrayIcon_Create(TComponent AOwner) {
    GET_FUNC_ADDR(TrayIcon_Create)
    return (TTrayIcon)(((SYSCALL1) (pTrayIcon_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(TrayIcon_Free)
void
TrayIcon_Free(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_Free)
    (((SYSCALL1) (pTrayIcon_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_ShowBalloonHint)
void
TrayIcon_ShowBalloonHint(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_ShowBalloonHint)
    (((SYSCALL1) (pTrayIcon_ShowBalloonHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_FindComponent)
TComponent
TrayIcon_FindComponent(TTrayIcon AObj, CChar char* AName) {
    GET_FUNC_ADDR(TrayIcon_FindComponent)
    return (TComponent)(((SYSCALL2) (pTrayIcon_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(TrayIcon_GetNamePath)
char*
TrayIcon_GetNamePath(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetNamePath)
    return (char*)(((SYSCALL1) (pTrayIcon_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_HasParent)
BOOL
TrayIcon_HasParent(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_HasParent)
    return (BOOL)(((SYSCALL1) (pTrayIcon_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_Assign)
void
TrayIcon_Assign(TTrayIcon AObj, TObject Source) {
    GET_FUNC_ADDR(TrayIcon_Assign)
    (((SYSCALL2) (pTrayIcon_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(TrayIcon_ClassType)
TClass
TrayIcon_ClassType(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_ClassType)
    return (TClass)(((SYSCALL1) (pTrayIcon_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_ClassName)
char*
TrayIcon_ClassName(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_ClassName)
    return (char*)(((SYSCALL1) (pTrayIcon_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_InstanceSize)
int32_t
TrayIcon_InstanceSize(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_InstanceSize)
    return (int32_t)(((SYSCALL1) (pTrayIcon_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_InheritsFrom)
BOOL
TrayIcon_InheritsFrom(TTrayIcon AObj, TClass AClass) {
    GET_FUNC_ADDR(TrayIcon_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pTrayIcon_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(TrayIcon_Equals)
BOOL
TrayIcon_Equals(TTrayIcon AObj, TObject Obj) {
    GET_FUNC_ADDR(TrayIcon_Equals)
    return (BOOL)(((SYSCALL2) (pTrayIcon_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(TrayIcon_GetHashCode)
int32_t
TrayIcon_GetHashCode(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetHashCode)
    return (int32_t)(((SYSCALL1) (pTrayIcon_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_ToString)
char*
TrayIcon_ToString(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_ToString)
    return (char*)(((SYSCALL1) (pTrayIcon_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_GetAnimateInterval)
uint32_t
TrayIcon_GetAnimateInterval(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetAnimateInterval)
    return (uint32_t)(((SYSCALL1) (pTrayIcon_GetAnimateInterval))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetAnimateInterval)
void
TrayIcon_SetAnimateInterval(TTrayIcon AObj, uint32_t AValue) {
    GET_FUNC_ADDR(TrayIcon_SetAnimateInterval)
    (((SYSCALL2) (pTrayIcon_SetAnimateInterval))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetHint)
char*
TrayIcon_GetHint(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetHint)
    return (char*)(((SYSCALL1) (pTrayIcon_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetHint)
void
TrayIcon_SetHint(TTrayIcon AObj, CChar char* AValue) {
    GET_FUNC_ADDR(TrayIcon_SetHint)
    (((SYSCALL2) (pTrayIcon_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetBalloonHint)
char*
TrayIcon_GetBalloonHint(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetBalloonHint)
    return (char*)(((SYSCALL1) (pTrayIcon_GetBalloonHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetBalloonHint)
void
TrayIcon_SetBalloonHint(TTrayIcon AObj, CChar char* AValue) {
    GET_FUNC_ADDR(TrayIcon_SetBalloonHint)
    (((SYSCALL2) (pTrayIcon_SetBalloonHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetBalloonTitle)
char*
TrayIcon_GetBalloonTitle(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetBalloonTitle)
    return (char*)(((SYSCALL1) (pTrayIcon_GetBalloonTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetBalloonTitle)
void
TrayIcon_SetBalloonTitle(TTrayIcon AObj, CChar char* AValue) {
    GET_FUNC_ADDR(TrayIcon_SetBalloonTitle)
    (((SYSCALL2) (pTrayIcon_SetBalloonTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetBalloonTimeout)
int32_t
TrayIcon_GetBalloonTimeout(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetBalloonTimeout)
    return (int32_t)(((SYSCALL1) (pTrayIcon_GetBalloonTimeout))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetBalloonTimeout)
void
TrayIcon_SetBalloonTimeout(TTrayIcon AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrayIcon_SetBalloonTimeout)
    (((SYSCALL2) (pTrayIcon_SetBalloonTimeout))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetBalloonFlags)
TBalloonFlags
TrayIcon_GetBalloonFlags(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetBalloonFlags)
    return (TBalloonFlags)(((SYSCALL1) (pTrayIcon_GetBalloonFlags))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetBalloonFlags)
void
TrayIcon_SetBalloonFlags(TTrayIcon AObj, TBalloonFlags AValue) {
    GET_FUNC_ADDR(TrayIcon_SetBalloonFlags)
    (((SYSCALL2) (pTrayIcon_SetBalloonFlags))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetIcon)
TIcon
TrayIcon_GetIcon(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetIcon)
    return (TIcon)(((SYSCALL1) (pTrayIcon_GetIcon))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetIcon)
void
TrayIcon_SetIcon(TTrayIcon AObj, TIcon AValue) {
    GET_FUNC_ADDR(TrayIcon_SetIcon)
    (((SYSCALL2) (pTrayIcon_SetIcon))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetPopupMenu)
TPopupMenu
TrayIcon_GetPopupMenu(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pTrayIcon_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetPopupMenu)
void
TrayIcon_SetPopupMenu(TTrayIcon AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(TrayIcon_SetPopupMenu)
    (((SYSCALL2) (pTrayIcon_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetVisible)
BOOL
TrayIcon_GetVisible(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetVisible)
    return (BOOL)(((SYSCALL1) (pTrayIcon_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetVisible)
void
TrayIcon_SetVisible(TTrayIcon AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrayIcon_SetVisible)
    (((SYSCALL2) (pTrayIcon_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_SetOnClick)
void
TrayIcon_SetOnClick(TTrayIcon AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(TrayIcon_SetOnClick)
    (((SYSCALL2) (pTrayIcon_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrayIcon_SetOnDblClick)
void
TrayIcon_SetOnDblClick(TTrayIcon AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(TrayIcon_SetOnDblClick)
    (((SYSCALL2) (pTrayIcon_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrayIcon_SetOnMouseMove)
void
TrayIcon_SetOnMouseMove(TTrayIcon AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(TrayIcon_SetOnMouseMove)
    (((SYSCALL2) (pTrayIcon_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrayIcon_SetOnMouseUp)
void
TrayIcon_SetOnMouseUp(TTrayIcon AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(TrayIcon_SetOnMouseUp)
    (((SYSCALL2) (pTrayIcon_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrayIcon_SetOnMouseDown)
void
TrayIcon_SetOnMouseDown(TTrayIcon AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(TrayIcon_SetOnMouseDown)
    (((SYSCALL2) (pTrayIcon_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrayIcon_GetComponentCount)
int32_t
TrayIcon_GetComponentCount(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pTrayIcon_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_GetComponentIndex)
int32_t
TrayIcon_GetComponentIndex(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pTrayIcon_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetComponentIndex)
void
TrayIcon_SetComponentIndex(TTrayIcon AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrayIcon_SetComponentIndex)
    (((SYSCALL2) (pTrayIcon_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetOwner)
TComponent
TrayIcon_GetOwner(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetOwner)
    return (TComponent)(((SYSCALL1) (pTrayIcon_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_GetName)
char*
TrayIcon_GetName(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetName)
    return (char*)(((SYSCALL1) (pTrayIcon_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetName)
void
TrayIcon_SetName(TTrayIcon AObj, CChar char* AValue) {
    GET_FUNC_ADDR(TrayIcon_SetName)
    (((SYSCALL2) (pTrayIcon_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetTag)
intptr_t
TrayIcon_GetTag(TTrayIcon AObj) {
    GET_FUNC_ADDR(TrayIcon_GetTag)
    return (intptr_t)(((SYSCALL1) (pTrayIcon_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrayIcon_SetTag)
void
TrayIcon_SetTag(TTrayIcon AObj, intptr_t AValue) {
    GET_FUNC_ADDR(TrayIcon_SetTag)
    (((SYSCALL2) (pTrayIcon_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrayIcon_GetComponents)
TComponent
TrayIcon_GetComponents(TTrayIcon AObj, int32_t AIndex) {
    GET_FUNC_ADDR(TrayIcon_GetComponents)
    return (TComponent)(((SYSCALL2) (pTrayIcon_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(TrayIcon_StaticClassType)
TClass
TrayIcon_StaticClassType() {
    GET_FUNC_ADDR(TrayIcon_StaticClassType)
    return (TClass)(((SYSCALL0) (pTrayIcon_StaticClassType))());
}

// -------------------TOpenDialog-------------------

DEFINE_FUNC_PTR(OpenDialog_Create)
TOpenDialog
OpenDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(OpenDialog_Create)
    return (TOpenDialog)(((SYSCALL1) (pOpenDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(OpenDialog_Free)
void
OpenDialog_Free(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_Free)
    (((SYSCALL1) (pOpenDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_Execute)
BOOL
OpenDialog_Execute(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_Execute)
    return (BOOL)(((SYSCALL1) (pOpenDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_FindComponent)
TComponent
OpenDialog_FindComponent(TOpenDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(OpenDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pOpenDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(OpenDialog_GetNamePath)
char*
OpenDialog_GetNamePath(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pOpenDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_HasParent)
BOOL
OpenDialog_HasParent(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pOpenDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_Assign)
void
OpenDialog_Assign(TOpenDialog AObj, TObject Source) {
    GET_FUNC_ADDR(OpenDialog_Assign)
    (((SYSCALL2) (pOpenDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(OpenDialog_ClassType)
TClass
OpenDialog_ClassType(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_ClassType)
    return (TClass)(((SYSCALL1) (pOpenDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_ClassName)
char*
OpenDialog_ClassName(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_ClassName)
    return (char*)(((SYSCALL1) (pOpenDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_InstanceSize)
int32_t
OpenDialog_InstanceSize(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pOpenDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_InheritsFrom)
BOOL
OpenDialog_InheritsFrom(TOpenDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(OpenDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pOpenDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(OpenDialog_Equals)
BOOL
OpenDialog_Equals(TOpenDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(OpenDialog_Equals)
    return (BOOL)(((SYSCALL2) (pOpenDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(OpenDialog_GetHashCode)
int32_t
OpenDialog_GetHashCode(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pOpenDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_ToString)
char*
OpenDialog_ToString(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_ToString)
    return (char*)(((SYSCALL1) (pOpenDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_GetFiles)
TStrings
OpenDialog_GetFiles(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetFiles)
    return (TStrings)(((SYSCALL1) (pOpenDialog_GetFiles))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_GetDefaultExt)
char*
OpenDialog_GetDefaultExt(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetDefaultExt)
    return (char*)(((SYSCALL1) (pOpenDialog_GetDefaultExt))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetDefaultExt)
void
OpenDialog_SetDefaultExt(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetDefaultExt)
    (((SYSCALL2) (pOpenDialog_SetDefaultExt))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetFileName)
char*
OpenDialog_GetFileName(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetFileName)
    return (char*)(((SYSCALL1) (pOpenDialog_GetFileName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetFileName)
void
OpenDialog_SetFileName(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetFileName)
    (((SYSCALL2) (pOpenDialog_SetFileName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetFilter)
char*
OpenDialog_GetFilter(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetFilter)
    return (char*)(((SYSCALL1) (pOpenDialog_GetFilter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetFilter)
void
OpenDialog_SetFilter(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetFilter)
    (((SYSCALL2) (pOpenDialog_SetFilter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetFilterIndex)
int32_t
OpenDialog_GetFilterIndex(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetFilterIndex)
    return (int32_t)(((SYSCALL1) (pOpenDialog_GetFilterIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetFilterIndex)
void
OpenDialog_SetFilterIndex(TOpenDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(OpenDialog_SetFilterIndex)
    (((SYSCALL2) (pOpenDialog_SetFilterIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetInitialDir)
char*
OpenDialog_GetInitialDir(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetInitialDir)
    return (char*)(((SYSCALL1) (pOpenDialog_GetInitialDir))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetInitialDir)
void
OpenDialog_SetInitialDir(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetInitialDir)
    (((SYSCALL2) (pOpenDialog_SetInitialDir))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetOptions)
TOpenOptions
OpenDialog_GetOptions(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetOptions)
    return (TOpenOptions)(((SYSCALL1) (pOpenDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetOptions)
void
OpenDialog_SetOptions(TOpenDialog AObj, TOpenOptions AValue) {
    GET_FUNC_ADDR(OpenDialog_SetOptions)
    (((SYSCALL2) (pOpenDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetTitle)
char*
OpenDialog_GetTitle(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetTitle)
    return (char*)(((SYSCALL1) (pOpenDialog_GetTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetTitle)
void
OpenDialog_SetTitle(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetTitle)
    (((SYSCALL2) (pOpenDialog_SetTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetHandle)
HWND
OpenDialog_GetHandle(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pOpenDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetOnClose)
void
OpenDialog_SetOnClose(TOpenDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(OpenDialog_SetOnClose)
    (((SYSCALL2) (pOpenDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(OpenDialog_SetOnShow)
void
OpenDialog_SetOnShow(TOpenDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(OpenDialog_SetOnShow)
    (((SYSCALL2) (pOpenDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(OpenDialog_GetComponentCount)
int32_t
OpenDialog_GetComponentCount(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pOpenDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_GetComponentIndex)
int32_t
OpenDialog_GetComponentIndex(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pOpenDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetComponentIndex)
void
OpenDialog_SetComponentIndex(TOpenDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(OpenDialog_SetComponentIndex)
    (((SYSCALL2) (pOpenDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetOwner)
TComponent
OpenDialog_GetOwner(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pOpenDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_GetName)
char*
OpenDialog_GetName(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetName)
    return (char*)(((SYSCALL1) (pOpenDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetName)
void
OpenDialog_SetName(TOpenDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenDialog_SetName)
    (((SYSCALL2) (pOpenDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetTag)
intptr_t
OpenDialog_GetTag(TOpenDialog AObj) {
    GET_FUNC_ADDR(OpenDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pOpenDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenDialog_SetTag)
void
OpenDialog_SetTag(TOpenDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(OpenDialog_SetTag)
    (((SYSCALL2) (pOpenDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenDialog_GetComponents)
TComponent
OpenDialog_GetComponents(TOpenDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(OpenDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pOpenDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(OpenDialog_StaticClassType)
TClass
OpenDialog_StaticClassType() {
    GET_FUNC_ADDR(OpenDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pOpenDialog_StaticClassType))());
}

// -------------------TSaveDialog-------------------

DEFINE_FUNC_PTR(SaveDialog_Create)
TSaveDialog
SaveDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(SaveDialog_Create)
    return (TSaveDialog)(((SYSCALL1) (pSaveDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(SaveDialog_Free)
void
SaveDialog_Free(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_Free)
    (((SYSCALL1) (pSaveDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_Execute)
BOOL
SaveDialog_Execute(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_Execute)
    return (BOOL)(((SYSCALL1) (pSaveDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_FindComponent)
TComponent
SaveDialog_FindComponent(TSaveDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(SaveDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pSaveDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(SaveDialog_GetNamePath)
char*
SaveDialog_GetNamePath(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pSaveDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_HasParent)
BOOL
SaveDialog_HasParent(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pSaveDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_Assign)
void
SaveDialog_Assign(TSaveDialog AObj, TObject Source) {
    GET_FUNC_ADDR(SaveDialog_Assign)
    (((SYSCALL2) (pSaveDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(SaveDialog_ClassType)
TClass
SaveDialog_ClassType(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_ClassType)
    return (TClass)(((SYSCALL1) (pSaveDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_ClassName)
char*
SaveDialog_ClassName(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_ClassName)
    return (char*)(((SYSCALL1) (pSaveDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_InstanceSize)
int32_t
SaveDialog_InstanceSize(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pSaveDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_InheritsFrom)
BOOL
SaveDialog_InheritsFrom(TSaveDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(SaveDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pSaveDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(SaveDialog_Equals)
BOOL
SaveDialog_Equals(TSaveDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(SaveDialog_Equals)
    return (BOOL)(((SYSCALL2) (pSaveDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(SaveDialog_GetHashCode)
int32_t
SaveDialog_GetHashCode(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pSaveDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_ToString)
char*
SaveDialog_ToString(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_ToString)
    return (char*)(((SYSCALL1) (pSaveDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_GetFiles)
TStrings
SaveDialog_GetFiles(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetFiles)
    return (TStrings)(((SYSCALL1) (pSaveDialog_GetFiles))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_GetDefaultExt)
char*
SaveDialog_GetDefaultExt(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetDefaultExt)
    return (char*)(((SYSCALL1) (pSaveDialog_GetDefaultExt))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetDefaultExt)
void
SaveDialog_SetDefaultExt(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetDefaultExt)
    (((SYSCALL2) (pSaveDialog_SetDefaultExt))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetFileName)
char*
SaveDialog_GetFileName(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetFileName)
    return (char*)(((SYSCALL1) (pSaveDialog_GetFileName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetFileName)
void
SaveDialog_SetFileName(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetFileName)
    (((SYSCALL2) (pSaveDialog_SetFileName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetFilter)
char*
SaveDialog_GetFilter(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetFilter)
    return (char*)(((SYSCALL1) (pSaveDialog_GetFilter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetFilter)
void
SaveDialog_SetFilter(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetFilter)
    (((SYSCALL2) (pSaveDialog_SetFilter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetFilterIndex)
int32_t
SaveDialog_GetFilterIndex(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetFilterIndex)
    return (int32_t)(((SYSCALL1) (pSaveDialog_GetFilterIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetFilterIndex)
void
SaveDialog_SetFilterIndex(TSaveDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SaveDialog_SetFilterIndex)
    (((SYSCALL2) (pSaveDialog_SetFilterIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetInitialDir)
char*
SaveDialog_GetInitialDir(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetInitialDir)
    return (char*)(((SYSCALL1) (pSaveDialog_GetInitialDir))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetInitialDir)
void
SaveDialog_SetInitialDir(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetInitialDir)
    (((SYSCALL2) (pSaveDialog_SetInitialDir))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetOptions)
TOpenOptions
SaveDialog_GetOptions(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetOptions)
    return (TOpenOptions)(((SYSCALL1) (pSaveDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetOptions)
void
SaveDialog_SetOptions(TSaveDialog AObj, TOpenOptions AValue) {
    GET_FUNC_ADDR(SaveDialog_SetOptions)
    (((SYSCALL2) (pSaveDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetTitle)
char*
SaveDialog_GetTitle(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetTitle)
    return (char*)(((SYSCALL1) (pSaveDialog_GetTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetTitle)
void
SaveDialog_SetTitle(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetTitle)
    (((SYSCALL2) (pSaveDialog_SetTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetHandle)
HWND
SaveDialog_GetHandle(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pSaveDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetOnClose)
void
SaveDialog_SetOnClose(TSaveDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SaveDialog_SetOnClose)
    (((SYSCALL2) (pSaveDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SaveDialog_SetOnShow)
void
SaveDialog_SetOnShow(TSaveDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SaveDialog_SetOnShow)
    (((SYSCALL2) (pSaveDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SaveDialog_GetComponentCount)
int32_t
SaveDialog_GetComponentCount(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pSaveDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_GetComponentIndex)
int32_t
SaveDialog_GetComponentIndex(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pSaveDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetComponentIndex)
void
SaveDialog_SetComponentIndex(TSaveDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SaveDialog_SetComponentIndex)
    (((SYSCALL2) (pSaveDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetOwner)
TComponent
SaveDialog_GetOwner(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pSaveDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_GetName)
char*
SaveDialog_GetName(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetName)
    return (char*)(((SYSCALL1) (pSaveDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetName)
void
SaveDialog_SetName(TSaveDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SaveDialog_SetName)
    (((SYSCALL2) (pSaveDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetTag)
intptr_t
SaveDialog_GetTag(TSaveDialog AObj) {
    GET_FUNC_ADDR(SaveDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pSaveDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SaveDialog_SetTag)
void
SaveDialog_SetTag(TSaveDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(SaveDialog_SetTag)
    (((SYSCALL2) (pSaveDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SaveDialog_GetComponents)
TComponent
SaveDialog_GetComponents(TSaveDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(SaveDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pSaveDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(SaveDialog_StaticClassType)
TClass
SaveDialog_StaticClassType() {
    GET_FUNC_ADDR(SaveDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pSaveDialog_StaticClassType))());
}

// -------------------TColorDialog-------------------

DEFINE_FUNC_PTR(ColorDialog_Create)
TColorDialog
ColorDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(ColorDialog_Create)
    return (TColorDialog)(((SYSCALL1) (pColorDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(ColorDialog_Free)
void
ColorDialog_Free(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_Free)
    (((SYSCALL1) (pColorDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_Execute)
BOOL
ColorDialog_Execute(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_Execute)
    return (BOOL)(((SYSCALL1) (pColorDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_FindComponent)
TComponent
ColorDialog_FindComponent(TColorDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(ColorDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pColorDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(ColorDialog_GetNamePath)
char*
ColorDialog_GetNamePath(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pColorDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_HasParent)
BOOL
ColorDialog_HasParent(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pColorDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_Assign)
void
ColorDialog_Assign(TColorDialog AObj, TObject Source) {
    GET_FUNC_ADDR(ColorDialog_Assign)
    (((SYSCALL2) (pColorDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(ColorDialog_ClassType)
TClass
ColorDialog_ClassType(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_ClassType)
    return (TClass)(((SYSCALL1) (pColorDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_ClassName)
char*
ColorDialog_ClassName(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_ClassName)
    return (char*)(((SYSCALL1) (pColorDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_InstanceSize)
int32_t
ColorDialog_InstanceSize(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pColorDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_InheritsFrom)
BOOL
ColorDialog_InheritsFrom(TColorDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(ColorDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pColorDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(ColorDialog_Equals)
BOOL
ColorDialog_Equals(TColorDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(ColorDialog_Equals)
    return (BOOL)(((SYSCALL2) (pColorDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(ColorDialog_GetHashCode)
int32_t
ColorDialog_GetHashCode(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pColorDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_ToString)
char*
ColorDialog_ToString(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_ToString)
    return (char*)(((SYSCALL1) (pColorDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_GetColor)
TColor
ColorDialog_GetColor(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetColor)
    return (TColor)(((SYSCALL1) (pColorDialog_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetColor)
void
ColorDialog_SetColor(TColorDialog AObj, TColor AValue) {
    GET_FUNC_ADDR(ColorDialog_SetColor)
    (((SYSCALL2) (pColorDialog_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorDialog_GetCustomColors)
TStrings
ColorDialog_GetCustomColors(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetCustomColors)
    return (TStrings)(((SYSCALL1) (pColorDialog_GetCustomColors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetCustomColors)
void
ColorDialog_SetCustomColors(TColorDialog AObj, TStrings AValue) {
    GET_FUNC_ADDR(ColorDialog_SetCustomColors)
    (((SYSCALL2) (pColorDialog_SetCustomColors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorDialog_GetHandle)
HWND
ColorDialog_GetHandle(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pColorDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetOnClose)
void
ColorDialog_SetOnClose(TColorDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorDialog_SetOnClose)
    (((SYSCALL2) (pColorDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorDialog_SetOnShow)
void
ColorDialog_SetOnShow(TColorDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(ColorDialog_SetOnShow)
    (((SYSCALL2) (pColorDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(ColorDialog_GetComponentCount)
int32_t
ColorDialog_GetComponentCount(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pColorDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_GetComponentIndex)
int32_t
ColorDialog_GetComponentIndex(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pColorDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetComponentIndex)
void
ColorDialog_SetComponentIndex(TColorDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(ColorDialog_SetComponentIndex)
    (((SYSCALL2) (pColorDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorDialog_GetOwner)
TComponent
ColorDialog_GetOwner(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pColorDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_GetName)
char*
ColorDialog_GetName(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetName)
    return (char*)(((SYSCALL1) (pColorDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetName)
void
ColorDialog_SetName(TColorDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(ColorDialog_SetName)
    (((SYSCALL2) (pColorDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorDialog_GetTag)
intptr_t
ColorDialog_GetTag(TColorDialog AObj) {
    GET_FUNC_ADDR(ColorDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pColorDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(ColorDialog_SetTag)
void
ColorDialog_SetTag(TColorDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(ColorDialog_SetTag)
    (((SYSCALL2) (pColorDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(ColorDialog_GetComponents)
TComponent
ColorDialog_GetComponents(TColorDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(ColorDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pColorDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(ColorDialog_StaticClassType)
TClass
ColorDialog_StaticClassType() {
    GET_FUNC_ADDR(ColorDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pColorDialog_StaticClassType))());
}

// -------------------TFontDialog-------------------

DEFINE_FUNC_PTR(FontDialog_Create)
TFontDialog
FontDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(FontDialog_Create)
    return (TFontDialog)(((SYSCALL1) (pFontDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(FontDialog_Free)
void
FontDialog_Free(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_Free)
    (((SYSCALL1) (pFontDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_Execute)
BOOL
FontDialog_Execute(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_Execute)
    return (BOOL)(((SYSCALL1) (pFontDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_FindComponent)
TComponent
FontDialog_FindComponent(TFontDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(FontDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pFontDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(FontDialog_GetNamePath)
char*
FontDialog_GetNamePath(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pFontDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_HasParent)
BOOL
FontDialog_HasParent(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pFontDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_Assign)
void
FontDialog_Assign(TFontDialog AObj, TObject Source) {
    GET_FUNC_ADDR(FontDialog_Assign)
    (((SYSCALL2) (pFontDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(FontDialog_ClassType)
TClass
FontDialog_ClassType(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_ClassType)
    return (TClass)(((SYSCALL1) (pFontDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_ClassName)
char*
FontDialog_ClassName(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_ClassName)
    return (char*)(((SYSCALL1) (pFontDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_InstanceSize)
int32_t
FontDialog_InstanceSize(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pFontDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_InheritsFrom)
BOOL
FontDialog_InheritsFrom(TFontDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(FontDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pFontDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(FontDialog_Equals)
BOOL
FontDialog_Equals(TFontDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(FontDialog_Equals)
    return (BOOL)(((SYSCALL2) (pFontDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(FontDialog_GetHashCode)
int32_t
FontDialog_GetHashCode(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pFontDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_ToString)
char*
FontDialog_ToString(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_ToString)
    return (char*)(((SYSCALL1) (pFontDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_GetFont)
TFont
FontDialog_GetFont(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetFont)
    return (TFont)(((SYSCALL1) (pFontDialog_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetFont)
void
FontDialog_SetFont(TFontDialog AObj, TFont AValue) {
    GET_FUNC_ADDR(FontDialog_SetFont)
    (((SYSCALL2) (pFontDialog_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(FontDialog_GetOptions)
TFontDialogOptions
FontDialog_GetOptions(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetOptions)
    return (TFontDialogOptions)(((SYSCALL1) (pFontDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetOptions)
void
FontDialog_SetOptions(TFontDialog AObj, TFontDialogOptions AValue) {
    GET_FUNC_ADDR(FontDialog_SetOptions)
    (((SYSCALL2) (pFontDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(FontDialog_GetHandle)
HWND
FontDialog_GetHandle(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pFontDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetOnClose)
void
FontDialog_SetOnClose(TFontDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(FontDialog_SetOnClose)
    (((SYSCALL2) (pFontDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(FontDialog_SetOnShow)
void
FontDialog_SetOnShow(TFontDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(FontDialog_SetOnShow)
    (((SYSCALL2) (pFontDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(FontDialog_GetComponentCount)
int32_t
FontDialog_GetComponentCount(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pFontDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_GetComponentIndex)
int32_t
FontDialog_GetComponentIndex(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pFontDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetComponentIndex)
void
FontDialog_SetComponentIndex(TFontDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(FontDialog_SetComponentIndex)
    (((SYSCALL2) (pFontDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(FontDialog_GetOwner)
TComponent
FontDialog_GetOwner(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pFontDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_GetName)
char*
FontDialog_GetName(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetName)
    return (char*)(((SYSCALL1) (pFontDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetName)
void
FontDialog_SetName(TFontDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(FontDialog_SetName)
    (((SYSCALL2) (pFontDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(FontDialog_GetTag)
intptr_t
FontDialog_GetTag(TFontDialog AObj) {
    GET_FUNC_ADDR(FontDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pFontDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(FontDialog_SetTag)
void
FontDialog_SetTag(TFontDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(FontDialog_SetTag)
    (((SYSCALL2) (pFontDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(FontDialog_GetComponents)
TComponent
FontDialog_GetComponents(TFontDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(FontDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pFontDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(FontDialog_StaticClassType)
TClass
FontDialog_StaticClassType() {
    GET_FUNC_ADDR(FontDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pFontDialog_StaticClassType))());
}

// -------------------TPrintDialog-------------------

DEFINE_FUNC_PTR(PrintDialog_Create)
TPrintDialog
PrintDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(PrintDialog_Create)
    return (TPrintDialog)(((SYSCALL1) (pPrintDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(PrintDialog_Free)
void
PrintDialog_Free(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_Free)
    (((SYSCALL1) (pPrintDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_Execute)
BOOL
PrintDialog_Execute(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_Execute)
    return (BOOL)(((SYSCALL1) (pPrintDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_FindComponent)
TComponent
PrintDialog_FindComponent(TPrintDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(PrintDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pPrintDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(PrintDialog_GetNamePath)
char*
PrintDialog_GetNamePath(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pPrintDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_HasParent)
BOOL
PrintDialog_HasParent(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pPrintDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_Assign)
void
PrintDialog_Assign(TPrintDialog AObj, TObject Source) {
    GET_FUNC_ADDR(PrintDialog_Assign)
    (((SYSCALL2) (pPrintDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(PrintDialog_ClassType)
TClass
PrintDialog_ClassType(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_ClassType)
    return (TClass)(((SYSCALL1) (pPrintDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_ClassName)
char*
PrintDialog_ClassName(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_ClassName)
    return (char*)(((SYSCALL1) (pPrintDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_InstanceSize)
int32_t
PrintDialog_InstanceSize(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pPrintDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_InheritsFrom)
BOOL
PrintDialog_InheritsFrom(TPrintDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(PrintDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pPrintDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(PrintDialog_Equals)
BOOL
PrintDialog_Equals(TPrintDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(PrintDialog_Equals)
    return (BOOL)(((SYSCALL2) (pPrintDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(PrintDialog_GetHashCode)
int32_t
PrintDialog_GetHashCode(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_ToString)
char*
PrintDialog_ToString(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_ToString)
    return (char*)(((SYSCALL1) (pPrintDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_GetCollate)
BOOL
PrintDialog_GetCollate(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetCollate)
    return (BOOL)(((SYSCALL1) (pPrintDialog_GetCollate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetCollate)
void
PrintDialog_SetCollate(TPrintDialog AObj, BOOL AValue) {
    GET_FUNC_ADDR(PrintDialog_SetCollate)
    (((SYSCALL2) (pPrintDialog_SetCollate))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetCopies)
int32_t
PrintDialog_GetCopies(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetCopies)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetCopies))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetCopies)
void
PrintDialog_SetCopies(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetCopies)
    (((SYSCALL2) (pPrintDialog_SetCopies))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetFromPage)
int32_t
PrintDialog_GetFromPage(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetFromPage)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetFromPage))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetFromPage)
void
PrintDialog_SetFromPage(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetFromPage)
    (((SYSCALL2) (pPrintDialog_SetFromPage))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetMinPage)
int32_t
PrintDialog_GetMinPage(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetMinPage)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetMinPage))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetMinPage)
void
PrintDialog_SetMinPage(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetMinPage)
    (((SYSCALL2) (pPrintDialog_SetMinPage))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetMaxPage)
int32_t
PrintDialog_GetMaxPage(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetMaxPage)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetMaxPage))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetMaxPage)
void
PrintDialog_SetMaxPage(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetMaxPage)
    (((SYSCALL2) (pPrintDialog_SetMaxPage))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetOptions)
TPrintDialogOptions
PrintDialog_GetOptions(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetOptions)
    return (TPrintDialogOptions)(((SYSCALL1) (pPrintDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetOptions)
void
PrintDialog_SetOptions(TPrintDialog AObj, TPrintDialogOptions AValue) {
    GET_FUNC_ADDR(PrintDialog_SetOptions)
    (((SYSCALL2) (pPrintDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetPrintToFile)
BOOL
PrintDialog_GetPrintToFile(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetPrintToFile)
    return (BOOL)(((SYSCALL1) (pPrintDialog_GetPrintToFile))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetPrintToFile)
void
PrintDialog_SetPrintToFile(TPrintDialog AObj, BOOL AValue) {
    GET_FUNC_ADDR(PrintDialog_SetPrintToFile)
    (((SYSCALL2) (pPrintDialog_SetPrintToFile))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetPrintRange)
TPrintRange
PrintDialog_GetPrintRange(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetPrintRange)
    return (TPrintRange)(((SYSCALL1) (pPrintDialog_GetPrintRange))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetPrintRange)
void
PrintDialog_SetPrintRange(TPrintDialog AObj, TPrintRange AValue) {
    GET_FUNC_ADDR(PrintDialog_SetPrintRange)
    (((SYSCALL2) (pPrintDialog_SetPrintRange))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetToPage)
int32_t
PrintDialog_GetToPage(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetToPage)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetToPage))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetToPage)
void
PrintDialog_SetToPage(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetToPage)
    (((SYSCALL2) (pPrintDialog_SetToPage))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetHandle)
HWND
PrintDialog_GetHandle(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pPrintDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetOnClose)
void
PrintDialog_SetOnClose(TPrintDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(PrintDialog_SetOnClose)
    (((SYSCALL2) (pPrintDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(PrintDialog_SetOnShow)
void
PrintDialog_SetOnShow(TPrintDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(PrintDialog_SetOnShow)
    (((SYSCALL2) (pPrintDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(PrintDialog_GetComponentCount)
int32_t
PrintDialog_GetComponentCount(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_GetComponentIndex)
int32_t
PrintDialog_GetComponentIndex(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pPrintDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetComponentIndex)
void
PrintDialog_SetComponentIndex(TPrintDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetComponentIndex)
    (((SYSCALL2) (pPrintDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetOwner)
TComponent
PrintDialog_GetOwner(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pPrintDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_GetName)
char*
PrintDialog_GetName(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetName)
    return (char*)(((SYSCALL1) (pPrintDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetName)
void
PrintDialog_SetName(TPrintDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(PrintDialog_SetName)
    (((SYSCALL2) (pPrintDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetTag)
intptr_t
PrintDialog_GetTag(TPrintDialog AObj) {
    GET_FUNC_ADDR(PrintDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pPrintDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(PrintDialog_SetTag)
void
PrintDialog_SetTag(TPrintDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(PrintDialog_SetTag)
    (((SYSCALL2) (pPrintDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(PrintDialog_GetComponents)
TComponent
PrintDialog_GetComponents(TPrintDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(PrintDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pPrintDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(PrintDialog_StaticClassType)
TClass
PrintDialog_StaticClassType() {
    GET_FUNC_ADDR(PrintDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pPrintDialog_StaticClassType))());
}

// -------------------TOpenPictureDialog-------------------

DEFINE_FUNC_PTR(OpenPictureDialog_Create)
TOpenPictureDialog
OpenPictureDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(OpenPictureDialog_Create)
    return (TOpenPictureDialog)(((SYSCALL1) (pOpenPictureDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_Free)
void
OpenPictureDialog_Free(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_Free)
    (((SYSCALL1) (pOpenPictureDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_Execute)
BOOL
OpenPictureDialog_Execute(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_Execute)
    return (BOOL)(((SYSCALL1) (pOpenPictureDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_FindComponent)
TComponent
OpenPictureDialog_FindComponent(TOpenPictureDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(OpenPictureDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pOpenPictureDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetNamePath)
char*
OpenPictureDialog_GetNamePath(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_HasParent)
BOOL
OpenPictureDialog_HasParent(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pOpenPictureDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_Assign)
void
OpenPictureDialog_Assign(TOpenPictureDialog AObj, TObject Source) {
    GET_FUNC_ADDR(OpenPictureDialog_Assign)
    (((SYSCALL2) (pOpenPictureDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_ClassType)
TClass
OpenPictureDialog_ClassType(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_ClassType)
    return (TClass)(((SYSCALL1) (pOpenPictureDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_ClassName)
char*
OpenPictureDialog_ClassName(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_ClassName)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_InstanceSize)
int32_t
OpenPictureDialog_InstanceSize(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pOpenPictureDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_InheritsFrom)
BOOL
OpenPictureDialog_InheritsFrom(TOpenPictureDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(OpenPictureDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pOpenPictureDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_Equals)
BOOL
OpenPictureDialog_Equals(TOpenPictureDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(OpenPictureDialog_Equals)
    return (BOOL)(((SYSCALL2) (pOpenPictureDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetHashCode)
int32_t
OpenPictureDialog_GetHashCode(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pOpenPictureDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_ToString)
char*
OpenPictureDialog_ToString(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_ToString)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetFilter)
char*
OpenPictureDialog_GetFilter(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetFilter)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetFilter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetFilter)
void
OpenPictureDialog_SetFilter(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetFilter)
    (((SYSCALL2) (pOpenPictureDialog_SetFilter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetFiles)
TStrings
OpenPictureDialog_GetFiles(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetFiles)
    return (TStrings)(((SYSCALL1) (pOpenPictureDialog_GetFiles))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetDefaultExt)
char*
OpenPictureDialog_GetDefaultExt(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetDefaultExt)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetDefaultExt))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetDefaultExt)
void
OpenPictureDialog_SetDefaultExt(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetDefaultExt)
    (((SYSCALL2) (pOpenPictureDialog_SetDefaultExt))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetFileName)
char*
OpenPictureDialog_GetFileName(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetFileName)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetFileName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetFileName)
void
OpenPictureDialog_SetFileName(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetFileName)
    (((SYSCALL2) (pOpenPictureDialog_SetFileName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetFilterIndex)
int32_t
OpenPictureDialog_GetFilterIndex(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetFilterIndex)
    return (int32_t)(((SYSCALL1) (pOpenPictureDialog_GetFilterIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetFilterIndex)
void
OpenPictureDialog_SetFilterIndex(TOpenPictureDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetFilterIndex)
    (((SYSCALL2) (pOpenPictureDialog_SetFilterIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetInitialDir)
char*
OpenPictureDialog_GetInitialDir(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetInitialDir)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetInitialDir))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetInitialDir)
void
OpenPictureDialog_SetInitialDir(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetInitialDir)
    (((SYSCALL2) (pOpenPictureDialog_SetInitialDir))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetOptions)
TOpenOptions
OpenPictureDialog_GetOptions(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetOptions)
    return (TOpenOptions)(((SYSCALL1) (pOpenPictureDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetOptions)
void
OpenPictureDialog_SetOptions(TOpenPictureDialog AObj, TOpenOptions AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetOptions)
    (((SYSCALL2) (pOpenPictureDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetTitle)
char*
OpenPictureDialog_GetTitle(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetTitle)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetTitle)
void
OpenPictureDialog_SetTitle(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetTitle)
    (((SYSCALL2) (pOpenPictureDialog_SetTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetHandle)
HWND
OpenPictureDialog_GetHandle(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pOpenPictureDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetOnClose)
void
OpenPictureDialog_SetOnClose(TOpenPictureDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(OpenPictureDialog_SetOnClose)
    (((SYSCALL2) (pOpenPictureDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetOnShow)
void
OpenPictureDialog_SetOnShow(TOpenPictureDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(OpenPictureDialog_SetOnShow)
    (((SYSCALL2) (pOpenPictureDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetComponentCount)
int32_t
OpenPictureDialog_GetComponentCount(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pOpenPictureDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetComponentIndex)
int32_t
OpenPictureDialog_GetComponentIndex(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pOpenPictureDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetComponentIndex)
void
OpenPictureDialog_SetComponentIndex(TOpenPictureDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetComponentIndex)
    (((SYSCALL2) (pOpenPictureDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetOwner)
TComponent
OpenPictureDialog_GetOwner(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pOpenPictureDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetName)
char*
OpenPictureDialog_GetName(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetName)
    return (char*)(((SYSCALL1) (pOpenPictureDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetName)
void
OpenPictureDialog_SetName(TOpenPictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetName)
    (((SYSCALL2) (pOpenPictureDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetTag)
intptr_t
OpenPictureDialog_GetTag(TOpenPictureDialog AObj) {
    GET_FUNC_ADDR(OpenPictureDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pOpenPictureDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_SetTag)
void
OpenPictureDialog_SetTag(TOpenPictureDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(OpenPictureDialog_SetTag)
    (((SYSCALL2) (pOpenPictureDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_GetComponents)
TComponent
OpenPictureDialog_GetComponents(TOpenPictureDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(OpenPictureDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pOpenPictureDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(OpenPictureDialog_StaticClassType)
TClass
OpenPictureDialog_StaticClassType() {
    GET_FUNC_ADDR(OpenPictureDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pOpenPictureDialog_StaticClassType))());
}

// -------------------TSavePictureDialog-------------------

DEFINE_FUNC_PTR(SavePictureDialog_Create)
TSavePictureDialog
SavePictureDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(SavePictureDialog_Create)
    return (TSavePictureDialog)(((SYSCALL1) (pSavePictureDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(SavePictureDialog_Free)
void
SavePictureDialog_Free(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_Free)
    (((SYSCALL1) (pSavePictureDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_Execute)
BOOL
SavePictureDialog_Execute(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_Execute)
    return (BOOL)(((SYSCALL1) (pSavePictureDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_FindComponent)
TComponent
SavePictureDialog_FindComponent(TSavePictureDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(SavePictureDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pSavePictureDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetNamePath)
char*
SavePictureDialog_GetNamePath(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_HasParent)
BOOL
SavePictureDialog_HasParent(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pSavePictureDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_Assign)
void
SavePictureDialog_Assign(TSavePictureDialog AObj, TObject Source) {
    GET_FUNC_ADDR(SavePictureDialog_Assign)
    (((SYSCALL2) (pSavePictureDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(SavePictureDialog_ClassType)
TClass
SavePictureDialog_ClassType(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_ClassType)
    return (TClass)(((SYSCALL1) (pSavePictureDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_ClassName)
char*
SavePictureDialog_ClassName(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_ClassName)
    return (char*)(((SYSCALL1) (pSavePictureDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_InstanceSize)
int32_t
SavePictureDialog_InstanceSize(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pSavePictureDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_InheritsFrom)
BOOL
SavePictureDialog_InheritsFrom(TSavePictureDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(SavePictureDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pSavePictureDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(SavePictureDialog_Equals)
BOOL
SavePictureDialog_Equals(TSavePictureDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(SavePictureDialog_Equals)
    return (BOOL)(((SYSCALL2) (pSavePictureDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetHashCode)
int32_t
SavePictureDialog_GetHashCode(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pSavePictureDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_ToString)
char*
SavePictureDialog_ToString(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_ToString)
    return (char*)(((SYSCALL1) (pSavePictureDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetFilter)
char*
SavePictureDialog_GetFilter(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetFilter)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetFilter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetFilter)
void
SavePictureDialog_SetFilter(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetFilter)
    (((SYSCALL2) (pSavePictureDialog_SetFilter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetFiles)
TStrings
SavePictureDialog_GetFiles(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetFiles)
    return (TStrings)(((SYSCALL1) (pSavePictureDialog_GetFiles))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetDefaultExt)
char*
SavePictureDialog_GetDefaultExt(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetDefaultExt)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetDefaultExt))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetDefaultExt)
void
SavePictureDialog_SetDefaultExt(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetDefaultExt)
    (((SYSCALL2) (pSavePictureDialog_SetDefaultExt))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetFileName)
char*
SavePictureDialog_GetFileName(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetFileName)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetFileName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetFileName)
void
SavePictureDialog_SetFileName(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetFileName)
    (((SYSCALL2) (pSavePictureDialog_SetFileName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetFilterIndex)
int32_t
SavePictureDialog_GetFilterIndex(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetFilterIndex)
    return (int32_t)(((SYSCALL1) (pSavePictureDialog_GetFilterIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetFilterIndex)
void
SavePictureDialog_SetFilterIndex(TSavePictureDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetFilterIndex)
    (((SYSCALL2) (pSavePictureDialog_SetFilterIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetInitialDir)
char*
SavePictureDialog_GetInitialDir(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetInitialDir)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetInitialDir))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetInitialDir)
void
SavePictureDialog_SetInitialDir(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetInitialDir)
    (((SYSCALL2) (pSavePictureDialog_SetInitialDir))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetOptions)
TOpenOptions
SavePictureDialog_GetOptions(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetOptions)
    return (TOpenOptions)(((SYSCALL1) (pSavePictureDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetOptions)
void
SavePictureDialog_SetOptions(TSavePictureDialog AObj, TOpenOptions AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetOptions)
    (((SYSCALL2) (pSavePictureDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetTitle)
char*
SavePictureDialog_GetTitle(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetTitle)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetTitle)
void
SavePictureDialog_SetTitle(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetTitle)
    (((SYSCALL2) (pSavePictureDialog_SetTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetHandle)
HWND
SavePictureDialog_GetHandle(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pSavePictureDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetOnClose)
void
SavePictureDialog_SetOnClose(TSavePictureDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SavePictureDialog_SetOnClose)
    (((SYSCALL2) (pSavePictureDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetOnShow)
void
SavePictureDialog_SetOnShow(TSavePictureDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SavePictureDialog_SetOnShow)
    (((SYSCALL2) (pSavePictureDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetComponentCount)
int32_t
SavePictureDialog_GetComponentCount(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pSavePictureDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetComponentIndex)
int32_t
SavePictureDialog_GetComponentIndex(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pSavePictureDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetComponentIndex)
void
SavePictureDialog_SetComponentIndex(TSavePictureDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetComponentIndex)
    (((SYSCALL2) (pSavePictureDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetOwner)
TComponent
SavePictureDialog_GetOwner(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pSavePictureDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetName)
char*
SavePictureDialog_GetName(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetName)
    return (char*)(((SYSCALL1) (pSavePictureDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetName)
void
SavePictureDialog_SetName(TSavePictureDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetName)
    (((SYSCALL2) (pSavePictureDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetTag)
intptr_t
SavePictureDialog_GetTag(TSavePictureDialog AObj) {
    GET_FUNC_ADDR(SavePictureDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pSavePictureDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SavePictureDialog_SetTag)
void
SavePictureDialog_SetTag(TSavePictureDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(SavePictureDialog_SetTag)
    (((SYSCALL2) (pSavePictureDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SavePictureDialog_GetComponents)
TComponent
SavePictureDialog_GetComponents(TSavePictureDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(SavePictureDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pSavePictureDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(SavePictureDialog_StaticClassType)
TClass
SavePictureDialog_StaticClassType() {
    GET_FUNC_ADDR(SavePictureDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pSavePictureDialog_StaticClassType))());
}

// -------------------TSelectDirectoryDialog-------------------

DEFINE_FUNC_PTR(SelectDirectoryDialog_Create)
TSelectDirectoryDialog
SelectDirectoryDialog_Create(TComponent AOwner) {
    GET_FUNC_ADDR(SelectDirectoryDialog_Create)
    return (TSelectDirectoryDialog)(((SYSCALL1) (pSelectDirectoryDialog_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_Free)
void
SelectDirectoryDialog_Free(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_Free)
    (((SYSCALL1) (pSelectDirectoryDialog_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_Execute)
BOOL
SelectDirectoryDialog_Execute(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_Execute)
    return (BOOL)(((SYSCALL1) (pSelectDirectoryDialog_Execute))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_FindComponent)
TComponent
SelectDirectoryDialog_FindComponent(TSelectDirectoryDialog AObj, CChar char* AName) {
    GET_FUNC_ADDR(SelectDirectoryDialog_FindComponent)
    return (TComponent)(((SYSCALL2) (pSelectDirectoryDialog_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetNamePath)
char*
SelectDirectoryDialog_GetNamePath(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetNamePath)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_HasParent)
BOOL
SelectDirectoryDialog_HasParent(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_HasParent)
    return (BOOL)(((SYSCALL1) (pSelectDirectoryDialog_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_Assign)
void
SelectDirectoryDialog_Assign(TSelectDirectoryDialog AObj, TObject Source) {
    GET_FUNC_ADDR(SelectDirectoryDialog_Assign)
    (((SYSCALL2) (pSelectDirectoryDialog_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_ClassType)
TClass
SelectDirectoryDialog_ClassType(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_ClassType)
    return (TClass)(((SYSCALL1) (pSelectDirectoryDialog_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_ClassName)
char*
SelectDirectoryDialog_ClassName(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_ClassName)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_InstanceSize)
int32_t
SelectDirectoryDialog_InstanceSize(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_InstanceSize)
    return (int32_t)(((SYSCALL1) (pSelectDirectoryDialog_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_InheritsFrom)
BOOL
SelectDirectoryDialog_InheritsFrom(TSelectDirectoryDialog AObj, TClass AClass) {
    GET_FUNC_ADDR(SelectDirectoryDialog_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pSelectDirectoryDialog_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_Equals)
BOOL
SelectDirectoryDialog_Equals(TSelectDirectoryDialog AObj, TObject Obj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_Equals)
    return (BOOL)(((SYSCALL2) (pSelectDirectoryDialog_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetHashCode)
int32_t
SelectDirectoryDialog_GetHashCode(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetHashCode)
    return (int32_t)(((SYSCALL1) (pSelectDirectoryDialog_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_ToString)
char*
SelectDirectoryDialog_ToString(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_ToString)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetFiles)
TStrings
SelectDirectoryDialog_GetFiles(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetFiles)
    return (TStrings)(((SYSCALL1) (pSelectDirectoryDialog_GetFiles))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetDefaultExt)
char*
SelectDirectoryDialog_GetDefaultExt(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetDefaultExt)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetDefaultExt))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetDefaultExt)
void
SelectDirectoryDialog_SetDefaultExt(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetDefaultExt)
    (((SYSCALL2) (pSelectDirectoryDialog_SetDefaultExt))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetFileName)
char*
SelectDirectoryDialog_GetFileName(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetFileName)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetFileName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetFileName)
void
SelectDirectoryDialog_SetFileName(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetFileName)
    (((SYSCALL2) (pSelectDirectoryDialog_SetFileName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetFilter)
char*
SelectDirectoryDialog_GetFilter(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetFilter)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetFilter))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetFilter)
void
SelectDirectoryDialog_SetFilter(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetFilter)
    (((SYSCALL2) (pSelectDirectoryDialog_SetFilter))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetFilterIndex)
int32_t
SelectDirectoryDialog_GetFilterIndex(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetFilterIndex)
    return (int32_t)(((SYSCALL1) (pSelectDirectoryDialog_GetFilterIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetFilterIndex)
void
SelectDirectoryDialog_SetFilterIndex(TSelectDirectoryDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetFilterIndex)
    (((SYSCALL2) (pSelectDirectoryDialog_SetFilterIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetInitialDir)
char*
SelectDirectoryDialog_GetInitialDir(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetInitialDir)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetInitialDir))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetInitialDir)
void
SelectDirectoryDialog_SetInitialDir(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetInitialDir)
    (((SYSCALL2) (pSelectDirectoryDialog_SetInitialDir))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetOptions)
TOpenOptions
SelectDirectoryDialog_GetOptions(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetOptions)
    return (TOpenOptions)(((SYSCALL1) (pSelectDirectoryDialog_GetOptions))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetOptions)
void
SelectDirectoryDialog_SetOptions(TSelectDirectoryDialog AObj, TOpenOptions AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetOptions)
    (((SYSCALL2) (pSelectDirectoryDialog_SetOptions))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetTitle)
char*
SelectDirectoryDialog_GetTitle(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetTitle)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetTitle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetTitle)
void
SelectDirectoryDialog_SetTitle(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetTitle)
    (((SYSCALL2) (pSelectDirectoryDialog_SetTitle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetHandle)
HWND
SelectDirectoryDialog_GetHandle(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetHandle)
    return (HWND)(((SYSCALL1) (pSelectDirectoryDialog_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetOnClose)
void
SelectDirectoryDialog_SetOnClose(TSelectDirectoryDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetOnClose)
    (((SYSCALL2) (pSelectDirectoryDialog_SetOnClose))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetOnShow)
void
SelectDirectoryDialog_SetOnShow(TSelectDirectoryDialog AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetOnShow)
    (((SYSCALL2) (pSelectDirectoryDialog_SetOnShow))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetComponentCount)
int32_t
SelectDirectoryDialog_GetComponentCount(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pSelectDirectoryDialog_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetComponentIndex)
int32_t
SelectDirectoryDialog_GetComponentIndex(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pSelectDirectoryDialog_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetComponentIndex)
void
SelectDirectoryDialog_SetComponentIndex(TSelectDirectoryDialog AObj, int32_t AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetComponentIndex)
    (((SYSCALL2) (pSelectDirectoryDialog_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetOwner)
TComponent
SelectDirectoryDialog_GetOwner(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetOwner)
    return (TComponent)(((SYSCALL1) (pSelectDirectoryDialog_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetName)
char*
SelectDirectoryDialog_GetName(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetName)
    return (char*)(((SYSCALL1) (pSelectDirectoryDialog_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetName)
void
SelectDirectoryDialog_SetName(TSelectDirectoryDialog AObj, CChar char* AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetName)
    (((SYSCALL2) (pSelectDirectoryDialog_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetTag)
intptr_t
SelectDirectoryDialog_GetTag(TSelectDirectoryDialog AObj) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetTag)
    return (intptr_t)(((SYSCALL1) (pSelectDirectoryDialog_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_SetTag)
void
SelectDirectoryDialog_SetTag(TSelectDirectoryDialog AObj, intptr_t AValue) {
    GET_FUNC_ADDR(SelectDirectoryDialog_SetTag)
    (((SYSCALL2) (pSelectDirectoryDialog_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_GetComponents)
TComponent
SelectDirectoryDialog_GetComponents(TSelectDirectoryDialog AObj, int32_t AIndex) {
    GET_FUNC_ADDR(SelectDirectoryDialog_GetComponents)
    return (TComponent)(((SYSCALL2) (pSelectDirectoryDialog_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(SelectDirectoryDialog_StaticClassType)
TClass
SelectDirectoryDialog_StaticClassType() {
    GET_FUNC_ADDR(SelectDirectoryDialog_StaticClassType)
    return (TClass)(((SYSCALL0) (pSelectDirectoryDialog_StaticClassType))());
}

// -------------------TRichEdit-------------------

DEFINE_FUNC_PTR(RichEdit_Create)
TRichEdit
RichEdit_Create(TComponent AOwner) {
    GET_FUNC_ADDR(RichEdit_Create)
    return (TRichEdit)(((SYSCALL1) (pRichEdit_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(RichEdit_Free)
void
RichEdit_Free(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Free)
    (((SYSCALL1) (pRichEdit_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Clear)
void
RichEdit_Clear(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Clear)
    (((SYSCALL1) (pRichEdit_Clear))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_FindText)
int32_t
RichEdit_FindText(TRichEdit AObj, CChar char* SearchStr, int32_t StartPos, int32_t Length, TSearchTypes Options) {
    GET_FUNC_ADDR(RichEdit_FindText)
    return (int32_t)(((SYSCALL5) (pRichEdit_FindText))(COV_PARAM(AObj), COV_PARAM(SearchStr), COV_PARAM(StartPos), COV_PARAM(Length), COV_PARAM(Options)));
}

DEFINE_FUNC_PTR(RichEdit_ClearSelection)
void
RichEdit_ClearSelection(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_ClearSelection)
    (((SYSCALL1) (pRichEdit_ClearSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_CopyToClipboard)
void
RichEdit_CopyToClipboard(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_CopyToClipboard)
    (((SYSCALL1) (pRichEdit_CopyToClipboard))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_CutToClipboard)
void
RichEdit_CutToClipboard(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_CutToClipboard)
    (((SYSCALL1) (pRichEdit_CutToClipboard))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_PasteFromClipboard)
void
RichEdit_PasteFromClipboard(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_PasteFromClipboard)
    (((SYSCALL1) (pRichEdit_PasteFromClipboard))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Undo)
void
RichEdit_Undo(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Undo)
    (((SYSCALL1) (pRichEdit_Undo))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SelectAll)
void
RichEdit_SelectAll(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_SelectAll)
    (((SYSCALL1) (pRichEdit_SelectAll))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_CanFocus)
BOOL
RichEdit_CanFocus(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_CanFocus)
    return (BOOL)(((SYSCALL1) (pRichEdit_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ContainsControl)
BOOL
RichEdit_ContainsControl(TRichEdit AObj, TControl Control) {
    GET_FUNC_ADDR(RichEdit_ContainsControl)
    return (BOOL)(((SYSCALL2) (pRichEdit_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(RichEdit_ControlAtPos)
TControl
RichEdit_ControlAtPos(TRichEdit AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(RichEdit_ControlAtPos)
    return (TControl)(((SYSCALL4) (pRichEdit_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(RichEdit_DisableAlign)
void
RichEdit_DisableAlign(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_DisableAlign)
    (((SYSCALL1) (pRichEdit_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_EnableAlign)
void
RichEdit_EnableAlign(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_EnableAlign)
    (((SYSCALL1) (pRichEdit_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_FindChildControl)
TControl
RichEdit_FindChildControl(TRichEdit AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(RichEdit_FindChildControl)
    return (TControl)(((SYSCALL2) (pRichEdit_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(RichEdit_FlipChildren)
void
RichEdit_FlipChildren(TRichEdit AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(RichEdit_FlipChildren)
    (((SYSCALL2) (pRichEdit_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(RichEdit_Focused)
BOOL
RichEdit_Focused(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Focused)
    return (BOOL)(((SYSCALL1) (pRichEdit_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_HandleAllocated)
BOOL
RichEdit_HandleAllocated(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pRichEdit_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_InsertControl)
void
RichEdit_InsertControl(TRichEdit AObj, TControl AControl) {
    GET_FUNC_ADDR(RichEdit_InsertControl)
    (((SYSCALL2) (pRichEdit_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RichEdit_Invalidate)
void
RichEdit_Invalidate(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Invalidate)
    (((SYSCALL1) (pRichEdit_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_PaintTo)
void
RichEdit_PaintTo(TRichEdit AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(RichEdit_PaintTo)
    (((SYSCALL4) (pRichEdit_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(RichEdit_RemoveControl)
void
RichEdit_RemoveControl(TRichEdit AObj, TControl AControl) {
    GET_FUNC_ADDR(RichEdit_RemoveControl)
    (((SYSCALL2) (pRichEdit_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(RichEdit_Realign)
void
RichEdit_Realign(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Realign)
    (((SYSCALL1) (pRichEdit_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Repaint)
void
RichEdit_Repaint(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Repaint)
    (((SYSCALL1) (pRichEdit_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleBy)
void
RichEdit_ScaleBy(TRichEdit AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(RichEdit_ScaleBy)
    (((SYSCALL3) (pRichEdit_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(RichEdit_ScrollBy)
void
RichEdit_ScrollBy(TRichEdit AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(RichEdit_ScrollBy)
    (((SYSCALL3) (pRichEdit_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(RichEdit_SetBounds)
void
RichEdit_SetBounds(TRichEdit AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(RichEdit_SetBounds)
    (((SYSCALL5) (pRichEdit_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(RichEdit_SetFocus)
void
RichEdit_SetFocus(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_SetFocus)
    (((SYSCALL1) (pRichEdit_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Update)
void
RichEdit_Update(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Update)
    (((SYSCALL1) (pRichEdit_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_BringToFront)
void
RichEdit_BringToFront(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_BringToFront)
    (((SYSCALL1) (pRichEdit_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ClientToScreen)
TPoint
RichEdit_ClientToScreen(TRichEdit AObj, TPoint Point) {
    GET_FUNC_ADDR(RichEdit_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pRichEdit_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_ClientToParent)
TPoint
RichEdit_ClientToParent(TRichEdit AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RichEdit_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pRichEdit_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_Dragging)
BOOL
RichEdit_Dragging(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Dragging)
    return (BOOL)(((SYSCALL1) (pRichEdit_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_HasParent)
BOOL
RichEdit_HasParent(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_HasParent)
    return (BOOL)(((SYSCALL1) (pRichEdit_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Hide)
void
RichEdit_Hide(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Hide)
    (((SYSCALL1) (pRichEdit_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Perform)
intptr_t
RichEdit_Perform(TRichEdit AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(RichEdit_Perform)
    return (intptr_t)(((SYSCALL4) (pRichEdit_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(RichEdit_Refresh)
void
RichEdit_Refresh(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Refresh)
    (((SYSCALL1) (pRichEdit_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ScreenToClient)
TPoint
RichEdit_ScreenToClient(TRichEdit AObj, TPoint Point) {
    GET_FUNC_ADDR(RichEdit_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pRichEdit_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_ParentToClient)
TPoint
RichEdit_ParentToClient(TRichEdit AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(RichEdit_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pRichEdit_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_SendToBack)
void
RichEdit_SendToBack(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_SendToBack)
    (((SYSCALL1) (pRichEdit_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Show)
void
RichEdit_Show(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_Show)
    (((SYSCALL1) (pRichEdit_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetTextBuf)
int32_t
RichEdit_GetTextBuf(TRichEdit AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(RichEdit_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pRichEdit_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(RichEdit_GetTextLen)
int32_t
RichEdit_GetTextLen(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTextLen)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTextBuf)
void
RichEdit_SetTextBuf(TRichEdit AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(RichEdit_SetTextBuf)
    (((SYSCALL2) (pRichEdit_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(RichEdit_FindComponent)
TComponent
RichEdit_FindComponent(TRichEdit AObj, CChar char* AName) {
    GET_FUNC_ADDR(RichEdit_FindComponent)
    return (TComponent)(((SYSCALL2) (pRichEdit_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(RichEdit_GetNamePath)
char*
RichEdit_GetNamePath(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetNamePath)
    return (char*)(((SYSCALL1) (pRichEdit_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_Assign)
void
RichEdit_Assign(TRichEdit AObj, TObject Source) {
    GET_FUNC_ADDR(RichEdit_Assign)
    (((SYSCALL2) (pRichEdit_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(RichEdit_ClassType)
TClass
RichEdit_ClassType(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_ClassType)
    return (TClass)(((SYSCALL1) (pRichEdit_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ClassName)
char*
RichEdit_ClassName(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_ClassName)
    return (char*)(((SYSCALL1) (pRichEdit_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_InstanceSize)
int32_t
RichEdit_InstanceSize(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_InstanceSize)
    return (int32_t)(((SYSCALL1) (pRichEdit_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_InheritsFrom)
BOOL
RichEdit_InheritsFrom(TRichEdit AObj, TClass AClass) {
    GET_FUNC_ADDR(RichEdit_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pRichEdit_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(RichEdit_Equals)
BOOL
RichEdit_Equals(TRichEdit AObj, TObject Obj) {
    GET_FUNC_ADDR(RichEdit_Equals)
    return (BOOL)(((SYSCALL2) (pRichEdit_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(RichEdit_GetHashCode)
int32_t
RichEdit_GetHashCode(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetHashCode)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_ToString)
char*
RichEdit_ToString(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_ToString)
    return (char*)(((SYSCALL1) (pRichEdit_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorToNeighbour)
void
RichEdit_AnchorToNeighbour(TRichEdit AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RichEdit_AnchorToNeighbour)
    (((SYSCALL4) (pRichEdit_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorParallel)
void
RichEdit_AnchorParallel(TRichEdit AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(RichEdit_AnchorParallel)
    (((SYSCALL4) (pRichEdit_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorHorizontalCenterTo)
void
RichEdit_AnchorHorizontalCenterTo(TRichEdit AObj, TControl ASibling) {
    GET_FUNC_ADDR(RichEdit_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pRichEdit_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorVerticalCenterTo)
void
RichEdit_AnchorVerticalCenterTo(TRichEdit AObj, TControl ASibling) {
    GET_FUNC_ADDR(RichEdit_AnchorVerticalCenterTo)
    (((SYSCALL2) (pRichEdit_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorSame)
void
RichEdit_AnchorSame(TRichEdit AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(RichEdit_AnchorSame)
    (((SYSCALL3) (pRichEdit_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorAsAlign)
void
RichEdit_AnchorAsAlign(TRichEdit AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(RichEdit_AnchorAsAlign)
    (((SYSCALL3) (pRichEdit_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RichEdit_AnchorClient)
void
RichEdit_AnchorClient(TRichEdit AObj, int32_t ASpace) {
    GET_FUNC_ADDR(RichEdit_AnchorClient)
    (((SYSCALL2) (pRichEdit_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleDesignToForm)
int32_t
RichEdit_ScaleDesignToForm(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleFormToDesign)
int32_t
RichEdit_ScaleFormToDesign(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_Scale96ToForm)
int32_t
RichEdit_Scale96ToForm(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pRichEdit_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleFormTo96)
int32_t
RichEdit_ScaleFormTo96(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_Scale96ToFont)
int32_t
RichEdit_Scale96ToFont(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pRichEdit_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleFontTo96)
int32_t
RichEdit_ScaleFontTo96(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleScreenToFont)
int32_t
RichEdit_ScaleScreenToFont(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleFontToScreen)
int32_t
RichEdit_ScaleFontToScreen(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_Scale96ToScreen)
int32_t
RichEdit_Scale96ToScreen(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pRichEdit_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleScreenTo96)
int32_t
RichEdit_ScaleScreenTo96(TRichEdit AObj, int32_t ASize) {
    GET_FUNC_ADDR(RichEdit_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pRichEdit_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(RichEdit_AutoAdjustLayout)
void
RichEdit_AutoAdjustLayout(TRichEdit AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(RichEdit_AutoAdjustLayout)
    (((SYSCALL6) (pRichEdit_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(RichEdit_FixDesignFontsPPI)
void
RichEdit_FixDesignFontsPPI(TRichEdit AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(RichEdit_FixDesignFontsPPI)
    (((SYSCALL2) (pRichEdit_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(RichEdit_ScaleFontsPPI)
void
RichEdit_ScaleFontsPPI(TRichEdit AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(RichEdit_ScaleFontsPPI)
    (((SYSCALL3) (pRichEdit_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(RichEdit_GetAlign)
TAlign
RichEdit_GetAlign(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAlign)
    return (TAlign)(((SYSCALL1) (pRichEdit_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAlign)
void
RichEdit_SetAlign(TRichEdit AObj, TAlign AValue) {
    GET_FUNC_ADDR(RichEdit_SetAlign)
    (((SYSCALL2) (pRichEdit_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAlignment)
TAlignment
RichEdit_GetAlignment(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAlignment)
    return (TAlignment)(((SYSCALL1) (pRichEdit_GetAlignment))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAlignment)
void
RichEdit_SetAlignment(TRichEdit AObj, TAlignment AValue) {
    GET_FUNC_ADDR(RichEdit_SetAlignment)
    (((SYSCALL2) (pRichEdit_SetAlignment))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchors)
TAnchors
RichEdit_GetAnchors(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pRichEdit_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAnchors)
void
RichEdit_SetAnchors(TRichEdit AObj, TAnchors AValue) {
    GET_FUNC_ADDR(RichEdit_SetAnchors)
    (((SYSCALL2) (pRichEdit_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetBiDiMode)
TBiDiMode
RichEdit_GetBiDiMode(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pRichEdit_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetBiDiMode)
void
RichEdit_SetBiDiMode(TRichEdit AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(RichEdit_SetBiDiMode)
    (((SYSCALL2) (pRichEdit_SetBiDiMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetBorderStyle)
TBorderStyle
RichEdit_GetBorderStyle(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBorderStyle)
    return (TBorderStyle)(((SYSCALL1) (pRichEdit_GetBorderStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetBorderStyle)
void
RichEdit_SetBorderStyle(TRichEdit AObj, TBorderStyle AValue) {
    GET_FUNC_ADDR(RichEdit_SetBorderStyle)
    (((SYSCALL2) (pRichEdit_SetBorderStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetBorderWidth)
int32_t
RichEdit_GetBorderWidth(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBorderWidth)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetBorderWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetBorderWidth)
void
RichEdit_SetBorderWidth(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetBorderWidth)
    (((SYSCALL2) (pRichEdit_SetBorderWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetColor)
TColor
RichEdit_GetColor(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetColor)
    return (TColor)(((SYSCALL1) (pRichEdit_GetColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetColor)
void
RichEdit_SetColor(TRichEdit AObj, TColor AValue) {
    GET_FUNC_ADDR(RichEdit_SetColor)
    (((SYSCALL2) (pRichEdit_SetColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDragCursor)
TCursor
RichEdit_GetDragCursor(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pRichEdit_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDragCursor)
void
RichEdit_SetDragCursor(TRichEdit AObj, TCursor AValue) {
    GET_FUNC_ADDR(RichEdit_SetDragCursor)
    (((SYSCALL2) (pRichEdit_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDragKind)
TDragKind
RichEdit_GetDragKind(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDragKind)
    return (TDragKind)(((SYSCALL1) (pRichEdit_GetDragKind))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDragKind)
void
RichEdit_SetDragKind(TRichEdit AObj, TDragKind AValue) {
    GET_FUNC_ADDR(RichEdit_SetDragKind)
    (((SYSCALL2) (pRichEdit_SetDragKind))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDragMode)
TDragMode
RichEdit_GetDragMode(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pRichEdit_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDragMode)
void
RichEdit_SetDragMode(TRichEdit AObj, TDragMode AValue) {
    GET_FUNC_ADDR(RichEdit_SetDragMode)
    (((SYSCALL2) (pRichEdit_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetEnabled)
BOOL
RichEdit_GetEnabled(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetEnabled)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetEnabled)
void
RichEdit_SetEnabled(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetEnabled)
    (((SYSCALL2) (pRichEdit_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetFont)
TFont
RichEdit_GetFont(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetFont)
    return (TFont)(((SYSCALL1) (pRichEdit_GetFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetFont)
void
RichEdit_SetFont(TRichEdit AObj, TFont AValue) {
    GET_FUNC_ADDR(RichEdit_SetFont)
    (((SYSCALL2) (pRichEdit_SetFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetHideSelection)
BOOL
RichEdit_GetHideSelection(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetHideSelection)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetHideSelection))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetHideSelection)
void
RichEdit_SetHideSelection(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetHideSelection)
    (((SYSCALL2) (pRichEdit_SetHideSelection))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetConstraints)
TSizeConstraints
RichEdit_GetConstraints(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pRichEdit_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetConstraints)
void
RichEdit_SetConstraints(TRichEdit AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(RichEdit_SetConstraints)
    (((SYSCALL2) (pRichEdit_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetLines)
TStrings
RichEdit_GetLines(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetLines)
    return (TStrings)(((SYSCALL1) (pRichEdit_GetLines))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetLines)
void
RichEdit_SetLines(TRichEdit AObj, TStrings AValue) {
    GET_FUNC_ADDR(RichEdit_SetLines)
    (((SYSCALL2) (pRichEdit_SetLines))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetMaxLength)
int32_t
RichEdit_GetMaxLength(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetMaxLength)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetMaxLength))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetMaxLength)
void
RichEdit_SetMaxLength(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetMaxLength)
    (((SYSCALL2) (pRichEdit_SetMaxLength))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetParentColor)
BOOL
RichEdit_GetParentColor(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParentColor)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetParentColor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParentColor)
void
RichEdit_SetParentColor(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetParentColor)
    (((SYSCALL2) (pRichEdit_SetParentColor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetParentFont)
BOOL
RichEdit_GetParentFont(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParentFont)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetParentFont))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParentFont)
void
RichEdit_SetParentFont(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetParentFont)
    (((SYSCALL2) (pRichEdit_SetParentFont))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetParentShowHint)
BOOL
RichEdit_GetParentShowHint(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParentShowHint)
void
RichEdit_SetParentShowHint(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetParentShowHint)
    (((SYSCALL2) (pRichEdit_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetPopupMenu)
TPopupMenu
RichEdit_GetPopupMenu(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pRichEdit_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetPopupMenu)
void
RichEdit_SetPopupMenu(TRichEdit AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(RichEdit_SetPopupMenu)
    (((SYSCALL2) (pRichEdit_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetReadOnly)
BOOL
RichEdit_GetReadOnly(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetReadOnly)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetReadOnly))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetReadOnly)
void
RichEdit_SetReadOnly(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetReadOnly)
    (((SYSCALL2) (pRichEdit_SetReadOnly))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetScrollBars)
TScrollStyle
RichEdit_GetScrollBars(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetScrollBars)
    return (TScrollStyle)(((SYSCALL1) (pRichEdit_GetScrollBars))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetScrollBars)
void
RichEdit_SetScrollBars(TRichEdit AObj, TScrollStyle AValue) {
    GET_FUNC_ADDR(RichEdit_SetScrollBars)
    (((SYSCALL2) (pRichEdit_SetScrollBars))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetShowHint)
BOOL
RichEdit_GetShowHint(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetShowHint)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetShowHint)
void
RichEdit_SetShowHint(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetShowHint)
    (((SYSCALL2) (pRichEdit_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetTabOrder)
TTabOrder
RichEdit_GetTabOrder(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pRichEdit_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTabOrder)
void
RichEdit_SetTabOrder(TRichEdit AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(RichEdit_SetTabOrder)
    (((SYSCALL2) (pRichEdit_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetTabStop)
BOOL
RichEdit_GetTabStop(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTabStop)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTabStop)
void
RichEdit_SetTabStop(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetTabStop)
    (((SYSCALL2) (pRichEdit_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetVisible)
BOOL
RichEdit_GetVisible(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetVisible)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetVisible)
void
RichEdit_SetVisible(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetVisible)
    (((SYSCALL2) (pRichEdit_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetWantTabs)
BOOL
RichEdit_GetWantTabs(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetWantTabs)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetWantTabs))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetWantTabs)
void
RichEdit_SetWantTabs(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetWantTabs)
    (((SYSCALL2) (pRichEdit_SetWantTabs))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetWantReturns)
BOOL
RichEdit_GetWantReturns(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetWantReturns)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetWantReturns))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetWantReturns)
void
RichEdit_SetWantReturns(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetWantReturns)
    (((SYSCALL2) (pRichEdit_SetWantReturns))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetWordWrap)
BOOL
RichEdit_GetWordWrap(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetWordWrap)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetWordWrap))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetWordWrap)
void
RichEdit_SetWordWrap(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetWordWrap)
    (((SYSCALL2) (pRichEdit_SetWordWrap))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetZoom)
int32_t
RichEdit_GetZoom(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetZoom)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetZoom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetZoom)
void
RichEdit_SetZoom(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetZoom)
    (((SYSCALL2) (pRichEdit_SetZoom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnChange)
void
RichEdit_SetOnChange(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnChange)
    (((SYSCALL2) (pRichEdit_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnClick)
void
RichEdit_SetOnClick(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnClick)
    (((SYSCALL2) (pRichEdit_SetOnClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnContextPopup)
void
RichEdit_SetOnContextPopup(TRichEdit AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnContextPopup)
    (((SYSCALL2) (pRichEdit_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnDblClick)
void
RichEdit_SetOnDblClick(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnDblClick)
    (((SYSCALL2) (pRichEdit_SetOnDblClick))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnDragDrop)
void
RichEdit_SetOnDragDrop(TRichEdit AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnDragDrop)
    (((SYSCALL2) (pRichEdit_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnDragOver)
void
RichEdit_SetOnDragOver(TRichEdit AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnDragOver)
    (((SYSCALL2) (pRichEdit_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnEndDrag)
void
RichEdit_SetOnEndDrag(TRichEdit AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnEndDrag)
    (((SYSCALL2) (pRichEdit_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnEnter)
void
RichEdit_SetOnEnter(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnEnter)
    (((SYSCALL2) (pRichEdit_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnExit)
void
RichEdit_SetOnExit(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnExit)
    (((SYSCALL2) (pRichEdit_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnKeyDown)
void
RichEdit_SetOnKeyDown(TRichEdit AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnKeyDown)
    (((SYSCALL2) (pRichEdit_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnKeyPress)
void
RichEdit_SetOnKeyPress(TRichEdit AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnKeyPress)
    (((SYSCALL2) (pRichEdit_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnKeyUp)
void
RichEdit_SetOnKeyUp(TRichEdit AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnKeyUp)
    (((SYSCALL2) (pRichEdit_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseDown)
void
RichEdit_SetOnMouseDown(TRichEdit AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseDown)
    (((SYSCALL2) (pRichEdit_SetOnMouseDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseEnter)
void
RichEdit_SetOnMouseEnter(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseEnter)
    (((SYSCALL2) (pRichEdit_SetOnMouseEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseLeave)
void
RichEdit_SetOnMouseLeave(TRichEdit AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseLeave)
    (((SYSCALL2) (pRichEdit_SetOnMouseLeave))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseMove)
void
RichEdit_SetOnMouseMove(TRichEdit AObj, TMouseMoveEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseMove)
    (((SYSCALL2) (pRichEdit_SetOnMouseMove))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseUp)
void
RichEdit_SetOnMouseUp(TRichEdit AObj, TMouseEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseUp)
    (((SYSCALL2) (pRichEdit_SetOnMouseUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseWheel)
void
RichEdit_SetOnMouseWheel(TRichEdit AObj, TMouseWheelEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseWheel)
    (((SYSCALL2) (pRichEdit_SetOnMouseWheel))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseWheelDown)
void
RichEdit_SetOnMouseWheelDown(TRichEdit AObj, TMouseWheelUpDownEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseWheelDown)
    (((SYSCALL2) (pRichEdit_SetOnMouseWheelDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_SetOnMouseWheelUp)
void
RichEdit_SetOnMouseWheelUp(TRichEdit AObj, TMouseWheelUpDownEvent AEventData) {
    GET_FUNC_ADDR(RichEdit_SetOnMouseWheelUp)
    (((SYSCALL2) (pRichEdit_SetOnMouseWheelUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(RichEdit_GetDefAttributes)
TTextAttributes
RichEdit_GetDefAttributes(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDefAttributes)
    return (TTextAttributes)(((SYSCALL1) (pRichEdit_GetDefAttributes))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDefAttributes)
void
RichEdit_SetDefAttributes(TRichEdit AObj, TTextAttributes AValue) {
    GET_FUNC_ADDR(RichEdit_SetDefAttributes)
    (((SYSCALL2) (pRichEdit_SetDefAttributes))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetSelAttributes)
TTextAttributes
RichEdit_GetSelAttributes(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetSelAttributes)
    return (TTextAttributes)(((SYSCALL1) (pRichEdit_GetSelAttributes))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetSelAttributes)
void
RichEdit_SetSelAttributes(TRichEdit AObj, TTextAttributes AValue) {
    GET_FUNC_ADDR(RichEdit_SetSelAttributes)
    (((SYSCALL2) (pRichEdit_SetSelAttributes))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetParagraph)
TParaAttributes
RichEdit_GetParagraph(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParagraph)
    return (TParaAttributes)(((SYSCALL1) (pRichEdit_GetParagraph))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetCaretPos)
TPoint
RichEdit_GetCaretPos(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetCaretPos)
    TPoint result;
    (((SYSCALL2) (pRichEdit_GetCaretPos))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_SetCaretPos)
void
RichEdit_SetCaretPos(TRichEdit AObj, TPoint AValue) {
    GET_FUNC_ADDR(RichEdit_SetCaretPos)
    (((SYSCALL2) (pRichEdit_SetCaretPos))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetCanUndo)
BOOL
RichEdit_GetCanUndo(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetCanUndo)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetCanUndo))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetModified)
BOOL
RichEdit_GetModified(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetModified)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetModified))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetModified)
void
RichEdit_SetModified(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetModified)
    (((SYSCALL2) (pRichEdit_SetModified))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetSelLength)
int32_t
RichEdit_GetSelLength(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetSelLength)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetSelLength))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetSelLength)
void
RichEdit_SetSelLength(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetSelLength)
    (((SYSCALL2) (pRichEdit_SetSelLength))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetSelStart)
int32_t
RichEdit_GetSelStart(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetSelStart)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetSelStart))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetSelStart)
void
RichEdit_SetSelStart(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetSelStart)
    (((SYSCALL2) (pRichEdit_SetSelStart))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetSelText)
char*
RichEdit_GetSelText(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetSelText)
    return (char*)(((SYSCALL1) (pRichEdit_GetSelText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetSelText)
void
RichEdit_SetSelText(TRichEdit AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RichEdit_SetSelText)
    (((SYSCALL2) (pRichEdit_SetSelText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetText)
char*
RichEdit_GetText(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetText)
    return (char*)(((SYSCALL1) (pRichEdit_GetText))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetText)
void
RichEdit_SetText(TRichEdit AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RichEdit_SetText)
    (((SYSCALL2) (pRichEdit_SetText))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetTextHint)
char*
RichEdit_GetTextHint(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTextHint)
    return (char*)(((SYSCALL1) (pRichEdit_GetTextHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTextHint)
void
RichEdit_SetTextHint(TRichEdit AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RichEdit_SetTextHint)
    (((SYSCALL2) (pRichEdit_SetTextHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDockClientCount)
int32_t
RichEdit_GetDockClientCount(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetDockSite)
BOOL
RichEdit_GetDockSite(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDockSite)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDockSite)
void
RichEdit_SetDockSite(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetDockSite)
    (((SYSCALL2) (pRichEdit_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDoubleBuffered)
BOOL
RichEdit_GetDoubleBuffered(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetDoubleBuffered)
void
RichEdit_SetDoubleBuffered(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetDoubleBuffered)
    (((SYSCALL2) (pRichEdit_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetMouseInClient)
BOOL
RichEdit_GetMouseInClient(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetVisibleDockClientCount)
int32_t
RichEdit_GetVisibleDockClientCount(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetBrush)
TBrush
RichEdit_GetBrush(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBrush)
    return (TBrush)(((SYSCALL1) (pRichEdit_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetControlCount)
int32_t
RichEdit_GetControlCount(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetControlCount)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetHandle)
HWND
RichEdit_GetHandle(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetHandle)
    return (HWND)(((SYSCALL1) (pRichEdit_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetParentDoubleBuffered)
BOOL
RichEdit_GetParentDoubleBuffered(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParentDoubleBuffered)
void
RichEdit_SetParentDoubleBuffered(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetParentDoubleBuffered)
    (((SYSCALL2) (pRichEdit_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetParentWindow)
HWND
RichEdit_GetParentWindow(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParentWindow)
    return (HWND)(((SYSCALL1) (pRichEdit_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParentWindow)
void
RichEdit_SetParentWindow(TRichEdit AObj, HWND AValue) {
    GET_FUNC_ADDR(RichEdit_SetParentWindow)
    (((SYSCALL2) (pRichEdit_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetShowing)
BOOL
RichEdit_GetShowing(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetShowing)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetUseDockManager)
BOOL
RichEdit_GetUseDockManager(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetUseDockManager)
void
RichEdit_SetUseDockManager(TRichEdit AObj, BOOL AValue) {
    GET_FUNC_ADDR(RichEdit_SetUseDockManager)
    (((SYSCALL2) (pRichEdit_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAction)
TAction
RichEdit_GetAction(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAction)
    return (TAction)(((SYSCALL1) (pRichEdit_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAction)
void
RichEdit_SetAction(TRichEdit AObj, TAction AValue) {
    GET_FUNC_ADDR(RichEdit_SetAction)
    (((SYSCALL2) (pRichEdit_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetBoundsRect)
TRect
RichEdit_GetBoundsRect(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBoundsRect)
    TRect result;
    (((SYSCALL2) (pRichEdit_GetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_SetBoundsRect)
void
RichEdit_SetBoundsRect(TRichEdit AObj, TRect AValue) {
    GET_FUNC_ADDR(RichEdit_SetBoundsRect)
    (((SYSCALL2) (pRichEdit_SetBoundsRect))(COV_PARAM(AObj), COV_PARAM(&AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetClientHeight)
int32_t
RichEdit_GetClientHeight(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetClientHeight)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetClientHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetClientHeight)
void
RichEdit_SetClientHeight(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetClientHeight)
    (((SYSCALL2) (pRichEdit_SetClientHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetClientOrigin)
TPoint
RichEdit_GetClientOrigin(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetClientOrigin)
    TPoint result;
    (((SYSCALL2) (pRichEdit_GetClientOrigin))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_GetClientRect)
TRect
RichEdit_GetClientRect(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetClientRect)
    TRect result;
    (((SYSCALL2) (pRichEdit_GetClientRect))(COV_PARAM(AObj), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(RichEdit_GetClientWidth)
int32_t
RichEdit_GetClientWidth(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetClientWidth)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetClientWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetClientWidth)
void
RichEdit_SetClientWidth(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetClientWidth)
    (((SYSCALL2) (pRichEdit_SetClientWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetControlState)
TControlState
RichEdit_GetControlState(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetControlState)
    return (TControlState)(((SYSCALL1) (pRichEdit_GetControlState))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetControlState)
void
RichEdit_SetControlState(TRichEdit AObj, TControlState AValue) {
    GET_FUNC_ADDR(RichEdit_SetControlState)
    (((SYSCALL2) (pRichEdit_SetControlState))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetControlStyle)
TControlStyle
RichEdit_GetControlStyle(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetControlStyle)
    return (TControlStyle)(((SYSCALL1) (pRichEdit_GetControlStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetControlStyle)
void
RichEdit_SetControlStyle(TRichEdit AObj, TControlStyle AValue) {
    GET_FUNC_ADDR(RichEdit_SetControlStyle)
    (((SYSCALL2) (pRichEdit_SetControlStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetFloating)
BOOL
RichEdit_GetFloating(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetFloating)
    return (BOOL)(((SYSCALL1) (pRichEdit_GetFloating))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetParent)
TWinControl
RichEdit_GetParent(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetParent)
    return (TWinControl)(((SYSCALL1) (pRichEdit_GetParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetParent)
void
RichEdit_SetParent(TRichEdit AObj, TWinControl AValue) {
    GET_FUNC_ADDR(RichEdit_SetParent)
    (((SYSCALL2) (pRichEdit_SetParent))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetLeft)
int32_t
RichEdit_GetLeft(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetLeft)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetLeft)
void
RichEdit_SetLeft(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetLeft)
    (((SYSCALL2) (pRichEdit_SetLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetTop)
int32_t
RichEdit_GetTop(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTop)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTop)
void
RichEdit_SetTop(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetTop)
    (((SYSCALL2) (pRichEdit_SetTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetWidth)
int32_t
RichEdit_GetWidth(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetWidth)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetWidth)
void
RichEdit_SetWidth(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetWidth)
    (((SYSCALL2) (pRichEdit_SetWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetHeight)
int32_t
RichEdit_GetHeight(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetHeight)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetHeight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetHeight)
void
RichEdit_SetHeight(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetHeight)
    (((SYSCALL2) (pRichEdit_SetHeight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetCursor)
TCursor
RichEdit_GetCursor(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetCursor)
    return (TCursor)(((SYSCALL1) (pRichEdit_GetCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetCursor)
void
RichEdit_SetCursor(TRichEdit AObj, TCursor AValue) {
    GET_FUNC_ADDR(RichEdit_SetCursor)
    (((SYSCALL2) (pRichEdit_SetCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetHint)
char*
RichEdit_GetHint(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetHint)
    return (char*)(((SYSCALL1) (pRichEdit_GetHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetHint)
void
RichEdit_SetHint(TRichEdit AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RichEdit_SetHint)
    (((SYSCALL2) (pRichEdit_SetHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetComponentCount)
int32_t
RichEdit_GetComponentCount(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetComponentCount)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetComponentCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetComponentIndex)
int32_t
RichEdit_GetComponentIndex(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetComponentIndex)
    return (int32_t)(((SYSCALL1) (pRichEdit_GetComponentIndex))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetComponentIndex)
void
RichEdit_SetComponentIndex(TRichEdit AObj, int32_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetComponentIndex)
    (((SYSCALL2) (pRichEdit_SetComponentIndex))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetOwner)
TComponent
RichEdit_GetOwner(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetOwner)
    return (TComponent)(((SYSCALL1) (pRichEdit_GetOwner))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_GetName)
char*
RichEdit_GetName(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetName)
    return (char*)(((SYSCALL1) (pRichEdit_GetName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetName)
void
RichEdit_SetName(TRichEdit AObj, CChar char* AValue) {
    GET_FUNC_ADDR(RichEdit_SetName)
    (((SYSCALL2) (pRichEdit_SetName))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetTag)
intptr_t
RichEdit_GetTag(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetTag)
    return (intptr_t)(((SYSCALL1) (pRichEdit_GetTag))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetTag)
void
RichEdit_SetTag(TRichEdit AObj, intptr_t AValue) {
    GET_FUNC_ADDR(RichEdit_SetTag)
    (((SYSCALL2) (pRichEdit_SetTag))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchorSideLeft)
TAnchorSide
RichEdit_GetAnchorSideLeft(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAnchorSideLeft)
    return (TAnchorSide)(((SYSCALL1) (pRichEdit_GetAnchorSideLeft))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAnchorSideLeft)
void
RichEdit_SetAnchorSideLeft(TRichEdit AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RichEdit_SetAnchorSideLeft)
    (((SYSCALL2) (pRichEdit_SetAnchorSideLeft))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchorSideTop)
TAnchorSide
RichEdit_GetAnchorSideTop(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAnchorSideTop)
    return (TAnchorSide)(((SYSCALL1) (pRichEdit_GetAnchorSideTop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAnchorSideTop)
void
RichEdit_SetAnchorSideTop(TRichEdit AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RichEdit_SetAnchorSideTop)
    (((SYSCALL2) (pRichEdit_SetAnchorSideTop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchorSideRight)
TAnchorSide
RichEdit_GetAnchorSideRight(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAnchorSideRight)
    return (TAnchorSide)(((SYSCALL1) (pRichEdit_GetAnchorSideRight))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAnchorSideRight)
void
RichEdit_SetAnchorSideRight(TRichEdit AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RichEdit_SetAnchorSideRight)
    (((SYSCALL2) (pRichEdit_SetAnchorSideRight))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchorSideBottom)
TAnchorSide
RichEdit_GetAnchorSideBottom(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetAnchorSideBottom)
    return (TAnchorSide)(((SYSCALL1) (pRichEdit_GetAnchorSideBottom))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetAnchorSideBottom)
void
RichEdit_SetAnchorSideBottom(TRichEdit AObj, TAnchorSide AValue) {
    GET_FUNC_ADDR(RichEdit_SetAnchorSideBottom)
    (((SYSCALL2) (pRichEdit_SetAnchorSideBottom))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetChildSizing)
TControlChildSizing
RichEdit_GetChildSizing(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetChildSizing)
    return (TControlChildSizing)(((SYSCALL1) (pRichEdit_GetChildSizing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetChildSizing)
void
RichEdit_SetChildSizing(TRichEdit AObj, TControlChildSizing AValue) {
    GET_FUNC_ADDR(RichEdit_SetChildSizing)
    (((SYSCALL2) (pRichEdit_SetChildSizing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetBorderSpacing)
TControlBorderSpacing
RichEdit_GetBorderSpacing(TRichEdit AObj) {
    GET_FUNC_ADDR(RichEdit_GetBorderSpacing)
    return (TControlBorderSpacing)(((SYSCALL1) (pRichEdit_GetBorderSpacing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(RichEdit_SetBorderSpacing)
void
RichEdit_SetBorderSpacing(TRichEdit AObj, TControlBorderSpacing AValue) {
    GET_FUNC_ADDR(RichEdit_SetBorderSpacing)
    (((SYSCALL2) (pRichEdit_SetBorderSpacing))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(RichEdit_GetDockClients)
TControl
RichEdit_GetDockClients(TRichEdit AObj, int32_t Index) {
    GET_FUNC_ADDR(RichEdit_GetDockClients)
    return (TControl)(((SYSCALL2) (pRichEdit_GetDockClients))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RichEdit_GetControls)
TControl
RichEdit_GetControls(TRichEdit AObj, int32_t Index) {
    GET_FUNC_ADDR(RichEdit_GetControls)
    return (TControl)(((SYSCALL2) (pRichEdit_GetControls))(COV_PARAM(AObj), COV_PARAM(Index)));
}

DEFINE_FUNC_PTR(RichEdit_GetComponents)
TComponent
RichEdit_GetComponents(TRichEdit AObj, int32_t AIndex) {
    GET_FUNC_ADDR(RichEdit_GetComponents)
    return (TComponent)(((SYSCALL2) (pRichEdit_GetComponents))(COV_PARAM(AObj), COV_PARAM(AIndex)));
}

DEFINE_FUNC_PTR(RichEdit_GetAnchorSide)
TAnchorSide
RichEdit_GetAnchorSide(TRichEdit AObj, TAnchorKind AKind) {
    GET_FUNC_ADDR(RichEdit_GetAnchorSide)
    return (TAnchorSide)(((SYSCALL2) (pRichEdit_GetAnchorSide))(COV_PARAM(AObj), COV_PARAM(AKind)));
}

DEFINE_FUNC_PTR(RichEdit_StaticClassType)
TClass
RichEdit_StaticClassType() {
    GET_FUNC_ADDR(RichEdit_StaticClassType)
    return (TClass)(((SYSCALL0) (pRichEdit_StaticClassType))());
}

// -------------------TTrackBar-------------------

DEFINE_FUNC_PTR(TrackBar_Create)
TTrackBar
TrackBar_Create(TComponent AOwner) {
    GET_FUNC_ADDR(TrackBar_Create)
    return (TTrackBar)(((SYSCALL1) (pTrackBar_Create))(COV_PARAM(AOwner)));
}

DEFINE_FUNC_PTR(TrackBar_Free)
void
TrackBar_Free(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Free)
    (((SYSCALL1) (pTrackBar_Free))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTick)
void
TrackBar_SetTick(TTrackBar AObj, int32_t Value) {
    GET_FUNC_ADDR(TrackBar_SetTick)
    (((SYSCALL2) (pTrackBar_SetTick))(COV_PARAM(AObj), COV_PARAM(Value)));
}

DEFINE_FUNC_PTR(TrackBar_CanFocus)
BOOL
TrackBar_CanFocus(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_CanFocus)
    return (BOOL)(((SYSCALL1) (pTrackBar_CanFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ContainsControl)
BOOL
TrackBar_ContainsControl(TTrackBar AObj, TControl Control) {
    GET_FUNC_ADDR(TrackBar_ContainsControl)
    return (BOOL)(((SYSCALL2) (pTrackBar_ContainsControl))(COV_PARAM(AObj), COV_PARAM(Control)));
}

DEFINE_FUNC_PTR(TrackBar_ControlAtPos)
TControl
TrackBar_ControlAtPos(TTrackBar AObj, TPoint Pos, BOOL AllowDisabled, BOOL AllowWinControls) {
    GET_FUNC_ADDR(TrackBar_ControlAtPos)
    return (TControl)(((SYSCALL4) (pTrackBar_ControlAtPos))(COV_PARAM(AObj), COV_PARAM(&Pos), COV_PARAM(AllowDisabled), COV_PARAM(AllowWinControls)));
}

DEFINE_FUNC_PTR(TrackBar_DisableAlign)
void
TrackBar_DisableAlign(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_DisableAlign)
    (((SYSCALL1) (pTrackBar_DisableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_EnableAlign)
void
TrackBar_EnableAlign(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_EnableAlign)
    (((SYSCALL1) (pTrackBar_EnableAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_FindChildControl)
TControl
TrackBar_FindChildControl(TTrackBar AObj, CChar char* ControlName) {
    GET_FUNC_ADDR(TrackBar_FindChildControl)
    return (TControl)(((SYSCALL2) (pTrackBar_FindChildControl))(COV_PARAM(AObj), COV_PARAM(ControlName)));
}

DEFINE_FUNC_PTR(TrackBar_FlipChildren)
void
TrackBar_FlipChildren(TTrackBar AObj, BOOL AllLevels) {
    GET_FUNC_ADDR(TrackBar_FlipChildren)
    (((SYSCALL2) (pTrackBar_FlipChildren))(COV_PARAM(AObj), COV_PARAM(AllLevels)));
}

DEFINE_FUNC_PTR(TrackBar_Focused)
BOOL
TrackBar_Focused(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Focused)
    return (BOOL)(((SYSCALL1) (pTrackBar_Focused))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_HandleAllocated)
BOOL
TrackBar_HandleAllocated(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_HandleAllocated)
    return (BOOL)(((SYSCALL1) (pTrackBar_HandleAllocated))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_InsertControl)
void
TrackBar_InsertControl(TTrackBar AObj, TControl AControl) {
    GET_FUNC_ADDR(TrackBar_InsertControl)
    (((SYSCALL2) (pTrackBar_InsertControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(TrackBar_Invalidate)
void
TrackBar_Invalidate(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Invalidate)
    (((SYSCALL1) (pTrackBar_Invalidate))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_PaintTo)
void
TrackBar_PaintTo(TTrackBar AObj, HDC DC, int32_t X, int32_t Y) {
    GET_FUNC_ADDR(TrackBar_PaintTo)
    (((SYSCALL4) (pTrackBar_PaintTo))(COV_PARAM(AObj), COV_PARAM(DC), COV_PARAM(X), COV_PARAM(Y)));
}

DEFINE_FUNC_PTR(TrackBar_RemoveControl)
void
TrackBar_RemoveControl(TTrackBar AObj, TControl AControl) {
    GET_FUNC_ADDR(TrackBar_RemoveControl)
    (((SYSCALL2) (pTrackBar_RemoveControl))(COV_PARAM(AObj), COV_PARAM(AControl)));
}

DEFINE_FUNC_PTR(TrackBar_Realign)
void
TrackBar_Realign(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Realign)
    (((SYSCALL1) (pTrackBar_Realign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Repaint)
void
TrackBar_Repaint(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Repaint)
    (((SYSCALL1) (pTrackBar_Repaint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleBy)
void
TrackBar_ScaleBy(TTrackBar AObj, int32_t M, int32_t D) {
    GET_FUNC_ADDR(TrackBar_ScaleBy)
    (((SYSCALL3) (pTrackBar_ScaleBy))(COV_PARAM(AObj), COV_PARAM(M), COV_PARAM(D)));
}

DEFINE_FUNC_PTR(TrackBar_ScrollBy)
void
TrackBar_ScrollBy(TTrackBar AObj, int32_t DeltaX, int32_t DeltaY) {
    GET_FUNC_ADDR(TrackBar_ScrollBy)
    (((SYSCALL3) (pTrackBar_ScrollBy))(COV_PARAM(AObj), COV_PARAM(DeltaX), COV_PARAM(DeltaY)));
}

DEFINE_FUNC_PTR(TrackBar_SetBounds)
void
TrackBar_SetBounds(TTrackBar AObj, int32_t ALeft, int32_t ATop, int32_t AWidth, int32_t AHeight) {
    GET_FUNC_ADDR(TrackBar_SetBounds)
    (((SYSCALL5) (pTrackBar_SetBounds))(COV_PARAM(AObj), COV_PARAM(ALeft), COV_PARAM(ATop), COV_PARAM(AWidth), COV_PARAM(AHeight)));
}

DEFINE_FUNC_PTR(TrackBar_SetFocus)
void
TrackBar_SetFocus(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_SetFocus)
    (((SYSCALL1) (pTrackBar_SetFocus))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Update)
void
TrackBar_Update(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Update)
    (((SYSCALL1) (pTrackBar_Update))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_BringToFront)
void
TrackBar_BringToFront(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_BringToFront)
    (((SYSCALL1) (pTrackBar_BringToFront))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ClientToScreen)
TPoint
TrackBar_ClientToScreen(TTrackBar AObj, TPoint Point) {
    GET_FUNC_ADDR(TrackBar_ClientToScreen)
    TPoint result;
    (((SYSCALL3) (pTrackBar_ClientToScreen))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(TrackBar_ClientToParent)
TPoint
TrackBar_ClientToParent(TTrackBar AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(TrackBar_ClientToParent)
    TPoint result;
    (((SYSCALL4) (pTrackBar_ClientToParent))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(TrackBar_Dragging)
BOOL
TrackBar_Dragging(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Dragging)
    return (BOOL)(((SYSCALL1) (pTrackBar_Dragging))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_HasParent)
BOOL
TrackBar_HasParent(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_HasParent)
    return (BOOL)(((SYSCALL1) (pTrackBar_HasParent))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Hide)
void
TrackBar_Hide(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Hide)
    (((SYSCALL1) (pTrackBar_Hide))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Perform)
intptr_t
TrackBar_Perform(TTrackBar AObj, uint32_t Msg, uintptr_t WParam, intptr_t LParam) {
    GET_FUNC_ADDR(TrackBar_Perform)
    return (intptr_t)(((SYSCALL4) (pTrackBar_Perform))(COV_PARAM(AObj), COV_PARAM(Msg), COV_PARAM(WParam), COV_PARAM(LParam)));
}

DEFINE_FUNC_PTR(TrackBar_Refresh)
void
TrackBar_Refresh(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Refresh)
    (((SYSCALL1) (pTrackBar_Refresh))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ScreenToClient)
TPoint
TrackBar_ScreenToClient(TTrackBar AObj, TPoint Point) {
    GET_FUNC_ADDR(TrackBar_ScreenToClient)
    TPoint result;
    (((SYSCALL3) (pTrackBar_ScreenToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(TrackBar_ParentToClient)
TPoint
TrackBar_ParentToClient(TTrackBar AObj, TPoint Point, TWinControl AParent) {
    GET_FUNC_ADDR(TrackBar_ParentToClient)
    TPoint result;
    (((SYSCALL4) (pTrackBar_ParentToClient))(COV_PARAM(AObj), COV_PARAM(&Point), COV_PARAM(AParent), COV_PARAM(&result)));
    return result;
}

DEFINE_FUNC_PTR(TrackBar_SendToBack)
void
TrackBar_SendToBack(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_SendToBack)
    (((SYSCALL1) (pTrackBar_SendToBack))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Show)
void
TrackBar_Show(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_Show)
    (((SYSCALL1) (pTrackBar_Show))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetTextBuf)
int32_t
TrackBar_GetTextBuf(TTrackBar AObj, CChar char* Buffer, int32_t BufSize) {
    GET_FUNC_ADDR(TrackBar_GetTextBuf)
    return (int32_t)(((SYSCALL3) (pTrackBar_GetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer), COV_PARAM(BufSize)));
}

DEFINE_FUNC_PTR(TrackBar_GetTextLen)
int32_t
TrackBar_GetTextLen(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetTextLen)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetTextLen))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTextBuf)
void
TrackBar_SetTextBuf(TTrackBar AObj, CChar char* Buffer) {
    GET_FUNC_ADDR(TrackBar_SetTextBuf)
    (((SYSCALL2) (pTrackBar_SetTextBuf))(COV_PARAM(AObj), COV_PARAM(Buffer)));
}

DEFINE_FUNC_PTR(TrackBar_FindComponent)
TComponent
TrackBar_FindComponent(TTrackBar AObj, CChar char* AName) {
    GET_FUNC_ADDR(TrackBar_FindComponent)
    return (TComponent)(((SYSCALL2) (pTrackBar_FindComponent))(COV_PARAM(AObj), COV_PARAM(AName)));
}

DEFINE_FUNC_PTR(TrackBar_GetNamePath)
char*
TrackBar_GetNamePath(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetNamePath)
    return (char*)(((SYSCALL1) (pTrackBar_GetNamePath))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_Assign)
void
TrackBar_Assign(TTrackBar AObj, TObject Source) {
    GET_FUNC_ADDR(TrackBar_Assign)
    (((SYSCALL2) (pTrackBar_Assign))(COV_PARAM(AObj), COV_PARAM(Source)));
}

DEFINE_FUNC_PTR(TrackBar_ClassType)
TClass
TrackBar_ClassType(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_ClassType)
    return (TClass)(((SYSCALL1) (pTrackBar_ClassType))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ClassName)
char*
TrackBar_ClassName(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_ClassName)
    return (char*)(((SYSCALL1) (pTrackBar_ClassName))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_InstanceSize)
int32_t
TrackBar_InstanceSize(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_InstanceSize)
    return (int32_t)(((SYSCALL1) (pTrackBar_InstanceSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_InheritsFrom)
BOOL
TrackBar_InheritsFrom(TTrackBar AObj, TClass AClass) {
    GET_FUNC_ADDR(TrackBar_InheritsFrom)
    return (BOOL)(((SYSCALL2) (pTrackBar_InheritsFrom))(COV_PARAM(AObj), COV_PARAM(AClass)));
}

DEFINE_FUNC_PTR(TrackBar_Equals)
BOOL
TrackBar_Equals(TTrackBar AObj, TObject Obj) {
    GET_FUNC_ADDR(TrackBar_Equals)
    return (BOOL)(((SYSCALL2) (pTrackBar_Equals))(COV_PARAM(AObj), COV_PARAM(Obj)));
}

DEFINE_FUNC_PTR(TrackBar_GetHashCode)
int32_t
TrackBar_GetHashCode(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetHashCode)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetHashCode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_ToString)
char*
TrackBar_ToString(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_ToString)
    return (char*)(((SYSCALL1) (pTrackBar_ToString))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorToNeighbour)
void
TrackBar_AnchorToNeighbour(TTrackBar AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(TrackBar_AnchorToNeighbour)
    (((SYSCALL4) (pTrackBar_AnchorToNeighbour))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorParallel)
void
TrackBar_AnchorParallel(TTrackBar AObj, TAnchorKind ASide, int32_t ASpace, TControl ASibling) {
    GET_FUNC_ADDR(TrackBar_AnchorParallel)
    (((SYSCALL4) (pTrackBar_AnchorParallel))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASpace), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorHorizontalCenterTo)
void
TrackBar_AnchorHorizontalCenterTo(TTrackBar AObj, TControl ASibling) {
    GET_FUNC_ADDR(TrackBar_AnchorHorizontalCenterTo)
    (((SYSCALL2) (pTrackBar_AnchorHorizontalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorVerticalCenterTo)
void
TrackBar_AnchorVerticalCenterTo(TTrackBar AObj, TControl ASibling) {
    GET_FUNC_ADDR(TrackBar_AnchorVerticalCenterTo)
    (((SYSCALL2) (pTrackBar_AnchorVerticalCenterTo))(COV_PARAM(AObj), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorSame)
void
TrackBar_AnchorSame(TTrackBar AObj, TAnchorKind ASide, TControl ASibling) {
    GET_FUNC_ADDR(TrackBar_AnchorSame)
    (((SYSCALL3) (pTrackBar_AnchorSame))(COV_PARAM(AObj), COV_PARAM(ASide), COV_PARAM(ASibling)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorAsAlign)
void
TrackBar_AnchorAsAlign(TTrackBar AObj, TAlign ATheAlign, int32_t ASpace) {
    GET_FUNC_ADDR(TrackBar_AnchorAsAlign)
    (((SYSCALL3) (pTrackBar_AnchorAsAlign))(COV_PARAM(AObj), COV_PARAM(ATheAlign), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(TrackBar_AnchorClient)
void
TrackBar_AnchorClient(TTrackBar AObj, int32_t ASpace) {
    GET_FUNC_ADDR(TrackBar_AnchorClient)
    (((SYSCALL2) (pTrackBar_AnchorClient))(COV_PARAM(AObj), COV_PARAM(ASpace)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleDesignToForm)
int32_t
TrackBar_ScaleDesignToForm(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleDesignToForm)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleDesignToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleFormToDesign)
int32_t
TrackBar_ScaleFormToDesign(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleFormToDesign)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleFormToDesign))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_Scale96ToForm)
int32_t
TrackBar_Scale96ToForm(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_Scale96ToForm)
    return (int32_t)(((SYSCALL2) (pTrackBar_Scale96ToForm))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleFormTo96)
int32_t
TrackBar_ScaleFormTo96(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleFormTo96)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleFormTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_Scale96ToFont)
int32_t
TrackBar_Scale96ToFont(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_Scale96ToFont)
    return (int32_t)(((SYSCALL2) (pTrackBar_Scale96ToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleFontTo96)
int32_t
TrackBar_ScaleFontTo96(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleFontTo96)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleFontTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleScreenToFont)
int32_t
TrackBar_ScaleScreenToFont(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleScreenToFont)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleScreenToFont))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleFontToScreen)
int32_t
TrackBar_ScaleFontToScreen(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleFontToScreen)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleFontToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_Scale96ToScreen)
int32_t
TrackBar_Scale96ToScreen(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_Scale96ToScreen)
    return (int32_t)(((SYSCALL2) (pTrackBar_Scale96ToScreen))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleScreenTo96)
int32_t
TrackBar_ScaleScreenTo96(TTrackBar AObj, int32_t ASize) {
    GET_FUNC_ADDR(TrackBar_ScaleScreenTo96)
    return (int32_t)(((SYSCALL2) (pTrackBar_ScaleScreenTo96))(COV_PARAM(AObj), COV_PARAM(ASize)));
}

DEFINE_FUNC_PTR(TrackBar_AutoAdjustLayout)
void
TrackBar_AutoAdjustLayout(TTrackBar AObj, TLayoutAdjustmentPolicy AMode, int32_t AFromPPI, int32_t AToPPI, int32_t AOldFormWidth, int32_t ANewFormWidth) {
    GET_FUNC_ADDR(TrackBar_AutoAdjustLayout)
    (((SYSCALL6) (pTrackBar_AutoAdjustLayout))(COV_PARAM(AObj), COV_PARAM(AMode), COV_PARAM(AFromPPI), COV_PARAM(AToPPI), COV_PARAM(AOldFormWidth), COV_PARAM(ANewFormWidth)));
}

DEFINE_FUNC_PTR(TrackBar_FixDesignFontsPPI)
void
TrackBar_FixDesignFontsPPI(TTrackBar AObj, int32_t ADesignTimePPI) {
    GET_FUNC_ADDR(TrackBar_FixDesignFontsPPI)
    (((SYSCALL2) (pTrackBar_FixDesignFontsPPI))(COV_PARAM(AObj), COV_PARAM(ADesignTimePPI)));
}

DEFINE_FUNC_PTR(TrackBar_ScaleFontsPPI)
void
TrackBar_ScaleFontsPPI(TTrackBar AObj, int32_t AToPPI, double AProportion) {
    GET_FUNC_ADDR(TrackBar_ScaleFontsPPI)
    (((SYSCALL3) (pTrackBar_ScaleFontsPPI))(COV_PARAM(AObj), COV_PARAM(AToPPI), COV_PARAM(&AProportion)));
}

DEFINE_FUNC_PTR(TrackBar_GetAlign)
TAlign
TrackBar_GetAlign(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetAlign)
    return (TAlign)(((SYSCALL1) (pTrackBar_GetAlign))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetAlign)
void
TrackBar_SetAlign(TTrackBar AObj, TAlign AValue) {
    GET_FUNC_ADDR(TrackBar_SetAlign)
    (((SYSCALL2) (pTrackBar_SetAlign))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetAnchors)
TAnchors
TrackBar_GetAnchors(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetAnchors)
    return (TAnchors)(((SYSCALL1) (pTrackBar_GetAnchors))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetAnchors)
void
TrackBar_SetAnchors(TTrackBar AObj, TAnchors AValue) {
    GET_FUNC_ADDR(TrackBar_SetAnchors)
    (((SYSCALL2) (pTrackBar_SetAnchors))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetBorderWidth)
int32_t
TrackBar_GetBorderWidth(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetBorderWidth)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetBorderWidth))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetBorderWidth)
void
TrackBar_SetBorderWidth(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetBorderWidth)
    (((SYSCALL2) (pTrackBar_SetBorderWidth))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetDoubleBuffered)
BOOL
TrackBar_GetDoubleBuffered(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetDoubleBuffered)
void
TrackBar_SetDoubleBuffered(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetDoubleBuffered)
    (((SYSCALL2) (pTrackBar_SetDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetDragCursor)
TCursor
TrackBar_GetDragCursor(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetDragCursor)
    return (TCursor)(((SYSCALL1) (pTrackBar_GetDragCursor))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetDragCursor)
void
TrackBar_SetDragCursor(TTrackBar AObj, TCursor AValue) {
    GET_FUNC_ADDR(TrackBar_SetDragCursor)
    (((SYSCALL2) (pTrackBar_SetDragCursor))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetDragMode)
TDragMode
TrackBar_GetDragMode(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetDragMode)
    return (TDragMode)(((SYSCALL1) (pTrackBar_GetDragMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetDragMode)
void
TrackBar_SetDragMode(TTrackBar AObj, TDragMode AValue) {
    GET_FUNC_ADDR(TrackBar_SetDragMode)
    (((SYSCALL2) (pTrackBar_SetDragMode))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetEnabled)
BOOL
TrackBar_GetEnabled(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetEnabled)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetEnabled))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetEnabled)
void
TrackBar_SetEnabled(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetEnabled)
    (((SYSCALL2) (pTrackBar_SetEnabled))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetConstraints)
TSizeConstraints
TrackBar_GetConstraints(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetConstraints)
    return (TSizeConstraints)(((SYSCALL1) (pTrackBar_GetConstraints))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetConstraints)
void
TrackBar_SetConstraints(TTrackBar AObj, TSizeConstraints AValue) {
    GET_FUNC_ADDR(TrackBar_SetConstraints)
    (((SYSCALL2) (pTrackBar_SetConstraints))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetLineSize)
int32_t
TrackBar_GetLineSize(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetLineSize)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetLineSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetLineSize)
void
TrackBar_SetLineSize(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetLineSize)
    (((SYSCALL2) (pTrackBar_SetLineSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetMax)
int32_t
TrackBar_GetMax(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetMax)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetMax))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetMax)
void
TrackBar_SetMax(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetMax)
    (((SYSCALL2) (pTrackBar_SetMax))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetMin)
int32_t
TrackBar_GetMin(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetMin)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetMin))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetMin)
void
TrackBar_SetMin(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetMin)
    (((SYSCALL2) (pTrackBar_SetMin))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetOrientation)
TTrackBarOrientation
TrackBar_GetOrientation(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetOrientation)
    return (TTrackBarOrientation)(((SYSCALL1) (pTrackBar_GetOrientation))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetOrientation)
void
TrackBar_SetOrientation(TTrackBar AObj, TTrackBarOrientation AValue) {
    GET_FUNC_ADDR(TrackBar_SetOrientation)
    (((SYSCALL2) (pTrackBar_SetOrientation))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetParentDoubleBuffered)
BOOL
TrackBar_GetParentDoubleBuffered(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetParentDoubleBuffered)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetParentDoubleBuffered))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetParentDoubleBuffered)
void
TrackBar_SetParentDoubleBuffered(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetParentDoubleBuffered)
    (((SYSCALL2) (pTrackBar_SetParentDoubleBuffered))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetParentShowHint)
BOOL
TrackBar_GetParentShowHint(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetParentShowHint)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetParentShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetParentShowHint)
void
TrackBar_SetParentShowHint(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetParentShowHint)
    (((SYSCALL2) (pTrackBar_SetParentShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetPageSize)
int32_t
TrackBar_GetPageSize(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetPageSize)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetPageSize))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetPageSize)
void
TrackBar_SetPageSize(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetPageSize)
    (((SYSCALL2) (pTrackBar_SetPageSize))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetPopupMenu)
TPopupMenu
TrackBar_GetPopupMenu(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetPopupMenu)
    return (TPopupMenu)(((SYSCALL1) (pTrackBar_GetPopupMenu))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetPopupMenu)
void
TrackBar_SetPopupMenu(TTrackBar AObj, TPopupMenu AValue) {
    GET_FUNC_ADDR(TrackBar_SetPopupMenu)
    (((SYSCALL2) (pTrackBar_SetPopupMenu))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetFrequency)
int32_t
TrackBar_GetFrequency(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetFrequency)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetFrequency))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetFrequency)
void
TrackBar_SetFrequency(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetFrequency)
    (((SYSCALL2) (pTrackBar_SetFrequency))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetPosition)
int32_t
TrackBar_GetPosition(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetPosition)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetPosition))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetPosition)
void
TrackBar_SetPosition(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetPosition)
    (((SYSCALL2) (pTrackBar_SetPosition))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetSelEnd)
int32_t
TrackBar_GetSelEnd(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetSelEnd)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetSelEnd))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetSelEnd)
void
TrackBar_SetSelEnd(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetSelEnd)
    (((SYSCALL2) (pTrackBar_SetSelEnd))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetSelStart)
int32_t
TrackBar_GetSelStart(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetSelStart)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetSelStart))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetSelStart)
void
TrackBar_SetSelStart(TTrackBar AObj, int32_t AValue) {
    GET_FUNC_ADDR(TrackBar_SetSelStart)
    (((SYSCALL2) (pTrackBar_SetSelStart))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetShowHint)
BOOL
TrackBar_GetShowHint(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetShowHint)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetShowHint))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetShowHint)
void
TrackBar_SetShowHint(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetShowHint)
    (((SYSCALL2) (pTrackBar_SetShowHint))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetShowSelRange)
BOOL
TrackBar_GetShowSelRange(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetShowSelRange)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetShowSelRange))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetShowSelRange)
void
TrackBar_SetShowSelRange(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetShowSelRange)
    (((SYSCALL2) (pTrackBar_SetShowSelRange))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetTabOrder)
TTabOrder
TrackBar_GetTabOrder(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetTabOrder)
    return (TTabOrder)(((SYSCALL1) (pTrackBar_GetTabOrder))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTabOrder)
void
TrackBar_SetTabOrder(TTrackBar AObj, TTabOrder AValue) {
    GET_FUNC_ADDR(TrackBar_SetTabOrder)
    (((SYSCALL2) (pTrackBar_SetTabOrder))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetTabStop)
BOOL
TrackBar_GetTabStop(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetTabStop)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetTabStop))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTabStop)
void
TrackBar_SetTabStop(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetTabStop)
    (((SYSCALL2) (pTrackBar_SetTabStop))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetTickMarks)
TTickMark
TrackBar_GetTickMarks(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetTickMarks)
    return (TTickMark)(((SYSCALL1) (pTrackBar_GetTickMarks))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTickMarks)
void
TrackBar_SetTickMarks(TTrackBar AObj, TTickMark AValue) {
    GET_FUNC_ADDR(TrackBar_SetTickMarks)
    (((SYSCALL2) (pTrackBar_SetTickMarks))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetTickStyle)
TTickStyle
TrackBar_GetTickStyle(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetTickStyle)
    return (TTickStyle)(((SYSCALL1) (pTrackBar_GetTickStyle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetTickStyle)
void
TrackBar_SetTickStyle(TTrackBar AObj, TTickStyle AValue) {
    GET_FUNC_ADDR(TrackBar_SetTickStyle)
    (((SYSCALL2) (pTrackBar_SetTickStyle))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetVisible)
BOOL
TrackBar_GetVisible(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetVisible)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetVisible))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetVisible)
void
TrackBar_SetVisible(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetVisible)
    (((SYSCALL2) (pTrackBar_SetVisible))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnContextPopup)
void
TrackBar_SetOnContextPopup(TTrackBar AObj, TContextPopupEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnContextPopup)
    (((SYSCALL2) (pTrackBar_SetOnContextPopup))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnChange)
void
TrackBar_SetOnChange(TTrackBar AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnChange)
    (((SYSCALL2) (pTrackBar_SetOnChange))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnDragDrop)
void
TrackBar_SetOnDragDrop(TTrackBar AObj, TDragDropEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnDragDrop)
    (((SYSCALL2) (pTrackBar_SetOnDragDrop))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnDragOver)
void
TrackBar_SetOnDragOver(TTrackBar AObj, TDragOverEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnDragOver)
    (((SYSCALL2) (pTrackBar_SetOnDragOver))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnEndDrag)
void
TrackBar_SetOnEndDrag(TTrackBar AObj, TEndDragEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnEndDrag)
    (((SYSCALL2) (pTrackBar_SetOnEndDrag))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnEnter)
void
TrackBar_SetOnEnter(TTrackBar AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnEnter)
    (((SYSCALL2) (pTrackBar_SetOnEnter))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnExit)
void
TrackBar_SetOnExit(TTrackBar AObj, TNotifyEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnExit)
    (((SYSCALL2) (pTrackBar_SetOnExit))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnKeyDown)
void
TrackBar_SetOnKeyDown(TTrackBar AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnKeyDown)
    (((SYSCALL2) (pTrackBar_SetOnKeyDown))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnKeyPress)
void
TrackBar_SetOnKeyPress(TTrackBar AObj, TKeyPressEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnKeyPress)
    (((SYSCALL2) (pTrackBar_SetOnKeyPress))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_SetOnKeyUp)
void
TrackBar_SetOnKeyUp(TTrackBar AObj, TKeyEvent AEventData) {
    GET_FUNC_ADDR(TrackBar_SetOnKeyUp)
    (((SYSCALL2) (pTrackBar_SetOnKeyUp))(COV_PARAM(AObj), COV_PARAM(AEventData)));
}

DEFINE_FUNC_PTR(TrackBar_GetDockClientCount)
int32_t
TrackBar_GetDockClientCount(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetDockClientCount)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetDockSite)
BOOL
TrackBar_GetDockSite(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetDockSite)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetDockSite))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetDockSite)
void
TrackBar_SetDockSite(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetDockSite)
    (((SYSCALL2) (pTrackBar_SetDockSite))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetMouseInClient)
BOOL
TrackBar_GetMouseInClient(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetMouseInClient)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetMouseInClient))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetVisibleDockClientCount)
int32_t
TrackBar_GetVisibleDockClientCount(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetVisibleDockClientCount)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetVisibleDockClientCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetBrush)
TBrush
TrackBar_GetBrush(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetBrush)
    return (TBrush)(((SYSCALL1) (pTrackBar_GetBrush))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetControlCount)
int32_t
TrackBar_GetControlCount(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetControlCount)
    return (int32_t)(((SYSCALL1) (pTrackBar_GetControlCount))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetHandle)
HWND
TrackBar_GetHandle(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetHandle)
    return (HWND)(((SYSCALL1) (pTrackBar_GetHandle))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetParentWindow)
HWND
TrackBar_GetParentWindow(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetParentWindow)
    return (HWND)(((SYSCALL1) (pTrackBar_GetParentWindow))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetParentWindow)
void
TrackBar_SetParentWindow(TTrackBar AObj, HWND AValue) {
    GET_FUNC_ADDR(TrackBar_SetParentWindow)
    (((SYSCALL2) (pTrackBar_SetParentWindow))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetShowing)
BOOL
TrackBar_GetShowing(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetShowing)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetShowing))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_GetUseDockManager)
BOOL
TrackBar_GetUseDockManager(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetUseDockManager)
    return (BOOL)(((SYSCALL1) (pTrackBar_GetUseDockManager))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetUseDockManager)
void
TrackBar_SetUseDockManager(TTrackBar AObj, BOOL AValue) {
    GET_FUNC_ADDR(TrackBar_SetUseDockManager)
    (((SYSCALL2) (pTrackBar_SetUseDockManager))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetAction)
TAction
TrackBar_GetAction(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetAction)
    return (TAction)(((SYSCALL1) (pTrackBar_GetAction))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetAction)
void
TrackBar_SetAction(TTrackBar AObj, TAction AValue) {
    GET_FUNC_ADDR(TrackBar_SetAction)
    (((SYSCALL2) (pTrackBar_SetAction))(COV_PARAM(AObj), COV_PARAM(AValue)));
}

DEFINE_FUNC_PTR(TrackBar_GetBiDiMode)
TBiDiMode
TrackBar_GetBiDiMode(TTrackBar AObj) {
    GET_FUNC_ADDR(TrackBar_GetBiDiMode)
    return (TBiDiMode)(((SYSCALL1) (pTrackBar_GetBiDiMode))(COV_PARAM(AObj)));
}

DEFINE_FUNC_PTR(TrackBar_SetBiDiMode)
void
TrackBar_SetBiDiMode(TTrackBar AObj, TBiDiMode AValue) {
    GET_FUNC_ADDR(TrackBar_SetBiDiMode)
    (((SY