
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TXButton struct {
    IControl
    instance unsafe.Pointer
}

// NewXButton
//
// 创建一个新的对象。
// 
// Create a new object.
func NewXButton(owner IComponent) *TXButton {
    x := new(TXButton)
    x.instance = unsafe.Pointer(XButton_Create(CheckPtr(owner)))
    return x
}

// AsXButton
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsXButton(obj interface{}) *TXButton {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TXButton{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (x *TXButton) Free() {
    if x.instance != nullptr {
        XButton_Free(x._instance())
        x.instance  = nullptr
    }
}

func (x *TXButton) _instance() uintptr {
    return uintptr(x.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (x *TXButton) Instance() uintptr {
    return x._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (x *TXButton) UnsafeAddr() unsafe.Pointer {
    return x.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (x *TXButton) IsValid() bool {
    return x.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (x *TXButton) Is() TIs {
    return TIs(x._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (x *TXButton) As() TAs {
//    return TAs(x._instance())
//}

// TXButtonClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TXButtonClass() TClass {
    return XButton_StaticClassType()
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (x *TXButton) BringToFront() {
    XButton_BringToFront(x._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (x *TXButton) ClientToScreen(Point TPoint) TPoint {
    return XButton_ClientToScreen(x._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (x *TXButton) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return XButton_ClientToParent(x._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (x *TXButton) Dragging() bool {
    return XButton_Dragging(x._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (x *TXButton) HasParent() bool {
    return XButton_HasParent(x._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (x *TXButton) Hide() {
    XButton_Hide(x._instance())
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (x *TXButton) Invalidate() {
    XButton_Invalidate(x._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (x *TXButton) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return XButton_Perform(x._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (x *TXButton) Refresh() {
    XButton_Refresh(x._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (x *TXButton) Repaint() {
    XButton_Repaint(x._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (x *TXButton) ScreenToClient(Point TPoint) TPoint {
    return XButton_ScreenToClient(x._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (x *TXButton) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return XButton_ParentToClient(x._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (x *TXButton) SendToBack() {
    XButton_SendToBack(x._instance())
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (x *TXButton) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    XButton_SetBounds(x._instance(), ALeft , ATop , AWidth , AHeight)
}

// Show
//
// 显示控件。
//
// Show control.
func (x *TXButton) Show() {
    XButton_Show(x._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (x *TXButton) Update() {
    XButton_Update(x._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (x *TXButton) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return XButton_GetTextBuf(x._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (x *TXButton) GetTextLen() int32 {
    return XButton_GetTextLen(x._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (x *TXButton) SetTextBuf(Buffer string) {
    XButton_SetTextBuf(x._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (x *TXButton) FindComponent(AName string) *TComponent {
    return AsComponent(XButton_FindComponent(x._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (x *TXButton) GetNamePath() string {
    return XButton_GetNamePath(x._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (x *TXButton) Assign(Source IObject) {
    XButton_Assign(x._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (x *TXButton) ClassType() TClass {
    return XButton_ClassType(x._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (x *TXButton) ClassName() string {
    return XButton_ClassName(x._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (x *TXButton) InstanceSize() int32 {
    return XButton_InstanceSize(x._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (x *TXButton) InheritsFrom(AClass TClass) bool {
    return XButton_InheritsFrom(x._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (x *TXButton) Equals(Obj IObject) bool {
    return XButton_Equals(x._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (x *TXButton) GetHashCode() int32 {
    return XButton_GetHashCode(x._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (x *TXButton) ToString() string {
    return XButton_ToString(x._instance())
}

func (x *TXButton) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    XButton_AnchorToNeighbour(x._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (x *TXButton) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    XButton_AnchorParallel(x._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (x *TXButton) AnchorHorizontalCenterTo(ASibling IControl) {
    XButton_AnchorHorizontalCenterTo(x._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (x *TXButton) AnchorVerticalCenterTo(ASibling IControl) {
    XButton_AnchorVerticalCenterTo(x._instance(), CheckPtr(ASibling))
}

func (x *TXButton) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    XButton_AnchorSame(x._instance(), ASide , CheckPtr(ASibling))
}

func (x *TXButton) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    XButton_AnchorAsAlign(x._instance(), ATheAlign , ASpace)
}

func (x *TXButton) AnchorClient(ASpace int32) {
    XButton_AnchorClient(x._instance(), ASpace)
}

func (x *TXButton) ScaleDesignToForm(ASize int32) int32 {
    return XButton_ScaleDesignToForm(x._instance(), ASize)
}

func (x *TXButton) ScaleFormToDesign(ASize int32) int32 {
    return XButton_ScaleFormToDesign(x._instance(), ASize)
}

func (x *TXButton) Scale96ToForm(ASize int32) int32 {
    return XButton_Scale96ToForm(x._instance(), ASize)
}

func (x *TXButton) ScaleFormTo96(ASize int32) int32 {
    return XButton_ScaleFormTo96(x._instance(), ASize)
}

func (x *TXButton) Scale96ToFont(ASize int32) int32 {
    return XButton_Scale96ToFont(x._instance(), ASize)
}

func (x *TXButton) ScaleFontTo96(ASize int32) int32 {
    return XButton_ScaleFontTo96(x._instance(), ASize)
}

func (x *TXButton) ScaleScreenToFont(ASize int32) int32 {
    return XButton_ScaleScreenToFont(x._instance(), ASize)
}

func (x *TXButton) ScaleFontToScreen(ASize int32) int32 {
    return XButton_ScaleFontToScreen(x._instance(), ASize)
}

func (x *TXButton) Scale96ToScreen(ASize int32) int32 {
    return XButton_Scale96ToScreen(x._instance(), ASize)
}

func (x *TXButton) ScaleScreenTo96(ASize int32) int32 {
    return XButton_ScaleScreenTo96(x._instance(), ASize)
}

func (x *TXButton) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    XButton_AutoAdjustLayout(x._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (x *TXButton) FixDesignFontsPPI(ADesignTimePPI int32) {
    XButton_FixDesignFontsPPI(x._instance(), ADesignTimePPI)
}

func (x *TXButton) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    XButton_ScaleFontsPPI(x._instance(), AToPPI , AProportion)
}

// Caption
//
// 获取控件标题。
//
// Get the control title.
func (x *TXButton) Caption() string {
    return XButton_GetCaption(x._instance())
}

// SetCaption
//
// 设置控件标题。
//
// Set the control title.
func (x *TXButton) SetCaption(value string) {
    XButton_SetCaption(x._instance(), value)
}

func (x *TXButton) ShowCaption() bool {
    return XButton_GetShowCaption(x._instance())
}

func (x *TXButton) SetShowCaption(value bool) {
    XButton_SetShowCaption(x._instance(), value)
}

func (x *TXButton) BackColor() TColor {
    return XButton_GetBackColor(x._instance())
}

func (x *TXButton) SetBackColor(value TColor) {
    XButton_SetBackColor(x._instance(), value)
}

func (x *TXButton) HoverColor() TColor {
    return XButton_GetHoverColor(x._instance())
}

func (x *TXButton) SetHoverColor(value TColor) {
    XButton_SetHoverColor(x._instance(), value)
}

func (x *TXButton) DownColor() TColor {
    return XButton_GetDownColor(x._instance())
}

func (x *TXButton) SetDownColor(value TColor) {
    XButton_SetDownColor(x._instance(), value)
}

// BorderWidth
//
// 获取边框的宽度。
func (x *TXButton) BorderWidth() int32 {
    return XButton_GetBorderWidth(x._instance())
}

// SetBorderWidth
//
// 设置边框的宽度。
func (x *TXButton) SetBorderWidth(value int32) {
    XButton_SetBorderWidth(x._instance(), value)
}

func (x *TXButton) BorderColor() TColor {
    return XButton_GetBorderColor(x._instance())
}

func (x *TXButton) SetBorderColor(value TColor) {
    XButton_SetBorderColor(x._instance(), value)
}

// Picture
//
// 获取图片。
func (x *TXButton) Picture() *TPicture {
    return AsPicture(XButton_GetPicture(x._instance()))
}

// SetPicture
//
// 设置图片。
func (x *TXButton) SetPicture(value *TPicture) {
    XButton_SetPicture(x._instance(), CheckPtr(value))
}

func (x *TXButton) DrawMode() TDrawImageMode {
    return XButton_GetDrawMode(x._instance())
}

func (x *TXButton) SetDrawMode(value TDrawImageMode) {
    XButton_SetDrawMode(x._instance(), value)
}

func (x *TXButton) NormalFontColor() TColor {
    return XButton_GetNormalFontColor(x._instance())
}

func (x *TXButton) SetNormalFontColor(value TColor) {
    XButton_SetNormalFontColor(x._instance(), value)
}

func (x *TXButton) DownFontColor() TColor {
    return XButton_GetDownFontColor(x._instance())
}

func (x *TXButton) SetDownFontColor(value TColor) {
    XButton_SetDownFontColor(x._instance(), value)
}

func (x *TXButton) HoverFontColor() TColor {
    return XButton_GetHoverFontColor(x._instance())
}

func (x *TXButton) SetHoverFontColor(value TColor) {
    XButton_SetHoverFontColor(x._instance(), value)
}

func (x *TXButton) Action() *TAction {
    return AsAction(XButton_GetAction(x._instance()))
}

func (x *TXButton) SetAction(value IComponent) {
    XButton_SetAction(x._instance(), CheckPtr(value))
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (x *TXButton) Align() TAlign {
    return XButton_GetAlign(x._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (x *TXButton) SetAlign(value TAlign) {
    XButton_SetAlign(x._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (x *TXButton) Anchors() TAnchors {
    return XButton_GetAnchors(x._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (x *TXButton) SetAnchors(value TAnchors) {
    XButton_SetAnchors(x._instance(), value)
}

func (x *TXButton) BiDiMode() TBiDiMode {
    return XButton_GetBiDiMode(x._instance())
}

func (x *TXButton) SetBiDiMode(value TBiDiMode) {
    XButton_SetBiDiMode(x._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (x *TXButton) Constraints() *TSizeConstraints {
    return AsSizeConstraints(XButton_GetConstraints(x._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (x *TXButton) SetConstraints(value *TSizeConstraints) {
    XButton_SetConstraints(x._instance(), CheckPtr(value))
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (x *TXButton) Enabled() bool {
    return XButton_GetEnabled(x._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (x *TXButton) SetEnabled(value bool) {
    XButton_SetEnabled(x._instance(), value)
}

// Font
//
// 获取字体。
//
// Get Font.
func (x *TXButton) Font() *TFont {
    return AsFont(XButton_GetFont(x._instance()))
}

// SetFont
//
// 设置字体。
//
// Set Font.
func (x *TXButton) SetFont(value *TFont) {
    XButton_SetFont(x._instance(), CheckPtr(value))
}

// ParentFont
//
// 获取使用父容器字体。
//
// Get Parent container font.
func (x *TXButton) ParentFont() bool {
    return XButton_GetParentFont(x._instance())
}

// SetParentFont
//
// 设置使用父容器字体。
//
// Set Parent container font.
func (x *TXButton) SetParentFont(value bool) {
    XButton_SetParentFont(x._instance(), value)
}

// ParentShowHint
//
// 获取以父容器的ShowHint属性为准。
func (x *TXButton) ParentShowHint() bool {
    return XButton_GetParentShowHint(x._instance())
}

// SetParentShowHint
//
// 设置以父容器的ShowHint属性为准。
func (x *TXButton) SetParentShowHint(value bool) {
    XButton_SetParentShowHint(x._instance(), value)
}

// PopupMenu
//
// 获取右键菜单。
//
// Get Right click menu.
func (x *TXButton) PopupMenu() *TPopupMenu {
    return AsPopupMenu(XButton_GetPopupMenu(x._instance()))
}

// SetPopupMenu
//
// 设置右键菜单。
//
// Set Right click menu.
func (x *TXButton) SetPopupMenu(value IComponent) {
    XButton_SetPopupMenu(x._instance(), CheckPtr(value))
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (x *TXButton) ShowHint() bool {
    return XButton_GetShowHint(x._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (x *TXButton) SetShowHint(value bool) {
    XButton_SetShowHint(x._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (x *TXButton) Visible() bool {
    return XButton_GetVisible(x._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (x *TXButton) SetVisible(value bool) {
    XButton_SetVisible(x._instance(), value)
}

// SetOnClick
//
// 设置控件单击事件。
//
// Set control click event.
func (x *TXButton) SetOnClick(fn TNotifyEvent) {
    XButton_SetOnClick(x._instance(), fn)
}

// SetOnDblClick
//
// 设置双击事件。
func (x *TXButton) SetOnDblClick(fn TNotifyEvent) {
    XButton_SetOnDblClick(x._instance(), fn)
}

// SetOnMouseDown
//
// 设置鼠标按下事件。
//
// Set Mouse down event.
func (x *TXButton) SetOnMouseDown(fn TMouseEvent) {
    XButton_SetOnMouseDown(x._instance(), fn)
}

// SetOnMouseEnter
//
// 设置鼠标进入事件。
//
// Set Mouse entry event.
func (x *TXButton) SetOnMouseEnter(fn TNotifyEvent) {
    XButton_SetOnMouseEnter(x._instance(), fn)
}

// SetOnMouseLeave
//
// 设置鼠标离开事件。
//
// Set Mouse leave event.
func (x *TXButton) SetOnMouseLeave(fn TNotifyEvent) {
    XButton_SetOnMouseLeave(x._instance(), fn)
}

// SetOnMouseMove
//
// 设置鼠标移动事件。
func (x *TXButton) SetOnMouseMove(fn TMouseMoveEvent) {
    XButton_SetOnMouseMove(x._instance(), fn)
}

// SetOnMouseUp
//
// 设置鼠标抬起事件。
//
// Set Mouse lift event.
func (x *TXButton) SetOnMouseUp(fn TMouseEvent) {
    XButton_SetOnMouseUp(x._instance(), fn)
}

func (x *TXButton) BoundsRect() TRect {
    return XButton_GetBoundsRect(x._instance())
}

func (x *TXButton) SetBoundsRect(value TRect) {
    XButton_SetBoundsRect(x._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (x *TXButton) ClientHeight() int32 {
    return XButton_GetClientHeight(x._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (x *TXButton) SetClientHeight(value int32) {
    XButton_SetClientHeight(x._instance(), value)
}

func (x *TXButton) ClientOrigin() TPoint {
    return XButton_GetClientOrigin(x._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (x *TXButton) ClientRect() TRect {
    return XButton_GetClientRect(x._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (x *TXButton) ClientWidth() int32 {
    return XButton_GetClientWidth(x._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (x *TXButton) SetClientWidth(value int32) {
    XButton_SetClientWidth(x._instance(), value)
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (x *TXButton) ControlState() TControlState {
    return XButton_GetControlState(x._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (x *TXButton) SetControlState(value TControlState) {
    XButton_SetControlState(x._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (x *TXButton) ControlStyle() TControlStyle {
    return XButton_GetControlStyle(x._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (x *TXButton) SetControlStyle(value TControlStyle) {
    XButton_SetControlStyle(x._instance(), value)
}

func (x *TXButton) Floating() bool {
    return XButton_GetFloating(x._instance())
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (x *TXButton) Parent() *TWinControl {
    return AsWinControl(XButton_GetParent(x._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (x *TXButton) SetParent(value IWinControl) {
    XButton_SetParent(x._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (x *TXButton) Left() int32 {
    return XButton_GetLeft(x._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (x *TXButton) SetLeft(value int32) {
    XButton_SetLeft(x._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (x *TXButton) Top() int32 {
    return XButton_GetTop(x._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (x *TXButton) SetTop(value int32) {
    XButton_SetTop(x._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (x *TXButton) Width() int32 {
    return XButton_GetWidth(x._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (x *TXButton) SetWidth(value int32) {
    XButton_SetWidth(x._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (x *TXButton) Height() int32 {
    return XButton_GetHeight(x._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (x *TXButton) SetHeight(value int32) {
    XButton_SetHeight(x._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (x *TXButton) Cursor() TCursor {
    return XButton_GetCursor(x._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (x *TXButton) SetCursor(value TCursor) {
    XButton_SetCursor(x._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (x *TXButton) Hint() string {
    return XButton_GetHint(x._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (x *TXButton) SetHint(value string) {
    XButton_SetHint(x._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (x *TXButton) ComponentCount() int32 {
    return XButton_GetComponentCount(x._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (x *TXButton) ComponentIndex() int32 {
    return XButton_GetComponentIndex(x._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (x *TXButton) SetComponentIndex(value int32) {
    XButton_SetComponentIndex(x._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (x *TXButton) Owner() *TComponent {
    return AsComponent(XButton_GetOwner(x._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (x *TXButton) Name() string {
    return XButton_GetName(x._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (x *TXButton) SetName(value string) {
    XButton_SetName(x._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (x *TXButton) Tag() int {
    return XButton_GetTag(x._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (x *TXButton) SetTag(value int) {
    XButton_SetTag(x._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (x *TXButton) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(XButton_GetAnchorSideLeft(x._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (x *TXButton) SetAnchorSideLeft(value *TAnchorSide) {
    XButton_SetAnchorSideLeft(x._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (x *TXButton) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(XButton_GetAnchorSideTop(x._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (x *TXButton) SetAnchorSideTop(value *TAnchorSide) {
    XButton_SetAnchorSideTop(x._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (x *TXButton) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(XButton_GetAnchorSideRight(x._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (x *TXButton) SetAnchorSideRight(value *TAnchorSide) {
    XButton_SetAnchorSideRight(x._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (x *TXButton) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(XButton_GetAnchorSideBottom(x._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (x *TXButton) SetAnchorSideBottom(value *TAnchorSide) {
    XButton_SetAnchorSideBottom(x._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (x *TXButton) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(XButton_GetBorderSpacing(x._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (x *TXButton) SetBorderSpacing(value *TControlBorderSpacing) {
    XButton_SetBorderSpacing(x._instance(), CheckPtr(value))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (x *TXButton) Components(AIndex int32) *TComponent {
    return AsComponent(XButton_GetComponents(x._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (x *TXButton) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(XButton_GetAnchorSide(x._instance(), AKind))
}

