
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TWinControl struct {
    IWinControl
    instance unsafe.Pointer
}

// NewWinControl
//
// 创建一个新的对象。
// 
// Create a new object.
func NewWinControl(owner IComponent) *TWinControl {
    w := new(TWinControl)
    w.instance = unsafe.Pointer(WinControl_Create(CheckPtr(owner)))
    return w
}

// AsWinControl
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsWinControl(obj interface{}) *TWinControl {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TWinControl{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (w *TWinControl) Free() {
    if w.instance != nullptr {
        WinControl_Free(w._instance())
        w.instance  = nullptr
    }
}

func (w *TWinControl) _instance() uintptr {
    return uintptr(w.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (w *TWinControl) Instance() uintptr {
    return w._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (w *TWinControl) UnsafeAddr() unsafe.Pointer {
    return w.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (w *TWinControl) IsValid() bool {
    return w.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (w *TWinControl) Is() TIs {
    return TIs(w._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (w *TWinControl) As() TAs {
//    return TAs(w._instance())
//}

// TWinControlClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TWinControlClass() TClass {
    return WinControl_StaticClassType()
}

// CanFocus
//
// 是否可以获得焦点。
func (w *TWinControl) CanFocus() bool {
    return WinControl_CanFocus(w._instance())
}

// ContainsControl
//
// 返回是否包含指定控件。
//
// it's contain a specified control.
func (w *TWinControl) ContainsControl(Control IControl) bool {
    return WinControl_ContainsControl(w._instance(), CheckPtr(Control))
}

// ControlAtPos
//
// 返回指定坐标及相关属性位置控件。
//
// Returns the specified coordinate and the relevant attribute position control..
func (w *TWinControl) ControlAtPos(Pos TPoint, AllowDisabled bool, AllowWinControls bool, AllLevels bool) *TControl {
    return AsControl(WinControl_ControlAtPos(w._instance(), Pos , AllowDisabled , AllowWinControls , AllLevels))
}

// DisableAlign
//
// 禁用控件的对齐。
//
// Disable control alignment.
func (w *TWinControl) DisableAlign() {
    WinControl_DisableAlign(w._instance())
}

// EnableAlign
//
// 启用控件对齐。
//
// Enabled control alignment.
func (w *TWinControl) EnableAlign() {
    WinControl_EnableAlign(w._instance())
}

// FindChildControl
//
// 查找子控件。
//
// Find sub controls.
func (w *TWinControl) FindChildControl(ControlName string) *TControl {
    return AsControl(WinControl_FindChildControl(w._instance(), ControlName))
}

func (w *TWinControl) FlipChildren(AllLevels bool) {
    WinControl_FlipChildren(w._instance(), AllLevels)
}

// Focused
//
// 返回是否获取焦点。
//
// Return to get focus.
func (w *TWinControl) Focused() bool {
    return WinControl_Focused(w._instance())
}

// HandleAllocated
//
// 句柄是否已经分配。
//
// Is the handle already allocated.
func (w *TWinControl) HandleAllocated() bool {
    return WinControl_HandleAllocated(w._instance())
}

// InsertControl
//
// 插入一个控件。
//
// Insert a control.
func (w *TWinControl) InsertControl(AControl IControl) {
    WinControl_InsertControl(w._instance(), CheckPtr(AControl))
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (w *TWinControl) Invalidate() {
    WinControl_Invalidate(w._instance())
}

// PaintTo
//
// 绘画至指定DC。
//
// Painting to the specified DC.
func (w *TWinControl) PaintTo(DC HDC, X int32, Y int32) {
    WinControl_PaintTo(w._instance(), DC , X , Y)
}

// RemoveControl
//
// 移除一个控件。
//
// Remove a control.
func (w *TWinControl) RemoveControl(AControl IControl) {
    WinControl_RemoveControl(w._instance(), CheckPtr(AControl))
}

// Realign
//
// 重新对齐。
//
// Realign.
func (w *TWinControl) Realign() {
    WinControl_Realign(w._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (w *TWinControl) Repaint() {
    WinControl_Repaint(w._instance())
}

// ScaleBy
//
// 按比例缩放。
//
// Scale by.
func (w *TWinControl) ScaleBy(M int32, D int32) {
    WinControl_ScaleBy(w._instance(), M , D)
}

// ScrollBy
//
// 滚动至指定位置。
//
// Scroll by.
func (w *TWinControl) ScrollBy(DeltaX int32, DeltaY int32) {
    WinControl_ScrollBy(w._instance(), DeltaX , DeltaY)
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (w *TWinControl) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    WinControl_SetBounds(w._instance(), ALeft , ATop , AWidth , AHeight)
}

// SetFocus
//
// 设置控件焦点。
//
// Set control focus.
func (w *TWinControl) SetFocus() {
    WinControl_SetFocus(w._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (w *TWinControl) Update() {
    WinControl_Update(w._instance())
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (w *TWinControl) BringToFront() {
    WinControl_BringToFront(w._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (w *TWinControl) ClientToScreen(Point TPoint) TPoint {
    return WinControl_ClientToScreen(w._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (w *TWinControl) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return WinControl_ClientToParent(w._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (w *TWinControl) Dragging() bool {
    return WinControl_Dragging(w._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (w *TWinControl) HasParent() bool {
    return WinControl_HasParent(w._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (w *TWinControl) Hide() {
    WinControl_Hide(w._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (w *TWinControl) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return WinControl_Perform(w._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (w *TWinControl) Refresh() {
    WinControl_Refresh(w._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (w *TWinControl) ScreenToClient(Point TPoint) TPoint {
    return WinControl_ScreenToClient(w._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (w *TWinControl) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return WinControl_ParentToClient(w._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (w *TWinControl) SendToBack() {
    WinControl_SendToBack(w._instance())
}

// Show
//
// 显示控件。
//
// Show control.
func (w *TWinControl) Show() {
    WinControl_Show(w._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (w *TWinControl) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return WinControl_GetTextBuf(w._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (w *TWinControl) GetTextLen() int32 {
    return WinControl_GetTextLen(w._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (w *TWinControl) SetTextBuf(Buffer string) {
    WinControl_SetTextBuf(w._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (w *TWinControl) FindComponent(AName string) *TComponent {
    return AsComponent(WinControl_FindComponent(w._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (w *TWinControl) GetNamePath() string {
    return WinControl_GetNamePath(w._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (w *TWinControl) Assign(Source IObject) {
    WinControl_Assign(w._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (w *TWinControl) ClassType() TClass {
    return WinControl_ClassType(w._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (w *TWinControl) ClassName() string {
    return WinControl_ClassName(w._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (w *TWinControl) InstanceSize() int32 {
    return WinControl_InstanceSize(w._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (w *TWinControl) InheritsFrom(AClass TClass) bool {
    return WinControl_InheritsFrom(w._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (w *TWinControl) Equals(Obj IObject) bool {
    return WinControl_Equals(w._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (w *TWinControl) GetHashCode() int32 {
    return WinControl_GetHashCode(w._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (w *TWinControl) ToString() string {
    return WinControl_ToString(w._instance())
}

func (w *TWinControl) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    WinControl_AnchorToNeighbour(w._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (w *TWinControl) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    WinControl_AnchorParallel(w._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (w *TWinControl) AnchorHorizontalCenterTo(ASibling IControl) {
    WinControl_AnchorHorizontalCenterTo(w._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (w *TWinControl) AnchorVerticalCenterTo(ASibling IControl) {
    WinControl_AnchorVerticalCenterTo(w._instance(), CheckPtr(ASibling))
}

func (w *TWinControl) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    WinControl_AnchorSame(w._instance(), ASide , CheckPtr(ASibling))
}

func (w *TWinControl) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    WinControl_AnchorAsAlign(w._instance(), ATheAlign , ASpace)
}

func (w *TWinControl) AnchorClient(ASpace int32) {
    WinControl_AnchorClient(w._instance(), ASpace)
}

func (w *TWinControl) ScaleDesignToForm(ASize int32) int32 {
    return WinControl_ScaleDesignToForm(w._instance(), ASize)
}

func (w *TWinControl) ScaleFormToDesign(ASize int32) int32 {
    return WinControl_ScaleFormToDesign(w._instance(), ASize)
}

func (w *TWinControl) Scale96ToForm(ASize int32) int32 {
    return WinControl_Scale96ToForm(w._instance(), ASize)
}

func (w *TWinControl) ScaleFormTo96(ASize int32) int32 {
    return WinControl_ScaleFormTo96(w._instance(), ASize)
}

func (w *TWinControl) Scale96ToFont(ASize int32) int32 {
    return WinControl_Scale96ToFont(w._instance(), ASize)
}

func (w *TWinControl) ScaleFontTo96(ASize int32) int32 {
    return WinControl_ScaleFontTo96(w._instance(), ASize)
}

func (w *TWinControl) ScaleScreenToFont(ASize int32) int32 {
    return WinControl_ScaleScreenToFont(w._instance(), ASize)
}

func (w *TWinControl) ScaleFontToScreen(ASize int32) int32 {
    return WinControl_ScaleFontToScreen(w._instance(), ASize)
}

func (w *TWinControl) Scale96ToScreen(ASize int32) int32 {
    return WinControl_Scale96ToScreen(w._instance(), ASize)
}

func (w *TWinControl) ScaleScreenTo96(ASize int32) int32 {
    return WinControl_ScaleScreenTo96(w._instance(), ASize)
}

func (w *TWinControl) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    WinControl_AutoAdjustLayout(w._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (w *TWinControl) FixDesignFontsPPI(ADesignTimePPI int32) {
    WinControl_FixDesignFontsPPI(w._instance(), ADesignTimePPI)
}

func (w *TWinControl) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    WinControl_ScaleFontsPPI(w._instance(), AToPPI , AProportion)
}

// DockClientCount
//
// 获取依靠客户端总数。
func (w *TWinControl) DockClientCount() int32 {
    return WinControl_GetDockClientCount(w._instance())
}

// DockSite
//
// 获取停靠站点。
//
// Get Docking site.
func (w *TWinControl) DockSite() bool {
    return WinControl_GetDockSite(w._instance())
}

// SetDockSite
//
// 设置停靠站点。
//
// Set Docking site.
func (w *TWinControl) SetDockSite(value bool) {
    WinControl_SetDockSite(w._instance(), value)
}

// DoubleBuffered
//
// 获取设置控件双缓冲。
//
// Get Set control double buffering.
func (w *TWinControl) DoubleBuffered() bool {
    return WinControl_GetDoubleBuffered(w._instance())
}

// SetDoubleBuffered
//
// 设置设置控件双缓冲。
//
// Set Set control double buffering.
func (w *TWinControl) SetDoubleBuffered(value bool) {
    WinControl_SetDoubleBuffered(w._instance(), value)
}

// MouseInClient
//
// 获取鼠标是否在客户端，仅VCL有效。
//
// Get Whether the mouse is on the client, only VCL is valid.
func (w *TWinControl) MouseInClient() bool {
    return WinControl_GetMouseInClient(w._instance())
}

// VisibleDockClientCount
//
// 获取当前停靠的可视总数。
//
// Get The total number of visible calls currently docked.
func (w *TWinControl) VisibleDockClientCount() int32 {
    return WinControl_GetVisibleDockClientCount(w._instance())
}

// Brush
//
// 获取画刷对象。
//
// Get Brush.
func (w *TWinControl) Brush() *TBrush {
    return AsBrush(WinControl_GetBrush(w._instance()))
}

// ControlCount
//
// 获取子控件数。
//
// Get Number of child controls.
func (w *TWinControl) ControlCount() int32 {
    return WinControl_GetControlCount(w._instance())
}

// Handle
//
// 获取控件句柄。
//
// Get Control handle.
func (w *TWinControl) Handle() HWND {
    return WinControl_GetHandle(w._instance())
}

// ParentDoubleBuffered
//
// 获取使用父容器双缓冲。
//
// Get Parent container double buffering.
func (w *TWinControl) ParentDoubleBuffered() bool {
    return WinControl_GetParentDoubleBuffered(w._instance())
}

// SetParentDoubleBuffered
//
// 设置使用父容器双缓冲。
//
// Set Parent container double buffering.
func (w *TWinControl) SetParentDoubleBuffered(value bool) {
    WinControl_SetParentDoubleBuffered(w._instance(), value)
}

// ParentWindow
//
// 获取父容器句柄。
//
// Get Parent container handle.
func (w *TWinControl) ParentWindow() HWND {
    return WinControl_GetParentWindow(w._instance())
}

// SetParentWindow
//
// 设置父容器句柄。
//
// Set Parent container handle.
func (w *TWinControl) SetParentWindow(value HWND) {
    WinControl_SetParentWindow(w._instance(), value)
}

func (w *TWinControl) Showing() bool {
    return WinControl_GetShowing(w._instance())
}

// TabOrder
//
// 获取Tab切换顺序序号。
//
// Get Tab switching sequence number.
func (w *TWinControl) TabOrder() TTabOrder {
    return WinControl_GetTabOrder(w._instance())
}

// SetTabOrder
//
// 设置Tab切换顺序序号。
//
// Set Tab switching sequence number.
func (w *TWinControl) SetTabOrder(value TTabOrder) {
    WinControl_SetTabOrder(w._instance(), value)
}

// TabStop
//
// 获取Tab可停留。
//
// Get Tab can stay.
func (w *TWinControl) TabStop() bool {
    return WinControl_GetTabStop(w._instance())
}

// SetTabStop
//
// 设置Tab可停留。
//
// Set Tab can stay.
func (w *TWinControl) SetTabStop(value bool) {
    WinControl_SetTabStop(w._instance(), value)
}

// UseDockManager
//
// 获取使用停靠管理。
func (w *TWinControl) UseDockManager() bool {
    return WinControl_GetUseDockManager(w._instance())
}

// SetUseDockManager
//
// 设置使用停靠管理。
func (w *TWinControl) SetUseDockManager(value bool) {
    WinControl_SetUseDockManager(w._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (w *TWinControl) Enabled() bool {
    return WinControl_GetEnabled(w._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (w *TWinControl) SetEnabled(value bool) {
    WinControl_SetEnabled(w._instance(), value)
}

func (w *TWinControl) Action() *TAction {
    return AsAction(WinControl_GetAction(w._instance()))
}

func (w *TWinControl) SetAction(value IComponent) {
    WinControl_SetAction(w._instance(), CheckPtr(value))
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (w *TWinControl) Align() TAlign {
    return WinControl_GetAlign(w._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (w *TWinControl) SetAlign(value TAlign) {
    WinControl_SetAlign(w._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (w *TWinControl) Anchors() TAnchors {
    return WinControl_GetAnchors(w._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (w *TWinControl) SetAnchors(value TAnchors) {
    WinControl_SetAnchors(w._instance(), value)
}

func (w *TWinControl) BiDiMode() TBiDiMode {
    return WinControl_GetBiDiMode(w._instance())
}

func (w *TWinControl) SetBiDiMode(value TBiDiMode) {
    WinControl_SetBiDiMode(w._instance(), value)
}

func (w *TWinControl) BoundsRect() TRect {
    return WinControl_GetBoundsRect(w._instance())
}

func (w *TWinControl) SetBoundsRect(value TRect) {
    WinControl_SetBoundsRect(w._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (w *TWinControl) ClientHeight() int32 {
    return WinControl_GetClientHeight(w._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (w *TWinControl) SetClientHeight(value int32) {
    WinControl_SetClientHeight(w._instance(), value)
}

func (w *TWinControl) ClientOrigin() TPoint {
    return WinControl_GetClientOrigin(w._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (w *TWinControl) ClientRect() TRect {
    return WinControl_GetClientRect(w._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (w *TWinControl) ClientWidth() int32 {
    return WinControl_GetClientWidth(w._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (w *TWinControl) SetClientWidth(value int32) {
    WinControl_SetClientWidth(w._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (w *TWinControl) Constraints() *TSizeConstraints {
    return AsSizeConstraints(WinControl_GetConstraints(w._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (w *TWinControl) SetConstraints(value *TSizeConstraints) {
    WinControl_SetConstraints(w._instance(), CheckPtr(value))
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (w *TWinControl) ControlState() TControlState {
    return WinControl_GetControlState(w._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (w *TWinControl) SetControlState(value TControlState) {
    WinControl_SetControlState(w._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (w *TWinControl) ControlStyle() TControlStyle {
    return WinControl_GetControlStyle(w._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (w *TWinControl) SetControlStyle(value TControlStyle) {
    WinControl_SetControlStyle(w._instance(), value)
}

func (w *TWinControl) Floating() bool {
    return WinControl_GetFloating(w._instance())
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (w *TWinControl) ShowHint() bool {
    return WinControl_GetShowHint(w._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (w *TWinControl) SetShowHint(value bool) {
    WinControl_SetShowHint(w._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (w *TWinControl) Visible() bool {
    return WinControl_GetVisible(w._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (w *TWinControl) SetVisible(value bool) {
    WinControl_SetVisible(w._instance(), value)
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (w *TWinControl) Parent() *TWinControl {
    return AsWinControl(WinControl_GetParent(w._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (w *TWinControl) SetParent(value IWinControl) {
    WinControl_SetParent(w._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (w *TWinControl) Left() int32 {
    return WinControl_GetLeft(w._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (w *TWinControl) SetLeft(value int32) {
    WinControl_SetLeft(w._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (w *TWinControl) Top() int32 {
    return WinControl_GetTop(w._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (w *TWinControl) SetTop(value int32) {
    WinControl_SetTop(w._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (w *TWinControl) Width() int32 {
    return WinControl_GetWidth(w._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (w *TWinControl) SetWidth(value int32) {
    WinControl_SetWidth(w._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (w *TWinControl) Height() int32 {
    return WinControl_GetHeight(w._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (w *TWinControl) SetHeight(value int32) {
    WinControl_SetHeight(w._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (w *TWinControl) Cursor() TCursor {
    return WinControl_GetCursor(w._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (w *TWinControl) SetCursor(value TCursor) {
    WinControl_SetCursor(w._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (w *TWinControl) Hint() string {
    return WinControl_GetHint(w._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (w *TWinControl) SetHint(value string) {
    WinControl_SetHint(w._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (w *TWinControl) ComponentCount() int32 {
    return WinControl_GetComponentCount(w._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (w *TWinControl) ComponentIndex() int32 {
    return WinControl_GetComponentIndex(w._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (w *TWinControl) SetComponentIndex(value int32) {
    WinControl_SetComponentIndex(w._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (w *TWinControl) Owner() *TComponent {
    return AsComponent(WinControl_GetOwner(w._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (w *TWinControl) Name() string {
    return WinControl_GetName(w._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (w *TWinControl) SetName(value string) {
    WinControl_SetName(w._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (w *TWinControl) Tag() int {
    return WinControl_GetTag(w._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (w *TWinControl) SetTag(value int) {
    WinControl_SetTag(w._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (w *TWinControl) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(WinControl_GetAnchorSideLeft(w._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (w *TWinControl) SetAnchorSideLeft(value *TAnchorSide) {
    WinControl_SetAnchorSideLeft(w._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (w *TWinControl) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(WinControl_GetAnchorSideTop(w._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (w *TWinControl) SetAnchorSideTop(value *TAnchorSide) {
    WinControl_SetAnchorSideTop(w._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (w *TWinControl) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(WinControl_GetAnchorSideRight(w._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (w *TWinControl) SetAnchorSideRight(value *TAnchorSide) {
    WinControl_SetAnchorSideRight(w._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (w *TWinControl) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(WinControl_GetAnchorSideBottom(w._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (w *TWinControl) SetAnchorSideBottom(value *TAnchorSide) {
    WinControl_SetAnchorSideBottom(w._instance(), CheckPtr(value))
}

func (w *TWinControl) ChildSizing() *TControlChildSizing {
    return AsControlChildSizing(WinControl_GetChildSizing(w._instance()))
}

func (w *TWinControl) SetChildSizing(value *TControlChildSizing) {
    WinControl_SetChildSizing(w._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (w *TWinControl) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(WinControl_GetBorderSpacing(w._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (w *TWinControl) SetBorderSpacing(value *TControlBorderSpacing) {
    WinControl_SetBorderSpacing(w._instance(), CheckPtr(value))
}

// DockClients
//
// 获取指定索引停靠客户端。
func (w *TWinControl) DockClients(Index int32) *TControl {
    return AsControl(WinControl_GetDockClients(w._instance(), Index))
}

// Controls
//
// 获取指定索引子控件。
func (w *TWinControl) Controls(Index int32) *TControl {
    return AsControl(WinControl_GetControls(w._instance(), Index))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (w *TWinControl) Components(AIndex int32) *TComponent {
    return AsComponent(WinControl_GetComponents(w._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (w *TWinControl) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(WinControl_GetAnchorSide(w._instance(), AKind))
}

