
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TTreeNodes struct {
    IObject
    instance unsafe.Pointer
}

// NewTreeNodes
//
// 创建一个新的对象。
// 
// Create a new object.
func NewTreeNodes(AOwner *TTreeView) *TTreeNodes {
    t := new(TTreeNodes)
    t.instance = unsafe.Pointer(TreeNodes_Create(CheckPtr(AOwner)))
    setFinalizer(t, (*TTreeNodes).Free)
    return t
}

// AsTreeNodes
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsTreeNodes(obj interface{}) *TTreeNodes {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TTreeNodes{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (t *TTreeNodes) Free() {
    if t.instance != nullptr {
        TreeNodes_Free(t._instance())
        t.instance  = nullptr
    }
}

func (t *TTreeNodes) _instance() uintptr {
    return uintptr(t.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (t *TTreeNodes) Instance() uintptr {
    return t._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (t *TTreeNodes) UnsafeAddr() unsafe.Pointer {
    return t.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (t *TTreeNodes) IsValid() bool {
    return t.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (t *TTreeNodes) Is() TIs {
    return TIs(t._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (t *TTreeNodes) As() TAs {
//    return TAs(t._instance())
//}

// TTreeNodesClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TTreeNodesClass() TClass {
    return TreeNodes_StaticClassType()
}

func (t *TTreeNodes) AddChildFirst(Parent *TTreeNode, S string) *TTreeNode {
    return AsTreeNode(TreeNodes_AddChildFirst(t._instance(), CheckPtr(Parent), S))
}

func (t *TTreeNodes) AddChild(Parent *TTreeNode, S string) *TTreeNode {
    return AsTreeNode(TreeNodes_AddChild(t._instance(), CheckPtr(Parent), S))
}

func (t *TTreeNodes) AddChildObjectFirst(Parent *TTreeNode, S string, Ptr uintptr) *TTreeNode {
    return AsTreeNode(TreeNodes_AddChildObjectFirst(t._instance(), CheckPtr(Parent), S , Ptr))
}

func (t *TTreeNodes) AddChildObject(Parent *TTreeNode, S string, Ptr uintptr) *TTreeNode {
    return AsTreeNode(TreeNodes_AddChildObject(t._instance(), CheckPtr(Parent), S , Ptr))
}

func (t *TTreeNodes) AddObjectFirst(Sibling *TTreeNode, S string, Ptr uintptr) *TTreeNode {
    return AsTreeNode(TreeNodes_AddObjectFirst(t._instance(), CheckPtr(Sibling), S , Ptr))
}

func (t *TTreeNodes) AddObject(Sibling *TTreeNode, S string, Ptr uintptr) *TTreeNode {
    return AsTreeNode(TreeNodes_AddObject(t._instance(), CheckPtr(Sibling), S , Ptr))
}

func (t *TTreeNodes) AddNode(Node *TTreeNode, Relative *TTreeNode, S string, Ptr uintptr, Method TNodeAttachMode) *TTreeNode {
    return AsTreeNode(TreeNodes_AddNode(t._instance(), CheckPtr(Node), CheckPtr(Relative), S , Ptr , Method))
}

func (t *TTreeNodes) AddFirst(Sibling *TTreeNode, S string) *TTreeNode {
    return AsTreeNode(TreeNodes_AddFirst(t._instance(), CheckPtr(Sibling), S))
}

func (t *TTreeNodes) Add(Sibling *TTreeNode, S string) *TTreeNode {
    return AsTreeNode(TreeNodes_Add(t._instance(), CheckPtr(Sibling), S))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (t *TTreeNodes) Assign(Source IObject) {
    TreeNodes_Assign(t._instance(), CheckPtr(Source))
}

func (t *TTreeNodes) BeginUpdate() {
    TreeNodes_BeginUpdate(t._instance())
}

// Clear
//
// 清除。
func (t *TTreeNodes) Clear() {
    TreeNodes_Clear(t._instance())
}

func (t *TTreeNodes) Delete(Node *TTreeNode) {
    TreeNodes_Delete(t._instance(), CheckPtr(Node))
}

func (t *TTreeNodes) EndUpdate() {
    TreeNodes_EndUpdate(t._instance())
}

func (t *TTreeNodes) GetFirstNode() *TTreeNode {
    return AsTreeNode(TreeNodes_GetFirstNode(t._instance()))
}

func (t *TTreeNodes) Insert(Sibling *TTreeNode, S string) *TTreeNode {
    return AsTreeNode(TreeNodes_Insert(t._instance(), CheckPtr(Sibling), S))
}

func (t *TTreeNodes) InsertObject(Sibling *TTreeNode, S string, Ptr uintptr) *TTreeNode {
    return AsTreeNode(TreeNodes_InsertObject(t._instance(), CheckPtr(Sibling), S , Ptr))
}

func (t *TTreeNodes) CustomSort(SortProc PFNTVCOMPARE, Data int, ARecurse bool) bool {
    return TreeNodes_CustomSort(t._instance(), SortProc , Data , ARecurse)
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (t *TTreeNodes) GetNamePath() string {
    return TreeNodes_GetNamePath(t._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (t *TTreeNodes) ClassType() TClass {
    return TreeNodes_ClassType(t._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (t *TTreeNodes) ClassName() string {
    return TreeNodes_ClassName(t._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (t *TTreeNodes) InstanceSize() int32 {
    return TreeNodes_InstanceSize(t._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (t *TTreeNodes) InheritsFrom(AClass TClass) bool {
    return TreeNodes_InheritsFrom(t._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (t *TTreeNodes) Equals(Obj IObject) bool {
    return TreeNodes_Equals(t._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (t *TTreeNodes) GetHashCode() int32 {
    return TreeNodes_GetHashCode(t._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (t *TTreeNodes) ToString() string {
    return TreeNodes_ToString(t._instance())
}

func (t *TTreeNodes) Count() int32 {
    return TreeNodes_GetCount(t._instance())
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (t *TTreeNodes) Owner() *TWinControl {
    return AsWinControl(TreeNodes_GetOwner(t._instance()))
}

func (t *TTreeNodes) Item(Index int32) *TTreeNode {
    return AsTreeNode(TreeNodes_GetItem(t._instance(), Index))
}

