
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TScrollBox struct {
    IWinControl
    instance unsafe.Pointer
}

// NewScrollBox
//
// 创建一个新的对象。
// 
// Create a new object.
func NewScrollBox(owner IComponent) *TScrollBox {
    s := new(TScrollBox)
    s.instance = unsafe.Pointer(ScrollBox_Create(CheckPtr(owner)))
    return s
}

// AsScrollBox
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsScrollBox(obj interface{}) *TScrollBox {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TScrollBox{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (s *TScrollBox) Free() {
    if s.instance != nullptr {
        ScrollBox_Free(s._instance())
        s.instance  = nullptr
    }
}

func (s *TScrollBox) _instance() uintptr {
    return uintptr(s.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (s *TScrollBox) Instance() uintptr {
    return s._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (s *TScrollBox) UnsafeAddr() unsafe.Pointer {
    return s.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (s *TScrollBox) IsValid() bool {
    return s.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (s *TScrollBox) Is() TIs {
    return TIs(s._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (s *TScrollBox) As() TAs {
//    return TAs(s._instance())
//}

// TScrollBoxClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TScrollBoxClass() TClass {
    return ScrollBox_StaticClassType()
}

func (s *TScrollBox) ScrollInView(AControl IControl) {
    ScrollBox_ScrollInView(s._instance(), CheckPtr(AControl))
}

// CanFocus
//
// 是否可以获得焦点。
func (s *TScrollBox) CanFocus() bool {
    return ScrollBox_CanFocus(s._instance())
}

// ContainsControl
//
// 返回是否包含指定控件。
//
// it's contain a specified control.
func (s *TScrollBox) ContainsControl(Control IControl) bool {
    return ScrollBox_ContainsControl(s._instance(), CheckPtr(Control))
}

// ControlAtPos
//
// 返回指定坐标及相关属性位置控件。
//
// Returns the specified coordinate and the relevant attribute position control..
func (s *TScrollBox) ControlAtPos(Pos TPoint, AllowDisabled bool, AllowWinControls bool, AllLevels bool) *TControl {
    return AsControl(ScrollBox_ControlAtPos(s._instance(), Pos , AllowDisabled , AllowWinControls , AllLevels))
}

// DisableAlign
//
// 禁用控件的对齐。
//
// Disable control alignment.
func (s *TScrollBox) DisableAlign() {
    ScrollBox_DisableAlign(s._instance())
}

// EnableAlign
//
// 启用控件对齐。
//
// Enabled control alignment.
func (s *TScrollBox) EnableAlign() {
    ScrollBox_EnableAlign(s._instance())
}

// FindChildControl
//
// 查找子控件。
//
// Find sub controls.
func (s *TScrollBox) FindChildControl(ControlName string) *TControl {
    return AsControl(ScrollBox_FindChildControl(s._instance(), ControlName))
}

func (s *TScrollBox) FlipChildren(AllLevels bool) {
    ScrollBox_FlipChildren(s._instance(), AllLevels)
}

// Focused
//
// 返回是否获取焦点。
//
// Return to get focus.
func (s *TScrollBox) Focused() bool {
    return ScrollBox_Focused(s._instance())
}

// HandleAllocated
//
// 句柄是否已经分配。
//
// Is the handle already allocated.
func (s *TScrollBox) HandleAllocated() bool {
    return ScrollBox_HandleAllocated(s._instance())
}

// InsertControl
//
// 插入一个控件。
//
// Insert a control.
func (s *TScrollBox) InsertControl(AControl IControl) {
    ScrollBox_InsertControl(s._instance(), CheckPtr(AControl))
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (s *TScrollBox) Invalidate() {
    ScrollBox_Invalidate(s._instance())
}

// PaintTo
//
// 绘画至指定DC。
//
// Painting to the specified DC.
func (s *TScrollBox) PaintTo(DC HDC, X int32, Y int32) {
    ScrollBox_PaintTo(s._instance(), DC , X , Y)
}

// RemoveControl
//
// 移除一个控件。
//
// Remove a control.
func (s *TScrollBox) RemoveControl(AControl IControl) {
    ScrollBox_RemoveControl(s._instance(), CheckPtr(AControl))
}

// Realign
//
// 重新对齐。
//
// Realign.
func (s *TScrollBox) Realign() {
    ScrollBox_Realign(s._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (s *TScrollBox) Repaint() {
    ScrollBox_Repaint(s._instance())
}

// ScaleBy
//
// 按比例缩放。
//
// Scale by.
func (s *TScrollBox) ScaleBy(M int32, D int32) {
    ScrollBox_ScaleBy(s._instance(), M , D)
}

// ScrollBy
//
// 滚动至指定位置。
//
// Scroll by.
func (s *TScrollBox) ScrollBy(DeltaX int32, DeltaY int32) {
    ScrollBox_ScrollBy(s._instance(), DeltaX , DeltaY)
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (s *TScrollBox) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    ScrollBox_SetBounds(s._instance(), ALeft , ATop , AWidth , AHeight)
}

// SetFocus
//
// 设置控件焦点。
//
// Set control focus.
func (s *TScrollBox) SetFocus() {
    ScrollBox_SetFocus(s._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (s *TScrollBox) Update() {
    ScrollBox_Update(s._instance())
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (s *TScrollBox) BringToFront() {
    ScrollBox_BringToFront(s._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (s *TScrollBox) ClientToScreen(Point TPoint) TPoint {
    return ScrollBox_ClientToScreen(s._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (s *TScrollBox) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return ScrollBox_ClientToParent(s._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (s *TScrollBox) Dragging() bool {
    return ScrollBox_Dragging(s._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (s *TScrollBox) HasParent() bool {
    return ScrollBox_HasParent(s._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (s *TScrollBox) Hide() {
    ScrollBox_Hide(s._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (s *TScrollBox) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return ScrollBox_Perform(s._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (s *TScrollBox) Refresh() {
    ScrollBox_Refresh(s._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (s *TScrollBox) ScreenToClient(Point TPoint) TPoint {
    return ScrollBox_ScreenToClient(s._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (s *TScrollBox) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return ScrollBox_ParentToClient(s._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (s *TScrollBox) SendToBack() {
    ScrollBox_SendToBack(s._instance())
}

// Show
//
// 显示控件。
//
// Show control.
func (s *TScrollBox) Show() {
    ScrollBox_Show(s._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (s *TScrollBox) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return ScrollBox_GetTextBuf(s._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (s *TScrollBox) GetTextLen() int32 {
    return ScrollBox_GetTextLen(s._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (s *TScrollBox) SetTextBuf(Buffer string) {
    ScrollBox_SetTextBuf(s._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (s *TScrollBox) FindComponent(AName string) *TComponent {
    return AsComponent(ScrollBox_FindComponent(s._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (s *TScrollBox) GetNamePath() string {
    return ScrollBox_GetNamePath(s._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (s *TScrollBox) Assign(Source IObject) {
    ScrollBox_Assign(s._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (s *TScrollBox) ClassType() TClass {
    return ScrollBox_ClassType(s._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (s *TScrollBox) ClassName() string {
    return ScrollBox_ClassName(s._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (s *TScrollBox) InstanceSize() int32 {
    return ScrollBox_InstanceSize(s._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (s *TScrollBox) InheritsFrom(AClass TClass) bool {
    return ScrollBox_InheritsFrom(s._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (s *TScrollBox) Equals(Obj IObject) bool {
    return ScrollBox_Equals(s._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (s *TScrollBox) GetHashCode() int32 {
    return ScrollBox_GetHashCode(s._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (s *TScrollBox) ToString() string {
    return ScrollBox_ToString(s._instance())
}

func (s *TScrollBox) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    ScrollBox_AnchorToNeighbour(s._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (s *TScrollBox) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    ScrollBox_AnchorParallel(s._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (s *TScrollBox) AnchorHorizontalCenterTo(ASibling IControl) {
    ScrollBox_AnchorHorizontalCenterTo(s._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (s *TScrollBox) AnchorVerticalCenterTo(ASibling IControl) {
    ScrollBox_AnchorVerticalCenterTo(s._instance(), CheckPtr(ASibling))
}

func (s *TScrollBox) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    ScrollBox_AnchorSame(s._instance(), ASide , CheckPtr(ASibling))
}

func (s *TScrollBox) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    ScrollBox_AnchorAsAlign(s._instance(), ATheAlign , ASpace)
}

func (s *TScrollBox) AnchorClient(ASpace int32) {
    ScrollBox_AnchorClient(s._instance(), ASpace)
}

func (s *TScrollBox) ScaleDesignToForm(ASize int32) int32 {
    return ScrollBox_ScaleDesignToForm(s._instance(), ASize)
}

func (s *TScrollBox) ScaleFormToDesign(ASize int32) int32 {
    return ScrollBox_ScaleFormToDesign(s._instance(), ASize)
}

func (s *TScrollBox) Scale96ToForm(ASize int32) int32 {
    return ScrollBox_Scale96ToForm(s._instance(), ASize)
}

func (s *TScrollBox) ScaleFormTo96(ASize int32) int32 {
    return ScrollBox_ScaleFormTo96(s._instance(), ASize)
}

func (s *TScrollBox) Scale96ToFont(ASize int32) int32 {
    return ScrollBox_Scale96ToFont(s._instance(), ASize)
}

func (s *TScrollBox) ScaleFontTo96(ASize int32) int32 {
    return ScrollBox_ScaleFontTo96(s._instance(), ASize)
}

func (s *TScrollBox) ScaleScreenToFont(ASize int32) int32 {
    return ScrollBox_ScaleScreenToFont(s._instance(), ASize)
}

func (s *TScrollBox) ScaleFontToScreen(ASize int32) int32 {
    return ScrollBox_ScaleFontToScreen(s._instance(), ASize)
}

func (s *TScrollBox) Scale96ToScreen(ASize int32) int32 {
    return ScrollBox_Scale96ToScreen(s._instance(), ASize)
}

func (s *TScrollBox) ScaleScreenTo96(ASize int32) int32 {
    return ScrollBox_ScaleScreenTo96(s._instance(), ASize)
}

func (s *TScrollBox) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    ScrollBox_AutoAdjustLayout(s._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (s *TScrollBox) FixDesignFontsPPI(ADesignTimePPI int32) {
    ScrollBox_FixDesignFontsPPI(s._instance(), ADesignTimePPI)
}

func (s *TScrollBox) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    ScrollBox_ScaleFontsPPI(s._instance(), AToPPI , AProportion)
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (s *TScrollBox) Align() TAlign {
    return ScrollBox_GetAlign(s._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (s *TScrollBox) SetAlign(value TAlign) {
    ScrollBox_SetAlign(s._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (s *TScrollBox) Anchors() TAnchors {
    return ScrollBox_GetAnchors(s._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (s *TScrollBox) SetAnchors(value TAnchors) {
    ScrollBox_SetAnchors(s._instance(), value)
}

func (s *TScrollBox) AutoScroll() bool {
    return ScrollBox_GetAutoScroll(s._instance())
}

func (s *TScrollBox) SetAutoScroll(value bool) {
    ScrollBox_SetAutoScroll(s._instance(), value)
}

// AutoSize
//
// 获取自动调整大小。
func (s *TScrollBox) AutoSize() bool {
    return ScrollBox_GetAutoSize(s._instance())
}

// SetAutoSize
//
// 设置自动调整大小。
func (s *TScrollBox) SetAutoSize(value bool) {
    ScrollBox_SetAutoSize(s._instance(), value)
}

func (s *TScrollBox) BiDiMode() TBiDiMode {
    return ScrollBox_GetBiDiMode(s._instance())
}

func (s *TScrollBox) SetBiDiMode(value TBiDiMode) {
    ScrollBox_SetBiDiMode(s._instance(), value)
}

// BorderStyle
//
// 获取窗口边框样式。比如：无边框，单一边框等。
func (s *TScrollBox) BorderStyle() TBorderStyle {
    return ScrollBox_GetBorderStyle(s._instance())
}

// SetBorderStyle
//
// 设置窗口边框样式。比如：无边框，单一边框等。
func (s *TScrollBox) SetBorderStyle(value TBorderStyle) {
    ScrollBox_SetBorderStyle(s._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (s *TScrollBox) Constraints() *TSizeConstraints {
    return AsSizeConstraints(ScrollBox_GetConstraints(s._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (s *TScrollBox) SetConstraints(value *TSizeConstraints) {
    ScrollBox_SetConstraints(s._instance(), CheckPtr(value))
}

// DockSite
//
// 获取停靠站点。
//
// Get Docking site.
func (s *TScrollBox) DockSite() bool {
    return ScrollBox_GetDockSite(s._instance())
}

// SetDockSite
//
// 设置停靠站点。
//
// Set Docking site.
func (s *TScrollBox) SetDockSite(value bool) {
    ScrollBox_SetDockSite(s._instance(), value)
}

// DoubleBuffered
//
// 获取设置控件双缓冲。
//
// Get Set control double buffering.
func (s *TScrollBox) DoubleBuffered() bool {
    return ScrollBox_GetDoubleBuffered(s._instance())
}

// SetDoubleBuffered
//
// 设置设置控件双缓冲。
//
// Set Set control double buffering.
func (s *TScrollBox) SetDoubleBuffered(value bool) {
    ScrollBox_SetDoubleBuffered(s._instance(), value)
}

// DragCursor
//
// 获取设置控件拖拽时的光标。
//
// Get Set the cursor when the control is dragged.
func (s *TScrollBox) DragCursor() TCursor {
    return ScrollBox_GetDragCursor(s._instance())
}

// SetDragCursor
//
// 设置设置控件拖拽时的光标。
//
// Set Set the cursor when the control is dragged.
func (s *TScrollBox) SetDragCursor(value TCursor) {
    ScrollBox_SetDragCursor(s._instance(), value)
}

// DragKind
//
// 获取拖拽方式。
//
// Get Drag and drop.
func (s *TScrollBox) DragKind() TDragKind {
    return ScrollBox_GetDragKind(s._instance())
}

// SetDragKind
//
// 设置拖拽方式。
//
// Set Drag and drop.
func (s *TScrollBox) SetDragKind(value TDragKind) {
    ScrollBox_SetDragKind(s._instance(), value)
}

// DragMode
//
// 获取拖拽模式。
//
// Get Drag mode.
func (s *TScrollBox) DragMode() TDragMode {
    return ScrollBox_GetDragMode(s._instance())
}

// SetDragMode
//
// 设置拖拽模式。
//
// Set Drag mode.
func (s *TScrollBox) SetDragMode(value TDragMode) {
    ScrollBox_SetDragMode(s._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (s *TScrollBox) Enabled() bool {
    return ScrollBox_GetEnabled(s._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (s *TScrollBox) SetEnabled(value bool) {
    ScrollBox_SetEnabled(s._instance(), value)
}

// Color
//
// 获取颜色。
//
// Get color.
func (s *TScrollBox) Color() TColor {
    return ScrollBox_GetColor(s._instance())
}

// SetColor
//
// 设置颜色。
//
// Set color.
func (s *TScrollBox) SetColor(value TColor) {
    ScrollBox_SetColor(s._instance(), value)
}

// Font
//
// 获取字体。
//
// Get Font.
func (s *TScrollBox) Font() *TFont {
    return AsFont(ScrollBox_GetFont(s._instance()))
}

// SetFont
//
// 设置字体。
//
// Set Font.
func (s *TScrollBox) SetFont(value *TFont) {
    ScrollBox_SetFont(s._instance(), CheckPtr(value))
}

func (s *TScrollBox) ParentBackground() bool {
    return ScrollBox_GetParentBackground(s._instance())
}

func (s *TScrollBox) SetParentBackground(value bool) {
    ScrollBox_SetParentBackground(s._instance(), value)
}

// ParentColor
//
// 获取使用父容器颜色。
//
// Get parent color.
func (s *TScrollBox) ParentColor() bool {
    return ScrollBox_GetParentColor(s._instance())
}

// SetParentColor
//
// 设置使用父容器颜色。
//
// Set parent color.
func (s *TScrollBox) SetParentColor(value bool) {
    ScrollBox_SetParentColor(s._instance(), value)
}

// ParentDoubleBuffered
//
// 获取使用父容器双缓冲。
//
// Get Parent container double buffering.
func (s *TScrollBox) ParentDoubleBuffered() bool {
    return ScrollBox_GetParentDoubleBuffered(s._instance())
}

// SetParentDoubleBuffered
//
// 设置使用父容器双缓冲。
//
// Set Parent container double buffering.
func (s *TScrollBox) SetParentDoubleBuffered(value bool) {
    ScrollBox_SetParentDoubleBuffered(s._instance(), value)
}

// ParentFont
//
// 获取使用父容器字体。
//
// Get Parent container font.
func (s *TScrollBox) ParentFont() bool {
    return ScrollBox_GetParentFont(s._instance())
}

// SetParentFont
//
// 设置使用父容器字体。
//
// Set Parent container font.
func (s *TScrollBox) SetParentFont(value bool) {
    ScrollBox_SetParentFont(s._instance(), value)
}

// ParentShowHint
//
// 获取以父容器的ShowHint属性为准。
func (s *TScrollBox) ParentShowHint() bool {
    return ScrollBox_GetParentShowHint(s._instance())
}

// SetParentShowHint
//
// 设置以父容器的ShowHint属性为准。
func (s *TScrollBox) SetParentShowHint(value bool) {
    ScrollBox_SetParentShowHint(s._instance(), value)
}

// PopupMenu
//
// 获取右键菜单。
//
// Get Right click menu.
func (s *TScrollBox) PopupMenu() *TPopupMenu {
    return AsPopupMenu(ScrollBox_GetPopupMenu(s._instance()))
}

// SetPopupMenu
//
// 设置右键菜单。
//
// Set Right click menu.
func (s *TScrollBox) SetPopupMenu(value IComponent) {
    ScrollBox_SetPopupMenu(s._instance(), CheckPtr(value))
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (s *TScrollBox) ShowHint() bool {
    return ScrollBox_GetShowHint(s._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (s *TScrollBox) SetShowHint(value bool) {
    ScrollBox_SetShowHint(s._instance(), value)
}

// TabOrder
//
// 获取Tab切换顺序序号。
//
// Get Tab switching sequence number.
func (s *TScrollBox) TabOrder() TTabOrder {
    return ScrollBox_GetTabOrder(s._instance())
}

// SetTabOrder
//
// 设置Tab切换顺序序号。
//
// Set Tab switching sequence number.
func (s *TScrollBox) SetTabOrder(value TTabOrder) {
    ScrollBox_SetTabOrder(s._instance(), value)
}

// TabStop
//
// 获取Tab可停留。
//
// Get Tab can stay.
func (s *TScrollBox) TabStop() bool {
    return ScrollBox_GetTabStop(s._instance())
}

// SetTabStop
//
// 设置Tab可停留。
//
// Set Tab can stay.
func (s *TScrollBox) SetTabStop(value bool) {
    ScrollBox_SetTabStop(s._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (s *TScrollBox) Visible() bool {
    return ScrollBox_GetVisible(s._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (s *TScrollBox) SetVisible(value bool) {
    ScrollBox_SetVisible(s._instance(), value)
}

// SetOnClick
//
// 设置控件单击事件。
//
// Set control click event.
func (s *TScrollBox) SetOnClick(fn TNotifyEvent) {
    ScrollBox_SetOnClick(s._instance(), fn)
}

func (s *TScrollBox) SetOnConstrainedResize(fn TConstrainedResizeEvent) {
    ScrollBox_SetOnConstrainedResize(s._instance(), fn)
}

// SetOnDblClick
//
// 设置双击事件。
func (s *TScrollBox) SetOnDblClick(fn TNotifyEvent) {
    ScrollBox_SetOnDblClick(s._instance(), fn)
}

func (s *TScrollBox) SetOnDockDrop(fn TDockDropEvent) {
    ScrollBox_SetOnDockDrop(s._instance(), fn)
}

// SetOnDragDrop
//
// 设置拖拽下落事件。
//
// Set Drag and drop event.
func (s *TScrollBox) SetOnDragDrop(fn TDragDropEvent) {
    ScrollBox_SetOnDragDrop(s._instance(), fn)
}

// SetOnDragOver
//
// 设置拖拽完成事件。
//
// Set Drag and drop completion event.
func (s *TScrollBox) SetOnDragOver(fn TDragOverEvent) {
    ScrollBox_SetOnDragOver(s._instance(), fn)
}

// SetOnEndDrag
//
// 设置拖拽结束。
//
// Set End of drag.
func (s *TScrollBox) SetOnEndDrag(fn TEndDragEvent) {
    ScrollBox_SetOnEndDrag(s._instance(), fn)
}

// SetOnEnter
//
// 设置焦点进入。
//
// Set Focus entry.
func (s *TScrollBox) SetOnEnter(fn TNotifyEvent) {
    ScrollBox_SetOnEnter(s._instance(), fn)
}

// SetOnExit
//
// 设置焦点退出。
//
// Set Focus exit.
func (s *TScrollBox) SetOnExit(fn TNotifyEvent) {
    ScrollBox_SetOnExit(s._instance(), fn)
}

func (s *TScrollBox) SetOnGetSiteInfo(fn TGetSiteInfoEvent) {
    ScrollBox_SetOnGetSiteInfo(s._instance(), fn)
}

// SetOnMouseDown
//
// 设置鼠标按下事件。
//
// Set Mouse down event.
func (s *TScrollBox) SetOnMouseDown(fn TMouseEvent) {
    ScrollBox_SetOnMouseDown(s._instance(), fn)
}

// SetOnMouseEnter
//
// 设置鼠标进入事件。
//
// Set Mouse entry event.
func (s *TScrollBox) SetOnMouseEnter(fn TNotifyEvent) {
    ScrollBox_SetOnMouseEnter(s._instance(), fn)
}

// SetOnMouseLeave
//
// 设置鼠标离开事件。
//
// Set Mouse leave event.
func (s *TScrollBox) SetOnMouseLeave(fn TNotifyEvent) {
    ScrollBox_SetOnMouseLeave(s._instance(), fn)
}

// SetOnMouseMove
//
// 设置鼠标移动事件。
func (s *TScrollBox) SetOnMouseMove(fn TMouseMoveEvent) {
    ScrollBox_SetOnMouseMove(s._instance(), fn)
}

// SetOnMouseUp
//
// 设置鼠标抬起事件。
//
// Set Mouse lift event.
func (s *TScrollBox) SetOnMouseUp(fn TMouseEvent) {
    ScrollBox_SetOnMouseUp(s._instance(), fn)
}

// SetOnMouseWheel
//
// 设置鼠标滚轮事件。
func (s *TScrollBox) SetOnMouseWheel(fn TMouseWheelEvent) {
    ScrollBox_SetOnMouseWheel(s._instance(), fn)
}

// SetOnMouseWheelDown
//
// 设置鼠标滚轮按下事件。
func (s *TScrollBox) SetOnMouseWheelDown(fn TMouseWheelUpDownEvent) {
    ScrollBox_SetOnMouseWheelDown(s._instance(), fn)
}

// SetOnMouseWheelUp
//
// 设置鼠标滚轮抬起事件。
func (s *TScrollBox) SetOnMouseWheelUp(fn TMouseWheelUpDownEvent) {
    ScrollBox_SetOnMouseWheelUp(s._instance(), fn)
}

// SetOnResize
//
// 设置大小被改变事件。
func (s *TScrollBox) SetOnResize(fn TNotifyEvent) {
    ScrollBox_SetOnResize(s._instance(), fn)
}

func (s *TScrollBox) SetOnUnDock(fn TUnDockEvent) {
    ScrollBox_SetOnUnDock(s._instance(), fn)
}

// SetOnAlignPosition
//
// 设置对齐位置事件，当Align为alCustom时Parent会收到这个消息。
func (s *TScrollBox) SetOnAlignPosition(fn TAlignPositionEvent) {
    ScrollBox_SetOnAlignPosition(s._instance(), fn)
}

func (s *TScrollBox) HorzScrollBar() *TControlScrollBar {
    return AsControlScrollBar(ScrollBox_GetHorzScrollBar(s._instance()))
}

func (s *TScrollBox) SetHorzScrollBar(value *TControlScrollBar) {
    ScrollBox_SetHorzScrollBar(s._instance(), CheckPtr(value))
}

func (s *TScrollBox) VertScrollBar() *TControlScrollBar {
    return AsControlScrollBar(ScrollBox_GetVertScrollBar(s._instance()))
}

func (s *TScrollBox) SetVertScrollBar(value *TControlScrollBar) {
    ScrollBox_SetVertScrollBar(s._instance(), CheckPtr(value))
}

// DockClientCount
//
// 获取依靠客户端总数。
func (s *TScrollBox) DockClientCount() int32 {
    return ScrollBox_GetDockClientCount(s._instance())
}

// MouseInClient
//
// 获取鼠标是否在客户端，仅VCL有效。
//
// Get Whether the mouse is on the client, only VCL is valid.
func (s *TScrollBox) MouseInClient() bool {
    return ScrollBox_GetMouseInClient(s._instance())
}

// VisibleDockClientCount
//
// 获取当前停靠的可视总数。
//
// Get The total number of visible calls currently docked.
func (s *TScrollBox) VisibleDockClientCount() int32 {
    return ScrollBox_GetVisibleDockClientCount(s._instance())
}

// Brush
//
// 获取画刷对象。
//
// Get Brush.
func (s *TScrollBox) Brush() *TBrush {
    return AsBrush(ScrollBox_GetBrush(s._instance()))
}

// ControlCount
//
// 获取子控件数。
//
// Get Number of child controls.
func (s *TScrollBox) ControlCount() int32 {
    return ScrollBox_GetControlCount(s._instance())
}

// Handle
//
// 获取控件句柄。
//
// Get Control handle.
func (s *TScrollBox) Handle() HWND {
    return ScrollBox_GetHandle(s._instance())
}

// ParentWindow
//
// 获取父容器句柄。
//
// Get Parent container handle.
func (s *TScrollBox) ParentWindow() HWND {
    return ScrollBox_GetParentWindow(s._instance())
}

// SetParentWindow
//
// 设置父容器句柄。
//
// Set Parent container handle.
func (s *TScrollBox) SetParentWindow(value HWND) {
    ScrollBox_SetParentWindow(s._instance(), value)
}

func (s *TScrollBox) Showing() bool {
    return ScrollBox_GetShowing(s._instance())
}

// UseDockManager
//
// 获取使用停靠管理。
func (s *TScrollBox) UseDockManager() bool {
    return ScrollBox_GetUseDockManager(s._instance())
}

// SetUseDockManager
//
// 设置使用停靠管理。
func (s *TScrollBox) SetUseDockManager(value bool) {
    ScrollBox_SetUseDockManager(s._instance(), value)
}

func (s *TScrollBox) Action() *TAction {
    return AsAction(ScrollBox_GetAction(s._instance()))
}

func (s *TScrollBox) SetAction(value IComponent) {
    ScrollBox_SetAction(s._instance(), CheckPtr(value))
}

func (s *TScrollBox) BoundsRect() TRect {
    return ScrollBox_GetBoundsRect(s._instance())
}

func (s *TScrollBox) SetBoundsRect(value TRect) {
    ScrollBox_SetBoundsRect(s._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (s *TScrollBox) ClientHeight() int32 {
    return ScrollBox_GetClientHeight(s._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (s *TScrollBox) SetClientHeight(value int32) {
    ScrollBox_SetClientHeight(s._instance(), value)
}

func (s *TScrollBox) ClientOrigin() TPoint {
    return ScrollBox_GetClientOrigin(s._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (s *TScrollBox) ClientRect() TRect {
    return ScrollBox_GetClientRect(s._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (s *TScrollBox) ClientWidth() int32 {
    return ScrollBox_GetClientWidth(s._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (s *TScrollBox) SetClientWidth(value int32) {
    ScrollBox_SetClientWidth(s._instance(), value)
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (s *TScrollBox) ControlState() TControlState {
    return ScrollBox_GetControlState(s._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (s *TScrollBox) SetControlState(value TControlState) {
    ScrollBox_SetControlState(s._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (s *TScrollBox) ControlStyle() TControlStyle {
    return ScrollBox_GetControlStyle(s._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (s *TScrollBox) SetControlStyle(value TControlStyle) {
    ScrollBox_SetControlStyle(s._instance(), value)
}

func (s *TScrollBox) Floating() bool {
    return ScrollBox_GetFloating(s._instance())
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (s *TScrollBox) Parent() *TWinControl {
    return AsWinControl(ScrollBox_GetParent(s._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (s *TScrollBox) SetParent(value IWinControl) {
    ScrollBox_SetParent(s._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (s *TScrollBox) Left() int32 {
    return ScrollBox_GetLeft(s._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (s *TScrollBox) SetLeft(value int32) {
    ScrollBox_SetLeft(s._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (s *TScrollBox) Top() int32 {
    return ScrollBox_GetTop(s._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (s *TScrollBox) SetTop(value int32) {
    ScrollBox_SetTop(s._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (s *TScrollBox) Width() int32 {
    return ScrollBox_GetWidth(s._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (s *TScrollBox) SetWidth(value int32) {
    ScrollBox_SetWidth(s._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (s *TScrollBox) Height() int32 {
    return ScrollBox_GetHeight(s._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (s *TScrollBox) SetHeight(value int32) {
    ScrollBox_SetHeight(s._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (s *TScrollBox) Cursor() TCursor {
    return ScrollBox_GetCursor(s._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (s *TScrollBox) SetCursor(value TCursor) {
    ScrollBox_SetCursor(s._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (s *TScrollBox) Hint() string {
    return ScrollBox_GetHint(s._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (s *TScrollBox) SetHint(value string) {
    ScrollBox_SetHint(s._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (s *TScrollBox) ComponentCount() int32 {
    return ScrollBox_GetComponentCount(s._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (s *TScrollBox) ComponentIndex() int32 {
    return ScrollBox_GetComponentIndex(s._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (s *TScrollBox) SetComponentIndex(value int32) {
    ScrollBox_SetComponentIndex(s._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (s *TScrollBox) Owner() *TComponent {
    return AsComponent(ScrollBox_GetOwner(s._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (s *TScrollBox) Name() string {
    return ScrollBox_GetName(s._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (s *TScrollBox) SetName(value string) {
    ScrollBox_SetName(s._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (s *TScrollBox) Tag() int {
    return ScrollBox_GetTag(s._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (s *TScrollBox) SetTag(value int) {
    ScrollBox_SetTag(s._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (s *TScrollBox) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(ScrollBox_GetAnchorSideLeft(s._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (s *TScrollBox) SetAnchorSideLeft(value *TAnchorSide) {
    ScrollBox_SetAnchorSideLeft(s._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (s *TScrollBox) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(ScrollBox_GetAnchorSideTop(s._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (s *TScrollBox) SetAnchorSideTop(value *TAnchorSide) {
    ScrollBox_SetAnchorSideTop(s._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (s *TScrollBox) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(ScrollBox_GetAnchorSideRight(s._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (s *TScrollBox) SetAnchorSideRight(value *TAnchorSide) {
    ScrollBox_SetAnchorSideRight(s._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (s *TScrollBox) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(ScrollBox_GetAnchorSideBottom(s._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (s *TScrollBox) SetAnchorSideBottom(value *TAnchorSide) {
    ScrollBox_SetAnchorSideBottom(s._instance(), CheckPtr(value))
}

func (s *TScrollBox) ChildSizing() *TControlChildSizing {
    return AsControlChildSizing(ScrollBox_GetChildSizing(s._instance()))
}

func (s *TScrollBox) SetChildSizing(value *TControlChildSizing) {
    ScrollBox_SetChildSizing(s._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (s *TScrollBox) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(ScrollBox_GetBorderSpacing(s._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (s *TScrollBox) SetBorderSpacing(value *TControlBorderSpacing) {
    ScrollBox_SetBorderSpacing(s._instance(), CheckPtr(value))
}

// DockClients
//
// 获取指定索引停靠客户端。
func (s *TScrollBox) DockClients(Index int32) *TControl {
    return AsControl(ScrollBox_GetDockClients(s._instance(), Index))
}

// Controls
//
// 获取指定索引子控件。
func (s *TScrollBox) Controls(Index int32) *TControl {
    return AsControl(ScrollBox_GetControls(s._instance(), Index))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (s *TScrollBox) Components(AIndex int32) *TComponent {
    return AsComponent(ScrollBox_GetComponents(s._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (s *TScrollBox) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(ScrollBox_GetAnchorSide(s._instance(), AKind))
}

