
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TScrollBar struct {
    IWinControl
    instance unsafe.Pointer
}

// NewScrollBar
//
// 创建一个新的对象。
// 
// Create a new object.
func NewScrollBar(owner IComponent) *TScrollBar {
    s := new(TScrollBar)
    s.instance = unsafe.Pointer(ScrollBar_Create(CheckPtr(owner)))
    return s
}

// AsScrollBar
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsScrollBar(obj interface{}) *TScrollBar {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TScrollBar{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (s *TScrollBar) Free() {
    if s.instance != nullptr {
        ScrollBar_Free(s._instance())
        s.instance  = nullptr
    }
}

func (s *TScrollBar) _instance() uintptr {
    return uintptr(s.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (s *TScrollBar) Instance() uintptr {
    return s._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (s *TScrollBar) UnsafeAddr() unsafe.Pointer {
    return s.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (s *TScrollBar) IsValid() bool {
    return s.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (s *TScrollBar) Is() TIs {
    return TIs(s._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (s *TScrollBar) As() TAs {
//    return TAs(s._instance())
//}

// TScrollBarClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TScrollBarClass() TClass {
    return ScrollBar_StaticClassType()
}

func (s *TScrollBar) SetParams(APosition int32, AMin int32, AMax int32) {
    ScrollBar_SetParams(s._instance(), APosition , AMin , AMax)
}

// CanFocus
//
// 是否可以获得焦点。
func (s *TScrollBar) CanFocus() bool {
    return ScrollBar_CanFocus(s._instance())
}

// ContainsControl
//
// 返回是否包含指定控件。
//
// it's contain a specified control.
func (s *TScrollBar) ContainsControl(Control IControl) bool {
    return ScrollBar_ContainsControl(s._instance(), CheckPtr(Control))
}

// ControlAtPos
//
// 返回指定坐标及相关属性位置控件。
//
// Returns the specified coordinate and the relevant attribute position control..
func (s *TScrollBar) ControlAtPos(Pos TPoint, AllowDisabled bool, AllowWinControls bool, AllLevels bool) *TControl {
    return AsControl(ScrollBar_ControlAtPos(s._instance(), Pos , AllowDisabled , AllowWinControls , AllLevels))
}

// DisableAlign
//
// 禁用控件的对齐。
//
// Disable control alignment.
func (s *TScrollBar) DisableAlign() {
    ScrollBar_DisableAlign(s._instance())
}

// EnableAlign
//
// 启用控件对齐。
//
// Enabled control alignment.
func (s *TScrollBar) EnableAlign() {
    ScrollBar_EnableAlign(s._instance())
}

// FindChildControl
//
// 查找子控件。
//
// Find sub controls.
func (s *TScrollBar) FindChildControl(ControlName string) *TControl {
    return AsControl(ScrollBar_FindChildControl(s._instance(), ControlName))
}

func (s *TScrollBar) FlipChildren(AllLevels bool) {
    ScrollBar_FlipChildren(s._instance(), AllLevels)
}

// Focused
//
// 返回是否获取焦点。
//
// Return to get focus.
func (s *TScrollBar) Focused() bool {
    return ScrollBar_Focused(s._instance())
}

// HandleAllocated
//
// 句柄是否已经分配。
//
// Is the handle already allocated.
func (s *TScrollBar) HandleAllocated() bool {
    return ScrollBar_HandleAllocated(s._instance())
}

// InsertControl
//
// 插入一个控件。
//
// Insert a control.
func (s *TScrollBar) InsertControl(AControl IControl) {
    ScrollBar_InsertControl(s._instance(), CheckPtr(AControl))
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (s *TScrollBar) Invalidate() {
    ScrollBar_Invalidate(s._instance())
}

// PaintTo
//
// 绘画至指定DC。
//
// Painting to the specified DC.
func (s *TScrollBar) PaintTo(DC HDC, X int32, Y int32) {
    ScrollBar_PaintTo(s._instance(), DC , X , Y)
}

// RemoveControl
//
// 移除一个控件。
//
// Remove a control.
func (s *TScrollBar) RemoveControl(AControl IControl) {
    ScrollBar_RemoveControl(s._instance(), CheckPtr(AControl))
}

// Realign
//
// 重新对齐。
//
// Realign.
func (s *TScrollBar) Realign() {
    ScrollBar_Realign(s._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (s *TScrollBar) Repaint() {
    ScrollBar_Repaint(s._instance())
}

// ScaleBy
//
// 按比例缩放。
//
// Scale by.
func (s *TScrollBar) ScaleBy(M int32, D int32) {
    ScrollBar_ScaleBy(s._instance(), M , D)
}

// ScrollBy
//
// 滚动至指定位置。
//
// Scroll by.
func (s *TScrollBar) ScrollBy(DeltaX int32, DeltaY int32) {
    ScrollBar_ScrollBy(s._instance(), DeltaX , DeltaY)
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (s *TScrollBar) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    ScrollBar_SetBounds(s._instance(), ALeft , ATop , AWidth , AHeight)
}

// SetFocus
//
// 设置控件焦点。
//
// Set control focus.
func (s *TScrollBar) SetFocus() {
    ScrollBar_SetFocus(s._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (s *TScrollBar) Update() {
    ScrollBar_Update(s._instance())
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (s *TScrollBar) BringToFront() {
    ScrollBar_BringToFront(s._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (s *TScrollBar) ClientToScreen(Point TPoint) TPoint {
    return ScrollBar_ClientToScreen(s._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (s *TScrollBar) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return ScrollBar_ClientToParent(s._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (s *TScrollBar) Dragging() bool {
    return ScrollBar_Dragging(s._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (s *TScrollBar) HasParent() bool {
    return ScrollBar_HasParent(s._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (s *TScrollBar) Hide() {
    ScrollBar_Hide(s._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (s *TScrollBar) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return ScrollBar_Perform(s._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (s *TScrollBar) Refresh() {
    ScrollBar_Refresh(s._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (s *TScrollBar) ScreenToClient(Point TPoint) TPoint {
    return ScrollBar_ScreenToClient(s._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (s *TScrollBar) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return ScrollBar_ParentToClient(s._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (s *TScrollBar) SendToBack() {
    ScrollBar_SendToBack(s._instance())
}

// Show
//
// 显示控件。
//
// Show control.
func (s *TScrollBar) Show() {
    ScrollBar_Show(s._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (s *TScrollBar) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return ScrollBar_GetTextBuf(s._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (s *TScrollBar) GetTextLen() int32 {
    return ScrollBar_GetTextLen(s._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (s *TScrollBar) SetTextBuf(Buffer string) {
    ScrollBar_SetTextBuf(s._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (s *TScrollBar) FindComponent(AName string) *TComponent {
    return AsComponent(ScrollBar_FindComponent(s._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (s *TScrollBar) GetNamePath() string {
    return ScrollBar_GetNamePath(s._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (s *TScrollBar) Assign(Source IObject) {
    ScrollBar_Assign(s._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (s *TScrollBar) ClassType() TClass {
    return ScrollBar_ClassType(s._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (s *TScrollBar) ClassName() string {
    return ScrollBar_ClassName(s._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (s *TScrollBar) InstanceSize() int32 {
    return ScrollBar_InstanceSize(s._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (s *TScrollBar) InheritsFrom(AClass TClass) bool {
    return ScrollBar_InheritsFrom(s._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (s *TScrollBar) Equals(Obj IObject) bool {
    return ScrollBar_Equals(s._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (s *TScrollBar) GetHashCode() int32 {
    return ScrollBar_GetHashCode(s._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (s *TScrollBar) ToString() string {
    return ScrollBar_ToString(s._instance())
}

func (s *TScrollBar) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    ScrollBar_AnchorToNeighbour(s._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (s *TScrollBar) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    ScrollBar_AnchorParallel(s._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (s *TScrollBar) AnchorHorizontalCenterTo(ASibling IControl) {
    ScrollBar_AnchorHorizontalCenterTo(s._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (s *TScrollBar) AnchorVerticalCenterTo(ASibling IControl) {
    ScrollBar_AnchorVerticalCenterTo(s._instance(), CheckPtr(ASibling))
}

func (s *TScrollBar) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    ScrollBar_AnchorSame(s._instance(), ASide , CheckPtr(ASibling))
}

func (s *TScrollBar) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    ScrollBar_AnchorAsAlign(s._instance(), ATheAlign , ASpace)
}

func (s *TScrollBar) AnchorClient(ASpace int32) {
    ScrollBar_AnchorClient(s._instance(), ASpace)
}

func (s *TScrollBar) ScaleDesignToForm(ASize int32) int32 {
    return ScrollBar_ScaleDesignToForm(s._instance(), ASize)
}

func (s *TScrollBar) ScaleFormToDesign(ASize int32) int32 {
    return ScrollBar_ScaleFormToDesign(s._instance(), ASize)
}

func (s *TScrollBar) Scale96ToForm(ASize int32) int32 {
    return ScrollBar_Scale96ToForm(s._instance(), ASize)
}

func (s *TScrollBar) ScaleFormTo96(ASize int32) int32 {
    return ScrollBar_ScaleFormTo96(s._instance(), ASize)
}

func (s *TScrollBar) Scale96ToFont(ASize int32) int32 {
    return ScrollBar_Scale96ToFont(s._instance(), ASize)
}

func (s *TScrollBar) ScaleFontTo96(ASize int32) int32 {
    return ScrollBar_ScaleFontTo96(s._instance(), ASize)
}

func (s *TScrollBar) ScaleScreenToFont(ASize int32) int32 {
    return ScrollBar_ScaleScreenToFont(s._instance(), ASize)
}

func (s *TScrollBar) ScaleFontToScreen(ASize int32) int32 {
    return ScrollBar_ScaleFontToScreen(s._instance(), ASize)
}

func (s *TScrollBar) Scale96ToScreen(ASize int32) int32 {
    return ScrollBar_Scale96ToScreen(s._instance(), ASize)
}

func (s *TScrollBar) ScaleScreenTo96(ASize int32) int32 {
    return ScrollBar_ScaleScreenTo96(s._instance(), ASize)
}

func (s *TScrollBar) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    ScrollBar_AutoAdjustLayout(s._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (s *TScrollBar) FixDesignFontsPPI(ADesignTimePPI int32) {
    ScrollBar_FixDesignFontsPPI(s._instance(), ADesignTimePPI)
}

func (s *TScrollBar) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    ScrollBar_ScaleFontsPPI(s._instance(), AToPPI , AProportion)
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (s *TScrollBar) Align() TAlign {
    return ScrollBar_GetAlign(s._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (s *TScrollBar) SetAlign(value TAlign) {
    ScrollBar_SetAlign(s._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (s *TScrollBar) Anchors() TAnchors {
    return ScrollBar_GetAnchors(s._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (s *TScrollBar) SetAnchors(value TAnchors) {
    ScrollBar_SetAnchors(s._instance(), value)
}

func (s *TScrollBar) BiDiMode() TBiDiMode {
    return ScrollBar_GetBiDiMode(s._instance())
}

func (s *TScrollBar) SetBiDiMode(value TBiDiMode) {
    ScrollBar_SetBiDiMode(s._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (s *TScrollBar) Constraints() *TSizeConstraints {
    return AsSizeConstraints(ScrollBar_GetConstraints(s._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (s *TScrollBar) SetConstraints(value *TSizeConstraints) {
    ScrollBar_SetConstraints(s._instance(), CheckPtr(value))
}

// DoubleBuffered
//
// 获取设置控件双缓冲。
//
// Get Set control double buffering.
func (s *TScrollBar) DoubleBuffered() bool {
    return ScrollBar_GetDoubleBuffered(s._instance())
}

// SetDoubleBuffered
//
// 设置设置控件双缓冲。
//
// Set Set control double buffering.
func (s *TScrollBar) SetDoubleBuffered(value bool) {
    ScrollBar_SetDoubleBuffered(s._instance(), value)
}

// DragCursor
//
// 获取设置控件拖拽时的光标。
//
// Get Set the cursor when the control is dragged.
func (s *TScrollBar) DragCursor() TCursor {
    return ScrollBar_GetDragCursor(s._instance())
}

// SetDragCursor
//
// 设置设置控件拖拽时的光标。
//
// Set Set the cursor when the control is dragged.
func (s *TScrollBar) SetDragCursor(value TCursor) {
    ScrollBar_SetDragCursor(s._instance(), value)
}

// DragKind
//
// 获取拖拽方式。
//
// Get Drag and drop.
func (s *TScrollBar) DragKind() TDragKind {
    return ScrollBar_GetDragKind(s._instance())
}

// SetDragKind
//
// 设置拖拽方式。
//
// Set Drag and drop.
func (s *TScrollBar) SetDragKind(value TDragKind) {
    ScrollBar_SetDragKind(s._instance(), value)
}

// DragMode
//
// 获取拖拽模式。
//
// Get Drag mode.
func (s *TScrollBar) DragMode() TDragMode {
    return ScrollBar_GetDragMode(s._instance())
}

// SetDragMode
//
// 设置拖拽模式。
//
// Set Drag mode.
func (s *TScrollBar) SetDragMode(value TDragMode) {
    ScrollBar_SetDragMode(s._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (s *TScrollBar) Enabled() bool {
    return ScrollBar_GetEnabled(s._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (s *TScrollBar) SetEnabled(value bool) {
    ScrollBar_SetEnabled(s._instance(), value)
}

func (s *TScrollBar) Kind() TScrollBarKind {
    return ScrollBar_GetKind(s._instance())
}

func (s *TScrollBar) SetKind(value TScrollBarKind) {
    ScrollBar_SetKind(s._instance(), value)
}

func (s *TScrollBar) LargeChange() TScrollBarInc {
    return ScrollBar_GetLargeChange(s._instance())
}

func (s *TScrollBar) SetLargeChange(value TScrollBarInc) {
    ScrollBar_SetLargeChange(s._instance(), value)
}

func (s *TScrollBar) Max() int32 {
    return ScrollBar_GetMax(s._instance())
}

func (s *TScrollBar) SetMax(value int32) {
    ScrollBar_SetMax(s._instance(), value)
}

func (s *TScrollBar) Min() int32 {
    return ScrollBar_GetMin(s._instance())
}

func (s *TScrollBar) SetMin(value int32) {
    ScrollBar_SetMin(s._instance(), value)
}

func (s *TScrollBar) PageSize() int32 {
    return ScrollBar_GetPageSize(s._instance())
}

func (s *TScrollBar) SetPageSize(value int32) {
    ScrollBar_SetPageSize(s._instance(), value)
}

// ParentDoubleBuffered
//
// 获取使用父容器双缓冲。
//
// Get Parent container double buffering.
func (s *TScrollBar) ParentDoubleBuffered() bool {
    return ScrollBar_GetParentDoubleBuffered(s._instance())
}

// SetParentDoubleBuffered
//
// 设置使用父容器双缓冲。
//
// Set Parent container double buffering.
func (s *TScrollBar) SetParentDoubleBuffered(value bool) {
    ScrollBar_SetParentDoubleBuffered(s._instance(), value)
}

// ParentShowHint
//
// 获取以父容器的ShowHint属性为准。
func (s *TScrollBar) ParentShowHint() bool {
    return ScrollBar_GetParentShowHint(s._instance())
}

// SetParentShowHint
//
// 设置以父容器的ShowHint属性为准。
func (s *TScrollBar) SetParentShowHint(value bool) {
    ScrollBar_SetParentShowHint(s._instance(), value)
}

// PopupMenu
//
// 获取右键菜单。
//
// Get Right click menu.
func (s *TScrollBar) PopupMenu() *TPopupMenu {
    return AsPopupMenu(ScrollBar_GetPopupMenu(s._instance()))
}

// SetPopupMenu
//
// 设置右键菜单。
//
// Set Right click menu.
func (s *TScrollBar) SetPopupMenu(value IComponent) {
    ScrollBar_SetPopupMenu(s._instance(), CheckPtr(value))
}

func (s *TScrollBar) Position() int32 {
    return ScrollBar_GetPosition(s._instance())
}

func (s *TScrollBar) SetPosition(value int32) {
    ScrollBar_SetPosition(s._instance(), value)
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (s *TScrollBar) ShowHint() bool {
    return ScrollBar_GetShowHint(s._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (s *TScrollBar) SetShowHint(value bool) {
    ScrollBar_SetShowHint(s._instance(), value)
}

func (s *TScrollBar) SmallChange() TScrollBarInc {
    return ScrollBar_GetSmallChange(s._instance())
}

func (s *TScrollBar) SetSmallChange(value TScrollBarInc) {
    ScrollBar_SetSmallChange(s._instance(), value)
}

// TabOrder
//
// 获取Tab切换顺序序号。
//
// Get Tab switching sequence number.
func (s *TScrollBar) TabOrder() TTabOrder {
    return ScrollBar_GetTabOrder(s._instance())
}

// SetTabOrder
//
// 设置Tab切换顺序序号。
//
// Set Tab switching sequence number.
func (s *TScrollBar) SetTabOrder(value TTabOrder) {
    ScrollBar_SetTabOrder(s._instance(), value)
}

// TabStop
//
// 获取Tab可停留。
//
// Get Tab can stay.
func (s *TScrollBar) TabStop() bool {
    return ScrollBar_GetTabStop(s._instance())
}

// SetTabStop
//
// 设置Tab可停留。
//
// Set Tab can stay.
func (s *TScrollBar) SetTabStop(value bool) {
    ScrollBar_SetTabStop(s._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (s *TScrollBar) Visible() bool {
    return ScrollBar_GetVisible(s._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (s *TScrollBar) SetVisible(value bool) {
    ScrollBar_SetVisible(s._instance(), value)
}

// SetOnContextPopup
//
// 设置上下文弹出事件，一般是右键时弹出。
//
// Set Context popup event, usually pop up when right click.
func (s *TScrollBar) SetOnContextPopup(fn TContextPopupEvent) {
    ScrollBar_SetOnContextPopup(s._instance(), fn)
}

// SetOnChange
//
// 设置改变事件。
//
// Set changed event.
func (s *TScrollBar) SetOnChange(fn TNotifyEvent) {
    ScrollBar_SetOnChange(s._instance(), fn)
}

// SetOnDragDrop
//
// 设置拖拽下落事件。
//
// Set Drag and drop event.
func (s *TScrollBar) SetOnDragDrop(fn TDragDropEvent) {
    ScrollBar_SetOnDragDrop(s._instance(), fn)
}

// SetOnDragOver
//
// 设置拖拽完成事件。
//
// Set Drag and drop completion event.
func (s *TScrollBar) SetOnDragOver(fn TDragOverEvent) {
    ScrollBar_SetOnDragOver(s._instance(), fn)
}

// SetOnEndDrag
//
// 设置拖拽结束。
//
// Set End of drag.
func (s *TScrollBar) SetOnEndDrag(fn TEndDragEvent) {
    ScrollBar_SetOnEndDrag(s._instance(), fn)
}

// SetOnEnter
//
// 设置焦点进入。
//
// Set Focus entry.
func (s *TScrollBar) SetOnEnter(fn TNotifyEvent) {
    ScrollBar_SetOnEnter(s._instance(), fn)
}

// SetOnExit
//
// 设置焦点退出。
//
// Set Focus exit.
func (s *TScrollBar) SetOnExit(fn TNotifyEvent) {
    ScrollBar_SetOnExit(s._instance(), fn)
}

// SetOnKeyDown
//
// 设置键盘按键按下事件。
//
// Set Keyboard button press event.
func (s *TScrollBar) SetOnKeyDown(fn TKeyEvent) {
    ScrollBar_SetOnKeyDown(s._instance(), fn)
}

// SetOnKeyPress
//
// 设置键键下事件。
func (s *TScrollBar) SetOnKeyPress(fn TKeyPressEvent) {
    ScrollBar_SetOnKeyPress(s._instance(), fn)
}

// SetOnKeyUp
//
// 设置键盘按键抬起事件。
//
// Set Keyboard button lift event.
func (s *TScrollBar) SetOnKeyUp(fn TKeyEvent) {
    ScrollBar_SetOnKeyUp(s._instance(), fn)
}

// DockClientCount
//
// 获取依靠客户端总数。
func (s *TScrollBar) DockClientCount() int32 {
    return ScrollBar_GetDockClientCount(s._instance())
}

// DockSite
//
// 获取停靠站点。
//
// Get Docking site.
func (s *TScrollBar) DockSite() bool {
    return ScrollBar_GetDockSite(s._instance())
}

// SetDockSite
//
// 设置停靠站点。
//
// Set Docking site.
func (s *TScrollBar) SetDockSite(value bool) {
    ScrollBar_SetDockSite(s._instance(), value)
}

// MouseInClient
//
// 获取鼠标是否在客户端，仅VCL有效。
//
// Get Whether the mouse is on the client, only VCL is valid.
func (s *TScrollBar) MouseInClient() bool {
    return ScrollBar_GetMouseInClient(s._instance())
}

// VisibleDockClientCount
//
// 获取当前停靠的可视总数。
//
// Get The total number of visible calls currently docked.
func (s *TScrollBar) VisibleDockClientCount() int32 {
    return ScrollBar_GetVisibleDockClientCount(s._instance())
}

// Brush
//
// 获取画刷对象。
//
// Get Brush.
func (s *TScrollBar) Brush() *TBrush {
    return AsBrush(ScrollBar_GetBrush(s._instance()))
}

// ControlCount
//
// 获取子控件数。
//
// Get Number of child controls.
func (s *TScrollBar) ControlCount() int32 {
    return ScrollBar_GetControlCount(s._instance())
}

// Handle
//
// 获取控件句柄。
//
// Get Control handle.
func (s *TScrollBar) Handle() HWND {
    return ScrollBar_GetHandle(s._instance())
}

// ParentWindow
//
// 获取父容器句柄。
//
// Get Parent container handle.
func (s *TScrollBar) ParentWindow() HWND {
    return ScrollBar_GetParentWindow(s._instance())
}

// SetParentWindow
//
// 设置父容器句柄。
//
// Set Parent container handle.
func (s *TScrollBar) SetParentWindow(value HWND) {
    ScrollBar_SetParentWindow(s._instance(), value)
}

func (s *TScrollBar) Showing() bool {
    return ScrollBar_GetShowing(s._instance())
}

// UseDockManager
//
// 获取使用停靠管理。
func (s *TScrollBar) UseDockManager() bool {
    return ScrollBar_GetUseDockManager(s._instance())
}

// SetUseDockManager
//
// 设置使用停靠管理。
func (s *TScrollBar) SetUseDockManager(value bool) {
    ScrollBar_SetUseDockManager(s._instance(), value)
}

func (s *TScrollBar) Action() *TAction {
    return AsAction(ScrollBar_GetAction(s._instance()))
}

func (s *TScrollBar) SetAction(value IComponent) {
    ScrollBar_SetAction(s._instance(), CheckPtr(value))
}

func (s *TScrollBar) BoundsRect() TRect {
    return ScrollBar_GetBoundsRect(s._instance())
}

func (s *TScrollBar) SetBoundsRect(value TRect) {
    ScrollBar_SetBoundsRect(s._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (s *TScrollBar) ClientHeight() int32 {
    return ScrollBar_GetClientHeight(s._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (s *TScrollBar) SetClientHeight(value int32) {
    ScrollBar_SetClientHeight(s._instance(), value)
}

func (s *TScrollBar) ClientOrigin() TPoint {
    return ScrollBar_GetClientOrigin(s._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (s *TScrollBar) ClientRect() TRect {
    return ScrollBar_GetClientRect(s._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (s *TScrollBar) ClientWidth() int32 {
    return ScrollBar_GetClientWidth(s._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (s *TScrollBar) SetClientWidth(value int32) {
    ScrollBar_SetClientWidth(s._instance(), value)
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (s *TScrollBar) ControlState() TControlState {
    return ScrollBar_GetControlState(s._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (s *TScrollBar) SetControlState(value TControlState) {
    ScrollBar_SetControlState(s._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (s *TScrollBar) ControlStyle() TControlStyle {
    return ScrollBar_GetControlStyle(s._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (s *TScrollBar) SetControlStyle(value TControlStyle) {
    ScrollBar_SetControlStyle(s._instance(), value)
}

func (s *TScrollBar) Floating() bool {
    return ScrollBar_GetFloating(s._instance())
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (s *TScrollBar) Parent() *TWinControl {
    return AsWinControl(ScrollBar_GetParent(s._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (s *TScrollBar) SetParent(value IWinControl) {
    ScrollBar_SetParent(s._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (s *TScrollBar) Left() int32 {
    return ScrollBar_GetLeft(s._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (s *TScrollBar) SetLeft(value int32) {
    ScrollBar_SetLeft(s._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (s *TScrollBar) Top() int32 {
    return ScrollBar_GetTop(s._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (s *TScrollBar) SetTop(value int32) {
    ScrollBar_SetTop(s._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (s *TScrollBar) Width() int32 {
    return ScrollBar_GetWidth(s._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (s *TScrollBar) SetWidth(value int32) {
    ScrollBar_SetWidth(s._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (s *TScrollBar) Height() int32 {
    return ScrollBar_GetHeight(s._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (s *TScrollBar) SetHeight(value int32) {
    ScrollBar_SetHeight(s._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (s *TScrollBar) Cursor() TCursor {
    return ScrollBar_GetCursor(s._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (s *TScrollBar) SetCursor(value TCursor) {
    ScrollBar_SetCursor(s._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (s *TScrollBar) Hint() string {
    return ScrollBar_GetHint(s._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (s *TScrollBar) SetHint(value string) {
    ScrollBar_SetHint(s._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (s *TScrollBar) ComponentCount() int32 {
    return ScrollBar_GetComponentCount(s._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (s *TScrollBar) ComponentIndex() int32 {
    return ScrollBar_GetComponentIndex(s._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (s *TScrollBar) SetComponentIndex(value int32) {
    ScrollBar_SetComponentIndex(s._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (s *TScrollBar) Owner() *TComponent {
    return AsComponent(ScrollBar_GetOwner(s._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (s *TScrollBar) Name() string {
    return ScrollBar_GetName(s._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (s *TScrollBar) SetName(value string) {
    ScrollBar_SetName(s._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (s *TScrollBar) Tag() int {
    return ScrollBar_GetTag(s._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (s *TScrollBar) SetTag(value int) {
    ScrollBar_SetTag(s._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (s *TScrollBar) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(ScrollBar_GetAnchorSideLeft(s._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (s *TScrollBar) SetAnchorSideLeft(value *TAnchorSide) {
    ScrollBar_SetAnchorSideLeft(s._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (s *TScrollBar) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(ScrollBar_GetAnchorSideTop(s._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (s *TScrollBar) SetAnchorSideTop(value *TAnchorSide) {
    ScrollBar_SetAnchorSideTop(s._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (s *TScrollBar) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(ScrollBar_GetAnchorSideRight(s._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (s *TScrollBar) SetAnchorSideRight(value *TAnchorSide) {
    ScrollBar_SetAnchorSideRight(s._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (s *TScrollBar) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(ScrollBar_GetAnchorSideBottom(s._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (s *TScrollBar) SetAnchorSideBottom(value *TAnchorSide) {
    ScrollBar_SetAnchorSideBottom(s._instance(), CheckPtr(value))
}

func (s *TScrollBar) ChildSizing() *TControlChildSizing {
    return AsControlChildSizing(ScrollBar_GetChildSizing(s._instance()))
}

func (s *TScrollBar) SetChildSizing(value *TControlChildSizing) {
    ScrollBar_SetChildSizing(s._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (s *TScrollBar) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(ScrollBar_GetBorderSpacing(s._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (s *TScrollBar) SetBorderSpacing(value *TControlBorderSpacing) {
    ScrollBar_SetBorderSpacing(s._instance(), CheckPtr(value))
}

// DockClients
//
// 获取指定索引停靠客户端。
func (s *TScrollBar) DockClients(Index int32) *TControl {
    return AsControl(ScrollBar_GetDockClients(s._instance(), Index))
}

// Controls
//
// 获取指定索引子控件。
func (s *TScrollBar) Controls(Index int32) *TControl {
    return AsControl(ScrollBar_GetControls(s._instance(), Index))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (s *TScrollBar) Components(AIndex int32) *TComponent {
    return AsComponent(ScrollBar_GetComponents(s._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (s *TScrollBar) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(ScrollBar_GetAnchorSide(s._instance(), AKind))
}

