//----------------------------------------
//
// Copyright © ying32. All Rights Reserved.
//
// Licensed under Apache License 2.0
//
//----------------------------------------

package rtl

var (
	langsMap = map[string]int32{
		"af-ZA":  1078,
		"am-ET":  1118,
		"ar-AE":  14337,
		"ar-BH":  15361,
		"ar-DZ":  5121,
		"ar-EG":  3073,
		"ar-IQ":  2049,
		"ar-JO":  11265,
		"ar-KW":  13313,
		"ar-LB":  12289,
		"ar-LY":  4097,
		"ar-MA":  6145,
		"ar-OM":  8193,
		"ar-QA":  16385,
		"ar-SA":  1025,
		"ar-SY":  10241,
		"ar-TN":  7169,
		"ar-YE":  9217,
		"arn-CL": 1146,
		"as-IN":  1101,
		"az-AZ":  2092,
		//"az-AZ":  1068,
		"ba-RU":  1133,
		"be-BY":  1059,
		"bg-BG":  1026,
		"bin-NG": 1126,
		"bn-BD":  2117,
		"bn-IN":  1093,
		"bo-CN":  1105,
		"br-FR":  1150,
		"bs-BA":  8218,
		//"bs-BA":  5146,
		//"ca-ES":  1027,
		"ca-ES":  2051,
		"chr-US": 1116,
		"co-FR":  1155,
		"cs-CZ":  1029,
		"cy-GB":  1106,
		"da-DK":  1030,
		"de-AT":  3079,
		"de-CH":  2055,
		"de-DE":  1031,
		"de-LI":  5127,
		"de-LU":  4103,
		"dsb-DE": 2094,
		"dv-MV":  1125,
		"dz-BT":  3153,
		"el-GR":  1032,
		"en-029": 9225,
		"en-AU":  3081,
		"en-BZ":  10249,
		"en-CA":  4105,
		"en-GB":  2057,
		"en-HK":  15369,
		"en-ID":  14345,
		"en-IE":  6153,
		"en-IN":  16393,
		"en-JM":  8201,
		"en-MY":  17417,
		"en-NZ":  5129,
		"en-PH":  13321,
		"en-SG":  18441,
		"en-TT":  11273,
		"en-US":  1033,
		"en-ZA":  7177,
		"en-ZW":  12297,
		"es-419": 22538,
		"es-AR":  11274,
		"es-BO":  16394,
		"es-CL":  13322,
		"es-CO":  9226,
		"es-CR":  5130,
		"es-CU":  23562,
		"es-DO":  7178,
		"es-EC":  12298,
		"es-ES":  3082,
		//"es-ES":  1034,
		"es-GT":  4106,
		"es-HN":  18442,
		"es-MX":  2058,
		"es-NI":  19466,
		"es-PA":  6154,
		"es-PE":  10250,
		"es-PR":  20490,
		"es-PY":  15370,
		"es-SV":  17418,
		"es-US":  21514,
		"es-UY":  14346,
		"es-VE":  8202,
		"et-EE":  1061,
		"eu-ES":  1069,
		"fa-IR":  1065,
		"ff-SN":  2151,
		"ff-NG":  1127,
		"fi-FI":  1035,
		"fil-PH": 1124,
		"fo-FO":  1080,
		"fr-029": 7180,
		"fr-BE":  2060,
		"fr-CA":  3084,
		"fr-CD":  9228,
		"fr-CH":  4108,
		"fr-CI":  12300,
		"fr-CM":  11276,
		"fr-FR":  1036,
		"fr-HT":  15372,
		"fr-LU":  5132,
		"fr-MA":  14348,
		"fr-MC":  6156,
		"fr-ML":  13324,
		"fr-RE":  8204,
		"fr-SN":  10252,
		"fy-NL":  1122,
		"ga-IE":  2108,
		"gd-GB":  1169,
		"gl-ES":  1110,
		"gn-PY":  1140,
		"gsw-FR": 1156,
		"gu-IN":  1095,
		"ha-NG":  1128,
		"haw-US": 1141,
		"he-IL":  1037,
		"hi-IN":  1081,
		"hr-BA":  4122,
		"hr-HR":  1050,
		"hsb-DE": 1070,
		"hu-HU":  1038,
		"hy-AM":  1067,
		"ibb-NG": 1129,
		"id-ID":  1057,
		"ig-NG":  1136,
		"ii-CN":  1144,
		"is-IS":  1039,
		"it-CH":  2064,
		"it-IT":  1040,
		//"iu-CA":  1117,
		"iu-CA":  2141,
		"ja-JP":  1041,
		"ka-GE":  1079,
		"kk-KZ":  1087,
		"kl-GL":  1135,
		"km-KH":  1107,
		"kn-IN":  1099,
		"ko-KR":  1042,
		"kok-IN": 1111,
		"kr-NG":  1137,
		"ks-IN":  2144,
		"ku-IQ":  1170,
		"ky-KG":  1088,
		"la-001": 1142,
		"lb-LU":  1134,
		"lo-LA":  1108,
		"lt-LT":  1063,
		"lv-LV":  1062,
		"mi-NZ":  1153,
		"mk-MK":  1071,
		"ml-IN":  1100,
		//"mn-MN":   1104,
		"mn-CN":   2128,
		"mn-MN":   3152,
		"mni-IN":  1112,
		"moh-CA":  1148,
		"mr-IN":   1102,
		"ms-BN":   2110,
		"ms-MY":   1086,
		"mt-MT":   1082,
		"my-MM":   1109,
		"nb-NO":   1044,
		"ne-IN":   2145,
		"ne-NP":   1121,
		"nl-BE":   2067,
		"nl-NL":   1043,
		"nn-NO":   2068,
		"nso-ZA":  1132,
		"oc-FR":   1154,
		"om-ET":   1138,
		"or-IN":   1096,
		"pa-PK":   2118,
		"pa-IN":   1094,
		"pap-029": 1145,
		"pl-PL":   1045,
		"prs-AF":  1164,
		"ps-AF":   1123,
		"pt-BR":   1046,
		"pt-PT":   2070,
		"quc-GT":  1158,
		"quz-BO":  1131,
		"quz-EC":  2155,
		"quz-PE":  3179,
		"rm-CH":   1047,
		"ro-MD":   2072,
		"ro-RO":   1048,
		"ru-MD":   2073,
		"ru-RU":   1049,
		"rw-RW":   1159,
		"sa-IN":   1103,
		"sah-RU":  1157,
		"sd-PK":   2137,
		"sd-IN":   1113,
		"se-FI":   3131,
		"se-NO":   1083,
		"se-SE":   2107,
		"si-LK":   1115,
		"sk-SK":   1051,
		"sl-SI":   1060,
		"sma-NO":  6203,
		"sma-SE":  7227,
		"smj-NO":  4155,
		"smj-SE":  5179,
		"smn-FI":  9275,
		"sms-FI":  8251,
		"so-SO":   1143,
		"sq-AL":   1052,
		"sr-BA":   7194,
		"sr-ME":   12314,
		"sr-RS":   10266,
		//"sr-BA":   6170,
		//"sr-ME":   11290,
		//"sr-RS":   9242,
		"st-ZA":  1072,
		"sv-FI":  2077,
		"sv-SE":  1053,
		"sw-KE":  1089,
		"syr-SY": 1114,
		"ta-IN":  1097,
		"ta-LK":  2121,
		"te-IN":  1098,
		"tg-TJ":  1064,
		"th-TH":  1054,
		"ti-ER":  2163,
		"ti-ET":  1139,
		"tk-TM":  1090,
		"tn-BW":  2098,
		"tn-ZA":  1074,
		"tr-TR":  1055,
		"ts-ZA":  1073,
		"tt-RU":  1092,
		"tzm-MA": 1119,
		"tzm-DZ": 2143,
		//"tzm-MA":  4191,
		"ug-CN": 1152,
		"uk-UA": 1058,
		"ur-IN": 2080,
		"ur-PK": 1056,
		//"uz-UZ":   2115,
		"uz-UZ":  1091,
		"ve-ZA":  1075,
		"vi-VN":  1066,
		"wo-SN":  1160,
		"xh-ZA":  1076,
		"yi-001": 1085,
		"yo-NG":  1130,
		"zh-CN":  2052,
		"zh-HK":  3076,
		"zh-MO":  5124,
		"zh-SG":  4100,
		"zh-TW":  1028,
		"zu-ZA":  1077,
	}
)

// LocaleIDFromName
// 从名称获取一个语言的id
func LocaleIDFromName(name string) int32 {
	if lang, ok := langsMap[name]; ok {
		return lang
	}
	return -1
}
