
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TPicture struct {
    IObject
    instance unsafe.Pointer
}

// NewPicture
//
// 创建一个新的对象。
// 
// Create a new object.
func NewPicture() *TPicture {
    p := new(TPicture)
    p.instance = unsafe.Pointer(Picture_Create())
    setFinalizer(p, (*TPicture).Free)
    return p
}

// AsPicture
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsPicture(obj interface{}) *TPicture {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TPicture{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (p *TPicture) Free() {
    if p.instance != nullptr {
        Picture_Free(p._instance())
        p.instance  = nullptr
    }
}

func (p *TPicture) _instance() uintptr {
    return uintptr(p.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (p *TPicture) Instance() uintptr {
    return p._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (p *TPicture) UnsafeAddr() unsafe.Pointer {
    return p.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (p *TPicture) IsValid() bool {
    return p.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (p *TPicture) Is() TIs {
    return TIs(p._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (p *TPicture) As() TAs {
//    return TAs(p._instance())
//}

// TPictureClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TPictureClass() TClass {
    return Picture_StaticClassType()
}

// LoadFromFile
//
// 从文件加载。
func (p *TPicture) LoadFromFile(Filename string) {
    Picture_LoadFromFile(p._instance(), Filename)
}

// SaveToFile
//
// 保存至文件。
func (p *TPicture) SaveToFile(Filename string) {
    Picture_SaveToFile(p._instance(), Filename)
}

// LoadFromStream
//
// 文件流加载。
func (p *TPicture) LoadFromStream(Stream IStream) {
    Picture_LoadFromStream(p._instance(), CheckPtr(Stream))
}

// SaveToStream
//
// 保存至流。
func (p *TPicture) SaveToStream(Stream IStream) {
    Picture_SaveToStream(p._instance(), CheckPtr(Stream))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (p *TPicture) Assign(Source IObject) {
    Picture_Assign(p._instance(), CheckPtr(Source))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (p *TPicture) GetNamePath() string {
    return Picture_GetNamePath(p._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (p *TPicture) ClassType() TClass {
    return Picture_ClassType(p._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (p *TPicture) ClassName() string {
    return Picture_ClassName(p._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (p *TPicture) InstanceSize() int32 {
    return Picture_InstanceSize(p._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (p *TPicture) InheritsFrom(AClass TClass) bool {
    return Picture_InheritsFrom(p._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (p *TPicture) Equals(Obj IObject) bool {
    return Picture_Equals(p._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (p *TPicture) GetHashCode() int32 {
    return Picture_GetHashCode(p._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (p *TPicture) ToString() string {
    return Picture_ToString(p._instance())
}

func (p *TPicture) Bitmap() *TBitmap {
    return AsBitmap(Picture_GetBitmap(p._instance()))
}

func (p *TPicture) SetBitmap(value *TBitmap) {
    Picture_SetBitmap(p._instance(), CheckPtr(value))
}

func (p *TPicture) Graphic() *TGraphic {
    return AsGraphic(Picture_GetGraphic(p._instance()))
}

func (p *TPicture) SetGraphic(value IGraphic) {
    Picture_SetGraphic(p._instance(), CheckPtr(value))
}

// Height
//
// 获取高度。
//
// Get height.
func (p *TPicture) Height() int32 {
    return Picture_GetHeight(p._instance())
}

// Icon
//
// 获取图标。
//
// Get icon.
func (p *TPicture) Icon() *TIcon {
    return AsIcon(Picture_GetIcon(p._instance()))
}

// SetIcon
//
// 设置图标。
//
// Set icon.
func (p *TPicture) SetIcon(value *TIcon) {
    Picture_SetIcon(p._instance(), CheckPtr(value))
}

// Width
//
// 获取宽度。
//
// Get width.
func (p *TPicture) Width() int32 {
    return Picture_GetWidth(p._instance())
}

// SetOnChange
//
// 设置改变事件。
//
// Set changed event.
func (p *TPicture) SetOnChange(fn TNotifyEvent) {
    Picture_SetOnChange(p._instance(), fn)
}

