
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TPaintBox struct {
    IControl
    instance unsafe.Pointer
}

// NewPaintBox
//
// 创建一个新的对象。
// 
// Create a new object.
func NewPaintBox(owner IComponent) *TPaintBox {
    p := new(TPaintBox)
    p.instance = unsafe.Pointer(PaintBox_Create(CheckPtr(owner)))
    return p
}

// AsPaintBox
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsPaintBox(obj interface{}) *TPaintBox {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TPaintBox{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (p *TPaintBox) Free() {
    if p.instance != nullptr {
        PaintBox_Free(p._instance())
        p.instance  = nullptr
    }
}

func (p *TPaintBox) _instance() uintptr {
    return uintptr(p.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (p *TPaintBox) Instance() uintptr {
    return p._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (p *TPaintBox) UnsafeAddr() unsafe.Pointer {
    return p.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (p *TPaintBox) IsValid() bool {
    return p.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (p *TPaintBox) Is() TIs {
    return TIs(p._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (p *TPaintBox) As() TAs {
//    return TAs(p._instance())
//}

// TPaintBoxClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TPaintBoxClass() TClass {
    return PaintBox_StaticClassType()
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (p *TPaintBox) BringToFront() {
    PaintBox_BringToFront(p._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (p *TPaintBox) ClientToScreen(Point TPoint) TPoint {
    return PaintBox_ClientToScreen(p._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (p *TPaintBox) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return PaintBox_ClientToParent(p._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (p *TPaintBox) Dragging() bool {
    return PaintBox_Dragging(p._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (p *TPaintBox) HasParent() bool {
    return PaintBox_HasParent(p._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (p *TPaintBox) Hide() {
    PaintBox_Hide(p._instance())
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (p *TPaintBox) Invalidate() {
    PaintBox_Invalidate(p._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (p *TPaintBox) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return PaintBox_Perform(p._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (p *TPaintBox) Refresh() {
    PaintBox_Refresh(p._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (p *TPaintBox) Repaint() {
    PaintBox_Repaint(p._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (p *TPaintBox) ScreenToClient(Point TPoint) TPoint {
    return PaintBox_ScreenToClient(p._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (p *TPaintBox) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return PaintBox_ParentToClient(p._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (p *TPaintBox) SendToBack() {
    PaintBox_SendToBack(p._instance())
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (p *TPaintBox) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    PaintBox_SetBounds(p._instance(), ALeft , ATop , AWidth , AHeight)
}

// Show
//
// 显示控件。
//
// Show control.
func (p *TPaintBox) Show() {
    PaintBox_Show(p._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (p *TPaintBox) Update() {
    PaintBox_Update(p._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (p *TPaintBox) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return PaintBox_GetTextBuf(p._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (p *TPaintBox) GetTextLen() int32 {
    return PaintBox_GetTextLen(p._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (p *TPaintBox) SetTextBuf(Buffer string) {
    PaintBox_SetTextBuf(p._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (p *TPaintBox) FindComponent(AName string) *TComponent {
    return AsComponent(PaintBox_FindComponent(p._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (p *TPaintBox) GetNamePath() string {
    return PaintBox_GetNamePath(p._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (p *TPaintBox) Assign(Source IObject) {
    PaintBox_Assign(p._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (p *TPaintBox) ClassType() TClass {
    return PaintBox_ClassType(p._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (p *TPaintBox) ClassName() string {
    return PaintBox_ClassName(p._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (p *TPaintBox) InstanceSize() int32 {
    return PaintBox_InstanceSize(p._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (p *TPaintBox) InheritsFrom(AClass TClass) bool {
    return PaintBox_InheritsFrom(p._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (p *TPaintBox) Equals(Obj IObject) bool {
    return PaintBox_Equals(p._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (p *TPaintBox) GetHashCode() int32 {
    return PaintBox_GetHashCode(p._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (p *TPaintBox) ToString() string {
    return PaintBox_ToString(p._instance())
}

func (p *TPaintBox) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    PaintBox_AnchorToNeighbour(p._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (p *TPaintBox) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    PaintBox_AnchorParallel(p._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (p *TPaintBox) AnchorHorizontalCenterTo(ASibling IControl) {
    PaintBox_AnchorHorizontalCenterTo(p._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (p *TPaintBox) AnchorVerticalCenterTo(ASibling IControl) {
    PaintBox_AnchorVerticalCenterTo(p._instance(), CheckPtr(ASibling))
}

func (p *TPaintBox) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    PaintBox_AnchorSame(p._instance(), ASide , CheckPtr(ASibling))
}

func (p *TPaintBox) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    PaintBox_AnchorAsAlign(p._instance(), ATheAlign , ASpace)
}

func (p *TPaintBox) AnchorClient(ASpace int32) {
    PaintBox_AnchorClient(p._instance(), ASpace)
}

func (p *TPaintBox) ScaleDesignToForm(ASize int32) int32 {
    return PaintBox_ScaleDesignToForm(p._instance(), ASize)
}

func (p *TPaintBox) ScaleFormToDesign(ASize int32) int32 {
    return PaintBox_ScaleFormToDesign(p._instance(), ASize)
}

func (p *TPaintBox) Scale96ToForm(ASize int32) int32 {
    return PaintBox_Scale96ToForm(p._instance(), ASize)
}

func (p *TPaintBox) ScaleFormTo96(ASize int32) int32 {
    return PaintBox_ScaleFormTo96(p._instance(), ASize)
}

func (p *TPaintBox) Scale96ToFont(ASize int32) int32 {
    return PaintBox_Scale96ToFont(p._instance(), ASize)
}

func (p *TPaintBox) ScaleFontTo96(ASize int32) int32 {
    return PaintBox_ScaleFontTo96(p._instance(), ASize)
}

func (p *TPaintBox) ScaleScreenToFont(ASize int32) int32 {
    return PaintBox_ScaleScreenToFont(p._instance(), ASize)
}

func (p *TPaintBox) ScaleFontToScreen(ASize int32) int32 {
    return PaintBox_ScaleFontToScreen(p._instance(), ASize)
}

func (p *TPaintBox) Scale96ToScreen(ASize int32) int32 {
    return PaintBox_Scale96ToScreen(p._instance(), ASize)
}

func (p *TPaintBox) ScaleScreenTo96(ASize int32) int32 {
    return PaintBox_ScaleScreenTo96(p._instance(), ASize)
}

func (p *TPaintBox) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    PaintBox_AutoAdjustLayout(p._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (p *TPaintBox) FixDesignFontsPPI(ADesignTimePPI int32) {
    PaintBox_FixDesignFontsPPI(p._instance(), ADesignTimePPI)
}

func (p *TPaintBox) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    PaintBox_ScaleFontsPPI(p._instance(), AToPPI , AProportion)
}

// Canvas
//
// 获取画布。
func (p *TPaintBox) Canvas() *TCanvas {
    return AsCanvas(PaintBox_GetCanvas(p._instance()))
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (p *TPaintBox) Align() TAlign {
    return PaintBox_GetAlign(p._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (p *TPaintBox) SetAlign(value TAlign) {
    PaintBox_SetAlign(p._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (p *TPaintBox) Anchors() TAnchors {
    return PaintBox_GetAnchors(p._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (p *TPaintBox) SetAnchors(value TAnchors) {
    PaintBox_SetAnchors(p._instance(), value)
}

// Color
//
// 获取颜色。
//
// Get color.
func (p *TPaintBox) Color() TColor {
    return PaintBox_GetColor(p._instance())
}

// SetColor
//
// 设置颜色。
//
// Set color.
func (p *TPaintBox) SetColor(value TColor) {
    PaintBox_SetColor(p._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (p *TPaintBox) Constraints() *TSizeConstraints {
    return AsSizeConstraints(PaintBox_GetConstraints(p._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (p *TPaintBox) SetConstraints(value *TSizeConstraints) {
    PaintBox_SetConstraints(p._instance(), CheckPtr(value))
}

// DragCursor
//
// 获取设置控件拖拽时的光标。
//
// Get Set the cursor when the control is dragged.
func (p *TPaintBox) DragCursor() TCursor {
    return PaintBox_GetDragCursor(p._instance())
}

// SetDragCursor
//
// 设置设置控件拖拽时的光标。
//
// Set Set the cursor when the control is dragged.
func (p *TPaintBox) SetDragCursor(value TCursor) {
    PaintBox_SetDragCursor(p._instance(), value)
}

// DragMode
//
// 获取拖拽模式。
//
// Get Drag mode.
func (p *TPaintBox) DragMode() TDragMode {
    return PaintBox_GetDragMode(p._instance())
}

// SetDragMode
//
// 设置拖拽模式。
//
// Set Drag mode.
func (p *TPaintBox) SetDragMode(value TDragMode) {
    PaintBox_SetDragMode(p._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (p *TPaintBox) Enabled() bool {
    return PaintBox_GetEnabled(p._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (p *TPaintBox) SetEnabled(value bool) {
    PaintBox_SetEnabled(p._instance(), value)
}

// Font
//
// 获取字体。
//
// Get Font.
func (p *TPaintBox) Font() *TFont {
    return AsFont(PaintBox_GetFont(p._instance()))
}

// SetFont
//
// 设置字体。
//
// Set Font.
func (p *TPaintBox) SetFont(value *TFont) {
    PaintBox_SetFont(p._instance(), CheckPtr(value))
}

// ParentColor
//
// 获取使用父容器颜色。
//
// Get parent color.
func (p *TPaintBox) ParentColor() bool {
    return PaintBox_GetParentColor(p._instance())
}

// SetParentColor
//
// 设置使用父容器颜色。
//
// Set parent color.
func (p *TPaintBox) SetParentColor(value bool) {
    PaintBox_SetParentColor(p._instance(), value)
}

// ParentFont
//
// 获取使用父容器字体。
//
// Get Parent container font.
func (p *TPaintBox) ParentFont() bool {
    return PaintBox_GetParentFont(p._instance())
}

// SetParentFont
//
// 设置使用父容器字体。
//
// Set Parent container font.
func (p *TPaintBox) SetParentFont(value bool) {
    PaintBox_SetParentFont(p._instance(), value)
}

// ParentShowHint
//
// 获取以父容器的ShowHint属性为准。
func (p *TPaintBox) ParentShowHint() bool {
    return PaintBox_GetParentShowHint(p._instance())
}

// SetParentShowHint
//
// 设置以父容器的ShowHint属性为准。
func (p *TPaintBox) SetParentShowHint(value bool) {
    PaintBox_SetParentShowHint(p._instance(), value)
}

// PopupMenu
//
// 获取右键菜单。
//
// Get Right click menu.
func (p *TPaintBox) PopupMenu() *TPopupMenu {
    return AsPopupMenu(PaintBox_GetPopupMenu(p._instance()))
}

// SetPopupMenu
//
// 设置右键菜单。
//
// Set Right click menu.
func (p *TPaintBox) SetPopupMenu(value IComponent) {
    PaintBox_SetPopupMenu(p._instance(), CheckPtr(value))
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (p *TPaintBox) ShowHint() bool {
    return PaintBox_GetShowHint(p._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (p *TPaintBox) SetShowHint(value bool) {
    PaintBox_SetShowHint(p._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (p *TPaintBox) Visible() bool {
    return PaintBox_GetVisible(p._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (p *TPaintBox) SetVisible(value bool) {
    PaintBox_SetVisible(p._instance(), value)
}

// SetOnClick
//
// 设置控件单击事件。
//
// Set control click event.
func (p *TPaintBox) SetOnClick(fn TNotifyEvent) {
    PaintBox_SetOnClick(p._instance(), fn)
}

// SetOnDblClick
//
// 设置双击事件。
func (p *TPaintBox) SetOnDblClick(fn TNotifyEvent) {
    PaintBox_SetOnDblClick(p._instance(), fn)
}

// SetOnDragDrop
//
// 设置拖拽下落事件。
//
// Set Drag and drop event.
func (p *TPaintBox) SetOnDragDrop(fn TDragDropEvent) {
    PaintBox_SetOnDragDrop(p._instance(), fn)
}

// SetOnDragOver
//
// 设置拖拽完成事件。
//
// Set Drag and drop completion event.
func (p *TPaintBox) SetOnDragOver(fn TDragOverEvent) {
    PaintBox_SetOnDragOver(p._instance(), fn)
}

// SetOnEndDrag
//
// 设置拖拽结束。
//
// Set End of drag.
func (p *TPaintBox) SetOnEndDrag(fn TEndDragEvent) {
    PaintBox_SetOnEndDrag(p._instance(), fn)
}

// SetOnMouseDown
//
// 设置鼠标按下事件。
//
// Set Mouse down event.
func (p *TPaintBox) SetOnMouseDown(fn TMouseEvent) {
    PaintBox_SetOnMouseDown(p._instance(), fn)
}

// SetOnMouseEnter
//
// 设置鼠标进入事件。
//
// Set Mouse entry event.
func (p *TPaintBox) SetOnMouseEnter(fn TNotifyEvent) {
    PaintBox_SetOnMouseEnter(p._instance(), fn)
}

// SetOnMouseLeave
//
// 设置鼠标离开事件。
//
// Set Mouse leave event.
func (p *TPaintBox) SetOnMouseLeave(fn TNotifyEvent) {
    PaintBox_SetOnMouseLeave(p._instance(), fn)
}

// SetOnMouseMove
//
// 设置鼠标移动事件。
func (p *TPaintBox) SetOnMouseMove(fn TMouseMoveEvent) {
    PaintBox_SetOnMouseMove(p._instance(), fn)
}

// SetOnMouseUp
//
// 设置鼠标抬起事件。
//
// Set Mouse lift event.
func (p *TPaintBox) SetOnMouseUp(fn TMouseEvent) {
    PaintBox_SetOnMouseUp(p._instance(), fn)
}

// SetOnPaint
//
// 设置绘画事件。
func (p *TPaintBox) SetOnPaint(fn TNotifyEvent) {
    PaintBox_SetOnPaint(p._instance(), fn)
}

func (p *TPaintBox) Action() *TAction {
    return AsAction(PaintBox_GetAction(p._instance()))
}

func (p *TPaintBox) SetAction(value IComponent) {
    PaintBox_SetAction(p._instance(), CheckPtr(value))
}

func (p *TPaintBox) BiDiMode() TBiDiMode {
    return PaintBox_GetBiDiMode(p._instance())
}

func (p *TPaintBox) SetBiDiMode(value TBiDiMode) {
    PaintBox_SetBiDiMode(p._instance(), value)
}

func (p *TPaintBox) BoundsRect() TRect {
    return PaintBox_GetBoundsRect(p._instance())
}

func (p *TPaintBox) SetBoundsRect(value TRect) {
    PaintBox_SetBoundsRect(p._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (p *TPaintBox) ClientHeight() int32 {
    return PaintBox_GetClientHeight(p._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (p *TPaintBox) SetClientHeight(value int32) {
    PaintBox_SetClientHeight(p._instance(), value)
}

func (p *TPaintBox) ClientOrigin() TPoint {
    return PaintBox_GetClientOrigin(p._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (p *TPaintBox) ClientRect() TRect {
    return PaintBox_GetClientRect(p._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (p *TPaintBox) ClientWidth() int32 {
    return PaintBox_GetClientWidth(p._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (p *TPaintBox) SetClientWidth(value int32) {
    PaintBox_SetClientWidth(p._instance(), value)
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (p *TPaintBox) ControlState() TControlState {
    return PaintBox_GetControlState(p._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (p *TPaintBox) SetControlState(value TControlState) {
    PaintBox_SetControlState(p._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (p *TPaintBox) ControlStyle() TControlStyle {
    return PaintBox_GetControlStyle(p._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (p *TPaintBox) SetControlStyle(value TControlStyle) {
    PaintBox_SetControlStyle(p._instance(), value)
}

func (p *TPaintBox) Floating() bool {
    return PaintBox_GetFloating(p._instance())
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (p *TPaintBox) Parent() *TWinControl {
    return AsWinControl(PaintBox_GetParent(p._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (p *TPaintBox) SetParent(value IWinControl) {
    PaintBox_SetParent(p._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (p *TPaintBox) Left() int32 {
    return PaintBox_GetLeft(p._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (p *TPaintBox) SetLeft(value int32) {
    PaintBox_SetLeft(p._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (p *TPaintBox) Top() int32 {
    return PaintBox_GetTop(p._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (p *TPaintBox) SetTop(value int32) {
    PaintBox_SetTop(p._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (p *TPaintBox) Width() int32 {
    return PaintBox_GetWidth(p._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (p *TPaintBox) SetWidth(value int32) {
    PaintBox_SetWidth(p._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (p *TPaintBox) Height() int32 {
    return PaintBox_GetHeight(p._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (p *TPaintBox) SetHeight(value int32) {
    PaintBox_SetHeight(p._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (p *TPaintBox) Cursor() TCursor {
    return PaintBox_GetCursor(p._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (p *TPaintBox) SetCursor(value TCursor) {
    PaintBox_SetCursor(p._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (p *TPaintBox) Hint() string {
    return PaintBox_GetHint(p._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (p *TPaintBox) SetHint(value string) {
    PaintBox_SetHint(p._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (p *TPaintBox) ComponentCount() int32 {
    return PaintBox_GetComponentCount(p._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (p *TPaintBox) ComponentIndex() int32 {
    return PaintBox_GetComponentIndex(p._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (p *TPaintBox) SetComponentIndex(value int32) {
    PaintBox_SetComponentIndex(p._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (p *TPaintBox) Owner() *TComponent {
    return AsComponent(PaintBox_GetOwner(p._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (p *TPaintBox) Name() string {
    return PaintBox_GetName(p._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (p *TPaintBox) SetName(value string) {
    PaintBox_SetName(p._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (p *TPaintBox) Tag() int {
    return PaintBox_GetTag(p._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (p *TPaintBox) SetTag(value int) {
    PaintBox_SetTag(p._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (p *TPaintBox) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(PaintBox_GetAnchorSideLeft(p._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (p *TPaintBox) SetAnchorSideLeft(value *TAnchorSide) {
    PaintBox_SetAnchorSideLeft(p._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (p *TPaintBox) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(PaintBox_GetAnchorSideTop(p._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (p *TPaintBox) SetAnchorSideTop(value *TAnchorSide) {
    PaintBox_SetAnchorSideTop(p._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (p *TPaintBox) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(PaintBox_GetAnchorSideRight(p._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (p *TPaintBox) SetAnchorSideRight(value *TAnchorSide) {
    PaintBox_SetAnchorSideRight(p._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (p *TPaintBox) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(PaintBox_GetAnchorSideBottom(p._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (p *TPaintBox) SetAnchorSideBottom(value *TAnchorSide) {
    PaintBox_SetAnchorSideBottom(p._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (p *TPaintBox) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(PaintBox_GetBorderSpacing(p._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (p *TPaintBox) SetBorderSpacing(value *TControlBorderSpacing) {
    PaintBox_SetBorderSpacing(p._instance(), CheckPtr(value))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (p *TPaintBox) Components(AIndex int32) *TComponent {
    return AsComponent(PaintBox_GetComponents(p._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (p *TPaintBox) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(PaintBox_GetAnchorSide(p._instance(), AKind))
}

