
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TObject struct {
    IObject
    instance unsafe.Pointer
}

// NewObject
//
// 创建一个新的对象。
// 
// Create a new object.
func NewObject() *TObject {
    o := new(TObject)
    o.instance = unsafe.Pointer(Object_Create())
    setFinalizer(o, (*TObject).Free)
    return o
}

// AsObject
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsObject(obj interface{}) *TObject {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TObject{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (o *TObject) Free() {
    if o.instance != nullptr {
        Object_Free(o._instance())
        o.instance  = nullptr
    }
}

func (o *TObject) _instance() uintptr {
    return uintptr(o.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (o *TObject) Instance() uintptr {
    return o._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (o *TObject) UnsafeAddr() unsafe.Pointer {
    return o.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (o *TObject) IsValid() bool {
    return o.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (o *TObject) Is() TIs {
    return TIs(o._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (o *TObject) As() TAs {
//    return TAs(o._instance())
//}

// TObjectClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TObjectClass() TClass {
    return Object_StaticClassType()
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (o *TObject) ClassType() TClass {
    return Object_ClassType(o._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (o *TObject) ClassName() string {
    return Object_ClassName(o._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (o *TObject) InstanceSize() int32 {
    return Object_InstanceSize(o._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (o *TObject) InheritsFrom(AClass TClass) bool {
    return Object_InheritsFrom(o._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (o *TObject) Equals(Obj IObject) bool {
    return Object_Equals(o._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (o *TObject) GetHashCode() int32 {
    return Object_GetHashCode(o._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (o *TObject) ToString() string {
    return Object_ToString(o._instance())
}

