
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TMouse struct {
    IObject
    instance unsafe.Pointer
}

// NewMouse
//
// 创建一个新的对象。
// 
// Create a new object.
func NewMouse() *TMouse {
    m := new(TMouse)
    m.instance = unsafe.Pointer(Mouse_Create())
    setFinalizer(m, (*TMouse).Free)
    return m
}

// AsMouse
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsMouse(obj interface{}) *TMouse {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TMouse{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (m *TMouse) Free() {
    if m.instance != nullptr {
        Mouse_Free(m._instance())
        m.instance  = nullptr
    }
}

func (m *TMouse) _instance() uintptr {
    return uintptr(m.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (m *TMouse) Instance() uintptr {
    return m._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (m *TMouse) UnsafeAddr() unsafe.Pointer {
    return m.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (m *TMouse) IsValid() bool {
    return m.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (m *TMouse) Is() TIs {
    return TIs(m._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (m *TMouse) As() TAs {
//    return TAs(m._instance())
//}

// TMouseClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TMouseClass() TClass {
    return Mouse_StaticClassType()
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (m *TMouse) ClassType() TClass {
    return Mouse_ClassType(m._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (m *TMouse) ClassName() string {
    return Mouse_ClassName(m._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (m *TMouse) InstanceSize() int32 {
    return Mouse_InstanceSize(m._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (m *TMouse) InheritsFrom(AClass TClass) bool {
    return Mouse_InheritsFrom(m._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (m *TMouse) Equals(Obj IObject) bool {
    return Mouse_Equals(m._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (m *TMouse) GetHashCode() int32 {
    return Mouse_GetHashCode(m._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (m *TMouse) ToString() string {
    return Mouse_ToString(m._instance())
}

func (m *TMouse) Capture() HWND {
    return Mouse_GetCapture(m._instance())
}

func (m *TMouse) SetCapture(value HWND) {
    Mouse_SetCapture(m._instance(), value)
}

func (m *TMouse) CursorPos() TPoint {
    return Mouse_GetCursorPos(m._instance())
}

func (m *TMouse) SetCursorPos(value TPoint) {
    Mouse_SetCursorPos(m._instance(), value)
}

func (m *TMouse) IsDragging() bool {
    return Mouse_GetIsDragging(m._instance())
}

func (m *TMouse) WheelScrollLines() int32 {
    return Mouse_GetWheelScrollLines(m._instance())
}

