
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TMemoryStream struct {
    IStream
    instance unsafe.Pointer
}

// NewMemoryStream
//
// 创建一个新的对象。
// 
// Create a new object.
func NewMemoryStream() *TMemoryStream {
    m := new(TMemoryStream)
    m.instance = unsafe.Pointer(MemoryStream_Create())
    setFinalizer(m, (*TMemoryStream).Free)
    return m
}

// AsMemoryStream
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsMemoryStream(obj interface{}) *TMemoryStream {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TMemoryStream{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (m *TMemoryStream) Free() {
    if m.instance != nullptr {
        MemoryStream_Free(m._instance())
        m.instance  = nullptr
    }
}

func (m *TMemoryStream) _instance() uintptr {
    return uintptr(m.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (m *TMemoryStream) Instance() uintptr {
    return m._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (m *TMemoryStream) UnsafeAddr() unsafe.Pointer {
    return m.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (m *TMemoryStream) IsValid() bool {
    return m.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (m *TMemoryStream) Is() TIs {
    return TIs(m._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (m *TMemoryStream) As() TAs {
//    return TAs(m._instance())
//}

// TMemoryStreamClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TMemoryStreamClass() TClass {
    return MemoryStream_StaticClassType()
}

// Clear
//
// 清除。
func (m *TMemoryStream) Clear() {
    MemoryStream_Clear(m._instance())
}

// LoadFromStream
//
// 文件流加载。
func (m *TMemoryStream) LoadFromStream(Stream IStream) {
    MemoryStream_LoadFromStream(m._instance(), CheckPtr(Stream))
}

// LoadFromFile
//
// 从文件加载。
func (m *TMemoryStream) LoadFromFile(FileName string) {
    MemoryStream_LoadFromFile(m._instance(), FileName)
}

// Seek
//
// 移动流指针位置。
func (m *TMemoryStream) Seek(Offset int64, Origin TSeekOrigin) int64 {
    return MemoryStream_Seek(m._instance(), Offset , Origin)
}

// SaveToStream
//
// 保存至流。
func (m *TMemoryStream) SaveToStream(Stream IStream) {
    MemoryStream_SaveToStream(m._instance(), CheckPtr(Stream))
}

// SaveToFile
//
// 保存至文件。
func (m *TMemoryStream) SaveToFile(FileName string) {
    MemoryStream_SaveToFile(m._instance(), FileName)
}

// CopyFrom
//
// 从指定流中复制。
func (m *TMemoryStream) CopyFrom(Source IStream, Count int64) int64 {
    return MemoryStream_CopyFrom(m._instance(), CheckPtr(Source), Count)
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (m *TMemoryStream) ClassType() TClass {
    return MemoryStream_ClassType(m._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (m *TMemoryStream) ClassName() string {
    return MemoryStream_ClassName(m._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (m *TMemoryStream) InstanceSize() int32 {
    return MemoryStream_InstanceSize(m._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (m *TMemoryStream) InheritsFrom(AClass TClass) bool {
    return MemoryStream_InheritsFrom(m._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (m *TMemoryStream) Equals(Obj IObject) bool {
    return MemoryStream_Equals(m._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (m *TMemoryStream) GetHashCode() int32 {
    return MemoryStream_GetHashCode(m._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (m *TMemoryStream) ToString() string {
    return MemoryStream_ToString(m._instance())
}

// Memory
//
// 获取内存指针。
func (m *TMemoryStream) Memory() uintptr {
    return MemoryStream_GetMemory(m._instance())
}

// Position
//
// 获取流指针位置。
func (m *TMemoryStream) Position() int64 {
    return MemoryStream_GetPosition(m._instance())
}

// SetPosition
//
// 设置流指针位置。
func (m *TMemoryStream) SetPosition(value int64) {
    MemoryStream_SetPosition(m._instance(), value)
}

// Size
//
// 获取流的大小。
func (m *TMemoryStream) Size() int64 {
    return MemoryStream_GetSize(m._instance())
}

// SetSize
//
// 设置流的大小。
func (m *TMemoryStream) SetSize(value int64) {
    MemoryStream_SetSize(m._instance(), value)
}

