
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TList struct {
    IObject
    instance unsafe.Pointer
}

// NewList
//
// 创建一个新的对象。
// 
// Create a new object.
func NewList() *TList {
    l := new(TList)
    l.instance = unsafe.Pointer(List_Create())
    setFinalizer(l, (*TList).Free)
    return l
}

// AsList
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsList(obj interface{}) *TList {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TList{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (l *TList) Free() {
    if l.instance != nullptr {
        List_Free(l._instance())
        l.instance  = nullptr
    }
}

func (l *TList) _instance() uintptr {
    return uintptr(l.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (l *TList) Instance() uintptr {
    return l._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (l *TList) UnsafeAddr() unsafe.Pointer {
    return l.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (l *TList) IsValid() bool {
    return l.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (l *TList) Is() TIs {
    return TIs(l._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (l *TList) As() TAs {
//    return TAs(l._instance())
//}

// TListClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TListClass() TClass {
    return List_StaticClassType()
}

func (l *TList) Add(Item uintptr) int32 {
    return List_Add(l._instance(), Item)
}

// Clear
//
// 清除。
func (l *TList) Clear() {
    List_Clear(l._instance())
}

func (l *TList) Delete(Index int32) {
    List_Delete(l._instance(), Index)
}

func (l *TList) Exchange(Index1 int32, Index2 int32) {
    List_Exchange(l._instance(), Index1 , Index2)
}

func (l *TList) Expand() *TList {
    return AsList(List_Expand(l._instance()))
}

func (l *TList) IndexOf(Item uintptr) int32 {
    return List_IndexOf(l._instance(), Item)
}

func (l *TList) Insert(Index int32, Item uintptr) {
    List_Insert(l._instance(), Index , Item)
}

func (l *TList) Move(CurIndex int32, NewIndex int32) {
    List_Move(l._instance(), CurIndex , NewIndex)
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (l *TList) ClassType() TClass {
    return List_ClassType(l._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (l *TList) ClassName() string {
    return List_ClassName(l._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (l *TList) InstanceSize() int32 {
    return List_InstanceSize(l._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (l *TList) InheritsFrom(AClass TClass) bool {
    return List_InheritsFrom(l._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (l *TList) Equals(Obj IObject) bool {
    return List_Equals(l._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (l *TList) GetHashCode() int32 {
    return List_GetHashCode(l._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (l *TList) ToString() string {
    return List_ToString(l._instance())
}

func (l *TList) Capacity() int32 {
    return List_GetCapacity(l._instance())
}

func (l *TList) SetCapacity(value int32) {
    List_SetCapacity(l._instance(), value)
}

// Count
//
// 获取项目总数。
//
// Get Total number of projects.
func (l *TList) Count() int32 {
    return List_GetCount(l._instance())
}

// SetCount
//
// 设置项目总数。
//
// Set Total number of projects.
func (l *TList) SetCount(value int32) {
    List_SetCount(l._instance(), value)
}

// List
//
// 获取获取列表指针。
//
// Get Get list pointer.
func (l *TList) List() uintptr {
    return List_GetList(l._instance())
}

// Items
//
// 获取获取指定索引项目。
//
// Get Get the specified index item.
func (l *TList) Items(Index int32) uintptr {
    return List_GetItems(l._instance(), Index)
}

// SetItems
//
// 设置获取指定索引项目。
//
// Set Get the specified index item.
func (l *TList) SetItems(Index int32, value uintptr) {
    List_SetItems(l._instance(), Index, value)
}

