
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TImageList struct {
    IComponent
    instance unsafe.Pointer
}

// NewImageList
//
// 创建一个新的对象。
// 
// Create a new object.
func NewImageList(owner IComponent) *TImageList {
    i := new(TImageList)
    i.instance = unsafe.Pointer(ImageList_Create(CheckPtr(owner)))
    return i
}

// AsImageList
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsImageList(obj interface{}) *TImageList {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TImageList{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (i *TImageList) Free() {
    if i.instance != nullptr {
        ImageList_Free(i._instance())
        i.instance  = nullptr
    }
}

func (i *TImageList) _instance() uintptr {
    return uintptr(i.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (i *TImageList) Instance() uintptr {
    return i._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (i *TImageList) UnsafeAddr() unsafe.Pointer {
    return i.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (i *TImageList) IsValid() bool {
    return i.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (i *TImageList) Is() TIs {
    return TIs(i._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (i *TImageList) As() TAs {
//    return TAs(i._instance())
//}

// TImageListClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TImageListClass() TClass {
    return ImageList_StaticClassType()
}

func (i *TImageList) StretchDraw(ACanvas *TCanvas, AIndex int32, ARect TRect, AEnabled bool) {
    ImageList_StretchDraw(i._instance(), CheckPtr(ACanvas), AIndex , ARect , AEnabled)
}

func (i *TImageList) AddSliced(Image IBitmap, AHorizontalCount int32, AVerticalCount int32) int32 {
    return ImageList_AddSliced(i._instance(), CheckPtr(Image), AHorizontalCount , AVerticalCount)
}

func (i *TImageList) Add(Image IBitmap, Mask IBitmap) int32 {
    return ImageList_Add(i._instance(), CheckPtr(Image), CheckPtr(Mask))
}

func (i *TImageList) Insert(AIndex int32, AImage IBitmap, AMask IBitmap) {
    ImageList_Insert(i._instance(), AIndex , CheckPtr(AImage), CheckPtr(AMask))
}

func (i *TImageList) InsertMasked(Index int32, AImage IBitmap, MaskColor TColor) {
    ImageList_InsertMasked(i._instance(), Index , CheckPtr(AImage), MaskColor)
}

func (i *TImageList) Replace(AIndex int32, AImage IBitmap, AMask IBitmap, AllResolutions bool) {
    ImageList_Replace(i._instance(), AIndex , CheckPtr(AImage), CheckPtr(AMask), AllResolutions)
}

func (i *TImageList) ReplaceMasked(Index int32, NewImage IBitmap, MaskColor TColor, AllResolutions bool) {
    ImageList_ReplaceMasked(i._instance(), Index , CheckPtr(NewImage), MaskColor , AllResolutions)
}

func (i *TImageList) ReplaceIcon(AIndex int32, AIcon *TIcon) {
    ImageList_ReplaceIcon(i._instance(), AIndex , CheckPtr(AIcon))
}

func (i *TImageList) GetBitmap(Index int32, Image IBitmap, AEffect TGraphicsDrawEffect) {
    ImageList_GetBitmap(i._instance(), Index , CheckPtr(Image), AEffect)
}

func (i *TImageList) GetFullBitmap(Image IBitmap, AEffect TGraphicsDrawEffect) {
    ImageList_GetFullBitmap(i._instance(), CheckPtr(Image), AEffect)
}

func (i *TImageList) GetHotSpot() TPoint {
    return ImageList_GetHotSpot(i._instance())
}

func (i *TImageList) HideDragImage() {
    ImageList_HideDragImage(i._instance())
}

func (i *TImageList) ShowDragImage() {
    ImageList_ShowDragImage(i._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (i *TImageList) Assign(Source IObject) {
    ImageList_Assign(i._instance(), CheckPtr(Source))
}

func (i *TImageList) AddIcon(Image *TIcon) int32 {
    return ImageList_AddIcon(i._instance(), CheckPtr(Image))
}

func (i *TImageList) AddImages(Value IComponent) {
    ImageList_AddImages(i._instance(), CheckPtr(Value))
}

func (i *TImageList) AddMasked(Image *TBitmap, MaskColor TColor) int32 {
    return ImageList_AddMasked(i._instance(), CheckPtr(Image), MaskColor)
}

// Clear
//
// 清除。
func (i *TImageList) Clear() {
    ImageList_Clear(i._instance())
}

func (i *TImageList) Delete(Index int32) {
    ImageList_Delete(i._instance(), Index)
}

func (i *TImageList) InsertIcon(Index int32, Image *TIcon) {
    ImageList_InsertIcon(i._instance(), Index , CheckPtr(Image))
}

func (i *TImageList) Move(CurIndex int32, NewIndex int32) {
    ImageList_Move(i._instance(), CurIndex , NewIndex)
}

func (i *TImageList) BeginUpdate() {
    ImageList_BeginUpdate(i._instance())
}

func (i *TImageList) EndUpdate() {
    ImageList_EndUpdate(i._instance())
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (i *TImageList) FindComponent(AName string) *TComponent {
    return AsComponent(ImageList_FindComponent(i._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (i *TImageList) GetNamePath() string {
    return ImageList_GetNamePath(i._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (i *TImageList) HasParent() bool {
    return ImageList_HasParent(i._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (i *TImageList) ClassType() TClass {
    return ImageList_ClassType(i._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (i *TImageList) ClassName() string {
    return ImageList_ClassName(i._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (i *TImageList) InstanceSize() int32 {
    return ImageList_InstanceSize(i._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (i *TImageList) InheritsFrom(AClass TClass) bool {
    return ImageList_InheritsFrom(i._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (i *TImageList) Equals(Obj IObject) bool {
    return ImageList_Equals(i._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (i *TImageList) GetHashCode() int32 {
    return ImageList_GetHashCode(i._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (i *TImageList) ToString() string {
    return ImageList_ToString(i._instance())
}

func (i *TImageList) Scaled() bool {
    return ImageList_GetScaled(i._instance())
}

func (i *TImageList) SetScaled(value bool) {
    ImageList_SetScaled(i._instance(), value)
}

func (i *TImageList) ShareImages() bool {
    return ImageList_GetShareImages(i._instance())
}

func (i *TImageList) SetShareImages(value bool) {
    ImageList_SetShareImages(i._instance(), value)
}

func (i *TImageList) Count() int32 {
    return ImageList_GetCount(i._instance())
}

func (i *TImageList) BlendColor() TColor {
    return ImageList_GetBlendColor(i._instance())
}

func (i *TImageList) SetBlendColor(value TColor) {
    ImageList_SetBlendColor(i._instance(), value)
}

func (i *TImageList) BkColor() TColor {
    return ImageList_GetBkColor(i._instance())
}

func (i *TImageList) SetBkColor(value TColor) {
    ImageList_SetBkColor(i._instance(), value)
}

func (i *TImageList) AllocBy() int32 {
    return ImageList_GetAllocBy(i._instance())
}

func (i *TImageList) SetAllocBy(value int32) {
    ImageList_SetAllocBy(i._instance(), value)
}

func (i *TImageList) DrawingStyle() TDrawingStyle {
    return ImageList_GetDrawingStyle(i._instance())
}

func (i *TImageList) SetDrawingStyle(value TDrawingStyle) {
    ImageList_SetDrawingStyle(i._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (i *TImageList) Height() int32 {
    return ImageList_GetHeight(i._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (i *TImageList) SetHeight(value int32) {
    ImageList_SetHeight(i._instance(), value)
}

func (i *TImageList) ImageType() TImageType {
    return ImageList_GetImageType(i._instance())
}

func (i *TImageList) SetImageType(value TImageType) {
    ImageList_SetImageType(i._instance(), value)
}

func (i *TImageList) Masked() bool {
    return ImageList_GetMasked(i._instance())
}

func (i *TImageList) SetMasked(value bool) {
    ImageList_SetMasked(i._instance(), value)
}

// SetOnChange
//
// 设置改变事件。
//
// Set changed event.
func (i *TImageList) SetOnChange(fn TNotifyEvent) {
    ImageList_SetOnChange(i._instance(), fn)
}

// Width
//
// 获取宽度。
//
// Get width.
func (i *TImageList) Width() int32 {
    return ImageList_GetWidth(i._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (i *TImageList) SetWidth(value int32) {
    ImageList_SetWidth(i._instance(), value)
}

// DragCursor
//
// 获取设置控件拖拽时的光标。
//
// Get Set the cursor when the control is dragged.
func (i *TImageList) DragCursor() TCursor {
    return ImageList_GetDragCursor(i._instance())
}

// SetDragCursor
//
// 设置设置控件拖拽时的光标。
//
// Set Set the cursor when the control is dragged.
func (i *TImageList) SetDragCursor(value TCursor) {
    ImageList_SetDragCursor(i._instance(), value)
}

// Dragging
//
// 获取是否在拖拽中。
//
// Get Is it in the middle of dragging.
func (i *TImageList) Dragging() bool {
    return ImageList_GetDragging(i._instance())
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (i *TImageList) ComponentCount() int32 {
    return ImageList_GetComponentCount(i._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (i *TImageList) ComponentIndex() int32 {
    return ImageList_GetComponentIndex(i._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (i *TImageList) SetComponentIndex(value int32) {
    ImageList_SetComponentIndex(i._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (i *TImageList) Owner() *TComponent {
    return AsComponent(ImageList_GetOwner(i._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (i *TImageList) Name() string {
    return ImageList_GetName(i._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (i *TImageList) SetName(value string) {
    ImageList_SetName(i._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (i *TImageList) Tag() int {
    return ImageList_GetTag(i._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (i *TImageList) SetTag(value int) {
    ImageList_SetTag(i._instance(), value)
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (i *TImageList) Components(AIndex int32) *TComponent {
    return AsComponent(ImageList_GetComponents(i._instance(), AIndex))
}

