
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TIcon struct {
    IBitmap
    instance unsafe.Pointer
}

// NewIcon
//
// 创建一个新的对象。
// 
// Create a new object.
func NewIcon() *TIcon {
    i := new(TIcon)
    i.instance = unsafe.Pointer(Icon_Create())
    setFinalizer(i, (*TIcon).Free)
    return i
}

// AsIcon
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsIcon(obj interface{}) *TIcon {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TIcon{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (i *TIcon) Free() {
    if i.instance != nullptr {
        Icon_Free(i._instance())
        i.instance  = nullptr
    }
}

func (i *TIcon) _instance() uintptr {
    return uintptr(i.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (i *TIcon) Instance() uintptr {
    return i._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (i *TIcon) UnsafeAddr() unsafe.Pointer {
    return i.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (i *TIcon) IsValid() bool {
    return i.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (i *TIcon) Is() TIs {
    return TIs(i._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (i *TIcon) As() TAs {
//    return TAs(i._instance())
//}

// TIconClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TIconClass() TClass {
    return Icon_StaticClassType()
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (i *TIcon) Assign(Source IObject) {
    Icon_Assign(i._instance(), CheckPtr(Source))
}

// HandleAllocated
//
// 句柄是否已经分配。
//
// Is the handle already allocated.
func (i *TIcon) HandleAllocated() bool {
    return Icon_HandleAllocated(i._instance())
}

// LoadFromStream
//
// 文件流加载。
func (i *TIcon) LoadFromStream(Stream IStream) {
    Icon_LoadFromStream(i._instance(), CheckPtr(Stream))
}

// SaveToStream
//
// 保存至流。
func (i *TIcon) SaveToStream(Stream IStream) {
    Icon_SaveToStream(i._instance(), CheckPtr(Stream))
}

func (i *TIcon) SetSize(AWidth int32, AHeight int32) {
    Icon_SetSize(i._instance(), AWidth , AHeight)
}

func (i *TIcon) LoadFromResourceName(Instance uintptr, ResName string) {
    Icon_LoadFromResourceName(i._instance(), Instance , ResName)
}

func (i *TIcon) LoadFromResourceID(Instance uintptr, ResID int32) {
    Icon_LoadFromResourceID(i._instance(), Instance , ResID)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (i *TIcon) Equals(Obj IObject) bool {
    return Icon_Equals(i._instance(), CheckPtr(Obj))
}

// LoadFromFile
//
// 从文件加载。
func (i *TIcon) LoadFromFile(Filename string) {
    Icon_LoadFromFile(i._instance(), Filename)
}

// SaveToFile
//
// 保存至文件。
func (i *TIcon) SaveToFile(Filename string) {
    Icon_SaveToFile(i._instance(), Filename)
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (i *TIcon) GetNamePath() string {
    return Icon_GetNamePath(i._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (i *TIcon) ClassType() TClass {
    return Icon_ClassType(i._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (i *TIcon) ClassName() string {
    return Icon_ClassName(i._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (i *TIcon) InstanceSize() int32 {
    return Icon_InstanceSize(i._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (i *TIcon) InheritsFrom(AClass TClass) bool {
    return Icon_InheritsFrom(i._instance(), AClass)
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (i *TIcon) GetHashCode() int32 {
    return Icon_GetHashCode(i._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (i *TIcon) ToString() string {
    return Icon_ToString(i._instance())
}

// Handle
//
// 获取控件句柄。
//
// Get Control handle.
func (i *TIcon) Handle() HICON {
    return Icon_GetHandle(i._instance())
}

// SetHandle
//
// 设置控件句柄。
//
// Set Control handle.
func (i *TIcon) SetHandle(value HICON) {
    Icon_SetHandle(i._instance(), value)
}

func (i *TIcon) Empty() bool {
    return Icon_GetEmpty(i._instance())
}

// Height
//
// 获取高度。
//
// Get height.
func (i *TIcon) Height() int32 {
    return Icon_GetHeight(i._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (i *TIcon) SetHeight(value int32) {
    Icon_SetHeight(i._instance(), value)
}

// Modified
//
// 获取修改。
//
// Get modified.
func (i *TIcon) Modified() bool {
    return Icon_GetModified(i._instance())
}

// SetModified
//
// 设置修改。
//
// Set modified.
func (i *TIcon) SetModified(value bool) {
    Icon_SetModified(i._instance(), value)
}

func (i *TIcon) Palette() HPALETTE {
    return Icon_GetPalette(i._instance())
}

func (i *TIcon) SetPalette(value HPALETTE) {
    Icon_SetPalette(i._instance(), value)
}

func (i *TIcon) PaletteModified() bool {
    return Icon_GetPaletteModified(i._instance())
}

func (i *TIcon) SetPaletteModified(value bool) {
    Icon_SetPaletteModified(i._instance(), value)
}

// Transparent
//
// 获取透明。
//
// Get transparent.
func (i *TIcon) Transparent() bool {
    return Icon_GetTransparent(i._instance())
}

// SetTransparent
//
// 设置透明。
//
// Set transparent.
func (i *TIcon) SetTransparent(value bool) {
    Icon_SetTransparent(i._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (i *TIcon) Width() int32 {
    return Icon_GetWidth(i._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (i *TIcon) SetWidth(value int32) {
    Icon_SetWidth(i._instance(), value)
}

// SetOnChange
//
// 设置改变事件。
//
// Set changed event.
func (i *TIcon) SetOnChange(fn TNotifyEvent) {
    Icon_SetOnChange(i._instance(), fn)
}

