
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TGraphic struct {
    IGraphic
    instance unsafe.Pointer
}

// NewGraphic
//
// 创建一个新的对象。
// 
// Create a new object.
func NewGraphic() *TGraphic {
    g := new(TGraphic)
    g.instance = unsafe.Pointer(Graphic_Create())
    setFinalizer(g, (*TGraphic).Free)
    return g
}

// AsGraphic
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsGraphic(obj interface{}) *TGraphic {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TGraphic{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (g *TGraphic) Free() {
    if g.instance != nullptr {
        Graphic_Free(g._instance())
        g.instance  = nullptr
    }
}

func (g *TGraphic) _instance() uintptr {
    return uintptr(g.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (g *TGraphic) Instance() uintptr {
    return g._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (g *TGraphic) UnsafeAddr() unsafe.Pointer {
    return g.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (g *TGraphic) IsValid() bool {
    return g.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (g *TGraphic) Is() TIs {
    return TIs(g._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (g *TGraphic) As() TAs {
//    return TAs(g._instance())
//}

// TGraphicClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TGraphicClass() TClass {
    return Graphic_StaticClassType()
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (g *TGraphic) Equals(Obj IObject) bool {
    return Graphic_Equals(g._instance(), CheckPtr(Obj))
}

// LoadFromFile
//
// 从文件加载。
func (g *TGraphic) LoadFromFile(Filename string) {
    Graphic_LoadFromFile(g._instance(), Filename)
}

// SaveToFile
//
// 保存至文件。
func (g *TGraphic) SaveToFile(Filename string) {
    Graphic_SaveToFile(g._instance(), Filename)
}

// LoadFromStream
//
// 文件流加载。
func (g *TGraphic) LoadFromStream(Stream IStream) {
    Graphic_LoadFromStream(g._instance(), CheckPtr(Stream))
}

// SaveToStream
//
// 保存至流。
func (g *TGraphic) SaveToStream(Stream IStream) {
    Graphic_SaveToStream(g._instance(), CheckPtr(Stream))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (g *TGraphic) Assign(Source IObject) {
    Graphic_Assign(g._instance(), CheckPtr(Source))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (g *TGraphic) GetNamePath() string {
    return Graphic_GetNamePath(g._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (g *TGraphic) ClassType() TClass {
    return Graphic_ClassType(g._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (g *TGraphic) ClassName() string {
    return Graphic_ClassName(g._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (g *TGraphic) InstanceSize() int32 {
    return Graphic_InstanceSize(g._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (g *TGraphic) InheritsFrom(AClass TClass) bool {
    return Graphic_InheritsFrom(g._instance(), AClass)
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (g *TGraphic) GetHashCode() int32 {
    return Graphic_GetHashCode(g._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (g *TGraphic) ToString() string {
    return Graphic_ToString(g._instance())
}

// Empty
//
// 获取对象是否为空。
//
// Get object is empty.
func (g *TGraphic) Empty() bool {
    return Graphic_GetEmpty(g._instance())
}

// Height
//
// 获取高度。
//
// Get height.
func (g *TGraphic) Height() int32 {
    return Graphic_GetHeight(g._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (g *TGraphic) SetHeight(value int32) {
    Graphic_SetHeight(g._instance(), value)
}

// Modified
//
// 获取修改。
//
// Get modified.
func (g *TGraphic) Modified() bool {
    return Graphic_GetModified(g._instance())
}

// SetModified
//
// 设置修改。
//
// Set modified.
func (g *TGraphic) SetModified(value bool) {
    Graphic_SetModified(g._instance(), value)
}

func (g *TGraphic) Palette() HPALETTE {
    return Graphic_GetPalette(g._instance())
}

func (g *TGraphic) SetPalette(value HPALETTE) {
    Graphic_SetPalette(g._instance(), value)
}

func (g *TGraphic) PaletteModified() bool {
    return Graphic_GetPaletteModified(g._instance())
}

func (g *TGraphic) SetPaletteModified(value bool) {
    Graphic_SetPaletteModified(g._instance(), value)
}

// Transparent
//
// 获取透明。
//
// Get transparent.
func (g *TGraphic) Transparent() bool {
    return Graphic_GetTransparent(g._instance())
}

// SetTransparent
//
// 设置透明。
//
// Set transparent.
func (g *TGraphic) SetTransparent(value bool) {
    Graphic_SetTransparent(g._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (g *TGraphic) Width() int32 {
    return Graphic_GetWidth(g._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (g *TGraphic) SetWidth(value int32) {
    Graphic_SetWidth(g._instance(), value)
}

// SetOnChange
//
// 设置改变事件。
//
// Set changed event.
func (g *TGraphic) SetOnChange(fn TNotifyEvent) {
    Graphic_SetOnChange(g._instance(), fn)
}

