
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TDragObject struct {
    IObject
    instance unsafe.Pointer
}

// NewDragObject
//
// 创建一个新的对象。
// 
// Create a new object.
func NewDragObject(AOwner IControl) *TDragObject {
    d := new(TDragObject)
    d.instance = unsafe.Pointer(DragObject_Create(CheckPtr(AOwner)))
    setFinalizer(d, (*TDragObject).Free)
    return d
}

// AsDragObject
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsDragObject(obj interface{}) *TDragObject {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TDragObject{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (d *TDragObject) Free() {
    if d.instance != nullptr {
        DragObject_Free(d._instance())
        d.instance  = nullptr
    }
}

func (d *TDragObject) _instance() uintptr {
    return uintptr(d.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (d *TDragObject) Instance() uintptr {
    return d._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (d *TDragObject) UnsafeAddr() unsafe.Pointer {
    return d.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (d *TDragObject) IsValid() bool {
    return d.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (d *TDragObject) Is() TIs {
    return TIs(d._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (d *TDragObject) As() TAs {
//    return TAs(d._instance())
//}

// TDragObjectClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TDragObjectClass() TClass {
    return DragObject_StaticClassType()
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (d *TDragObject) Assign(Source *TDragObject) {
    DragObject_Assign(d._instance(), CheckPtr(Source))
}

func (d *TDragObject) HideDragImage() {
    DragObject_HideDragImage(d._instance())
}

func (d *TDragObject) ShowDragImage() {
    DragObject_ShowDragImage(d._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (d *TDragObject) ClassType() TClass {
    return DragObject_ClassType(d._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (d *TDragObject) ClassName() string {
    return DragObject_ClassName(d._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (d *TDragObject) InstanceSize() int32 {
    return DragObject_InstanceSize(d._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (d *TDragObject) InheritsFrom(AClass TClass) bool {
    return DragObject_InheritsFrom(d._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (d *TDragObject) Equals(Obj IObject) bool {
    return DragObject_Equals(d._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (d *TDragObject) GetHashCode() int32 {
    return DragObject_GetHashCode(d._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (d *TDragObject) ToString() string {
    return DragObject_ToString(d._instance())
}

func (d *TDragObject) AlwaysShowDragImages() bool {
    return DragObject_GetAlwaysShowDragImages(d._instance())
}

func (d *TDragObject) SetAlwaysShowDragImages(value bool) {
    DragObject_SetAlwaysShowDragImages(d._instance(), value)
}

func (d *TDragObject) DragPos() TPoint {
    return DragObject_GetDragPos(d._instance())
}

func (d *TDragObject) SetDragPos(value TPoint) {
    DragObject_SetDragPos(d._instance(), value)
}

func (d *TDragObject) DragTarget() uintptr {
    return DragObject_GetDragTarget(d._instance())
}

func (d *TDragObject) SetDragTarget(value uintptr) {
    DragObject_SetDragTarget(d._instance(), value)
}

func (d *TDragObject) DragTargetPos() TPoint {
    return DragObject_GetDragTargetPos(d._instance())
}

func (d *TDragObject) SetDragTargetPos(value TPoint) {
    DragObject_SetDragTargetPos(d._instance(), value)
}

func (d *TDragObject) Dropped() bool {
    return DragObject_GetDropped(d._instance())
}

