
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TControl struct {
    IControl
    instance unsafe.Pointer
}

// NewControl
//
// 创建一个新的对象。
// 
// Create a new object.
func NewControl(owner IComponent) *TControl {
    c := new(TControl)
    c.instance = unsafe.Pointer(Control_Create(CheckPtr(owner)))
    return c
}

// AsControl
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsControl(obj interface{}) *TControl {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TControl{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (c *TControl) Free() {
    if c.instance != nullptr {
        Control_Free(c._instance())
        c.instance  = nullptr
    }
}

func (c *TControl) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TControl) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TControl) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TControl) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TControl) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TControl) As() TAs {
//    return TAs(c._instance())
//}

// TControlClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TControlClass() TClass {
    return Control_StaticClassType()
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (c *TControl) BringToFront() {
    Control_BringToFront(c._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (c *TControl) ClientToScreen(Point TPoint) TPoint {
    return Control_ClientToScreen(c._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (c *TControl) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return Control_ClientToParent(c._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (c *TControl) Dragging() bool {
    return Control_Dragging(c._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (c *TControl) HasParent() bool {
    return Control_HasParent(c._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (c *TControl) Hide() {
    Control_Hide(c._instance())
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (c *TControl) Invalidate() {
    Control_Invalidate(c._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (c *TControl) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return Control_Perform(c._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (c *TControl) Refresh() {
    Control_Refresh(c._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (c *TControl) Repaint() {
    Control_Repaint(c._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (c *TControl) ScreenToClient(Point TPoint) TPoint {
    return Control_ScreenToClient(c._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (c *TControl) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return Control_ParentToClient(c._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (c *TControl) SendToBack() {
    Control_SendToBack(c._instance())
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (c *TControl) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    Control_SetBounds(c._instance(), ALeft , ATop , AWidth , AHeight)
}

// Show
//
// 显示控件。
//
// Show control.
func (c *TControl) Show() {
    Control_Show(c._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (c *TControl) Update() {
    Control_Update(c._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (c *TControl) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return Control_GetTextBuf(c._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (c *TControl) GetTextLen() int32 {
    return Control_GetTextLen(c._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (c *TControl) SetTextBuf(Buffer string) {
    Control_SetTextBuf(c._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (c *TControl) FindComponent(AName string) *TComponent {
    return AsComponent(Control_FindComponent(c._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TControl) GetNamePath() string {
    return Control_GetNamePath(c._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TControl) Assign(Source IObject) {
    Control_Assign(c._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TControl) ClassType() TClass {
    return Control_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TControl) ClassName() string {
    return Control_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TControl) InstanceSize() int32 {
    return Control_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TControl) InheritsFrom(AClass TClass) bool {
    return Control_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TControl) Equals(Obj IObject) bool {
    return Control_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TControl) GetHashCode() int32 {
    return Control_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TControl) ToString() string {
    return Control_ToString(c._instance())
}

func (c *TControl) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    Control_AnchorToNeighbour(c._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (c *TControl) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    Control_AnchorParallel(c._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (c *TControl) AnchorHorizontalCenterTo(ASibling IControl) {
    Control_AnchorHorizontalCenterTo(c._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (c *TControl) AnchorVerticalCenterTo(ASibling IControl) {
    Control_AnchorVerticalCenterTo(c._instance(), CheckPtr(ASibling))
}

func (c *TControl) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    Control_AnchorSame(c._instance(), ASide , CheckPtr(ASibling))
}

func (c *TControl) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    Control_AnchorAsAlign(c._instance(), ATheAlign , ASpace)
}

func (c *TControl) AnchorClient(ASpace int32) {
    Control_AnchorClient(c._instance(), ASpace)
}

func (c *TControl) ScaleDesignToForm(ASize int32) int32 {
    return Control_ScaleDesignToForm(c._instance(), ASize)
}

func (c *TControl) ScaleFormToDesign(ASize int32) int32 {
    return Control_ScaleFormToDesign(c._instance(), ASize)
}

func (c *TControl) Scale96ToForm(ASize int32) int32 {
    return Control_Scale96ToForm(c._instance(), ASize)
}

func (c *TControl) ScaleFormTo96(ASize int32) int32 {
    return Control_ScaleFormTo96(c._instance(), ASize)
}

func (c *TControl) Scale96ToFont(ASize int32) int32 {
    return Control_Scale96ToFont(c._instance(), ASize)
}

func (c *TControl) ScaleFontTo96(ASize int32) int32 {
    return Control_ScaleFontTo96(c._instance(), ASize)
}

func (c *TControl) ScaleScreenToFont(ASize int32) int32 {
    return Control_ScaleScreenToFont(c._instance(), ASize)
}

func (c *TControl) ScaleFontToScreen(ASize int32) int32 {
    return Control_ScaleFontToScreen(c._instance(), ASize)
}

func (c *TControl) Scale96ToScreen(ASize int32) int32 {
    return Control_Scale96ToScreen(c._instance(), ASize)
}

func (c *TControl) ScaleScreenTo96(ASize int32) int32 {
    return Control_ScaleScreenTo96(c._instance(), ASize)
}

func (c *TControl) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    Control_AutoAdjustLayout(c._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (c *TControl) FixDesignFontsPPI(ADesignTimePPI int32) {
    Control_FixDesignFontsPPI(c._instance(), ADesignTimePPI)
}

func (c *TControl) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    Control_ScaleFontsPPI(c._instance(), AToPPI , AProportion)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (c *TControl) Enabled() bool {
    return Control_GetEnabled(c._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (c *TControl) SetEnabled(value bool) {
    Control_SetEnabled(c._instance(), value)
}

func (c *TControl) Action() *TAction {
    return AsAction(Control_GetAction(c._instance()))
}

func (c *TControl) SetAction(value IComponent) {
    Control_SetAction(c._instance(), CheckPtr(value))
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (c *TControl) Align() TAlign {
    return Control_GetAlign(c._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (c *TControl) SetAlign(value TAlign) {
    Control_SetAlign(c._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (c *TControl) Anchors() TAnchors {
    return Control_GetAnchors(c._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (c *TControl) SetAnchors(value TAnchors) {
    Control_SetAnchors(c._instance(), value)
}

func (c *TControl) BiDiMode() TBiDiMode {
    return Control_GetBiDiMode(c._instance())
}

func (c *TControl) SetBiDiMode(value TBiDiMode) {
    Control_SetBiDiMode(c._instance(), value)
}

func (c *TControl) BoundsRect() TRect {
    return Control_GetBoundsRect(c._instance())
}

func (c *TControl) SetBoundsRect(value TRect) {
    Control_SetBoundsRect(c._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (c *TControl) ClientHeight() int32 {
    return Control_GetClientHeight(c._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (c *TControl) SetClientHeight(value int32) {
    Control_SetClientHeight(c._instance(), value)
}

func (c *TControl) ClientOrigin() TPoint {
    return Control_GetClientOrigin(c._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (c *TControl) ClientRect() TRect {
    return Control_GetClientRect(c._instance())
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (c *TControl) ClientWidth() int32 {
    return Control_GetClientWidth(c._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (c *TControl) SetClientWidth(value int32) {
    Control_SetClientWidth(c._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (c *TControl) Constraints() *TSizeConstraints {
    return AsSizeConstraints(Control_GetConstraints(c._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (c *TControl) SetConstraints(value *TSizeConstraints) {
    Control_SetConstraints(c._instance(), CheckPtr(value))
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (c *TControl) ControlState() TControlState {
    return Control_GetControlState(c._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (c *TControl) SetControlState(value TControlState) {
    Control_SetControlState(c._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (c *TControl) ControlStyle() TControlStyle {
    return Control_GetControlStyle(c._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (c *TControl) SetControlStyle(value TControlStyle) {
    Control_SetControlStyle(c._instance(), value)
}

func (c *TControl) Floating() bool {
    return Control_GetFloating(c._instance())
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (c *TControl) ShowHint() bool {
    return Control_GetShowHint(c._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (c *TControl) SetShowHint(value bool) {
    Control_SetShowHint(c._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (c *TControl) Visible() bool {
    return Control_GetVisible(c._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (c *TControl) SetVisible(value bool) {
    Control_SetVisible(c._instance(), value)
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (c *TControl) Parent() *TWinControl {
    return AsWinControl(Control_GetParent(c._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (c *TControl) SetParent(value IWinControl) {
    Control_SetParent(c._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (c *TControl) Left() int32 {
    return Control_GetLeft(c._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (c *TControl) SetLeft(value int32) {
    Control_SetLeft(c._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (c *TControl) Top() int32 {
    return Control_GetTop(c._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (c *TControl) SetTop(value int32) {
    Control_SetTop(c._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (c *TControl) Width() int32 {
    return Control_GetWidth(c._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (c *TControl) SetWidth(value int32) {
    Control_SetWidth(c._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (c *TControl) Height() int32 {
    return Control_GetHeight(c._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (c *TControl) SetHeight(value int32) {
    Control_SetHeight(c._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (c *TControl) Cursor() TCursor {
    return Control_GetCursor(c._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (c *TControl) SetCursor(value TCursor) {
    Control_SetCursor(c._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (c *TControl) Hint() string {
    return Control_GetHint(c._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (c *TControl) SetHint(value string) {
    Control_SetHint(c._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (c *TControl) ComponentCount() int32 {
    return Control_GetComponentCount(c._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (c *TControl) ComponentIndex() int32 {
    return Control_GetComponentIndex(c._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (c *TControl) SetComponentIndex(value int32) {
    Control_SetComponentIndex(c._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (c *TControl) Owner() *TComponent {
    return AsComponent(Control_GetOwner(c._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (c *TControl) Name() string {
    return Control_GetName(c._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (c *TControl) SetName(value string) {
    Control_SetName(c._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (c *TControl) Tag() int {
    return Control_GetTag(c._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (c *TControl) SetTag(value int) {
    Control_SetTag(c._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (c *TControl) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(Control_GetAnchorSideLeft(c._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (c *TControl) SetAnchorSideLeft(value *TAnchorSide) {
    Control_SetAnchorSideLeft(c._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (c *TControl) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(Control_GetAnchorSideTop(c._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (c *TControl) SetAnchorSideTop(value *TAnchorSide) {
    Control_SetAnchorSideTop(c._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (c *TControl) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(Control_GetAnchorSideRight(c._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (c *TControl) SetAnchorSideRight(value *TAnchorSide) {
    Control_SetAnchorSideRight(c._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (c *TControl) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(Control_GetAnchorSideBottom(c._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (c *TControl) SetAnchorSideBottom(value *TAnchorSide) {
    Control_SetAnchorSideBottom(c._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (c *TControl) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(Control_GetBorderSpacing(c._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (c *TControl) SetBorderSpacing(value *TControlBorderSpacing) {
    Control_SetBorderSpacing(c._instance(), CheckPtr(value))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (c *TControl) Components(AIndex int32) *TComponent {
    return AsComponent(Control_GetComponents(c._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (c *TControl) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(Control_GetAnchorSide(c._instance(), AKind))
}

