
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TComboExItems struct {
    IObject
    instance unsafe.Pointer
}

// AsComboExItems
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsComboExItems(obj interface{}) *TComboExItems {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TComboExItems{instance: instance}
}

func (c *TComboExItems) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TComboExItems) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TComboExItems) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TComboExItems) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TComboExItems) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TComboExItems) As() TAs {
//    return TAs(c._instance())
//}

// TComboExItemsClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TComboExItemsClass() TClass {
    return ComboExItems_StaticClassType()
}

func (c *TComboExItems) Add() *TComboExItem {
    return AsComboExItem(ComboExItems_Add(c._instance()))
}

func (c *TComboExItems) AddItem(Caption string, ImageIndex int32, SelectedImageIndex int32, OverlayImageIndex int32, Indent int32, Data uintptr) *TComboExItem {
    return AsComboExItem(ComboExItems_AddItem(c._instance(), Caption , ImageIndex , SelectedImageIndex , OverlayImageIndex , Indent , Data))
}

func (c *TComboExItems) Insert(Index int32) *TComboExItem {
    return AsComboExItem(ComboExItems_Insert(c._instance(), Index))
}

// Owner
//
// 组件所有者。
//
// component owner.
func (c *TComboExItems) Owner() *TObject {
    return AsObject(ComboExItems_Owner(c._instance()))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TComboExItems) Assign(Source IObject) {
    ComboExItems_Assign(c._instance(), CheckPtr(Source))
}

func (c *TComboExItems) BeginUpdate() {
    ComboExItems_BeginUpdate(c._instance())
}

// Clear
//
// 清除。
func (c *TComboExItems) Clear() {
    ComboExItems_Clear(c._instance())
}

func (c *TComboExItems) Delete(Index int32) {
    ComboExItems_Delete(c._instance(), Index)
}

func (c *TComboExItems) EndUpdate() {
    ComboExItems_EndUpdate(c._instance())
}

func (c *TComboExItems) FindItemID(ID int32) *TCollectionItem {
    return AsCollectionItem(ComboExItems_FindItemID(c._instance(), ID))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TComboExItems) GetNamePath() string {
    return ComboExItems_GetNamePath(c._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TComboExItems) ClassType() TClass {
    return ComboExItems_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TComboExItems) ClassName() string {
    return ComboExItems_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TComboExItems) InstanceSize() int32 {
    return ComboExItems_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TComboExItems) InheritsFrom(AClass TClass) bool {
    return ComboExItems_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TComboExItems) Equals(Obj IObject) bool {
    return ComboExItems_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TComboExItems) GetHashCode() int32 {
    return ComboExItems_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TComboExItems) ToString() string {
    return ComboExItems_ToString(c._instance())
}

func (c *TComboExItems) Count() int32 {
    return ComboExItems_GetCount(c._instance())
}

func (c *TComboExItems) ComboItems(Index int32) *TComboExItem {
    return AsComboExItem(ComboExItems_GetComboItems(c._instance(), Index))
}

