
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TComboExItem struct {
    IObject
    instance unsafe.Pointer
}

// AsComboExItem
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsComboExItem(obj interface{}) *TComboExItem {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TComboExItem{instance: instance}
}

func (c *TComboExItem) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TComboExItem) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TComboExItem) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TComboExItem) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TComboExItem) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TComboExItem) As() TAs {
//    return TAs(c._instance())
//}

// TComboExItemClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TComboExItemClass() TClass {
    return ComboExItem_StaticClassType()
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TComboExItem) Assign(Source IObject) {
    ComboExItem_Assign(c._instance(), CheckPtr(Source))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TComboExItem) GetNamePath() string {
    return ComboExItem_GetNamePath(c._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TComboExItem) ClassType() TClass {
    return ComboExItem_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TComboExItem) ClassName() string {
    return ComboExItem_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TComboExItem) InstanceSize() int32 {
    return ComboExItem_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TComboExItem) InheritsFrom(AClass TClass) bool {
    return ComboExItem_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TComboExItem) Equals(Obj IObject) bool {
    return ComboExItem_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TComboExItem) GetHashCode() int32 {
    return ComboExItem_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TComboExItem) ToString() string {
    return ComboExItem_ToString(c._instance())
}

func (c *TComboExItem) Indent() int32 {
    return ComboExItem_GetIndent(c._instance())
}

func (c *TComboExItem) SetIndent(value int32) {
    ComboExItem_SetIndent(c._instance(), value)
}

func (c *TComboExItem) OverlayImageIndex() int32 {
    return ComboExItem_GetOverlayImageIndex(c._instance())
}

func (c *TComboExItem) SetOverlayImageIndex(value int32) {
    ComboExItem_SetOverlayImageIndex(c._instance(), value)
}

func (c *TComboExItem) Data() unsafe.Pointer {
    return ComboExItem_GetData(c._instance())
}

func (c *TComboExItem) SetData(value unsafe.Pointer) {
    ComboExItem_SetData(c._instance(), value)
}

// Caption
//
// 获取控件标题。
//
// Get the control title.
func (c *TComboExItem) Caption() string {
    return ComboExItem_GetCaption(c._instance())
}

// SetCaption
//
// 设置控件标题。
//
// Set the control title.
func (c *TComboExItem) SetCaption(value string) {
    ComboExItem_SetCaption(c._instance(), value)
}

// ImageIndex
//
// 获取图像在images中的索引。
func (c *TComboExItem) ImageIndex() int32 {
    return ComboExItem_GetImageIndex(c._instance())
}

// SetImageIndex
//
// 设置图像在images中的索引。
func (c *TComboExItem) SetImageIndex(value int32) {
    ComboExItem_SetImageIndex(c._instance(), value)
}

func (c *TComboExItem) Collection() *TCollection {
    return AsCollection(ComboExItem_GetCollection(c._instance()))
}

func (c *TComboExItem) SetCollection(value *TCollection) {
    ComboExItem_SetCollection(c._instance(), CheckPtr(value))
}

func (c *TComboExItem) Index() int32 {
    return ComboExItem_GetIndex(c._instance())
}

func (c *TComboExItem) SetIndex(value int32) {
    ComboExItem_SetIndex(c._instance(), value)
}

func (c *TComboExItem) DisplayName() string {
    return ComboExItem_GetDisplayName(c._instance())
}

func (c *TComboExItem) SetDisplayName(value string) {
    ComboExItem_SetDisplayName(c._instance(), value)
}

