
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TCollectionItem struct {
    IObject
    instance unsafe.Pointer
}

// NewCollectionItem
//
// 创建一个新的对象。
// 
// Create a new object.
func NewCollectionItem(AOwner *TCollection) *TCollectionItem {
    c := new(TCollectionItem)
    c.instance = unsafe.Pointer(CollectionItem_Create(CheckPtr(AOwner)))
    setFinalizer(c, (*TCollectionItem).Free)
    return c
}

// AsCollectionItem
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsCollectionItem(obj interface{}) *TCollectionItem {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TCollectionItem{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (c *TCollectionItem) Free() {
    if c.instance != nullptr {
        CollectionItem_Free(c._instance())
        c.instance  = nullptr
    }
}

func (c *TCollectionItem) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TCollectionItem) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TCollectionItem) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TCollectionItem) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TCollectionItem) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TCollectionItem) As() TAs {
//    return TAs(c._instance())
//}

// TCollectionItemClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TCollectionItemClass() TClass {
    return CollectionItem_StaticClassType()
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TCollectionItem) GetNamePath() string {
    return CollectionItem_GetNamePath(c._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TCollectionItem) Assign(Source IObject) {
    CollectionItem_Assign(c._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TCollectionItem) ClassType() TClass {
    return CollectionItem_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TCollectionItem) ClassName() string {
    return CollectionItem_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TCollectionItem) InstanceSize() int32 {
    return CollectionItem_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TCollectionItem) InheritsFrom(AClass TClass) bool {
    return CollectionItem_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TCollectionItem) Equals(Obj IObject) bool {
    return CollectionItem_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TCollectionItem) GetHashCode() int32 {
    return CollectionItem_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TCollectionItem) ToString() string {
    return CollectionItem_ToString(c._instance())
}

func (c *TCollectionItem) Collection() *TCollection {
    return AsCollection(CollectionItem_GetCollection(c._instance()))
}

func (c *TCollectionItem) SetCollection(value *TCollection) {
    CollectionItem_SetCollection(c._instance(), CheckPtr(value))
}

func (c *TCollectionItem) Index() int32 {
    return CollectionItem_GetIndex(c._instance())
}

func (c *TCollectionItem) SetIndex(value int32) {
    CollectionItem_SetIndex(c._instance(), value)
}

func (c *TCollectionItem) DisplayName() string {
    return CollectionItem_GetDisplayName(c._instance())
}

func (c *TCollectionItem) SetDisplayName(value string) {
    CollectionItem_SetDisplayName(c._instance(), value)
}

