
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TCollection struct {
    IObject
    instance unsafe.Pointer
}

// NewCollection
//
// 创建一个新的对象。
// 
// Create a new object.
func NewCollection(AOwner *TCollectionItem) *TCollection {
    c := new(TCollection)
    c.instance = unsafe.Pointer(Collection_Create(CheckPtr(AOwner)))
    setFinalizer(c, (*TCollection).Free)
    return c
}

// AsCollection
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsCollection(obj interface{}) *TCollection {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TCollection{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (c *TCollection) Free() {
    if c.instance != nullptr {
        Collection_Free(c._instance())
        c.instance  = nullptr
    }
}

func (c *TCollection) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TCollection) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TCollection) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TCollection) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TCollection) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TCollection) As() TAs {
//    return TAs(c._instance())
//}

// TCollectionClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TCollectionClass() TClass {
    return Collection_StaticClassType()
}

// Owner
//
// 组件所有者。
//
// component owner.
func (c *TCollection) Owner() *TObject {
    return AsObject(Collection_Owner(c._instance()))
}

func (c *TCollection) Add() *TCollectionItem {
    return AsCollectionItem(Collection_Add(c._instance()))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TCollection) Assign(Source IObject) {
    Collection_Assign(c._instance(), CheckPtr(Source))
}

func (c *TCollection) BeginUpdate() {
    Collection_BeginUpdate(c._instance())
}

// Clear
//
// 清除。
func (c *TCollection) Clear() {
    Collection_Clear(c._instance())
}

func (c *TCollection) Delete(Index int32) {
    Collection_Delete(c._instance(), Index)
}

func (c *TCollection) EndUpdate() {
    Collection_EndUpdate(c._instance())
}

func (c *TCollection) FindItemID(ID int32) *TCollectionItem {
    return AsCollectionItem(Collection_FindItemID(c._instance(), ID))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TCollection) GetNamePath() string {
    return Collection_GetNamePath(c._instance())
}

func (c *TCollection) Insert(Index int32) *TCollectionItem {
    return AsCollectionItem(Collection_Insert(c._instance(), Index))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TCollection) ClassType() TClass {
    return Collection_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TCollection) ClassName() string {
    return Collection_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TCollection) InstanceSize() int32 {
    return Collection_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TCollection) InheritsFrom(AClass TClass) bool {
    return Collection_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TCollection) Equals(Obj IObject) bool {
    return Collection_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TCollection) GetHashCode() int32 {
    return Collection_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TCollection) ToString() string {
    return Collection_ToString(c._instance())
}

func (c *TCollection) Count() int32 {
    return Collection_GetCount(c._instance())
}

func (c *TCollection) Items(Index int32) *TCollectionItem {
    return AsCollectionItem(Collection_GetItems(c._instance(), Index))
}

func (c *TCollection) SetItems(Index int32, value *TCollectionItem) {
    Collection_SetItems(c._instance(), Index, CheckPtr(value))
}

