
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TClipboard struct {
    IObject
    instance unsafe.Pointer
}

// NewClipboard
//
// 创建一个新的对象。
// 
// Create a new object.
func NewClipboard() *TClipboard {
    c := new(TClipboard)
    c.instance = unsafe.Pointer(Clipboard_Create())
    setFinalizer(c, (*TClipboard).Free)
    return c
}

// AsClipboard
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsClipboard(obj interface{}) *TClipboard {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TClipboard{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (c *TClipboard) Free() {
    if c.instance != nullptr {
        Clipboard_Free(c._instance())
        c.instance  = nullptr
    }
}

func (c *TClipboard) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TClipboard) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TClipboard) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TClipboard) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TClipboard) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TClipboard) As() TAs {
//    return TAs(c._instance())
//}

// TClipboardClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TClipboardClass() TClass {
    return Clipboard_StaticClassType()
}

func (c *TClipboard) FindPictureFormatID() TClipboardFormat {
    return Clipboard_FindPictureFormatID(c._instance())
}

func (c *TClipboard) FindFormatID(FormatName string) TClipboardFormat {
    return Clipboard_FindFormatID(c._instance(), FormatName)
}

func (c *TClipboard) SupportedFormats(List IStrings) {
    Clipboard_SupportedFormats(c._instance(), CheckPtr(List))
}

func (c *TClipboard) HasFormatName(FormatName string) bool {
    return Clipboard_HasFormatName(c._instance(), FormatName)
}

func (c *TClipboard) HasPictureFormat() bool {
    return Clipboard_HasPictureFormat(c._instance())
}

func (c *TClipboard) SetAsHtml(Html string, PlainText string) {
    Clipboard_SetAsHtml(c._instance(), Html , PlainText)
}

func (c *TClipboard) GetFormat(FormatID TClipboardFormat, Stream IStream) bool {
    return Clipboard_GetFormat(c._instance(), FormatID , CheckPtr(Stream))
}

func (c *TClipboard) AddFormat(FormatID TClipboardFormat, Stream IStream) bool {
    return Clipboard_AddFormat(c._instance(), FormatID , CheckPtr(Stream))
}

func (c *TClipboard) SetFormat(FormatID TClipboardFormat, Stream IStream) bool {
    return Clipboard_SetFormat(c._instance(), FormatID , CheckPtr(Stream))
}

func (c *TClipboard) GetComponent(Owner IComponent, Parent IComponent) *TComponent {
    return AsComponent(Clipboard_GetComponent(c._instance(), CheckPtr(Owner), CheckPtr(Parent)))
}

func (c *TClipboard) SetComponent(Component IComponent) bool {
    return Clipboard_SetComponent(c._instance(), CheckPtr(Component))
}

func (c *TClipboard) SetComponentAsText(Component IComponent) bool {
    return Clipboard_SetComponentAsText(c._instance(), CheckPtr(Component))
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TClipboard) Assign(Source IObject) {
    Clipboard_Assign(c._instance(), CheckPtr(Source))
}

// Clear
//
// 清除。
func (c *TClipboard) Clear() {
    Clipboard_Clear(c._instance())
}

// Close
//
// 关闭。
func (c *TClipboard) Close() {
    Clipboard_Close(c._instance())
}

func (c *TClipboard) Open() {
    Clipboard_Open(c._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (c *TClipboard) SetTextBuf(Buffer string) {
    Clipboard_SetTextBuf(c._instance(), Buffer)
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TClipboard) GetNamePath() string {
    return Clipboard_GetNamePath(c._instance())
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TClipboard) ClassType() TClass {
    return Clipboard_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TClipboard) ClassName() string {
    return Clipboard_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TClipboard) InstanceSize() int32 {
    return Clipboard_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TClipboard) InheritsFrom(AClass TClass) bool {
    return Clipboard_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TClipboard) Equals(Obj IObject) bool {
    return Clipboard_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TClipboard) GetHashCode() int32 {
    return Clipboard_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TClipboard) ToString() string {
    return Clipboard_ToString(c._instance())
}

func (c *TClipboard) FormatCount() int32 {
    return Clipboard_GetFormatCount(c._instance())
}

func (c *TClipboard) Formats(Index int32) TClipboardFormat {
    return Clipboard_GetFormats(c._instance(), Index)
}

