
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TCheckGroup struct {
    IWinControl
    instance unsafe.Pointer
}

// NewCheckGroup
//
// 创建一个新的对象。
// 
// Create a new object.
func NewCheckGroup(owner IComponent) *TCheckGroup {
    c := new(TCheckGroup)
    c.instance = unsafe.Pointer(CheckGroup_Create(CheckPtr(owner)))
    return c
}

// AsCheckGroup
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsCheckGroup(obj interface{}) *TCheckGroup {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TCheckGroup{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (c *TCheckGroup) Free() {
    if c.instance != nullptr {
        CheckGroup_Free(c._instance())
        c.instance  = nullptr
    }
}

func (c *TCheckGroup) _instance() uintptr {
    return uintptr(c.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (c *TCheckGroup) Instance() uintptr {
    return c._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (c *TCheckGroup) UnsafeAddr() unsafe.Pointer {
    return c.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (c *TCheckGroup) IsValid() bool {
    return c.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (c *TCheckGroup) Is() TIs {
    return TIs(c._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (c *TCheckGroup) As() TAs {
//    return TAs(c._instance())
//}

// TCheckGroupClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TCheckGroupClass() TClass {
    return CheckGroup_StaticClassType()
}

func (c *TCheckGroup) FlipChildren(AllLevels bool) {
    CheckGroup_FlipChildren(c._instance(), AllLevels)
}

func (c *TCheckGroup) Rows() int32 {
    return CheckGroup_Rows(c._instance())
}

// CanFocus
//
// 是否可以获得焦点。
func (c *TCheckGroup) CanFocus() bool {
    return CheckGroup_CanFocus(c._instance())
}

// ContainsControl
//
// 返回是否包含指定控件。
//
// it's contain a specified control.
func (c *TCheckGroup) ContainsControl(Control IControl) bool {
    return CheckGroup_ContainsControl(c._instance(), CheckPtr(Control))
}

// ControlAtPos
//
// 返回指定坐标及相关属性位置控件。
//
// Returns the specified coordinate and the relevant attribute position control..
func (c *TCheckGroup) ControlAtPos(Pos TPoint, AllowDisabled bool, AllowWinControls bool, AllLevels bool) *TControl {
    return AsControl(CheckGroup_ControlAtPos(c._instance(), Pos , AllowDisabled , AllowWinControls , AllLevels))
}

// DisableAlign
//
// 禁用控件的对齐。
//
// Disable control alignment.
func (c *TCheckGroup) DisableAlign() {
    CheckGroup_DisableAlign(c._instance())
}

// EnableAlign
//
// 启用控件对齐。
//
// Enabled control alignment.
func (c *TCheckGroup) EnableAlign() {
    CheckGroup_EnableAlign(c._instance())
}

// FindChildControl
//
// 查找子控件。
//
// Find sub controls.
func (c *TCheckGroup) FindChildControl(ControlName string) *TControl {
    return AsControl(CheckGroup_FindChildControl(c._instance(), ControlName))
}

// Focused
//
// 返回是否获取焦点。
//
// Return to get focus.
func (c *TCheckGroup) Focused() bool {
    return CheckGroup_Focused(c._instance())
}

// HandleAllocated
//
// 句柄是否已经分配。
//
// Is the handle already allocated.
func (c *TCheckGroup) HandleAllocated() bool {
    return CheckGroup_HandleAllocated(c._instance())
}

// InsertControl
//
// 插入一个控件。
//
// Insert a control.
func (c *TCheckGroup) InsertControl(AControl IControl) {
    CheckGroup_InsertControl(c._instance(), CheckPtr(AControl))
}

// Invalidate
//
// 要求重绘。
//
// Redraw.
func (c *TCheckGroup) Invalidate() {
    CheckGroup_Invalidate(c._instance())
}

// PaintTo
//
// 绘画至指定DC。
//
// Painting to the specified DC.
func (c *TCheckGroup) PaintTo(DC HDC, X int32, Y int32) {
    CheckGroup_PaintTo(c._instance(), DC , X , Y)
}

// RemoveControl
//
// 移除一个控件。
//
// Remove a control.
func (c *TCheckGroup) RemoveControl(AControl IControl) {
    CheckGroup_RemoveControl(c._instance(), CheckPtr(AControl))
}

// Realign
//
// 重新对齐。
//
// Realign.
func (c *TCheckGroup) Realign() {
    CheckGroup_Realign(c._instance())
}

// Repaint
//
// 重绘。
//
// Repaint.
func (c *TCheckGroup) Repaint() {
    CheckGroup_Repaint(c._instance())
}

// ScaleBy
//
// 按比例缩放。
//
// Scale by.
func (c *TCheckGroup) ScaleBy(M int32, D int32) {
    CheckGroup_ScaleBy(c._instance(), M , D)
}

// ScrollBy
//
// 滚动至指定位置。
//
// Scroll by.
func (c *TCheckGroup) ScrollBy(DeltaX int32, DeltaY int32) {
    CheckGroup_ScrollBy(c._instance(), DeltaX , DeltaY)
}

// SetBounds
//
// 设置组件边界。
//
// Set component boundaries.
func (c *TCheckGroup) SetBounds(ALeft int32, ATop int32, AWidth int32, AHeight int32) {
    CheckGroup_SetBounds(c._instance(), ALeft , ATop , AWidth , AHeight)
}

// SetFocus
//
// 设置控件焦点。
//
// Set control focus.
func (c *TCheckGroup) SetFocus() {
    CheckGroup_SetFocus(c._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (c *TCheckGroup) Update() {
    CheckGroup_Update(c._instance())
}

// BringToFront
//
// 将控件置于最前。
//
// Bring the control to the front.
func (c *TCheckGroup) BringToFront() {
    CheckGroup_BringToFront(c._instance())
}

// ClientToScreen
//
// 将客户端坐标转为绝对的屏幕坐标。
//
// Convert client coordinates to absolute screen coordinates.
func (c *TCheckGroup) ClientToScreen(Point TPoint) TPoint {
    return CheckGroup_ClientToScreen(c._instance(), Point)
}

// ClientToParent
//
// 将客户端坐标转为父容器坐标。
//
// Convert client coordinates to parent container coordinates.
func (c *TCheckGroup) ClientToParent(Point TPoint, AParent IWinControl) TPoint {
    return CheckGroup_ClientToParent(c._instance(), Point , CheckPtr(AParent))
}

// Dragging
//
// 是否在拖拽中。
//
// Is it in the middle of dragging.
func (c *TCheckGroup) Dragging() bool {
    return CheckGroup_Dragging(c._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (c *TCheckGroup) HasParent() bool {
    return CheckGroup_HasParent(c._instance())
}

// Hide
//
// 隐藏控件。
//
// Hidden control.
func (c *TCheckGroup) Hide() {
    CheckGroup_Hide(c._instance())
}

// Perform
//
// 发送一个消息。
//
// Send a message.
func (c *TCheckGroup) Perform(Msg uint32, WParam uintptr, LParam int) int {
    return CheckGroup_Perform(c._instance(), Msg , WParam , LParam)
}

// Refresh
//
// 刷新控件。
//
// Refresh control.
func (c *TCheckGroup) Refresh() {
    CheckGroup_Refresh(c._instance())
}

// ScreenToClient
//
// 将屏幕坐标转为客户端坐标。
//
// Convert screen coordinates to client coordinates.
func (c *TCheckGroup) ScreenToClient(Point TPoint) TPoint {
    return CheckGroup_ScreenToClient(c._instance(), Point)
}

// ParentToClient
//
// 将父容器坐标转为客户端坐标。
//
// Convert parent container coordinates to client coordinates.
func (c *TCheckGroup) ParentToClient(Point TPoint, AParent IWinControl) TPoint {
    return CheckGroup_ParentToClient(c._instance(), Point , CheckPtr(AParent))
}

// SendToBack
//
// 控件至于最后面。
//
// The control is placed at the end.
func (c *TCheckGroup) SendToBack() {
    CheckGroup_SendToBack(c._instance())
}

// Show
//
// 显示控件。
//
// Show control.
func (c *TCheckGroup) Show() {
    CheckGroup_Show(c._instance())
}

// GetTextBuf
//
// 获取控件的字符，如果有。
//
// Get the characters of the control, if any.
func (c *TCheckGroup) GetTextBuf(Buffer *string, BufSize int32) int32 {
    return CheckGroup_GetTextBuf(c._instance(), Buffer , BufSize)
}

// GetTextLen
//
// 获取控件的字符长，如果有。
//
// Get the character length of the control, if any.
func (c *TCheckGroup) GetTextLen() int32 {
    return CheckGroup_GetTextLen(c._instance())
}

// SetTextBuf
//
// 设置控件字符，如果有。
//
// Set control characters, if any.
func (c *TCheckGroup) SetTextBuf(Buffer string) {
    CheckGroup_SetTextBuf(c._instance(), Buffer)
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (c *TCheckGroup) FindComponent(AName string) *TComponent {
    return AsComponent(CheckGroup_FindComponent(c._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (c *TCheckGroup) GetNamePath() string {
    return CheckGroup_GetNamePath(c._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (c *TCheckGroup) Assign(Source IObject) {
    CheckGroup_Assign(c._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (c *TCheckGroup) ClassType() TClass {
    return CheckGroup_ClassType(c._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (c *TCheckGroup) ClassName() string {
    return CheckGroup_ClassName(c._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (c *TCheckGroup) InstanceSize() int32 {
    return CheckGroup_InstanceSize(c._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (c *TCheckGroup) InheritsFrom(AClass TClass) bool {
    return CheckGroup_InheritsFrom(c._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (c *TCheckGroup) Equals(Obj IObject) bool {
    return CheckGroup_Equals(c._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (c *TCheckGroup) GetHashCode() int32 {
    return CheckGroup_GetHashCode(c._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (c *TCheckGroup) ToString() string {
    return CheckGroup_ToString(c._instance())
}

func (c *TCheckGroup) AnchorToNeighbour(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    CheckGroup_AnchorToNeighbour(c._instance(), ASide , ASpace , CheckPtr(ASibling))
}

func (c *TCheckGroup) AnchorParallel(ASide TAnchorKind, ASpace int32, ASibling IControl) {
    CheckGroup_AnchorParallel(c._instance(), ASide , ASpace , CheckPtr(ASibling))
}

// AnchorHorizontalCenterTo
//
// 置于指定控件的横向中心。
func (c *TCheckGroup) AnchorHorizontalCenterTo(ASibling IControl) {
    CheckGroup_AnchorHorizontalCenterTo(c._instance(), CheckPtr(ASibling))
}

// AnchorVerticalCenterTo
//
// 置于指定控件的纵向中心。
func (c *TCheckGroup) AnchorVerticalCenterTo(ASibling IControl) {
    CheckGroup_AnchorVerticalCenterTo(c._instance(), CheckPtr(ASibling))
}

func (c *TCheckGroup) AnchorSame(ASide TAnchorKind, ASibling IControl) {
    CheckGroup_AnchorSame(c._instance(), ASide , CheckPtr(ASibling))
}

func (c *TCheckGroup) AnchorAsAlign(ATheAlign TAlign, ASpace int32) {
    CheckGroup_AnchorAsAlign(c._instance(), ATheAlign , ASpace)
}

func (c *TCheckGroup) AnchorClient(ASpace int32) {
    CheckGroup_AnchorClient(c._instance(), ASpace)
}

func (c *TCheckGroup) ScaleDesignToForm(ASize int32) int32 {
    return CheckGroup_ScaleDesignToForm(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleFormToDesign(ASize int32) int32 {
    return CheckGroup_ScaleFormToDesign(c._instance(), ASize)
}

func (c *TCheckGroup) Scale96ToForm(ASize int32) int32 {
    return CheckGroup_Scale96ToForm(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleFormTo96(ASize int32) int32 {
    return CheckGroup_ScaleFormTo96(c._instance(), ASize)
}

func (c *TCheckGroup) Scale96ToFont(ASize int32) int32 {
    return CheckGroup_Scale96ToFont(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleFontTo96(ASize int32) int32 {
    return CheckGroup_ScaleFontTo96(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleScreenToFont(ASize int32) int32 {
    return CheckGroup_ScaleScreenToFont(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleFontToScreen(ASize int32) int32 {
    return CheckGroup_ScaleFontToScreen(c._instance(), ASize)
}

func (c *TCheckGroup) Scale96ToScreen(ASize int32) int32 {
    return CheckGroup_Scale96ToScreen(c._instance(), ASize)
}

func (c *TCheckGroup) ScaleScreenTo96(ASize int32) int32 {
    return CheckGroup_ScaleScreenTo96(c._instance(), ASize)
}

func (c *TCheckGroup) AutoAdjustLayout(AMode TLayoutAdjustmentPolicy, AFromPPI int32, AToPPI int32, AOldFormWidth int32, ANewFormWidth int32) {
    CheckGroup_AutoAdjustLayout(c._instance(), AMode , AFromPPI , AToPPI , AOldFormWidth , ANewFormWidth)
}

func (c *TCheckGroup) FixDesignFontsPPI(ADesignTimePPI int32) {
    CheckGroup_FixDesignFontsPPI(c._instance(), ADesignTimePPI)
}

func (c *TCheckGroup) ScaleFontsPPI(AToPPI int32, AProportion float64) {
    CheckGroup_ScaleFontsPPI(c._instance(), AToPPI , AProportion)
}

// Align
//
// 获取控件自动调整。
//
// Get Control automatically adjusts.
func (c *TCheckGroup) Align() TAlign {
    return CheckGroup_GetAlign(c._instance())
}

// SetAlign
//
// 设置控件自动调整。
//
// Set Control automatically adjusts.
func (c *TCheckGroup) SetAlign(value TAlign) {
    CheckGroup_SetAlign(c._instance(), value)
}

// Anchors
//
// 获取四个角位置的锚点。
func (c *TCheckGroup) Anchors() TAnchors {
    return CheckGroup_GetAnchors(c._instance())
}

// SetAnchors
//
// 设置四个角位置的锚点。
func (c *TCheckGroup) SetAnchors(value TAnchors) {
    CheckGroup_SetAnchors(c._instance(), value)
}

func (c *TCheckGroup) AutoFill() bool {
    return CheckGroup_GetAutoFill(c._instance())
}

func (c *TCheckGroup) SetAutoFill(value bool) {
    CheckGroup_SetAutoFill(c._instance(), value)
}

// AutoSize
//
// 获取自动调整大小。
func (c *TCheckGroup) AutoSize() bool {
    return CheckGroup_GetAutoSize(c._instance())
}

// SetAutoSize
//
// 设置自动调整大小。
func (c *TCheckGroup) SetAutoSize(value bool) {
    CheckGroup_SetAutoSize(c._instance(), value)
}

func (c *TCheckGroup) BiDiMode() TBiDiMode {
    return CheckGroup_GetBiDiMode(c._instance())
}

func (c *TCheckGroup) SetBiDiMode(value TBiDiMode) {
    CheckGroup_SetBiDiMode(c._instance(), value)
}

// Caption
//
// 获取控件标题。
//
// Get the control title.
func (c *TCheckGroup) Caption() string {
    return CheckGroup_GetCaption(c._instance())
}

// SetCaption
//
// 设置控件标题。
//
// Set the control title.
func (c *TCheckGroup) SetCaption(value string) {
    CheckGroup_SetCaption(c._instance(), value)
}

// ClientHeight
//
// 获取客户区高度。
//
// Get client height.
func (c *TCheckGroup) ClientHeight() int32 {
    return CheckGroup_GetClientHeight(c._instance())
}

// SetClientHeight
//
// 设置客户区高度。
//
// Set client height.
func (c *TCheckGroup) SetClientHeight(value int32) {
    CheckGroup_SetClientHeight(c._instance(), value)
}

// ClientWidth
//
// 获取客户区宽度。
//
// Get client width.
func (c *TCheckGroup) ClientWidth() int32 {
    return CheckGroup_GetClientWidth(c._instance())
}

// SetClientWidth
//
// 设置客户区宽度。
//
// Set client width.
func (c *TCheckGroup) SetClientWidth(value int32) {
    CheckGroup_SetClientWidth(c._instance(), value)
}

// Color
//
// 获取颜色。
//
// Get color.
func (c *TCheckGroup) Color() TColor {
    return CheckGroup_GetColor(c._instance())
}

// SetColor
//
// 设置颜色。
//
// Set color.
func (c *TCheckGroup) SetColor(value TColor) {
    CheckGroup_SetColor(c._instance(), value)
}

func (c *TCheckGroup) ColumnLayout() TColumnLayout {
    return CheckGroup_GetColumnLayout(c._instance())
}

func (c *TCheckGroup) SetColumnLayout(value TColumnLayout) {
    CheckGroup_SetColumnLayout(c._instance(), value)
}

func (c *TCheckGroup) Columns() int32 {
    return CheckGroup_GetColumns(c._instance())
}

func (c *TCheckGroup) SetColumns(value int32) {
    CheckGroup_SetColumns(c._instance(), value)
}

// Constraints
//
// 获取约束控件大小。
func (c *TCheckGroup) Constraints() *TSizeConstraints {
    return AsSizeConstraints(CheckGroup_GetConstraints(c._instance()))
}

// SetConstraints
//
// 设置约束控件大小。
func (c *TCheckGroup) SetConstraints(value *TSizeConstraints) {
    CheckGroup_SetConstraints(c._instance(), CheckPtr(value))
}

// DoubleBuffered
//
// 获取设置控件双缓冲。
//
// Get Set control double buffering.
func (c *TCheckGroup) DoubleBuffered() bool {
    return CheckGroup_GetDoubleBuffered(c._instance())
}

// SetDoubleBuffered
//
// 设置设置控件双缓冲。
//
// Set Set control double buffering.
func (c *TCheckGroup) SetDoubleBuffered(value bool) {
    CheckGroup_SetDoubleBuffered(c._instance(), value)
}

// DragCursor
//
// 获取设置控件拖拽时的光标。
//
// Get Set the cursor when the control is dragged.
func (c *TCheckGroup) DragCursor() TCursor {
    return CheckGroup_GetDragCursor(c._instance())
}

// SetDragCursor
//
// 设置设置控件拖拽时的光标。
//
// Set Set the cursor when the control is dragged.
func (c *TCheckGroup) SetDragCursor(value TCursor) {
    CheckGroup_SetDragCursor(c._instance(), value)
}

// DragMode
//
// 获取拖拽模式。
//
// Get Drag mode.
func (c *TCheckGroup) DragMode() TDragMode {
    return CheckGroup_GetDragMode(c._instance())
}

// SetDragMode
//
// 设置拖拽模式。
//
// Set Drag mode.
func (c *TCheckGroup) SetDragMode(value TDragMode) {
    CheckGroup_SetDragMode(c._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (c *TCheckGroup) Enabled() bool {
    return CheckGroup_GetEnabled(c._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (c *TCheckGroup) SetEnabled(value bool) {
    CheckGroup_SetEnabled(c._instance(), value)
}

// Font
//
// 获取字体。
//
// Get Font.
func (c *TCheckGroup) Font() *TFont {
    return AsFont(CheckGroup_GetFont(c._instance()))
}

// SetFont
//
// 设置字体。
//
// Set Font.
func (c *TCheckGroup) SetFont(value *TFont) {
    CheckGroup_SetFont(c._instance(), CheckPtr(value))
}

func (c *TCheckGroup) Items() *TStrings {
    return AsStrings(CheckGroup_GetItems(c._instance()))
}

func (c *TCheckGroup) SetItems(value IStrings) {
    CheckGroup_SetItems(c._instance(), CheckPtr(value))
}

// SetOnClick
//
// 设置控件单击事件。
//
// Set control click event.
func (c *TCheckGroup) SetOnClick(fn TNotifyEvent) {
    CheckGroup_SetOnClick(c._instance(), fn)
}

// SetOnDblClick
//
// 设置双击事件。
func (c *TCheckGroup) SetOnDblClick(fn TNotifyEvent) {
    CheckGroup_SetOnDblClick(c._instance(), fn)
}

// SetOnDragDrop
//
// 设置拖拽下落事件。
//
// Set Drag and drop event.
func (c *TCheckGroup) SetOnDragDrop(fn TDragDropEvent) {
    CheckGroup_SetOnDragDrop(c._instance(), fn)
}

// SetOnDragOver
//
// 设置拖拽完成事件。
//
// Set Drag and drop completion event.
func (c *TCheckGroup) SetOnDragOver(fn TDragOverEvent) {
    CheckGroup_SetOnDragOver(c._instance(), fn)
}

// SetOnEndDrag
//
// 设置拖拽结束。
//
// Set End of drag.
func (c *TCheckGroup) SetOnEndDrag(fn TEndDragEvent) {
    CheckGroup_SetOnEndDrag(c._instance(), fn)
}

// SetOnEnter
//
// 设置焦点进入。
//
// Set Focus entry.
func (c *TCheckGroup) SetOnEnter(fn TNotifyEvent) {
    CheckGroup_SetOnEnter(c._instance(), fn)
}

// SetOnExit
//
// 设置焦点退出。
//
// Set Focus exit.
func (c *TCheckGroup) SetOnExit(fn TNotifyEvent) {
    CheckGroup_SetOnExit(c._instance(), fn)
}

func (c *TCheckGroup) SetOnItemClick(fn TCheckGroupClicked) {
    CheckGroup_SetOnItemClick(c._instance(), fn)
}

// SetOnKeyDown
//
// 设置键盘按键按下事件。
//
// Set Keyboard button press event.
func (c *TCheckGroup) SetOnKeyDown(fn TKeyEvent) {
    CheckGroup_SetOnKeyDown(c._instance(), fn)
}

// SetOnKeyPress
//
// 设置键键下事件。
func (c *TCheckGroup) SetOnKeyPress(fn TKeyPressEvent) {
    CheckGroup_SetOnKeyPress(c._instance(), fn)
}

// SetOnKeyUp
//
// 设置键盘按键抬起事件。
//
// Set Keyboard button lift event.
func (c *TCheckGroup) SetOnKeyUp(fn TKeyEvent) {
    CheckGroup_SetOnKeyUp(c._instance(), fn)
}

// SetOnMouseDown
//
// 设置鼠标按下事件。
//
// Set Mouse down event.
func (c *TCheckGroup) SetOnMouseDown(fn TMouseEvent) {
    CheckGroup_SetOnMouseDown(c._instance(), fn)
}

// SetOnMouseEnter
//
// 设置鼠标进入事件。
//
// Set Mouse entry event.
func (c *TCheckGroup) SetOnMouseEnter(fn TNotifyEvent) {
    CheckGroup_SetOnMouseEnter(c._instance(), fn)
}

// SetOnMouseLeave
//
// 设置鼠标离开事件。
//
// Set Mouse leave event.
func (c *TCheckGroup) SetOnMouseLeave(fn TNotifyEvent) {
    CheckGroup_SetOnMouseLeave(c._instance(), fn)
}

// SetOnMouseMove
//
// 设置鼠标移动事件。
func (c *TCheckGroup) SetOnMouseMove(fn TMouseMoveEvent) {
    CheckGroup_SetOnMouseMove(c._instance(), fn)
}

// SetOnMouseUp
//
// 设置鼠标抬起事件。
//
// Set Mouse lift event.
func (c *TCheckGroup) SetOnMouseUp(fn TMouseEvent) {
    CheckGroup_SetOnMouseUp(c._instance(), fn)
}

// SetOnMouseWheel
//
// 设置鼠标滚轮事件。
func (c *TCheckGroup) SetOnMouseWheel(fn TMouseWheelEvent) {
    CheckGroup_SetOnMouseWheel(c._instance(), fn)
}

// SetOnMouseWheelDown
//
// 设置鼠标滚轮按下事件。
func (c *TCheckGroup) SetOnMouseWheelDown(fn TMouseWheelUpDownEvent) {
    CheckGroup_SetOnMouseWheelDown(c._instance(), fn)
}

// SetOnMouseWheelUp
//
// 设置鼠标滚轮抬起事件。
func (c *TCheckGroup) SetOnMouseWheelUp(fn TMouseWheelUpDownEvent) {
    CheckGroup_SetOnMouseWheelUp(c._instance(), fn)
}

// SetOnResize
//
// 设置大小被改变事件。
func (c *TCheckGroup) SetOnResize(fn TNotifyEvent) {
    CheckGroup_SetOnResize(c._instance(), fn)
}

// ParentFont
//
// 获取使用父容器字体。
//
// Get Parent container font.
func (c *TCheckGroup) ParentFont() bool {
    return CheckGroup_GetParentFont(c._instance())
}

// SetParentFont
//
// 设置使用父容器字体。
//
// Set Parent container font.
func (c *TCheckGroup) SetParentFont(value bool) {
    CheckGroup_SetParentFont(c._instance(), value)
}

// ParentColor
//
// 获取使用父容器颜色。
//
// Get parent color.
func (c *TCheckGroup) ParentColor() bool {
    return CheckGroup_GetParentColor(c._instance())
}

// SetParentColor
//
// 设置使用父容器颜色。
//
// Set parent color.
func (c *TCheckGroup) SetParentColor(value bool) {
    CheckGroup_SetParentColor(c._instance(), value)
}

// ParentDoubleBuffered
//
// 获取使用父容器双缓冲。
//
// Get Parent container double buffering.
func (c *TCheckGroup) ParentDoubleBuffered() bool {
    return CheckGroup_GetParentDoubleBuffered(c._instance())
}

// SetParentDoubleBuffered
//
// 设置使用父容器双缓冲。
//
// Set Parent container double buffering.
func (c *TCheckGroup) SetParentDoubleBuffered(value bool) {
    CheckGroup_SetParentDoubleBuffered(c._instance(), value)
}

// ParentShowHint
//
// 获取以父容器的ShowHint属性为准。
func (c *TCheckGroup) ParentShowHint() bool {
    return CheckGroup_GetParentShowHint(c._instance())
}

// SetParentShowHint
//
// 设置以父容器的ShowHint属性为准。
func (c *TCheckGroup) SetParentShowHint(value bool) {
    CheckGroup_SetParentShowHint(c._instance(), value)
}

// PopupMenu
//
// 获取右键菜单。
//
// Get Right click menu.
func (c *TCheckGroup) PopupMenu() *TPopupMenu {
    return AsPopupMenu(CheckGroup_GetPopupMenu(c._instance()))
}

// SetPopupMenu
//
// 设置右键菜单。
//
// Set Right click menu.
func (c *TCheckGroup) SetPopupMenu(value IComponent) {
    CheckGroup_SetPopupMenu(c._instance(), CheckPtr(value))
}

// ShowHint
//
// 获取显示鼠标悬停提示。
//
// Get Show mouseover tips.
func (c *TCheckGroup) ShowHint() bool {
    return CheckGroup_GetShowHint(c._instance())
}

// SetShowHint
//
// 设置显示鼠标悬停提示。
//
// Set Show mouseover tips.
func (c *TCheckGroup) SetShowHint(value bool) {
    CheckGroup_SetShowHint(c._instance(), value)
}

// TabOrder
//
// 获取Tab切换顺序序号。
//
// Get Tab switching sequence number.
func (c *TCheckGroup) TabOrder() TTabOrder {
    return CheckGroup_GetTabOrder(c._instance())
}

// SetTabOrder
//
// 设置Tab切换顺序序号。
//
// Set Tab switching sequence number.
func (c *TCheckGroup) SetTabOrder(value TTabOrder) {
    CheckGroup_SetTabOrder(c._instance(), value)
}

// TabStop
//
// 获取Tab可停留。
//
// Get Tab can stay.
func (c *TCheckGroup) TabStop() bool {
    return CheckGroup_GetTabStop(c._instance())
}

// SetTabStop
//
// 设置Tab可停留。
//
// Set Tab can stay.
func (c *TCheckGroup) SetTabStop(value bool) {
    CheckGroup_SetTabStop(c._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (c *TCheckGroup) Visible() bool {
    return CheckGroup_GetVisible(c._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (c *TCheckGroup) SetVisible(value bool) {
    CheckGroup_SetVisible(c._instance(), value)
}

func (c *TCheckGroup) ParentBackground() bool {
    return CheckGroup_GetParentBackground(c._instance())
}

func (c *TCheckGroup) SetParentBackground(value bool) {
    CheckGroup_SetParentBackground(c._instance(), value)
}

// DockClientCount
//
// 获取依靠客户端总数。
func (c *TCheckGroup) DockClientCount() int32 {
    return CheckGroup_GetDockClientCount(c._instance())
}

// DockSite
//
// 获取停靠站点。
//
// Get Docking site.
func (c *TCheckGroup) DockSite() bool {
    return CheckGroup_GetDockSite(c._instance())
}

// SetDockSite
//
// 设置停靠站点。
//
// Set Docking site.
func (c *TCheckGroup) SetDockSite(value bool) {
    CheckGroup_SetDockSite(c._instance(), value)
}

// MouseInClient
//
// 获取鼠标是否在客户端，仅VCL有效。
//
// Get Whether the mouse is on the client, only VCL is valid.
func (c *TCheckGroup) MouseInClient() bool {
    return CheckGroup_GetMouseInClient(c._instance())
}

// VisibleDockClientCount
//
// 获取当前停靠的可视总数。
//
// Get The total number of visible calls currently docked.
func (c *TCheckGroup) VisibleDockClientCount() int32 {
    return CheckGroup_GetVisibleDockClientCount(c._instance())
}

// Brush
//
// 获取画刷对象。
//
// Get Brush.
func (c *TCheckGroup) Brush() *TBrush {
    return AsBrush(CheckGroup_GetBrush(c._instance()))
}

// ControlCount
//
// 获取子控件数。
//
// Get Number of child controls.
func (c *TCheckGroup) ControlCount() int32 {
    return CheckGroup_GetControlCount(c._instance())
}

// Handle
//
// 获取控件句柄。
//
// Get Control handle.
func (c *TCheckGroup) Handle() HWND {
    return CheckGroup_GetHandle(c._instance())
}

// ParentWindow
//
// 获取父容器句柄。
//
// Get Parent container handle.
func (c *TCheckGroup) ParentWindow() HWND {
    return CheckGroup_GetParentWindow(c._instance())
}

// SetParentWindow
//
// 设置父容器句柄。
//
// Set Parent container handle.
func (c *TCheckGroup) SetParentWindow(value HWND) {
    CheckGroup_SetParentWindow(c._instance(), value)
}

func (c *TCheckGroup) Showing() bool {
    return CheckGroup_GetShowing(c._instance())
}

// UseDockManager
//
// 获取使用停靠管理。
func (c *TCheckGroup) UseDockManager() bool {
    return CheckGroup_GetUseDockManager(c._instance())
}

// SetUseDockManager
//
// 设置使用停靠管理。
func (c *TCheckGroup) SetUseDockManager(value bool) {
    CheckGroup_SetUseDockManager(c._instance(), value)
}

func (c *TCheckGroup) Action() *TAction {
    return AsAction(CheckGroup_GetAction(c._instance()))
}

func (c *TCheckGroup) SetAction(value IComponent) {
    CheckGroup_SetAction(c._instance(), CheckPtr(value))
}

func (c *TCheckGroup) BoundsRect() TRect {
    return CheckGroup_GetBoundsRect(c._instance())
}

func (c *TCheckGroup) SetBoundsRect(value TRect) {
    CheckGroup_SetBoundsRect(c._instance(), value)
}

func (c *TCheckGroup) ClientOrigin() TPoint {
    return CheckGroup_GetClientOrigin(c._instance())
}

// ClientRect
//
// 获取客户区矩形。
//
// Get client rectangle.
func (c *TCheckGroup) ClientRect() TRect {
    return CheckGroup_GetClientRect(c._instance())
}

// ControlState
//
// 获取控件状态。
//
// Get control state.
func (c *TCheckGroup) ControlState() TControlState {
    return CheckGroup_GetControlState(c._instance())
}

// SetControlState
//
// 设置控件状态。
//
// Set control state.
func (c *TCheckGroup) SetControlState(value TControlState) {
    CheckGroup_SetControlState(c._instance(), value)
}

// ControlStyle
//
// 获取控件样式。
//
// Get control style.
func (c *TCheckGroup) ControlStyle() TControlStyle {
    return CheckGroup_GetControlStyle(c._instance())
}

// SetControlStyle
//
// 设置控件样式。
//
// Set control style.
func (c *TCheckGroup) SetControlStyle(value TControlStyle) {
    CheckGroup_SetControlStyle(c._instance(), value)
}

func (c *TCheckGroup) Floating() bool {
    return CheckGroup_GetFloating(c._instance())
}

// Parent
//
// 获取控件父容器。
//
// Get control parent container.
func (c *TCheckGroup) Parent() *TWinControl {
    return AsWinControl(CheckGroup_GetParent(c._instance()))
}

// SetParent
//
// 设置控件父容器。
//
// Set control parent container.
func (c *TCheckGroup) SetParent(value IWinControl) {
    CheckGroup_SetParent(c._instance(), CheckPtr(value))
}

// Left
//
// 获取左边位置。
//
// Get Left position.
func (c *TCheckGroup) Left() int32 {
    return CheckGroup_GetLeft(c._instance())
}

// SetLeft
//
// 设置左边位置。
//
// Set Left position.
func (c *TCheckGroup) SetLeft(value int32) {
    CheckGroup_SetLeft(c._instance(), value)
}

// Top
//
// 获取顶边位置。
//
// Get Top position.
func (c *TCheckGroup) Top() int32 {
    return CheckGroup_GetTop(c._instance())
}

// SetTop
//
// 设置顶边位置。
//
// Set Top position.
func (c *TCheckGroup) SetTop(value int32) {
    CheckGroup_SetTop(c._instance(), value)
}

// Width
//
// 获取宽度。
//
// Get width.
func (c *TCheckGroup) Width() int32 {
    return CheckGroup_GetWidth(c._instance())
}

// SetWidth
//
// 设置宽度。
//
// Set width.
func (c *TCheckGroup) SetWidth(value int32) {
    CheckGroup_SetWidth(c._instance(), value)
}

// Height
//
// 获取高度。
//
// Get height.
func (c *TCheckGroup) Height() int32 {
    return CheckGroup_GetHeight(c._instance())
}

// SetHeight
//
// 设置高度。
//
// Set height.
func (c *TCheckGroup) SetHeight(value int32) {
    CheckGroup_SetHeight(c._instance(), value)
}

// Cursor
//
// 获取控件光标。
//
// Get control cursor.
func (c *TCheckGroup) Cursor() TCursor {
    return CheckGroup_GetCursor(c._instance())
}

// SetCursor
//
// 设置控件光标。
//
// Set control cursor.
func (c *TCheckGroup) SetCursor(value TCursor) {
    CheckGroup_SetCursor(c._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (c *TCheckGroup) Hint() string {
    return CheckGroup_GetHint(c._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (c *TCheckGroup) SetHint(value string) {
    CheckGroup_SetHint(c._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (c *TCheckGroup) ComponentCount() int32 {
    return CheckGroup_GetComponentCount(c._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (c *TCheckGroup) ComponentIndex() int32 {
    return CheckGroup_GetComponentIndex(c._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (c *TCheckGroup) SetComponentIndex(value int32) {
    CheckGroup_SetComponentIndex(c._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (c *TCheckGroup) Owner() *TComponent {
    return AsComponent(CheckGroup_GetOwner(c._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (c *TCheckGroup) Name() string {
    return CheckGroup_GetName(c._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (c *TCheckGroup) SetName(value string) {
    CheckGroup_SetName(c._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (c *TCheckGroup) Tag() int {
    return CheckGroup_GetTag(c._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (c *TCheckGroup) SetTag(value int) {
    CheckGroup_SetTag(c._instance(), value)
}

// AnchorSideLeft
//
// 获取左边锚点。
func (c *TCheckGroup) AnchorSideLeft() *TAnchorSide {
    return AsAnchorSide(CheckGroup_GetAnchorSideLeft(c._instance()))
}

// SetAnchorSideLeft
//
// 设置左边锚点。
func (c *TCheckGroup) SetAnchorSideLeft(value *TAnchorSide) {
    CheckGroup_SetAnchorSideLeft(c._instance(), CheckPtr(value))
}

// AnchorSideTop
//
// 获取顶边锚点。
func (c *TCheckGroup) AnchorSideTop() *TAnchorSide {
    return AsAnchorSide(CheckGroup_GetAnchorSideTop(c._instance()))
}

// SetAnchorSideTop
//
// 设置顶边锚点。
func (c *TCheckGroup) SetAnchorSideTop(value *TAnchorSide) {
    CheckGroup_SetAnchorSideTop(c._instance(), CheckPtr(value))
}

// AnchorSideRight
//
// 获取右边锚点。
func (c *TCheckGroup) AnchorSideRight() *TAnchorSide {
    return AsAnchorSide(CheckGroup_GetAnchorSideRight(c._instance()))
}

// SetAnchorSideRight
//
// 设置右边锚点。
func (c *TCheckGroup) SetAnchorSideRight(value *TAnchorSide) {
    CheckGroup_SetAnchorSideRight(c._instance(), CheckPtr(value))
}

// AnchorSideBottom
//
// 获取底边锚点。
func (c *TCheckGroup) AnchorSideBottom() *TAnchorSide {
    return AsAnchorSide(CheckGroup_GetAnchorSideBottom(c._instance()))
}

// SetAnchorSideBottom
//
// 设置底边锚点。
func (c *TCheckGroup) SetAnchorSideBottom(value *TAnchorSide) {
    CheckGroup_SetAnchorSideBottom(c._instance(), CheckPtr(value))
}

func (c *TCheckGroup) ChildSizing() *TControlChildSizing {
    return AsControlChildSizing(CheckGroup_GetChildSizing(c._instance()))
}

func (c *TCheckGroup) SetChildSizing(value *TControlChildSizing) {
    CheckGroup_SetChildSizing(c._instance(), CheckPtr(value))
}

// BorderSpacing
//
// 获取边框间距。
func (c *TCheckGroup) BorderSpacing() *TControlBorderSpacing {
    return AsControlBorderSpacing(CheckGroup_GetBorderSpacing(c._instance()))
}

// SetBorderSpacing
//
// 设置边框间距。
func (c *TCheckGroup) SetBorderSpacing(value *TControlBorderSpacing) {
    CheckGroup_SetBorderSpacing(c._instance(), CheckPtr(value))
}

// Checked
//
// 获取是否选中。
func (c *TCheckGroup) Checked(Index int32) bool {
    return CheckGroup_GetChecked(c._instance(), Index)
}

// SetChecked
//
// 设置是否选中。
func (c *TCheckGroup) SetChecked(Index int32, value bool) {
    CheckGroup_SetChecked(c._instance(), Index, value)
}

func (c *TCheckGroup) CheckEnabled(Index int32) bool {
    return CheckGroup_GetCheckEnabled(c._instance(), Index)
}

func (c *TCheckGroup) SetCheckEnabled(Index int32, value bool) {
    CheckGroup_SetCheckEnabled(c._instance(), Index, value)
}

// DockClients
//
// 获取指定索引停靠客户端。
func (c *TCheckGroup) DockClients(Index int32) *TControl {
    return AsControl(CheckGroup_GetDockClients(c._instance(), Index))
}

// Controls
//
// 获取指定索引子控件。
func (c *TCheckGroup) Controls(Index int32) *TControl {
    return AsControl(CheckGroup_GetControls(c._instance(), Index))
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (c *TCheckGroup) Components(AIndex int32) *TComponent {
    return AsComponent(CheckGroup_GetComponents(c._instance(), AIndex))
}

// AnchorSide
//
// 获取锚侧面。
func (c *TCheckGroup) AnchorSide(AKind TAnchorKind) *TAnchorSide {
    return AsAnchorSide(CheckGroup_GetAnchorSide(c._instance(), AKind))
}

