
//----------------------------------------
// The code is automatically generated by the GenlibLcl tool.
// Copyright © ying32. All Rights Reserved.
// 
// Licensed under Apache License 2.0
//
//----------------------------------------


package vcl


import (
    . "github.com/ying32/govcl/vcl/api"
    . "github.com/ying32/govcl/vcl/types"
    "unsafe"
)

type TAction struct {
    IComponent
    instance unsafe.Pointer
}

// NewAction
//
// 创建一个新的对象。
// 
// Create a new object.
func NewAction(owner IComponent) *TAction {
    a := new(TAction)
    a.instance = unsafe.Pointer(Action_Create(CheckPtr(owner)))
    return a
}

// AsAction
//
// 动态转换一个已存在的对象实例。
// 
// Dynamically convert an existing object instance.
func AsAction(obj interface{}) *TAction {
    instance := getInstance(obj)
    if instance == nullptr { return nil }
    return &TAction{instance: instance}
}

// Free 
//
// 释放对象。
// 
// Free object.
func (a *TAction) Free() {
    if a.instance != nullptr {
        Action_Free(a._instance())
        a.instance  = nullptr
    }
}

func (a *TAction) _instance() uintptr {
    return uintptr(a.instance)
}

// Instance 
//
// 返回对象实例指针。
// 
// Return object instance pointer.
func (a *TAction) Instance() uintptr {
    return a._instance()
}

// UnsafeAddr 
//
// 获取一个不安全的地址。
// 
// Get an unsafe address.
func (a *TAction) UnsafeAddr() unsafe.Pointer {
    return a.instance
}

// IsValid 
//
// 检测地址是否为空。
// 
// Check if the address is empty.
func (a *TAction) IsValid() bool {
    return a.instance != nullptr
}

// Is 
// 
// 检测当前对象是否继承自目标对象。
// 
// Checks whether the current object is inherited from the target object.
func (a *TAction) Is() TIs {
    return TIs(a._instance())
}

// As 
//
// 动态转换当前对象为目标对象。
// 
// Dynamically convert the current object to the target object.
//func (a *TAction) As() TAs {
//    return TAs(a._instance())
//}

// TActionClass
//
// 获取类信息指针。
// 
// Get class information pointer.
func TActionClass() TClass {
    return Action_StaticClassType()
}

// Execute
//
// 执行。
func (a *TAction) Execute() bool {
    return Action_Execute(a._instance())
}

// Update
//
// 控件更新。
//
// Update.
func (a *TAction) Update() bool {
    return Action_Update(a._instance())
}

// HasParent
//
// 是否有父容器。
//
// Is there a parent container.
func (a *TAction) HasParent() bool {
    return Action_HasParent(a._instance())
}

// FindComponent
//
// 查找指定名称的组件。
//
// Find the component with the specified name.
func (a *TAction) FindComponent(AName string) *TComponent {
    return AsComponent(Action_FindComponent(a._instance(), AName))
}

// GetNamePath
//
// 获取类名路径。
//
// Get the class name path.
func (a *TAction) GetNamePath() string {
    return Action_GetNamePath(a._instance())
}

// Assign
//
// 复制一个对象，如果对象实现了此方法的话。
//
// Copy an object, if the object implements this method.
func (a *TAction) Assign(Source IObject) {
    Action_Assign(a._instance(), CheckPtr(Source))
}

// ClassType
//
// 获取类的类型信息。
//
// Get class type information.
func (a *TAction) ClassType() TClass {
    return Action_ClassType(a._instance())
}

// ClassName
//
// 获取当前对象类名称。
//
// Get the current object class name.
func (a *TAction) ClassName() string {
    return Action_ClassName(a._instance())
}

// InstanceSize
//
// 获取当前对象实例大小。
//
// Get the current object instance size.
func (a *TAction) InstanceSize() int32 {
    return Action_InstanceSize(a._instance())
}

// InheritsFrom
//
// 判断当前类是否继承自指定类。
//
// Determine whether the current class inherits from the specified class.
func (a *TAction) InheritsFrom(AClass TClass) bool {
    return Action_InheritsFrom(a._instance(), AClass)
}

// Equals
//
// 与一个对象进行比较。
//
// Compare with an object.
func (a *TAction) Equals(Obj IObject) bool {
    return Action_Equals(a._instance(), CheckPtr(Obj))
}

// GetHashCode
//
// 获取类的哈希值。
//
// Get the hash value of the class.
func (a *TAction) GetHashCode() int32 {
    return Action_GetHashCode(a._instance())
}

// ToString
//
// 文本类信息。
//
// Text information.
func (a *TAction) ToString() string {
    return Action_ToString(a._instance())
}

func (a *TAction) AutoCheck() bool {
    return Action_GetAutoCheck(a._instance())
}

func (a *TAction) SetAutoCheck(value bool) {
    Action_SetAutoCheck(a._instance(), value)
}

// Caption
//
// 获取控件标题。
//
// Get the control title.
func (a *TAction) Caption() string {
    return Action_GetCaption(a._instance())
}

// SetCaption
//
// 设置控件标题。
//
// Set the control title.
func (a *TAction) SetCaption(value string) {
    Action_SetCaption(a._instance(), value)
}

// Checked
//
// 获取是否选中。
func (a *TAction) Checked() bool {
    return Action_GetChecked(a._instance())
}

// SetChecked
//
// 设置是否选中。
func (a *TAction) SetChecked(value bool) {
    Action_SetChecked(a._instance(), value)
}

// Enabled
//
// 获取控件启用。
//
// Get the control enabled.
func (a *TAction) Enabled() bool {
    return Action_GetEnabled(a._instance())
}

// SetEnabled
//
// 设置控件启用。
//
// Set the control enabled.
func (a *TAction) SetEnabled(value bool) {
    Action_SetEnabled(a._instance(), value)
}

// GroupIndex
//
// 获取团组索引。
func (a *TAction) GroupIndex() int32 {
    return Action_GetGroupIndex(a._instance())
}

// SetGroupIndex
//
// 设置团组索引。
func (a *TAction) SetGroupIndex(value int32) {
    Action_SetGroupIndex(a._instance(), value)
}

// Hint
//
// 获取组件鼠标悬停提示。
//
// Get component mouse hints.
func (a *TAction) Hint() string {
    return Action_GetHint(a._instance())
}

// SetHint
//
// 设置组件鼠标悬停提示。
//
// Set component mouse hints.
func (a *TAction) SetHint(value string) {
    Action_SetHint(a._instance(), value)
}

// ImageIndex
//
// 获取图像在images中的索引。
func (a *TAction) ImageIndex() int32 {
    return Action_GetImageIndex(a._instance())
}

// SetImageIndex
//
// 设置图像在images中的索引。
func (a *TAction) SetImageIndex(value int32) {
    Action_SetImageIndex(a._instance(), value)
}

// ShortCut
//
// 获取快捷键。
func (a *TAction) ShortCut() TShortCut {
    return Action_GetShortCut(a._instance())
}

// SetShortCut
//
// 设置快捷键。
func (a *TAction) SetShortCut(value TShortCut) {
    Action_SetShortCut(a._instance(), value)
}

// Visible
//
// 获取控件可视。
//
// Get the control visible.
func (a *TAction) Visible() bool {
    return Action_GetVisible(a._instance())
}

// SetVisible
//
// 设置控件可视。
//
// Set the control visible.
func (a *TAction) SetVisible(value bool) {
    Action_SetVisible(a._instance(), value)
}

// SetOnExecute
//
// 设置动作执行事件。
func (a *TAction) SetOnExecute(fn TNotifyEvent) {
    Action_SetOnExecute(a._instance(), fn)
}

// SetOnUpdate
//
// 设置动作更新事件。
func (a *TAction) SetOnUpdate(fn TNotifyEvent) {
    Action_SetOnUpdate(a._instance(), fn)
}

func (a *TAction) Index() int32 {
    return Action_GetIndex(a._instance())
}

func (a *TAction) SetIndex(value int32) {
    Action_SetIndex(a._instance(), value)
}

// ComponentCount
//
// 获取组件总数。
//
// Get the total number of components.
func (a *TAction) ComponentCount() int32 {
    return Action_GetComponentCount(a._instance())
}

// ComponentIndex
//
// 获取组件索引。
//
// Get component index.
func (a *TAction) ComponentIndex() int32 {
    return Action_GetComponentIndex(a._instance())
}

// SetComponentIndex
//
// 设置组件索引。
//
// Set component index.
func (a *TAction) SetComponentIndex(value int32) {
    Action_SetComponentIndex(a._instance(), value)
}

// Owner
//
// 获取组件所有者。
//
// Get component owner.
func (a *TAction) Owner() *TComponent {
    return AsComponent(Action_GetOwner(a._instance()))
}

// Name
//
// 获取组件名称。
//
// Get the component name.
func (a *TAction) Name() string {
    return Action_GetName(a._instance())
}

// SetName
//
// 设置组件名称。
//
// Set the component name.
func (a *TAction) SetName(value string) {
    Action_SetName(a._instance(), value)
}

// Tag
//
// 获取对象标记。
//
// Get the control tag.
func (a *TAction) Tag() int {
    return Action_GetTag(a._instance())
}

// SetTag
//
// 设置对象标记。
//
// Set the control tag.
func (a *TAction) SetTag(value int) {
    Action_SetTag(a._instance(), value)
}

// Components
//
// 获取指定索引组件。
//
// Get the specified index component.
func (a *TAction) Components(AIndex int32) *TComponent {
    return AsComponent(Action_GetComponents(a._instance(), AIndex))
}

