---
title: knitr showcase
subtitle: Examples from other users
date: '2013-03-11'
slug: showcase
---

Below are links related to **knitr** in other websites and applications (if you have more, or you do not like your links to be listed here, please feel free to let me know).

## Websites

- [RPubs](http://rpubs.com/): Easy web publishing from R
- [knitr in a knutshell](http://kbroman.github.io/knitr_knutshell), a short tutorial by Karl Broman
- [R learning resources](http://www.ats.ucla.edu/stat/r/) at UCLA by Joshua Wiley et al (dynamically built with **knitr**)
- [knitr on ShareLaTeX](http://www.sharelatex.com/learn/Knitr) (an online LaTeX editor)
- [Rcpp Gallery](http://gallery.rcpp.org/): Articles and code examples for the **Rcpp** package
- [Slidify](http://slidify.org/): reproducible HTML5 slides made easy
- [One Page R](http://onepager.togaware.com/) Literate Data Science by Graham Williams
- [Reproducible graphics with R and ggplot2](http://www.scribd.com/doc/93360631/Presentation) by Baptiste Auguié
- [ML/stats notes](https://github.com/johnmyleswhite/MLNotes) by John Myles White
- [A French introduction to R](http://alea.fr.eu.org/pages/intro-R) by Julien Barnier (also see [CRAN](http://cran.r-project.org/other-docs.html))
- Applications of R in Business Contest ([knitr's entry](http://www.inside-r.org/howto/knitr-elegant-flexible-and-fast-dynamic-report-generation-r); [announcement](http://www.revolutionanalytics.com/news-events/news-room/2012/applications-of-r-in-business-competition.php))

## Book Reviews

Below is a list of the book reviews on [Dynamic Documents with R and knitr](http://amzn.com/1498716962).

- A [book review](http://www.jstatsoft.org/v56/b02/) in the _Journal of Statistical Software_ by Amelia McNamara
- A [book review](http://www.maa.org/press/maa-reviews/dynamic-documents-with-r-and-knitr-0) in _MAA Reviews_ by Peter Rabinovitch
- A [book review](http://www.tug.org/books/reviews/tb109reviews-xie.html) on [TUGboat](http://www.tug.org/books/#xie-knitr) by Boris Veytsman
- [A book review](http://rpubs.com/safeisrisky/knitr_booksummary) on RPubs by RK
- [A book review](http://dx.doi.org/10.1080/00031305.2015.1014676) in _The American Statistician_ by Quan Zhang

## Solutions

- [a knitr Howto page](http://biostat.mc.vanderbilt.edu/wiki/Main/KnitrHowto) in Vanderbilt Biostatistics Wiki
- [Plain Text, Papers, Pandoc](http://kieranhealy.org/blog/archives/2014/01/23/plain-text/) by Kieran Healy
- [R Markdown output formats for Tufte-style handouts](https://github.com/sachsmc/tufterhandout) by Michael Sachs
- [Blogging with Rmarkdown, knitr, and Jekyll](http://brendanrocks.com/blogging-with-rmarkdown-knitr-jekyll/) by Brendan Rocks
- [Blog with Knitr and Jekyll](http://jfisher-usgs.github.com/r/2012/07/03/knitr-jekyll/) by Jason C Fisher
- [Creating HTML5 slides with RStudio, knitr and pandoc](http://gastonsanchez.wordpress.com/2012/11/19/creating-html5-slides-with-rstudio-knitr-and-pandoc/) by Gaston Sanchez
- [A framework to create bootstrap styled HTML reports from knitr Rmarkdown](https://github.com/jimhester/knitrBootstrap) by Jim Hester (a [preview](http://htmlpreview.github.io/?https://raw.github.com/jimhester/knitrBootstrap/master/inst/examples/all.html))
- [Creating a Business Dashboard in R](http://fishyoperations.com/creating-a-business-dashboards-in-r.html) by Bart Smeets
- Carl Boettiger has cool blog posts demonstrating how to publish a post to Wordpress.com with knitr and RWordPress purely in R, with images uploaded to [Imgur](http://www.carlboettiger.info/archives/3974) and [Flickr](http://www.carlboettiger.info/archives/3988) respectively
- [knitr + cactus + TwitterBootstrap + Jquery](http://geospaced.blogspot.com/2012/05/knitr-cactus-twitterbootstrap-jquery.html) by Barry Rowlingson (includes a smart use of jQuery to add links to R functions)
- [Interactive reports in R with knitr and RStudio ](http://lamages.blogspot.co.uk/2012/05/interactive-reports-in-r-with-knitr-and.html) and [Interactive HTML presentation with R, googleVis, knitr, pandoc and slidy ](http://lamages.blogspot.com/2012/05/interactive-html-presentation-with-r.html) by Markus Gesmann
- [Stacked bar plots with several descriptive nodes](http://tex.stackexchange.com/a/87897/9128) by ADP
- [Blogging from R to Wordpress](http://wkmor1.wordpress.com/2012/07/01/rchievement-of-the-day-3-bloggin-from-r-14/) by William K. Morris
- A demo on using `tidy=TRUE` or the listings environment so code chunks can stay inside page margins ([link to StackExchange](http://tex.stackexchange.com/q/41471/9128))
- [How to Use Knitr with a Rakefile](http://lincolnmullen.com/blog/how-to-use-knitr-with-a-rakefile/) by Lincoln A. Mullen
- [Reproducible Research with Word?](http://ericpgreen.com/reproducible-research-with-word/) by Eric P. Green
- [knitr, slidify, and Popcorn.js](http://ramnathv.github.io/slidifyExamples/examples/popcornjs) by Ramnath Vaidyanathan ([#466](https://github.com/yihui/knitr/issues/466))
- [Transparent, reproducible blogging with nanoc and knitr](http://chogg.name/blog/2015/03/19/nanoc_knitr/) by Charles Hogg
- [Using knitr and R to make instructor/student handout versions](http://lukemiller.org/index.php/2015/11/using-knitr-and-r-to-make-instructorstudent-handout-versions/) by Luke Miller
- [Thesis template to generate LaTeX files using R with knitr](https://github.com/asardaes/R-LaTeX-Template) by Alexis Sarda

## R Packages

- [The GitHub Wiki of the cda package](https://github.com/baptiste/cda/wiki) by Baptiste Auguie
- [website of ggbio package](http://tengfei.github.com/ggbio/) by Tengfei Yin
- [The sampSurf Package](http://sampsurf.r-forge.r-project.org/) by Jeffrey H. Gove
- [the RHadoop Wiki](https://github.com/RevolutionAnalytics/RHadoop/wiki) by Revolution Analytics
- [The ggmcmc package examples](http://xavier-fim.net/packages/ggmcmc/) by Xavier Fernández-i-Marín
- [tabplot: Tableplot, a visualization of large datasets](http://cran.r-project.org/package=tabplot) by Martijn Tennekes and Edwin de Jonge (see its PDF vignette)
- the [ggplot2 transition guide](https://github.com/djmurphy420/ggplot2-transition-guide) to version 0.9.0 by Dennis Murphy et al
- a few packages on Bioconductor: [ReportingTools](http://www.bioconductor.org/packages/2.12/bioc/vignettes/ReportingTools/inst/doc/knitr.html) and [RGalaxy](http://www.bioconductor.org/packages/2.12/bioc/html/RGalaxy.html)
- [the dendextend package](https://github.com/talgalili/dendextend) by Tal Galili
- [An Introduction to CHNOSZ](http://chnosz.net/vignettes/anintro.html) vignette by Jeffrey M. Dick using Tufte style

## Courses

Below is a lecture on **knitr** kindly shared by Roger Peng for the Coursera
course [_Computing for Data Analysis_](https://www.coursera.org/course/compdata):

<iframe width="100%" height="450" src="//www.youtube.com/embed/YcJb1HBc-1Q" frameborder="0" allowfullscreen></iframe>

And below are some other courses related to **knitr**:

- [BMI 826-003](http://kbroman.github.io/Tools4RR/) (Tools for Reproducible Research) by Karl Broman, University of Wisconsin-Madison
- [Reproducible Research](https://www.coursera.org/course/repdata) by Roger Peng, Coursera
- [Introduction to data science](http://www.unomaha.edu/mahbubulmajumder/data-science/fall-2014/) by Mahbubul Majumder, University of Nebraska at Omaha
- [BIOS 301](http://fonnesbeck.github.com/Bios301/) (Introduction to Statistical Computing) by Chris Fonnesbeck, Vanderbilt University
- [Math 344](http://www.calvin.edu/~rpruim/courses/m344/S12/) (Probability and Statistics) by Randall Pruim, Calvin College
- [Stat 506](http://www.math.montana.edu/~jimrc/classes/stat506/) (Advanced Regression) by Jim Robison-Cox, Montana State University
- [STT 3820](http://www1.appstate.edu/~arnholta/classes/STT3820/index.htm) by Alan T. Arnholt, Appalachian State University
- [Math 747](http://www.math.mcmaster.ca/~bolker/classes/m747/) (Topics in math biology) by Ben Bolker, McMaster University
- [STAT 319](http://www.personal.psu.edu/yoh5109/319spring2013/) (Applied Statistics in Science) by Yuan Huang, Penn State University (also see the tutorial [Create Dynamic R Statistical Reports Using R Markdown](https://onlinecourses.science.psu.edu/statprogram/markdown))
- [some notes](http://bcb.dfci.harvard.edu/~aedin/courses/ReproducibleResearch/) on reproducible research by Aedin Culhane, Harvard University
- [STAT 622](http://www.stat.rice.edu/~marina/stat622.html) (Bayesian Data Analysis) by Marina Vannucci, Rice University
- [STA613/CBB540](http://genome.duke.edu/labs/engelhardt/courses/cbb540.html) (Statistical methods in computational biology) by Barbara Engelhardt, Duke University
- [Stat 590](http://statacumen.com/teaching/sc1/) (Statistical Computing) by Erik Erhardt, University of New Mexico
- [STAT 497C](https://onlinecourses.science.psu.edu/stat497r/node/101) (Topics in R Statistical Language) by Eric Nord, Penn State University
- [CSSS-Stat 567](http://www.stat.washington.edu/~hoff/courses/567/) (Statistical Analysis of Social Networks) by Peter Hoff, University of Washington
- [Math 15](http://msemac.redwoods.edu/~darnold/math15/) (Statistics) by David Arnold, College of the Redwoods
- [STAT 545A](http://www.stat.ubc.ca/~jenny/STAT545A/) Exploratory Data Analysis by Jennifer Bryan, University of British Columbia
- [STAT545](http://www.stat.purdue.edu/~varao/STAT545/main.html) Introduction to Computational Statistics, by Vinayak Rao, Purdue University
- [Sta 101](https://stat.duke.edu/courses/Fall14/sta101.001/) Data Analysis and Statistical Inference, by Mine Çetinkaya-Rundel, Duke University
- [GEOL 6370](http://strata.uga.edu/6370/) Data Analysis in the Geosciences, by Steven M. Holland, University of Georgia

## Workshops and Presentations

Below is a tutorial kindly made and shared by Joshua Wiley:

<iframe width="100%" height="450" src="//www.youtube.com/embed/p2VBzhLVz3o" frameborder="0" allowfullscreen></iframe>

More text versions of presentations:

- [New tools and workflows for data analysis](https://speakerdeck.com/jennybc/new-tools-and-workflows-for-data-analysis) by Jennifer Bryan ([video](http://www.fields.utoronto.ca/video-archive/2015/02/318-4374))
- [Geospatial Data in R and Beyond](http://www.maths.lancs.ac.uk/~rowlings/Teaching/UseR2012/) by Barry Rowlingson
- [Broom Spatial R Class](http://davenportspatialanalytics.squarespace.com/blog/2012/6/19/notes-from-a-recent-spatial-r-class-i-gave.html) by Frank Davenport ([PDF](https://dl.dropbox.com/u/9577903/broomspatial.pdf))
- [Visualizing Categorical Data](http://euclid.psych.yorku.ca/datavis.ca/courses/VCD/R/output/) by Michael Friendly
- [ggplot2 workshop notes](http://www.ling.upenn.edu/~joseff/avml2012/) by Josef Fruehwald for AVML 2012
- [R Introduction for UCL PhDs](http://www.homepages.ucl.ac.uk/~uctpfos/files/introPHD.html) by Florian Oswald at University College London
- [Introduction to R lectures for ECPR Winter School 2013](http://zfazekas.github.com/teaching/2013/02/17/ecpr-intro-to-R/) by Zoltán Fazekas, University of Southern Denmark
- [R for the brave](https://dl.dropbox.com/u/4149392/R_for_the_brave.pdf) by Will Pearse
- [Introduction to knitr: The R Markdown (Rmd) format](http://lcolladotor.github.com/Rmd-intro/) by L. Collado Torres for JHSPH Biostat computing club
- [Stop Clicking, Start typing](http://mwfrost.com/r_slides/r_slides.html) by Matt Frost
- [そろそろRStudioの話でもしてみようと思う](http://www.slideshare.net/wdkz/rstudio-13866958) by 和田 計也
- [Introduction to Data Analysis and Visualization using R](https://speakerdeck.com/vinayakh/introduction-to-data-analysis-and-visualization-using-r) by Vinayak Hedge
- [Creating publication quality graphics using R](http://metvurst.wordpress.com/2013/07/15/creating-publication-quality-graphics-using-r-3/) by Tim Salabim
- [Reproducible Research Using Knitr/R](https://github.com/umd-byob/byob/tree/master/presentations/2013/0903-knitr_reproducible_research) by Keith Hughitt

## Books

- [The Analysis of Data](http://theanalysisofdata.com/) by Guy Lebanon (written with R Markdown)
- [Dynamic Report Generation with R and knitr](http://www.crcpress.com/product/isbn/9781482203530) by Yihui Xie (written with LyX + the `knitr` module)
    - [Dynamic Report Generation with R and knitr, Second Edition](https://www.crcpress.com/product/isbn/9781498716963)
- [Text Analysis with R for Students of Literature](http://www.matthewjockers.net/2013/09/03/tawr/) by Matthew L. Jockers
- [Data Analysis for the Life Sciences](https://leanpub.com/dataanalysisforthelifesciences) by Rafael Irizarry and Michael Love
- [Using R for Introductory Statistics, Second Edition](http://www.crcpress.com/product/isbn/9781466590731) by John Verzani
- [Learning R: A Step-by-Step Function Guide to Data Analysis](http://shop.oreilly.com/product/0636920028352.do) by Richard Cotton (written with AsciiDoc + `knitr`)
- [Introductory Fisheries Analysis with R](http://derekogle.com/IFAR/) by Derek H. Ogle
- [The Statistical Sleuth In R](http://www.math.smith.edu/~nhorton/sleuth/) by Nicholas Horton, Kate Aloisio, and Ruobing Zhang (`knitr` + LaTeX)
- [Regression Modeling Strategies](https://groups.google.com/forum/?hl=en&fromgroups#!topic/knitr/bYj3Zn11hjE) (`knitr` + LaTeX)
- [Latent Variable Modeling using R: A Step-By-Step Guide](http://blogs.baylor.edu/rlatentvariable/)
- [Biolostatistical Design and Analysis using R](http://yihui.org/en/guestbook/#comment-456270476)
- [Statistics for Experimental Economists: Elegant Analysis with R](http://www.experimentalecon.com/papers/estats.pdf) by Mark A. Olson
- [R과 Knitr를 활용한 데이터 연동형 문서 만들기](http://ksbapp.com/)
- [El arte de programar en R: un lenguaje para la estadística](http://www.imta.gob.mx/biblioteca/libros_html/el-arte-de-programar-en-r/) by Julio Sergio Santana and Efraín Mateos Farfán
- [PH525x series - Biomedical Data Science](http://genomicsclass.github.io/book/) by Rafael Irizarry and Michael Love
- [Data Science for Fundraising: Build Data-Driven Solutions Using R](http://a.co/0axoWr6) by Ashutosh Nandeshwar and Rodger Devine

## Papers and reports

- [Cut the tyranny of copy-and-paste with these coding tools](https://www.nature.com/articles/d41586-022-00563-z) by Jeffrey M. Perkel, _Nature_ 603, 191-192 (2022)
- [Our path to better science in less time using open data science tools](https://www.nature.com/articles/s41559-017-0160) by Julia S. Stewart Lowndes _et al_, Nature Ecology & Evolution **1**, Article number: 0160 (2017)
- Eglen, SJ; Weeks, M; Jessop, M; Simonotto, J; Jackson, T; Sernagor, E. A data repository and analysis framework for spontaneous neural activity recordings in developing retina. GigaScience 2014, 3:3 <http://dx.doi.org/10.1186/2047-217X-3-3>
    - plus [an interview](http://blogs.biomedcentral.com/gigablog/2014/03/26/carmen-reproducible-research-and-push-button-papers/) to the first author
    - [Q&A on dynamic documents](http://blogs.biomedcentral.com/gigablog/2014/04/16/qa-on-dynamic-documents/)
- [Programming tools: Adventures with R](http://www.nature.com/news/programming-tools-adventures-with-r-1.16609) by Sylvia Tippmann, _Nature_ **517**, 109–110 (01 January 2015) doi:10.1038/517109a
- [Rebooting review](http://dx.doi.org/10.1038/nbt.3202), _Nature Biotechnology_ **33**, 319 (2015)
- [Rule rewrite aims to clean up scientific software](http://dx.doi.org/10.1038/520276a), _Nature_ **520**, 276–277 (2015)
- [A Guide to Reproducible Code](http://www.britishecologicalsociety.org/publications/guides-to/) (Guides to Better Science), by the British Ecological Society
- [2017 Employer Health Benefits Survey](http://www.kff.org/health-costs/report/2017-employer-health-benefits-survey/) by Kaiser Family Foundation (2017)
    - Referenced by the New York Times article "[While Premiums Soar Under Obamacare, Costs of Employer-Based Plans Are Stable](https://www.nytimes.com/2017/09/19/health/health-insurance-premiums-employer.html)"
- [Irregularities in LaCour (2014)](http://stanford.edu/~dbroock/broockman_kalla_aronow_lg_irregularities.pdf) by David Broockman, Joshua Kalla, and Peter Aronow, a rebuttal paper with retraction letter from Donald P. Green
    - LaCour, Michael J. & Donald P. Green. 2014. "When contact changes minds: An experiment on transmission of support for gay equality[2]." Science 346(6215): 1366.
- [Granger-causality analysis of integrated-model outputs, a tool to assess external drivers in fishery](https://twitter.com/Margarita_RH/status/1090590323406000129) by Margarita Rincón, Rachele Corti, Bjarki Elvarsson, Fernando Ramos, and Javier Ruiz.
- [Harry Alastair V.](https://twitter.com/alharry/status/1088323057230405633), Butcher Paul A., Macbeth William G., Morgan Jess A. T., Taylor Stephen M., Geraghty Pascal T. (2019) Life history of the common blacktip shark, Carcharhinus limbatus, from central eastern Australia and comparative demography of a cryptic shark complex. Marine and Freshwater Research. https://doi.org/10.1071/MF18141
- Piwowar HA, Vision TJ. (2013) Data reuse and the open data citation advantage. PeerJ 1:e175 <http://dx.doi.org/10.7717/peerj.175>
- [Some great short courses](http://www3.nd.edu/~mclark19/projects.html) on R, generalized additive models, and machine learning, etc, by Michael Clark, Center for Social Research, Notre Dame
- [An Introduction to Mediation Analysis](https://github.com/JWiley/mediation) by Joshua F. Wiley
- ORANGE REPORT: [Annual Report of the Swedish Pension System](http://secure.pensionsmyndigheten.se/download/18.76cf683d13f231c03cd1bc/Orange+Report+2012.pdf) by the Swedish Pensions Agency
- [2011 Census Open Atlas Project](http://www.alex-singleton.com/2011-census-open-atlas-project/) by Alex Singleton
- [openWAR](http://arxiv.org/abs/1312.7158): An Open Source System for Evaluating Overall Player Performance in Major League Baseball
- [Design and Analysis of Bar-seq Experiments](http://www.g3journal.org/content/early/2013/10/30/g3.113.008565/suppl/DC1) by Robinson et al., 2014
- [Data and program code for meta-analyses of population health and health services research questions](https://github.com/timchurches/meta-analyses) by Tim Churches
- [Genomic analysis using R and knitr](https://github.com/EBI-predocs/knitr-example) by Konrad Rudolph
- [Assessing the 2016 Budget reforms](https://github.com/grattaninstitute/Assessing-2016-Super-tax-reforms) by John Daley and Brendan Coates
- [CFPB Data Point: Becoming Credit Visible](https://s3.amazonaws.com/files.consumerfinance.gov/f/documents/BecomingCreditVisible_Data_Point_Final.pdf) by the CFPB Office of Research
- [A parametric texture model based on deep convolutional features closely matches texture appearance for humans](https://github.com/tomwallis/cnn_texture_appearance) by Wallis et al.
- [Revisiting the effect of red on competition in humans (supplementary information)](http://www.biorxiv.org/content/biorxiv/suppl/2016/11/21/086710.DC1/086710-1.pdf) by Laura Fortunato and Aaron Clauset
- [Epiviz Web Components: reusable and extensible component library to visualize functional genomic datasets](https://f1000research.com/articles/7-1096/v1) by Jayaram Kancherla, Alexander Zhang, Brian Gottfried, and Hector Corrada Bravo

## Wrappers in other languages

- [knitr-ruby](https://github.com/ropensci/knitr-ruby): a Ruby wrapper
- [Flask-FlatPages-Knitr](https://github.com/fhirschmann/Flask-FlatPages-Knitr): Knitr preprocessing for Flask-FlatPages

## Blog posts

- [Using knitr and pandoc to create reproducible scientific reports](http://galahad.well.ox.ac.uk/repro/) by Peter Humburg
- [Reproducible research, training wheels, and knitr](http://civilstat.com/?p=1521) by Jerzy Wieczorek
- [Don't R alone!](http://www.noamross.net/blog/2013/1/7/collaborating-with-r.html) A guide to tools for collaboration with R by Noam Ross
- [Getting Started with R Markdown, knitr, and Rstudio 0.96](http://jeromyanglim.blogspot.com.au/2012/05/getting-started-with-r-markdown-knitr.html), [How to Convert Sweave LaTeX to knitr R Markdown](http://jeromyanglim.blogspot.com/2012/06/how-to-convert-sweave-latex-to-knitr-r.html) and [Converting Sweave LaTeX to knitr LaTeX: A case study](http://jeromyanglim.blogspot.com/2012/06/converting-sweave-latex-to-knitr-latex.html) by Jeromy Anglim
- [Tools for making a paper](http://conjugateprior.org/2013/03/tools-for-making-a-paper/) by Will Lowe
- [Integrate data and reporting on the Web with knitr](http://blog.revolutionanalytics.com/2012/09/data-reporting-knitr.html) by me as a guest blog post on Revolution Analytics
- [knitr: A flexible R authoring tool](http://rpubs.com/JoFrhwld/UseR_Sept) (HTML5 slides) by Josef Fruehwald
- [Planting seeds of reproducibility with knitr and markdown](http://citizen-statistician.org/2012/10/08/planting-seeds-of-reproducibility-with-knitr-and-markdown/) by Mine Çetinkaya-Rundel (the Citizen-Statistician blog)
- [A closer look at "How economists get tripped up by statistics"](http://biostat.mc.vanderbilt.edu/wiki/Main/GradStudentsHelpfulExamples) by Laurie Samuels
- [Latex Allergy Cured by knitr](http://timelyportfolio.blogspot.com/2012/04/latex-allergy-cured-by-knitr.html)
- [knitr Performance Report-Attempt 1](http://timelyportfolio.blogspot.com/2012/04/knitr-performance-report-attempt-1.html)
- [Easier literate programming with R](http://aliquote.org/memos/2012/04/02/easier-literate-programming-with-r) by Christophe Lalanne
- [knitR - eine Alternative zu Sweave?](http://www.blogofolio.de/2012/05/knitr-eine-alternative-zu-sweave/) by Christian B.
- [Better R support in pygments by monkey patching SLexer](http://blog.felixriedel.com/2012/05/better-r-support-in-pygments-by-monkey-patching-slexer/) by f3lix
- [被knitr包给震撼到了](http://xccds1977.blogspot.com/2012/05/knitr.html) by [@xccds](https://twitter.com/xccds)
- [Reproducible Research](http://torsneyt.wordpress.com/2012/05/19/reproducible-research/) by Tom Torsney-Weir (on Vim and Marked)
- [为什么Markdown+R有较大概率成为科技写作主流？](http://www.yangzhiping.com/tech/r-markdown-knitr.html) by 阳志平
- [Governance Indicators](http://www.russellshepherd.com/d/?q=blog/governance-indicators) by Russell Shepherd
- [Petrol prices adjusted for inflation](http://mcfromnz.wordpress.com/2012/07/28/petrol-prices-adjusted-for-inflation/) by Matt Cooper
- [Creating beautiful reports from R with knitr](http://blog.revolutionanalytics.com/2012/08/creating-beautiful-reports-from-r-with-knitr.html) by David Smith
- [An R-based Research Notebook](http://www.tomtorsneyweir.com/research-notebook/) by Tom Torsney-Weir
- [knitR, Markdown, and Your Homework](http://learningdata.wordpress.com/2012/09/30/knitr-markdown-and-your-homework/) by Jarrett Byrnes
- [Color Palettes in HCL Space](http://www.trestletechnology.net/2012/10/color-palettes-in-hcl-space/) by Trestle Technology, LLC
- [Introduction to R and Biostatistics](http://fellgernon.tumblr.com/post/35587597245/introduction-to-r-and-biostatistics-2012-version) by Leonardo Collado Torres
- [Reproducible Research using R and Bioconductor](http://onertipaday.blogspot.com/2012/12/italian-bio-r-day-2012-slides-on.html) by Paolo Sonego
- [Bioinformaticians Need Lab Notebooks Too](http://reasoniamhere.com/bioinformaticians-need-lab-notebooks-too/) by Nacho Caballero
- [From OpenOffice noob to control freak: A love story with R, LaTeX and knitr](http://machine-master.blogspot.com/2013/03/from-openoffice-noob-to-control-freak.html) by Christoph Molnar
- [Including an interactive 3D rgl graphic in a html report with knitr](http://stla.overblog.com/including-an-interactive-3d-rgl-graphic-with-knitr) by Stéphane Laurent
- [Create HTML or PDF Files with R, Knitr, MiKTeX, and Pandoc](http://rprogramming.net/create-html-or-pdf-files-with-r-knitr-miktex-and-pandoc/) by Justin Meyer
- [Reproducible research with R, Knitr, Pandoc and Word](http://quantifyingmemory.blogspot.com/2013/02/reproducible-research-with-r-knitr.html) by Rolf Fredheim
- [Visualizing Farmers' Markets Geo Data using googleVis, plyr, knitr and Markdown using R](http://dataillumination.blogspot.com/2013/03/visualizing-farmers-markets-geo-data_19.html) by Peter Chen
- [2013 NSF Graduate Research Fellowship statistics](http://www.scribd.com/doc/132971631/NSFstats2013) by Elson Liu
- [Ben Bolker's notes on workflows, pipelines, reproducible research, etc.](http://stevencarlislewalker.wordpress.com/2013/07/12/ben-bolkers-notes-on-workflows-pipelines-reproducible-research-etc/) by Steve C Walker
- [Playing with R, ggplot2 and knitr](http://www.complementarytraining.blogspot.se/2013/10/playing-with-r-ggplot2-and-knitr.html) by Mladen Jovanović
- [A simple bootstrap-based knitr template](http://watson.nci.nih.gov/~sdavis/blog/a_simple_bootstrap-based_knitr_template/) by Sean Davis
- [Automated Blogging](http://blog.r-enthusiasts.com/2013/12/04/automated-blogging.html) by Romain François
- [How to avoid scandals using knitr](http://www.mango-solutions.com/wp/2014/01/how-to-avoid-scandals-using-knitr/) by Mango Solutions
- Fast-track publishing using knitr: [Part I](http://gforge.se/?p=928), [Part II](http://gforge.se/?p=960), [Part III](http://gforge.se/?p=1005) by Max Gordon
- [Basic data-frame manipulations in R](http://therostrumblog.wordpress.com/2014/01/29/basic-data-frame-manipulations-in-r/) by THE ROSTRUM
- [Reproducibility is not just for researchers](http://www.dataschool.io/reproducibility-is-not-just-for-researchers/) by Kevin Markham
- [Tools for statistical writing and reproducible research](http://theincidentaleconomist.com/wordpress/tools-for-statistical-writing-and-reproducible-research/) by Bill Gardner
- [knitr ではじめるデータ分析レポート作成 ~基礎編~](http://qiita.com/hereticreader/items/a3000cb7d5b17ad71731) by Yu ISHIKAWA
- [Starting data analysis/wrangling with R: Things I wish I'd been told](http://reganmian.net/blog/2014/10/14/starting-data-analysiswrangling-with-r-things-i-wish-id-been-told/) by Stian Håklev
- [Knitr's best hidden gem: spin](http://deanattali.com/2015/03/24/knitrs-best-hidden-gem-spin/) by Dean Attali
- [Why use KnitR for scientific publishing?](http://randomlifedata.com/2015/04/why-use-knitr-for-scientific-publishing/) by Rob Les Davidson
- [From Code to Reports with knitr & Markdown](http://www.predictiveanalyticsworld.com/patimes/from-code-to-reports-with-knitr-050915/) by Andrew Brooks
- [Top 10 data mining algorithms in plain R](http://rayli.net/blog/data/top-10-data-mining-algorithms-in-plain-r/) by Ray Li
- [Knotes on Knitr](http://www.jonzelner.net/knitr/r/reproducibility/2016/06/02/knitr/) by Jon Zelner
- [A reproducibility horror story](http://blog.revolutionanalytics.com/2016/08/a-reproducibility-horror-story.html)
- [Reproducible Analytical Pipeline](https://gdsdata.blog.gov.uk/2017/03/27/reproducible-analytical-pipeline/) by Matt Upson
- [Composing reproducible manuscripts using R Markdown](https://elifesciences.org/elife-news/composing-reproducible-manuscripts-using-r-markdown) by Chris Hartgerink, Tilburg University
